/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.apache.camel.kafkaconnector.aws2s3;

import java.util.Map;
import javax.annotation.Generated;
import org.apache.camel.kafkaconnector.CamelSinkConnectorConfig;
import org.apache.kafka.common.config.ConfigDef;

@Generated("This class has been generated by camel-kafka-connector-generator-maven-plugin, remove this annotation to prevent it from being generated.")
public class CamelAws2s3SinkConnectorConfig extends CamelSinkConnectorConfig {

    public static final String CAMEL_SINK_AWS2S3_PATH_BUCKET_NAME_OR_ARN_CONF = "camel.sink.path.bucketNameOrArn";
    public static final String CAMEL_SINK_AWS2S3_PATH_BUCKET_NAME_OR_ARN_DOC = "Bucket name or ARN";
    public static final String CAMEL_SINK_AWS2S3_PATH_BUCKET_NAME_OR_ARN_DEFAULT = null;
    public static final String CAMEL_SINK_AWS2S3_ENDPOINT_AMAZON_S3CLIENT_CONF = "camel.sink.endpoint.amazonS3Client";
    public static final String CAMEL_SINK_AWS2S3_ENDPOINT_AMAZON_S3CLIENT_DOC = "Reference to a com.amazonaws.services.s3.AmazonS3 in the registry.";
    public static final String CAMEL_SINK_AWS2S3_ENDPOINT_AMAZON_S3CLIENT_DEFAULT = null;
    public static final String CAMEL_SINK_AWS2S3_ENDPOINT_AMAZON_S3PRESIGNER_CONF = "camel.sink.endpoint.amazonS3Presigner";
    public static final String CAMEL_SINK_AWS2S3_ENDPOINT_AMAZON_S3PRESIGNER_DOC = "An S3 Presigner for Request, used mainly in createDownloadLink operation";
    public static final String CAMEL_SINK_AWS2S3_ENDPOINT_AMAZON_S3PRESIGNER_DEFAULT = null;
    public static final String CAMEL_SINK_AWS2S3_ENDPOINT_AUTO_CREATE_BUCKET_CONF = "camel.sink.endpoint.autoCreateBucket";
    public static final String CAMEL_SINK_AWS2S3_ENDPOINT_AUTO_CREATE_BUCKET_DOC = "Setting the autocreation of the S3 bucket bucketName. This will apply also in case of moveAfterRead option enabled and it will create the destinationBucket if it doesn't exist already.";
    public static final Boolean CAMEL_SINK_AWS2S3_ENDPOINT_AUTO_CREATE_BUCKET_DEFAULT = false;
    public static final String CAMEL_SINK_AWS2S3_ENDPOINT_OVERRIDE_ENDPOINT_CONF = "camel.sink.endpoint.overrideEndpoint";
    public static final String CAMEL_SINK_AWS2S3_ENDPOINT_OVERRIDE_ENDPOINT_DOC = "Set the need for overidding the endpoint. This option needs to be used in combination with uriEndpointOverride option";
    public static final Boolean CAMEL_SINK_AWS2S3_ENDPOINT_OVERRIDE_ENDPOINT_DEFAULT = false;
    public static final String CAMEL_SINK_AWS2S3_ENDPOINT_POJO_REQUEST_CONF = "camel.sink.endpoint.pojoRequest";
    public static final String CAMEL_SINK_AWS2S3_ENDPOINT_POJO_REQUEST_DOC = "If we want to use a POJO request as body or not";
    public static final Boolean CAMEL_SINK_AWS2S3_ENDPOINT_POJO_REQUEST_DEFAULT = false;
    public static final String CAMEL_SINK_AWS2S3_ENDPOINT_POLICY_CONF = "camel.sink.endpoint.policy";
    public static final String CAMEL_SINK_AWS2S3_ENDPOINT_POLICY_DOC = "The policy for this queue to set in the com.amazonaws.services.s3.AmazonS3#setBucketPolicy() method.";
    public static final String CAMEL_SINK_AWS2S3_ENDPOINT_POLICY_DEFAULT = null;
    public static final String CAMEL_SINK_AWS2S3_ENDPOINT_PROXY_HOST_CONF = "camel.sink.endpoint.proxyHost";
    public static final String CAMEL_SINK_AWS2S3_ENDPOINT_PROXY_HOST_DOC = "To define a proxy host when instantiating the SQS client";
    public static final String CAMEL_SINK_AWS2S3_ENDPOINT_PROXY_HOST_DEFAULT = null;
    public static final String CAMEL_SINK_AWS2S3_ENDPOINT_PROXY_PORT_CONF = "camel.sink.endpoint.proxyPort";
    public static final String CAMEL_SINK_AWS2S3_ENDPOINT_PROXY_PORT_DOC = "Specify a proxy port to be used inside the client definition.";
    public static final String CAMEL_SINK_AWS2S3_ENDPOINT_PROXY_PORT_DEFAULT = null;
    public static final String CAMEL_SINK_AWS2S3_ENDPOINT_PROXY_PROTOCOL_CONF = "camel.sink.endpoint.proxyProtocol";
    public static final String CAMEL_SINK_AWS2S3_ENDPOINT_PROXY_PROTOCOL_DOC = "To define a proxy protocol when instantiating the S3 client One of: [HTTP] [HTTPS]";
    public static final String CAMEL_SINK_AWS2S3_ENDPOINT_PROXY_PROTOCOL_DEFAULT = "HTTPS";
    public static final String CAMEL_SINK_AWS2S3_ENDPOINT_REGION_CONF = "camel.sink.endpoint.region";
    public static final String CAMEL_SINK_AWS2S3_ENDPOINT_REGION_DOC = "The region in which S3 client needs to work. When using this parameter, the configuration will expect the lowercase name of the region (for example ap-east-1) You'll need to use the name Region.EU_WEST_1.id()";
    public static final String CAMEL_SINK_AWS2S3_ENDPOINT_REGION_DEFAULT = null;
    public static final String CAMEL_SINK_AWS2S3_ENDPOINT_TRUST_ALL_CERTIFICATES_CONF = "camel.sink.endpoint.trustAllCertificates";
    public static final String CAMEL_SINK_AWS2S3_ENDPOINT_TRUST_ALL_CERTIFICATES_DOC = "If we want to trust all certificates in case of overriding the endpoint";
    public static final Boolean CAMEL_SINK_AWS2S3_ENDPOINT_TRUST_ALL_CERTIFICATES_DEFAULT = false;
    public static final String CAMEL_SINK_AWS2S3_ENDPOINT_URI_ENDPOINT_OVERRIDE_CONF = "camel.sink.endpoint.uriEndpointOverride";
    public static final String CAMEL_SINK_AWS2S3_ENDPOINT_URI_ENDPOINT_OVERRIDE_DOC = "Set the overriding uri endpoint. This option needs to be used in combination with overrideEndpoint option";
    public static final String CAMEL_SINK_AWS2S3_ENDPOINT_URI_ENDPOINT_OVERRIDE_DEFAULT = null;
    public static final String CAMEL_SINK_AWS2S3_ENDPOINT_USE_DEFAULT_CREDENTIALS_PROVIDER_CONF = "camel.sink.endpoint.useDefaultCredentialsProvider";
    public static final String CAMEL_SINK_AWS2S3_ENDPOINT_USE_DEFAULT_CREDENTIALS_PROVIDER_DOC = "Set whether the S3 client should expect to load credentials through a default credentials provider or to expect static credentials to be passed in.";
    public static final Boolean CAMEL_SINK_AWS2S3_ENDPOINT_USE_DEFAULT_CREDENTIALS_PROVIDER_DEFAULT = false;
    public static final String CAMEL_SINK_AWS2S3_ENDPOINT_CUSTOMER_ALGORITHM_CONF = "camel.sink.endpoint.customerAlgorithm";
    public static final String CAMEL_SINK_AWS2S3_ENDPOINT_CUSTOMER_ALGORITHM_DOC = "Define the customer algorithm to use in case CustomerKey is enabled";
    public static final String CAMEL_SINK_AWS2S3_ENDPOINT_CUSTOMER_ALGORITHM_DEFAULT = null;
    public static final String CAMEL_SINK_AWS2S3_ENDPOINT_CUSTOMER_KEY_ID_CONF = "camel.sink.endpoint.customerKeyId";
    public static final String CAMEL_SINK_AWS2S3_ENDPOINT_CUSTOMER_KEY_ID_DOC = "Define the id of Customer key to use in case CustomerKey is enabled";
    public static final String CAMEL_SINK_AWS2S3_ENDPOINT_CUSTOMER_KEY_ID_DEFAULT = null;
    public static final String CAMEL_SINK_AWS2S3_ENDPOINT_CUSTOMER_KEY_MD5CONF = "camel.sink.endpoint.customerKeyMD5";
    public static final String CAMEL_SINK_AWS2S3_ENDPOINT_CUSTOMER_KEY_MD5DOC = "Define the MD5 of Customer key to use in case CustomerKey is enabled";
    public static final String CAMEL_SINK_AWS2S3_ENDPOINT_CUSTOMER_KEY_MD5DEFAULT = null;
    public static final String CAMEL_SINK_AWS2S3_ENDPOINT_BATCH_MESSAGE_NUMBER_CONF = "camel.sink.endpoint.batchMessageNumber";
    public static final String CAMEL_SINK_AWS2S3_ENDPOINT_BATCH_MESSAGE_NUMBER_DOC = "The number of messages composing a batch in streaming upload mode";
    public static final Integer CAMEL_SINK_AWS2S3_ENDPOINT_BATCH_MESSAGE_NUMBER_DEFAULT = 10;
    public static final String CAMEL_SINK_AWS2S3_ENDPOINT_BATCH_SIZE_CONF = "camel.sink.endpoint.batchSize";
    public static final String CAMEL_SINK_AWS2S3_ENDPOINT_BATCH_SIZE_DOC = "The batch size (in bytes) in streaming upload mode";
    public static final Integer CAMEL_SINK_AWS2S3_ENDPOINT_BATCH_SIZE_DEFAULT = 1000000;
    public static final String CAMEL_SINK_AWS2S3_ENDPOINT_DELETE_AFTER_WRITE_CONF = "camel.sink.endpoint.deleteAfterWrite";
    public static final String CAMEL_SINK_AWS2S3_ENDPOINT_DELETE_AFTER_WRITE_DOC = "Delete file object after the S3 file has been uploaded";
    public static final Boolean CAMEL_SINK_AWS2S3_ENDPOINT_DELETE_AFTER_WRITE_DEFAULT = false;
    public static final String CAMEL_SINK_AWS2S3_ENDPOINT_KEY_NAME_CONF = "camel.sink.endpoint.keyName";
    public static final String CAMEL_SINK_AWS2S3_ENDPOINT_KEY_NAME_DOC = "Setting the key name for an element in the bucket through endpoint parameter";
    public static final String CAMEL_SINK_AWS2S3_ENDPOINT_KEY_NAME_DEFAULT = null;
    public static final String CAMEL_SINK_AWS2S3_ENDPOINT_LAZY_START_PRODUCER_CONF = "camel.sink.endpoint.lazyStartProducer";
    public static final String CAMEL_SINK_AWS2S3_ENDPOINT_LAZY_START_PRODUCER_DOC = "Whether the producer should be started lazy (on the first message). By starting lazy you can use this to allow CamelContext and routes to startup in situations where a producer may otherwise fail during starting and cause the route to fail being started. By deferring this startup to be lazy then the startup failure can be handled during routing messages via Camel's routing error handlers. Beware that when the first message is processed then creating and starting the producer may take a little time and prolong the total processing time of the processing.";
    public static final Boolean CAMEL_SINK_AWS2S3_ENDPOINT_LAZY_START_PRODUCER_DEFAULT = false;
    public static final String CAMEL_SINK_AWS2S3_ENDPOINT_MULTI_PART_UPLOAD_CONF = "camel.sink.endpoint.multiPartUpload";
    public static final String CAMEL_SINK_AWS2S3_ENDPOINT_MULTI_PART_UPLOAD_DOC = "If it is true, camel will upload the file with multi part format, the part size is decided by the option of partSize";
    public static final Boolean CAMEL_SINK_AWS2S3_ENDPOINT_MULTI_PART_UPLOAD_DEFAULT = false;
    public static final String CAMEL_SINK_AWS2S3_ENDPOINT_NAMING_STRATEGY_CONF = "camel.sink.endpoint.namingStrategy";
    public static final String CAMEL_SINK_AWS2S3_ENDPOINT_NAMING_STRATEGY_DOC = "The naming strategy to use in streaming upload mode One of: [progressive] [random]";
    public static final String CAMEL_SINK_AWS2S3_ENDPOINT_NAMING_STRATEGY_DEFAULT = "progressive";
    public static final String CAMEL_SINK_AWS2S3_ENDPOINT_OPERATION_CONF = "camel.sink.endpoint.operation";
    public static final String CAMEL_SINK_AWS2S3_ENDPOINT_OPERATION_DOC = "The operation to do in case the user don't want to do only an upload One of: [copyObject] [listObjects] [deleteObject] [deleteBucket] [listBuckets] [getObject] [getObjectRange]";
    public static final String CAMEL_SINK_AWS2S3_ENDPOINT_OPERATION_DEFAULT = null;
    public static final String CAMEL_SINK_AWS2S3_ENDPOINT_PART_SIZE_CONF = "camel.sink.endpoint.partSize";
    public static final String CAMEL_SINK_AWS2S3_ENDPOINT_PART_SIZE_DOC = "Setup the partSize which is used in multi part upload, the default size is 25M.";
    public static final Long CAMEL_SINK_AWS2S3_ENDPOINT_PART_SIZE_DEFAULT = 26214400L;
    public static final String CAMEL_SINK_AWS2S3_ENDPOINT_RESTARTING_POLICY_CONF = "camel.sink.endpoint.restartingPolicy";
    public static final String CAMEL_SINK_AWS2S3_ENDPOINT_RESTARTING_POLICY_DOC = "The restarting policy to use in streaming upload mode One of: [override] [lastPart]";
    public static final String CAMEL_SINK_AWS2S3_ENDPOINT_RESTARTING_POLICY_DEFAULT = "override";
    public static final String CAMEL_SINK_AWS2S3_ENDPOINT_STORAGE_CLASS_CONF = "camel.sink.endpoint.storageClass";
    public static final String CAMEL_SINK_AWS2S3_ENDPOINT_STORAGE_CLASS_DOC = "The storage class to set in the com.amazonaws.services.s3.model.PutObjectRequest request.";
    public static final String CAMEL_SINK_AWS2S3_ENDPOINT_STORAGE_CLASS_DEFAULT = null;
    public static final String CAMEL_SINK_AWS2S3_ENDPOINT_STREAMING_UPLOAD_MODE_CONF = "camel.sink.endpoint.streamingUploadMode";
    public static final String CAMEL_SINK_AWS2S3_ENDPOINT_STREAMING_UPLOAD_MODE_DOC = "When stream mode is true the upload to bucket will be done in streaming";
    public static final Boolean CAMEL_SINK_AWS2S3_ENDPOINT_STREAMING_UPLOAD_MODE_DEFAULT = false;
    public static final String CAMEL_SINK_AWS2S3_ENDPOINT_STREAMING_UPLOAD_TIMEOUT_CONF = "camel.sink.endpoint.streamingUploadTimeout";
    public static final String CAMEL_SINK_AWS2S3_ENDPOINT_STREAMING_UPLOAD_TIMEOUT_DOC = "While streaming upload mode is true, this option set the timeout to complete upload";
    public static final Long CAMEL_SINK_AWS2S3_ENDPOINT_STREAMING_UPLOAD_TIMEOUT_DEFAULT = null;
    public static final String CAMEL_SINK_AWS2S3_ENDPOINT_AWS_KMSKEY_ID_CONF = "camel.sink.endpoint.awsKMSKeyId";
    public static final String CAMEL_SINK_AWS2S3_ENDPOINT_AWS_KMSKEY_ID_DOC = "Define the id of KMS key to use in case KMS is enabled";
    public static final String CAMEL_SINK_AWS2S3_ENDPOINT_AWS_KMSKEY_ID_DEFAULT = null;
    public static final String CAMEL_SINK_AWS2S3_ENDPOINT_USE_AWS_KMSCONF = "camel.sink.endpoint.useAwsKMS";
    public static final String CAMEL_SINK_AWS2S3_ENDPOINT_USE_AWS_KMSDOC = "Define if KMS must be used or not";
    public static final Boolean CAMEL_SINK_AWS2S3_ENDPOINT_USE_AWS_KMSDEFAULT = false;
    public static final String CAMEL_SINK_AWS2S3_ENDPOINT_USE_CUSTOMER_KEY_CONF = "camel.sink.endpoint.useCustomerKey";
    public static final String CAMEL_SINK_AWS2S3_ENDPOINT_USE_CUSTOMER_KEY_DOC = "Define if Customer Key must be used or not";
    public static final Boolean CAMEL_SINK_AWS2S3_ENDPOINT_USE_CUSTOMER_KEY_DEFAULT = false;
    public static final String CAMEL_SINK_AWS2S3_ENDPOINT_ACCESS_KEY_CONF = "camel.sink.endpoint.accessKey";
    public static final String CAMEL_SINK_AWS2S3_ENDPOINT_ACCESS_KEY_DOC = "Amazon AWS Access Key";
    public static final String CAMEL_SINK_AWS2S3_ENDPOINT_ACCESS_KEY_DEFAULT = null;
    public static final String CAMEL_SINK_AWS2S3_ENDPOINT_SECRET_KEY_CONF = "camel.sink.endpoint.secretKey";
    public static final String CAMEL_SINK_AWS2S3_ENDPOINT_SECRET_KEY_DOC = "Amazon AWS Secret Key";
    public static final String CAMEL_SINK_AWS2S3_ENDPOINT_SECRET_KEY_DEFAULT = null;
    public static final String CAMEL_SINK_AWS2S3_COMPONENT_AMAZON_S3CLIENT_CONF = "camel.component.aws2-s3.amazonS3Client";
    public static final String CAMEL_SINK_AWS2S3_COMPONENT_AMAZON_S3CLIENT_DOC = "Reference to a com.amazonaws.services.s3.AmazonS3 in the registry.";
    public static final String CAMEL_SINK_AWS2S3_COMPONENT_AMAZON_S3CLIENT_DEFAULT = null;
    public static final String CAMEL_SINK_AWS2S3_COMPONENT_AMAZON_S3PRESIGNER_CONF = "camel.component.aws2-s3.amazonS3Presigner";
    public static final String CAMEL_SINK_AWS2S3_COMPONENT_AMAZON_S3PRESIGNER_DOC = "An S3 Presigner for Request, used mainly in createDownloadLink operation";
    public static final String CAMEL_SINK_AWS2S3_COMPONENT_AMAZON_S3PRESIGNER_DEFAULT = null;
    public static final String CAMEL_SINK_AWS2S3_COMPONENT_AUTO_CREATE_BUCKET_CONF = "camel.component.aws2-s3.autoCreateBucket";
    public static final String CAMEL_SINK_AWS2S3_COMPONENT_AUTO_CREATE_BUCKET_DOC = "Setting the autocreation of the S3 bucket bucketName. This will apply also in case of moveAfterRead option enabled and it will create the destinationBucket if it doesn't exist already.";
    public static final Boolean CAMEL_SINK_AWS2S3_COMPONENT_AUTO_CREATE_BUCKET_DEFAULT = false;
    public static final String CAMEL_SINK_AWS2S3_COMPONENT_CONFIGURATION_CONF = "camel.component.aws2-s3.configuration";
    public static final String CAMEL_SINK_AWS2S3_COMPONENT_CONFIGURATION_DOC = "The component configuration";
    public static final String CAMEL_SINK_AWS2S3_COMPONENT_CONFIGURATION_DEFAULT = null;
    public static final String CAMEL_SINK_AWS2S3_COMPONENT_OVERRIDE_ENDPOINT_CONF = "camel.component.aws2-s3.overrideEndpoint";
    public static final String CAMEL_SINK_AWS2S3_COMPONENT_OVERRIDE_ENDPOINT_DOC = "Set the need for overidding the endpoint. This option needs to be used in combination with uriEndpointOverride option";
    public static final Boolean CAMEL_SINK_AWS2S3_COMPONENT_OVERRIDE_ENDPOINT_DEFAULT = false;
    public static final String CAMEL_SINK_AWS2S3_COMPONENT_POJO_REQUEST_CONF = "camel.component.aws2-s3.pojoRequest";
    public static final String CAMEL_SINK_AWS2S3_COMPONENT_POJO_REQUEST_DOC = "If we want to use a POJO request as body or not";
    public static final Boolean CAMEL_SINK_AWS2S3_COMPONENT_POJO_REQUEST_DEFAULT = false;
    public static final String CAMEL_SINK_AWS2S3_COMPONENT_POLICY_CONF = "camel.component.aws2-s3.policy";
    public static final String CAMEL_SINK_AWS2S3_COMPONENT_POLICY_DOC = "The policy for this queue to set in the com.amazonaws.services.s3.AmazonS3#setBucketPolicy() method.";
    public static final String CAMEL_SINK_AWS2S3_COMPONENT_POLICY_DEFAULT = null;
    public static final String CAMEL_SINK_AWS2S3_COMPONENT_PROXY_HOST_CONF = "camel.component.aws2-s3.proxyHost";
    public static final String CAMEL_SINK_AWS2S3_COMPONENT_PROXY_HOST_DOC = "To define a proxy host when instantiating the SQS client";
    public static final String CAMEL_SINK_AWS2S3_COMPONENT_PROXY_HOST_DEFAULT = null;
    public static final String CAMEL_SINK_AWS2S3_COMPONENT_PROXY_PORT_CONF = "camel.component.aws2-s3.proxyPort";
    public static final String CAMEL_SINK_AWS2S3_COMPONENT_PROXY_PORT_DOC = "Specify a proxy port to be used inside the client definition.";
    public static final String CAMEL_SINK_AWS2S3_COMPONENT_PROXY_PORT_DEFAULT = null;
    public static final String CAMEL_SINK_AWS2S3_COMPONENT_PROXY_PROTOCOL_CONF = "camel.component.aws2-s3.proxyProtocol";
    public static final String CAMEL_SINK_AWS2S3_COMPONENT_PROXY_PROTOCOL_DOC = "To define a proxy protocol when instantiating the S3 client One of: [HTTP] [HTTPS]";
    public static final String CAMEL_SINK_AWS2S3_COMPONENT_PROXY_PROTOCOL_DEFAULT = "HTTPS";
    public static final String CAMEL_SINK_AWS2S3_COMPONENT_REGION_CONF = "camel.component.aws2-s3.region";
    public static final String CAMEL_SINK_AWS2S3_COMPONENT_REGION_DOC = "The region in which S3 client needs to work. When using this parameter, the configuration will expect the lowercase name of the region (for example ap-east-1) You'll need to use the name Region.EU_WEST_1.id()";
    public static final String CAMEL_SINK_AWS2S3_COMPONENT_REGION_DEFAULT = null;
    public static final String CAMEL_SINK_AWS2S3_COMPONENT_TRUST_ALL_CERTIFICATES_CONF = "camel.component.aws2-s3.trustAllCertificates";
    public static final String CAMEL_SINK_AWS2S3_COMPONENT_TRUST_ALL_CERTIFICATES_DOC = "If we want to trust all certificates in case of overriding the endpoint";
    public static final Boolean CAMEL_SINK_AWS2S3_COMPONENT_TRUST_ALL_CERTIFICATES_DEFAULT = false;
    public static final String CAMEL_SINK_AWS2S3_COMPONENT_URI_ENDPOINT_OVERRIDE_CONF = "camel.component.aws2-s3.uriEndpointOverride";
    public static final String CAMEL_SINK_AWS2S3_COMPONENT_URI_ENDPOINT_OVERRIDE_DOC = "Set the overriding uri endpoint. This option needs to be used in combination with overrideEndpoint option";
    public static final String CAMEL_SINK_AWS2S3_COMPONENT_URI_ENDPOINT_OVERRIDE_DEFAULT = null;
    public static final String CAMEL_SINK_AWS2S3_COMPONENT_USE_DEFAULT_CREDENTIALS_PROVIDER_CONF = "camel.component.aws2-s3.useDefaultCredentialsProvider";
    public static final String CAMEL_SINK_AWS2S3_COMPONENT_USE_DEFAULT_CREDENTIALS_PROVIDER_DOC = "Set whether the S3 client should expect to load credentials through a default credentials provider or to expect static credentials to be passed in.";
    public static final Boolean CAMEL_SINK_AWS2S3_COMPONENT_USE_DEFAULT_CREDENTIALS_PROVIDER_DEFAULT = false;
    public static final String CAMEL_SINK_AWS2S3_COMPONENT_CUSTOMER_ALGORITHM_CONF = "camel.component.aws2-s3.customerAlgorithm";
    public static final String CAMEL_SINK_AWS2S3_COMPONENT_CUSTOMER_ALGORITHM_DOC = "Define the customer algorithm to use in case CustomerKey is enabled";
    public static final String CAMEL_SINK_AWS2S3_COMPONENT_CUSTOMER_ALGORITHM_DEFAULT = null;
    public static final String CAMEL_SINK_AWS2S3_COMPONENT_CUSTOMER_KEY_ID_CONF = "camel.component.aws2-s3.customerKeyId";
    public static final String CAMEL_SINK_AWS2S3_COMPONENT_CUSTOMER_KEY_ID_DOC = "Define the id of Customer key to use in case CustomerKey is enabled";
    public static final String CAMEL_SINK_AWS2S3_COMPONENT_CUSTOMER_KEY_ID_DEFAULT = null;
    public static final String CAMEL_SINK_AWS2S3_COMPONENT_CUSTOMER_KEY_MD5CONF = "camel.component.aws2-s3.customerKeyMD5";
    public static final String CAMEL_SINK_AWS2S3_COMPONENT_CUSTOMER_KEY_MD5DOC = "Define the MD5 of Customer key to use in case CustomerKey is enabled";
    public static final String CAMEL_SINK_AWS2S3_COMPONENT_CUSTOMER_KEY_MD5DEFAULT = null;
    public static final String CAMEL_SINK_AWS2S3_COMPONENT_BATCH_MESSAGE_NUMBER_CONF = "camel.component.aws2-s3.batchMessageNumber";
    public static final String CAMEL_SINK_AWS2S3_COMPONENT_BATCH_MESSAGE_NUMBER_DOC = "The number of messages composing a batch in streaming upload mode";
    public static final Integer CAMEL_SINK_AWS2S3_COMPONENT_BATCH_MESSAGE_NUMBER_DEFAULT = 10;
    public static final String CAMEL_SINK_AWS2S3_COMPONENT_BATCH_SIZE_CONF = "camel.component.aws2-s3.batchSize";
    public static final String CAMEL_SINK_AWS2S3_COMPONENT_BATCH_SIZE_DOC = "The batch size (in bytes) in streaming upload mode";
    public static final Integer CAMEL_SINK_AWS2S3_COMPONENT_BATCH_SIZE_DEFAULT = 1000000;
    public static final String CAMEL_SINK_AWS2S3_COMPONENT_DELETE_AFTER_WRITE_CONF = "camel.component.aws2-s3.deleteAfterWrite";
    public static final String CAMEL_SINK_AWS2S3_COMPONENT_DELETE_AFTER_WRITE_DOC = "Delete file object after the S3 file has been uploaded";
    public static final Boolean CAMEL_SINK_AWS2S3_COMPONENT_DELETE_AFTER_WRITE_DEFAULT = false;
    public static final String CAMEL_SINK_AWS2S3_COMPONENT_KEY_NAME_CONF = "camel.component.aws2-s3.keyName";
    public static final String CAMEL_SINK_AWS2S3_COMPONENT_KEY_NAME_DOC = "Setting the key name for an element in the bucket through endpoint parameter";
    public static final String CAMEL_SINK_AWS2S3_COMPONENT_KEY_NAME_DEFAULT = null;
    public static final String CAMEL_SINK_AWS2S3_COMPONENT_LAZY_START_PRODUCER_CONF = "camel.component.aws2-s3.lazyStartProducer";
    public static final String CAMEL_SINK_AWS2S3_COMPONENT_LAZY_START_PRODUCER_DOC = "Whether the producer should be started lazy (on the first message). By starting lazy you can use this to allow CamelContext and routes to startup in situations where a producer may otherwise fail during starting and cause the route to fail being started. By deferring this startup to be lazy then the startup failure can be handled during routing messages via Camel's routing error handlers. Beware that when the first message is processed then creating and starting the producer may take a little time and prolong the total processing time of the processing.";
    public static final Boolean CAMEL_SINK_AWS2S3_COMPONENT_LAZY_START_PRODUCER_DEFAULT = false;
    public static final String CAMEL_SINK_AWS2S3_COMPONENT_MULTI_PART_UPLOAD_CONF = "camel.component.aws2-s3.multiPartUpload";
    public static final String CAMEL_SINK_AWS2S3_COMPONENT_MULTI_PART_UPLOAD_DOC = "If it is true, camel will upload the file with multi part format, the part size is decided by the option of partSize";
    public static final Boolean CAMEL_SINK_AWS2S3_COMPONENT_MULTI_PART_UPLOAD_DEFAULT = false;
    public static final String CAMEL_SINK_AWS2S3_COMPONENT_NAMING_STRATEGY_CONF = "camel.component.aws2-s3.namingStrategy";
    public static final String CAMEL_SINK_AWS2S3_COMPONENT_NAMING_STRATEGY_DOC = "The naming strategy to use in streaming upload mode One of: [progressive] [random]";
    public static final String CAMEL_SINK_AWS2S3_COMPONENT_NAMING_STRATEGY_DEFAULT = "progressive";
    public static final String CAMEL_SINK_AWS2S3_COMPONENT_OPERATION_CONF = "camel.component.aws2-s3.operation";
    public static final String CAMEL_SINK_AWS2S3_COMPONENT_OPERATION_DOC = "The operation to do in case the user don't want to do only an upload One of: [copyObject] [listObjects] [deleteObject] [deleteBucket] [listBuckets] [getObject] [getObjectRange]";
    public static final String CAMEL_SINK_AWS2S3_COMPONENT_OPERATION_DEFAULT = null;
    public static final String CAMEL_SINK_AWS2S3_COMPONENT_PART_SIZE_CONF = "camel.component.aws2-s3.partSize";
    public static final String CAMEL_SINK_AWS2S3_COMPONENT_PART_SIZE_DOC = "Setup the partSize which is used in multi part upload, the default size is 25M.";
    public static final Long CAMEL_SINK_AWS2S3_COMPONENT_PART_SIZE_DEFAULT = 26214400L;
    public static final String CAMEL_SINK_AWS2S3_COMPONENT_RESTARTING_POLICY_CONF = "camel.component.aws2-s3.restartingPolicy";
    public static final String CAMEL_SINK_AWS2S3_COMPONENT_RESTARTING_POLICY_DOC = "The restarting policy to use in streaming upload mode One of: [override] [lastPart]";
    public static final String CAMEL_SINK_AWS2S3_COMPONENT_RESTARTING_POLICY_DEFAULT = "override";
    public static final String CAMEL_SINK_AWS2S3_COMPONENT_STORAGE_CLASS_CONF = "camel.component.aws2-s3.storageClass";
    public static final String CAMEL_SINK_AWS2S3_COMPONENT_STORAGE_CLASS_DOC = "The storage class to set in the com.amazonaws.services.s3.model.PutObjectRequest request.";
    public static final String CAMEL_SINK_AWS2S3_COMPONENT_STORAGE_CLASS_DEFAULT = null;
    public static final String CAMEL_SINK_AWS2S3_COMPONENT_STREAMING_UPLOAD_MODE_CONF = "camel.component.aws2-s3.streamingUploadMode";
    public static final String CAMEL_SINK_AWS2S3_COMPONENT_STREAMING_UPLOAD_MODE_DOC = "When stream mode is true the upload to bucket will be done in streaming";
    public static final Boolean CAMEL_SINK_AWS2S3_COMPONENT_STREAMING_UPLOAD_MODE_DEFAULT = false;
    public static final String CAMEL_SINK_AWS2S3_COMPONENT_STREAMING_UPLOAD_TIMEOUT_CONF = "camel.component.aws2-s3.streamingUploadTimeout";
    public static final String CAMEL_SINK_AWS2S3_COMPONENT_STREAMING_UPLOAD_TIMEOUT_DOC = "While streaming upload mode is true, this option set the timeout to complete upload";
    public static final Long CAMEL_SINK_AWS2S3_COMPONENT_STREAMING_UPLOAD_TIMEOUT_DEFAULT = null;
    public static final String CAMEL_SINK_AWS2S3_COMPONENT_AWS_KMSKEY_ID_CONF = "camel.component.aws2-s3.awsKMSKeyId";
    public static final String CAMEL_SINK_AWS2S3_COMPONENT_AWS_KMSKEY_ID_DOC = "Define the id of KMS key to use in case KMS is enabled";
    public static final String CAMEL_SINK_AWS2S3_COMPONENT_AWS_KMSKEY_ID_DEFAULT = null;
    public static final String CAMEL_SINK_AWS2S3_COMPONENT_USE_AWS_KMSCONF = "camel.component.aws2-s3.useAwsKMS";
    public static final String CAMEL_SINK_AWS2S3_COMPONENT_USE_AWS_KMSDOC = "Define if KMS must be used or not";
    public static final Boolean CAMEL_SINK_AWS2S3_COMPONENT_USE_AWS_KMSDEFAULT = false;
    public static final String CAMEL_SINK_AWS2S3_COMPONENT_USE_CUSTOMER_KEY_CONF = "camel.component.aws2-s3.useCustomerKey";
    public static final String CAMEL_SINK_AWS2S3_COMPONENT_USE_CUSTOMER_KEY_DOC = "Define if Customer Key must be used or not";
    public static final Boolean CAMEL_SINK_AWS2S3_COMPONENT_USE_CUSTOMER_KEY_DEFAULT = false;
    public static final String CAMEL_SINK_AWS2S3_COMPONENT_AUTOWIRED_ENABLED_CONF = "camel.component.aws2-s3.autowiredEnabled";
    public static final String CAMEL_SINK_AWS2S3_COMPONENT_AUTOWIRED_ENABLED_DOC = "Whether autowiring is enabled. This is used for automatic autowiring options (the option must be marked as autowired) by looking up in the registry to find if there is a single instance of matching type, which then gets configured on the component. This can be used for automatic configuring JDBC data sources, JMS connection factories, AWS Clients, etc.";
    public static final Boolean CAMEL_SINK_AWS2S3_COMPONENT_AUTOWIRED_ENABLED_DEFAULT = true;
    public static final String CAMEL_SINK_AWS2S3_COMPONENT_ACCESS_KEY_CONF = "camel.component.aws2-s3.accessKey";
    public static final String CAMEL_SINK_AWS2S3_COMPONENT_ACCESS_KEY_DOC = "Amazon AWS Access Key";
    public static final String CAMEL_SINK_AWS2S3_COMPONENT_ACCESS_KEY_DEFAULT = null;
    public static final String CAMEL_SINK_AWS2S3_COMPONENT_SECRET_KEY_CONF = "camel.component.aws2-s3.secretKey";
    public static final String CAMEL_SINK_AWS2S3_COMPONENT_SECRET_KEY_DOC = "Amazon AWS Secret Key";
    public static final String CAMEL_SINK_AWS2S3_COMPONENT_SECRET_KEY_DEFAULT = null;

    public CamelAws2s3SinkConnectorConfig(
            ConfigDef config,
            Map<String, String> parsedConfig) {
        super(config, parsedConfig);
    }

    public CamelAws2s3SinkConnectorConfig(Map<String, String> parsedConfig) {
        this(conf(), parsedConfig);
    }

    public static ConfigDef conf() {
        ConfigDef conf = new ConfigDef(CamelSinkConnectorConfig.conf());
        conf.define(CAMEL_SINK_AWS2S3_PATH_BUCKET_NAME_OR_ARN_CONF, ConfigDef.Type.STRING, CAMEL_SINK_AWS2S3_PATH_BUCKET_NAME_OR_ARN_DEFAULT, ConfigDef.Importance.HIGH, CAMEL_SINK_AWS2S3_PATH_BUCKET_NAME_OR_ARN_DOC);
        conf.define(CAMEL_SINK_AWS2S3_ENDPOINT_AMAZON_S3CLIENT_CONF, ConfigDef.Type.STRING, CAMEL_SINK_AWS2S3_ENDPOINT_AMAZON_S3CLIENT_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SINK_AWS2S3_ENDPOINT_AMAZON_S3CLIENT_DOC);
        conf.define(CAMEL_SINK_AWS2S3_ENDPOINT_AMAZON_S3PRESIGNER_CONF, ConfigDef.Type.STRING, CAMEL_SINK_AWS2S3_ENDPOINT_AMAZON_S3PRESIGNER_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SINK_AWS2S3_ENDPOINT_AMAZON_S3PRESIGNER_DOC);
        conf.define(CAMEL_SINK_AWS2S3_ENDPOINT_AUTO_CREATE_BUCKET_CONF, ConfigDef.Type.BOOLEAN, CAMEL_SINK_AWS2S3_ENDPOINT_AUTO_CREATE_BUCKET_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SINK_AWS2S3_ENDPOINT_AUTO_CREATE_BUCKET_DOC);
        conf.define(CAMEL_SINK_AWS2S3_ENDPOINT_OVERRIDE_ENDPOINT_CONF, ConfigDef.Type.BOOLEAN, CAMEL_SINK_AWS2S3_ENDPOINT_OVERRIDE_ENDPOINT_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SINK_AWS2S3_ENDPOINT_OVERRIDE_ENDPOINT_DOC);
        conf.define(CAMEL_SINK_AWS2S3_ENDPOINT_POJO_REQUEST_CONF, ConfigDef.Type.BOOLEAN, CAMEL_SINK_AWS2S3_ENDPOINT_POJO_REQUEST_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SINK_AWS2S3_ENDPOINT_POJO_REQUEST_DOC);
        conf.define(CAMEL_SINK_AWS2S3_ENDPOINT_POLICY_CONF, ConfigDef.Type.STRING, CAMEL_SINK_AWS2S3_ENDPOINT_POLICY_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SINK_AWS2S3_ENDPOINT_POLICY_DOC);
        conf.define(CAMEL_SINK_AWS2S3_ENDPOINT_PROXY_HOST_CONF, ConfigDef.Type.STRING, CAMEL_SINK_AWS2S3_ENDPOINT_PROXY_HOST_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SINK_AWS2S3_ENDPOINT_PROXY_HOST_DOC);
        conf.define(CAMEL_SINK_AWS2S3_ENDPOINT_PROXY_PORT_CONF, ConfigDef.Type.STRING, CAMEL_SINK_AWS2S3_ENDPOINT_PROXY_PORT_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SINK_AWS2S3_ENDPOINT_PROXY_PORT_DOC);
        conf.define(CAMEL_SINK_AWS2S3_ENDPOINT_PROXY_PROTOCOL_CONF, ConfigDef.Type.STRING, CAMEL_SINK_AWS2S3_ENDPOINT_PROXY_PROTOCOL_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SINK_AWS2S3_ENDPOINT_PROXY_PROTOCOL_DOC);
        conf.define(CAMEL_SINK_AWS2S3_ENDPOINT_REGION_CONF, ConfigDef.Type.STRING, CAMEL_SINK_AWS2S3_ENDPOINT_REGION_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SINK_AWS2S3_ENDPOINT_REGION_DOC);
        conf.define(CAMEL_SINK_AWS2S3_ENDPOINT_TRUST_ALL_CERTIFICATES_CONF, ConfigDef.Type.BOOLEAN, CAMEL_SINK_AWS2S3_ENDPOINT_TRUST_ALL_CERTIFICATES_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SINK_AWS2S3_ENDPOINT_TRUST_ALL_CERTIFICATES_DOC);
        conf.define(CAMEL_SINK_AWS2S3_ENDPOINT_URI_ENDPOINT_OVERRIDE_CONF, ConfigDef.Type.STRING, CAMEL_SINK_AWS2S3_ENDPOINT_URI_ENDPOINT_OVERRIDE_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SINK_AWS2S3_ENDPOINT_URI_ENDPOINT_OVERRIDE_DOC);
        conf.define(CAMEL_SINK_AWS2S3_ENDPOINT_USE_DEFAULT_CREDENTIALS_PROVIDER_CONF, ConfigDef.Type.BOOLEAN, CAMEL_SINK_AWS2S3_ENDPOINT_USE_DEFAULT_CREDENTIALS_PROVIDER_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SINK_AWS2S3_ENDPOINT_USE_DEFAULT_CREDENTIALS_PROVIDER_DOC);
        conf.define(CAMEL_SINK_AWS2S3_ENDPOINT_CUSTOMER_ALGORITHM_CONF, ConfigDef.Type.STRING, CAMEL_SINK_AWS2S3_ENDPOINT_CUSTOMER_ALGORITHM_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SINK_AWS2S3_ENDPOINT_CUSTOMER_ALGORITHM_DOC);
        conf.define(CAMEL_SINK_AWS2S3_ENDPOINT_CUSTOMER_KEY_ID_CONF, ConfigDef.Type.STRING, CAMEL_SINK_AWS2S3_ENDPOINT_CUSTOMER_KEY_ID_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SINK_AWS2S3_ENDPOINT_CUSTOMER_KEY_ID_DOC);
        conf.define(CAMEL_SINK_AWS2S3_ENDPOINT_CUSTOMER_KEY_MD5CONF, ConfigDef.Type.STRING, CAMEL_SINK_AWS2S3_ENDPOINT_CUSTOMER_KEY_MD5DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SINK_AWS2S3_ENDPOINT_CUSTOMER_KEY_MD5DOC);
        conf.define(CAMEL_SINK_AWS2S3_ENDPOINT_BATCH_MESSAGE_NUMBER_CONF, ConfigDef.Type.INT, CAMEL_SINK_AWS2S3_ENDPOINT_BATCH_MESSAGE_NUMBER_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SINK_AWS2S3_ENDPOINT_BATCH_MESSAGE_NUMBER_DOC);
        conf.define(CAMEL_SINK_AWS2S3_ENDPOINT_BATCH_SIZE_CONF, ConfigDef.Type.INT, CAMEL_SINK_AWS2S3_ENDPOINT_BATCH_SIZE_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SINK_AWS2S3_ENDPOINT_BATCH_SIZE_DOC);
        conf.define(CAMEL_SINK_AWS2S3_ENDPOINT_DELETE_AFTER_WRITE_CONF, ConfigDef.Type.BOOLEAN, CAMEL_SINK_AWS2S3_ENDPOINT_DELETE_AFTER_WRITE_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SINK_AWS2S3_ENDPOINT_DELETE_AFTER_WRITE_DOC);
        conf.define(CAMEL_SINK_AWS2S3_ENDPOINT_KEY_NAME_CONF, ConfigDef.Type.STRING, CAMEL_SINK_AWS2S3_ENDPOINT_KEY_NAME_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SINK_AWS2S3_ENDPOINT_KEY_NAME_DOC);
        conf.define(CAMEL_SINK_AWS2S3_ENDPOINT_LAZY_START_PRODUCER_CONF, ConfigDef.Type.BOOLEAN, CAMEL_SINK_AWS2S3_ENDPOINT_LAZY_START_PRODUCER_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SINK_AWS2S3_ENDPOINT_LAZY_START_PRODUCER_DOC);
        conf.define(CAMEL_SINK_AWS2S3_ENDPOINT_MULTI_PART_UPLOAD_CONF, ConfigDef.Type.BOOLEAN, CAMEL_SINK_AWS2S3_ENDPOINT_MULTI_PART_UPLOAD_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SINK_AWS2S3_ENDPOINT_MULTI_PART_UPLOAD_DOC);
        conf.define(CAMEL_SINK_AWS2S3_ENDPOINT_NAMING_STRATEGY_CONF, ConfigDef.Type.STRING, CAMEL_SINK_AWS2S3_ENDPOINT_NAMING_STRATEGY_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SINK_AWS2S3_ENDPOINT_NAMING_STRATEGY_DOC);
        conf.define(CAMEL_SINK_AWS2S3_ENDPOINT_OPERATION_CONF, ConfigDef.Type.STRING, CAMEL_SINK_AWS2S3_ENDPOINT_OPERATION_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SINK_AWS2S3_ENDPOINT_OPERATION_DOC);
        conf.define(CAMEL_SINK_AWS2S3_ENDPOINT_PART_SIZE_CONF, ConfigDef.Type.LONG, CAMEL_SINK_AWS2S3_ENDPOINT_PART_SIZE_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SINK_AWS2S3_ENDPOINT_PART_SIZE_DOC);
        conf.define(CAMEL_SINK_AWS2S3_ENDPOINT_RESTARTING_POLICY_CONF, ConfigDef.Type.STRING, CAMEL_SINK_AWS2S3_ENDPOINT_RESTARTING_POLICY_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SINK_AWS2S3_ENDPOINT_RESTARTING_POLICY_DOC);
        conf.define(CAMEL_SINK_AWS2S3_ENDPOINT_STORAGE_CLASS_CONF, ConfigDef.Type.STRING, CAMEL_SINK_AWS2S3_ENDPOINT_STORAGE_CLASS_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SINK_AWS2S3_ENDPOINT_STORAGE_CLASS_DOC);
        conf.define(CAMEL_SINK_AWS2S3_ENDPOINT_STREAMING_UPLOAD_MODE_CONF, ConfigDef.Type.BOOLEAN, CAMEL_SINK_AWS2S3_ENDPOINT_STREAMING_UPLOAD_MODE_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SINK_AWS2S3_ENDPOINT_STREAMING_UPLOAD_MODE_DOC);
        conf.define(CAMEL_SINK_AWS2S3_ENDPOINT_STREAMING_UPLOAD_TIMEOUT_CONF, ConfigDef.Type.LONG, CAMEL_SINK_AWS2S3_ENDPOINT_STREAMING_UPLOAD_TIMEOUT_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SINK_AWS2S3_ENDPOINT_STREAMING_UPLOAD_TIMEOUT_DOC);
        conf.define(CAMEL_SINK_AWS2S3_ENDPOINT_AWS_KMSKEY_ID_CONF, ConfigDef.Type.STRING, CAMEL_SINK_AWS2S3_ENDPOINT_AWS_KMSKEY_ID_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SINK_AWS2S3_ENDPOINT_AWS_KMSKEY_ID_DOC);
        conf.define(CAMEL_SINK_AWS2S3_ENDPOINT_USE_AWS_KMSCONF, ConfigDef.Type.BOOLEAN, CAMEL_SINK_AWS2S3_ENDPOINT_USE_AWS_KMSDEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SINK_AWS2S3_ENDPOINT_USE_AWS_KMSDOC);
        conf.define(CAMEL_SINK_AWS2S3_ENDPOINT_USE_CUSTOMER_KEY_CONF, ConfigDef.Type.BOOLEAN, CAMEL_SINK_AWS2S3_ENDPOINT_USE_CUSTOMER_KEY_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SINK_AWS2S3_ENDPOINT_USE_CUSTOMER_KEY_DOC);
        conf.define(CAMEL_SINK_AWS2S3_ENDPOINT_ACCESS_KEY_CONF, ConfigDef.Type.PASSWORD, CAMEL_SINK_AWS2S3_ENDPOINT_ACCESS_KEY_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SINK_AWS2S3_ENDPOINT_ACCESS_KEY_DOC);
        conf.define(CAMEL_SINK_AWS2S3_ENDPOINT_SECRET_KEY_CONF, ConfigDef.Type.PASSWORD, CAMEL_SINK_AWS2S3_ENDPOINT_SECRET_KEY_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SINK_AWS2S3_ENDPOINT_SECRET_KEY_DOC);
        conf.define(CAMEL_SINK_AWS2S3_COMPONENT_AMAZON_S3CLIENT_CONF, ConfigDef.Type.STRING, CAMEL_SINK_AWS2S3_COMPONENT_AMAZON_S3CLIENT_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SINK_AWS2S3_COMPONENT_AMAZON_S3CLIENT_DOC);
        conf.define(CAMEL_SINK_AWS2S3_COMPONENT_AMAZON_S3PRESIGNER_CONF, ConfigDef.Type.STRING, CAMEL_SINK_AWS2S3_COMPONENT_AMAZON_S3PRESIGNER_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SINK_AWS2S3_COMPONENT_AMAZON_S3PRESIGNER_DOC);
        conf.define(CAMEL_SINK_AWS2S3_COMPONENT_AUTO_CREATE_BUCKET_CONF, ConfigDef.Type.BOOLEAN, CAMEL_SINK_AWS2S3_COMPONENT_AUTO_CREATE_BUCKET_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SINK_AWS2S3_COMPONENT_AUTO_CREATE_BUCKET_DOC);
        conf.define(CAMEL_SINK_AWS2S3_COMPONENT_CONFIGURATION_CONF, ConfigDef.Type.STRING, CAMEL_SINK_AWS2S3_COMPONENT_CONFIGURATION_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SINK_AWS2S3_COMPONENT_CONFIGURATION_DOC);
        conf.define(CAMEL_SINK_AWS2S3_COMPONENT_OVERRIDE_ENDPOINT_CONF, ConfigDef.Type.BOOLEAN, CAMEL_SINK_AWS2S3_COMPONENT_OVERRIDE_ENDPOINT_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SINK_AWS2S3_COMPONENT_OVERRIDE_ENDPOINT_DOC);
        conf.define(CAMEL_SINK_AWS2S3_COMPONENT_POJO_REQUEST_CONF, ConfigDef.Type.BOOLEAN, CAMEL_SINK_AWS2S3_COMPONENT_POJO_REQUEST_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SINK_AWS2S3_COMPONENT_POJO_REQUEST_DOC);
        conf.define(CAMEL_SINK_AWS2S3_COMPONENT_POLICY_CONF, ConfigDef.Type.STRING, CAMEL_SINK_AWS2S3_COMPONENT_POLICY_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SINK_AWS2S3_COMPONENT_POLICY_DOC);
        conf.define(CAMEL_SINK_AWS2S3_COMPONENT_PROXY_HOST_CONF, ConfigDef.Type.STRING, CAMEL_SINK_AWS2S3_COMPONENT_PROXY_HOST_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SINK_AWS2S3_COMPONENT_PROXY_HOST_DOC);
        conf.define(CAMEL_SINK_AWS2S3_COMPONENT_PROXY_PORT_CONF, ConfigDef.Type.STRING, CAMEL_SINK_AWS2S3_COMPONENT_PROXY_PORT_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SINK_AWS2S3_COMPONENT_PROXY_PORT_DOC);
        conf.define(CAMEL_SINK_AWS2S3_COMPONENT_PROXY_PROTOCOL_CONF, ConfigDef.Type.STRING, CAMEL_SINK_AWS2S3_COMPONENT_PROXY_PROTOCOL_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SINK_AWS2S3_COMPONENT_PROXY_PROTOCOL_DOC);
        conf.define(CAMEL_SINK_AWS2S3_COMPONENT_REGION_CONF, ConfigDef.Type.STRING, CAMEL_SINK_AWS2S3_COMPONENT_REGION_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SINK_AWS2S3_COMPONENT_REGION_DOC);
        conf.define(CAMEL_SINK_AWS2S3_COMPONENT_TRUST_ALL_CERTIFICATES_CONF, ConfigDef.Type.BOOLEAN, CAMEL_SINK_AWS2S3_COMPONENT_TRUST_ALL_CERTIFICATES_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SINK_AWS2S3_COMPONENT_TRUST_ALL_CERTIFICATES_DOC);
        conf.define(CAMEL_SINK_AWS2S3_COMPONENT_URI_ENDPOINT_OVERRIDE_CONF, ConfigDef.Type.STRING, CAMEL_SINK_AWS2S3_COMPONENT_URI_ENDPOINT_OVERRIDE_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SINK_AWS2S3_COMPONENT_URI_ENDPOINT_OVERRIDE_DOC);
        conf.define(CAMEL_SINK_AWS2S3_COMPONENT_USE_DEFAULT_CREDENTIALS_PROVIDER_CONF, ConfigDef.Type.BOOLEAN, CAMEL_SINK_AWS2S3_COMPONENT_USE_DEFAULT_CREDENTIALS_PROVIDER_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SINK_AWS2S3_COMPONENT_USE_DEFAULT_CREDENTIALS_PROVIDER_DOC);
        conf.define(CAMEL_SINK_AWS2S3_COMPONENT_CUSTOMER_ALGORITHM_CONF, ConfigDef.Type.STRING, CAMEL_SINK_AWS2S3_COMPONENT_CUSTOMER_ALGORITHM_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SINK_AWS2S3_COMPONENT_CUSTOMER_ALGORITHM_DOC);
        conf.define(CAMEL_SINK_AWS2S3_COMPONENT_CUSTOMER_KEY_ID_CONF, ConfigDef.Type.STRING, CAMEL_SINK_AWS2S3_COMPONENT_CUSTOMER_KEY_ID_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SINK_AWS2S3_COMPONENT_CUSTOMER_KEY_ID_DOC);
        conf.define(CAMEL_SINK_AWS2S3_COMPONENT_CUSTOMER_KEY_MD5CONF, ConfigDef.Type.STRING, CAMEL_SINK_AWS2S3_COMPONENT_CUSTOMER_KEY_MD5DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SINK_AWS2S3_COMPONENT_CUSTOMER_KEY_MD5DOC);
        conf.define(CAMEL_SINK_AWS2S3_COMPONENT_BATCH_MESSAGE_NUMBER_CONF, ConfigDef.Type.INT, CAMEL_SINK_AWS2S3_COMPONENT_BATCH_MESSAGE_NUMBER_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SINK_AWS2S3_COMPONENT_BATCH_MESSAGE_NUMBER_DOC);
        conf.define(CAMEL_SINK_AWS2S3_COMPONENT_BATCH_SIZE_CONF, ConfigDef.Type.INT, CAMEL_SINK_AWS2S3_COMPONENT_BATCH_SIZE_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SINK_AWS2S3_COMPONENT_BATCH_SIZE_DOC);
        conf.define(CAMEL_SINK_AWS2S3_COMPONENT_DELETE_AFTER_WRITE_CONF, ConfigDef.Type.BOOLEAN, CAMEL_SINK_AWS2S3_COMPONENT_DELETE_AFTER_WRITE_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SINK_AWS2S3_COMPONENT_DELETE_AFTER_WRITE_DOC);
        conf.define(CAMEL_SINK_AWS2S3_COMPONENT_KEY_NAME_CONF, ConfigDef.Type.STRING, CAMEL_SINK_AWS2S3_COMPONENT_KEY_NAME_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SINK_AWS2S3_COMPONENT_KEY_NAME_DOC);
        conf.define(CAMEL_SINK_AWS2S3_COMPONENT_LAZY_START_PRODUCER_CONF, ConfigDef.Type.BOOLEAN, CAMEL_SINK_AWS2S3_COMPONENT_LAZY_START_PRODUCER_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SINK_AWS2S3_COMPONENT_LAZY_START_PRODUCER_DOC);
        conf.define(CAMEL_SINK_AWS2S3_COMPONENT_MULTI_PART_UPLOAD_CONF, ConfigDef.Type.BOOLEAN, CAMEL_SINK_AWS2S3_COMPONENT_MULTI_PART_UPLOAD_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SINK_AWS2S3_COMPONENT_MULTI_PART_UPLOAD_DOC);
        conf.define(CAMEL_SINK_AWS2S3_COMPONENT_NAMING_STRATEGY_CONF, ConfigDef.Type.STRING, CAMEL_SINK_AWS2S3_COMPONENT_NAMING_STRATEGY_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SINK_AWS2S3_COMPONENT_NAMING_STRATEGY_DOC);
        conf.define(CAMEL_SINK_AWS2S3_COMPONENT_OPERATION_CONF, ConfigDef.Type.STRING, CAMEL_SINK_AWS2S3_COMPONENT_OPERATION_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SINK_AWS2S3_COMPONENT_OPERATION_DOC);
        conf.define(CAMEL_SINK_AWS2S3_COMPONENT_PART_SIZE_CONF, ConfigDef.Type.LONG, CAMEL_SINK_AWS2S3_COMPONENT_PART_SIZE_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SINK_AWS2S3_COMPONENT_PART_SIZE_DOC);
        conf.define(CAMEL_SINK_AWS2S3_COMPONENT_RESTARTING_POLICY_CONF, ConfigDef.Type.STRING, CAMEL_SINK_AWS2S3_COMPONENT_RESTARTING_POLICY_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SINK_AWS2S3_COMPONENT_RESTARTING_POLICY_DOC);
        conf.define(CAMEL_SINK_AWS2S3_COMPONENT_STORAGE_CLASS_CONF, ConfigDef.Type.STRING, CAMEL_SINK_AWS2S3_COMPONENT_STORAGE_CLASS_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SINK_AWS2S3_COMPONENT_STORAGE_CLASS_DOC);
        conf.define(CAMEL_SINK_AWS2S3_COMPONENT_STREAMING_UPLOAD_MODE_CONF, ConfigDef.Type.BOOLEAN, CAMEL_SINK_AWS2S3_COMPONENT_STREAMING_UPLOAD_MODE_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SINK_AWS2S3_COMPONENT_STREAMING_UPLOAD_MODE_DOC);
        conf.define(CAMEL_SINK_AWS2S3_COMPONENT_STREAMING_UPLOAD_TIMEOUT_CONF, ConfigDef.Type.LONG, CAMEL_SINK_AWS2S3_COMPONENT_STREAMING_UPLOAD_TIMEOUT_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SINK_AWS2S3_COMPONENT_STREAMING_UPLOAD_TIMEOUT_DOC);
        conf.define(CAMEL_SINK_AWS2S3_COMPONENT_AWS_KMSKEY_ID_CONF, ConfigDef.Type.STRING, CAMEL_SINK_AWS2S3_COMPONENT_AWS_KMSKEY_ID_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SINK_AWS2S3_COMPONENT_AWS_KMSKEY_ID_DOC);
        conf.define(CAMEL_SINK_AWS2S3_COMPONENT_USE_AWS_KMSCONF, ConfigDef.Type.BOOLEAN, CAMEL_SINK_AWS2S3_COMPONENT_USE_AWS_KMSDEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SINK_AWS2S3_COMPONENT_USE_AWS_KMSDOC);
        conf.define(CAMEL_SINK_AWS2S3_COMPONENT_USE_CUSTOMER_KEY_CONF, ConfigDef.Type.BOOLEAN, CAMEL_SINK_AWS2S3_COMPONENT_USE_CUSTOMER_KEY_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SINK_AWS2S3_COMPONENT_USE_CUSTOMER_KEY_DOC);
        conf.define(CAMEL_SINK_AWS2S3_COMPONENT_AUTOWIRED_ENABLED_CONF, ConfigDef.Type.BOOLEAN, CAMEL_SINK_AWS2S3_COMPONENT_AUTOWIRED_ENABLED_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SINK_AWS2S3_COMPONENT_AUTOWIRED_ENABLED_DOC);
        conf.define(CAMEL_SINK_AWS2S3_COMPONENT_ACCESS_KEY_CONF, ConfigDef.Type.PASSWORD, CAMEL_SINK_AWS2S3_COMPONENT_ACCESS_KEY_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SINK_AWS2S3_COMPONENT_ACCESS_KEY_DOC);
        conf.define(CAMEL_SINK_AWS2S3_COMPONENT_SECRET_KEY_CONF, ConfigDef.Type.PASSWORD, CAMEL_SINK_AWS2S3_COMPONENT_SECRET_KEY_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SINK_AWS2S3_COMPONENT_SECRET_KEY_DOC);
        return conf;
    }
}