/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.v1.kameletspec;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import io.fabric8.kubernetes.api.builder.Editable;
import io.fabric8.kubernetes.api.model.KubernetesResource;
import java.util.List;
import org.apache.camel.v1.kameletspec.SourcesBuilder;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonPropertyOrder(value={"compression", "content", "contentKey", "contentRef", "contentType", "from-kamelet", "interceptors", "language", "loader", "name", "path", "property-names", "rawContent", "type"})
@JsonDeserialize(using=JsonDeserializer.None.class)
public class Sources
implements Editable<SourcesBuilder>,
KubernetesResource {
    @JsonProperty(value="compression")
    @JsonPropertyDescription(value="if the content is compressed (base64 encrypted)")
    @JsonSetter(nulls=Nulls.SKIP)
    private Boolean compression;
    @JsonProperty(value="content")
    @JsonPropertyDescription(value="the source code (plain text)")
    @JsonSetter(nulls=Nulls.SKIP)
    private String content;
    @JsonProperty(value="contentKey")
    @JsonPropertyDescription(value="the confimap key holding the source content")
    @JsonSetter(nulls=Nulls.SKIP)
    private String contentKey;
    @JsonProperty(value="contentRef")
    @JsonPropertyDescription(value="the confimap reference holding the source content")
    @JsonSetter(nulls=Nulls.SKIP)
    private String contentRef;
    @JsonProperty(value="contentType")
    @JsonPropertyDescription(value="the content type (tipically text or binary)")
    @JsonSetter(nulls=Nulls.SKIP)
    private String contentType;
    @JsonProperty(value="from-kamelet")
    @JsonPropertyDescription(value="True if the spec is generated from a Kamelet")
    @JsonSetter(nulls=Nulls.SKIP)
    private Boolean fromKamelet;
    @JsonProperty(value="interceptors")
    @JsonPropertyDescription(value="Interceptors are optional identifiers the org.apache.camel.k.RoutesLoader\nuses to pre/post process sources\nDeprecated: no longer in use.")
    @JsonSetter(nulls=Nulls.SKIP)
    private List<String> interceptors;
    @JsonProperty(value="language")
    @JsonPropertyDescription(value="specify which is the language (Camel DSL) used to interpret this source code")
    @JsonSetter(nulls=Nulls.SKIP)
    private String language;
    @JsonProperty(value="loader")
    @JsonPropertyDescription(value="Loader is an optional id of the org.apache.camel.k.RoutesLoader that will\ninterpret this source at runtime")
    @JsonSetter(nulls=Nulls.SKIP)
    private String loader;
    @JsonProperty(value="name")
    @JsonPropertyDescription(value="the name of the specification")
    @JsonSetter(nulls=Nulls.SKIP)
    private String name;
    @JsonProperty(value="path")
    @JsonPropertyDescription(value="the path where the file is stored")
    @JsonSetter(nulls=Nulls.SKIP)
    private String path;
    @JsonProperty(value="property-names")
    @JsonPropertyDescription(value="List of property names defined in the source (e.g. if type is \"template\")")
    @JsonSetter(nulls=Nulls.SKIP)
    private List<String> propertyNames;
    @JsonProperty(value="rawContent")
    @JsonPropertyDescription(value="the source code (binary)")
    @JsonSetter(nulls=Nulls.SKIP)
    private String rawContent;
    @JsonProperty(value="type")
    @JsonPropertyDescription(value="Type defines the kind of source described by this object")
    @JsonSetter(nulls=Nulls.SKIP)
    private String type;

    public SourcesBuilder edit() {
        return new SourcesBuilder(this);
    }

    public Boolean getCompression() {
        return this.compression;
    }

    public void setCompression(Boolean compression) {
        this.compression = compression;
    }

    public String getContent() {
        return this.content;
    }

    public void setContent(String content) {
        this.content = content;
    }

    public String getContentKey() {
        return this.contentKey;
    }

    public void setContentKey(String contentKey) {
        this.contentKey = contentKey;
    }

    public String getContentRef() {
        return this.contentRef;
    }

    public void setContentRef(String contentRef) {
        this.contentRef = contentRef;
    }

    public String getContentType() {
        return this.contentType;
    }

    public void setContentType(String contentType) {
        this.contentType = contentType;
    }

    public Boolean getFromKamelet() {
        return this.fromKamelet;
    }

    public void setFromKamelet(Boolean fromKamelet) {
        this.fromKamelet = fromKamelet;
    }

    public List<String> getInterceptors() {
        return this.interceptors;
    }

    public void setInterceptors(List<String> interceptors) {
        this.interceptors = interceptors;
    }

    public String getLanguage() {
        return this.language;
    }

    public void setLanguage(String language) {
        this.language = language;
    }

    public String getLoader() {
        return this.loader;
    }

    public void setLoader(String loader) {
        this.loader = loader;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getPath() {
        return this.path;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public List<String> getPropertyNames() {
        return this.propertyNames;
    }

    public void setPropertyNames(List<String> propertyNames) {
        this.propertyNames = propertyNames;
    }

    public String getRawContent() {
        return this.rawContent;
    }

    public void setRawContent(String rawContent) {
        this.rawContent = rawContent;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public String toString() {
        return "Sources(compression=" + this.getCompression() + ", content=" + this.getContent() + ", contentKey=" + this.getContentKey() + ", contentRef=" + this.getContentRef() + ", contentType=" + this.getContentType() + ", fromKamelet=" + this.getFromKamelet() + ", interceptors=" + this.getInterceptors() + ", language=" + this.getLanguage() + ", loader=" + this.getLoader() + ", name=" + this.getName() + ", path=" + this.getPath() + ", propertyNames=" + this.getPropertyNames() + ", rawContent=" + this.getRawContent() + ", type=" + this.getType() + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Sources)) {
            return false;
        }
        Sources other = (Sources)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Boolean this$compression = this.getCompression();
        Boolean other$compression = other.getCompression();
        if (this$compression == null ? other$compression != null : !((Object)this$compression).equals(other$compression)) {
            return false;
        }
        Boolean this$fromKamelet = this.getFromKamelet();
        Boolean other$fromKamelet = other.getFromKamelet();
        if (this$fromKamelet == null ? other$fromKamelet != null : !((Object)this$fromKamelet).equals(other$fromKamelet)) {
            return false;
        }
        String this$content = this.getContent();
        String other$content = other.getContent();
        if (this$content == null ? other$content != null : !this$content.equals(other$content)) {
            return false;
        }
        String this$contentKey = this.getContentKey();
        String other$contentKey = other.getContentKey();
        if (this$contentKey == null ? other$contentKey != null : !this$contentKey.equals(other$contentKey)) {
            return false;
        }
        String this$contentRef = this.getContentRef();
        String other$contentRef = other.getContentRef();
        if (this$contentRef == null ? other$contentRef != null : !this$contentRef.equals(other$contentRef)) {
            return false;
        }
        String this$contentType = this.getContentType();
        String other$contentType = other.getContentType();
        if (this$contentType == null ? other$contentType != null : !this$contentType.equals(other$contentType)) {
            return false;
        }
        List<String> this$interceptors = this.getInterceptors();
        List<String> other$interceptors = other.getInterceptors();
        if (this$interceptors == null ? other$interceptors != null : !((Object)this$interceptors).equals(other$interceptors)) {
            return false;
        }
        String this$language = this.getLanguage();
        String other$language = other.getLanguage();
        if (this$language == null ? other$language != null : !this$language.equals(other$language)) {
            return false;
        }
        String this$loader = this.getLoader();
        String other$loader = other.getLoader();
        if (this$loader == null ? other$loader != null : !this$loader.equals(other$loader)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        String this$path = this.getPath();
        String other$path = other.getPath();
        if (this$path == null ? other$path != null : !this$path.equals(other$path)) {
            return false;
        }
        List<String> this$propertyNames = this.getPropertyNames();
        List<String> other$propertyNames = other.getPropertyNames();
        if (this$propertyNames == null ? other$propertyNames != null : !((Object)this$propertyNames).equals(other$propertyNames)) {
            return false;
        }
        String this$rawContent = this.getRawContent();
        String other$rawContent = other.getRawContent();
        if (this$rawContent == null ? other$rawContent != null : !this$rawContent.equals(other$rawContent)) {
            return false;
        }
        String this$type = this.getType();
        String other$type = other.getType();
        return !(this$type == null ? other$type != null : !this$type.equals(other$type));
    }

    protected boolean canEqual(Object other) {
        return other instanceof Sources;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Boolean $compression = this.getCompression();
        result = result * 59 + ($compression == null ? 43 : ((Object)$compression).hashCode());
        Boolean $fromKamelet = this.getFromKamelet();
        result = result * 59 + ($fromKamelet == null ? 43 : ((Object)$fromKamelet).hashCode());
        String $content = this.getContent();
        result = result * 59 + ($content == null ? 43 : $content.hashCode());
        String $contentKey = this.getContentKey();
        result = result * 59 + ($contentKey == null ? 43 : $contentKey.hashCode());
        String $contentRef = this.getContentRef();
        result = result * 59 + ($contentRef == null ? 43 : $contentRef.hashCode());
        String $contentType = this.getContentType();
        result = result * 59 + ($contentType == null ? 43 : $contentType.hashCode());
        List<String> $interceptors = this.getInterceptors();
        result = result * 59 + ($interceptors == null ? 43 : ((Object)$interceptors).hashCode());
        String $language = this.getLanguage();
        result = result * 59 + ($language == null ? 43 : $language.hashCode());
        String $loader = this.getLoader();
        result = result * 59 + ($loader == null ? 43 : $loader.hashCode());
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        String $path = this.getPath();
        result = result * 59 + ($path == null ? 43 : $path.hashCode());
        List<String> $propertyNames = this.getPropertyNames();
        result = result * 59 + ($propertyNames == null ? 43 : ((Object)$propertyNames).hashCode());
        String $rawContent = this.getRawContent();
        result = result * 59 + ($rawContent == null ? 43 : $rawContent.hashCode());
        String $type = this.getType();
        result = result * 59 + ($type == null ? 43 : $type.hashCode());
        return result;
    }
}

