/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.v1.pipespec.integration.traits;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import io.fabric8.kubernetes.api.model.KubernetesResource;
import java.util.List;
import org.apache.camel.v1.pipespec.integration.traits.knative.Configuration;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonPropertyOrder(value={"auto", "channelSinks", "channelSources", "config", "configuration", "enabled", "endpointSinks", "endpointSources", "eventSinks", "eventSources", "filterSourceChannels", "namespaceLabel", "sinkBinding"})
@JsonDeserialize(using=JsonDeserializer.None.class)
public class Knative
implements KubernetesResource {
    @JsonProperty(value="auto")
    @JsonPropertyDescription(value="Enable automatic discovery of all trait properties.")
    @JsonSetter(nulls=Nulls.SKIP)
    private Boolean auto;
    @JsonProperty(value="channelSinks")
    @JsonPropertyDescription(value="List of channels used as destination of integration routes. Can contain simple channel names or full Camel URIs.")
    @JsonSetter(nulls=Nulls.SKIP)
    private List<String> channelSinks;
    @JsonProperty(value="channelSources")
    @JsonPropertyDescription(value="List of channels used as source of integration routes. Can contain simple channel names or full Camel URIs.")
    @JsonSetter(nulls=Nulls.SKIP)
    private List<String> channelSources;
    @JsonProperty(value="config")
    @JsonPropertyDescription(value="Can be used to inject a Knative complete configuration in JSON format.")
    @JsonSetter(nulls=Nulls.SKIP)
    private String config;
    @JsonProperty(value="configuration")
    @JsonPropertyDescription(value="Legacy trait configuration parameters. Deprecated: for backward compatibility.")
    @JsonSetter(nulls=Nulls.SKIP)
    private Configuration configuration;
    @JsonProperty(value="enabled")
    @JsonPropertyDescription(value="Can be used to enable or disable a trait. All traits share this common property.")
    @JsonSetter(nulls=Nulls.SKIP)
    private Boolean enabled;
    @JsonProperty(value="endpointSinks")
    @JsonPropertyDescription(value="List of endpoints used as destination of integration routes. Can contain simple endpoint names or full Camel URIs.")
    @JsonSetter(nulls=Nulls.SKIP)
    private List<String> endpointSinks;
    @JsonProperty(value="endpointSources")
    @JsonPropertyDescription(value="List of channels used as source of integration routes.")
    @JsonSetter(nulls=Nulls.SKIP)
    private List<String> endpointSources;
    @JsonProperty(value="eventSinks")
    @JsonPropertyDescription(value="List of event types that the integration will produce. Can contain simple event types or full Camel URIs (to use a specific broker).")
    @JsonSetter(nulls=Nulls.SKIP)
    private List<String> eventSinks;
    @JsonProperty(value="eventSources")
    @JsonPropertyDescription(value="List of event types that the integration will be subscribed to. Can contain simple event types or full Camel URIs (to use a specific broker different from \"default\").")
    @JsonSetter(nulls=Nulls.SKIP)
    private List<String> eventSources;
    @JsonProperty(value="filterSourceChannels")
    @JsonPropertyDescription(value="Enables filtering on events based on the header \"ce-knativehistory\". Since this header has been removed in newer versions of Knative, filtering is disabled by default.")
    @JsonSetter(nulls=Nulls.SKIP)
    private Boolean filterSourceChannels;
    @JsonProperty(value="namespaceLabel")
    @JsonPropertyDescription(value="Enables the camel-k-operator to set the \"bindings.knative.dev/include=true\" label to the namespace As Knative requires this label to perform injection of K_SINK URL into the service. If this is false, the integration pod may start and fail, read the SinkBinding Knative documentation. (default: true)")
    @JsonSetter(nulls=Nulls.SKIP)
    private Boolean namespaceLabel;
    @JsonProperty(value="sinkBinding")
    @JsonPropertyDescription(value="Allows binding the integration to a sink via a Knative SinkBinding resource. This can be used when the integration targets a single sink. It's enabled by default when the integration targets a single sink (except when the integration is owned by a Knative source).")
    @JsonSetter(nulls=Nulls.SKIP)
    private Boolean sinkBinding;

    public Boolean getAuto() {
        return this.auto;
    }

    public void setAuto(Boolean auto) {
        this.auto = auto;
    }

    public List<String> getChannelSinks() {
        return this.channelSinks;
    }

    public void setChannelSinks(List<String> channelSinks) {
        this.channelSinks = channelSinks;
    }

    public List<String> getChannelSources() {
        return this.channelSources;
    }

    public void setChannelSources(List<String> channelSources) {
        this.channelSources = channelSources;
    }

    public String getConfig() {
        return this.config;
    }

    public void setConfig(String config) {
        this.config = config;
    }

    public Configuration getConfiguration() {
        return this.configuration;
    }

    public void setConfiguration(Configuration configuration) {
        this.configuration = configuration;
    }

    public Boolean getEnabled() {
        return this.enabled;
    }

    public void setEnabled(Boolean enabled) {
        this.enabled = enabled;
    }

    public List<String> getEndpointSinks() {
        return this.endpointSinks;
    }

    public void setEndpointSinks(List<String> endpointSinks) {
        this.endpointSinks = endpointSinks;
    }

    public List<String> getEndpointSources() {
        return this.endpointSources;
    }

    public void setEndpointSources(List<String> endpointSources) {
        this.endpointSources = endpointSources;
    }

    public List<String> getEventSinks() {
        return this.eventSinks;
    }

    public void setEventSinks(List<String> eventSinks) {
        this.eventSinks = eventSinks;
    }

    public List<String> getEventSources() {
        return this.eventSources;
    }

    public void setEventSources(List<String> eventSources) {
        this.eventSources = eventSources;
    }

    public Boolean getFilterSourceChannels() {
        return this.filterSourceChannels;
    }

    public void setFilterSourceChannels(Boolean filterSourceChannels) {
        this.filterSourceChannels = filterSourceChannels;
    }

    public Boolean getNamespaceLabel() {
        return this.namespaceLabel;
    }

    public void setNamespaceLabel(Boolean namespaceLabel) {
        this.namespaceLabel = namespaceLabel;
    }

    public Boolean getSinkBinding() {
        return this.sinkBinding;
    }

    public void setSinkBinding(Boolean sinkBinding) {
        this.sinkBinding = sinkBinding;
    }
}

