/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.v1.pipespec.integration.traits;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import io.fabric8.kubernetes.api.model.KubernetesResource;
import java.util.List;
import org.apache.camel.v1.pipespec.integration.traits.jolokia.Configuration;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonPropertyOrder(value={"CACert", "clientPrincipal", "configuration", "discoveryEnabled", "enabled", "extendedClientCheck", "host", "options", "password", "port", "protocol", "useSSLClientAuthentication", "user"})
@JsonDeserialize(using=JsonDeserializer.None.class)
public class Jolokia
implements KubernetesResource {
    @JsonProperty(value="CACert")
    @JsonPropertyDescription(value="The PEM encoded CA certification file path, used to verify client certificates, applicable when `protocol` is `https` and `use-ssl-client-authentication` is `true` (default `/var/run/secrets/kubernetes.io/serviceaccount/service-ca.crt` for OpenShift).")
    @JsonSetter(nulls=Nulls.SKIP)
    private String CACert;
    @JsonProperty(value="clientPrincipal")
    @JsonPropertyDescription(value="The principal(s) which must be given in a client certificate to allow access to the Jolokia endpoint, applicable when `protocol` is `https` and `use-ssl-client-authentication` is `true` (default `clientPrincipal=cn=system:master-proxy`, `cn=hawtio-online.hawtio.svc` and `cn=fuse-console.fuse.svc` for OpenShift).")
    @JsonSetter(nulls=Nulls.SKIP)
    private List<String> clientPrincipal;
    @JsonProperty(value="configuration")
    @JsonPropertyDescription(value="Legacy trait configuration parameters. Deprecated: for backward compatibility.")
    @JsonSetter(nulls=Nulls.SKIP)
    private Configuration configuration;
    @JsonProperty(value="discoveryEnabled")
    @JsonPropertyDescription(value="Listen for multicast requests (default `false`)")
    @JsonSetter(nulls=Nulls.SKIP)
    private Boolean discoveryEnabled;
    @JsonProperty(value="enabled")
    @JsonPropertyDescription(value="Can be used to enable or disable a trait. All traits share this common property.")
    @JsonSetter(nulls=Nulls.SKIP)
    private Boolean enabled;
    @JsonProperty(value="extendedClientCheck")
    @JsonPropertyDescription(value="Mandate the client certificate contains a client flag in the extended key usage section, applicable when `protocol` is `https` and `use-ssl-client-authentication` is `true` (default `true` for OpenShift).")
    @JsonSetter(nulls=Nulls.SKIP)
    private Boolean extendedClientCheck;
    @JsonProperty(value="host")
    @JsonPropertyDescription(value="The Host address to which the Jolokia agent should bind to. If `\"\\*\"` or `\"0.0.0.0\"` is given, the servers binds to every network interface (default `\"*\"`).")
    @JsonSetter(nulls=Nulls.SKIP)
    private String host;
    @JsonProperty(value="options")
    @JsonPropertyDescription(value="A list of additional Jolokia options as defined in https://jolokia.org/reference/html/agents.html#agent-jvm-config[JVM agent configuration options]")
    @JsonSetter(nulls=Nulls.SKIP)
    private List<String> options;
    @JsonProperty(value="password")
    @JsonPropertyDescription(value="The password used for authentication, applicable when the `user` option is set.")
    @JsonSetter(nulls=Nulls.SKIP)
    private String password;
    @JsonProperty(value="port")
    @JsonPropertyDescription(value="The Jolokia endpoint port (default `8778`).")
    @JsonSetter(nulls=Nulls.SKIP)
    private Long port;
    @JsonProperty(value="protocol")
    @JsonPropertyDescription(value="The protocol to use, either `http` or `https` (default `https` for OpenShift)")
    @JsonSetter(nulls=Nulls.SKIP)
    private String protocol;
    @JsonProperty(value="useSSLClientAuthentication")
    @JsonPropertyDescription(value="Whether client certificates should be used for authentication (default `true` for OpenShift).")
    @JsonSetter(nulls=Nulls.SKIP)
    private Boolean useSSLClientAuthentication;
    @JsonProperty(value="user")
    @JsonPropertyDescription(value="The user to be used for authentication")
    @JsonSetter(nulls=Nulls.SKIP)
    private String user;

    public String getCACert() {
        return this.CACert;
    }

    public void setCACert(String CACert) {
        this.CACert = CACert;
    }

    public List<String> getClientPrincipal() {
        return this.clientPrincipal;
    }

    public void setClientPrincipal(List<String> clientPrincipal) {
        this.clientPrincipal = clientPrincipal;
    }

    public Configuration getConfiguration() {
        return this.configuration;
    }

    public void setConfiguration(Configuration configuration) {
        this.configuration = configuration;
    }

    public Boolean getDiscoveryEnabled() {
        return this.discoveryEnabled;
    }

    public void setDiscoveryEnabled(Boolean discoveryEnabled) {
        this.discoveryEnabled = discoveryEnabled;
    }

    public Boolean getEnabled() {
        return this.enabled;
    }

    public void setEnabled(Boolean enabled) {
        this.enabled = enabled;
    }

    public Boolean getExtendedClientCheck() {
        return this.extendedClientCheck;
    }

    public void setExtendedClientCheck(Boolean extendedClientCheck) {
        this.extendedClientCheck = extendedClientCheck;
    }

    public String getHost() {
        return this.host;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public List<String> getOptions() {
        return this.options;
    }

    public void setOptions(List<String> options) {
        this.options = options;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public Long getPort() {
        return this.port;
    }

    public void setPort(Long port) {
        this.port = port;
    }

    public String getProtocol() {
        return this.protocol;
    }

    public void setProtocol(String protocol) {
        this.protocol = protocol;
    }

    public Boolean getUseSSLClientAuthentication() {
        return this.useSSLClientAuthentication;
    }

    public void setUseSSLClientAuthentication(Boolean useSSLClientAuthentication) {
        this.useSSLClientAuthentication = useSSLClientAuthentication;
    }

    public String getUser() {
        return this.user;
    }

    public void setUser(String user) {
        this.user = user;
    }
}

