/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.v1.pipespec.integration.template.spec.volumes;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import io.fabric8.generator.annotation.Required;
import io.fabric8.kubernetes.api.model.KubernetesResource;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonPropertyOrder(value={"fsType", "partition", "pdName", "readOnly"})
@JsonDeserialize(using=JsonDeserializer.None.class)
public class GcePersistentDisk
implements KubernetesResource {
    @JsonProperty(value="fsType")
    @JsonPropertyDescription(value="fsType is filesystem type of the volume that you want to mount. Tip: Ensure that the filesystem type is supported by the host operating system. Examples: \"ext4\", \"xfs\", \"ntfs\". Implicitly inferred to be \"ext4\" if unspecified. More info: https://kubernetes.io/docs/concepts/storage/volumes#gcepersistentdisk TODO: how do we prevent errors in the filesystem from compromising the machine")
    @JsonSetter(nulls=Nulls.SKIP)
    private String fsType;
    @JsonProperty(value="partition")
    @JsonPropertyDescription(value="partition is the partition in the volume that you want to mount. If omitted, the default is to mount by volume name. Examples: For volume /dev/sda1, you specify the partition as \"1\". Similarly, the volume partition for /dev/sda is \"0\" (or you can leave the property empty). More info: https://kubernetes.io/docs/concepts/storage/volumes#gcepersistentdisk")
    @JsonSetter(nulls=Nulls.SKIP)
    private Integer partition;
    @JsonProperty(value="pdName")
    @Required
    @JsonPropertyDescription(value="pdName is unique name of the PD resource in GCE. Used to identify the disk in GCE. More info: https://kubernetes.io/docs/concepts/storage/volumes#gcepersistentdisk")
    @JsonSetter(nulls=Nulls.SKIP)
    private String pdName;
    @JsonProperty(value="readOnly")
    @JsonPropertyDescription(value="readOnly here will force the ReadOnly setting in VolumeMounts. Defaults to false. More info: https://kubernetes.io/docs/concepts/storage/volumes#gcepersistentdisk")
    @JsonSetter(nulls=Nulls.SKIP)
    private Boolean readOnly;

    public String getFsType() {
        return this.fsType;
    }

    public void setFsType(String fsType) {
        this.fsType = fsType;
    }

    public Integer getPartition() {
        return this.partition;
    }

    public void setPartition(Integer partition) {
        this.partition = partition;
    }

    public String getPdName() {
        return this.pdName;
    }

    public void setPdName(String pdName) {
        this.pdName = pdName;
    }

    public Boolean getReadOnly() {
        return this.readOnly;
    }

    public void setReadOnly(Boolean readOnly) {
        this.readOnly = readOnly;
    }
}

