/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.v1.integrationplatformspec;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import io.fabric8.kubernetes.api.model.KubernetesResource;
import java.util.Map;
import org.apache.camel.v1.integrationplatformspec.build.BuildConfiguration;
import org.apache.camel.v1.integrationplatformspec.build.Maven;
import org.apache.camel.v1.integrationplatformspec.build.Registry;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonPropertyOrder(value={"PublishStrategyOptions", "baseImage", "buildCatalogToolTimeout", "buildConfiguration", "maven", "maxRunningBuilds", "publishStrategy", "registry", "runtimeProvider", "runtimeVersion", "timeout"})
@JsonDeserialize(using=JsonDeserializer.None.class)
public class Build
implements KubernetesResource {
    @JsonProperty(value="PublishStrategyOptions")
    @JsonPropertyDescription(value="Generic options that can used by any publish strategy")
    @JsonSetter(nulls=Nulls.SKIP)
    private Map<String, String> PublishStrategyOptions;
    @JsonProperty(value="baseImage")
    @JsonPropertyDescription(value="a base image that can be used as base layer for all images. It can be useful if you want to provide some custom base image with further utility softwares")
    @JsonSetter(nulls=Nulls.SKIP)
    private String baseImage;
    @JsonProperty(value="buildCatalogToolTimeout")
    @JsonPropertyDescription(value="the timeout (in seconds) to use when creating the build tools container image")
    @JsonSetter(nulls=Nulls.SKIP)
    private String buildCatalogToolTimeout;
    @JsonProperty(value="buildConfiguration")
    @JsonPropertyDescription(value="the configuration required to build an Integration container image")
    @JsonSetter(nulls=Nulls.SKIP)
    private BuildConfiguration buildConfiguration;
    @JsonProperty(value="maven")
    @JsonPropertyDescription(value="Maven configuration used to build the Camel/Camel-Quarkus applications")
    @JsonSetter(nulls=Nulls.SKIP)
    private Maven maven;
    @JsonProperty(value="maxRunningBuilds")
    @JsonPropertyDescription(value="the maximum amount of parallel running pipelines started by this operator instance")
    @JsonSetter(nulls=Nulls.SKIP)
    private Integer maxRunningBuilds;
    @JsonProperty(value="publishStrategy")
    @JsonPropertyDescription(value="the strategy to adopt for publishing an Integration container image")
    @JsonSetter(nulls=Nulls.SKIP)
    private String publishStrategy;
    @JsonProperty(value="registry")
    @JsonPropertyDescription(value="the image registry used to push/pull Integration images")
    @JsonSetter(nulls=Nulls.SKIP)
    private Registry registry;
    @JsonProperty(value="runtimeProvider")
    @JsonPropertyDescription(value="the runtime used. Likely Camel Quarkus (we used to have main runtime which has been discontinued since version 1.5)")
    @JsonSetter(nulls=Nulls.SKIP)
    private String runtimeProvider;
    @JsonProperty(value="runtimeVersion")
    @JsonPropertyDescription(value="the Camel K Runtime dependency version")
    @JsonSetter(nulls=Nulls.SKIP)
    private String runtimeVersion;
    @JsonProperty(value="timeout")
    @JsonPropertyDescription(value="how much time to wait before time out the pipeline process")
    @JsonSetter(nulls=Nulls.SKIP)
    private String timeout;

    public Map<String, String> getPublishStrategyOptions() {
        return this.PublishStrategyOptions;
    }

    public void setPublishStrategyOptions(Map<String, String> PublishStrategyOptions) {
        this.PublishStrategyOptions = PublishStrategyOptions;
    }

    public String getBaseImage() {
        return this.baseImage;
    }

    public void setBaseImage(String baseImage) {
        this.baseImage = baseImage;
    }

    public String getBuildCatalogToolTimeout() {
        return this.buildCatalogToolTimeout;
    }

    public void setBuildCatalogToolTimeout(String buildCatalogToolTimeout) {
        this.buildCatalogToolTimeout = buildCatalogToolTimeout;
    }

    public BuildConfiguration getBuildConfiguration() {
        return this.buildConfiguration;
    }

    public void setBuildConfiguration(BuildConfiguration buildConfiguration) {
        this.buildConfiguration = buildConfiguration;
    }

    public Maven getMaven() {
        return this.maven;
    }

    public void setMaven(Maven maven) {
        this.maven = maven;
    }

    public Integer getMaxRunningBuilds() {
        return this.maxRunningBuilds;
    }

    public void setMaxRunningBuilds(Integer maxRunningBuilds) {
        this.maxRunningBuilds = maxRunningBuilds;
    }

    public String getPublishStrategy() {
        return this.publishStrategy;
    }

    public void setPublishStrategy(String publishStrategy) {
        this.publishStrategy = publishStrategy;
    }

    public Registry getRegistry() {
        return this.registry;
    }

    public void setRegistry(Registry registry) {
        this.registry = registry;
    }

    public String getRuntimeProvider() {
        return this.runtimeProvider;
    }

    public void setRuntimeProvider(String runtimeProvider) {
        this.runtimeProvider = runtimeProvider;
    }

    public String getRuntimeVersion() {
        return this.runtimeVersion;
    }

    public void setRuntimeVersion(String runtimeVersion) {
        this.runtimeVersion = runtimeVersion;
    }

    public String getTimeout() {
        return this.timeout;
    }

    public void setTimeout(String timeout) {
        this.timeout = timeout;
    }
}

