/*
Licensed to the Apache Software Foundation (ASF) under one or more
contributor license agreements.  See the NOTICE file distributed with
this work for additional information regarding copyright ownership.
The ASF licenses this file to You under the Apache License, Version 2.0
(the "License"); you may not use this file except in compliance with
the License.  You may obtain a copy of the License at

   http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

// Code generated by client-gen. DO NOT EDIT.

package fake

import (
	"context"
	json "encoding/json"
	"fmt"

	camelv1 "github.com/apache/camel-k/v2/pkg/apis/camel/v1"
	applyconfigurationcamelv1 "github.com/apache/camel-k/v2/pkg/client/camel/applyconfiguration/camel/v1"
	autoscalingv1 "k8s.io/api/autoscaling/v1"
	v1 "k8s.io/apimachinery/pkg/apis/meta/v1"
	labels "k8s.io/apimachinery/pkg/labels"
	schema "k8s.io/apimachinery/pkg/runtime/schema"
	types "k8s.io/apimachinery/pkg/types"
	watch "k8s.io/apimachinery/pkg/watch"
	testing "k8s.io/client-go/testing"
)

// FakePipes implements PipeInterface
type FakePipes struct {
	Fake *FakeCamelV1
	ns   string
}

var pipesResource = schema.GroupVersionResource{Group: "camel.apache.org", Version: "v1", Resource: "pipes"}

var pipesKind = schema.GroupVersionKind{Group: "camel.apache.org", Version: "v1", Kind: "Pipe"}

// Get takes name of the pipe, and returns the corresponding pipe object, and an error if there is any.
func (c *FakePipes) Get(ctx context.Context, name string, options v1.GetOptions) (result *camelv1.Pipe, err error) {
	obj, err := c.Fake.
		Invokes(testing.NewGetAction(pipesResource, c.ns, name), &camelv1.Pipe{})

	if obj == nil {
		return nil, err
	}
	return obj.(*camelv1.Pipe), err
}

// List takes label and field selectors, and returns the list of Pipes that match those selectors.
func (c *FakePipes) List(ctx context.Context, opts v1.ListOptions) (result *camelv1.PipeList, err error) {
	obj, err := c.Fake.
		Invokes(testing.NewListAction(pipesResource, pipesKind, c.ns, opts), &camelv1.PipeList{})

	if obj == nil {
		return nil, err
	}

	label, _, _ := testing.ExtractFromListOptions(opts)
	if label == nil {
		label = labels.Everything()
	}
	list := &camelv1.PipeList{ListMeta: obj.(*camelv1.PipeList).ListMeta}
	for _, item := range obj.(*camelv1.PipeList).Items {
		if label.Matches(labels.Set(item.Labels)) {
			list.Items = append(list.Items, item)
		}
	}
	return list, err
}

// Watch returns a watch.Interface that watches the requested pipes.
func (c *FakePipes) Watch(ctx context.Context, opts v1.ListOptions) (watch.Interface, error) {
	return c.Fake.
		InvokesWatch(testing.NewWatchAction(pipesResource, c.ns, opts))

}

// Create takes the representation of a pipe and creates it.  Returns the server's representation of the pipe, and an error, if there is any.
func (c *FakePipes) Create(ctx context.Context, pipe *camelv1.Pipe, opts v1.CreateOptions) (result *camelv1.Pipe, err error) {
	obj, err := c.Fake.
		Invokes(testing.NewCreateAction(pipesResource, c.ns, pipe), &camelv1.Pipe{})

	if obj == nil {
		return nil, err
	}
	return obj.(*camelv1.Pipe), err
}

// Update takes the representation of a pipe and updates it. Returns the server's representation of the pipe, and an error, if there is any.
func (c *FakePipes) Update(ctx context.Context, pipe *camelv1.Pipe, opts v1.UpdateOptions) (result *camelv1.Pipe, err error) {
	obj, err := c.Fake.
		Invokes(testing.NewUpdateAction(pipesResource, c.ns, pipe), &camelv1.Pipe{})

	if obj == nil {
		return nil, err
	}
	return obj.(*camelv1.Pipe), err
}

// UpdateStatus was generated because the type contains a Status member.
// Add a +genclient:noStatus comment above the type to avoid generating UpdateStatus().
func (c *FakePipes) UpdateStatus(ctx context.Context, pipe *camelv1.Pipe, opts v1.UpdateOptions) (*camelv1.Pipe, error) {
	obj, err := c.Fake.
		Invokes(testing.NewUpdateSubresourceAction(pipesResource, "status", c.ns, pipe), &camelv1.Pipe{})

	if obj == nil {
		return nil, err
	}
	return obj.(*camelv1.Pipe), err
}

// Delete takes name of the pipe and deletes it. Returns an error if one occurs.
func (c *FakePipes) Delete(ctx context.Context, name string, opts v1.DeleteOptions) error {
	_, err := c.Fake.
		Invokes(testing.NewDeleteActionWithOptions(pipesResource, c.ns, name, opts), &camelv1.Pipe{})

	return err
}

// DeleteCollection deletes a collection of objects.
func (c *FakePipes) DeleteCollection(ctx context.Context, opts v1.DeleteOptions, listOpts v1.ListOptions) error {
	action := testing.NewDeleteCollectionAction(pipesResource, c.ns, listOpts)

	_, err := c.Fake.Invokes(action, &camelv1.PipeList{})
	return err
}

// Patch applies the patch and returns the patched pipe.
func (c *FakePipes) Patch(ctx context.Context, name string, pt types.PatchType, data []byte, opts v1.PatchOptions, subresources ...string) (result *camelv1.Pipe, err error) {
	obj, err := c.Fake.
		Invokes(testing.NewPatchSubresourceAction(pipesResource, c.ns, name, pt, data, subresources...), &camelv1.Pipe{})

	if obj == nil {
		return nil, err
	}
	return obj.(*camelv1.Pipe), err
}

// Apply takes the given apply declarative configuration, applies it and returns the applied pipe.
func (c *FakePipes) Apply(ctx context.Context, pipe *applyconfigurationcamelv1.PipeApplyConfiguration, opts v1.ApplyOptions) (result *camelv1.Pipe, err error) {
	if pipe == nil {
		return nil, fmt.Errorf("pipe provided to Apply must not be nil")
	}
	data, err := json.Marshal(pipe)
	if err != nil {
		return nil, err
	}
	name := pipe.Name
	if name == nil {
		return nil, fmt.Errorf("pipe.Name must be provided to Apply")
	}
	obj, err := c.Fake.
		Invokes(testing.NewPatchSubresourceAction(pipesResource, c.ns, *name, types.ApplyPatchType, data), &camelv1.Pipe{})

	if obj == nil {
		return nil, err
	}
	return obj.(*camelv1.Pipe), err
}

// ApplyStatus was generated because the type contains a Status member.
// Add a +genclient:noStatus comment above the type to avoid generating ApplyStatus().
func (c *FakePipes) ApplyStatus(ctx context.Context, pipe *applyconfigurationcamelv1.PipeApplyConfiguration, opts v1.ApplyOptions) (result *camelv1.Pipe, err error) {
	if pipe == nil {
		return nil, fmt.Errorf("pipe provided to Apply must not be nil")
	}
	data, err := json.Marshal(pipe)
	if err != nil {
		return nil, err
	}
	name := pipe.Name
	if name == nil {
		return nil, fmt.Errorf("pipe.Name must be provided to Apply")
	}
	obj, err := c.Fake.
		Invokes(testing.NewPatchSubresourceAction(pipesResource, c.ns, *name, types.ApplyPatchType, data, "status"), &camelv1.Pipe{})

	if obj == nil {
		return nil, err
	}
	return obj.(*camelv1.Pipe), err
}

// GetScale takes name of the pipe, and returns the corresponding scale object, and an error if there is any.
func (c *FakePipes) GetScale(ctx context.Context, pipeName string, options v1.GetOptions) (result *autoscalingv1.Scale, err error) {
	obj, err := c.Fake.
		Invokes(testing.NewGetSubresourceAction(pipesResource, c.ns, "scale", pipeName), &autoscalingv1.Scale{})

	if obj == nil {
		return nil, err
	}
	return obj.(*autoscalingv1.Scale), err
}

// UpdateScale takes the representation of a scale and updates it. Returns the server's representation of the scale, and an error, if there is any.
func (c *FakePipes) UpdateScale(ctx context.Context, pipeName string, scale *autoscalingv1.Scale, opts v1.UpdateOptions) (result *autoscalingv1.Scale, err error) {
	obj, err := c.Fake.
		Invokes(testing.NewUpdateSubresourceAction(pipesResource, "scale", c.ns, scale), &autoscalingv1.Scale{})

	if obj == nil {
		return nil, err
	}
	return obj.(*autoscalingv1.Scale), err
}
