/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.v1.pipespec.integration.template.spec;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import io.fabric8.generator.annotation.Required;
import io.fabric8.kubernetes.api.model.KubernetesResource;
import java.util.List;
import org.apache.camel.v1.pipespec.integration.template.spec.ephemeralcontainers.Env;
import org.apache.camel.v1.pipespec.integration.template.spec.ephemeralcontainers.EnvFrom;
import org.apache.camel.v1.pipespec.integration.template.spec.ephemeralcontainers.Lifecycle;
import org.apache.camel.v1.pipespec.integration.template.spec.ephemeralcontainers.LivenessProbe;
import org.apache.camel.v1.pipespec.integration.template.spec.ephemeralcontainers.Ports;
import org.apache.camel.v1.pipespec.integration.template.spec.ephemeralcontainers.ReadinessProbe;
import org.apache.camel.v1.pipespec.integration.template.spec.ephemeralcontainers.Resources;
import org.apache.camel.v1.pipespec.integration.template.spec.ephemeralcontainers.SecurityContext;
import org.apache.camel.v1.pipespec.integration.template.spec.ephemeralcontainers.StartupProbe;
import org.apache.camel.v1.pipespec.integration.template.spec.ephemeralcontainers.VolumeDevices;
import org.apache.camel.v1.pipespec.integration.template.spec.ephemeralcontainers.VolumeMounts;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonPropertyOrder(value={"args", "command", "env", "envFrom", "image", "imagePullPolicy", "lifecycle", "livenessProbe", "name", "ports", "readinessProbe", "resources", "securityContext", "startupProbe", "stdin", "stdinOnce", "targetContainerName", "terminationMessagePath", "terminationMessagePolicy", "tty", "volumeDevices", "volumeMounts", "workingDir"})
@JsonDeserialize(using=JsonDeserializer.None.class)
public class EphemeralContainers
implements KubernetesResource {
    @JsonProperty(value="args")
    @JsonPropertyDescription(value="Arguments to the entrypoint. The image's CMD is used if this is not provided. Variable references $(VAR_NAME) are expanded using the container's environment. If a variable cannot be resolved, the reference in the input string will be unchanged. Double $$ are reduced to a single $, which allows for escaping the $(VAR_NAME) syntax: i.e. \"$$(VAR_NAME)\" will produce the string literal \"$(VAR_NAME)\". Escaped references will never be expanded, regardless of whether the variable exists or not. Cannot be updated. More info: https://kubernetes.io/docs/tasks/inject-data-application/define-command-argument-container/#running-a-command-in-a-shell")
    @JsonSetter(nulls=Nulls.SKIP)
    private List<String> args;
    @JsonProperty(value="command")
    @JsonPropertyDescription(value="Entrypoint array. Not executed within a shell. The image's ENTRYPOINT is used if this is not provided. Variable references $(VAR_NAME) are expanded using the container's environment. If a variable cannot be resolved, the reference in the input string will be unchanged. Double $$ are reduced to a single $, which allows for escaping the $(VAR_NAME) syntax: i.e. \"$$(VAR_NAME)\" will produce the string literal \"$(VAR_NAME)\". Escaped references will never be expanded, regardless of whether the variable exists or not. Cannot be updated. More info: https://kubernetes.io/docs/tasks/inject-data-application/define-command-argument-container/#running-a-command-in-a-shell")
    @JsonSetter(nulls=Nulls.SKIP)
    private List<String> command;
    @JsonProperty(value="env")
    @JsonPropertyDescription(value="List of environment variables to set in the container. Cannot be updated.")
    @JsonSetter(nulls=Nulls.SKIP)
    private List<Env> env;
    @JsonProperty(value="envFrom")
    @JsonPropertyDescription(value="List of sources to populate environment variables in the container. The keys defined within a source must be a C_IDENTIFIER. All invalid keys will be reported as an event when the container is starting. When a key exists in multiple sources, the value associated with the last source will take precedence. Values defined by an Env with a duplicate key will take precedence. Cannot be updated.")
    @JsonSetter(nulls=Nulls.SKIP)
    private List<EnvFrom> envFrom;
    @JsonProperty(value="image")
    @JsonPropertyDescription(value="Container image name. More info: https://kubernetes.io/docs/concepts/containers/images")
    @JsonSetter(nulls=Nulls.SKIP)
    private String image;
    @JsonProperty(value="imagePullPolicy")
    @JsonPropertyDescription(value="Image pull policy. One of Always, Never, IfNotPresent. Defaults to Always if :latest tag is specified, or IfNotPresent otherwise. Cannot be updated. More info: https://kubernetes.io/docs/concepts/containers/images#updating-images")
    @JsonSetter(nulls=Nulls.SKIP)
    private String imagePullPolicy;
    @JsonProperty(value="lifecycle")
    @JsonPropertyDescription(value="Lifecycle is not allowed for ephemeral containers.")
    @JsonSetter(nulls=Nulls.SKIP)
    private Lifecycle lifecycle;
    @JsonProperty(value="livenessProbe")
    @JsonPropertyDescription(value="Probes are not allowed for ephemeral containers.")
    @JsonSetter(nulls=Nulls.SKIP)
    private LivenessProbe livenessProbe;
    @JsonProperty(value="name")
    @Required
    @JsonPropertyDescription(value="Name of the ephemeral container specified as a DNS_LABEL. This name must be unique among all containers, init containers and ephemeral containers.")
    @JsonSetter(nulls=Nulls.SKIP)
    private String name;
    @JsonProperty(value="ports")
    @JsonPropertyDescription(value="Ports are not allowed for ephemeral containers.")
    @JsonSetter(nulls=Nulls.SKIP)
    private List<Ports> ports;
    @JsonProperty(value="readinessProbe")
    @JsonPropertyDescription(value="Probes are not allowed for ephemeral containers.")
    @JsonSetter(nulls=Nulls.SKIP)
    private ReadinessProbe readinessProbe;
    @JsonProperty(value="resources")
    @JsonPropertyDescription(value="Resources are not allowed for ephemeral containers. Ephemeral containers use spare resources already allocated to the pod.")
    @JsonSetter(nulls=Nulls.SKIP)
    private Resources resources;
    @JsonProperty(value="securityContext")
    @JsonPropertyDescription(value="Optional: SecurityContext defines the security options the ephemeral container should be run with. If set, the fields of SecurityContext override the equivalent fields of PodSecurityContext.")
    @JsonSetter(nulls=Nulls.SKIP)
    private SecurityContext securityContext;
    @JsonProperty(value="startupProbe")
    @JsonPropertyDescription(value="Probes are not allowed for ephemeral containers.")
    @JsonSetter(nulls=Nulls.SKIP)
    private StartupProbe startupProbe;
    @JsonProperty(value="stdin")
    @JsonPropertyDescription(value="Whether this container should allocate a buffer for stdin in the container runtime. If this is not set, reads from stdin in the container will always result in EOF. Default is false.")
    @JsonSetter(nulls=Nulls.SKIP)
    private Boolean stdin;
    @JsonProperty(value="stdinOnce")
    @JsonPropertyDescription(value="Whether the container runtime should close the stdin channel after it has been opened by a single attach. When stdin is true the stdin stream will remain open across multiple attach sessions. If stdinOnce is set to true, stdin is opened on container start, is empty until the first client attaches to stdin, and then remains open and accepts data until the client disconnects, at which time stdin is closed and remains closed until the container is restarted. If this flag is false, a container processes that reads from stdin will never receive an EOF. Default is false")
    @JsonSetter(nulls=Nulls.SKIP)
    private Boolean stdinOnce;
    @JsonProperty(value="targetContainerName")
    @JsonPropertyDescription(value="If set, the name of the container from PodSpec that this ephemeral container targets. The ephemeral container will be run in the namespaces (IPC, PID, etc) of this container. If not set then the ephemeral container uses the namespaces configured in the Pod spec. \n The container runtime must implement support for this feature. If the runtime does not support namespace targeting then the result of setting this field is undefined.")
    @JsonSetter(nulls=Nulls.SKIP)
    private String targetContainerName;
    @JsonProperty(value="terminationMessagePath")
    @JsonPropertyDescription(value="Optional: Path at which the file to which the container's termination message will be written is mounted into the container's filesystem. Message written is intended to be brief final status, such as an assertion failure message. Will be truncated by the node if greater than 4096 bytes. The total message length across all containers will be limited to 12kb. Defaults to /dev/termination-log. Cannot be updated.")
    @JsonSetter(nulls=Nulls.SKIP)
    private String terminationMessagePath;
    @JsonProperty(value="terminationMessagePolicy")
    @JsonPropertyDescription(value="Indicate how the termination message should be populated. File will use the contents of terminationMessagePath to populate the container status message on both success and failure. FallbackToLogsOnError will use the last chunk of container log output if the termination message file is empty and the container exited with an error. The log output is limited to 2048 bytes or 80 lines, whichever is smaller. Defaults to File. Cannot be updated.")
    @JsonSetter(nulls=Nulls.SKIP)
    private String terminationMessagePolicy;
    @JsonProperty(value="tty")
    @JsonPropertyDescription(value="Whether this container should allocate a TTY for itself, also requires 'stdin' to be true. Default is false.")
    @JsonSetter(nulls=Nulls.SKIP)
    private Boolean tty;
    @JsonProperty(value="volumeDevices")
    @JsonPropertyDescription(value="volumeDevices is the list of block devices to be used by the container.")
    @JsonSetter(nulls=Nulls.SKIP)
    private List<VolumeDevices> volumeDevices;
    @JsonProperty(value="volumeMounts")
    @JsonPropertyDescription(value="Pod volumes to mount into the container's filesystem. Subpath mounts are not allowed for ephemeral containers. Cannot be updated.")
    @JsonSetter(nulls=Nulls.SKIP)
    private List<VolumeMounts> volumeMounts;
    @JsonProperty(value="workingDir")
    @JsonPropertyDescription(value="Container's working directory. If not specified, the container runtime's default will be used, which might be configured in the container image. Cannot be updated.")
    @JsonSetter(nulls=Nulls.SKIP)
    private String workingDir;

    public List<String> getArgs() {
        return this.args;
    }

    public void setArgs(List<String> args) {
        this.args = args;
    }

    public List<String> getCommand() {
        return this.command;
    }

    public void setCommand(List<String> command) {
        this.command = command;
    }

    public List<Env> getEnv() {
        return this.env;
    }

    public void setEnv(List<Env> env) {
        this.env = env;
    }

    public List<EnvFrom> getEnvFrom() {
        return this.envFrom;
    }

    public void setEnvFrom(List<EnvFrom> envFrom) {
        this.envFrom = envFrom;
    }

    public String getImage() {
        return this.image;
    }

    public void setImage(String image) {
        this.image = image;
    }

    public String getImagePullPolicy() {
        return this.imagePullPolicy;
    }

    public void setImagePullPolicy(String imagePullPolicy) {
        this.imagePullPolicy = imagePullPolicy;
    }

    public Lifecycle getLifecycle() {
        return this.lifecycle;
    }

    public void setLifecycle(Lifecycle lifecycle) {
        this.lifecycle = lifecycle;
    }

    public LivenessProbe getLivenessProbe() {
        return this.livenessProbe;
    }

    public void setLivenessProbe(LivenessProbe livenessProbe) {
        this.livenessProbe = livenessProbe;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public List<Ports> getPorts() {
        return this.ports;
    }

    public void setPorts(List<Ports> ports) {
        this.ports = ports;
    }

    public ReadinessProbe getReadinessProbe() {
        return this.readinessProbe;
    }

    public void setReadinessProbe(ReadinessProbe readinessProbe) {
        this.readinessProbe = readinessProbe;
    }

    public Resources getResources() {
        return this.resources;
    }

    public void setResources(Resources resources) {
        this.resources = resources;
    }

    public SecurityContext getSecurityContext() {
        return this.securityContext;
    }

    public void setSecurityContext(SecurityContext securityContext) {
        this.securityContext = securityContext;
    }

    public StartupProbe getStartupProbe() {
        return this.startupProbe;
    }

    public void setStartupProbe(StartupProbe startupProbe) {
        this.startupProbe = startupProbe;
    }

    public Boolean getStdin() {
        return this.stdin;
    }

    public void setStdin(Boolean stdin) {
        this.stdin = stdin;
    }

    public Boolean getStdinOnce() {
        return this.stdinOnce;
    }

    public void setStdinOnce(Boolean stdinOnce) {
        this.stdinOnce = stdinOnce;
    }

    public String getTargetContainerName() {
        return this.targetContainerName;
    }

    public void setTargetContainerName(String targetContainerName) {
        this.targetContainerName = targetContainerName;
    }

    public String getTerminationMessagePath() {
        return this.terminationMessagePath;
    }

    public void setTerminationMessagePath(String terminationMessagePath) {
        this.terminationMessagePath = terminationMessagePath;
    }

    public String getTerminationMessagePolicy() {
        return this.terminationMessagePolicy;
    }

    public void setTerminationMessagePolicy(String terminationMessagePolicy) {
        this.terminationMessagePolicy = terminationMessagePolicy;
    }

    public Boolean getTty() {
        return this.tty;
    }

    public void setTty(Boolean tty) {
        this.tty = tty;
    }

    public List<VolumeDevices> getVolumeDevices() {
        return this.volumeDevices;
    }

    public void setVolumeDevices(List<VolumeDevices> volumeDevices) {
        this.volumeDevices = volumeDevices;
    }

    public List<VolumeMounts> getVolumeMounts() {
        return this.volumeMounts;
    }

    public void setVolumeMounts(List<VolumeMounts> volumeMounts) {
        this.volumeMounts = volumeMounts;
    }

    public String getWorkingDir() {
        return this.workingDir;
    }

    public void setWorkingDir(String workingDir) {
        this.workingDir = workingDir;
    }
}

