/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.v1.integrationspec.template.spec.containers;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import io.fabric8.kubernetes.api.model.KubernetesResource;
import org.apache.camel.v1.integrationspec.template.spec.containers.lifecycle.PostStart;
import org.apache.camel.v1.integrationspec.template.spec.containers.lifecycle.PreStop;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonPropertyOrder(value={"postStart", "preStop"})
@JsonDeserialize(using=JsonDeserializer.None.class)
public class Lifecycle
implements KubernetesResource {
    @JsonProperty(value="postStart")
    @JsonPropertyDescription(value="PostStart is called immediately after a container is created. If the handler fails, the container is terminated and restarted according to its restart policy. Other management of the container blocks until the hook completes. More info: https://kubernetes.io/docs/concepts/containers/container-lifecycle-hooks/#container-hooks")
    @JsonSetter(nulls=Nulls.SKIP)
    private PostStart postStart;
    @JsonProperty(value="preStop")
    @JsonPropertyDescription(value="PreStop is called immediately before a container is terminated due to an API request or management event such as liveness/startup probe failure, preemption, resource contention, etc. The handler is not called if the container crashes or exits. The Pod's termination grace period countdown begins before the PreStop hook is executed. Regardless of the outcome of the handler, the container will eventually terminate within the Pod's termination grace period (unless delayed by finalizers). Other management of the container blocks until the hook completes or until the termination grace period is reached. More info: https://kubernetes.io/docs/concepts/containers/container-lifecycle-hooks/#container-hooks")
    @JsonSetter(nulls=Nulls.SKIP)
    private PreStop preStop;

    public PostStart getPostStart() {
        return this.postStart;
    }

    public void setPostStart(PostStart postStart) {
        this.postStart = postStart;
    }

    public PreStop getPreStop() {
        return this.preStop;
    }

    public void setPreStop(PreStop preStop) {
        this.preStop = preStop;
    }
}

