/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.v1.buildspec;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import io.fabric8.kubernetes.api.model.KubernetesResource;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonPropertyOrder(value={"limitCPU", "limitMemory", "operatorNamespace", "orderStrategy", "requestCPU", "requestMemory", "strategy", "toolImage"})
@JsonDeserialize(using=JsonDeserializer.None.class)
public class Configuration
implements KubernetesResource {
    @JsonProperty(value="limitCPU")
    @JsonPropertyDescription(value="The maximum amount of CPU required. Only used for `pod` strategy")
    @JsonSetter(nulls=Nulls.SKIP)
    private String limitCPU;
    @JsonProperty(value="limitMemory")
    @JsonPropertyDescription(value="The maximum amount of memory required. Only used for `pod` strategy")
    @JsonSetter(nulls=Nulls.SKIP)
    private String limitMemory;
    @JsonProperty(value="operatorNamespace")
    @JsonPropertyDescription(value="The namespace where to run the builder Pod (must be the same of the operator in charge of this Build reconciliation).")
    @JsonSetter(nulls=Nulls.SKIP)
    private String operatorNamespace;
    @JsonProperty(value="orderStrategy")
    @JsonPropertyDescription(value="the build order strategy to adopt")
    @JsonSetter(nulls=Nulls.SKIP)
    private OrderStrategy orderStrategy;
    @JsonProperty(value="requestCPU")
    @JsonPropertyDescription(value="The minimum amount of CPU required. Only used for `pod` strategy")
    @JsonSetter(nulls=Nulls.SKIP)
    private String requestCPU;
    @JsonProperty(value="requestMemory")
    @JsonPropertyDescription(value="The minimum amount of memory required. Only used for `pod` strategy")
    @JsonSetter(nulls=Nulls.SKIP)
    private String requestMemory;
    @JsonProperty(value="strategy")
    @JsonPropertyDescription(value="the strategy to adopt")
    @JsonSetter(nulls=Nulls.SKIP)
    private Strategy strategy;
    @JsonProperty(value="toolImage")
    @JsonPropertyDescription(value="The container image to be used to run the build.")
    @JsonSetter(nulls=Nulls.SKIP)
    private String toolImage;

    public String getLimitCPU() {
        return this.limitCPU;
    }

    public void setLimitCPU(String limitCPU) {
        this.limitCPU = limitCPU;
    }

    public String getLimitMemory() {
        return this.limitMemory;
    }

    public void setLimitMemory(String limitMemory) {
        this.limitMemory = limitMemory;
    }

    public String getOperatorNamespace() {
        return this.operatorNamespace;
    }

    public void setOperatorNamespace(String operatorNamespace) {
        this.operatorNamespace = operatorNamespace;
    }

    public OrderStrategy getOrderStrategy() {
        return this.orderStrategy;
    }

    public void setOrderStrategy(OrderStrategy orderStrategy) {
        this.orderStrategy = orderStrategy;
    }

    public String getRequestCPU() {
        return this.requestCPU;
    }

    public void setRequestCPU(String requestCPU) {
        this.requestCPU = requestCPU;
    }

    public String getRequestMemory() {
        return this.requestMemory;
    }

    public void setRequestMemory(String requestMemory) {
        this.requestMemory = requestMemory;
    }

    public Strategy getStrategy() {
        return this.strategy;
    }

    public void setStrategy(Strategy strategy) {
        this.strategy = strategy;
    }

    public String getToolImage() {
        return this.toolImage;
    }

    public void setToolImage(String toolImage) {
        this.toolImage = toolImage;
    }

    public static enum Strategy {
        ROUTINE("routine"),
        POD("pod");

        String value;

        private Strategy(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }
    }

    public static enum OrderStrategy {
        DEPENDENCIES("dependencies"),
        FIFO("fifo"),
        SEQUENTIAL("sequential");

        String value;

        private OrderStrategy(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }
    }
}

