/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.v1;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import io.fabric8.kubernetes.api.model.KubernetesResource;
import java.util.List;
import java.util.Map;
import org.apache.camel.v1.kameletspec.DataTypes;
import org.apache.camel.v1.kameletspec.Definition;
import org.apache.camel.v1.kameletspec.Sources;
import org.apache.camel.v1.kameletspec.Template;
import org.apache.camel.v1.kameletspec.Types;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonPropertyOrder(value={"dataTypes", "definition", "dependencies", "sources", "template", "types"})
@JsonDeserialize(using=JsonDeserializer.None.class)
public class KameletSpec
implements KubernetesResource {
    @JsonProperty(value="dataTypes")
    @JsonPropertyDescription(value="data specification types for the events consumed/produced by the Kamelet")
    @JsonSetter(nulls=Nulls.SKIP)
    private Map<String, DataTypes> dataTypes;
    @JsonProperty(value="definition")
    @JsonPropertyDescription(value="defines the formal configuration of the Kamelet")
    @JsonSetter(nulls=Nulls.SKIP)
    private Definition definition;
    @JsonProperty(value="dependencies")
    @JsonPropertyDescription(value="Camel dependencies needed by the Kamelet")
    @JsonSetter(nulls=Nulls.SKIP)
    private List<String> dependencies;
    @JsonProperty(value="sources")
    @JsonPropertyDescription(value="sources in any Camel DSL supported")
    @JsonSetter(nulls=Nulls.SKIP)
    private List<Sources> sources;
    @JsonProperty(value="template")
    @JsonPropertyDescription(value="the main source in YAML DSL")
    @JsonSetter(nulls=Nulls.SKIP)
    private Template template;
    @JsonProperty(value="types")
    @JsonPropertyDescription(value="data specification types for the events consumed/produced by the Kamelet Deprecated: In favor of using DataTypes")
    @JsonSetter(nulls=Nulls.SKIP)
    private Map<String, Types> types;

    public Map<String, DataTypes> getDataTypes() {
        return this.dataTypes;
    }

    public void setDataTypes(Map<String, DataTypes> dataTypes) {
        this.dataTypes = dataTypes;
    }

    public Definition getDefinition() {
        return this.definition;
    }

    public void setDefinition(Definition definition) {
        this.definition = definition;
    }

    public List<String> getDependencies() {
        return this.dependencies;
    }

    public void setDependencies(List<String> dependencies) {
        this.dependencies = dependencies;
    }

    public List<Sources> getSources() {
        return this.sources;
    }

    public void setSources(List<Sources> sources) {
        this.sources = sources;
    }

    public Template getTemplate() {
        return this.template;
    }

    public void setTemplate(Template template) {
        this.template = template;
    }

    public Map<String, Types> getTypes() {
        return this.types;
    }

    public void setTypes(Map<String, Types> types) {
        this.types = types;
    }
}

