/*
Licensed to the Apache Software Foundation (ASF) under one or more
contributor license agreements.  See the NOTICE file distributed with
this work for additional information regarding copyright ownership.
The ASF licenses this file to You under the Apache License, Version 2.0
(the "License"); you may not use this file except in compliance with
the License.  You may obtain a copy of the License at

   http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

// Code generated by client-gen. DO NOT EDIT.

package v1alpha1

import (
	"context"
	"time"

	v1alpha1 "github.com/apache/camel-k/pkg/apis/camel/v1alpha1"
	scheme "github.com/apache/camel-k/pkg/client/camel/clientset/versioned/scheme"
	v1 "k8s.io/apimachinery/pkg/apis/meta/v1"
	types "k8s.io/apimachinery/pkg/types"
	watch "k8s.io/apimachinery/pkg/watch"
	rest "k8s.io/client-go/rest"
)

// KameletBindingsGetter has a method to return a KameletBindingInterface.
// A group's client should implement this interface.
type KameletBindingsGetter interface {
	KameletBindings(namespace string) KameletBindingInterface
}

// KameletBindingInterface has methods to work with KameletBinding resources.
type KameletBindingInterface interface {
	Create(ctx context.Context, kameletBinding *v1alpha1.KameletBinding, opts v1.CreateOptions) (*v1alpha1.KameletBinding, error)
	Update(ctx context.Context, kameletBinding *v1alpha1.KameletBinding, opts v1.UpdateOptions) (*v1alpha1.KameletBinding, error)
	UpdateStatus(ctx context.Context, kameletBinding *v1alpha1.KameletBinding, opts v1.UpdateOptions) (*v1alpha1.KameletBinding, error)
	Delete(ctx context.Context, name string, opts v1.DeleteOptions) error
	DeleteCollection(ctx context.Context, opts v1.DeleteOptions, listOpts v1.ListOptions) error
	Get(ctx context.Context, name string, opts v1.GetOptions) (*v1alpha1.KameletBinding, error)
	List(ctx context.Context, opts v1.ListOptions) (*v1alpha1.KameletBindingList, error)
	Watch(ctx context.Context, opts v1.ListOptions) (watch.Interface, error)
	Patch(ctx context.Context, name string, pt types.PatchType, data []byte, opts v1.PatchOptions, subresources ...string) (result *v1alpha1.KameletBinding, err error)
	KameletBindingExpansion
}

// kameletBindings implements KameletBindingInterface
type kameletBindings struct {
	client rest.Interface
	ns     string
}

// newKameletBindings returns a KameletBindings
func newKameletBindings(c *CamelV1alpha1Client, namespace string) *kameletBindings {
	return &kameletBindings{
		client: c.RESTClient(),
		ns:     namespace,
	}
}

// Get takes name of the kameletBinding, and returns the corresponding kameletBinding object, and an error if there is any.
func (c *kameletBindings) Get(ctx context.Context, name string, options v1.GetOptions) (result *v1alpha1.KameletBinding, err error) {
	result = &v1alpha1.KameletBinding{}
	err = c.client.Get().
		Namespace(c.ns).
		Resource("kameletbindings").
		Name(name).
		VersionedParams(&options, scheme.ParameterCodec).
		Do(ctx).
		Into(result)
	return
}

// List takes label and field selectors, and returns the list of KameletBindings that match those selectors.
func (c *kameletBindings) List(ctx context.Context, opts v1.ListOptions) (result *v1alpha1.KameletBindingList, err error) {
	var timeout time.Duration
	if opts.TimeoutSeconds != nil {
		timeout = time.Duration(*opts.TimeoutSeconds) * time.Second
	}
	result = &v1alpha1.KameletBindingList{}
	err = c.client.Get().
		Namespace(c.ns).
		Resource("kameletbindings").
		VersionedParams(&opts, scheme.ParameterCodec).
		Timeout(timeout).
		Do(ctx).
		Into(result)
	return
}

// Watch returns a watch.Interface that watches the requested kameletBindings.
func (c *kameletBindings) Watch(ctx context.Context, opts v1.ListOptions) (watch.Interface, error) {
	var timeout time.Duration
	if opts.TimeoutSeconds != nil {
		timeout = time.Duration(*opts.TimeoutSeconds) * time.Second
	}
	opts.Watch = true
	return c.client.Get().
		Namespace(c.ns).
		Resource("kameletbindings").
		VersionedParams(&opts, scheme.ParameterCodec).
		Timeout(timeout).
		Watch(ctx)
}

// Create takes the representation of a kameletBinding and creates it.  Returns the server's representation of the kameletBinding, and an error, if there is any.
func (c *kameletBindings) Create(ctx context.Context, kameletBinding *v1alpha1.KameletBinding, opts v1.CreateOptions) (result *v1alpha1.KameletBinding, err error) {
	result = &v1alpha1.KameletBinding{}
	err = c.client.Post().
		Namespace(c.ns).
		Resource("kameletbindings").
		VersionedParams(&opts, scheme.ParameterCodec).
		Body(kameletBinding).
		Do(ctx).
		Into(result)
	return
}

// Update takes the representation of a kameletBinding and updates it. Returns the server's representation of the kameletBinding, and an error, if there is any.
func (c *kameletBindings) Update(ctx context.Context, kameletBinding *v1alpha1.KameletBinding, opts v1.UpdateOptions) (result *v1alpha1.KameletBinding, err error) {
	result = &v1alpha1.KameletBinding{}
	err = c.client.Put().
		Namespace(c.ns).
		Resource("kameletbindings").
		Name(kameletBinding.Name).
		VersionedParams(&opts, scheme.ParameterCodec).
		Body(kameletBinding).
		Do(ctx).
		Into(result)
	return
}

// UpdateStatus was generated because the type contains a Status member.
// Add a +genclient:noStatus comment above the type to avoid generating UpdateStatus().
func (c *kameletBindings) UpdateStatus(ctx context.Context, kameletBinding *v1alpha1.KameletBinding, opts v1.UpdateOptions) (result *v1alpha1.KameletBinding, err error) {
	result = &v1alpha1.KameletBinding{}
	err = c.client.Put().
		Namespace(c.ns).
		Resource("kameletbindings").
		Name(kameletBinding.Name).
		SubResource("status").
		VersionedParams(&opts, scheme.ParameterCodec).
		Body(kameletBinding).
		Do(ctx).
		Into(result)
	return
}

// Delete takes name of the kameletBinding and deletes it. Returns an error if one occurs.
func (c *kameletBindings) Delete(ctx context.Context, name string, opts v1.DeleteOptions) error {
	return c.client.Delete().
		Namespace(c.ns).
		Resource("kameletbindings").
		Name(name).
		Body(&opts).
		Do(ctx).
		Error()
}

// DeleteCollection deletes a collection of objects.
func (c *kameletBindings) DeleteCollection(ctx context.Context, opts v1.DeleteOptions, listOpts v1.ListOptions) error {
	var timeout time.Duration
	if listOpts.TimeoutSeconds != nil {
		timeout = time.Duration(*listOpts.TimeoutSeconds) * time.Second
	}
	return c.client.Delete().
		Namespace(c.ns).
		Resource("kameletbindings").
		VersionedParams(&listOpts, scheme.ParameterCodec).
		Timeout(timeout).
		Body(&opts).
		Do(ctx).
		Error()
}

// Patch applies the patch and returns the patched kameletBinding.
func (c *kameletBindings) Patch(ctx context.Context, name string, pt types.PatchType, data []byte, opts v1.PatchOptions, subresources ...string) (result *v1alpha1.KameletBinding, err error) {
	result = &v1alpha1.KameletBinding{}
	err = c.client.Patch(pt).
		Namespace(c.ns).
		Resource("kameletbindings").
		Name(name).
		SubResource(subresources...).
		VersionedParams(&opts, scheme.ParameterCodec).
		Body(data).
		Do(ctx).
		Into(result)
	return
}
