/*
Licensed to the Apache Software Foundation (ASF) under one or more
contributor license agreements.  See the NOTICE file distributed with
this work for additional information regarding copyright ownership.
The ASF licenses this file to You under the Apache License, Version 2.0
(the "License"); you may not use this file except in compliance with
the License.  You may obtain a copy of the License at

   http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

// Code generated by client-gen. DO NOT EDIT.

package v1beta1

import (
	"context"
	"time"

	v1beta1 "github.com/apache/camel-k/addons/strimzi/duck/v1beta1"
	scheme "github.com/apache/camel-k/addons/strimzi/duck/v1beta1/client/internalclientset/scheme"
	v1 "k8s.io/apimachinery/pkg/apis/meta/v1"
	watch "k8s.io/apimachinery/pkg/watch"
	rest "k8s.io/client-go/rest"
)

// KafkasGetter has a method to return a KafkaInterface.
// A group's client should implement this interface.
type KafkasGetter interface {
	Kafkas(namespace string) KafkaInterface
}

// KafkaInterface has methods to work with Kafka resources.
type KafkaInterface interface {
	Get(ctx context.Context, name string, opts v1.GetOptions) (*v1beta1.Kafka, error)
	List(ctx context.Context, opts v1.ListOptions) (*v1beta1.KafkaList, error)
	Watch(ctx context.Context, opts v1.ListOptions) (watch.Interface, error)
	KafkaExpansion
}

// kafkas implements KafkaInterface
type kafkas struct {
	client rest.Interface
	ns     string
}

// newKafkas returns a Kafkas
func newKafkas(c *KafkaV1beta1Client, namespace string) *kafkas {
	return &kafkas{
		client: c.RESTClient(),
		ns:     namespace,
	}
}

// Get takes name of the kafka, and returns the corresponding kafka object, and an error if there is any.
func (c *kafkas) Get(ctx context.Context, name string, options v1.GetOptions) (result *v1beta1.Kafka, err error) {
	result = &v1beta1.Kafka{}
	err = c.client.Get().
		Namespace(c.ns).
		Resource("kafkas").
		Name(name).
		VersionedParams(&options, scheme.ParameterCodec).
		Do(ctx).
		Into(result)
	return
}

// List takes label and field selectors, and returns the list of Kafkas that match those selectors.
func (c *kafkas) List(ctx context.Context, opts v1.ListOptions) (result *v1beta1.KafkaList, err error) {
	var timeout time.Duration
	if opts.TimeoutSeconds != nil {
		timeout = time.Duration(*opts.TimeoutSeconds) * time.Second
	}
	result = &v1beta1.KafkaList{}
	err = c.client.Get().
		Namespace(c.ns).
		Resource("kafkas").
		VersionedParams(&opts, scheme.ParameterCodec).
		Timeout(timeout).
		Do(ctx).
		Into(result)
	return
}

// Watch returns a watch.Interface that watches the requested kafkas.
func (c *kafkas) Watch(ctx context.Context, opts v1.ListOptions) (watch.Interface, error) {
	var timeout time.Duration
	if opts.TimeoutSeconds != nil {
		timeout = time.Duration(*opts.TimeoutSeconds) * time.Second
	}
	opts.Watch = true
	return c.client.Get().
		Namespace(c.ns).
		Resource("kafkas").
		VersionedParams(&opts, scheme.ParameterCodec).
		Timeout(timeout).
		Watch(ctx)
}
