/*
Licensed to the Apache Software Foundation (ASF) under one or more
contributor license agreements.  See the NOTICE file distributed with
this work for additional information regarding copyright ownership.
The ASF licenses this file to You under the Apache License, Version 2.0
(the "License"); you may not use this file except in compliance with
the License.  You may obtain a copy of the License at

   http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

// Code generated by informer-gen. DO NOT EDIT.

package v1

import (
	internalinterfaces "github.com/apache/camel-k/pkg/client/camel/informers/externalversions/internalinterfaces"
)

// Interface provides access to all the informers in this group version.
type Interface interface {
	// Builds returns a BuildInformer.
	Builds() BuildInformer
	// CamelCatalogs returns a CamelCatalogInformer.
	CamelCatalogs() CamelCatalogInformer
	// Integrations returns a IntegrationInformer.
	Integrations() IntegrationInformer
	// IntegrationKits returns a IntegrationKitInformer.
	IntegrationKits() IntegrationKitInformer
	// IntegrationPlatforms returns a IntegrationPlatformInformer.
	IntegrationPlatforms() IntegrationPlatformInformer
}

type version struct {
	factory          internalinterfaces.SharedInformerFactory
	namespace        string
	tweakListOptions internalinterfaces.TweakListOptionsFunc
}

// New returns a new Interface.
func New(f internalinterfaces.SharedInformerFactory, namespace string, tweakListOptions internalinterfaces.TweakListOptionsFunc) Interface {
	return &version{factory: f, namespace: namespace, tweakListOptions: tweakListOptions}
}

// Builds returns a BuildInformer.
func (v *version) Builds() BuildInformer {
	return &buildInformer{factory: v.factory, namespace: v.namespace, tweakListOptions: v.tweakListOptions}
}

// CamelCatalogs returns a CamelCatalogInformer.
func (v *version) CamelCatalogs() CamelCatalogInformer {
	return &camelCatalogInformer{factory: v.factory, namespace: v.namespace, tweakListOptions: v.tweakListOptions}
}

// Integrations returns a IntegrationInformer.
func (v *version) Integrations() IntegrationInformer {
	return &integrationInformer{factory: v.factory, namespace: v.namespace, tweakListOptions: v.tweakListOptions}
}

// IntegrationKits returns a IntegrationKitInformer.
func (v *version) IntegrationKits() IntegrationKitInformer {
	return &integrationKitInformer{factory: v.factory, namespace: v.namespace, tweakListOptions: v.tweakListOptions}
}

// IntegrationPlatforms returns a IntegrationPlatformInformer.
func (v *version) IntegrationPlatforms() IntegrationPlatformInformer {
	return &integrationPlatformInformer{factory: v.factory, namespace: v.namespace, tweakListOptions: v.tweakListOptions}
}
