# Changelog

## [Unreleased](https://github.com/apache/camel-k/tree/HEAD)

[Full Changelog](https://github.com/apache/camel-k/compare/v1.1.1...HEAD)

**Closed issues:**

- Binary resources such as keystores are being corrupted [\#1750](https://github.com/apache/camel-k/issues/1750)
- Propagate Kamelet icon on binding [\#1747](https://github.com/apache/camel-k/issues/1747)
- Thread blocked calling knative REST [\#1720](https://github.com/apache/camel-k/issues/1720)
- Automatic changelog update should not be run on forks [\#1717](https://github.com/apache/camel-k/issues/1717)
- Environment Variables from Secrets [\#1715](https://github.com/apache/camel-k/issues/1715)
- Salesforce Integration as Knative Serverless Service fails [\#1713](https://github.com/apache/camel-k/issues/1713)
- Generate CRD schema for Kamelet + KameletBinding [\#1710](https://github.com/apache/camel-k/issues/1710)
- Add Kamelet integration tests [\#1709](https://github.com/apache/camel-k/issues/1709)
- Does camel-k plan to provide Java SDK client Calls? [\#1708](https://github.com/apache/camel-k/issues/1708)
- Release 1.1.1 [\#1700](https://github.com/apache/camel-k/issues/1700)
- Upgrade to Prometheus operator version 0.42.0+ [\#1697](https://github.com/apache/camel-k/issues/1697)
- Add support for Strimzi Topics in KameletBinding [\#1686](https://github.com/apache/camel-k/issues/1686)
- kamelets: source/sink binding [\#1676](https://github.com/apache/camel-k/issues/1676)
- Add related image in OLM descriptor [\#1611](https://github.com/apache/camel-k/issues/1611)
- Deprecate build kit at platform set-up time [\#1604](https://github.com/apache/camel-k/issues/1604)
- kamelets: runtime support [\#1575](https://github.com/apache/camel-k/issues/1575)
- kamelets: operator support [\#1574](https://github.com/apache/camel-k/issues/1574)
- Support for Kamelets [\#1567](https://github.com/apache/camel-k/issues/1567)
- Add a kamel help cli command [\#1545](https://github.com/apache/camel-k/issues/1545)
- Switch to Quarkus as default runtime for integrations [\#1513](https://github.com/apache/camel-k/issues/1513)

**Merged pull requests:**

- Fix \#1750: auto-compress/encode binary sources and resources [\#1751](https://github.com/apache/camel-k/pull/1751) ([nicolaferraro](https://github.com/nicolaferraro))
- Fix \#1747: propagate icon on kameletbinding and fix integration owner… [\#1749](https://github.com/apache/camel-k/pull/1749) ([nicolaferraro](https://github.com/nicolaferraro))
- Add support for Strimzi KafkaTopics in KameletBinding [\#1745](https://github.com/apache/camel-k/pull/1745) ([nicolaferraro](https://github.com/nicolaferraro))
- chore: Upgrade Prometheus to version 0.42.1 [\#1744](https://github.com/apache/camel-k/pull/1744) ([astefanutti](https://github.com/astefanutti))
- fix\(doc\): Set architecture diagram width explicitly [\#1742](https://github.com/apache/camel-k/pull/1742) ([astefanutti](https://github.com/astefanutti))
- Upgrade to Operator SDK 1.0+ [\#1741](https://github.com/apache/camel-k/pull/1741) ([astefanutti](https://github.com/astefanutti))
- Added installations steps to IBM Kubernetes Service\(IKS\) [\#1739](https://github.com/apache/camel-k/pull/1739) ([juanjopb](https://github.com/juanjopb))
- Fix typo [\#1736](https://github.com/apache/camel-k/pull/1736) ([llowinge](https://github.com/llowinge))
- doc: Add high-level architecture diagram [\#1735](https://github.com/apache/camel-k/pull/1735) ([astefanutti](https://github.com/astefanutti))
- fix: Uninstall cluster role bindings [\#1734](https://github.com/apache/camel-k/pull/1734) ([christophd](https://github.com/christophd))
- chore: Update rbac authorization k8s from v1beta1 to v1 [\#1733](https://github.com/apache/camel-k/pull/1733) ([christophd](https://github.com/christophd))
- chore: Fix operator sdk download url in release workflow [\#1731](https://github.com/apache/camel-k/pull/1731) ([christophd](https://github.com/christophd))
- fix\(\#1717\) Automatic changelog update should not be run on forks [\#1730](https://github.com/apache/camel-k/pull/1730) ([christophd](https://github.com/christophd))
- chore: Make scripts portable [\#1729](https://github.com/apache/camel-k/pull/1729) ([christophd](https://github.com/christophd))
- \[fix\] Use correct name of kameletbinding [\#1728](https://github.com/apache/camel-k/pull/1728) ([llowinge](https://github.com/llowinge))
- chore\(binding\): refactor binding mechanism and add many more tests [\#1727](https://github.com/apache/camel-k/pull/1727) ([nicolaferraro](https://github.com/nicolaferraro))
- \[fix\] Use bigger timeout to start querying metrics in test [\#1726](https://github.com/apache/camel-k/pull/1726) ([llowinge](https://github.com/llowinge))
- Related to \#1675: install default Kamelets [\#1725](https://github.com/apache/camel-k/pull/1725) ([nicolaferraro](https://github.com/nicolaferraro))
- fix: Adapt Knative service definition to new KnativeEnvironment definition [\#1724](https://github.com/apache/camel-k/pull/1724) ([astefanutti](https://github.com/astefanutti))
- Jolokia trait fixes so that it works with Hawtio Online [\#1723](https://github.com/apache/camel-k/pull/1723) ([astefanutti](https://github.com/astefanutti))
- \[fix\] Use in-place editing [\#1722](https://github.com/apache/camel-k/pull/1722) ([llowinge](https://github.com/llowinge))
- docs: add section describing secret ref in properties files [\#1716](https://github.com/apache/camel-k/pull/1716) ([evanshortiss](https://github.com/evanshortiss))
- Fix \#1710: auto-generate CRD specification on "generate" task \(and fix Kamelets\) [\#1714](https://github.com/apache/camel-k/pull/1714) ([nicolaferraro](https://github.com/nicolaferraro))
- Fix \#1709: add e2e tests about kamelets [\#1711](https://github.com/apache/camel-k/pull/1711) ([nicolaferraro](https://github.com/nicolaferraro))
- \[Minor\] grammatical/typo changes [\#1705](https://github.com/apache/camel-k/pull/1705) ([PoojaChandak](https://github.com/PoojaChandak))
- Document Update [\#1704](https://github.com/apache/camel-k/pull/1704) ([NiteshKoushik](https://github.com/NiteshKoushik))
- Document update [\#1703](https://github.com/apache/camel-k/pull/1703) ([NiteshKoushik](https://github.com/NiteshKoushik))
- Document Update [\#1702](https://github.com/apache/camel-k/pull/1702) ([NiteshKoushik](https://github.com/NiteshKoushik))
- Switch from Gitter to Zulip [\#1701](https://github.com/apache/camel-k/pull/1701) ([lburgazzoli](https://github.com/lburgazzoli))
- Add documentation about kamel run from github [\#1695](https://github.com/apache/camel-k/pull/1695) ([davsclaus](https://github.com/davsclaus))
- Automatic changelog: Let's run during the night only one time [\#1692](https://github.com/apache/camel-k/pull/1692) ([oscerd](https://github.com/oscerd))
- chore\(doc\): document Kamelets and fix small issues [\#1690](https://github.com/apache/camel-k/pull/1690) ([nicolaferraro](https://github.com/nicolaferraro))
- Changelog updater: run every hour [\#1688](https://github.com/apache/camel-k/pull/1688) ([oscerd](https://github.com/oscerd))
- Fix \#1670: upgrade to Knative 0.16 and support from 0.15 to 0.17 [\#1685](https://github.com/apache/camel-k/pull/1685) ([nicolaferraro](https://github.com/nicolaferraro))
- Added an automatic changelog Github action [\#1684](https://github.com/apache/camel-k/pull/1684) ([oscerd](https://github.com/oscerd))
- Add describe command completion [\#1683](https://github.com/apache/camel-k/pull/1683) ([johnpoth](https://github.com/johnpoth))
- fix \#1668: cancel previous context before issuing a new one [\#1679](https://github.com/apache/camel-k/pull/1679) ([nicolaferraro](https://github.com/nicolaferraro))
- Create amqpConsume.java [\#1678](https://github.com/apache/camel-k/pull/1678) ([rbaumgar](https://github.com/rbaumgar))
- build\(ci\): ignore some paths on the GitHub action workflows [\#1672](https://github.com/apache/camel-k/pull/1672) ([lburgazzoli](https://github.com/lburgazzoli))
- docs: remove old references to the runtime [\#1671](https://github.com/apache/camel-k/pull/1671) ([lburgazzoli](https://github.com/lburgazzoli))
- \[test\] Create integration test for exposing metrics to prometheus [\#1660](https://github.com/apache/camel-k/pull/1660) ([llowinge](https://github.com/llowinge))
- Remove backport gh action. It doesn't work [\#1659](https://github.com/apache/camel-k/pull/1659) ([oscerd](https://github.com/oscerd))
- Fixes \(mainly typo\) in documentation [\#1658](https://github.com/apache/camel-k/pull/1658) ([ikwattro](https://github.com/ikwattro))
- chore\(doc\): document sinkbinding in the context of sources and Kamelets [\#1655](https://github.com/apache/camel-k/pull/1655) ([nicolaferraro](https://github.com/nicolaferraro))
- chore\(release\): create additional tags for go modules [\#1653](https://github.com/apache/camel-k/pull/1653) ([nicolaferraro](https://github.com/nicolaferraro))
- Add support for oidc [\#1647](https://github.com/apache/camel-k/pull/1647) ([aslom](https://github.com/aslom))
- Related to \#1638 kamel init - should not create source file with ASF … [\#1644](https://github.com/apache/camel-k/pull/1644) ([oscerd](https://github.com/oscerd))
- Related to \#1638 kamel init - should not create source file with ASF … [\#1643](https://github.com/apache/camel-k/pull/1643) ([oscerd](https://github.com/oscerd))
- Related to \#1638 kamel init - should not create source file with ASF … [\#1642](https://github.com/apache/camel-k/pull/1642) ([oscerd](https://github.com/oscerd))
- Related to \#1638 kamel init - should not create source file with ASF … [\#1641](https://github.com/apache/camel-k/pull/1641) ([oscerd](https://github.com/oscerd))
- Related to \#1638 kamel init - should not create source file with ASF … [\#1640](https://github.com/apache/camel-k/pull/1640) ([oscerd](https://github.com/oscerd))
- Related to \#1638 kamel init - should not create source file with ASF … [\#1639](https://github.com/apache/camel-k/pull/1639) ([oscerd](https://github.com/oscerd))
- Add support for sinkbinding [\#1637](https://github.com/apache/camel-k/pull/1637) ([nicolaferraro](https://github.com/nicolaferraro))
- Fix \#1536: take modeline changes into account in dev mode [\#1634](https://github.com/apache/camel-k/pull/1634) ([johnpoth](https://github.com/johnpoth))
- fix\(doc\): Fix Affinity trait examples formatting [\#1631](https://github.com/apache/camel-k/pull/1631) ([astefanutti](https://github.com/astefanutti))
- Use Quarkus as default runtime [\#1609](https://github.com/apache/camel-k/pull/1609) ([nicolaferraro](https://github.com/nicolaferraro))
- Implement Kamelets [\#1602](https://github.com/apache/camel-k/pull/1602) ([nicolaferraro](https://github.com/nicolaferraro))

## [v1.1.1](https://github.com/apache/camel-k/tree/v1.1.1) (2020-09-11)

[Full Changelog](https://github.com/apache/camel-k/compare/pkg/apis/camel/v1.1.1...v1.1.1)

## [pkg/apis/camel/v1.1.1](https://github.com/apache/camel-k/tree/pkg/apis/camel/v1.1.1) (2020-09-11)

[Full Changelog](https://github.com/apache/camel-k/compare/pkg/client/camel/v1.1.1...pkg/apis/camel/v1.1.1)

## [pkg/client/camel/v1.1.1](https://github.com/apache/camel-k/tree/pkg/client/camel/v1.1.1) (2020-09-11)

[Full Changelog](https://github.com/apache/camel-k/compare/pkg/client/camel/v1.1.0...pkg/client/camel/v1.1.1)

**Closed issues:**

- Failed to install Camel-K in IKS [\#1687](https://github.com/apache/camel-k/issues/1687)
- Upgrade base to Knative 0.16 and support 0.17 [\#1670](https://github.com/apache/camel-k/issues/1670)
- Integration is logged twice in dev mode [\#1668](https://github.com/apache/camel-k/issues/1668)
- operator.adoc - ascii doc warning [\#1662](https://github.com/apache/camel-k/issues/1662)
- Caffeine with Knative doesn't work [\#1649](https://github.com/apache/camel-k/issues/1649)
- Build error when using traits [\#1648](https://github.com/apache/camel-k/issues/1648)
- Add oidc provider to Camel-K [\#1646](https://github.com/apache/camel-k/issues/1646)
- When creating a new tag, make sure it's strictly numeric \(i.e. 1.1.0 instead of v1.1.0\) [\#1645](https://github.com/apache/camel-k/issues/1645)
- kamel init - should not create source file with ASF license header [\#1638](https://github.com/apache/camel-k/issues/1638)
- No matches for kind "Subscription" in version "messaging.knative.dev/v1alpha1" [\#1636](https://github.com/apache/camel-k/issues/1636)
- Add command completion for kamel [\#1635](https://github.com/apache/camel-k/issues/1635)
- Release Camel K 1.1.0 [\#1618](https://github.com/apache/camel-k/issues/1618)
- kamel install not working on vanilla k8 cluster  [\#1552](https://github.com/apache/camel-k/issues/1552)
- Use sinkbinding in operator [\#1548](https://github.com/apache/camel-k/issues/1548)
- Publish yaml schema of design definition on https://www.schemastore.org/json/ [\#1538](https://github.com/apache/camel-k/issues/1538)
- In dev mode, changes to modeline are not taken into account [\#1536](https://github.com/apache/camel-k/issues/1536)
- PublishStrategy missing from IntegrationPlatform build spec [\#1370](https://github.com/apache/camel-k/issues/1370)
- kamel install not working - Error: cannot find automatically a registry where to push images [\#674](https://github.com/apache/camel-k/issues/674)

**Merged pull requests:**

- Add support for oidc \(\#1647\) [\#1694](https://github.com/apache/camel-k/pull/1694) ([nicolaferraro](https://github.com/nicolaferraro))
- Fix \#1636: use messaging/v1beta1 for Knative subscription [\#1669](https://github.com/apache/camel-k/pull/1669) ([nicolaferraro](https://github.com/nicolaferraro))

## [pkg/client/camel/v1.1.0](https://github.com/apache/camel-k/tree/pkg/client/camel/v1.1.0) (2020-07-21)

[Full Changelog](https://github.com/apache/camel-k/compare/v1.1.0...pkg/client/camel/v1.1.0)

## [v1.1.0](https://github.com/apache/camel-k/tree/v1.1.0) (2020-07-21)

[Full Changelog](https://github.com/apache/camel-k/compare/pkg/apis/camel/v1.1.0...v1.1.0)

## [pkg/apis/camel/v1.1.0](https://github.com/apache/camel-k/tree/pkg/apis/camel/v1.1.0) (2020-07-21)

[Full Changelog](https://github.com/apache/camel-k/compare/1.0.1...pkg/apis/camel/v1.1.0)

**Closed issues:**

- Set knative.reply = false in knative environment metadata [\#1617](https://github.com/apache/camel-k/issues/1617)
- Camel-K-Examples: The Kinesis examples fails because of signature [\#1608](https://github.com/apache/camel-k/issues/1608)
- Camel-K-example: The Kinesis source example fails because region is missing [\#1607](https://github.com/apache/camel-k/issues/1607)
- Add 'v' prefix to tag names [\#1601](https://github.com/apache/camel-k/issues/1601)
- Fix generation of traits.yaml file [\#1599](https://github.com/apache/camel-k/issues/1599)
- Create a troubleshooting documentation [\#1595](https://github.com/apache/camel-k/issues/1595)
- The options parameter from the jvm trait should support value containing commas [\#1593](https://github.com/apache/camel-k/issues/1593)
- Restore flow type as object? [\#1590](https://github.com/apache/camel-k/issues/1590)
- Bad help description for kamel init [\#1585](https://github.com/apache/camel-k/issues/1585)
- dependencies trait - Camel shorthand camel:dns vs camel-dns [\#1583](https://github.com/apache/camel-k/issues/1583)
- Camel to Yaml transformation [\#1581](https://github.com/apache/camel-k/issues/1581)
- Running YAML code [\#1579](https://github.com/apache/camel-k/issues/1579)
- Add the camel category to Camel K CRDs [\#1556](https://github.com/apache/camel-k/issues/1556)
- kamel run simple.js --dev hangs after multiple kill/start [\#1505](https://github.com/apache/camel-k/issues/1505)
- Support `make install-crc` [\#1410](https://github.com/apache/camel-k/issues/1410)
- Add a nodeport option to the service trait [\#1321](https://github.com/apache/camel-k/issues/1321)
- Misleading error message in knative trait: cannot find event default [\#1308](https://github.com/apache/camel-k/issues/1308)
- Error when trying create Integration [\#1280](https://github.com/apache/camel-k/issues/1280)
- Verify registry connection on install [\#1192](https://github.com/apache/camel-k/issues/1192)
- Kafka Producer [\#1189](https://github.com/apache/camel-k/issues/1189)
- Add a specific label to the integration pod [\#1129](https://github.com/apache/camel-k/issues/1129)
- Add documentation for integration platform configuration [\#951](https://github.com/apache/camel-k/issues/951)
- kamel --dev stuck when mvn dependencies has problem [\#911](https://github.com/apache/camel-k/issues/911)
- Update Camel-K/Knative examples for 1.0.0-M1 release [\#908](https://github.com/apache/camel-k/issues/908)
- IntegrationPlatform stucked in "status.phase: Starting" [\#466](https://github.com/apache/camel-k/issues/466)
- camel-k operator Error with minikube [\#431](https://github.com/apache/camel-k/issues/431)
- Structured trait configuration [\#395](https://github.com/apache/camel-k/issues/395)

**Merged pull requests:**

- Initial architecture documentation [\#1629](https://github.com/apache/camel-k/pull/1629) ([lburgazzoli](https://github.com/lburgazzoli))
- fix\(doc\): PodMonitoring -\> PodMonitor [\#1628](https://github.com/apache/camel-k/pull/1628) ([astefanutti](https://github.com/astefanutti))
- doc: Init troubleshooting guide [\#1627](https://github.com/apache/camel-k/pull/1627) ([astefanutti](https://github.com/astefanutti))
- chore\(doc\): Polish secured monitoring proposal [\#1626](https://github.com/apache/camel-k/pull/1626) ([astefanutti](https://github.com/astefanutti))
- doc: Update secured monitoring proposal for Quarkus/Knative single-port [\#1625](https://github.com/apache/camel-k/pull/1625) ([astefanutti](https://github.com/astefanutti))
- Fix \#1599: generate good trait doc [\#1622](https://github.com/apache/camel-k/pull/1622) ([nicolaferraro](https://github.com/nicolaferraro))
- Init .asf.yaml file [\#1621](https://github.com/apache/camel-k/pull/1621) ([astefanutti](https://github.com/astefanutti))
- Upgrade to staged Camel K runtime 1.4.0 \(Camel 3.4.0,Camel-Quarkus 1.… [\#1620](https://github.com/apache/camel-k/pull/1620) ([nicolaferraro](https://github.com/nicolaferraro))
- Set reply=false by default from knative broker and channel [\#1619](https://github.com/apache/camel-k/pull/1619) ([nicolaferraro](https://github.com/nicolaferraro))
- \#1556 - Add the camel category to Camel K CRDs [\#1615](https://github.com/apache/camel-k/pull/1615) ([ipolyzos](https://github.com/ipolyzos))
- Add examples back into the affinity trait documentation [\#1613](https://github.com/apache/camel-k/pull/1613) ([astefanutti](https://github.com/astefanutti))
- feat: expose Operator ImagePullPolicy option and set it to Always in … [\#1612](https://github.com/apache/camel-k/pull/1612) ([johnpoth](https://github.com/johnpoth))
- doc: add toc to readme [\#1606](https://github.com/apache/camel-k/pull/1606) ([tadayosi](https://github.com/tadayosi))
- Upgrade Knative to version 0.15.0 [\#1605](https://github.com/apache/camel-k/pull/1605) ([oscerd](https://github.com/oscerd))
- Fix \#1601: add v prefix to future tags [\#1603](https://github.com/apache/camel-k/pull/1603) ([nicolaferraro](https://github.com/nicolaferraro))
- feat: Structured traits configuration serialization [\#1600](https://github.com/apache/camel-k/pull/1600) ([astefanutti](https://github.com/astefanutti))
- Fix typo missing space "featuresare" -\> "features are" [\#1598](https://github.com/apache/camel-k/pull/1598) ([apupier](https://github.com/apupier))
- chore: Add information on how to debug the camel-k operator [\#1597](https://github.com/apache/camel-k/pull/1597) ([johnpoth](https://github.com/johnpoth))
- Fixes incomplete help message [\#1596](https://github.com/apache/camel-k/pull/1596) ([orpiske](https://github.com/orpiske))
- Submit secured monitoring proposal [\#1594](https://github.com/apache/camel-k/pull/1594) ([astefanutti](https://github.com/astefanutti))
- Document CRC's insecure Docker registry \#1410 [\#1592](https://github.com/apache/camel-k/pull/1592) ([johnpoth](https://github.com/johnpoth))
- fix\(api\): Declare integration Flow as json.RawMessage [\#1591](https://github.com/apache/camel-k/pull/1591) ([astefanutti](https://github.com/astefanutti))
- fix\(doc\): Correct title levels in monitoring documentation [\#1589](https://github.com/apache/camel-k/pull/1589) ([astefanutti](https://github.com/astefanutti))
- Monitoring docs: Fixed link [\#1588](https://github.com/apache/camel-k/pull/1588) ([oscerd](https://github.com/oscerd))
- feat: Integration scale sub-resource works with HPA [\#1587](https://github.com/apache/camel-k/pull/1587) ([astefanutti](https://github.com/astefanutti))
- doc: Complete the monitoring documentation [\#1586](https://github.com/apache/camel-k/pull/1586) ([astefanutti](https://github.com/astefanutti))
- feat\(crd\): Generate CRDs from APIs [\#1582](https://github.com/apache/camel-k/pull/1582) ([astefanutti](https://github.com/astefanutti))
- Fix typo fo -\> of [\#1578](https://github.com/apache/camel-k/pull/1578) ([apupier](https://github.com/apupier))
- add documentation for CRC \#1410 [\#1570](https://github.com/apache/camel-k/pull/1570) ([johnpoth](https://github.com/johnpoth))
- doc: Add monitoring documentation [\#1569](https://github.com/apache/camel-k/pull/1569) ([astefanutti](https://github.com/astefanutti))
- fix typo [\#1564](https://github.com/apache/camel-k/pull/1564) ([nicolaferraro](https://github.com/nicolaferraro))
- Added token as parameter to backport gh action [\#1563](https://github.com/apache/camel-k/pull/1563) ([oscerd](https://github.com/oscerd))
- Added back token for gh action [\#1561](https://github.com/apache/camel-k/pull/1561) ([oscerd](https://github.com/oscerd))
- Switch to Syndesis backport github action [\#1560](https://github.com/apache/camel-k/pull/1560) ([oscerd](https://github.com/oscerd))
- fix\(jvm\): Integration do not shutdown gracefully when jvm.print-command is set [\#1558](https://github.com/apache/camel-k/pull/1558) ([astefanutti](https://github.com/astefanutti))
- fix\(util\): line break after "Monitoring pod ..." message [\#1554](https://github.com/apache/camel-k/pull/1554) ([tadayosi](https://github.com/tadayosi))
- fix: bug in utility function [\#1553](https://github.com/apache/camel-k/pull/1553) ([nicolaferraro](https://github.com/nicolaferraro))
- support make install-crc \#1410 [\#1544](https://github.com/apache/camel-k/pull/1544) ([johnpoth](https://github.com/johnpoth))
- Cannot expose knative endpoints in YAML [\#1540](https://github.com/apache/camel-k/pull/1540) ([lburgazzoli](https://github.com/lburgazzoli))
- chore: add a backport action [\#1531](https://github.com/apache/camel-k/pull/1531) ([nicolaferraro](https://github.com/nicolaferraro))
- fix\(doc\): remove redundant '/build' entry in project structure [\#1530](https://github.com/apache/camel-k/pull/1530) ([tadayosi](https://github.com/tadayosi))
- fix: JVM trait overrides other traits JVM arguments [\#1528](https://github.com/apache/camel-k/pull/1528) ([astefanutti](https://github.com/astefanutti))
- \#1524 set the OLM channel used on install to 'stable' [\#1527](https://github.com/apache/camel-k/pull/1527) ([ipolyzos](https://github.com/ipolyzos))
-  \#1321 add support for nodeport type for services [\#1526](https://github.com/apache/camel-k/pull/1526) ([ipolyzos](https://github.com/ipolyzos))
- Add ikb as alias for builds.camel.apache.org [\#1521](https://github.com/apache/camel-k/pull/1521) ([lburgazzoli](https://github.com/lburgazzoli))
- fix for \#1511 [\#1517](https://github.com/apache/camel-k/pull/1517) ([ipolyzos](https://github.com/ipolyzos))
- CLI - Make kamel run handle github urls that are not raw [\#1515](https://github.com/apache/camel-k/pull/1515) ([lburgazzoli](https://github.com/lburgazzoli))
- chore\(release\): bump version to 1.1.0-SNAPSHOT and update OLM/HELM [\#1510](https://github.com/apache/camel-k/pull/1510) ([nicolaferraro](https://github.com/nicolaferraro))

## [1.0.1](https://github.com/apache/camel-k/tree/1.0.1) (2020-06-25)

[Full Changelog](https://github.com/apache/camel-k/compare/1.0.0...1.0.1)

**Closed issues:**

- Switch to Syndesis gh action for backporting [\#1559](https://github.com/apache/camel-k/issues/1559)
- Integration do not shutdown gracefully when `jvm.print-command` is set [\#1557](https://github.com/apache/camel-k/issues/1557)
- Adding dependencies on external packages [\#1546](https://github.com/apache/camel-k/issues/1546)
- application.properties missing when using latest kamel-1.0.0 release [\#1542](https://github.com/apache/camel-k/issues/1542)
- Package not found [\#1541](https://github.com/apache/camel-k/issues/1541)
- Can't connect to prometheus endpoint in 1.0.0 \(not running?\) [\#1525](https://github.com/apache/camel-k/issues/1525)
- Create a 1.0.x branch  [\#1519](https://github.com/apache/camel-k/issues/1519)
- Update the kamel homebrew formula to v1.0.0 [\#1512](https://github.com/apache/camel-k/issues/1512)
- \[regression\]kamel help trait --all -o json returns both yaml and json output [\#1511](https://github.com/apache/camel-k/issues/1511)
- addRoutes problem when running 01-Basic example from new camel-k-example docs [\#1509](https://github.com/apache/camel-k/issues/1509)
- CLI - Make kamel run handle github urls that are not raw [\#1497](https://github.com/apache/camel-k/issues/1497)
- metrics: in quarkus mode, use microprofile metrics in place of the prometheus agent [\#1263](https://github.com/apache/camel-k/issues/1263)
- Add time it takes to build a kit in the builder pod log [\#1186](https://github.com/apache/camel-k/issues/1186)
- Saga example [\#1097](https://github.com/apache/camel-k/issues/1097)
- java.lang.NoSuchMethodError: com.javainuse.route.SimpleRouteBuilder.getContext\(\)Lorg/apache/camel/model/ModelCamelContext; [\#1073](https://github.com/apache/camel-k/issues/1073)
- Error after cluster restart [\#933](https://github.com/apache/camel-k/issues/933)
- Error pushing image to camel-k-ctx [\#853](https://github.com/apache/camel-k/issues/853)
- service and route not created when using --open-api parameter [\#843](https://github.com/apache/camel-k/issues/843)
- one page of documentation to install Camel-K on Minikube is incorrect [\#798](https://github.com/apache/camel-k/issues/798)
- Kamel run Sample.java --dev hanged with "Waiting for Platform". Error - Non-resolvable import POM [\#677](https://github.com/apache/camel-k/issues/677)
- Sample does not work after change camel version [\#664](https://github.com/apache/camel-k/issues/664)
- Cannot load Knative configuration from file or env variable [\#654](https://github.com/apache/camel-k/issues/654)
- Release 1.0.1 [\#1565](https://github.com/apache/camel-k/issues/1565)
- Cannot expose knative endpoints in YAML [\#1539](https://github.com/apache/camel-k/issues/1539)
- kamel install uses the wrong channel in OLM [\#1524](https://github.com/apache/camel-k/issues/1524)

**Merged pull requests:**

-  \#1524 set the OLM channel used on install to 'stable' [\#1532](https://github.com/apache/camel-k/pull/1532) ([oscerd](https://github.com/oscerd))
- fix: JVM trait overrides other traits JVM arguments [\#1529](https://github.com/apache/camel-k/pull/1529) ([astefanutti](https://github.com/astefanutti))
- Backport fix for \#1511 in release-1.0.x [\#1520](https://github.com/apache/camel-k/pull/1520) ([nicolaferraro](https://github.com/nicolaferraro))

## [1.0.0](https://github.com/apache/camel-k/tree/1.0.0) (2020-06-05)

[Full Changelog](https://github.com/apache/camel-k/compare/1.0.0-nightly.202005130003...1.0.0)

**Closed issues:**

- Print the JVM command with its parameters in integration pod logs [\#1495](https://github.com/apache/camel-k/issues/1495)
- Converting ProcessorDefinition to DSL and interfacing with camel k [\#1469](https://github.com/apache/camel-k/issues/1469)
- vanilla minikube - CronJobs are not being built from operator [\#1442](https://github.com/apache/camel-k/issues/1442)
- Move languages documentation to camel-k-runtime [\#1427](https://github.com/apache/camel-k/issues/1427)
- Kotlin documentation incorrect for kotlin DSL [\#1426](https://github.com/apache/camel-k/issues/1426)
- Switchting to quarkus fails to build because of missing versions [\#1423](https://github.com/apache/camel-k/issues/1423)
- support for jitpack dependencies [\#1407](https://github.com/apache/camel-k/issues/1407)
- Avoid requirements of a kubeconfig when using `kamel init xxx` command [\#1368](https://github.com/apache/camel-k/issues/1368)
- Support for local development using containers [\#1339](https://github.com/apache/camel-k/issues/1339)
- User cannot create resource in API group [\#1302](https://github.com/apache/camel-k/issues/1302)
- Support of 3rd party camel components, data formats and type converters [\#1285](https://github.com/apache/camel-k/issues/1285)
- Camel-k with Spring boot  [\#1176](https://github.com/apache/camel-k/issues/1176)
- routes-rest.js not working [\#1174](https://github.com/apache/camel-k/issues/1174)
- Unable to run Knative integration [\#1169](https://github.com/apache/camel-k/issues/1169)
- Basic javascript example generates "Multiple applicable overloads found for method name process" [\#1144](https://github.com/apache/camel-k/issues/1144)
- Basic groovy example generates "Ambiguous method overloading for method org.apache.camel.model.RouteDefinition\#process" [\#1143](https://github.com/apache/camel-k/issues/1143)
- Multiple traits to create a service [\#1061](https://github.com/apache/camel-k/issues/1061)
- Camel K Operator is not reading the Telegram endpoint API-Key properly. [\#1039](https://github.com/apache/camel-k/issues/1039)
- No interface for setting the number of pods on which an integration is to be deployed [\#1032](https://github.com/apache/camel-k/issues/1032)
- Is there a way to co-locate the camel-k-operator, builder and PV in the same node [\#924](https://github.com/apache/camel-k/issues/924)
- Camel-K build fails with error: open /workspace/builder-656588331/package/context/Dockerfile: no such file or directory [\#923](https://github.com/apache/camel-k/issues/923)
- Add support for defining the loader to be used by the runtime [\#910](https://github.com/apache/camel-k/issues/910)
- Support shebang to precise that a file is a Camel-K executable file [\#754](https://github.com/apache/camel-k/issues/754)
- Make sure global and local operators can cohexist [\#751](https://github.com/apache/camel-k/issues/751)
- Cannot reinstall the kamel in minikube [\#711](https://github.com/apache/camel-k/issues/711)
- \[DISCUSS\] Vision for Knative Sources [\#639](https://github.com/apache/camel-k/issues/639)
- Remove maven wrapper from camel-k [\#629](https://github.com/apache/camel-k/issues/629)
- Allow "kamel" to install a specific version of camel k [\#604](https://github.com/apache/camel-k/issues/604)
- Knative minikube service failure [\#482](https://github.com/apache/camel-k/issues/482)
- Add support for secure registries in Kubernetes mode [\#139](https://github.com/apache/camel-k/issues/139)
- Add health checks and additional monitoring [\#58](https://github.com/apache/camel-k/issues/58)
- Release Camel K 1.0.0 [\#1498](https://github.com/apache/camel-k/issues/1498)
- Add an opentracing trait [\#1489](https://github.com/apache/camel-k/issues/1489)
- Support inline YAML DSL  [\#1470](https://github.com/apache/camel-k/issues/1470)
- Kamel uninstall leftovers [\#1465](https://github.com/apache/camel-k/issues/1465)
- Refactor API module to include it in master [\#1463](https://github.com/apache/camel-k/issues/1463)
- sanitized integration name on Windows contains whole path [\#1462](https://github.com/apache/camel-k/issues/1462)
- Unable to start Prometheus when Knative enabled.  [\#1459](https://github.com/apache/camel-k/issues/1459)
- Customizing prometheus configuration fails with MountVolume issue [\#1451](https://github.com/apache/camel-k/issues/1451)
- servicemonitor is not created for missing role on camel-k-operator [\#1450](https://github.com/apache/camel-k/issues/1450)
- Support setting parameters as modeline options [\#1449](https://github.com/apache/camel-k/issues/1449)
- Issue when fixing erroneous resource [\#1446](https://github.com/apache/camel-k/issues/1446)
- Can't install camel-k helm chart in more than one namespace [\#1443](https://github.com/apache/camel-k/issues/1443)
- Vanilla Minishift install not working. [\#1429](https://github.com/apache/camel-k/issues/1429)
- Use /openapi.json as default location for OpenAPI data [\#1428](https://github.com/apache/camel-k/issues/1428)
- CamelSources not working in nightly [\#1419](https://github.com/apache/camel-k/issues/1419)
- Add license headers to files generated with kamel init [\#1417](https://github.com/apache/camel-k/issues/1417)
- Spectrum publisher still slow [\#1416](https://github.com/apache/camel-k/issues/1416)
- Support Knative channels v1beta1 versions [\#1414](https://github.com/apache/camel-k/issues/1414)
- Camel Cron trait page is rendered incorrectly [\#1401](https://github.com/apache/camel-k/issues/1401)
- Detect camel-microprofile-fault-tolerance for Circuit Breaker [\#1396](https://github.com/apache/camel-k/issues/1396)
- Events should be shown also when running the integration with --logs [\#1395](https://github.com/apache/camel-k/issues/1395)
- Cannot switch between cron and normal deployment in dev mode [\#1394](https://github.com/apache/camel-k/issues/1394)
- The camel-k:edit clusterrole is not always created [\#1393](https://github.com/apache/camel-k/issues/1393)
- Add some sugar for additional sources [\#1388](https://github.com/apache/camel-k/issues/1388)
- Quarkus runner jar is never rebuilt on layered kits [\#1387](https://github.com/apache/camel-k/issues/1387)
- Allow to define custom prometheus exporter [\#1384](https://github.com/apache/camel-k/issues/1384)
- Cannot manage prometheus resources [\#1382](https://github.com/apache/camel-k/issues/1382)
- OpenShift CLI download links are not populated when installing from operator hub [\#1379](https://github.com/apache/camel-k/issues/1379)
- Add more build events [\#1367](https://github.com/apache/camel-k/issues/1367)
- Knative API example becomes unstable [\#1364](https://github.com/apache/camel-k/issues/1364)
- Refactor CI tests to reduce feedback time [\#1362](https://github.com/apache/camel-k/issues/1362)
- Add a simple API tutorial for the getting started experience [\#1361](https://github.com/apache/camel-k/issues/1361)
- Upgrade Knative CI to 0.13.x [\#1359](https://github.com/apache/camel-k/issues/1359)
- Provide description in JSON output for traits [\#1358](https://github.com/apache/camel-k/issues/1358)
- Kamel uninstall does not remove everything in OLM mode [\#1356](https://github.com/apache/camel-k/issues/1356)
- Standard rest services can be bound to 8080 by default [\#1347](https://github.com/apache/camel-k/issues/1347)
- 'context' object not available in JavaScript integrations [\#1346](https://github.com/apache/camel-k/issues/1346)
- Probes not bound to Knative services [\#1341](https://github.com/apache/camel-k/issues/1341)
- ConfigMap xxx-openapi-000 not found [\#1340](https://github.com/apache/camel-k/issues/1340)
- Wrong knative dependency [\#1337](https://github.com/apache/camel-k/issues/1337)
- Adapt cron trait to latest camel-k-runtime [\#1329](https://github.com/apache/camel-k/issues/1329)
- Switch to java 11 by default ? [\#1327](https://github.com/apache/camel-k/issues/1327)
- Add a 3scale addon [\#1325](https://github.com/apache/camel-k/issues/1325)
- Add e2e test for the multiple files scenario [\#1320](https://github.com/apache/camel-k/issues/1320)
- Rename rest-dsl trait to openapi [\#1317](https://github.com/apache/camel-k/issues/1317)
- Add some sugar to rest APIs [\#1316](https://github.com/apache/camel-k/issues/1316)
- Errors in incremental build on OCP4 [\#1314](https://github.com/apache/camel-k/issues/1314)
- Support OpenAPI 3 [\#1310](https://github.com/apache/camel-k/issues/1310)
- Cannot patch event log errors [\#1309](https://github.com/apache/camel-k/issues/1309)
- Events are reported twice in dev mode [\#1297](https://github.com/apache/camel-k/issues/1297)
- Support Knative eventing v1beta1 APIs [\#1212](https://github.com/apache/camel-k/issues/1212)
- Add condition/status to monitor running state of the integration [\#1171](https://github.com/apache/camel-k/issues/1171)
- Document YAML DSL on the website [\#1114](https://github.com/apache/camel-k/issues/1114)
- Hide some CRDs from developer catalog [\#1045](https://github.com/apache/camel-k/issues/1045)
- GC trait fails on unknown types [\#1027](https://github.com/apache/camel-k/issues/1027)
- Kamel install -o yaml should not try to connect to a cluster [\#885](https://github.com/apache/camel-k/issues/885)
- Wrong links from second page on [\#827](https://github.com/apache/camel-k/issues/827)
- Update installation documentation [\#823](https://github.com/apache/camel-k/issues/823)
- Builds are 1200% slower on Openshift 4 [\#813](https://github.com/apache/camel-k/issues/813)
- CLI too slow on remote clusters [\#792](https://github.com/apache/camel-k/issues/792)
- Add .flow example to e2e tests [\#780](https://github.com/apache/camel-k/issues/780)
- Propagate build errors up to the integration [\#763](https://github.com/apache/camel-k/issues/763)
- Add timeout to maven operations [\#761](https://github.com/apache/camel-k/issues/761)
- Service trait: confusing behavior [\#753](https://github.com/apache/camel-k/issues/753)
- Include checksum when checking for compatible kits [\#743](https://github.com/apache/camel-k/issues/743)
- validate maven artifacts [\#742](https://github.com/apache/camel-k/issues/742)
- camel-k-cache crashes on minikube [\#736](https://github.com/apache/camel-k/issues/736)
- Move to knative serving v1beta1 apis [\#729](https://github.com/apache/camel-k/issues/729)
- Add the ASL license header on the source file [\#709](https://github.com/apache/camel-k/issues/709)
- Add e2e tests in CI [\#693](https://github.com/apache/camel-k/issues/693)
- Add version information to all resources [\#692](https://github.com/apache/camel-k/issues/692)
- Insufficient permission when installing 0.3.3 from operatorhub [\#686](https://github.com/apache/camel-k/issues/686)
- Remove predefined images [\#644](https://github.com/apache/camel-k/issues/644)
- Define a meta-controller for Camel-based Knative sources [\#641](https://github.com/apache/camel-k/issues/641)
- Add support for Knative Broker/Trigger [\#638](https://github.com/apache/camel-k/issues/638)
- Testing Camel K integrations [\#600](https://github.com/apache/camel-k/issues/600)
- Add conditions to camel-k CRs [\#594](https://github.com/apache/camel-k/issues/594)
- Generate Specific Knative Sources per Camel Component [\#569](https://github.com/apache/camel-k/issues/569)
- Automatic installation when creating a Knative Camel Source [\#568](https://github.com/apache/camel-k/issues/568)
- Support for multi-tenancy [\#523](https://github.com/apache/camel-k/issues/523)
- Enable the scale sub resource on integrations [\#353](https://github.com/apache/camel-k/issues/353)
- VSCode extension [\#338](https://github.com/apache/camel-k/issues/338)
- Improve IDE auto-completion [\#311](https://github.com/apache/camel-k/issues/311)
- Be revision-friendly and do not use revisions by default on Knative profile [\#289](https://github.com/apache/camel-k/issues/289)
- Rename 'context' term used by Camel K. [\#206](https://github.com/apache/camel-k/issues/206)
- Publish Helm charts [\#168](https://github.com/apache/camel-k/issues/168)

**Merged pull requests:**

- chore\(ci\): fix ci repository configuration [\#1504](https://github.com/apache/camel-k/pull/1504) ([nicolaferraro](https://github.com/nicolaferraro))
- chore\(release\): bump runtime to 1.3.0 [\#1501](https://github.com/apache/camel-k/pull/1501) ([nicolaferraro](https://github.com/nicolaferraro))
- fix\(jvm\): Bind all interfaces to restore remote debugging with newer JDK versions [\#1500](https://github.com/apache/camel-k/pull/1500) ([astefanutti](https://github.com/astefanutti))
- Add stale action [\#1499](https://github.com/apache/camel-k/pull/1499) ([lburgazzoli](https://github.com/lburgazzoli))
- feat: Add option to print JVM command in integration logs [\#1496](https://github.com/apache/camel-k/pull/1496) ([astefanutti](https://github.com/astefanutti))
- chore\(ci\): bump setup jdk action in CI [\#1494](https://github.com/apache/camel-k/pull/1494) ([nicolaferraro](https://github.com/nicolaferraro))
- Avoid requirements of a kubeconfig when using  command [\#1493](https://github.com/apache/camel-k/pull/1493) ([lburgazzoli](https://github.com/lburgazzoli))
- Add tracing trait and automatically discover Jaeger [\#1492](https://github.com/apache/camel-k/pull/1492) ([nicolaferraro](https://github.com/nicolaferraro))
- support for jitpack dependencies [\#1491](https://github.com/apache/camel-k/pull/1491) ([lburgazzoli](https://github.com/lburgazzoli))
- feat: Prometheus support for Quarkus based on MicroProfile Metrics [\#1490](https://github.com/apache/camel-k/pull/1490) ([astefanutti](https://github.com/astefanutti))
- chore\(keys\): update PGP key [\#1488](https://github.com/apache/camel-k/pull/1488) ([nicolaferraro](https://github.com/nicolaferraro))
- Fix \#1396: use circuitbreaker capability from runtime [\#1486](https://github.com/apache/camel-k/pull/1486) ([nicolaferraro](https://github.com/nicolaferraro))
- fix: Regenerate catalogs with Camel version 3.3.0 [\#1485](https://github.com/apache/camel-k/pull/1485) ([astefanutti](https://github.com/astefanutti))
- sanitized integration name on Windows contains whole path [\#1484](https://github.com/apache/camel-k/pull/1484) ([oscerd](https://github.com/oscerd))
- chore\(ci\): install latest openjdk in Travis [\#1483](https://github.com/apache/camel-k/pull/1483) ([nicolaferraro](https://github.com/nicolaferraro))
- Upgrade Operator SDK to version 0.17.1 [\#1482](https://github.com/apache/camel-k/pull/1482) ([astefanutti](https://github.com/astefanutti))
- Code clean-up [\#1481](https://github.com/apache/camel-k/pull/1481) ([astefanutti](https://github.com/astefanutti))
- chore\(builder\): enable Spectrum to publish to authenticated registries [\#1479](https://github.com/apache/camel-k/pull/1479) ([nicolaferraro](https://github.com/nicolaferraro))
- Make Prometheus trait compatible with Knative Serving [\#1478](https://github.com/apache/camel-k/pull/1478) ([astefanutti](https://github.com/astefanutti))
- chore\(client\): generate client interface for catalog [\#1477](https://github.com/apache/camel-k/pull/1477) ([nicolaferraro](https://github.com/nicolaferraro))
- Uninstall all doc [\#1475](https://github.com/apache/camel-k/pull/1475) ([ipolyzos](https://github.com/ipolyzos))
- fix: Use platform HTTP server in REST DSL example [\#1474](https://github.com/apache/camel-k/pull/1474) ([astefanutti](https://github.com/astefanutti))
- Fixed link in Quarkus.adoc [\#1473](https://github.com/apache/camel-k/pull/1473) ([oscerd](https://github.com/oscerd))
- Fix \#1470: support inline YAML [\#1472](https://github.com/apache/camel-k/pull/1472) ([nicolaferraro](https://github.com/nicolaferraro))
- Update uninstalling.doc [\#1467](https://github.com/apache/camel-k/pull/1467) ([ipolyzos](https://github.com/ipolyzos))
- \#1465 remove crd and clusterrole on uninstall [\#1466](https://github.com/apache/camel-k/pull/1466) ([ipolyzos](https://github.com/ipolyzos))
- Fix \#1463: add apis and client as submodule [\#1464](https://github.com/apache/camel-k/pull/1464) ([nicolaferraro](https://github.com/nicolaferraro))
- Fix \#1045: hide internal CRDs in OLM console [\#1461](https://github.com/apache/camel-k/pull/1461) ([nicolaferraro](https://github.com/nicolaferraro))
- Make cron work on quarkus runtime [\#1460](https://github.com/apache/camel-k/pull/1460) ([nicolaferraro](https://github.com/nicolaferraro))
- Allow the short syntax in knative endpoints [\#1458](https://github.com/apache/camel-k/pull/1458) ([nicolaferraro](https://github.com/nicolaferraro))
- Remove unused import package in example [\#1457](https://github.com/apache/camel-k/pull/1457) ([apupier](https://github.com/apupier))

## [1.0.0-nightly.202005130003](https://github.com/apache/camel-k/tree/1.0.0-nightly.202005130003) (2020-05-11)

[Full Changelog](https://github.com/apache/camel-k/compare/1.0.0-nightly.202005060045...1.0.0-nightly.202005130003)

**Closed issues:**

- \(vanilla minikube\) RestDSL.java not working out of the box [\#1452](https://github.com/apache/camel-k/issues/1452)
- Make kamel cli installable via Homebrew [\#1369](https://github.com/apache/camel-k/issues/1369)

**Merged pull requests:**

- Fix \#1449: add support for modeline options [\#1455](https://github.com/apache/camel-k/pull/1455) ([nicolaferraro](https://github.com/nicolaferraro))
- information to update the homebrew formula [\#1454](https://github.com/apache/camel-k/pull/1454) ([ipolyzos](https://github.com/ipolyzos))
- Fix \#1450: fix servicemonitor roles on direct install [\#1453](https://github.com/apache/camel-k/pull/1453) ([nicolaferraro](https://github.com/nicolaferraro))
- Helm fix [\#1448](https://github.com/apache/camel-k/pull/1448) ([nicolaferraro](https://github.com/nicolaferraro))

## [1.0.0-nightly.202005060045](https://github.com/apache/camel-k/tree/1.0.0-nightly.202005060045) (2020-05-05)

[Full Changelog](https://github.com/apache/camel-k/compare/1.0.0-nightly.202004171040...1.0.0-nightly.202005060045)

**Closed issues:**

- Does any company use Camel K in production environment? [\#1436](https://github.com/apache/camel-k/issues/1436)
- Kotlin Autocomplete in Intellij? [\#1425](https://github.com/apache/camel-k/issues/1425)
- @PropertyInject does not work in @BindToRegistry methods [\#1422](https://github.com/apache/camel-k/issues/1422)
- Not working Ubuntu 18 Minikube [\#1412](https://github.com/apache/camel-k/issues/1412)
- Error during unshare\(CLONE\_NEWUSER\): Invalid argument [\#1408](https://github.com/apache/camel-k/issues/1408)
- re-organize e2e tests [\#1404](https://github.com/apache/camel-k/issues/1404)

**Merged pull requests:**

- Fix \#1446 and \#1395: completely update integration resource on redepl… [\#1447](https://github.com/apache/camel-k/pull/1447) ([nicolaferraro](https://github.com/nicolaferraro))
- Fix \#1367: add more build events [\#1444](https://github.com/apache/camel-k/pull/1444) ([nicolaferraro](https://github.com/nicolaferraro))
- Partially Fixes Camel 14995: generates master and 3/threescale traits docs. [\#1441](https://github.com/apache/camel-k/pull/1441) ([djencks](https://github.com/djencks))
- Fixes CAMEL-14993 generate traits table with Antora, etc. [\#1440](https://github.com/apache/camel-k/pull/1440) ([djencks](https://github.com/djencks))
- Update 3scale.go [\#1439](https://github.com/apache/camel-k/pull/1439) ([rajatdiptabiswas](https://github.com/rajatdiptabiswas))
- Add ready condition to the integration [\#1438](https://github.com/apache/camel-k/pull/1438) ([nicolaferraro](https://github.com/nicolaferraro))
- Fix \#1414: upgrade to knative 0.14 and support v1beta1 channels and b… [\#1437](https://github.com/apache/camel-k/pull/1437) ([nicolaferraro](https://github.com/nicolaferraro))
- Attempt to upgrade knative CI [\#1435](https://github.com/apache/camel-k/pull/1435) ([nicolaferraro](https://github.com/nicolaferraro))
- Fix \#1416: make minikube experience super-fast again [\#1434](https://github.com/apache/camel-k/pull/1434) ([nicolaferraro](https://github.com/nicolaferraro))
- Fixes CAMEL-14975 \(2 of 3\) Issue 14975 move lang to runtime: remove moved files [\#1433](https://github.com/apache/camel-k/pull/1433) ([djencks](https://github.com/djencks))
- Fix 1401 [\#1432](https://github.com/apache/camel-k/pull/1432) ([oscerd](https://github.com/oscerd))
- chore\(CI\): add knative sources test with YAKS [\#1431](https://github.com/apache/camel-k/pull/1431) ([nicolaferraro](https://github.com/nicolaferraro))
- Fix for \#1358 [\#1430](https://github.com/apache/camel-k/pull/1430) ([dobozysaurus](https://github.com/dobozysaurus))
- Fix knative sources [\#1421](https://github.com/apache/camel-k/pull/1421) ([nicolaferraro](https://github.com/nicolaferraro))
- Add license headers to files generated with kamel init [\#1420](https://github.com/apache/camel-k/pull/1420) ([ipolyzos](https://github.com/ipolyzos))
- Attempt to make CI better [\#1418](https://github.com/apache/camel-k/pull/1418) ([nicolaferraro](https://github.com/nicolaferraro))
- Properly handle platform-http component in routes [\#1411](https://github.com/apache/camel-k/pull/1411) ([lburgazzoli](https://github.com/lburgazzoli))
- Add some sugar for additional sources [\#1400](https://github.com/apache/camel-k/pull/1400) ([lburgazzoli](https://github.com/lburgazzoli))

## [1.0.0-nightly.202004171040](https://github.com/apache/camel-k/tree/1.0.0-nightly.202004171040) (2020-04-17)

[Full Changelog](https://github.com/apache/camel-k/compare/1.0.0-nightly.202003261646...1.0.0-nightly.202004171040)

**Closed issues:**

- Failed to read a GraphQL query from a ConfigMap [\#1403](https://github.com/apache/camel-k/issues/1403)
- Adding the http4  dependency causes the deployment of an integration to fail [\#1386](https://github.com/apache/camel-k/issues/1386)
- How can I run a whole project with many integration files in a comfortable way? [\#1375](https://github.com/apache/camel-k/issues/1375)

**Merged pull requests:**

- Fixed cron trait docs [\#1405](https://github.com/apache/camel-k/pull/1405) ([oscerd](https://github.com/oscerd))
- Fix \#1393: create standard role at operator startup in OLM [\#1399](https://github.com/apache/camel-k/pull/1399) ([nicolaferraro](https://github.com/nicolaferraro))
- Cannot switch between cron and normal deployment in dev mode [\#1398](https://github.com/apache/camel-k/pull/1398) ([lburgazzoli](https://github.com/lburgazzoli))
- Fix \#1384: allow to define an alternative prometheus config [\#1397](https://github.com/apache/camel-k/pull/1397) ([nicolaferraro](https://github.com/nicolaferraro))
- Fix YAML rest-dsl inspections [\#1392](https://github.com/apache/camel-k/pull/1392) ([lburgazzoli](https://github.com/lburgazzoli))
- chore\(builder\): small refactor to image context lookup [\#1391](https://github.com/apache/camel-k/pull/1391) ([lburgazzoli](https://github.com/lburgazzoli))
- chore\(ci\): fix Knative CI [\#1390](https://github.com/apache/camel-k/pull/1390) ([nicolaferraro](https://github.com/nicolaferraro))
- Include checksum when checking for compatible kits [\#1389](https://github.com/apache/camel-k/pull/1389) ([lburgazzoli](https://github.com/lburgazzoli))
- bug: fix minor repetition of example heading in cron trait [\#1385](https://github.com/apache/camel-k/pull/1385) ([AemieJ](https://github.com/AemieJ))
- fix \#1382: enable prometheus roles when installing from olm and helm [\#1383](https://github.com/apache/camel-k/pull/1383) ([nicolaferraro](https://github.com/nicolaferraro))
- Switch to java 11 by default and adapt to runtime 1.3.x [\#1381](https://github.com/apache/camel-k/pull/1381) ([lburgazzoli](https://github.com/lburgazzoli))
- Fix \#1379: make download link available also when installing from operator hub [\#1380](https://github.com/apache/camel-k/pull/1380) ([nicolaferraro](https://github.com/nicolaferraro))
- Fix \#1356: remove namespace resources on uninstall and fix maven-sett… [\#1378](https://github.com/apache/camel-k/pull/1378) ([nicolaferraro](https://github.com/nicolaferraro))

## [1.0.0-nightly.202003261646](https://github.com/apache/camel-k/tree/1.0.0-nightly.202003261646) (2020-03-26)

[Full Changelog](https://github.com/apache/camel-k/compare/1.0.0-RC2...1.0.0-nightly.202003261646)

**Closed issues:**

- Nightly builds? [\#1365](https://github.com/apache/camel-k/issues/1365)
- unsupported secret type for registry authentication [\#1360](https://github.com/apache/camel-k/issues/1360)
- How can I modify registries in buildah container? [\#1357](https://github.com/apache/camel-k/issues/1357)
- Remove human-readable format from timer period computation in cron trait [\#1350](https://github.com/apache/camel-k/issues/1350)
- Cannot find RestApiConsumerFactory [\#1348](https://github.com/apache/camel-k/issues/1348)
- Error creating build container: no space left on device [\#1333](https://github.com/apache/camel-k/issues/1333)
- Catalog generation does not take into account the runtime provider to determine the catalog name [\#1312](https://github.com/apache/camel-k/issues/1312)
- Add superfast builds for dev clusters [\#1305](https://github.com/apache/camel-k/issues/1305)
- Unable to run saga sample [\#1304](https://github.com/apache/camel-k/issues/1304)
- \[Enhancement\]Improve log message when image not available in cache [\#1301](https://github.com/apache/camel-k/issues/1301)
- Unable to run the polyglot sample [\#1300](https://github.com/apache/camel-k/issues/1300)
- kamel version should report version number in offline mode [\#1298](https://github.com/apache/camel-k/issues/1298)
- ClassNotFoundException from pom-catalog.xml [\#1293](https://github.com/apache/camel-k/issues/1293)
- Defining datasource in groovy and using in XML routes [\#892](https://github.com/apache/camel-k/issues/892)
- Inject CamelContext into Java DSL RouteBuilder [\#563](https://github.com/apache/camel-k/issues/563)
- Error with Knative probes [\#528](https://github.com/apache/camel-k/issues/528)

**Merged pull requests:**

- chore\(build\): fix package\_artifact.sh script call [\#1374](https://github.com/apache/camel-k/pull/1374) ([johnpoth](https://github.com/johnpoth))
- Add nightly releases [\#1373](https://github.com/apache/camel-k/pull/1373) ([nicolaferraro](https://github.com/nicolaferraro))
- Fix \#1364: only delete direct children of the integration during gc [\#1372](https://github.com/apache/camel-k/pull/1372) ([nicolaferraro](https://github.com/nicolaferraro))
- chore\(build\): bump runtime to 1.2.1 [\#1366](https://github.com/apache/camel-k/pull/1366) ([nicolaferraro](https://github.com/nicolaferraro))
- Nth attempt to fix CI [\#1355](https://github.com/apache/camel-k/pull/1355) ([nicolaferraro](https://github.com/nicolaferraro))
- Support for configuring uninstall commmand through files and env vars [\#1354](https://github.com/apache/camel-k/pull/1354) ([lburgazzoli](https://github.com/lburgazzoli))
- Fix \#1340: own openapi configmap and cache it [\#1353](https://github.com/apache/camel-k/pull/1353) ([nicolaferraro](https://github.com/nicolaferraro))
- Fixes \#1350 Remove human-readable format from timer period computatio… [\#1352](https://github.com/apache/camel-k/pull/1352) ([oscerd](https://github.com/oscerd))
- Fix \#1325: add 3scale addon [\#1351](https://github.com/apache/camel-k/pull/1351) ([nicolaferraro](https://github.com/nicolaferraro))
- Set default for rest based services [\#1349](https://github.com/apache/camel-k/pull/1349) ([lburgazzoli](https://github.com/lburgazzoli))
- Fix probes port detection [\#1345](https://github.com/apache/camel-k/pull/1345) ([lburgazzoli](https://github.com/lburgazzoli))
- Fix \#1309: add permissions to patch events [\#1344](https://github.com/apache/camel-k/pull/1344) ([nicolaferraro](https://github.com/nicolaferraro))
- Probes not bound to Knative services [\#1342](https://github.com/apache/camel-k/pull/1342) ([lburgazzoli](https://github.com/lburgazzoli))
- Wrong knative dependency \#1337 [\#1338](https://github.com/apache/camel-k/pull/1338) ([lburgazzoli](https://github.com/lburgazzoli))
- Workaround for apache/camel-k-runtime\#258 [\#1335](https://github.com/apache/camel-k/pull/1335) ([lburgazzoli](https://github.com/lburgazzoli))
- refactor source code inspectors to avoid using redgexp for markup languages [\#1334](https://github.com/apache/camel-k/pull/1334) ([lburgazzoli](https://github.com/lburgazzoli))
- Support for OpenAPI v3 [\#1330](https://github.com/apache/camel-k/pull/1330) ([lburgazzoli](https://github.com/lburgazzoli))
- Fix helm install doc [\#1326](https://github.com/apache/camel-k/pull/1326) ([nicolaferraro](https://github.com/nicolaferraro))
- \[ADD\] Add rest test [\#1324](https://github.com/apache/camel-k/pull/1324) ([bouskaJ](https://github.com/bouskaJ))
- Add e2e test for the multiple files scenario [\#1322](https://github.com/apache/camel-k/pull/1322) ([lburgazzoli](https://github.com/lburgazzoli))
- \[FIX\] Fix kamel install olm parameter [\#1319](https://github.com/apache/camel-k/pull/1319) ([bouskaJ](https://github.com/bouskaJ))
- Add support for capabilities [\#1318](https://github.com/apache/camel-k/pull/1318) ([lburgazzoli](https://github.com/lburgazzoli))
- Fix \#1304: fix the saga example to use default ports [\#1315](https://github.com/apache/camel-k/pull/1315) ([nicolaferraro](https://github.com/nicolaferraro))
- Catalog generation does not take into account the runtime provider to determine the catalog name [\#1313](https://github.com/apache/camel-k/pull/1313) ([lburgazzoli](https://github.com/lburgazzoli))
- Workaround. Labels are not supported on ProjectRequest [\#1311](https://github.com/apache/camel-k/pull/1311) ([bouskaJ](https://github.com/bouskaJ))
- Make test timeouts configurable [\#1307](https://github.com/apache/camel-k/pull/1307) ([bouskaJ](https://github.com/bouskaJ))
- Add super-fast builds for dev clusters [\#1306](https://github.com/apache/camel-k/pull/1306) ([nicolaferraro](https://github.com/nicolaferraro))
- Unable to run the polyglot sample  [\#1303](https://github.com/apache/camel-k/pull/1303) ([lburgazzoli](https://github.com/lburgazzoli))
- feat: Support Buildah builds on OpenShift with internal registry auto-configuration [\#1295](https://github.com/apache/camel-k/pull/1295) ([astefanutti](https://github.com/astefanutti))

## [1.0.0-RC2](https://github.com/apache/camel-k/tree/1.0.0-RC2) (2020-02-24)

[Full Changelog](https://github.com/apache/camel-k/compare/1.0.0-RC1...1.0.0-RC2)

**Closed issues:**

- Buildah support [\#1256](https://github.com/apache/camel-k/issues/1256)
- Dead link from readme to trait documentation [\#1249](https://github.com/apache/camel-k/issues/1249)
- When using `camel-opentracing`, \<Log statement in routes.xml is getting logged twice [\#1240](https://github.com/apache/camel-k/issues/1240)
- Resource group endpoints is that a left over from old Camel version [\#1187](https://github.com/apache/camel-k/issues/1187)
- Private repository for dependent Library [\#1180](https://github.com/apache/camel-k/issues/1180)
- Trying to get sample RestWithUndertow working [\#1175](https://github.com/apache/camel-k/issues/1175)
- Abilty to disable sidecar injection in knative services [\#1173](https://github.com/apache/camel-k/issues/1173)
- Support for using ENV variables in kamel binary [\#1103](https://github.com/apache/camel-k/issues/1103)
- Get rid of json schema generation [\#1037](https://github.com/apache/camel-k/issues/1037)
- camel-k-maven-settings localRepository change is not working [\#1010](https://github.com/apache/camel-k/issues/1010)
- Error in jsonschema gen [\#561](https://github.com/apache/camel-k/issues/561)
- Provide config command for kamel [\#504](https://github.com/apache/camel-k/issues/504)
- Decouple traits from base image [\#394](https://github.com/apache/camel-k/issues/394)
- Automatically use Kubernetes-based master component [\#259](https://github.com/apache/camel-k/issues/259)
- Integrate with GolangCI [\#258](https://github.com/apache/camel-k/issues/258)
- add unit tests for traits [\#255](https://github.com/apache/camel-k/issues/255)
- Add uninstall command [\#38](https://github.com/apache/camel-k/issues/38)
- Resources are not replaced on install [\#1286](https://github.com/apache/camel-k/issues/1286)
- Release 1.0.0-RC2 [\#1273](https://github.com/apache/camel-k/issues/1273)
- Upgrade to Knative 0.12 [\#1270](https://github.com/apache/camel-k/issues/1270)
- Allow to inject data from externally crafted secrets [\#1261](https://github.com/apache/camel-k/issues/1261)
- Multiple Knative endpoint in the same route will cause the pod continuously restart  [\#1257](https://github.com/apache/camel-k/issues/1257)
- Add e2e tests for global installation mode [\#1255](https://github.com/apache/camel-k/issues/1255)
- Installation error: normal user can't delete consoleclidownloads [\#1242](https://github.com/apache/camel-k/issues/1242)
- Check exact Knative version before enabling serving [\#1237](https://github.com/apache/camel-k/issues/1237)
- Autodetect camel-bean [\#1236](https://github.com/apache/camel-k/issues/1236)
- Add a "master" trait [\#1234](https://github.com/apache/camel-k/issues/1234)
- Dev mode doesn't start if the integration is already running [\#1233](https://github.com/apache/camel-k/issues/1233)
- Kamel version should not try to connect to a cluster [\#1230](https://github.com/apache/camel-k/issues/1230)
- Remove the option to set the camel version [\#1229](https://github.com/apache/camel-k/issues/1229)
- Avoid installing operator when OLM reaources are present [\#1223](https://github.com/apache/camel-k/issues/1223)
- knative channel consumer stuck in running state [\#1222](https://github.com/apache/camel-k/issues/1222)
- kamel kit create returns error - result must be a pointer [\#1221](https://github.com/apache/camel-k/issues/1221)
- Integration builds takes lots of time [\#1209](https://github.com/apache/camel-k/issues/1209)
- Disabling traits does not reflect in camel-k  integration [\#1208](https://github.com/apache/camel-k/issues/1208)
- Camel K Validator Component hangs on URL input  [\#1207](https://github.com/apache/camel-k/issues/1207)
- Knative services are slow to become ready [\#1206](https://github.com/apache/camel-k/issues/1206)
- Change log that warns Knative users [\#1205](https://github.com/apache/camel-k/issues/1205)
- Slow build time on Minikube reported [\#1204](https://github.com/apache/camel-k/issues/1204)
- Offer easier access to trait list [\#1203](https://github.com/apache/camel-k/issues/1203)
- Allow easy switch between different controllers [\#1201](https://github.com/apache/camel-k/issues/1201)
- Handle concurrency in CronJob mode [\#1200](https://github.com/apache/camel-k/issues/1200)
- Provide more information when the integration fails at runtime [\#1199](https://github.com/apache/camel-k/issues/1199)
- Add build information when printing integration logs [\#1195](https://github.com/apache/camel-k/issues/1195)
- Add `kamel logs` alias [\#1194](https://github.com/apache/camel-k/issues/1194)
- Invalid JSON Patch error when running simple Camel-K example with 1.0.0-RC1 [\#1190](https://github.com/apache/camel-k/issues/1190)
- Add an init/scaffold subcommand [\#1188](https://github.com/apache/camel-k/issues/1188)
- Exiting dev mode returns non zero exit code [\#1183](https://github.com/apache/camel-k/issues/1183)
- Add native support for CronJobs [\#1182](https://github.com/apache/camel-k/issues/1182)
- Simplify user experience when using config file [\#1181](https://github.com/apache/camel-k/issues/1181)
- Knative integration takes too long to make the service ready [\#1172](https://github.com/apache/camel-k/issues/1172)
- kamel run --wait should return non-zero exit code in case of failure [\#1170](https://github.com/apache/camel-k/issues/1170)
- Add Knative Integration Tests on KinD [\#1162](https://github.com/apache/camel-k/issues/1162)
- Set the IntegrationConditionServiceNotAvailableReason only when the service trait is disabled [\#1149](https://github.com/apache/camel-k/issues/1149)
- Kamel run --property-file [\#1102](https://github.com/apache/camel-k/issues/1102)
- Auto detect Camel components via FQN classnames [\#1095](https://github.com/apache/camel-k/issues/1095)
- traits documentation - Make it clear how to specify 2 or more options [\#1093](https://github.com/apache/camel-k/issues/1093)
- Handle defaults differently \(aka do not change specs\) [\#778](https://github.com/apache/camel-k/issues/778)
- Package installation artifacts with Helm [\#167](https://github.com/apache/camel-k/issues/167)
- Execute e2e tests on vanilla Kubernetes [\#164](https://github.com/apache/camel-k/issues/164)

**Merged pull requests:**

- Fix \#1236: upgrade to runtime 1.1.0 and remove camel-bean autodetection [\#1294](https://github.com/apache/camel-k/pull/1294) ([nicolaferraro](https://github.com/nicolaferraro))
- fix\(platform\): Default to pod build strategy for Kaniko [\#1292](https://github.com/apache/camel-k/pull/1292) ([astefanutti](https://github.com/astefanutti))
- Related to \#1190: add more logs when patch fails [\#1291](https://github.com/apache/camel-k/pull/1291) ([nicolaferraro](https://github.com/nicolaferraro))
- Fix \#1255: add a global installation test [\#1290](https://github.com/apache/camel-k/pull/1290) ([nicolaferraro](https://github.com/nicolaferraro))
- Some small Knative fixes [\#1289](https://github.com/apache/camel-k/pull/1289) ([nicolaferraro](https://github.com/nicolaferraro))
- Fix \#1286: overwrite resources when --force option is passed to kamel… [\#1288](https://github.com/apache/camel-k/pull/1288) ([nicolaferraro](https://github.com/nicolaferraro))
- Add Helm chart for Camel K [\#1287](https://github.com/apache/camel-k/pull/1287) ([nicolaferraro](https://github.com/nicolaferraro))
- \[FIX\] Fix output redirection for external bin [\#1284](https://github.com/apache/camel-k/pull/1284) ([bouskaJ](https://github.com/bouskaJ))
- fix typo puslar -\> pulsar [\#1281](https://github.com/apache/camel-k/pull/1281) ([apupier](https://github.com/apupier))
- Fix Quarkus dependency detection [\#1279](https://github.com/apache/camel-k/pull/1279) ([jamesnetherton](https://github.com/jamesnetherton))
- Get rid of json schema generation [\#1278](https://github.com/apache/camel-k/pull/1278) ([lburgazzoli](https://github.com/lburgazzoli))
- chore\(ci\): test openshift on GH actions [\#1277](https://github.com/apache/camel-k/pull/1277) ([nicolaferraro](https://github.com/nicolaferraro))
- Fix \#1237: check specific knative serving versions to determine if it… [\#1276](https://github.com/apache/camel-k/pull/1276) ([nicolaferraro](https://github.com/nicolaferraro))
- Add concurrency control in cronjobs and fix controller switching [\#1275](https://github.com/apache/camel-k/pull/1275) ([nicolaferraro](https://github.com/nicolaferraro))
- Refactoring traits to allow addons and add master trait \(as addon\) [\#1274](https://github.com/apache/camel-k/pull/1274) ([nicolaferraro](https://github.com/nicolaferraro))
- tekton parameters with parentheses instead of curly brackets [\#1272](https://github.com/apache/camel-k/pull/1272) ([brunoNetId](https://github.com/brunoNetId))
- fix \#1270: upgrade to Knative 0.12 [\#1271](https://github.com/apache/camel-k/pull/1271) ([nicolaferraro](https://github.com/nicolaferraro))
- fix \#1222: use image sha in s2i build to avoid knative registry resol… [\#1269](https://github.com/apache/camel-k/pull/1269) ([nicolaferraro](https://github.com/nicolaferraro))
- Apache Pulsar and Groovy example [\#1268](https://github.com/apache/camel-k/pull/1268) ([haris-zynka](https://github.com/haris-zynka))
- Allow to inject data from externally crafted secrets \#1261 \(camel-k bits\) [\#1265](https://github.com/apache/camel-k/pull/1265) ([lburgazzoli](https://github.com/lburgazzoli))
- Use OLM by default when available [\#1260](https://github.com/apache/camel-k/pull/1260) ([nicolaferraro](https://github.com/nicolaferraro))
- chore: Run Maven in batch mode to reduce log noise [\#1258](https://github.com/apache/camel-k/pull/1258) ([jamesnetherton](https://github.com/jamesnetherton))
- Add uninstall command [\#1254](https://github.com/apache/camel-k/pull/1254) ([jamesnetherton](https://github.com/jamesnetherton))
- chore\(build\): Upgrade Kaniko to version 0.17.1 [\#1253](https://github.com/apache/camel-k/pull/1253) ([astefanutti](https://github.com/astefanutti))
- Small fixes [\#1252](https://github.com/apache/camel-k/pull/1252) ([astefanutti](https://github.com/astefanutti))
- add 'logs' alias on 'log' cmd [\#1251](https://github.com/apache/camel-k/pull/1251) ([ipolyzos](https://github.com/ipolyzos))
- Fix dead link to trait documentation \#1249 [\#1250](https://github.com/apache/camel-k/pull/1250) ([apupier](https://github.com/apupier))
- fix\(install\): Check permission to create OpenShift ConsoleCLIDownload resource [\#1248](https://github.com/apache/camel-k/pull/1248) ([astefanutti](https://github.com/astefanutti))
- chore\(test\): enable e2e tests with Docker Hub and Github packages [\#1247](https://github.com/apache/camel-k/pull/1247) ([nicolaferraro](https://github.com/nicolaferraro))
- Fix \#1162: Knative e2e tests with Kourier [\#1246](https://github.com/apache/camel-k/pull/1246) ([nicolaferraro](https://github.com/nicolaferraro))
- Remove the option to set the camel version [\#1245](https://github.com/apache/camel-k/pull/1245) ([lburgazzoli](https://github.com/lburgazzoli))
- Fix \#1102: add run --property-file option [\#1244](https://github.com/apache/camel-k/pull/1244) ([nicolaferraro](https://github.com/nicolaferraro))
- chore\(permissions\): restrict knative serving permissions on the services [\#1243](https://github.com/apache/camel-k/pull/1243) ([nicolaferraro](https://github.com/nicolaferraro))
- fix \#1230: make some commands to work offline [\#1241](https://github.com/apache/camel-k/pull/1241) ([nicolaferraro](https://github.com/nicolaferraro))
- Provide more information on the deployment status and generate related Kubernetes events [\#1228](https://github.com/apache/camel-k/pull/1228) ([nicolaferraro](https://github.com/nicolaferraro))
- JVM trait [\#1226](https://github.com/apache/camel-k/pull/1226) ([astefanutti](https://github.com/astefanutti))
- fix: Command execution fails with result must be a pointer [\#1225](https://github.com/apache/camel-k/pull/1225) ([jamesnetherton](https://github.com/jamesnetherton))
- chore\(dev\): Upgrade Operator SDK to version 0.15.0 [\#1224](https://github.com/apache/camel-k/pull/1224) ([astefanutti](https://github.com/astefanutti))
- feat: Offer easier access to trait list [\#1220](https://github.com/apache/camel-k/pull/1220) ([jamesnetherton](https://github.com/jamesnetherton))
- fix \#1188: add init command [\#1219](https://github.com/apache/camel-k/pull/1219) ([nicolaferraro](https://github.com/nicolaferraro))
- Fix \#1093: document how to update multiple trait properties [\#1218](https://github.com/apache/camel-k/pull/1218) ([nicolaferraro](https://github.com/nicolaferraro))
- Fix \#1181: add --save option to install and run [\#1217](https://github.com/apache/camel-k/pull/1217) ([nicolaferraro](https://github.com/nicolaferraro))
- chore\(build\): add verbose flag for Kaniko builds [\#1216](https://github.com/apache/camel-k/pull/1216) ([nicolaferraro](https://github.com/nicolaferraro))
- Support any Java base images [\#1215](https://github.com/apache/camel-k/pull/1215) ([astefanutti](https://github.com/astefanutti))
- fix: Exiting dev mode returns non zero exit code [\#1214](https://github.com/apache/camel-k/pull/1214) ([jamesnetherton](https://github.com/jamesnetherton))
- chore\(olm\): set empty spec in CSV to pass courier validation [\#1213](https://github.com/apache/camel-k/pull/1213) ([nicolaferraro](https://github.com/nicolaferraro))
- fix\(dev\): Use go-homedir package instead of os/user to retrieve user home directory [\#1211](https://github.com/apache/camel-k/pull/1211) ([astefanutti](https://github.com/astefanutti))
- chore\(crd\): update the CRD versions [\#1210](https://github.com/apache/camel-k/pull/1210) ([nicolaferraro](https://github.com/nicolaferraro))
- chore\(jolokia\): Declare client certificate Jolokia trait option as an array [\#1202](https://github.com/apache/camel-k/pull/1202) ([astefanutti](https://github.com/astefanutti))
- fix\(jolokia\): Order consistently Jolokia agent options when encoded as environment variable [\#1198](https://github.com/apache/camel-k/pull/1198) ([astefanutti](https://github.com/astefanutti))
- Add native support for CronJobs [\#1197](https://github.com/apache/camel-k/pull/1197) ([nicolaferraro](https://github.com/nicolaferraro))
- Jolokia trait improvements [\#1193](https://github.com/apache/camel-k/pull/1193) ([astefanutti](https://github.com/astefanutti))
- Upgrade Operator SDK to version 0.14.0 [\#1191](https://github.com/apache/camel-k/pull/1191) ([astefanutti](https://github.com/astefanutti))
- fix: Avoid potential nil pointer dereference in wait & dev modes [\#1179](https://github.com/apache/camel-k/pull/1179) ([jamesnetherton](https://github.com/jamesnetherton))
- kamel run --wait should return non-zero exit code in case of failure [\#1178](https://github.com/apache/camel-k/pull/1178) ([jamesnetherton](https://github.com/jamesnetherton))
- Auto detect Camel components via FQN classnames [\#1177](https://github.com/apache/camel-k/pull/1177) ([jamesnetherton](https://github.com/jamesnetherton))
- chore\(release\): bump version to 1.0.0-RC2-SNAPSHOT [\#1168](https://github.com/apache/camel-k/pull/1168) ([nicolaferraro](https://github.com/nicolaferraro))
- Buildah support [\#1259](https://github.com/apache/camel-k/pull/1259) ([astefanutti](https://github.com/astefanutti))

## [1.0.0-RC1](https://github.com/apache/camel-k/tree/1.0.0-RC1) (2019-12-20)

[Full Changelog](https://github.com/apache/camel-k/compare/1.0.0-M4...1.0.0-RC1)

**Closed issues:**

- Trying to get sample RestWithUndertow working. [\#1130](https://github.com/apache/camel-k/issues/1130)
- unable to execute basic Examples eg. Printer.groovy in GKE [\#1115](https://github.com/apache/camel-k/issues/1115)
- kamel scale integration to zero not possible [\#1094](https://github.com/apache/camel-k/issues/1094)
- kamel - Allow to configure memory and cpu settings [\#1091](https://github.com/apache/camel-k/issues/1091)
- Example Request: CamelJmsToFileExample.java [\#1079](https://github.com/apache/camel-k/issues/1079)
- No component found with scheme: http4 // Camel-k 1.0.0M4 [\#1072](https://github.com/apache/camel-k/issues/1072)
- Registry beans issues after upgrade from kamel 0.3.4 to kamel 1.0.0 M4 [\#1071](https://github.com/apache/camel-k/issues/1071)
- broken routes.js example [\#1065](https://github.com/apache/camel-k/issues/1065)
- camel-k installation struggles [\#1059](https://github.com/apache/camel-k/issues/1059)
- camel-k-maven-plugin must not contain any of these characters \/:"\<\>|?\* but found \> @ line 16, column 18 [\#1056](https://github.com/apache/camel-k/issues/1056)
- Automatically extract trait configuration for user manual [\#1014](https://github.com/apache/camel-k/issues/1014)
- Cannot set blockOwnerDeletion in this case because cannot find RESTMapping for APIVersion camel.apache.org/v1alpha1 Kind IntegrationKit [\#764](https://github.com/apache/camel-k/issues/764)
- Error creating integration context with buildStrategy: routine on minikube [\#665](https://github.com/apache/camel-k/issues/665)
- Kaniko: Add ability to push to on-premise registries [\#613](https://github.com/apache/camel-k/issues/613)
- \[quarkus\] in JVM mode we should no restrict the languages we can use [\#1154](https://github.com/apache/camel-k/issues/1154)
- In Kotlin example single quote needs to be replaced with double quotes [\#1145](https://github.com/apache/camel-k/issues/1145)
- \[gc\] cannot delete collection resource "daemonsets" [\#1140](https://github.com/apache/camel-k/issues/1140)
- Camel-k install on azure fails. [\#1138](https://github.com/apache/camel-k/issues/1138)
- Kamel CLI run from URL [\#1136](https://github.com/apache/camel-k/issues/1136)
- Ignore package when working with Java classes [\#1132](https://github.com/apache/camel-k/issues/1132)
- Review usage of version constraints [\#1126](https://github.com/apache/camel-k/issues/1126)
- Improve discovery of Knative on install [\#1125](https://github.com/apache/camel-k/issues/1125)
- Do not change spec in platform [\#1120](https://github.com/apache/camel-k/issues/1120)
- Knative event endpoints may be bidirectional [\#1119](https://github.com/apache/camel-k/issues/1119)
- Release 1.0.0-RC1 [\#1116](https://github.com/apache/camel-k/issues/1116)
- Upgrade to Knative 0.10.x serving v1 API and remove support for 0.8 [\#1112](https://github.com/apache/camel-k/issues/1112)
- Allow to configure kamel CLI with env vars and configuration files [\#1108](https://github.com/apache/camel-k/issues/1108)
- Defer detection of knative profile to when the integration runs [\#1089](https://github.com/apache/camel-k/issues/1089)
- Create camel-quarkus catalog for new release [\#1083](https://github.com/apache/camel-k/issues/1083)
- Update dev-mode documentation to use newer Camel log output [\#1081](https://github.com/apache/camel-k/issues/1081)
- error building image: getting stage builder for stage 0: MANIFEST\_UNKNOWN: "manifest unknown [\#1080](https://github.com/apache/camel-k/issues/1080)
- Remove requirement for PVC on vanilla Kube [\#1069](https://github.com/apache/camel-k/issues/1069)
- Hystrix detection should be changed when upgrading to Camel 3 GA [\#1058](https://github.com/apache/camel-k/issues/1058)
- Running without a platform [\#1047](https://github.com/apache/camel-k/issues/1047)
- Problems with incremental packager on Kaniko [\#998](https://github.com/apache/camel-k/issues/998)
- Moving api to v1 [\#921](https://github.com/apache/camel-k/issues/921)

**Merged pull requests:**

- Upgrade to Runtime 1.0.9 and Kaniko 0.14.0 [\#1167](https://github.com/apache/camel-k/pull/1167) ([nicolaferraro](https://github.com/nicolaferraro))
- fix\(CLI\): Cannot set Kaniko cache option [\#1166](https://github.com/apache/camel-k/pull/1166) ([astefanutti](https://github.com/astefanutti))
- \[quarkus\] in JVM mode we should no restrict the languages we can use [\#1161](https://github.com/apache/camel-k/pull/1161) ([lburgazzoli](https://github.com/lburgazzoli))
- Fix \#921: Migration to v1 API [\#1160](https://github.com/apache/camel-k/pull/1160) ([nicolaferraro](https://github.com/nicolaferraro))
- chore\(dev\): Upgrade Operator SDK to version 0.13.0 [\#1153](https://github.com/apache/camel-k/pull/1153) ([astefanutti](https://github.com/astefanutti))
- fix for issue \#1138 [\#1152](https://github.com/apache/camel-k/pull/1152) ([mrganeshraja](https://github.com/mrganeshraja))
- Fix \#1089: defer knative detection to when integration runs [\#1151](https://github.com/apache/camel-k/pull/1151) ([nicolaferraro](https://github.com/nicolaferraro))
- fix\(gc\): Do not log 403 errors on deletecollection requests during GC [\#1150](https://github.com/apache/camel-k/pull/1150) ([astefanutti](https://github.com/astefanutti))
- Some minor fixes and updates [\#1148](https://github.com/apache/camel-k/pull/1148) ([nicolaferraro](https://github.com/nicolaferraro))
- chore\(test\): add e2e tests for dev mode [\#1147](https://github.com/apache/camel-k/pull/1147) ([nicolaferraro](https://github.com/nicolaferraro))
- fix \#1136: do not watch remote files in dev mode [\#1146](https://github.com/apache/camel-k/pull/1146) ([nicolaferraro](https://github.com/nicolaferraro))
- Added unit tests for the prometheus trait \#255 [\#1142](https://github.com/apache/camel-k/pull/1142) ([aldettinger](https://github.com/aldettinger))
- Fix \#1126: remove constraints and use default versions [\#1141](https://github.com/apache/camel-k/pull/1141) ([nicolaferraro](https://github.com/nicolaferraro))
- chore\(test\): allow to change some defaults for testing [\#1139](https://github.com/apache/camel-k/pull/1139) ([nicolaferraro](https://github.com/nicolaferraro))
- Update to maven 3.6.3 [\#1134](https://github.com/apache/camel-k/pull/1134) ([lburgazzoli](https://github.com/lburgazzoli))
- Allow to configure kamel CLI with env vars and configuration files [\#1133](https://github.com/apache/camel-k/pull/1133) ([lburgazzoli](https://github.com/lburgazzoli))
- Fix \#1125: use all known knative types to check if it's enabled [\#1131](https://github.com/apache/camel-k/pull/1131) ([nicolaferraro](https://github.com/nicolaferraro))
- Don't write to platform spec to allow upgrades [\#1127](https://github.com/apache/camel-k/pull/1127) ([nicolaferraro](https://github.com/nicolaferraro))
- Enable github actions to build and validate pr [\#1124](https://github.com/apache/camel-k/pull/1124) ([lburgazzoli](https://github.com/lburgazzoli))
- Switch to Knative 0.10 and remove Knative 0.8 compatibility [\#1123](https://github.com/apache/camel-k/pull/1123) ([nicolaferraro](https://github.com/nicolaferraro))
- chore\(build\): disable go modules when performing go clean [\#1118](https://github.com/apache/camel-k/pull/1118) ([lburgazzoli](https://github.com/lburgazzoli))
- Fix \#1047: create a default platform when possible [\#1117](https://github.com/apache/camel-k/pull/1117) ([nicolaferraro](https://github.com/nicolaferraro))
- chore\(ci\): dump namespace when tests fail in CI [\#1113](https://github.com/apache/camel-k/pull/1113) ([nicolaferraro](https://github.com/nicolaferraro))
- chore\(revert\): revert Kaniko to more stable v0.9.0 [\#1111](https://github.com/apache/camel-k/pull/1111) ([nicolaferraro](https://github.com/nicolaferraro))
- Use JSON merge patch to reconcile Camel K custom resource statuses [\#1110](https://github.com/apache/camel-k/pull/1110) ([astefanutti](https://github.com/astefanutti))
- Update to add the saga example [\#1109](https://github.com/apache/camel-k/pull/1109) ([zhfeng](https://github.com/zhfeng))
- Change case of readme to please Eclipse Che [\#1106](https://github.com/apache/camel-k/pull/1106) ([apupier](https://github.com/apupier))
- chore: Add explicit dependency on json-patch [\#1105](https://github.com/apache/camel-k/pull/1105) ([astefanutti](https://github.com/astefanutti))
- Check whether KAMEL\_BIN file exists [\#1101](https://github.com/apache/camel-k/pull/1101) ([bouskaJ](https://github.com/bouskaJ))
- feat: Generic patching of integration resources in running phase [\#1100](https://github.com/apache/camel-k/pull/1100) ([astefanutti](https://github.com/astefanutti))
- fix\(doc\): Add affinity trait examples back [\#1098](https://github.com/apache/camel-k/pull/1098) ([astefanutti](https://github.com/astefanutti))
- fix\(OpenAPI\): Use catalog runtime version to generate OpenAPI project [\#1096](https://github.com/apache/camel-k/pull/1096) ([astefanutti](https://github.com/astefanutti))
- chore\(lint\): fix formatting error to make CI happy again [\#1090](https://github.com/apache/camel-k/pull/1090) ([nicolaferraro](https://github.com/nicolaferraro))
- chore\(deps\): bump js-yaml from 3.12.0 to 3.13.1 in /docs [\#1088](https://github.com/apache/camel-k/pull/1088) ([dependabot[bot]](https://github.com/apps/dependabot))
- chore\(deps\): bump lodash from 4.17.11 to 4.17.15 in /docs [\#1087](https://github.com/apache/camel-k/pull/1087) ([dependabot[bot]](https://github.com/apps/dependabot))
- chore\(deps\): bump handlebars from 4.0.12 to 4.5.3 in /docs [\#1086](https://github.com/apache/camel-k/pull/1086) ([dependabot[bot]](https://github.com/apps/dependabot))
- chore\(deps\): bump mixin-deep from 1.3.1 to 1.3.2 in /docs [\#1085](https://github.com/apache/camel-k/pull/1085) ([dependabot[bot]](https://github.com/apps/dependabot))
- Allow to push images to other registries [\#1084](https://github.com/apache/camel-k/pull/1084) ([nicolaferraro](https://github.com/nicolaferraro))
- Add examples [\#1078](https://github.com/apache/camel-k/pull/1078) ([lburgazzoli](https://github.com/lburgazzoli))
- fix the version of the operator image [\#1077](https://github.com/apache/camel-k/pull/1077) ([zhfeng](https://github.com/zhfeng))
- Support KUBECONF env variable [\#1076](https://github.com/apache/camel-k/pull/1076) ([bouskaJ](https://github.com/bouskaJ))
- chore\(build\): Use JSON merge patch to update build status [\#1074](https://github.com/apache/camel-k/pull/1074) ([astefanutti](https://github.com/astefanutti))
- Automatically generate trait documentation from code [\#1068](https://github.com/apache/camel-k/pull/1068) ([nicolaferraro](https://github.com/nicolaferraro))
- examples with camel-amqp and connection factory [\#1067](https://github.com/apache/camel-k/pull/1067) ([hguerrero](https://github.com/hguerrero))
- add wrapper for processor functions [\#1066](https://github.com/apache/camel-k/pull/1066) ([hguerrero](https://github.com/hguerrero))
- feat\(build\): Better report build progress [\#1064](https://github.com/apache/camel-k/pull/1064) ([astefanutti](https://github.com/astefanutti))
- Add GC trait discovery client caching options and server-side deletion [\#1062](https://github.com/apache/camel-k/pull/1062) ([astefanutti](https://github.com/astefanutti))
- chore\(olm\): fix olm naming [\#1060](https://github.com/apache/camel-k/pull/1060) ([nicolaferraro](https://github.com/nicolaferraro))
- feat\(build\): Task-based builds [\#1121](https://github.com/apache/camel-k/pull/1121) ([astefanutti](https://github.com/astefanutti))

## [1.0.0-M4](https://github.com/apache/camel-k/tree/1.0.0-M4) (2019-11-13)

[Full Changelog](https://github.com/apache/camel-k/compare/1.0.0-M3...1.0.0-M4)

**Closed issues:**

- Remove support for java class loader [\#1050](https://github.com/apache/camel-k/issues/1050)
- can't use a function processor with javascript [\#1035](https://github.com/apache/camel-k/issues/1035)
- Cannot push kit image to GCR \(or Docker.io\) during integration creation [\#1024](https://github.com/apache/camel-k/issues/1024)
- groovy.lang.MissingMethodException: No signature of method: Script1.context\(\) [\#1022](https://github.com/apache/camel-k/issues/1022)
- support for quarkus in JVM mode [\#990](https://github.com/apache/camel-k/issues/990)
- Release 1.0.0-M4 [\#1055](https://github.com/apache/camel-k/issues/1055)
- When kamel is launched from inside a container, it is using the serviceaccount of this container instead of the user configured in kubeconfig [\#1048](https://github.com/apache/camel-k/issues/1048)
- Changing trait config should lead to redeploy [\#1038](https://github.com/apache/camel-k/issues/1038)
- Generate full k8s client for provided APIs [\#1036](https://github.com/apache/camel-k/issues/1036)
- Avoid having failing builds during Apache Vote [\#1023](https://github.com/apache/camel-k/issues/1023)
- Write documentation for the release process [\#989](https://github.com/apache/camel-k/issues/989)
- Require go \>= 1.13 for development [\#981](https://github.com/apache/camel-k/issues/981)
- Automatically create catalogs from maven [\#744](https://github.com/apache/camel-k/issues/744)
- Do not rebuild knative integrations when changing sink [\#662](https://github.com/apache/camel-k/issues/662)

**Merged pull requests:**

- Fix \#1048: use container mode only when no other mechanism is available [\#1054](https://github.com/apache/camel-k/pull/1054) ([nicolaferraro](https://github.com/nicolaferraro))
- Fix \#1038: redeploy integration when trait config changes [\#1053](https://github.com/apache/camel-k/pull/1053) ([nicolaferraro](https://github.com/nicolaferraro))
- Remove support for java class loader [\#1052](https://github.com/apache/camel-k/pull/1052) ([lburgazzoli](https://github.com/lburgazzoli))
- Fix \#1036: generate k8s client for camel k resources [\#1051](https://github.com/apache/camel-k/pull/1051) ([nicolaferraro](https://github.com/nicolaferraro))
- chore\(magic\): auto-add dependency on camel-jackson when using plain .… [\#1049](https://github.com/apache/camel-k/pull/1049) ([nicolaferraro](https://github.com/nicolaferraro))
- fix \#662: mark kit traits to avoid rebuilding when not necessary [\#1046](https://github.com/apache/camel-k/pull/1046) ([nicolaferraro](https://github.com/nicolaferraro))
- fix\(camel\): Report runtime version from Camel catalog into integration and kit statuses [\#1044](https://github.com/apache/camel-k/pull/1044) ([astefanutti](https://github.com/astefanutti))
- chore\(dev\): Upgrade Operator SDK to version 0.12.0 [\#1043](https://github.com/apache/camel-k/pull/1043) ([astefanutti](https://github.com/astefanutti))
- Fix typo in doc [\#1042](https://github.com/apache/camel-k/pull/1042) ([apupier](https://github.com/apupier))
- fix \#989: document the release process [\#1041](https://github.com/apache/camel-k/pull/1041) ([nicolaferraro](https://github.com/nicolaferraro))
- chore\(dev\): Require Go version 1.13 [\#1040](https://github.com/apache/camel-k/pull/1040) ([astefanutti](https://github.com/astefanutti))
- Add readme in examples subfolder [\#1034](https://github.com/apache/camel-k/pull/1034) ([apupier](https://github.com/apupier))
- fix \#1023: add possibility to reference staging artifacts [\#1029](https://github.com/apache/camel-k/pull/1029) ([nicolaferraro](https://github.com/nicolaferraro))
- chore: fix eaxmples [\#1026](https://github.com/apache/camel-k/pull/1026) ([lburgazzoli](https://github.com/lburgazzoli))
- fix\(SDK\): Add relative symlink to kamel main package [\#1025](https://github.com/apache/camel-k/pull/1025) ([astefanutti](https://github.com/astefanutti))
- chore: Use non-caching API reader from SDK [\#1021](https://github.com/apache/camel-k/pull/1021) ([astefanutti](https://github.com/astefanutti))
- feat\(quarkus\): Initial Quarkus support [\#1013](https://github.com/apache/camel-k/pull/1013) ([astefanutti](https://github.com/astefanutti))

## [1.0.0-M3](https://github.com/apache/camel-k/tree/1.0.0-M3) (2019-10-18)

[Full Changelog](https://github.com/apache/camel-k/compare/1.0.0-M2...1.0.0-M3)

**Closed issues:**

- Failing start the camel-k-operator 1.0.0.-M3-SNAPSHOT with the minishifit [\#1015](https://github.com/apache/camel-k/issues/1015)
- Provide a plain text file with the latest version of Camel K for easier automation of downloading via the tooling [\#1009](https://github.com/apache/camel-k/issues/1009)
- Cannot use knative-source-yaml loader [\#1005](https://github.com/apache/camel-k/issues/1005)
- Pubilsh Camel K 1.0.0-M2 to operator hub [\#1004](https://github.com/apache/camel-k/issues/1004)
- remove integration delete action and finalizer [\#995](https://github.com/apache/camel-k/issues/995)
- kamel run fail: Get https://image-registry.openshift-image-registry.svc:5000/v2/: x509: certificate signed by unknown authority [\#994](https://github.com/apache/camel-k/issues/994)
- Permission Denied while creating a temporary dir on AWS EKS [\#971](https://github.com/apache/camel-k/issues/971)
- Starting a new integration in --dev mode and then starting it again without --dev mode leaves hanging process [\#946](https://github.com/apache/camel-k/issues/946)
- Help message of "camel context create" misleading [\#586](https://github.com/apache/camel-k/issues/586)
- Release Camel K 1.0.0-M3 [\#1020](https://github.com/apache/camel-k/issues/1020)
- Misleading version 1.0.0 in some Camel K runtime artifacts [\#1011](https://github.com/apache/camel-k/issues/1011)
- Allow explicit usage of apiVersion and kind in knative URIs [\#1008](https://github.com/apache/camel-k/issues/1008)
- Cannot configure slices in traits [\#997](https://github.com/apache/camel-k/issues/997)
- Add check for missing license headers in files [\#988](https://github.com/apache/camel-k/issues/988)
- Wrong knative roles installed in global mode [\#985](https://github.com/apache/camel-k/issues/985)
- Wrong behavior of global mode wrt kaniko cache warmer and platform [\#984](https://github.com/apache/camel-k/issues/984)
- Build operator image from non-Linux local OS [\#982](https://github.com/apache/camel-k/issues/982)
- Include camel-k-runtime version in camel-catalog [\#959](https://github.com/apache/camel-k/issues/959)
- Add Kamel CLI download link in OpenShift Web console [\#939](https://github.com/apache/camel-k/issues/939)

**Merged pull requests:**

- fix \#985: add correct clusterroles for knative in global mode [\#1019](https://github.com/apache/camel-k/pull/1019) ([nicolaferraro](https://github.com/nicolaferraro))
- fix \#988: add check for missing licenses before release [\#1018](https://github.com/apache/camel-k/pull/1018) ([nicolaferraro](https://github.com/nicolaferraro))
- Upgrade Operator SDK to version 0.11.0 [\#1017](https://github.com/apache/camel-k/pull/1017) ([astefanutti](https://github.com/astefanutti))
- chore\(tests\): add integration tests for common knative issues [\#1016](https://github.com/apache/camel-k/pull/1016) ([nicolaferraro](https://github.com/nicolaferraro))
- Support Knative broker/trigger model and explicit source/sink [\#1012](https://github.com/apache/camel-k/pull/1012) ([nicolaferraro](https://github.com/nicolaferraro))
- fix \#1005: allow to customize loader and add default dependencies for… [\#1007](https://github.com/apache/camel-k/pull/1007) ([nicolaferraro](https://github.com/nicolaferraro))
- Update OLM manifests for 1.0.0-M2 release [\#1006](https://github.com/apache/camel-k/pull/1006) ([astefanutti](https://github.com/astefanutti))
- fix: Avoid updating Deployment replicas in default configuration [\#1003](https://github.com/apache/camel-k/pull/1003) ([astefanutti](https://github.com/astefanutti))
- perf: Enqueue ReplicaSet updates only when replicas changed [\#1002](https://github.com/apache/camel-k/pull/1002) ([astefanutti](https://github.com/astefanutti))
- chore: Remove references to OpenShift deprecated build APIs [\#1001](https://github.com/apache/camel-k/pull/1001) ([astefanutti](https://github.com/astefanutti))
- fix: Handle traits update conflicts gracefully [\#1000](https://github.com/apache/camel-k/pull/1000) ([astefanutti](https://github.com/astefanutti))
- chore: GC trait improvements [\#999](https://github.com/apache/camel-k/pull/999) ([astefanutti](https://github.com/astefanutti))
- remove integration delete action and finalizer [\#996](https://github.com/apache/camel-k/pull/996) ([lburgazzoli](https://github.com/lburgazzoli))
- Include camel-k-runtime version in camel-catalog [\#993](https://github.com/apache/camel-k/pull/993) ([lburgazzoli](https://github.com/lburgazzoli))
- Fix release issues for 1.0.0-M2 [\#986](https://github.com/apache/camel-k/pull/986) ([asifdxtreme](https://github.com/asifdxtreme))
- Kaniko cache warmer and platform multi-tenancy improvements [\#992](https://github.com/apache/camel-k/pull/992) ([astefanutti](https://github.com/astefanutti))
- chore\(build\): Auto cross-compile operator image binary from non-Linux local OS [\#987](https://github.com/apache/camel-k/pull/987) ([astefanutti](https://github.com/astefanutti))
- Add Kamel CLI download link to OpenShift Web console [\#983](https://github.com/apache/camel-k/pull/983) ([astefanutti](https://github.com/astefanutti))

## [1.0.0-M2](https://github.com/apache/camel-k/tree/1.0.0-M2) (2019-10-05)

[Full Changelog](https://github.com/apache/camel-k/compare/1.0.0-M1...1.0.0-M2)

**Closed issues:**

- Build completes OK but integration shows ERROR [\#965](https://github.com/apache/camel-k/issues/965)
- Monitoring kubectl for changes to integrations misses transition to error state [\#937](https://github.com/apache/camel-k/issues/937)
- Knative route from AWS S3 endpoint immediatly stops after starting [\#919](https://github.com/apache/camel-k/issues/919)
- Dev mode doesn't show if the build failed [\#906](https://github.com/apache/camel-k/issues/906)
- Road Map about Yaml DSL [\#902](https://github.com/apache/camel-k/issues/902)
- Issues with pre-published Kubernetes secret and Camel-K integration [\#900](https://github.com/apache/camel-k/issues/900)
- camel-k-kit-XXXXX is not able to inherit docker proxy configuration [\#899](https://github.com/apache/camel-k/issues/899)
- Camel-k-cache not able to create PVC \(pod has unbound immediate PersistentVolumeClaims\) [\#898](https://github.com/apache/camel-k/issues/898)
- Include modeline in examples [\#895](https://github.com/apache/camel-k/issues/895)
- Improve kamel "get" to enable specifying integration name [\#893](https://github.com/apache/camel-k/issues/893)
- Publish Camel K 1.0.0-M1 to operator hub [\#887](https://github.com/apache/camel-k/issues/887)
- Kamel reset should delete builds as well as kits [\#875](https://github.com/apache/camel-k/issues/875)
- BuildConfig's, ImageStream's and Pod's not labeled with camel-k and can't delete with -l 'app=camel-k' [\#840](https://github.com/apache/camel-k/issues/840)
- Orphan generated XML DSL from OpenAPI JSON after deleting integration [\#839](https://github.com/apache/camel-k/issues/839)
- All links of the documentation are missing spaces before and after displayed text [\#794](https://github.com/apache/camel-k/issues/794)
- Update Camel K tagline in Kamel CLI [\#732](https://github.com/apache/camel-k/issues/732)
- Review reset and delete with --all option for merging similar functions to one place  [\#598](https://github.com/apache/camel-k/issues/598)
- Able to run maven build with debug and/or extended info [\#85](https://github.com/apache/camel-k/issues/85)
- Remove references to host that did compilation in stacktraces [\#972](https://github.com/apache/camel-k/issues/972)
- Integration fails with --dev mode [\#968](https://github.com/apache/camel-k/issues/968)
- Kaniko step fails on Minikube with IncrementalPackager [\#960](https://github.com/apache/camel-k/issues/960)
- Upgrade to Camel 3.0.0-RC1 [\#956](https://github.com/apache/camel-k/issues/956)
- Upgrade to Knative 0.9 [\#952](https://github.com/apache/camel-k/issues/952)
- Permission error on a OpenStack/Cinder persistent volume while creating a temporary dir [\#947](https://github.com/apache/camel-k/issues/947)
- Merge all binaries into a single one [\#945](https://github.com/apache/camel-k/issues/945)
- Release Camel K 1.0.0-M2 [\#944](https://github.com/apache/camel-k/issues/944)
- Allow to run integrations in Tekton pipelines [\#942](https://github.com/apache/camel-k/issues/942)
- kamel get still has a column for 'Context' [\#941](https://github.com/apache/camel-k/issues/941)
- routes.yaml example fails with NoSuchLanguageException [\#929](https://github.com/apache/camel-k/issues/929)
- Can't use operator global mode [\#920](https://github.com/apache/camel-k/issues/920)
- Kamel run fails on Google Cloud Infrastructure \(GKE\) [\#915](https://github.com/apache/camel-k/issues/915)
- Automatically resolve dependency for language expressions \(eg: groovy\) [\#914](https://github.com/apache/camel-k/issues/914)
- Add option to disable Kaniko cache warming [\#907](https://github.com/apache/camel-k/issues/907)
- Camel K should use duck types to recognize Knative sinks [\#888](https://github.com/apache/camel-k/issues/888)

**Merged pull requests:**

- fix \#972: strip local host data from build [\#980](https://github.com/apache/camel-k/pull/980) ([nicolaferraro](https://github.com/nicolaferraro))
- Fix gke permissions [\#979](https://github.com/apache/camel-k/pull/979) ([nicolaferraro](https://github.com/nicolaferraro))
- chore\(scale\): Rebuild resources [\#978](https://github.com/apache/camel-k/pull/978) ([astefanutti](https://github.com/astefanutti))
- fix: Add missing configmaps resource to camel-k-builder role [\#977](https://github.com/apache/camel-k/pull/977) ([jamesnetherton](https://github.com/jamesnetherton))
- chore: Display Kaniko version in prelude log [\#976](https://github.com/apache/camel-k/pull/976) ([astefanutti](https://github.com/astefanutti))
- fix: Kaniko cache default spec is not updated when calling the status endpoint [\#975](https://github.com/apache/camel-k/pull/975) ([astefanutti](https://github.com/astefanutti))
- fix: Add nil check for dev mode intergration phase watch result [\#974](https://github.com/apache/camel-k/pull/974) ([jamesnetherton](https://github.com/jamesnetherton))
- fix: Kaniko publisher step fails with IncrementalPackager [\#970](https://github.com/apache/camel-k/pull/970) ([astefanutti](https://github.com/astefanutti))
- chore\(cli\): Hide builder and operator commands [\#969](https://github.com/apache/camel-k/pull/969) ([astefanutti](https://github.com/astefanutti))
- fix\(build\): Remove builder bin commands [\#967](https://github.com/apache/camel-k/pull/967) ([astefanutti](https://github.com/astefanutti))
- fix: Merge all binaries into a single one [\#966](https://github.com/apache/camel-k/pull/966) ([jamesnetherton](https://github.com/jamesnetherton))
- fix: Rename kamel get 'context' column to 'kit' [\#964](https://github.com/apache/camel-k/pull/964) ([jamesnetherton](https://github.com/jamesnetherton))
- chore\(release\): automatic generation of release notes [\#963](https://github.com/apache/camel-k/pull/963) ([nicolaferraro](https://github.com/nicolaferraro))
- Upgrade to Knative 0.9 [\#961](https://github.com/apache/camel-k/pull/961) ([nicolaferraro](https://github.com/nicolaferraro))
- sanitize name of auto-generated catalogs [\#958](https://github.com/apache/camel-k/pull/958) ([lburgazzoli](https://github.com/lburgazzoli))
- Automatically resolve dependencies for language expressions [\#957](https://github.com/apache/camel-k/pull/957) ([jamesnetherton](https://github.com/jamesnetherton))
- chore: Remove unecessary watch on builds while reconciling integrations [\#955](https://github.com/apache/camel-k/pull/955) ([astefanutti](https://github.com/astefanutti))
- Jolokia and Prometheus traits fixes [\#954](https://github.com/apache/camel-k/pull/954) ([astefanutti](https://github.com/astefanutti))
- fix\(build\): Go 1.13 compatibility [\#953](https://github.com/apache/camel-k/pull/953) ([astefanutti](https://github.com/astefanutti))
- Resources GC improvements [\#950](https://github.com/apache/camel-k/pull/950) ([astefanutti](https://github.com/astefanutti))
- Upgrade Operator SDK to version 0.10.0 [\#949](https://github.com/apache/camel-k/pull/949) ([astefanutti](https://github.com/astefanutti))
- fix\(builder\): Clean ReplaceHost step leftover that causes nil pointer dereference panic [\#948](https://github.com/apache/camel-k/pull/948) ([astefanutti](https://github.com/astefanutti))
- Add ability to execute tasks in Tekton pipeline [\#943](https://github.com/apache/camel-k/pull/943) ([nicolaferraro](https://github.com/nicolaferraro))
- Making kamel CLI 90% faster on remote clusters [\#940](https://github.com/apache/camel-k/pull/940) ([nicolaferraro](https://github.com/nicolaferraro))
- fix\(examples\): Remove timer route to allow scale-to-zero of REST DSL example [\#936](https://github.com/apache/camel-k/pull/936) ([astefanutti](https://github.com/astefanutti))
- fix\(knative\): Use channel hostname to filter Knative history header [\#935](https://github.com/apache/camel-k/pull/935) ([astefanutti](https://github.com/astefanutti))
- Provide better instructions on the kit create command for missing nam… [\#932](https://github.com/apache/camel-k/pull/932) ([dobozysaurus](https://github.com/dobozysaurus))
- Fix \#732: Adjusted CLI tagline to be in sync with updated \(serverless superpowers\) language. [\#931](https://github.com/apache/camel-k/pull/931) ([dobozysaurus](https://github.com/dobozysaurus))
- fix: Correct indentation for integration source content [\#928](https://github.com/apache/camel-k/pull/928) ([jamesnetherton](https://github.com/jamesnetherton))
- fix: Dev mode does not show if the build failed [\#927](https://github.com/apache/camel-k/pull/927) ([jamesnetherton](https://github.com/jamesnetherton))
- fix\(build\): Replace git.apache.org/thrift.git dependency [\#926](https://github.com/apache/camel-k/pull/926) ([astefanutti](https://github.com/astefanutti))
- fix\(knative\): favor cluster-local instead of public URL to address en… [\#925](https://github.com/apache/camel-k/pull/925) ([astefanutti](https://github.com/astefanutti))
- perf\(gc\): Restrict discovery to types that support the list verb [\#917](https://github.com/apache/camel-k/pull/917) ([astefanutti](https://github.com/astefanutti))
- fix\(knative\): Cannot schedule container image using default internal registry hostname [\#916](https://github.com/apache/camel-k/pull/916) ([astefanutti](https://github.com/astefanutti))
- fix\(doc\): migrate links from staging to official Camel Web site [\#913](https://github.com/apache/camel-k/pull/913) ([astefanutti](https://github.com/astefanutti))
- fix\(OLM\): CSV name must be DNS-1123 subdomains and consist of lower c… [\#912](https://github.com/apache/camel-k/pull/912) ([astefanutti](https://github.com/astefanutti))
- fix\(OLM\): Remove integration context leftovers from OLM bundles [\#909](https://github.com/apache/camel-k/pull/909) ([astefanutti](https://github.com/astefanutti))
-  fix: Enable proxy server to be configured for Kaniko builds [\#905](https://github.com/apache/camel-k/pull/905) ([jamesnetherton](https://github.com/jamesnetherton))
- Added unit tests for the jolokia trait \#255 [\#904](https://github.com/apache/camel-k/pull/904) ([aldettinger](https://github.com/aldettinger))
- fix\(build\): Cache go modules directory [\#903](https://github.com/apache/camel-k/pull/903) ([jamesnetherton](https://github.com/jamesnetherton))
- fix\(examples\): Remove references to obsolete runtime argument [\#901](https://github.com/apache/camel-k/pull/901) ([jamesnetherton](https://github.com/jamesnetherton))
- fix: Improve kamel get to enable specifying integration name [\#897](https://github.com/apache/camel-k/pull/897) ([jamesnetherton](https://github.com/jamesnetherton))
- Include modeline in examples \#895 [\#896](https://github.com/apache/camel-k/pull/896) ([apupier](https://github.com/apupier))
- External kamel bin testing [\#894](https://github.com/apache/camel-k/pull/894) ([bouskaJ](https://github.com/bouskaJ))
- BuildConfig's, ImageStream's and Pod's not labeled with camel-k and can't delete with -l 'app=camel-k' [\#884](https://github.com/apache/camel-k/pull/884) ([dmvolod](https://github.com/dmvolod))
- Fix embedded resources snapshot version [\#882](https://github.com/apache/camel-k/pull/882) ([dmvolod](https://github.com/dmvolod))
- Switch to images-dev build on install-mini\<plaform\> [\#881](https://github.com/apache/camel-k/pull/881) ([dmvolod](https://github.com/dmvolod))
- Added unit tests for ingress\_trait \#255 [\#880](https://github.com/apache/camel-k/pull/880) ([aldettinger](https://github.com/aldettinger))
- feat: Enable integration scale sub-resource [\#962](https://github.com/apache/camel-k/pull/962) ([astefanutti](https://github.com/astefanutti))
- fix: Add option to disable Kaniko cache warming [\#922](https://github.com/apache/camel-k/pull/922) ([asifdxtreme](https://github.com/asifdxtreme))

## [1.0.0-M1](https://github.com/apache/camel-k/tree/1.0.0-M1) (2019-07-25)

[Full Changelog](https://github.com/apache/camel-k/compare/0.3.4...1.0.0-M1)

**Closed issues:**

- Lambda processor doesn't work with JS routes [\#873](https://github.com/apache/camel-k/issues/873)
- make images fail on resolve of camel-k-maven-plugin [\#869](https://github.com/apache/camel-k/issues/869)
- operator-sdk build fails on latest master with 'make images-dev' [\#863](https://github.com/apache/camel-k/issues/863)
- camel-rest should load automatically for routes using Rest DSL  [\#862](https://github.com/apache/camel-k/issues/862)
- Upgrade operator sdk to 0.9.0 [\#845](https://github.com/apache/camel-k/issues/845)
- route trait assumes target port name is always 'http' [\#837](https://github.com/apache/camel-k/issues/837)
- Concurrency issue in the end to end tests [\#830](https://github.com/apache/camel-k/issues/830)
- Can camel-k accept camel context definition? [\#814](https://github.com/apache/camel-k/issues/814)
- Update to camel 3.0.0-M4  [\#811](https://github.com/apache/camel-k/issues/811)
- Kamel install with kit option can leave integrationkit stuck waiting for platform [\#809](https://github.com/apache/camel-k/issues/809)
- Dependencies & rest-dsl traits are never enabled [\#807](https://github.com/apache/camel-k/issues/807)
- Updating an integration leaves it stuck in phase Deploying [\#806](https://github.com/apache/camel-k/issues/806)
- Nil pointer on build failure recovery [\#804](https://github.com/apache/camel-k/issues/804)
- Move waiting for platform to controller [\#797](https://github.com/apache/camel-k/issues/797)
- Don't wait for initial kit to be ready to declare the platform ready [\#795](https://github.com/apache/camel-k/issues/795)
- e2e tests are failing on travis [\#793](https://github.com/apache/camel-k/issues/793)
- Support for new yaml dsl [\#781](https://github.com/apache/camel-k/issues/781)
- Integration naming issues with numbers in them [\#777](https://github.com/apache/camel-k/issues/777)
- Route trait does not work if route.auto is set to false [\#767](https://github.com/apache/camel-k/issues/767)
- Switch to Camel 3 [\#755](https://github.com/apache/camel-k/issues/755)
- Do not create a route on top of prometheus service only [\#749](https://github.com/apache/camel-k/issues/749)
- The --maven-repository shortcut does not configure plugin repositories [\#746](https://github.com/apache/camel-k/issues/746)
- Add a --global install option [\#745](https://github.com/apache/camel-k/issues/745)
- CR example is using wrong schema [\#737](https://github.com/apache/camel-k/issues/737)
- camelContext is not supported in XML DSL routedefinition [\#731](https://github.com/apache/camel-k/issues/731)
- Switch to go mod compatible version of operator-sdk [\#702](https://github.com/apache/camel-k/issues/702)
- `make generate` does not work with new module structure [\#699](https://github.com/apache/camel-k/issues/699)
- camel-k-operator ready for running integration when camel-k-\* builds are still fails [\#582](https://github.com/apache/camel-k/issues/582)
- Honour KUBECONFIG [\#574](https://github.com/apache/camel-k/issues/574)
- Generate website using Antora [\#282](https://github.com/apache/camel-k/issues/282)
- Able to set custom camel-k-operator image name and location  [\#97](https://github.com/apache/camel-k/issues/97)
- Add script/doc for those who use 'oc cluster up' \(cluster-wrapper\) [\#60](https://github.com/apache/camel-k/issues/60)
- Release Camel K 1.0.0 M1 and related Camel K Runtime [\#878](https://github.com/apache/camel-k/issues/878)
- Can't determine knative endpoint address [\#856](https://github.com/apache/camel-k/issues/856)
- Wrong dependency camel-k:knative used [\#848](https://github.com/apache/camel-k/issues/848)
- Groovy Rest example fails due to Unable to find loader for language=xml [\#838](https://github.com/apache/camel-k/issues/838)
- Disable Istio by default [\#833](https://github.com/apache/camel-k/issues/833)
- GC trait fails on some installations [\#832](https://github.com/apache/camel-k/issues/832)
- Stable container name [\#826](https://github.com/apache/camel-k/issues/826)
- Determine correct profile at runtime in the operator [\#815](https://github.com/apache/camel-k/issues/815)
- Knative serving runLatest is deprecated [\#791](https://github.com/apache/camel-k/issues/791)
- Wrong example on operator hub [\#789](https://github.com/apache/camel-k/issues/789)
- Enable maven strict checksum policy on platform initialization [\#776](https://github.com/apache/camel-k/issues/776)
- Misleading "service.enabled=false" when used in combination with the prometheus trait [\#768](https://github.com/apache/camel-k/issues/768)
- Allow backward compatible changes in CRD [\#730](https://github.com/apache/camel-k/issues/730)

**Merged pull requests:**

- Fix make clean for tests and remove binary file from repo [\#879](https://github.com/apache/camel-k/pull/879) ([dmvolod](https://github.com/dmvolod))
- chore\(js\): fix examples, use arrow function for lambda style processor [\#877](https://github.com/apache/camel-k/pull/877) ([lburgazzoli](https://github.com/lburgazzoli))
- fix\(GC\): Skip 503 errors when scanning for resources to be GCed [\#876](https://github.com/apache/camel-k/pull/876) ([astefanutti](https://github.com/astefanutti))
- Remove Dep files [\#872](https://github.com/apache/camel-k/pull/872) ([astefanutti](https://github.com/astefanutti))
- chore\(build\): remove go mod vendor from travis build [\#871](https://github.com/apache/camel-k/pull/871) ([lburgazzoli](https://github.com/lburgazzoli))
- Fix \#789: add correct example for operator hub [\#868](https://github.com/apache/camel-k/pull/868) ([nicolaferraro](https://github.com/nicolaferraro))
- Fix \#730: put example that demonstrate backward compatibility works [\#867](https://github.com/apache/camel-k/pull/867) ([nicolaferraro](https://github.com/nicolaferraro))
- camel-rest should load automatically for routes using Rest DSL [\#866](https://github.com/apache/camel-k/pull/866) ([lburgazzoli](https://github.com/lburgazzoli))
- Remove .gitmodules file [\#865](https://github.com/apache/camel-k/pull/865) ([astefanutti](https://github.com/astefanutti))
- Update build requirements documentation [\#864](https://github.com/apache/camel-k/pull/864) ([astefanutti](https://github.com/astefanutti))
- Fix \#815: determine correct profile at runtime when empty [\#861](https://github.com/apache/camel-k/pull/861) ([nicolaferraro](https://github.com/nicolaferraro))
- fix\(examples\): add --dependency=camel-rest to usage comments in rest examples [\#860](https://github.com/apache/camel-k/pull/860) ([tadayosi](https://github.com/tadayosi))
- Add --verbose to lint for preventing hangs visibility [\#859](https://github.com/apache/camel-k/pull/859) ([dmvolod](https://github.com/dmvolod))
- fix\(docs\): typo in running in dev mode [\#858](https://github.com/apache/camel-k/pull/858) ([tadayosi](https://github.com/tadayosi))
- Fix \#856: lookup destination in multiple places and add e2e tests [\#857](https://github.com/apache/camel-k/pull/857) ([nicolaferraro](https://github.com/nicolaferraro))
- chore\(lint\): tune golangci-lint resource requirements [\#855](https://github.com/apache/camel-k/pull/855) ([lburgazzoli](https://github.com/lburgazzoli))
- chore\(knative\): fix auto discovery [\#854](https://github.com/apache/camel-k/pull/854) ([lburgazzoli](https://github.com/lburgazzoli))
- fix\(classpath\): lookup integration container by name instead of iterating amoung all the containers [\#852](https://github.com/apache/camel-k/pull/852) ([lburgazzoli](https://github.com/lburgazzoli))
- Upgrade to Knative 0.7.1 [\#851](https://github.com/apache/camel-k/pull/851) ([nicolaferraro](https://github.com/nicolaferraro))
- Upgrade Operator SDK to version 0.9.0 [\#850](https://github.com/apache/camel-k/pull/850) ([astefanutti](https://github.com/astefanutti))
- Groovy Rest example fails due to Unable to find loader for language=xml [\#849](https://github.com/apache/camel-k/pull/849) ([dmvolod](https://github.com/dmvolod))
- Disable Istio by default [\#847](https://github.com/apache/camel-k/pull/847) ([lburgazzoli](https://github.com/lburgazzoli))
- Add unit tests for the classpath trait \#255 [\#846](https://github.com/apache/camel-k/pull/846) ([aldettinger](https://github.com/aldettinger))
- fix build-pod strategy on kubernetes [\#844](https://github.com/apache/camel-k/pull/844) ([lburgazzoli](https://github.com/lburgazzoli))
- route trait assumes target port name is always 'http' [\#842](https://github.com/apache/camel-k/pull/842) ([lburgazzoli](https://github.com/lburgazzoli))
- fix: Enable maven strict checksum policy on platform initialization [\#836](https://github.com/apache/camel-k/pull/836) ([jamesnetherton](https://github.com/jamesnetherton))
- Stable container name [\#835](https://github.com/apache/camel-k/pull/835) ([lburgazzoli](https://github.com/lburgazzoli))
- Concurrency issue in the end to end tests [\#834](https://github.com/apache/camel-k/pull/834) ([lburgazzoli](https://github.com/lburgazzoli))
- fix: point to the staging site from README.adoc [\#831](https://github.com/apache/camel-k/pull/831) ([zregvart](https://github.com/zregvart))
- chore\(docs\): cleanup contributors guide [\#829](https://github.com/apache/camel-k/pull/829) ([zregvart](https://github.com/zregvart))
- chore: point the Antora configuration to `master` [\#828](https://github.com/apache/camel-k/pull/828) ([zregvart](https://github.com/zregvart))
- Misleading "service.enabled=false" when used in combination with the prometheus trait i [\#825](https://github.com/apache/camel-k/pull/825) ([lburgazzoli](https://github.com/lburgazzoli))
- Publishing documentation using Antora [\#824](https://github.com/apache/camel-k/pull/824) ([zregvart](https://github.com/zregvart))
- chore\(doc\): add ddoc for probes trait [\#822](https://github.com/apache/camel-k/pull/822) ([lburgazzoli](https://github.com/lburgazzoli))
- chore: re-enable integration tests [\#821](https://github.com/apache/camel-k/pull/821) ([lburgazzoli](https://github.com/lburgazzoli))
- Remove obsolete runtime dependency type [\#820](https://github.com/apache/camel-k/pull/820) ([lburgazzoli](https://github.com/lburgazzoli))
- fix\(test\): Fix XML e2e test after upgrade to 3.0.0-M4 [\#819](https://github.com/apache/camel-k/pull/819) ([jamesnetherton](https://github.com/jamesnetherton))
- chore\(runtime\): remove hardcoded log4j dependency [\#818](https://github.com/apache/camel-k/pull/818) ([lburgazzoli](https://github.com/lburgazzoli))
- test\(yaml\): Add YAML e2e test [\#817](https://github.com/apache/camel-k/pull/817) ([jamesnetherton](https://github.com/jamesnetherton))
- fix: Use error condition when active platform cannot be resolved [\#816](https://github.com/apache/camel-k/pull/816) ([jamesnetherton](https://github.com/jamesnetherton))
- Update to camel 3.0.0-M4 [\#812](https://github.com/apache/camel-k/pull/812) ([lburgazzoli](https://github.com/lburgazzoli))
- fix: Kamel install with kit option can leave integrationkit stuck waiting for platform [\#810](https://github.com/apache/camel-k/pull/810) ([jamesnetherton](https://github.com/jamesnetherton))
- fix: Dependencies & rest-dsl traits are never enabled [\#808](https://github.com/apache/camel-k/pull/808) ([jamesnetherton](https://github.com/jamesnetherton))
- fix: Nil pointer on build failure recovery [\#805](https://github.com/apache/camel-k/pull/805) ([jamesnetherton](https://github.com/jamesnetherton))
- Revert "chore: Re-enable e2e tests" [\#803](https://github.com/apache/camel-k/pull/803) ([lburgazzoli](https://github.com/lburgazzoli))
- chore: Re-enable e2e tests [\#802](https://github.com/apache/camel-k/pull/802) ([jamesnetherton](https://github.com/jamesnetherton))
- chore\(build\): strip full path from stackstraces [\#801](https://github.com/apache/camel-k/pull/801) ([lburgazzoli](https://github.com/lburgazzoli))
- Support for new yaml dsl [\#800](https://github.com/apache/camel-k/pull/800) ([lburgazzoli](https://github.com/lburgazzoli))
- Move waiting for platform to controller [\#799](https://github.com/apache/camel-k/pull/799) ([lburgazzoli](https://github.com/lburgazzoli))
- Don't wait for initial kit to be ready to declare the platform ready [\#796](https://github.com/apache/camel-k/pull/796) ([lburgazzoli](https://github.com/lburgazzoli))
- Add keys [\#790](https://github.com/apache/camel-k/pull/790) ([lburgazzoli](https://github.com/lburgazzoli))
- chore\(travis\): disable e2e [\#787](https://github.com/apache/camel-k/pull/787) ([lburgazzoli](https://github.com/lburgazzoli))
- chore: extract indentedwriter to it's own package and make it an utility [\#786](https://github.com/apache/camel-k/pull/786) ([lburgazzoli](https://github.com/lburgazzoli))
- refactor\(trait\): replace resources and execute post action as part of trait management [\#785](https://github.com/apache/camel-k/pull/785) ([lburgazzoli](https://github.com/lburgazzoli))
- Refactor controller logic [\#784](https://github.com/apache/camel-k/pull/784) ([lburgazzoli](https://github.com/lburgazzoli))
- Route trait does not work if route.auto is set to false [\#783](https://github.com/apache/camel-k/pull/783) ([lburgazzoli](https://github.com/lburgazzoli))
- Initial upgrade support [\#782](https://github.com/apache/camel-k/pull/782) ([nicolaferraro](https://github.com/nicolaferraro))
- fix: Integration naming issues with numbers in them [\#779](https://github.com/apache/camel-k/pull/779) ([jamesnetherton](https://github.com/jamesnetherton))
- fix: Validate maven artifacts [\#774](https://github.com/apache/camel-k/pull/774) ([jamesnetherton](https://github.com/jamesnetherton))
- chore\(lint\): run golanci-lint on travis [\#773](https://github.com/apache/camel-k/pull/773) ([lburgazzoli](https://github.com/lburgazzoli))
- chore: cleanup integration kit [\#772](https://github.com/apache/camel-k/pull/772) ([lburgazzoli](https://github.com/lburgazzoli))
- chore: cleanup build [\#771](https://github.com/apache/camel-k/pull/771) ([lburgazzoli](https://github.com/lburgazzoli))
- chore\(lint\): fix findings [\#770](https://github.com/apache/camel-k/pull/770) ([lburgazzoli](https://github.com/lburgazzoli))
- chore\(integration controller\): replace custom reconcile trigger with watch [\#769](https://github.com/apache/camel-k/pull/769) ([lburgazzoli](https://github.com/lburgazzoli))
- Add conditions to camel-k CRs [\#766](https://github.com/apache/camel-k/pull/766) ([lburgazzoli](https://github.com/lburgazzoli))
- Add timeout to maven operations [\#765](https://github.com/apache/camel-k/pull/765) ([lburgazzoli](https://github.com/lburgazzoli))
- chore\(lint\): fix findings [\#760](https://github.com/apache/camel-k/pull/760) ([lburgazzoli](https://github.com/lburgazzoli))
- Automatically create catalogs from maven [\#759](https://github.com/apache/camel-k/pull/759) ([lburgazzoli](https://github.com/lburgazzoli))
- Add e2e tests [\#758](https://github.com/apache/camel-k/pull/758) ([nicolaferraro](https://github.com/nicolaferraro))
- Service trait: confusing behavior [\#757](https://github.com/apache/camel-k/pull/757) ([lburgazzoli](https://github.com/lburgazzoli))
-  feat: Add a --global install option [\#752](https://github.com/apache/camel-k/pull/752) ([jamesnetherton](https://github.com/jamesnetherton))
- Fix \#749: do not create route/ingress if not needed [\#750](https://github.com/apache/camel-k/pull/750) ([nicolaferraro](https://github.com/nicolaferraro))
-  fix: CR example is using wrong schema [\#748](https://github.com/apache/camel-k/pull/748) ([jamesnetherton](https://github.com/jamesnetherton))
- The --maven-repository shortcut does not configure plugin repositories [\#747](https://github.com/apache/camel-k/pull/747) ([lburgazzoli](https://github.com/lburgazzoli))
- chore\(builder\): ensure files added tot he tar archive have the right permissions [\#741](https://github.com/apache/camel-k/pull/741) ([lburgazzoli](https://github.com/lburgazzoli))
- fix: Honour KUBECONFIG [\#740](https://github.com/apache/camel-k/pull/740) ([jamesnetherton](https://github.com/jamesnetherton))
- Set RestWithRestlet response Content-Type header to text/plain [\#738](https://github.com/apache/camel-k/pull/738) ([jamesnetherton](https://github.com/jamesnetherton))
- Added KEYS file [\#734](https://github.com/apache/camel-k/pull/734) ([oscerd](https://github.com/oscerd))
- Bump to 1.0.0-M1-SNAPSHOT and release changes [\#733](https://github.com/apache/camel-k/pull/733) ([nicolaferraro](https://github.com/nicolaferraro))
- Rename 'context' term used by Camel K. [\#726](https://github.com/apache/camel-k/pull/726) ([lburgazzoli](https://github.com/lburgazzoli))

## [0.3.4](https://github.com/apache/camel-k/tree/0.3.4) (2019-06-07)

[Full Changelog](https://github.com/apache/camel-k/compare/0.3.3...0.3.4)

**Closed issues:**

- Don't automatically install contexts upon platform installation [\#716](https://github.com/apache/camel-k/issues/716)
- Allow to provide custom settings.xml  [\#715](https://github.com/apache/camel-k/issues/715)
- Question about the installation of the cluster [\#701](https://github.com/apache/camel-k/issues/701)
- Provide a way to override the default image name [\#698](https://github.com/apache/camel-k/issues/698)
- kamel run --dev examples/resources-route.groovy issues Cannot find resource [\#697](https://github.com/apache/camel-k/issues/697)
- Making sure external dep projects can import Camel K APIs [\#679](https://github.com/apache/camel-k/issues/679)
- Remove depenency on Istio for Knative sources [\#669](https://github.com/apache/camel-k/issues/669)
- Allow to subscribe to multiple knative channels in the same integration   [\#668](https://github.com/apache/camel-k/issues/668)
- Error creating integration context with buildStrategy: pod on minikube [\#666](https://github.com/apache/camel-k/issues/666)
- Use in-memory channel provisioner in place of in-memory-channel in Knative example [\#663](https://github.com/apache/camel-k/issues/663)
- Integration stuck waiting for platform [\#660](https://github.com/apache/camel-k/issues/660)
- Update to Camel 2.24.0 [\#655](https://github.com/apache/camel-k/issues/655)
- Improve documentation [\#653](https://github.com/apache/camel-k/issues/653)
- Remove camel 3.0.0-M1 catalog [\#651](https://github.com/apache/camel-k/issues/651)
- remove support for integration container image creation [\#650](https://github.com/apache/camel-k/issues/650)
- include context traits when looking up for a compatible context [\#649](https://github.com/apache/camel-k/issues/649)
- examples/knative splitter 'Service.serving.knative.dev \"words\" not found' [\#645](https://github.com/apache/camel-k/issues/645)
- Release 0.3.3 [\#642](https://github.com/apache/camel-k/issues/642)
- Generate catalog for recent Camel versions [\#637](https://github.com/apache/camel-k/issues/637)
- Deprecate integration image creation [\#627](https://github.com/apache/camel-k/issues/627)
- Set env var with Kamel [\#606](https://github.com/apache/camel-k/issues/606)
- Add support for DSL in Knative Camel Sources [\#567](https://github.com/apache/camel-k/issues/567)
- drop support for knative \< 0.4 [\#552](https://github.com/apache/camel-k/issues/552)
- remove spring boot support [\#534](https://github.com/apache/camel-k/issues/534)
- camel-k on Openshift Container Platform 3.11 [\#493](https://github.com/apache/camel-k/issues/493)
- Add spring-boot example in the examples directory [\#397](https://github.com/apache/camel-k/issues/397)
- examples/knative broken on OpenShift knative 0.6.0, must not set the field\(s\): spec.runLatest.configuration.revisionTemplate.spec.container.env\[11\].valueFrom.fieldRef [\#722](https://github.com/apache/camel-k/issues/722)
- PGP Sign released artifacts [\#707](https://github.com/apache/camel-k/issues/707)
- Setup the maven proxy inside of the builder [\#706](https://github.com/apache/camel-k/issues/706)
- Automatically use pod build strategy in "AllNamespaces" setup [\#703](https://github.com/apache/camel-k/issues/703)
- Release 0.3.4 [\#683](https://github.com/apache/camel-k/issues/683)

**Merged pull requests:**

- chore\(regen\): regenerate defaults [\#727](https://github.com/apache/camel-k/pull/727) ([lburgazzoli](https://github.com/lburgazzoli))
- fix: Do not share labels map reference in integration deployment [\#725](https://github.com/apache/camel-k/pull/725) ([astefanutti](https://github.com/astefanutti))
- Filter allowed env variables in Knative [\#724](https://github.com/apache/camel-k/pull/724) ([nicolaferraro](https://github.com/nicolaferraro))
- Automatically configure global build strategy [\#723](https://github.com/apache/camel-k/pull/723) ([nicolaferraro](https://github.com/nicolaferraro))
- chore\(build\): remove test artifacts [\#721](https://github.com/apache/camel-k/pull/721) ([lburgazzoli](https://github.com/lburgazzoli))
-  Allow to provide custom settings.xml [\#720](https://github.com/apache/camel-k/pull/720) ([lburgazzoli](https://github.com/lburgazzoli))
- Don't automatically install contexts upon platform installation [\#719](https://github.com/apache/camel-k/pull/719) ([lburgazzoli](https://github.com/lburgazzoli))
- chore: default to camel-k-runtime v0.3.3 [\#718](https://github.com/apache/camel-k/pull/718) ([lburgazzoli](https://github.com/lburgazzoli))
- Fix \#707: sign released artifacts [\#713](https://github.com/apache/camel-k/pull/713) ([nicolaferraro](https://github.com/nicolaferraro))
- \#709 Add ASL license header into the files [\#712](https://github.com/apache/camel-k/pull/712) ([WillemJiang](https://github.com/WillemJiang))
- kamel run --dev examples/resources-route.groovy issues Cannot find resource [\#710](https://github.com/apache/camel-k/pull/710) ([lburgazzoli](https://github.com/lburgazzoli))
- \#701 Update the cluster-setup document for installing knative on minishift [\#708](https://github.com/apache/camel-k/pull/708) ([WillemJiang](https://github.com/WillemJiang))
- trait\(route\): do not set Route.Spec.TLS if not needed [\#705](https://github.com/apache/camel-k/pull/705) ([lburgazzoli](https://github.com/lburgazzoli))
- Fix \#698: 2nd attempt [\#704](https://github.com/apache/camel-k/pull/704) ([nicolaferraro](https://github.com/nicolaferraro))
- feat: Set env var with Kamel [\#696](https://github.com/apache/camel-k/pull/696) ([jamesnetherton](https://github.com/jamesnetherton))
- Fix \#644: remove predefined images [\#695](https://github.com/apache/camel-k/pull/695) ([nicolaferraro](https://github.com/nicolaferraro))
- chore: disable modules when invoking go clean [\#694](https://github.com/apache/camel-k/pull/694) ([lburgazzoli](https://github.com/lburgazzoli))
- chore: fix lint finding [\#691](https://github.com/apache/camel-k/pull/691) ([lburgazzoli](https://github.com/lburgazzoli))
- chore: include build info in camel-k operator [\#690](https://github.com/apache/camel-k/pull/690) ([lburgazzoli](https://github.com/lburgazzoli))
- Update to Camel 2.24.0 [\#689](https://github.com/apache/camel-k/pull/689) ([lburgazzoli](https://github.com/lburgazzoli))
- chore: remove spring-boot leftovers [\#688](https://github.com/apache/camel-k/pull/688) ([lburgazzoli](https://github.com/lburgazzoli))
- Remove vendor directory for good [\#685](https://github.com/apache/camel-k/pull/685) ([astefanutti](https://github.com/astefanutti))
- fix: Integration stuck waiting for platform [\#684](https://github.com/apache/camel-k/pull/684) ([jamesnetherton](https://github.com/jamesnetherton))
- Fix \#679: make sure we don't use external deps other than kube in apis [\#680](https://github.com/apache/camel-k/pull/680) ([nicolaferraro](https://github.com/nicolaferraro))
- A pack of small Knative improvements [\#678](https://github.com/apache/camel-k/pull/678) ([nicolaferraro](https://github.com/nicolaferraro))
- chore: support for health based on servlet available from 0.3.3-SNAPSHOT [\#676](https://github.com/apache/camel-k/pull/676) ([lburgazzoli](https://github.com/lburgazzoli))
- Migrate to Go modules [\#675](https://github.com/apache/camel-k/pull/675) ([astefanutti](https://github.com/astefanutti))
- trait\(route\): tls support [\#673](https://github.com/apache/camel-k/pull/673) ([lburgazzoli](https://github.com/lburgazzoli))
- chore\(lint\): better naming [\#672](https://github.com/apache/camel-k/pull/672) ([lburgazzoli](https://github.com/lburgazzoli))
- Upgrade Operator SDK to version 0.8.0 [\#671](https://github.com/apache/camel-k/pull/671) ([astefanutti](https://github.com/astefanutti))
- chore\(lint\): fix findings [\#670](https://github.com/apache/camel-k/pull/670) ([lburgazzoli](https://github.com/lburgazzoli))
- fix wrong log method used to log formatted content [\#667](https://github.com/apache/camel-k/pull/667) ([lburgazzoli](https://github.com/lburgazzoli))
- Unified operator deployment [\#661](https://github.com/apache/camel-k/pull/661) ([astefanutti](https://github.com/astefanutti))
- include context traits when looking up for a compatible context [\#659](https://github.com/apache/camel-k/pull/659) ([lburgazzoli](https://github.com/lburgazzoli))
- drop support for knative \< 0.4 [\#658](https://github.com/apache/camel-k/pull/658) ([lburgazzoli](https://github.com/lburgazzoli))
- remove spring boot support [\#657](https://github.com/apache/camel-k/pull/657) ([lburgazzoli](https://github.com/lburgazzoli))
- remove support for integration container image creation [\#656](https://github.com/apache/camel-k/pull/656) ([lburgazzoli](https://github.com/lburgazzoli))
- Fix \#651: removed camel 3.0.0-M1 catalog [\#652](https://github.com/apache/camel-k/pull/652) ([aldettinger](https://github.com/aldettinger))
- Initial OLM manifest [\#648](https://github.com/apache/camel-k/pull/648) ([astefanutti](https://github.com/astefanutti))
- Adding a note about the delay at first Sample run [\#647](https://github.com/apache/camel-k/pull/647) ([rafaeltuelho](https://github.com/rafaeltuelho))
- Fix \#645: use the right kind of sink in knative trait [\#646](https://github.com/apache/camel-k/pull/646) ([nicolaferraro](https://github.com/nicolaferraro))
- chore\(doc\): change the description of the project [\#628](https://github.com/apache/camel-k/pull/628) ([nicolaferraro](https://github.com/nicolaferraro))

## [0.3.3](https://github.com/apache/camel-k/tree/0.3.3) (2019-05-03)

[Full Changelog](https://github.com/apache/camel-k/compare/0.3.2...0.3.3)

**Closed issues:**

- LanguageXML is not included in languages list [\#634](https://github.com/apache/camel-k/issues/634)
- FTP producer: Error writig file [\#620](https://github.com/apache/camel-k/issues/620)
- Kamel binary install on Windows 10 with Minikube [\#619](https://github.com/apache/camel-k/issues/619)
- Malformed maven project while building context [\#618](https://github.com/apache/camel-k/issues/618)
- istio: allow to control annotation sidecar.istio.io/inject [\#609](https://github.com/apache/camel-k/issues/609)
- allow to configure default configurations on platform [\#608](https://github.com/apache/camel-k/issues/608)
- Script set-version.sh does not honor the registry/repository settings [\#602](https://github.com/apache/camel-k/issues/602)
- add options to configure affinity [\#601](https://github.com/apache/camel-k/issues/601)
- camel-k groovy, jvm, spring-boot gives error pushing image [\#588](https://github.com/apache/camel-k/issues/588)
- on-premises: mount rwx volume [\#587](https://github.com/apache/camel-k/issues/587)
- context with status error should not be included when looking up suitable context for an integration [\#584](https://github.com/apache/camel-k/issues/584)
- Release 0.3.2 [\#576](https://github.com/apache/camel-k/issues/576)
- When using hystrix EIP then auto include camel-hystrix dependency [\#575](https://github.com/apache/camel-k/issues/575)
- camel-k-operator pod CrashLoopBackOff on minikube on restart [\#537](https://github.com/apache/camel-k/issues/537)
- Resolving Dependency Automatically -- aws-s3 [\#419](https://github.com/apache/camel-k/issues/419)
- Kamel CLI - Add command to view which dependencies the pre-build context has loaded [\#398](https://github.com/apache/camel-k/issues/398)
- Review resource conflict hanndling [\#363](https://github.com/apache/camel-k/issues/363)
- Split builder from operator [\#125](https://github.com/apache/camel-k/issues/125)

**Merged pull requests:**

- Upgrade to camel-k-runtime 0.3.2 [\#643](https://github.com/apache/camel-k/pull/643) ([davsclaus](https://github.com/davsclaus))
- feat: Add volume argument to kamel run [\#640](https://github.com/apache/camel-k/pull/640) ([jamesnetherton](https://github.com/jamesnetherton))
- fix: Add .exe file extension to Windows kamel binary [\#636](https://github.com/apache/camel-k/pull/636) ([jamesnetherton](https://github.com/jamesnetherton))
- LanguageXML is not included in languages list \#634 [\#635](https://github.com/apache/camel-k/pull/635) ([lburgazzoli](https://github.com/lburgazzoli))
- feat: Add kamel describe command [\#633](https://github.com/apache/camel-k/pull/633) ([jamesnetherton](https://github.com/jamesnetherton))
- Modified PR \#625 as requested [\#632](https://github.com/apache/camel-k/pull/632) ([valdar](https://github.com/valdar))
- Use non-caching client in builds scheduling critical section [\#631](https://github.com/apache/camel-k/pull/631) ([astefanutti](https://github.com/astefanutti))
- Updated README for configmap [\#626](https://github.com/apache/camel-k/pull/626) ([stevef1uk](https://github.com/stevef1uk))
- Build improvements [\#623](https://github.com/apache/camel-k/pull/623) ([astefanutti](https://github.com/astefanutti))
-  allow to configure default configurations on platform [\#622](https://github.com/apache/camel-k/pull/622) ([lburgazzoli](https://github.com/lburgazzoli))
- Fix \#602: error in set-version script [\#621](https://github.com/apache/camel-k/pull/621) ([nicolaferraro](https://github.com/nicolaferraro))
- chore\(build\): add builder to dev workflow [\#616](https://github.com/apache/camel-k/pull/616) ([nicolaferraro](https://github.com/nicolaferraro))
- Rely on label selector to query older generation resources in GC [\#615](https://github.com/apache/camel-k/pull/615) ([astefanutti](https://github.com/astefanutti))
- Update gke-setup.adoc [\#612](https://github.com/apache/camel-k/pull/612) ([MehrCurry](https://github.com/MehrCurry))
- Fix \#575: recognize hystrix automatically [\#611](https://github.com/apache/camel-k/pull/611) ([nicolaferraro](https://github.com/nicolaferraro))
- istio: allow to control annotation sidecar.istio.io/inject i [\#610](https://github.com/apache/camel-k/pull/610) ([lburgazzoli](https://github.com/lburgazzoli))
- Add affinity trait [\#607](https://github.com/apache/camel-k/pull/607) ([astefanutti](https://github.com/astefanutti))
- fix \#602: Script set-version.sh does not honor the registry/repository… [\#603](https://github.com/apache/camel-k/pull/603) ([valdar](https://github.com/valdar))
- Change builder to sync style API and remove in-memory working queue [\#599](https://github.com/apache/camel-k/pull/599) ([astefanutti](https://github.com/astefanutti))
- Upgrade Operator SDK to version 0.7.0 [\#596](https://github.com/apache/camel-k/pull/596) ([astefanutti](https://github.com/astefanutti))
- cleanup [\#590](https://github.com/apache/camel-k/pull/590) ([lburgazzoli](https://github.com/lburgazzoli))
- context with status error should not be included when looking up suitable context for an integration [\#585](https://github.com/apache/camel-k/pull/585) ([lburgazzoli](https://github.com/lburgazzoli))
- Split builder from operator [\#583](https://github.com/apache/camel-k/pull/583) ([astefanutti](https://github.com/astefanutti))
- Add log4j-slf4j-impl as runtime dependency in default project build [\#578](https://github.com/apache/camel-k/pull/578) ([astefanutti](https://github.com/astefanutti))

## [0.3.2](https://github.com/apache/camel-k/tree/0.3.2) (2019-03-26)

[Full Changelog](https://github.com/apache/camel-k/compare/0.3.1...0.3.2)

**Closed issues:**

- Unable to create subscription to channel [\#579](https://github.com/apache/camel-k/issues/579)
- allow to configure resources requests/limits [\#570](https://github.com/apache/camel-k/issues/570)
- Add support for traits defaults [\#566](https://github.com/apache/camel-k/issues/566)
- Can't connect to kservices [\#553](https://github.com/apache/camel-k/issues/553)
- Release 0.3.1 [\#540](https://github.com/apache/camel-k/issues/540)
- Knative pods not scaling down to zero [\#498](https://github.com/apache/camel-k/issues/498)
- improve release process [\#458](https://github.com/apache/camel-k/issues/458)
- Upgrade to Apache Camel 3.0.0-M1 [\#452](https://github.com/apache/camel-k/issues/452)
- JVM issue on Minikube while running Sample.java integration using 0.2.0 release of Kamel binary [\#424](https://github.com/apache/camel-k/issues/424)

**Merged pull requests:**

- Fix \#579: fix namespace in subscription [\#581](https://github.com/apache/camel-k/pull/581) ([nicolaferraro](https://github.com/nicolaferraro))
- chore\(style\): apply gofmt after code generation [\#577](https://github.com/apache/camel-k/pull/577) ([lburgazzoli](https://github.com/lburgazzoli))
- allow to configure resources requests/limits [\#573](https://github.com/apache/camel-k/pull/573) ([lburgazzoli](https://github.com/lburgazzoli))
- Add support for traits defaults [\#572](https://github.com/apache/camel-k/pull/572) ([lburgazzoli](https://github.com/lburgazzoli))
- knative: create full camel environment [\#571](https://github.com/apache/camel-k/pull/571) ([lburgazzoli](https://github.com/lburgazzoli))
- dependencies: add support for boms [\#565](https://github.com/apache/camel-k/pull/565) ([lburgazzoli](https://github.com/lburgazzoli))
- Upgrade Operator SDK to version 0.6.0 [\#562](https://github.com/apache/camel-k/pull/562) ([astefanutti](https://github.com/astefanutti))

## [0.3.1](https://github.com/apache/camel-k/tree/0.3.1) (2019-03-15)

[Full Changelog](https://github.com/apache/camel-k/compare/0.3.0...0.3.1)

**Closed issues:**

- Unable to use predefined images [\#557](https://github.com/apache/camel-k/issues/557)
- Improve SanitizeName [\#548](https://github.com/apache/camel-k/issues/548)
- camel-k --runtime-version is not honoured for all runtimes [\#538](https://github.com/apache/camel-k/issues/538)
- Timeout in S2I build [\#536](https://github.com/apache/camel-k/issues/536)
- Add option to health probes [\#525](https://github.com/apache/camel-k/issues/525)
- Remove operator metrics port and service [\#513](https://github.com/apache/camel-k/issues/513)
- Adding Probes to Knative services [\#511](https://github.com/apache/camel-k/issues/511)
- Release version 0.3.0 [\#489](https://github.com/apache/camel-k/issues/489)

**Merged pull requests:**

- Fix \#557: fix generated images [\#560](https://github.com/apache/camel-k/pull/560) ([nicolaferraro](https://github.com/nicolaferraro))
- chore\(maven\): Run Maven in batch mode to reduce log noise [\#556](https://github.com/apache/camel-k/pull/556) ([jamesnetherton](https://github.com/jamesnetherton))
- knative: fix copy secrets to env vars [\#555](https://github.com/apache/camel-k/pull/555) ([lburgazzoli](https://github.com/lburgazzoli))
- resources: add options to configure mount path and key [\#554](https://github.com/apache/camel-k/pull/554) ([lburgazzoli](https://github.com/lburgazzoli))
- Timeout in S2I build [\#551](https://github.com/apache/camel-k/pull/551) ([lburgazzoli](https://github.com/lburgazzoli))
- fix: Improve how SanitizeName handles paths and URLs [\#549](https://github.com/apache/camel-k/pull/549) ([jamesnetherton](https://github.com/jamesnetherton))
- fix bug due to state change during trait evaluation [\#547](https://github.com/apache/camel-k/pull/547) ([nicolaferraro](https://github.com/nicolaferraro))
- chore\(refactor\): move JAVA\_CLASSPATH configuration to classpath trait [\#546](https://github.com/apache/camel-k/pull/546) ([lburgazzoli](https://github.com/lburgazzoli))
- fix: include mount paths in java's classpath [\#545](https://github.com/apache/camel-k/pull/545) ([lburgazzoli](https://github.com/lburgazzoli))
- chore\(fix\): minScale and maxScale should be always greater than 0 [\#544](https://github.com/apache/camel-k/pull/544) ([nicolaferraro](https://github.com/nicolaferraro))
- Add explicit kind selection to deployer trait [\#543](https://github.com/apache/camel-k/pull/543) ([nicolaferraro](https://github.com/nicolaferraro))
- chore\(runtime\): update to runtime v0.3.1 [\#542](https://github.com/apache/camel-k/pull/542) ([lburgazzoli](https://github.com/lburgazzoli))
- chore: Remove operator metrics port and service [\#541](https://github.com/apache/camel-k/pull/541) ([jamesnetherton](https://github.com/jamesnetherton))
- camel-k --runtime-version is not honoured for all runtimes [\#539](https://github.com/apache/camel-k/pull/539) ([lburgazzoli](https://github.com/lburgazzoli))
- Improve owner trait [\#535](https://github.com/apache/camel-k/pull/535) ([lburgazzoli](https://github.com/lburgazzoli))
- chore\(lint\): fix findings [\#533](https://github.com/apache/camel-k/pull/533) ([lburgazzoli](https://github.com/lburgazzoli))
- fix: do not add probes to knative services [\#532](https://github.com/apache/camel-k/pull/532) ([lburgazzoli](https://github.com/lburgazzoli))
- Add option to health probes [\#531](https://github.com/apache/camel-k/pull/531) ([lburgazzoli](https://github.com/lburgazzoli))
- feature\(kaniko\): support for incremental build [\#530](https://github.com/apache/camel-k/pull/530) ([lburgazzoli](https://github.com/lburgazzoli))
- ordered delete [\#529](https://github.com/apache/camel-k/pull/529) ([lburgazzoli](https://github.com/lburgazzoli))
- chore\(kamel\): fix reset command [\#526](https://github.com/apache/camel-k/pull/526) ([lburgazzoli](https://github.com/lburgazzoli))
- chore\(release\): add automatic version update to release [\#524](https://github.com/apache/camel-k/pull/524) ([nicolaferraro](https://github.com/nicolaferraro))
- Adding Probes to Knative services [\#514](https://github.com/apache/camel-k/pull/514) ([lburgazzoli](https://github.com/lburgazzoli))

## [0.3.0](https://github.com/apache/camel-k/tree/0.3.0) (2019-03-04)

[Full Changelog](https://github.com/apache/camel-k/compare/0.2.1...0.3.0)

**Closed issues:**

- Allow file names as "kamel delete" argument [\#515](https://github.com/apache/camel-k/issues/515)
- Update minikube docs  [\#508](https://github.com/apache/camel-k/issues/508)
- Unable to start knative route [\#506](https://github.com/apache/camel-k/issues/506)
- Add kamel option to uninstall [\#503](https://github.com/apache/camel-k/issues/503)
- Upgrade to Knative  \> v0.3.0 [\#497](https://github.com/apache/camel-k/issues/497)
- Support for MAVEN\_MIRROR\_URL [\#492](https://github.com/apache/camel-k/issues/492)
- Came-k routes takes long time to terminate [\#490](https://github.com/apache/camel-k/issues/490)
- improve resource gc performances [\#487](https://github.com/apache/camel-k/issues/487)
- Unable to send message to knative channel [\#483](https://github.com/apache/camel-k/issues/483)
- add finalizer to ensure integration children are cleaned up [\#477](https://github.com/apache/camel-k/issues/477)
- move runtime in its own repository [\#470](https://github.com/apache/camel-k/issues/470)
- add an option to set which runtime version the operator should to run integrations [\#469](https://github.com/apache/camel-k/issues/469)
- do not include runtime artefacts in operator image by default [\#468](https://github.com/apache/camel-k/issues/468)
- add a tool to generate json schema from custom resources [\#461](https://github.com/apache/camel-k/issues/461)
- move integration reconcile loop wake-up field to status [\#460](https://github.com/apache/camel-k/issues/460)
- release version 0.2.1 [\#453](https://github.com/apache/camel-k/issues/453)
- Use Kaniko Cache to speedup [\#196](https://github.com/apache/camel-k/issues/196)

**Merged pull requests:**

- fix: Allow file names as delete cmd argument [\#522](https://github.com/apache/camel-k/pull/522) ([christophd](https://github.com/christophd))
- chore\(image\): include camel runtime adapters [\#521](https://github.com/apache/camel-k/pull/521) ([lburgazzoli](https://github.com/lburgazzoli))
- test\(builder\): more assertions on deps [\#520](https://github.com/apache/camel-k/pull/520) ([oscerd](https://github.com/oscerd))
- chore\(build\): remove jitpack configuration [\#519](https://github.com/apache/camel-k/pull/519) ([lburgazzoli](https://github.com/lburgazzoli))
- chore\(runtime\): Bump runtime to 0.3.0 [\#518](https://github.com/apache/camel-k/pull/518) ([oscerd](https://github.com/oscerd))
- knative\(serving\): add support for additional annotations [\#517](https://github.com/apache/camel-k/pull/517) ([lburgazzoli](https://github.com/lburgazzoli))
- chore\(make\): fix images-push target [\#510](https://github.com/apache/camel-k/pull/510) ([lburgazzoli](https://github.com/lburgazzoli))
- minikube doc update [\#509](https://github.com/apache/camel-k/pull/509) ([kameshsampath](https://github.com/kameshsampath))
- chore\(crd\): add missing label to CamelCatalog CRD [\#502](https://github.com/apache/camel-k/pull/502) ([lburgazzoli](https://github.com/lburgazzoli))
- chore\(install\): fix wrong resource kind [\#501](https://github.com/apache/camel-k/pull/501) ([lburgazzoli](https://github.com/lburgazzoli))
- feature\(knative\): support configmap and secrets [\#500](https://github.com/apache/camel-k/pull/500) ([lburgazzoli](https://github.com/lburgazzoli))
- Fix \#497: upgrade to knative 0.4.0 [\#499](https://github.com/apache/camel-k/pull/499) ([nicolaferraro](https://github.com/nicolaferraro))
- Perform garbage collection asynchronously [\#496](https://github.com/apache/camel-k/pull/496) ([astefanutti](https://github.com/astefanutti))
- Do not swallow error returned by controller actions [\#494](https://github.com/apache/camel-k/pull/494) ([astefanutti](https://github.com/astefanutti))
- sanitize dependencies [\#491](https://github.com/apache/camel-k/pull/491) ([lburgazzoli](https://github.com/lburgazzoli))
- chore\(controller\): reduce logging when action fails because of conflicts, log the error message without the stack and re-queue the reconcilation [\#488](https://github.com/apache/camel-k/pull/488) ([lburgazzoli](https://github.com/lburgazzoli))
- do not include runtime artefacts in operator image by default [\#486](https://github.com/apache/camel-k/pull/486) ([lburgazzoli](https://github.com/lburgazzoli))
- chore\(version\): Align to latest runtime, until we remove git submodule [\#485](https://github.com/apache/camel-k/pull/485) ([oscerd](https://github.com/oscerd))
- chore\(refactor\): Added license to .travis.yml [\#484](https://github.com/apache/camel-k/pull/484) ([oscerd](https://github.com/oscerd))
- add finalizer to ensure integration children are cleaned up [\#480](https://github.com/apache/camel-k/pull/480) ([lburgazzoli](https://github.com/lburgazzoli))
- Activate Kaniko caching and warm the platform base image [\#479](https://github.com/apache/camel-k/pull/479) ([astefanutti](https://github.com/astefanutti))
- add an option to set which runtime version the operator should to run integrations [\#478](https://github.com/apache/camel-k/pull/478) ([lburgazzoli](https://github.com/lburgazzoli))
- Aligned the submodule runtime from camel-k-runtime [\#476](https://github.com/apache/camel-k/pull/476) ([oscerd](https://github.com/oscerd))
- Removed JenkinsFile since it used by the runtime repo now [\#475](https://github.com/apache/camel-k/pull/475) ([oscerd](https://github.com/oscerd))
- Fixes \#470 [\#474](https://github.com/apache/camel-k/pull/474) ([oscerd](https://github.com/oscerd))
- fix\(traints\): ensure an error is returned to the caller if a catalog cannot be found [\#472](https://github.com/apache/camel-k/pull/472) ([lburgazzoli](https://github.com/lburgazzoli))
- Remove unecessary Go dep overrides [\#467](https://github.com/apache/camel-k/pull/467) ([astefanutti](https://github.com/astefanutti))
- fix\(semver\): support exact version match when looking up camel catalog [\#465](https://github.com/apache/camel-k/pull/465) ([lburgazzoli](https://github.com/lburgazzoli))
- Fix lint errors [\#464](https://github.com/apache/camel-k/pull/464) ([astefanutti](https://github.com/astefanutti))
- Add a phase to wake up integration reconcile loop on context build co… [\#463](https://github.com/apache/camel-k/pull/463) ([astefanutti](https://github.com/astefanutti))
- add a tool to generate json schema from custom resources  [\#462](https://github.com/apache/camel-k/pull/462) ([lburgazzoli](https://github.com/lburgazzoli))
- Optimize reconciliation loops [\#459](https://github.com/apache/camel-k/pull/459) ([astefanutti](https://github.com/astefanutti))

## [0.2.1](https://github.com/apache/camel-k/tree/0.2.1) (2019-02-19)

[Full Changelog](https://github.com/apache/camel-k/compare/0.2.0...0.2.1)

**Closed issues:**

- deploy camel-k runtime artifacts to apache snapshot automatically [\#447](https://github.com/apache/camel-k/issues/447)
- move catalog definition in status instead of spec [\#446](https://github.com/apache/camel-k/issues/446)
- camel catalog controller [\#445](https://github.com/apache/camel-k/issues/445)
- Add field 'camel-version' to Integration CRD [\#439](https://github.com/apache/camel-k/issues/439)
- Passing image destination to build [\#437](https://github.com/apache/camel-k/issues/437)
- Error while deploying integration in Knative based environment [\#436](https://github.com/apache/camel-k/issues/436)
- deploy runtime snapshots to apache snapshot repo [\#432](https://github.com/apache/camel-k/issues/432)
- support for semver catalog resolution [\#414](https://github.com/apache/camel-k/issues/414)
- The example RestWithRestlet does not work calling its service via curl or webbrowser [\#402](https://github.com/apache/camel-k/issues/402)
- runtime: ensure that the generated project uses the right camel version [\#384](https://github.com/apache/camel-k/issues/384)
- camel-knative: support for cloud events specs v0.2 [\#376](https://github.com/apache/camel-k/issues/376)
- Failed to resolve endpoint: twitter-search [\#370](https://github.com/apache/camel-k/issues/370)
- Add a trait to configure/enable jolokia [\#369](https://github.com/apache/camel-k/issues/369)
- Automatically apply defaults to platform configuration [\#365](https://github.com/apache/camel-k/issues/365)
- Use consistent logging style [\#362](https://github.com/apache/camel-k/issues/362)
- Allow to configure the location fo the local maven repo [\#358](https://github.com/apache/camel-k/issues/358)
- kamel stuck when a secret has an illegal name [\#356](https://github.com/apache/camel-k/issues/356)
- catalog should be available as custom resource [\#302](https://github.com/apache/camel-k/issues/302)
- Provide a way to inject annotations/labels into child resources [\#263](https://github.com/apache/camel-k/issues/263)
- Remove old resources on redeploy [\#211](https://github.com/apache/camel-k/issues/211)
- Expose metrics to Prometheus [\#82](https://github.com/apache/camel-k/issues/82)
- Cannot deploy integration if not in the root package [\#41](https://github.com/apache/camel-k/issues/41)

**Merged pull requests:**

- Added a FailIfNoTests option to Surefire [\#457](https://github.com/apache/camel-k/pull/457) ([oscerd](https://github.com/oscerd))
- Enable status subresource for integration context [\#456](https://github.com/apache/camel-k/pull/456) ([astefanutti](https://github.com/astefanutti))
- Enable status subresource for integration platform [\#455](https://github.com/apache/camel-k/pull/455) ([astefanutti](https://github.com/astefanutti))
- Added release profile [\#454](https://github.com/apache/camel-k/pull/454) ([oscerd](https://github.com/oscerd))
- chore\(catalog\): improve camel catalog generation [\#451](https://github.com/apache/camel-k/pull/451) ([lburgazzoli](https://github.com/lburgazzoli))
- Remove deploy phase from test and install stage [\#450](https://github.com/apache/camel-k/pull/450) ([oscerd](https://github.com/oscerd))
- Fixed Jenkinsfile [\#449](https://github.com/apache/camel-k/pull/449) ([oscerd](https://github.com/oscerd))
- chore\(build\): deploy camel-k runtime artifacts to apache snapshot aut… [\#448](https://github.com/apache/camel-k/pull/448) ([oscerd](https://github.com/oscerd))
- Cannot deploy integration if not in the root package [\#444](https://github.com/apache/camel-k/pull/444) ([lburgazzoli](https://github.com/lburgazzoli))
- Error while deploying integration in Knative based environment [\#443](https://github.com/apache/camel-k/pull/443) ([lburgazzoli](https://github.com/lburgazzoli))
- Add field 'camel-version' to Integration CRD [\#442](https://github.com/apache/camel-k/pull/442) ([lburgazzoli](https://github.com/lburgazzoli))
- fix rest dsl generation [\#441](https://github.com/apache/camel-k/pull/441) ([lburgazzoli](https://github.com/lburgazzoli))
- Pass garbage collection items by values instead of references [\#440](https://github.com/apache/camel-k/pull/440) ([astefanutti](https://github.com/astefanutti))
- Ability to customise the generated camel-k image [\#438](https://github.com/apache/camel-k/pull/438) ([kameshsampath](https://github.com/kameshsampath))
- chore\(deploy snapshot\): deploy runtime snapshots to apache snapshot r… [\#435](https://github.com/apache/camel-k/pull/435) ([oscerd](https://github.com/oscerd))
- Fix typos in traits doc [\#434](https://github.com/apache/camel-k/pull/434) ([astefanutti](https://github.com/astefanutti))
- Add garbage collector trait [\#433](https://github.com/apache/camel-k/pull/433) ([astefanutti](https://github.com/astefanutti))
- Fix operator leader election [\#430](https://github.com/apache/camel-k/pull/430) ([astefanutti](https://github.com/astefanutti))
- Deactivate Downloading/Downloaded Maven log messages from CI build [\#429](https://github.com/apache/camel-k/pull/429) ([astefanutti](https://github.com/astefanutti))
- Set Maven batch mode for CI Maven build [\#428](https://github.com/apache/camel-k/pull/428) ([astefanutti](https://github.com/astefanutti))
- chore\(catalog\): reduce build\_catalog.sh verbosity [\#427](https://github.com/apache/camel-k/pull/427) ([lburgazzoli](https://github.com/lburgazzoli))
- Upgrade operator SDK to version 0.5.0 [\#426](https://github.com/apache/camel-k/pull/426) ([astefanutti](https://github.com/astefanutti))
- chore\(runtime\): prepare for deployment [\#425](https://github.com/apache/camel-k/pull/425) ([lburgazzoli](https://github.com/lburgazzoli))
- feature\(kamel\): Validate --context when given [\#423](https://github.com/apache/camel-k/pull/423) ([rhuss](https://github.com/rhuss))
- Support transfering annotations and labels from an integration onto o… [\#422](https://github.com/apache/camel-k/pull/422) ([astefanutti](https://github.com/astefanutti))
- enhancement\(runtime\): improve runtime lifecycle handling [\#420](https://github.com/apache/camel-k/pull/420) ([lburgazzoli](https://github.com/lburgazzoli))
- Fixed --property flag, now commas can be used inside flag's value. [\#418](https://github.com/apache/camel-k/pull/418) ([valdar](https://github.com/valdar))
- Moved route loading of jvm-runtime inside a Listner to load them afte… [\#417](https://github.com/apache/camel-k/pull/417) ([valdar](https://github.com/valdar))
- chore\(runtime\): update dependencies [\#416](https://github.com/apache/camel-k/pull/416) ([lburgazzoli](https://github.com/lburgazzoli))
- Resolve camel catalog from custom resource [\#415](https://github.com/apache/camel-k/pull/415) ([lburgazzoli](https://github.com/lburgazzoli))
- runtime: ensure that the generated project uses the right camel version [\#413](https://github.com/apache/camel-k/pull/413) ([lburgazzoli](https://github.com/lburgazzoli))
- Renamed RuntimeTrait in ContextCustomizer since the name clashed and … [\#412](https://github.com/apache/camel-k/pull/412) ([valdar](https://github.com/valdar))
- chore\(lint\): fix lint fidings and standardize traits initialization [\#411](https://github.com/apache/camel-k/pull/411) ([lburgazzoli](https://github.com/lburgazzoli))
- fix context.Context misuse [\#410](https://github.com/apache/camel-k/pull/410) ([lburgazzoli](https://github.com/lburgazzoli))
- camel-knative: support for cloud events specs v0.2 [\#409](https://github.com/apache/camel-k/pull/409) ([lburgazzoli](https://github.com/lburgazzoli))
- Fix CSV map string parsing [\#408](https://github.com/apache/camel-k/pull/408) ([astefanutti](https://github.com/astefanutti))
- Add an option to deactivate ServiceMonitor resource creation in Prome… [\#407](https://github.com/apache/camel-k/pull/407) ([astefanutti](https://github.com/astefanutti))
- The example RestWithRestlet does not work calling its service via curl or webbrowser [\#406](https://github.com/apache/camel-k/pull/406) ([lburgazzoli](https://github.com/lburgazzoli))
- Default OpenShift proxy client principal in Jolokia trait [\#405](https://github.com/apache/camel-k/pull/405) ([astefanutti](https://github.com/astefanutti))
- Update Jolokia trait documentation [\#404](https://github.com/apache/camel-k/pull/404) ([astefanutti](https://github.com/astefanutti))
- Factorize CSV map string parsing [\#403](https://github.com/apache/camel-k/pull/403) ([astefanutti](https://github.com/astefanutti))
- Improve error handling while parsing Prometheus service monitor labels [\#401](https://github.com/apache/camel-k/pull/401) ([astefanutti](https://github.com/astefanutti))
- Jolokia trait configuration maps JVM agent options directly [\#400](https://github.com/apache/camel-k/pull/400) ([astefanutti](https://github.com/astefanutti))
- chore\(maven\): simplify maven model [\#399](https://github.com/apache/camel-k/pull/399) ([lburgazzoli](https://github.com/lburgazzoli))
- Fixed array index out of boun that would kill camel-k operator in case of a malformed --dependency [\#396](https://github.com/apache/camel-k/pull/396) ([valdar](https://github.com/valdar))
- Fix comment about multi-valuated CLI trait configuration option [\#392](https://github.com/apache/camel-k/pull/392) ([astefanutti](https://github.com/astefanutti))
- Use named target ports in integration service [\#391](https://github.com/apache/camel-k/pull/391) ([astefanutti](https://github.com/astefanutti))
- Add Prometheus ServiceMonitor labels trait configuration [\#390](https://github.com/apache/camel-k/pull/390) ([astefanutti](https://github.com/astefanutti))
- Fixed AddDependency in integration\_type\_support.go to handle default … [\#389](https://github.com/apache/camel-k/pull/389) ([valdar](https://github.com/valdar))
- Aggregate multiple occurences of the same run command CLI option into… [\#388](https://github.com/apache/camel-k/pull/388) ([astefanutti](https://github.com/astefanutti))
- Add container ports to integration deployment [\#387](https://github.com/apache/camel-k/pull/387) ([astefanutti](https://github.com/astefanutti))
- Automatically apply defaults to platform configuration \#365 [\#386](https://github.com/apache/camel-k/pull/386) ([lburgazzoli](https://github.com/lburgazzoli))
- Use consistent logging style [\#385](https://github.com/apache/camel-k/pull/385) ([lburgazzoli](https://github.com/lburgazzoli))
- Service and Prometheus traits aggregate into a single service per int… [\#382](https://github.com/apache/camel-k/pull/382) ([astefanutti](https://github.com/astefanutti))
- Fix trait properties to kebab case [\#381](https://github.com/apache/camel-k/pull/381) ([astefanutti](https://github.com/astefanutti))
- Deactivate the Prometheus agent in trait Apply instead of Configure [\#380](https://github.com/apache/camel-k/pull/380) ([astefanutti](https://github.com/astefanutti))
- chore\(s2i\): update base image to 3.0-java8 [\#379](https://github.com/apache/camel-k/pull/379) ([lburgazzoli](https://github.com/lburgazzoli))
- runtime: simplify loader development [\#378](https://github.com/apache/camel-k/pull/378) ([lburgazzoli](https://github.com/lburgazzoli))
- Failed to resolve endpoint: twitter-search [\#377](https://github.com/apache/camel-k/pull/377) ([lburgazzoli](https://github.com/lburgazzoli))
- Jolokia trait initial implementation [\#375](https://github.com/apache/camel-k/pull/375) ([astefanutti](https://github.com/astefanutti))
- Configure Prometheus agent port based on trait property [\#373](https://github.com/apache/camel-k/pull/373) ([astefanutti](https://github.com/astefanutti))
- Added a commit to explain why duoble trait.apply is used in RuntimeSu… [\#372](https://github.com/apache/camel-k/pull/372) ([valdar](https://github.com/valdar))
- runtime: improve discovery and configuration of runtime traits [\#371](https://github.com/apache/camel-k/pull/371) ([lburgazzoli](https://github.com/lburgazzoli))
- Activate the Prometheus Java agent according to the eponym trait conf… [\#368](https://github.com/apache/camel-k/pull/368) ([astefanutti](https://github.com/astefanutti))
- chore\(deps\): update kotlin to v1.3.20 [\#367](https://github.com/apache/camel-k/pull/367) ([lburgazzoli](https://github.com/lburgazzoli))
- Prometheus trait initial implementation [\#364](https://github.com/apache/camel-k/pull/364) ([astefanutti](https://github.com/astefanutti))
- chore\(release\): add publisher to makefile [\#360](https://github.com/apache/camel-k/pull/360) ([nicolaferraro](https://github.com/nicolaferraro))
- Allow to configure the location fo the local maven repo [\#359](https://github.com/apache/camel-k/pull/359) ([lburgazzoli](https://github.com/lburgazzoli))
- kamel stuck when a secret has an illegal name [\#357](https://github.com/apache/camel-k/pull/357) ([lburgazzoli](https://github.com/lburgazzoli))
- Enable status subresource for integration [\#352](https://github.com/apache/camel-k/pull/352) ([astefanutti](https://github.com/astefanutti))
- build handlers: split buld step in two phases: submit and run [\#351](https://github.com/apache/camel-k/pull/351) ([lburgazzoli](https://github.com/lburgazzoli))

## [0.2.0](https://github.com/apache/camel-k/tree/0.2.0) (2019-01-22)

[Full Changelog](https://github.com/apache/camel-k/compare/0.1.0...0.2.0)

**Closed issues:**

- Use container name for "kamel log", too [\#347](https://github.com/apache/camel-k/issues/347)
- Allow to configure the base image used to run integrations [\#340](https://github.com/apache/camel-k/issues/340)
- Use standard deployment for Knative event sources [\#324](https://github.com/apache/camel-k/issues/324)
- support for openapi/swagger  [\#323](https://github.com/apache/camel-k/issues/323)
- create camel-k-maven-plugin [\#322](https://github.com/apache/camel-k/issues/322)
- Allow to customize contexts create at installation [\#318](https://github.com/apache/camel-k/issues/318)
- Option to create an Integration Context from an existing image [\#316](https://github.com/apache/camel-k/issues/316)
- Publish some base images together with Camel K [\#312](https://github.com/apache/camel-k/issues/312)
- Add a simplified model for sources [\#307](https://github.com/apache/camel-k/issues/307)
- The kaniko build pod failed to start [\#306](https://github.com/apache/camel-k/issues/306)
- Allow to customize integration service account [\#305](https://github.com/apache/camel-k/issues/305)
- catalog : include camel-k components [\#301](https://github.com/apache/camel-k/issues/301)
- Set the env var KOTLIN\_JDK\_HOME to point to your real JDK home [\#297](https://github.com/apache/camel-k/issues/297)
- Support for runtime traits [\#287](https://github.com/apache/camel-k/issues/287)
- Inject camel-k version as environment variable [\#285](https://github.com/apache/camel-k/issues/285)
- Platform options [\#284](https://github.com/apache/camel-k/issues/284)
- IntegrationContext builds sometimes fail [\#279](https://github.com/apache/camel-k/issues/279)
- trait: add a trait to inject pod metadata as env var [\#275](https://github.com/apache/camel-k/issues/275)
- Display relevant custom columns [\#274](https://github.com/apache/camel-k/issues/274)
- Refactor traits lifecycle [\#268](https://github.com/apache/camel-k/issues/268)
- Determine active/passive endpoints from Catalog [\#264](https://github.com/apache/camel-k/issues/264)
- add resources to an integration [\#241](https://github.com/apache/camel-k/issues/241)
- Migrate to Operator SDK 0.1.x [\#237](https://github.com/apache/camel-k/issues/237)
- Use docker-registry.default.svc to reference images [\#221](https://github.com/apache/camel-k/issues/221)
- Add option to extract all resources needed to install Camel K [\#220](https://github.com/apache/camel-k/issues/220)
- Exposing Rest endpoint [\#212](https://github.com/apache/camel-k/issues/212)
- Creating Ingress and services with Kubernetes  [\#189](https://github.com/apache/camel-k/issues/189)
- create knative context [\#183](https://github.com/apache/camel-k/issues/183)
- Add a state to integrations waiting for platform to be ready [\#136](https://github.com/apache/camel-k/issues/136)
- Add a "-w" flag to "kamel install" [\#135](https://github.com/apache/camel-k/issues/135)
- Provide PR build check on pull requests [\#132](https://github.com/apache/camel-k/issues/132)
- Provide link to CI in readme [\#121](https://github.com/apache/camel-k/issues/121)
- Add a dev's mode to kamel command to push project directly within the pod [\#108](https://github.com/apache/camel-k/issues/108)

**Merged pull requests:**

- fix openapi handling when used in conjunction with deployment.container-image=true [\#350](https://github.com/apache/camel-k/pull/350) ([lburgazzoli](https://github.com/lburgazzoli))
- chore: regenerated resources.go [\#349](https://github.com/apache/camel-k/pull/349) ([rhuss](https://github.com/rhuss))
- fix\(kamel log\): Use integration name for looking up containers [\#348](https://github.com/apache/camel-k/pull/348) ([rhuss](https://github.com/rhuss))
- Integration/IntegrationContext builds sometimes fail [\#346](https://github.com/apache/camel-k/pull/346) ([lburgazzoli](https://github.com/lburgazzoli))
- chore\(contributing.adoc\): Add explanation to add KOTLIN\_JDK\_HOME for building on MacOs [\#344](https://github.com/apache/camel-k/pull/344) ([rhuss](https://github.com/rhuss))
- builder: add hooks to the builder state changes to update resources when the build completes [\#343](https://github.com/apache/camel-k/pull/343) ([lburgazzoli](https://github.com/lburgazzoli))
- Allow to configure the base image used to run integrations [\#341](https://github.com/apache/camel-k/pull/341) ([lburgazzoli](https://github.com/lburgazzoli))
- Upgrade Jackson to version 2.9.8 [\#339](https://github.com/apache/camel-k/pull/339) ([oscerd](https://github.com/oscerd))
- Bump to Camel 2.23.1 [\#337](https://github.com/apache/camel-k/pull/337) ([oscerd](https://github.com/oscerd))
- Some Knative improvements [\#336](https://github.com/apache/camel-k/pull/336) ([nicolaferraro](https://github.com/nicolaferraro))
- Fix bug in compression utils [\#335](https://github.com/apache/camel-k/pull/335) ([nicolaferraro](https://github.com/nicolaferraro))
- openapi: fix automatic service configuration [\#333](https://github.com/apache/camel-k/pull/333) ([lburgazzoli](https://github.com/lburgazzoli))
- Add a state to integrations waiting for platform to be ready [\#332](https://github.com/apache/camel-k/pull/332) ([lburgazzoli](https://github.com/lburgazzoli))
- Add a -w flag to kamel install [\#331](https://github.com/apache/camel-k/pull/331) ([lburgazzoli](https://github.com/lburgazzoli))
- chore: refactor source inspector [\#329](https://github.com/apache/camel-k/pull/329) ([lburgazzoli](https://github.com/lburgazzoli))
- support for openapi/swagger  [\#328](https://github.com/apache/camel-k/pull/328) ([lburgazzoli](https://github.com/lburgazzoli))
- create camel-k-maven-plugin [\#326](https://github.com/apache/camel-k/pull/326) ([lburgazzoli](https://github.com/lburgazzoli))
- Release some predefined images for Knative [\#325](https://github.com/apache/camel-k/pull/325) ([nicolaferraro](https://github.com/nicolaferraro))
- Runtime dep upgrade [\#321](https://github.com/apache/camel-k/pull/321) ([lburgazzoli](https://github.com/lburgazzoli))
- chore\(ux\): show the same basic info with oc and kamel [\#320](https://github.com/apache/camel-k/pull/320) ([lburgazzoli](https://github.com/lburgazzoli))
- Allow to customize contexts create at installation [\#319](https://github.com/apache/camel-k/pull/319) ([lburgazzoli](https://github.com/lburgazzoli))
- Option to create an Integration Context from an existing image [\#317](https://github.com/apache/camel-k/pull/317) ([lburgazzoli](https://github.com/lburgazzoli))
- Migrate to operator-sdk 0.3.0 [\#315](https://github.com/apache/camel-k/pull/315) ([nicolaferraro](https://github.com/nicolaferraro))
- chore\(knative\): do not change spec during processing [\#314](https://github.com/apache/camel-k/pull/314) ([nicolaferraro](https://github.com/nicolaferraro))
- chore\(knative\): improvements for creating Knative CamelSources [\#313](https://github.com/apache/camel-k/pull/313) ([nicolaferraro](https://github.com/nicolaferraro))
- chore\(client\): add a reset command [\#310](https://github.com/apache/camel-k/pull/310) ([nicolaferraro](https://github.com/nicolaferraro))
- Remove the "./" prefix before sanitizing the integration name. [\#309](https://github.com/apache/camel-k/pull/309) ([crystaldust](https://github.com/crystaldust))
- runtime: add support for a simple yaml flow [\#308](https://github.com/apache/camel-k/pull/308) ([lburgazzoli](https://github.com/lburgazzoli))
- Display relevant custom columns [\#304](https://github.com/apache/camel-k/pull/304) ([lburgazzoli](https://github.com/lburgazzoli))
- catalog : include camel-k components [\#303](https://github.com/apache/camel-k/pull/303) ([lburgazzoli](https://github.com/lburgazzoli))
- add resources to an integration [\#300](https://github.com/apache/camel-k/pull/300) ([lburgazzoli](https://github.com/lburgazzoli))
- chore\(runtime\): try to lookup routes loaders from registry first, then from resources/services [\#298](https://github.com/apache/camel-k/pull/298) ([lburgazzoli](https://github.com/lburgazzoli))
- Platform options  [\#296](https://github.com/apache/camel-k/pull/296) ([lburgazzoli](https://github.com/lburgazzoli))
- chore\(release\): package examples to publish them during release [\#295](https://github.com/apache/camel-k/pull/295) ([nicolaferraro](https://github.com/nicolaferraro))
- Allow to generate install resources if needed [\#294](https://github.com/apache/camel-k/pull/294) ([nicolaferraro](https://github.com/nicolaferraro))
- Re-add missing commits [\#293](https://github.com/apache/camel-k/pull/293) ([nicolaferraro](https://github.com/nicolaferraro))
- chore\(log\): make dev-mode work in Knative [\#280](https://github.com/apache/camel-k/pull/280) ([nicolaferraro](https://github.com/nicolaferraro))
- Fix \#221: use registry name instead of IP in Knative on Openshift [\#278](https://github.com/apache/camel-k/pull/278) ([nicolaferraro](https://github.com/nicolaferraro))
- Determine active/passive endpoints from Catalog [\#277](https://github.com/apache/camel-k/pull/277) ([lburgazzoli](https://github.com/lburgazzoli))
- trait: add a trait to inject pod metadata as env var [\#276](https://github.com/apache/camel-k/pull/276) ([lburgazzoli](https://github.com/lburgazzoli))
- Traits lifecycle [\#273](https://github.com/apache/camel-k/pull/273) ([lburgazzoli](https://github.com/lburgazzoli))

## [0.1.0](https://github.com/apache/camel-k/tree/0.1.0) (2018-12-10)

[Full Changelog](https://github.com/apache/camel-k/compare/0.0.5...0.1.0)

**Closed issues:**

- Allow using compressed sources in Knative profile [\#270](https://github.com/apache/camel-k/issues/270)
- Support for compressed source blob [\#265](https://github.com/apache/camel-k/issues/265)
- add an option to always generate a docker image [\#246](https://github.com/apache/camel-k/issues/246)
- temporary build folder not cleaned up [\#230](https://github.com/apache/camel-k/issues/230)
- Do not always scale down to 0 in Knative [\#219](https://github.com/apache/camel-k/issues/219)
- Allow to push to a Knative channel or service endpoint [\#218](https://github.com/apache/camel-k/issues/218)
- Support subscription to multiple Knative channels [\#216](https://github.com/apache/camel-k/issues/216)
- Create a Istio trait [\#209](https://github.com/apache/camel-k/issues/209)
- Provide example with custom processor [\#205](https://github.com/apache/camel-k/issues/205)
- Kamel CLI - Add command to run integration in Java debug mode [\#190](https://github.com/apache/camel-k/issues/190)
- runtime : create cloudevents camel component [\#171](https://github.com/apache/camel-k/issues/171)
- Investigate switching to kubebuilder [\#169](https://github.com/apache/camel-k/issues/169)
- Allow to use dash syntax in configuring component properties [\#142](https://github.com/apache/camel-k/issues/142)
- Introducing Traits [\#115](https://github.com/apache/camel-k/issues/115)
- Trigger context update when build finishes [\#113](https://github.com/apache/camel-k/issues/113)
- Support for multiple integration definitions [\#45](https://github.com/apache/camel-k/issues/45)

**Merged pull requests:**

- Allow using compressed sources in Knative profile [\#272](https://github.com/apache/camel-k/pull/272) ([lburgazzoli](https://github.com/lburgazzoli))
- chore\(deps\): update kotlin to v1.3.11 [\#271](https://github.com/apache/camel-k/pull/271) ([lburgazzoli](https://github.com/lburgazzoli))
- builder: wake up event loop when the container image buils is done to seep up deployment time [\#269](https://github.com/apache/camel-k/pull/269) ([lburgazzoli](https://github.com/lburgazzoli))
- chore: rename constant KamelPlatform to IntegrationContextTypePlatform [\#267](https://github.com/apache/camel-k/pull/267) ([lburgazzoli](https://github.com/lburgazzoli))
- Support for compressed source blob  [\#266](https://github.com/apache/camel-k/pull/266) ([lburgazzoli](https://github.com/lburgazzoli))
- Better Knative and Istio integration [\#261](https://github.com/apache/camel-k/pull/261) ([nicolaferraro](https://github.com/nicolaferraro))
- chore\(runtime\): code cleanup [\#260](https://github.com/apache/camel-k/pull/260) ([lburgazzoli](https://github.com/lburgazzoli))
- chore: add all sorts of linters and pre-commit hook [\#257](https://github.com/apache/camel-k/pull/257) ([zregvart](https://github.com/zregvart))
- Update runtime dependencies [\#256](https://github.com/apache/camel-k/pull/256) ([lburgazzoli](https://github.com/lburgazzoli))
- add an option to always generate a docker image [\#253](https://github.com/apache/camel-k/pull/253) ([lburgazzoli](https://github.com/lburgazzoli))
- chore: add debug trait [\#252](https://github.com/apache/camel-k/pull/252) ([zregvart](https://github.com/zregvart))
- runtime\(springboot\): set the exact list of dependencies used by spring boot instead of use everithing in the dependencies folder [\#251](https://github.com/apache/camel-k/pull/251) ([lburgazzoli](https://github.com/lburgazzoli))
- Update dependencies [\#250](https://github.com/apache/camel-k/pull/250) ([lburgazzoli](https://github.com/lburgazzoli))
- chore: support for computing knative channel/service host name from uri [\#248](https://github.com/apache/camel-k/pull/248) ([lburgazzoli](https://github.com/lburgazzoli))
- Allow to push to Knative channels [\#247](https://github.com/apache/camel-k/pull/247) ([nicolaferraro](https://github.com/nicolaferraro))
- small adjustments to README [\#245](https://github.com/apache/camel-k/pull/245) ([onderson](https://github.com/onderson))
- typo [\#244](https://github.com/apache/camel-k/pull/244) ([davsclaus](https://github.com/davsclaus))
- Fixing some govet findings [\#243](https://github.com/apache/camel-k/pull/243) ([oscerd](https://github.com/oscerd))
- Make go-report happy again with gofmt [\#242](https://github.com/apache/camel-k/pull/242) ([oscerd](https://github.com/oscerd))
- support for spring boot [\#239](https://github.com/apache/camel-k/pull/239) ([lburgazzoli](https://github.com/lburgazzoli))
- initial support for custom maven repositories [\#238](https://github.com/apache/camel-k/pull/238) ([lburgazzoli](https://github.com/lburgazzoli))
- Trigger context update when build finishes [\#236](https://github.com/apache/camel-k/pull/236) ([lburgazzoli](https://github.com/lburgazzoli))
- Support for multiple integration definitions [\#235](https://github.com/apache/camel-k/pull/235) ([lburgazzoli](https://github.com/lburgazzoli))
- runtime: add a netty4-http based knative component [\#234](https://github.com/apache/camel-k/pull/234) ([lburgazzoli](https://github.com/lburgazzoli))
- trait: add builder trait [\#233](https://github.com/apache/camel-k/pull/233) ([lburgazzoli](https://github.com/lburgazzoli))
- Make it work on GKE [\#232](https://github.com/apache/camel-k/pull/232) ([nicolaferraro](https://github.com/nicolaferraro))
- temporary build folder not cleaned up [\#231](https://github.com/apache/camel-k/pull/231) ([lburgazzoli](https://github.com/lburgazzoli))
- refactor: make traits more flexible [\#229](https://github.com/apache/camel-k/pull/229) ([lburgazzoli](https://github.com/lburgazzoli))
- Bump version to 0.0.6-SNAPSHOT [\#228](https://github.com/apache/camel-k/pull/228) ([nicolaferraro](https://github.com/nicolaferraro))

## [0.0.5](https://github.com/apache/camel-k/tree/0.0.5) (2018-11-16)

[Full Changelog](https://github.com/apache/camel-k/compare/0.0.4...0.0.5)

**Closed issues:**

- Kaniko build failing on Minikube [\#226](https://github.com/apache/camel-k/issues/226)
- camel-k make resulting in test failures while building runtime kotlin  [\#222](https://github.com/apache/camel-k/issues/222)
- Provide option to get the Json/Yaml of a integration [\#207](https://github.com/apache/camel-k/issues/207)
- Where we can get XSD for plain XML DSL? [\#201](https://github.com/apache/camel-k/issues/201)
- Cannot configure traits [\#199](https://github.com/apache/camel-k/issues/199)
- camel-k-context-jvm, camel-k-context-kotlin, camel-k-context-groovy pods goes into error state when installing camel-k [\#194](https://github.com/apache/camel-k/issues/194)
- Installation hangs on GKE  [\#188](https://github.com/apache/camel-k/issues/188)
- kamel run --dev mode terminate pod if pressing ctrl + c [\#184](https://github.com/apache/camel-k/issues/184)
- runtime : create knative camel component [\#172](https://github.com/apache/camel-k/issues/172)
- Doc and/or command should be changed - kamel install [\#106](https://github.com/apache/camel-k/issues/106)

**Merged pull requests:**

- Fix kaniko build [\#227](https://github.com/apache/camel-k/pull/227) ([nicolaferraro](https://github.com/nicolaferraro))
- runtime: small improvement to the dependency lister plugin [\#225](https://github.com/apache/camel-k/pull/225) ([lburgazzoli](https://github.com/lburgazzoli))
- new builder [\#223](https://github.com/apache/camel-k/pull/223) ([lburgazzoli](https://github.com/lburgazzoli))
- Update deps and cleanup [\#217](https://github.com/apache/camel-k/pull/217) ([lburgazzoli](https://github.com/lburgazzoli))
- Add base support for Knative eventing [\#215](https://github.com/apache/camel-k/pull/215) ([nicolaferraro](https://github.com/nicolaferraro))
- Add first Knative trait and profiles [\#210](https://github.com/apache/camel-k/pull/210) ([nicolaferraro](https://github.com/nicolaferraro))
- feat: \#207 Provide option to get the Json/Yaml of a integration [\#208](https://github.com/apache/camel-k/pull/208) ([chirino](https://github.com/chirino))
- cloudevents & knative [\#204](https://github.com/apache/camel-k/pull/204) ([lburgazzoli](https://github.com/lburgazzoli))
- Added some traits and full refactoring [\#203](https://github.com/apache/camel-k/pull/203) ([nicolaferraro](https://github.com/nicolaferraro))
- Fix compatibility with operator sdk 0.0.7 [\#202](https://github.com/apache/camel-k/pull/202) ([nicolaferraro](https://github.com/nicolaferraro))
- Cannot configure traits [\#200](https://github.com/apache/camel-k/pull/200) ([lburgazzoli](https://github.com/lburgazzoli))
- \(chore\) add an example of xml route [\#198](https://github.com/apache/camel-k/pull/198) ([nicolaferraro](https://github.com/nicolaferraro))
- Use a working kaniko sha [\#197](https://github.com/apache/camel-k/pull/197) ([nicolaferraro](https://github.com/nicolaferraro))
- runtime\(kotline\): update to kotlin 1.3.0 release [\#195](https://github.com/apache/camel-k/pull/195) ([lburgazzoli](https://github.com/lburgazzoli))
- Fix installation on new cluster and upgrade operator sdk [\#193](https://github.com/apache/camel-k/pull/193) ([nicolaferraro](https://github.com/nicolaferraro))
- Fix CI Job [\#192](https://github.com/apache/camel-k/pull/192) ([nicolaferraro](https://github.com/nicolaferraro))
- misc runtime fixes and improvements [\#191](https://github.com/apache/camel-k/pull/191) ([lburgazzoli](https://github.com/lburgazzoli))
- corrected minor spelling or wrong language reference \(Kotlin-\>JavaScript\) [\#187](https://github.com/apache/camel-k/pull/187) ([marcellanz](https://github.com/marcellanz))
- kamel run --dev mode terminate pod if pressing ctrl + c  [\#186](https://github.com/apache/camel-k/pull/186) ([dmvolod](https://github.com/dmvolod))
- Ci integration tests [\#165](https://github.com/apache/camel-k/pull/165) ([nicolaferraro](https://github.com/nicolaferraro))

## [0.0.4](https://github.com/apache/camel-k/tree/0.0.4) (2018-10-16)

[Full Changelog](https://github.com/apache/camel-k/compare/0.0.3...0.0.4)

**Closed issues:**

- configure camel context from properties  [\#175](https://github.com/apache/camel-k/issues/175)
- Camel-http4 not recognized automatically [\#174](https://github.com/apache/camel-k/issues/174)
- Property placeholder conflict in groovy [\#173](https://github.com/apache/camel-k/issues/173)
- kamel "get" should not return contexts [\#161](https://github.com/apache/camel-k/issues/161)
- Add log command [\#153](https://github.com/apache/camel-k/issues/153)
- Add option to run from URL [\#137](https://github.com/apache/camel-k/issues/137)
- Enable integration tests in CI [\#127](https://github.com/apache/camel-k/issues/127)
- Need a Web UI? [\#77](https://github.com/apache/camel-k/issues/77)

**Merged pull requests:**

- chore\(logging\): move log colouring definition to runtime [\#181](https://github.com/apache/camel-k/pull/181) ([lburgazzoli](https://github.com/lburgazzoli))
- camel-http4 not recognized automatically [\#180](https://github.com/apache/camel-k/pull/180) ([lburgazzoli](https://github.com/lburgazzoli))
- Add log command [\#179](https://github.com/apache/camel-k/pull/179) ([lburgazzoli](https://github.com/lburgazzoli))
- configure camel context from properties [\#178](https://github.com/apache/camel-k/pull/178) ([lburgazzoli](https://github.com/lburgazzoli))
- Misc fixing [\#177](https://github.com/apache/camel-k/pull/177) ([lburgazzoli](https://github.com/lburgazzoli))
- operator: swich to type safe trait definition [\#176](https://github.com/apache/camel-k/pull/176) ([lburgazzoli](https://github.com/lburgazzoli))
- runtime\(groovy\) : improve registry dsl [\#170](https://github.com/apache/camel-k/pull/170) ([lburgazzoli](https://github.com/lburgazzoli))
- Regenerate code, deps and fixes [\#166](https://github.com/apache/camel-k/pull/166) ([lburgazzoli](https://github.com/lburgazzoli))
- Add travis build info [\#163](https://github.com/apache/camel-k/pull/163) ([nicolaferraro](https://github.com/nicolaferraro))
- \(chore\) Add gitter badge [\#162](https://github.com/apache/camel-k/pull/162) ([nicolaferraro](https://github.com/nicolaferraro))
- Add initial support for traits [\#160](https://github.com/apache/camel-k/pull/160) ([nicolaferraro](https://github.com/nicolaferraro))
- Make goReport happy, again [\#159](https://github.com/apache/camel-k/pull/159) ([oscerd](https://github.com/oscerd))
- Minor fix in the order of operation for sanitizing integration name [\#158](https://github.com/apache/camel-k/pull/158) ([oscerd](https://github.com/oscerd))
- runtime: refine groovy dsl [\#157](https://github.com/apache/camel-k/pull/157) ([lburgazzoli](https://github.com/lburgazzoli))
- Add option to run from URL [\#156](https://github.com/apache/camel-k/pull/156) ([oscerd](https://github.com/oscerd))
- doc: add initial documentation about integration DSLs [\#155](https://github.com/apache/camel-k/pull/155) ([lburgazzoli](https://github.com/lburgazzoli))
- \(chore\): use operator-sdk master and fix tests [\#154](https://github.com/apache/camel-k/pull/154) ([nicolaferraro](https://github.com/nicolaferraro))
- runtime: improve rest dsl for groovy and kotlin runtimes [\#152](https://github.com/apache/camel-k/pull/152) ([lburgazzoli](https://github.com/lburgazzoli))
- runtime: improve kotlin dsl [\#151](https://github.com/apache/camel-k/pull/151) ([lburgazzoli](https://github.com/lburgazzoli))
- runtime: improve groovy dsl [\#150](https://github.com/apache/camel-k/pull/150) ([lburgazzoli](https://github.com/lburgazzoli))
- chore: compile integration tests on make [\#149](https://github.com/apache/camel-k/pull/149) ([nicolaferraro](https://github.com/nicolaferraro))
- runtime: enhance groovy dsl [\#148](https://github.com/apache/camel-k/pull/148) ([lburgazzoli](https://github.com/lburgazzoli))

## [0.0.3](https://github.com/apache/camel-k/tree/0.0.3) (2018-10-02)

[Full Changelog](https://github.com/apache/camel-k/compare/0.0.2...0.0.3)

**Closed issues:**

- Dead link in Developer's guide "runtime" [\#124](https://github.com/apache/camel-k/issues/124)
- Regression for groovy routes [\#118](https://github.com/apache/camel-k/issues/118)
- Add bindings for rest dsl in groovy/js routes [\#117](https://github.com/apache/camel-k/issues/117)
- Experiment with janino to build java expressions to reduce java verbosity [\#116](https://github.com/apache/camel-k/issues/116)
- Report correct build status in case of failure [\#114](https://github.com/apache/camel-k/issues/114)
- Document latest improvements and release 0.0.2 [\#102](https://github.com/apache/camel-k/issues/102)
- Create a Camel CRD [\#73](https://github.com/apache/camel-k/issues/73)
- Figure out how to deploy integrations on plain Kubernetes [\#32](https://github.com/apache/camel-k/issues/32)

**Merged pull requests:**

- Added Maven Wrapper [\#147](https://github.com/apache/camel-k/pull/147) ([oscerd](https://github.com/oscerd))
- Added vendor directory to avoid dep ensure [\#145](https://github.com/apache/camel-k/pull/145) ([oscerd](https://github.com/oscerd))
- chore: small improvement to groovy dls [\#144](https://github.com/apache/camel-k/pull/144) ([lburgazzoli](https://github.com/lburgazzoli))
- Added an example of binding object in Camel registry in groovy [\#143](https://github.com/apache/camel-k/pull/143) ([oscerd](https://github.com/oscerd))
- Add initial implementation of a DSL to bind object to camel registry [\#141](https://github.com/apache/camel-k/pull/141) ([lburgazzoli](https://github.com/lburgazzoli))
- Use properties to configure components and logging [\#140](https://github.com/apache/camel-k/pull/140) ([lburgazzoli](https://github.com/lburgazzoli))
- Add support for plain Kubernetes [\#138](https://github.com/apache/camel-k/pull/138) ([nicolaferraro](https://github.com/nicolaferraro))
- Polish and make go-report happy [\#134](https://github.com/apache/camel-k/pull/134) ([oscerd](https://github.com/oscerd))
- runtime: support for kotlin runtime [\#133](https://github.com/apache/camel-k/pull/133) ([lburgazzoli](https://github.com/lburgazzoli))
- Defer cancel function call returned by WithDeadline in tests [\#131](https://github.com/apache/camel-k/pull/131) ([oscerd](https://github.com/oscerd))
- Remove unreachable code in pod\_scraper.go [\#130](https://github.com/apache/camel-k/pull/130) ([oscerd](https://github.com/oscerd))
- Dead link in Developer's guide "runtime" [\#129](https://github.com/apache/camel-k/pull/129) ([oscerd](https://github.com/oscerd))
- Report correct build status in case of failure [\#128](https://github.com/apache/camel-k/pull/128) ([oscerd](https://github.com/oscerd))
- Add IntegrationPlatform resource [\#126](https://github.com/apache/camel-k/pull/126) ([nicolaferraro](https://github.com/nicolaferraro))
- Avoid deprecated addRoutes \(replaced by includeRoutes\) [\#123](https://github.com/apache/camel-k/pull/123) ([apupier](https://github.com/apupier))
- Fix "typo" Openshift -\> OpenShift [\#122](https://github.com/apache/camel-k/pull/122) ([apupier](https://github.com/apupier))
- Add bindings for rest dsl in groovy/js routes [\#120](https://github.com/apache/camel-k/pull/120) ([lburgazzoli](https://github.com/lburgazzoli))
- Groovy regression [\#119](https://github.com/apache/camel-k/pull/119) ([lburgazzoli](https://github.com/lburgazzoli))
- Speed up s2i a little bit [\#112](https://github.com/apache/camel-k/pull/112) ([nicolaferraro](https://github.com/nicolaferraro))
- chore\(kamel\): improve completion and context delete [\#111](https://github.com/apache/camel-k/pull/111) ([lburgazzoli](https://github.com/lburgazzoli))
- chore\(dep\): remove dependency on yaml.v1 [\#110](https://github.com/apache/camel-k/pull/110) ([lburgazzoli](https://github.com/lburgazzoli))
- Add asciidoc documentation with sub-documents and some badges [\#109](https://github.com/apache/camel-k/pull/109) ([nicolaferraro](https://github.com/nicolaferraro))
- Refactor build, deploy and run workflow [\#107](https://github.com/apache/camel-k/pull/107) ([lburgazzoli](https://github.com/lburgazzoli))
- Bump version to 0.0.3-SNAPSHOT [\#105](https://github.com/apache/camel-k/pull/105) ([nicolaferraro](https://github.com/nicolaferraro))

## [0.0.2](https://github.com/apache/camel-k/tree/0.0.2) (2018-09-19)

[Full Changelog](https://github.com/apache/camel-k/compare/0.0.1...0.0.2)

**Closed issues:**

- Add delete integration option [\#96](https://github.com/apache/camel-k/issues/96)
- Auto-discover dependencies [\#94](https://github.com/apache/camel-k/issues/94)
- Embed camel catalog [\#93](https://github.com/apache/camel-k/issues/93)
- Integrations are started twice [\#90](https://github.com/apache/camel-k/issues/90)
- Fails to run build after install with  javax.net.ssl.SSLProtocolException: handshake alert:  unrecognized\_name [\#84](https://github.com/apache/camel-k/issues/84)
- Manually trigger integration update [\#80](https://github.com/apache/camel-k/issues/80)
- Automatically create "platform" contexts [\#75](https://github.com/apache/camel-k/issues/75)
- Install a root IntegrationContext [\#74](https://github.com/apache/camel-k/issues/74)
- Add support for XML routes  [\#70](https://github.com/apache/camel-k/issues/70)
- Remove language configuration in kamel run [\#69](https://github.com/apache/camel-k/issues/69)
- Support for configmap and secrets [\#67](https://github.com/apache/camel-k/issues/67)
- Support for environment variables [\#65](https://github.com/apache/camel-k/issues/65)
- Support for properties [\#62](https://github.com/apache/camel-k/issues/62)
- Setup release scripts [\#59](https://github.com/apache/camel-k/issues/59)
- kamel install with sample [\#51](https://github.com/apache/camel-k/issues/51)
- Add "make install-minishift" command [\#42](https://github.com/apache/camel-k/issues/42)
- Add dev mode [\#34](https://github.com/apache/camel-k/issues/34)
- Add wait and log watch options [\#33](https://github.com/apache/camel-k/issues/33)
- Manage dependencies [\#30](https://github.com/apache/camel-k/issues/30)

**Merged pull requests:**

- Fix golint findings, remove unused code [\#103](https://github.com/apache/camel-k/pull/103) ([lburgazzoli](https://github.com/lburgazzoli))
- feat\(examples\): Add a Camel-caffeine Cache java sample [\#101](https://github.com/apache/camel-k/pull/101) ([oscerd](https://github.com/oscerd))
- Add delete integration option [\#100](https://github.com/apache/camel-k/pull/100) ([dmvolod](https://github.com/dmvolod))
- chore: refactor pkg/build to a more idiomatic structure [\#99](https://github.com/apache/camel-k/pull/99) ([lburgazzoli](https://github.com/lburgazzoli))
- Auto-discover dependencies [\#98](https://github.com/apache/camel-k/pull/98) ([nicolaferraro](https://github.com/nicolaferraro))
- Embed camel catalog [\#95](https://github.com/apache/camel-k/pull/95) ([lburgazzoli](https://github.com/lburgazzoli))
- Add sync and dev mode [\#92](https://github.com/apache/camel-k/pull/92) ([nicolaferraro](https://github.com/nicolaferraro))
- chore\(cobra\): add autocompletion for configmap and secrets [\#91](https://github.com/apache/camel-k/pull/91) ([lburgazzoli](https://github.com/lburgazzoli))
- Simplify install and update readme [\#88](https://github.com/apache/camel-k/pull/88) ([nicolaferraro](https://github.com/nicolaferraro))
- kamel install with sample [\#87](https://github.com/apache/camel-k/pull/87) ([dmvolod](https://github.com/dmvolod))
- Pod log implementation [\#86](https://github.com/apache/camel-k/pull/86) ([nicolaferraro](https://github.com/nicolaferraro))
- Added make install-minishift command to build [\#83](https://github.com/apache/camel-k/pull/83) ([oscerd](https://github.com/oscerd))
- Minot improvements to kamel client [\#81](https://github.com/apache/camel-k/pull/81) ([lburgazzoli](https://github.com/lburgazzoli))
- jvm: improve language detection [\#79](https://github.com/apache/camel-k/pull/79) ([lburgazzoli](https://github.com/lburgazzoli))
- Context handling improvement [\#76](https://github.com/apache/camel-k/pull/76) ([lburgazzoli](https://github.com/lburgazzoli))
- Add release commands and bump to 0.0.2-SNAPSHOT [\#72](https://github.com/apache/camel-k/pull/72) ([nicolaferraro](https://github.com/nicolaferraro))
- Add support for XML routes [\#71](https://github.com/apache/camel-k/pull/71) ([lburgazzoli](https://github.com/lburgazzoli))
- Support for integration configuration [\#68](https://github.com/apache/camel-k/pull/68) ([lburgazzoli](https://github.com/lburgazzoli))

## [0.0.1](https://github.com/apache/camel-k/tree/0.0.1) (2018-09-13)

[Full Changelog](https://github.com/apache/camel-k/compare/55fca8ee59ca67450bd114065872b0849917f132...0.0.1)

**Closed issues:**

- kamel run runtime/examples/Sample.java fails with java.lang.NoClassDefFoundError [\#57](https://github.com/apache/camel-k/issues/57)
- Store integration code in a configmap [\#54](https://github.com/apache/camel-k/issues/54)
- kamel run should support adding dependencies [\#49](https://github.com/apache/camel-k/issues/49)
- Route loaders should derive language from "kamel run --language" [\#46](https://github.com/apache/camel-k/issues/46)
- How to know a Component status at a time [\#44](https://github.com/apache/camel-k/issues/44)
- Unable to reinstall the operator [\#43](https://github.com/apache/camel-k/issues/43)
- Support set integration name for kamel run [\#40](https://github.com/apache/camel-k/issues/40)
- Allow buildless direct deploy [\#31](https://github.com/apache/camel-k/issues/31)

**Merged pull requests:**

- kamel run runtime/examples/Sample.java fails with java.lang.NoClassDefFoundError [\#64](https://github.com/apache/camel-k/pull/64) ([lburgazzoli](https://github.com/lburgazzoli))
-  Fix tests and add release scripts up to cross-compilation [\#63](https://github.com/apache/camel-k/pull/63) ([nicolaferraro](https://github.com/nicolaferraro))
- Allow buildless direct deploy [\#61](https://github.com/apache/camel-k/pull/61) ([lburgazzoli](https://github.com/lburgazzoli))
- Add a wait option to kamel run [\#56](https://github.com/apache/camel-k/pull/56) ([nicolaferraro](https://github.com/nicolaferraro))
- Store integration code in a configmap [\#55](https://github.com/apache/camel-k/pull/55) ([lburgazzoli](https://github.com/lburgazzoli))
- kamel run should support adding dependencies [\#53](https://github.com/apache/camel-k/pull/53) ([lburgazzoli](https://github.com/lburgazzoli))
- Unable to reinstall the operator fixes \#43 [\#50](https://github.com/apache/camel-k/pull/50) ([dmvolod](https://github.com/dmvolod))
- Support set integration name for kamel run [\#48](https://github.com/apache/camel-k/pull/48) ([oscerd](https://github.com/oscerd))
- Route loaders should derive language from 'kamel run --language' \#46 [\#47](https://github.com/apache/camel-k/pull/47) ([lburgazzoli](https://github.com/lburgazzoli))
- add support for non java integrations [\#39](https://github.com/apache/camel-k/pull/39) ([lburgazzoli](https://github.com/lburgazzoli))
-  Adding contributing guide [\#29](https://github.com/apache/camel-k/pull/29) ([nicolaferraro](https://github.com/nicolaferraro))
- Bump Camel to version 2.22.1 [\#28](https://github.com/apache/camel-k/pull/28) ([oscerd](https://github.com/oscerd))
- generate pom using go's xml encoder [\#27](https://github.com/apache/camel-k/pull/27) ([lburgazzoli](https://github.com/lburgazzoli))
- Fix typo in print integration context [\#26](https://github.com/apache/camel-k/pull/26) ([dmvolod](https://github.com/dmvolod))
- Changed log message in Sample.java in order to really rocks! [\#25](https://github.com/apache/camel-k/pull/25) ([valdar](https://github.com/valdar))
- initial code for integration context [\#24](https://github.com/apache/camel-k/pull/24) ([lburgazzoli](https://github.com/lburgazzoli))
- Add label to service [\#23](https://github.com/apache/camel-k/pull/23) ([dmvolod](https://github.com/dmvolod))
- CAMEL-12789: complete install command [\#22](https://github.com/apache/camel-k/pull/22) ([nicolaferraro](https://github.com/nicolaferraro))
- Add labels to all resources [\#21](https://github.com/apache/camel-k/pull/21) ([dmvolod](https://github.com/dmvolod))
- CAMEL-12798: Add getting started guide [\#20](https://github.com/apache/camel-k/pull/20) ([nicolaferraro](https://github.com/nicolaferraro))
- runtime: add support for groovy [\#19](https://github.com/apache/camel-k/pull/19) ([lburgazzoli](https://github.com/lburgazzoli))
- Installation and run works [\#18](https://github.com/apache/camel-k/pull/18) ([nicolaferraro](https://github.com/nicolaferraro))
- t code [\#17](https://github.com/apache/camel-k/pull/17) ([lburgazzoli](https://github.com/lburgazzoli))
- README update [\#16](https://github.com/apache/camel-k/pull/16) ([oscerd](https://github.com/oscerd))
- Dep version Readme [\#15](https://github.com/apache/camel-k/pull/15) ([oscerd](https://github.com/oscerd))
- add clean and dep target to Makefile [\#14](https://github.com/apache/camel-k/pull/14) ([lburgazzoli](https://github.com/lburgazzoli))
- Update readme fix typos [\#12](https://github.com/apache/camel-k/pull/12) ([onderson](https://github.com/onderson))
- Added build documentation. [\#11](https://github.com/apache/camel-k/pull/11) ([valdar](https://github.com/valdar))
- Use https instead of git for github.com/nicolaferraro/operator-sdk.git source [\#10](https://github.com/apache/camel-k/pull/10) ([dmvolod](https://github.com/dmvolod))
- Fix operator role to have lower privileges than the standard user and standardize command options [\#7](https://github.com/apache/camel-k/pull/7) ([nicolaferraro](https://github.com/nicolaferraro))
- Adding install and get commands [\#6](https://github.com/apache/camel-k/pull/6) ([nicolaferraro](https://github.com/nicolaferraro))
- Added Property placeholder for commons-lang3 version [\#5](https://github.com/apache/camel-k/pull/5) ([oscerd](https://github.com/oscerd))
- Minor refactor of client cmd [\#4](https://github.com/apache/camel-k/pull/4) ([lburgazzoli](https://github.com/lburgazzoli))
- swith to full in-memory java compiler and some minro cleanup [\#3](https://github.com/apache/camel-k/pull/3) ([lburgazzoli](https://github.com/lburgazzoli))
- Add bash completion [\#2](https://github.com/apache/camel-k/pull/2) ([lburgazzoli](https://github.com/lburgazzoli))
- Add support for .js, .java and classes [\#1](https://github.com/apache/camel-k/pull/1) ([lburgazzoli](https://github.com/lburgazzoli))



\* *This Changelog was automatically generated by [github_changelog_generator](https://github.com/github-changelog-generator/github-changelog-generator)*
