/*
Licensed to the Apache Software Foundation (ASF) under one or more
contributor license agreements.  See the NOTICE file distributed with
this work for additional information regarding copyright ownership.
The ASF licenses this file to You under the Apache License, Version 2.0
(the "License"); you may not use this file except in compliance with
the License.  You may obtain a copy of the License at

   http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

// Code generated by client-gen. DO NOT EDIT.

package v1

import (
	"context"
	json "encoding/json"
	"fmt"
	"time"

	v1 "github.com/apache/camel-k/pkg/apis/camel/v1"
	camelv1 "github.com/apache/camel-k/pkg/client/camel/applyconfiguration/camel/v1"
	scheme "github.com/apache/camel-k/pkg/client/camel/clientset/versioned/scheme"
	autoscalingv1 "k8s.io/api/autoscaling/v1"
	metav1 "k8s.io/apimachinery/pkg/apis/meta/v1"
	types "k8s.io/apimachinery/pkg/types"
	watch "k8s.io/apimachinery/pkg/watch"
	rest "k8s.io/client-go/rest"
)

// IntegrationsGetter has a method to return a IntegrationInterface.
// A group's client should implement this interface.
type IntegrationsGetter interface {
	Integrations(namespace string) IntegrationInterface
}

// IntegrationInterface has methods to work with Integration resources.
type IntegrationInterface interface {
	Create(ctx context.Context, integration *v1.Integration, opts metav1.CreateOptions) (*v1.Integration, error)
	Update(ctx context.Context, integration *v1.Integration, opts metav1.UpdateOptions) (*v1.Integration, error)
	UpdateStatus(ctx context.Context, integration *v1.Integration, opts metav1.UpdateOptions) (*v1.Integration, error)
	Delete(ctx context.Context, name string, opts metav1.DeleteOptions) error
	DeleteCollection(ctx context.Context, opts metav1.DeleteOptions, listOpts metav1.ListOptions) error
	Get(ctx context.Context, name string, opts metav1.GetOptions) (*v1.Integration, error)
	List(ctx context.Context, opts metav1.ListOptions) (*v1.IntegrationList, error)
	Watch(ctx context.Context, opts metav1.ListOptions) (watch.Interface, error)
	Patch(ctx context.Context, name string, pt types.PatchType, data []byte, opts metav1.PatchOptions, subresources ...string) (result *v1.Integration, err error)
	Apply(ctx context.Context, integration *camelv1.IntegrationApplyConfiguration, opts metav1.ApplyOptions) (result *v1.Integration, err error)
	ApplyStatus(ctx context.Context, integration *camelv1.IntegrationApplyConfiguration, opts metav1.ApplyOptions) (result *v1.Integration, err error)
	GetScale(ctx context.Context, integrationName string, options metav1.GetOptions) (*autoscalingv1.Scale, error)
	UpdateScale(ctx context.Context, integrationName string, scale *autoscalingv1.Scale, opts metav1.UpdateOptions) (*autoscalingv1.Scale, error)

	IntegrationExpansion
}

// integrations implements IntegrationInterface
type integrations struct {
	client rest.Interface
	ns     string
}

// newIntegrations returns a Integrations
func newIntegrations(c *CamelV1Client, namespace string) *integrations {
	return &integrations{
		client: c.RESTClient(),
		ns:     namespace,
	}
}

// Get takes name of the integration, and returns the corresponding integration object, and an error if there is any.
func (c *integrations) Get(ctx context.Context, name string, options metav1.GetOptions) (result *v1.Integration, err error) {
	result = &v1.Integration{}
	err = c.client.Get().
		Namespace(c.ns).
		Resource("integrations").
		Name(name).
		VersionedParams(&options, scheme.ParameterCodec).
		Do(ctx).
		Into(result)
	return
}

// List takes label and field selectors, and returns the list of Integrations that match those selectors.
func (c *integrations) List(ctx context.Context, opts metav1.ListOptions) (result *v1.IntegrationList, err error) {
	var timeout time.Duration
	if opts.TimeoutSeconds != nil {
		timeout = time.Duration(*opts.TimeoutSeconds) * time.Second
	}
	result = &v1.IntegrationList{}
	err = c.client.Get().
		Namespace(c.ns).
		Resource("integrations").
		VersionedParams(&opts, scheme.ParameterCodec).
		Timeout(timeout).
		Do(ctx).
		Into(result)
	return
}

// Watch returns a watch.Interface that watches the requested integrations.
func (c *integrations) Watch(ctx context.Context, opts metav1.ListOptions) (watch.Interface, error) {
	var timeout time.Duration
	if opts.TimeoutSeconds != nil {
		timeout = time.Duration(*opts.TimeoutSeconds) * time.Second
	}
	opts.Watch = true
	return c.client.Get().
		Namespace(c.ns).
		Resource("integrations").
		VersionedParams(&opts, scheme.ParameterCodec).
		Timeout(timeout).
		Watch(ctx)
}

// Create takes the representation of a integration and creates it.  Returns the server's representation of the integration, and an error, if there is any.
func (c *integrations) Create(ctx context.Context, integration *v1.Integration, opts metav1.CreateOptions) (result *v1.Integration, err error) {
	result = &v1.Integration{}
	err = c.client.Post().
		Namespace(c.ns).
		Resource("integrations").
		VersionedParams(&opts, scheme.ParameterCodec).
		Body(integration).
		Do(ctx).
		Into(result)
	return
}

// Update takes the representation of a integration and updates it. Returns the server's representation of the integration, and an error, if there is any.
func (c *integrations) Update(ctx context.Context, integration *v1.Integration, opts metav1.UpdateOptions) (result *v1.Integration, err error) {
	result = &v1.Integration{}
	err = c.client.Put().
		Namespace(c.ns).
		Resource("integrations").
		Name(integration.Name).
		VersionedParams(&opts, scheme.ParameterCodec).
		Body(integration).
		Do(ctx).
		Into(result)
	return
}

// UpdateStatus was generated because the type contains a Status member.
// Add a +genclient:noStatus comment above the type to avoid generating UpdateStatus().
func (c *integrations) UpdateStatus(ctx context.Context, integration *v1.Integration, opts metav1.UpdateOptions) (result *v1.Integration, err error) {
	result = &v1.Integration{}
	err = c.client.Put().
		Namespace(c.ns).
		Resource("integrations").
		Name(integration.Name).
		SubResource("status").
		VersionedParams(&opts, scheme.ParameterCodec).
		Body(integration).
		Do(ctx).
		Into(result)
	return
}

// Delete takes name of the integration and deletes it. Returns an error if one occurs.
func (c *integrations) Delete(ctx context.Context, name string, opts metav1.DeleteOptions) error {
	return c.client.Delete().
		Namespace(c.ns).
		Resource("integrations").
		Name(name).
		Body(&opts).
		Do(ctx).
		Error()
}

// DeleteCollection deletes a collection of objects.
func (c *integrations) DeleteCollection(ctx context.Context, opts metav1.DeleteOptions, listOpts metav1.ListOptions) error {
	var timeout time.Duration
	if listOpts.TimeoutSeconds != nil {
		timeout = time.Duration(*listOpts.TimeoutSeconds) * time.Second
	}
	return c.client.Delete().
		Namespace(c.ns).
		Resource("integrations").
		VersionedParams(&listOpts, scheme.ParameterCodec).
		Timeout(timeout).
		Body(&opts).
		Do(ctx).
		Error()
}

// Patch applies the patch and returns the patched integration.
func (c *integrations) Patch(ctx context.Context, name string, pt types.PatchType, data []byte, opts metav1.PatchOptions, subresources ...string) (result *v1.Integration, err error) {
	result = &v1.Integration{}
	err = c.client.Patch(pt).
		Namespace(c.ns).
		Resource("integrations").
		Name(name).
		SubResource(subresources...).
		VersionedParams(&opts, scheme.ParameterCodec).
		Body(data).
		Do(ctx).
		Into(result)
	return
}

// Apply takes the given apply declarative configuration, applies it and returns the applied integration.
func (c *integrations) Apply(ctx context.Context, integration *camelv1.IntegrationApplyConfiguration, opts metav1.ApplyOptions) (result *v1.Integration, err error) {
	if integration == nil {
		return nil, fmt.Errorf("integration provided to Apply must not be nil")
	}
	patchOpts := opts.ToPatchOptions()
	data, err := json.Marshal(integration)
	if err != nil {
		return nil, err
	}
	name := integration.Name
	if name == nil {
		return nil, fmt.Errorf("integration.Name must be provided to Apply")
	}
	result = &v1.Integration{}
	err = c.client.Patch(types.ApplyPatchType).
		Namespace(c.ns).
		Resource("integrations").
		Name(*name).
		VersionedParams(&patchOpts, scheme.ParameterCodec).
		Body(data).
		Do(ctx).
		Into(result)
	return
}

// ApplyStatus was generated because the type contains a Status member.
// Add a +genclient:noStatus comment above the type to avoid generating ApplyStatus().
func (c *integrations) ApplyStatus(ctx context.Context, integration *camelv1.IntegrationApplyConfiguration, opts metav1.ApplyOptions) (result *v1.Integration, err error) {
	if integration == nil {
		return nil, fmt.Errorf("integration provided to Apply must not be nil")
	}
	patchOpts := opts.ToPatchOptions()
	data, err := json.Marshal(integration)
	if err != nil {
		return nil, err
	}

	name := integration.Name
	if name == nil {
		return nil, fmt.Errorf("integration.Name must be provided to Apply")
	}

	result = &v1.Integration{}
	err = c.client.Patch(types.ApplyPatchType).
		Namespace(c.ns).
		Resource("integrations").
		Name(*name).
		SubResource("status").
		VersionedParams(&patchOpts, scheme.ParameterCodec).
		Body(data).
		Do(ctx).
		Into(result)
	return
}

// GetScale takes name of the integration, and returns the corresponding autoscalingv1.Scale object, and an error if there is any.
func (c *integrations) GetScale(ctx context.Context, integrationName string, options metav1.GetOptions) (result *autoscalingv1.Scale, err error) {
	result = &autoscalingv1.Scale{}
	err = c.client.Get().
		Namespace(c.ns).
		Resource("integrations").
		Name(integrationName).
		SubResource("scale").
		VersionedParams(&options, scheme.ParameterCodec).
		Do(ctx).
		Into(result)
	return
}

// UpdateScale takes the top resource name and the representation of a scale and updates it. Returns the server's representation of the scale, and an error, if there is any.
func (c *integrations) UpdateScale(ctx context.Context, integrationName string, scale *autoscalingv1.Scale, opts metav1.UpdateOptions) (result *autoscalingv1.Scale, err error) {
	result = &autoscalingv1.Scale{}
	err = c.client.Put().
		Namespace(c.ns).
		Resource("integrations").
		Name(integrationName).
		SubResource("scale").
		VersionedParams(&opts, scheme.ParameterCodec).
		Body(scale).
		Do(ctx).
		Into(result)
	return
}
