/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.v1alpha1.kameletbindingspec.integration.traits;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import io.fabric8.kubernetes.api.model.KubernetesResource;
import org.apache.camel.v1alpha1.kameletbindingspec.integration.traits.cron.Configuration;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonPropertyOrder(value={"activeDeadlineSeconds", "auto", "backoffLimit", "components", "concurrencyPolicy", "configuration", "enabled", "fallback", "schedule", "startingDeadlineSeconds"})
@JsonDeserialize(using=JsonDeserializer.None.class)
public class Cron
implements KubernetesResource {
    @JsonProperty(value="activeDeadlineSeconds")
    @JsonPropertyDescription(value="Specifies the duration in seconds, relative to the start time, that the job may be continuously active before it is considered to be failed. It defaults to 60s.")
    @JsonSetter(nulls=Nulls.SKIP)
    private Long activeDeadlineSeconds;
    @JsonProperty(value="auto")
    @JsonPropertyDescription(value="Automatically deploy the integration as CronJob when all routes are either starting from a periodic consumer (only `cron`, `timer` and `quartz` are supported) or a passive consumer (e.g. `direct` is a passive consumer). \n It's required that all periodic consumers have the same period, and it can be expressed as cron schedule (e.g. `1m` can be expressed as `0/1 * * * *`, while `35m` or `50s` cannot).")
    @JsonSetter(nulls=Nulls.SKIP)
    private Boolean auto;
    @JsonProperty(value="backoffLimit")
    @JsonPropertyDescription(value="Specifies the number of retries before marking the job failed. It defaults to 2.")
    @JsonSetter(nulls=Nulls.SKIP)
    private Integer backoffLimit;
    @JsonProperty(value="components")
    @JsonPropertyDescription(value="A comma separated list of the Camel components that need to be customized in order for them to work when the schedule is triggered externally by Kubernetes. A specific customizer is activated for each specified component. E.g. for the `timer` component, the `cron-timer` customizer is activated (it's present in the `org.apache.camel.k:camel-k-cron` library). \n Supported components are currently: `cron`, `timer` and `quartz`.")
    @JsonSetter(nulls=Nulls.SKIP)
    private String components;
    @JsonProperty(value="concurrencyPolicy")
    @JsonPropertyDescription(value="Specifies how to treat concurrent executions of a Job. Valid values are: - \"Allow\": allows CronJobs to run concurrently; - \"Forbid\" (default): forbids concurrent runs, skipping next run if previous run hasn't finished yet; - \"Replace\": cancels currently running job and replaces it with a new one")
    @JsonSetter(nulls=Nulls.SKIP)
    private ConcurrencyPolicy concurrencyPolicy;
    @JsonProperty(value="configuration")
    @JsonPropertyDescription(value="Legacy trait configuration parameters. Deprecated: for backward compatibility.")
    @JsonSetter(nulls=Nulls.SKIP)
    private Configuration configuration;
    @JsonProperty(value="enabled")
    @JsonPropertyDescription(value="Can be used to enable or disable a trait. All traits share this common property.")
    @JsonSetter(nulls=Nulls.SKIP)
    private Boolean enabled;
    @JsonProperty(value="fallback")
    @JsonPropertyDescription(value="Use the default Camel implementation of the `cron` endpoint (`quartz`) instead of trying to materialize the integration as Kubernetes CronJob.")
    @JsonSetter(nulls=Nulls.SKIP)
    private Boolean fallback;
    @JsonProperty(value="schedule")
    @JsonPropertyDescription(value="The CronJob schedule for the whole integration. If multiple routes are declared, they must have the same schedule for this mechanism to work correctly.")
    @JsonSetter(nulls=Nulls.SKIP)
    private String schedule;
    @JsonProperty(value="startingDeadlineSeconds")
    @JsonPropertyDescription(value="Optional deadline in seconds for starting the job if it misses scheduled time for any reason.  Missed jobs executions will be counted as failed ones.")
    @JsonSetter(nulls=Nulls.SKIP)
    private Long startingDeadlineSeconds;

    public Long getActiveDeadlineSeconds() {
        return this.activeDeadlineSeconds;
    }

    public void setActiveDeadlineSeconds(Long activeDeadlineSeconds) {
        this.activeDeadlineSeconds = activeDeadlineSeconds;
    }

    public Boolean getAuto() {
        return this.auto;
    }

    public void setAuto(Boolean auto) {
        this.auto = auto;
    }

    public Integer getBackoffLimit() {
        return this.backoffLimit;
    }

    public void setBackoffLimit(Integer backoffLimit) {
        this.backoffLimit = backoffLimit;
    }

    public String getComponents() {
        return this.components;
    }

    public void setComponents(String components) {
        this.components = components;
    }

    public ConcurrencyPolicy getConcurrencyPolicy() {
        return this.concurrencyPolicy;
    }

    public void setConcurrencyPolicy(ConcurrencyPolicy concurrencyPolicy) {
        this.concurrencyPolicy = concurrencyPolicy;
    }

    public Configuration getConfiguration() {
        return this.configuration;
    }

    public void setConfiguration(Configuration configuration) {
        this.configuration = configuration;
    }

    public Boolean getEnabled() {
        return this.enabled;
    }

    public void setEnabled(Boolean enabled) {
        this.enabled = enabled;
    }

    public Boolean getFallback() {
        return this.fallback;
    }

    public void setFallback(Boolean fallback) {
        this.fallback = fallback;
    }

    public String getSchedule() {
        return this.schedule;
    }

    public void setSchedule(String schedule) {
        this.schedule = schedule;
    }

    public Long getStartingDeadlineSeconds() {
        return this.startingDeadlineSeconds;
    }

    public void setStartingDeadlineSeconds(Long startingDeadlineSeconds) {
        this.startingDeadlineSeconds = startingDeadlineSeconds;
    }

    public static enum ConcurrencyPolicy {
        ALLOW("Allow"),
        FORBID("Forbid"),
        REPLACE("Replace");

        String value;

        private ConcurrencyPolicy(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }
    }
}

