/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.v1.integrationspec.template.spec.volumes;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import io.fabric8.generator.annotation.Required;
import io.fabric8.kubernetes.api.model.KubernetesResource;
import org.apache.camel.v1.integrationspec.template.spec.volumes.scaleio.SecretRef;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonPropertyOrder(value={"fsType", "gateway", "protectionDomain", "readOnly", "secretRef", "sslEnabled", "storageMode", "storagePool", "system", "volumeName"})
@JsonDeserialize(using=JsonDeserializer.None.class)
public class ScaleIO
implements KubernetesResource {
    @JsonProperty(value="fsType")
    @JsonPropertyDescription(value="fsType is the filesystem type to mount. Must be a filesystem type supported by the host operating system. Ex. \"ext4\", \"xfs\", \"ntfs\". Default is \"xfs\".")
    @JsonSetter(nulls=Nulls.SKIP)
    private String fsType;
    @JsonProperty(value="gateway")
    @Required
    @JsonPropertyDescription(value="gateway is the host address of the ScaleIO API Gateway.")
    @JsonSetter(nulls=Nulls.SKIP)
    private String gateway;
    @JsonProperty(value="protectionDomain")
    @JsonPropertyDescription(value="protectionDomain is the name of the ScaleIO Protection Domain for the configured storage.")
    @JsonSetter(nulls=Nulls.SKIP)
    private String protectionDomain;
    @JsonProperty(value="readOnly")
    @JsonPropertyDescription(value="readOnly Defaults to false (read/write). ReadOnly here will force the ReadOnly setting in VolumeMounts.")
    @JsonSetter(nulls=Nulls.SKIP)
    private Boolean readOnly;
    @JsonProperty(value="secretRef")
    @Required
    @JsonPropertyDescription(value="secretRef references to the secret for ScaleIO user and other sensitive information. If this is not provided, Login operation will fail.")
    @JsonSetter(nulls=Nulls.SKIP)
    private SecretRef secretRef;
    @JsonProperty(value="sslEnabled")
    @JsonPropertyDescription(value="sslEnabled Flag enable/disable SSL communication with Gateway, default false")
    @JsonSetter(nulls=Nulls.SKIP)
    private Boolean sslEnabled;
    @JsonProperty(value="storageMode")
    @JsonPropertyDescription(value="storageMode indicates whether the storage for a volume should be ThickProvisioned or ThinProvisioned. Default is ThinProvisioned.")
    @JsonSetter(nulls=Nulls.SKIP)
    private String storageMode;
    @JsonProperty(value="storagePool")
    @JsonPropertyDescription(value="storagePool is the ScaleIO Storage Pool associated with the protection domain.")
    @JsonSetter(nulls=Nulls.SKIP)
    private String storagePool;
    @JsonProperty(value="system")
    @Required
    @JsonPropertyDescription(value="system is the name of the storage system as configured in ScaleIO.")
    @JsonSetter(nulls=Nulls.SKIP)
    private String system;
    @JsonProperty(value="volumeName")
    @JsonPropertyDescription(value="volumeName is the name of a volume already created in the ScaleIO system that is associated with this volume source.")
    @JsonSetter(nulls=Nulls.SKIP)
    private String volumeName;

    public String getFsType() {
        return this.fsType;
    }

    public void setFsType(String fsType) {
        this.fsType = fsType;
    }

    public String getGateway() {
        return this.gateway;
    }

    public void setGateway(String gateway) {
        this.gateway = gateway;
    }

    public String getProtectionDomain() {
        return this.protectionDomain;
    }

    public void setProtectionDomain(String protectionDomain) {
        this.protectionDomain = protectionDomain;
    }

    public Boolean getReadOnly() {
        return this.readOnly;
    }

    public void setReadOnly(Boolean readOnly) {
        this.readOnly = readOnly;
    }

    public SecretRef getSecretRef() {
        return this.secretRef;
    }

    public void setSecretRef(SecretRef secretRef) {
        this.secretRef = secretRef;
    }

    public Boolean getSslEnabled() {
        return this.sslEnabled;
    }

    public void setSslEnabled(Boolean sslEnabled) {
        this.sslEnabled = sslEnabled;
    }

    public String getStorageMode() {
        return this.storageMode;
    }

    public void setStorageMode(String storageMode) {
        this.storageMode = storageMode;
    }

    public String getStoragePool() {
        return this.storagePool;
    }

    public void setStoragePool(String storagePool) {
        this.storagePool = storagePool;
    }

    public String getSystem() {
        return this.system;
    }

    public void setSystem(String system) {
        this.system = system;
    }

    public String getVolumeName() {
        return this.volumeName;
    }

    public void setVolumeName(String volumeName) {
        this.volumeName = volumeName;
    }
}

