/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.v1.integrationplatformspec.build;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import io.fabric8.kubernetes.api.model.KubernetesResource;
import java.util.List;
import java.util.Map;
import org.apache.camel.v1.integrationplatformspec.build.maven.CaSecrets;
import org.apache.camel.v1.integrationplatformspec.build.maven.Extension;
import org.apache.camel.v1.integrationplatformspec.build.maven.Settings;
import org.apache.camel.v1.integrationplatformspec.build.maven.SettingsSecurity;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonPropertyOrder(value={"caSecrets", "cliOptions", "extension", "localRepository", "properties", "settings", "settingsSecurity"})
@JsonDeserialize(using=JsonDeserializer.None.class)
public class Maven
implements KubernetesResource {
    @JsonProperty(value="caSecrets")
    @JsonPropertyDescription(value="The Secrets name and key, containing the CA certificate(s) used to connect to remote Maven repositories. It can contain X.509 certificates, and PKCS#7 formatted certificate chains. A JKS formatted keystore is automatically created to store the CA certificate(s), and configured to be used as a trusted certificate(s) by the Maven commands. Note that the root CA certificates are also imported into the created keystore.")
    @JsonSetter(nulls=Nulls.SKIP)
    private List<CaSecrets> caSecrets;
    @JsonProperty(value="cliOptions")
    @JsonPropertyDescription(value="The CLI options that are appended to the list of arguments for Maven commands, e.g., `-V,--no-transfer-progress,-Dstyle.color=never`. See https://maven.apache.org/ref/3.8.4/maven-embedder/cli.html.")
    @JsonSetter(nulls=Nulls.SKIP)
    private List<String> cliOptions;
    @JsonProperty(value="extension")
    @JsonPropertyDescription(value="The Maven build extensions. See https://maven.apache.org/guides/mini/guide-using-extensions.html.")
    @JsonSetter(nulls=Nulls.SKIP)
    private List<Extension> extension;
    @JsonProperty(value="localRepository")
    @JsonPropertyDescription(value="The path of the local Maven repository.")
    @JsonSetter(nulls=Nulls.SKIP)
    private String localRepository;
    @JsonProperty(value="properties")
    @JsonPropertyDescription(value="The Maven properties.")
    @JsonSetter(nulls=Nulls.SKIP)
    private Map<String, String> properties;
    @JsonProperty(value="settings")
    @JsonPropertyDescription(value="A reference to the ConfigMap or Secret key that contains the Maven settings.")
    @JsonSetter(nulls=Nulls.SKIP)
    private Settings settings;
    @JsonProperty(value="settingsSecurity")
    @JsonPropertyDescription(value="A reference to the ConfigMap or Secret key that contains the security of the Maven settings.")
    @JsonSetter(nulls=Nulls.SKIP)
    private SettingsSecurity settingsSecurity;

    public List<CaSecrets> getCaSecrets() {
        return this.caSecrets;
    }

    public void setCaSecrets(List<CaSecrets> caSecrets) {
        this.caSecrets = caSecrets;
    }

    public List<String> getCliOptions() {
        return this.cliOptions;
    }

    public void setCliOptions(List<String> cliOptions) {
        this.cliOptions = cliOptions;
    }

    public List<Extension> getExtension() {
        return this.extension;
    }

    public void setExtension(List<Extension> extension) {
        this.extension = extension;
    }

    public String getLocalRepository() {
        return this.localRepository;
    }

    public void setLocalRepository(String localRepository) {
        this.localRepository = localRepository;
    }

    public Map<String, String> getProperties() {
        return this.properties;
    }

    public void setProperties(Map<String, String> properties) {
        this.properties = properties;
    }

    public Settings getSettings() {
        return this.settings;
    }

    public void setSettings(Settings settings) {
        this.settings = settings;
    }

    public SettingsSecurity getSettingsSecurity() {
        return this.settingsSecurity;
    }

    public void setSettingsSecurity(SettingsSecurity settingsSecurity) {
        this.settingsSecurity = settingsSecurity;
    }
}

