/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.v1;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import io.fabric8.kubernetes.api.model.KubernetesResource;
import java.util.List;
import java.util.Map;
import org.apache.camel.v1.integrationplatformstatus.Build;
import org.apache.camel.v1.integrationplatformstatus.Conditions;
import org.apache.camel.v1.integrationplatformstatus.Configuration;
import org.apache.camel.v1.integrationplatformstatus.Kamelet;
import org.apache.camel.v1.integrationplatformstatus.Traits;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonPropertyOrder(value={"build", "cluster", "conditions", "configuration", "info", "kamelet", "observedGeneration", "phase", "profile", "traits", "version"})
@JsonDeserialize(using=JsonDeserializer.None.class)
public class IntegrationPlatformStatus
implements KubernetesResource {
    @JsonProperty(value="build")
    @JsonPropertyDescription(value="specify how to build the Integration/IntegrationKits")
    @JsonSetter(nulls=Nulls.SKIP)
    private Build build;
    @JsonProperty(value="cluster")
    @JsonPropertyDescription(value="what kind of cluster you're running (ie, plain Kubernetes or OpenShift)")
    @JsonSetter(nulls=Nulls.SKIP)
    private String cluster;
    @JsonProperty(value="conditions")
    @JsonPropertyDescription(value="which are the conditions met (particularly useful when in ERROR phase)")
    @JsonSetter(nulls=Nulls.SKIP)
    private List<Conditions> conditions;
    @JsonProperty(value="configuration")
    @JsonPropertyDescription(value="Deprecated: Use camel trait (camel.properties) to manage properties Use mount trait (mount.configs) to manage configs Use mount trait (mount.resources) to manage resources Use mount trait (mount.volumes) to manage volumes list of configuration properties to be attached to all the Integration/IntegrationKits built from this IntegrationPlatform")
    @JsonSetter(nulls=Nulls.SKIP)
    private List<Configuration> configuration;
    @JsonProperty(value="info")
    @JsonPropertyDescription(value="generic information related to the build of Camel K operator software")
    @JsonSetter(nulls=Nulls.SKIP)
    private Map<String, String> info;
    @JsonProperty(value="kamelet")
    @JsonPropertyDescription(value="configuration to be executed to all Kamelets controlled by this IntegrationPlatform")
    @JsonSetter(nulls=Nulls.SKIP)
    private Kamelet kamelet;
    @JsonProperty(value="observedGeneration")
    @JsonPropertyDescription(value="ObservedGeneration is the most recent generation observed for this IntegrationPlatform.")
    @JsonSetter(nulls=Nulls.SKIP)
    private Long observedGeneration;
    @JsonProperty(value="phase")
    @JsonPropertyDescription(value="defines in what phase the IntegrationPlatform is found")
    @JsonSetter(nulls=Nulls.SKIP)
    private String phase;
    @JsonProperty(value="profile")
    @JsonPropertyDescription(value="the profile you wish to use. It will apply certain traits which are required by the specific profile chosen. It usually relates the Cluster with the optional definition of special profiles (ie, Knative)")
    @JsonSetter(nulls=Nulls.SKIP)
    private String profile;
    @JsonProperty(value="traits")
    @JsonPropertyDescription(value="list of traits to be executed for all the Integration/IntegrationKits built from this IntegrationPlatform")
    @JsonSetter(nulls=Nulls.SKIP)
    private Traits traits;
    @JsonProperty(value="version")
    @JsonPropertyDescription(value="the Camel K operator version controlling this IntegrationPlatform")
    @JsonSetter(nulls=Nulls.SKIP)
    private String version;

    public Build getBuild() {
        return this.build;
    }

    public void setBuild(Build build) {
        this.build = build;
    }

    public String getCluster() {
        return this.cluster;
    }

    public void setCluster(String cluster) {
        this.cluster = cluster;
    }

    public List<Conditions> getConditions() {
        return this.conditions;
    }

    public void setConditions(List<Conditions> conditions) {
        this.conditions = conditions;
    }

    public List<Configuration> getConfiguration() {
        return this.configuration;
    }

    public void setConfiguration(List<Configuration> configuration) {
        this.configuration = configuration;
    }

    public Map<String, String> getInfo() {
        return this.info;
    }

    public void setInfo(Map<String, String> info) {
        this.info = info;
    }

    public Kamelet getKamelet() {
        return this.kamelet;
    }

    public void setKamelet(Kamelet kamelet) {
        this.kamelet = kamelet;
    }

    public Long getObservedGeneration() {
        return this.observedGeneration;
    }

    public void setObservedGeneration(Long observedGeneration) {
        this.observedGeneration = observedGeneration;
    }

    public String getPhase() {
        return this.phase;
    }

    public void setPhase(String phase) {
        this.phase = phase;
    }

    public String getProfile() {
        return this.profile;
    }

    public void setProfile(String profile) {
        this.profile = profile;
    }

    public Traits getTraits() {
        return this.traits;
    }

    public void setTraits(Traits traits) {
        this.traits = traits;
    }

    public String getVersion() {
        return this.version;
    }

    public void setVersion(String version) {
        this.version = version;
    }
}

