/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.v1;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import io.fabric8.kubernetes.api.model.KubernetesResource;
import java.util.List;
import org.apache.camel.v1.buildspec.Tasks;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonPropertyOrder(value={"maxRunningBuilds", "strategy", "tasks", "timeout"})
@JsonDeserialize(using=JsonDeserializer.None.class)
public class BuildSpec
implements KubernetesResource {
    @JsonProperty(value="maxRunningBuilds")
    @JsonPropertyDescription(value="the maximum amount of parallel running builds started by this operator instance")
    @JsonSetter(nulls=Nulls.SKIP)
    private Integer maxRunningBuilds;
    @JsonProperty(value="strategy")
    @JsonPropertyDescription(value="The strategy that should be used to perform the Build.")
    @JsonSetter(nulls=Nulls.SKIP)
    private Strategy strategy;
    @JsonProperty(value="tasks")
    @JsonPropertyDescription(value="The sequence of Build tasks to be performed as part of the Build execution.")
    @JsonSetter(nulls=Nulls.SKIP)
    private List<Tasks> tasks;
    @JsonProperty(value="timeout")
    @JsonPropertyDescription(value="Timeout defines the Build maximum execution duration. The Build deadline is set to the Build start time plus the Timeout duration. If the Build deadline is exceeded, the Build context is canceled, and its phase set to BuildPhaseFailed.")
    @JsonSetter(nulls=Nulls.SKIP)
    private String timeout;

    public Integer getMaxRunningBuilds() {
        return this.maxRunningBuilds;
    }

    public void setMaxRunningBuilds(Integer maxRunningBuilds) {
        this.maxRunningBuilds = maxRunningBuilds;
    }

    public Strategy getStrategy() {
        return this.strategy;
    }

    public void setStrategy(Strategy strategy) {
        this.strategy = strategy;
    }

    public List<Tasks> getTasks() {
        return this.tasks;
    }

    public void setTasks(List<Tasks> tasks) {
        this.tasks = tasks;
    }

    public String getTimeout() {
        return this.timeout;
    }

    public void setTimeout(String timeout) {
        this.timeout = timeout;
    }

    public static enum Strategy {
        ROUTINE("routine"),
        POD("pod");

        String value;

        private Strategy(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }
    }
}

