/*
Licensed to the Apache Software Foundation (ASF) under one or more
contributor license agreements.  See the NOTICE file distributed with
this work for additional information regarding copyright ownership.
The ASF licenses this file to You under the Apache License, Version 2.0
(the "License"); you may not use this file except in compliance with
the License.  You may obtain a copy of the License at

   http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

// Code generated by client-gen. DO NOT EDIT.

package fake

import (
	"context"
	json "encoding/json"
	"fmt"

	camelv1 "github.com/apache/camel-k/pkg/apis/camel/v1"
	applyconfigurationcamelv1 "github.com/apache/camel-k/pkg/client/camel/applyconfiguration/camel/v1"
	v1 "k8s.io/apimachinery/pkg/apis/meta/v1"
	labels "k8s.io/apimachinery/pkg/labels"
	schema "k8s.io/apimachinery/pkg/runtime/schema"
	types "k8s.io/apimachinery/pkg/types"
	watch "k8s.io/apimachinery/pkg/watch"
	testing "k8s.io/client-go/testing"
)

// FakeCamelCatalogs implements CamelCatalogInterface
type FakeCamelCatalogs struct {
	Fake *FakeCamelV1
	ns   string
}

var camelcatalogsResource = schema.GroupVersionResource{Group: "camel.apache.org", Version: "v1", Resource: "camelcatalogs"}

var camelcatalogsKind = schema.GroupVersionKind{Group: "camel.apache.org", Version: "v1", Kind: "CamelCatalog"}

// Get takes name of the camelCatalog, and returns the corresponding camelCatalog object, and an error if there is any.
func (c *FakeCamelCatalogs) Get(ctx context.Context, name string, options v1.GetOptions) (result *camelv1.CamelCatalog, err error) {
	obj, err := c.Fake.
		Invokes(testing.NewGetAction(camelcatalogsResource, c.ns, name), &camelv1.CamelCatalog{})

	if obj == nil {
		return nil, err
	}
	return obj.(*camelv1.CamelCatalog), err
}

// List takes label and field selectors, and returns the list of CamelCatalogs that match those selectors.
func (c *FakeCamelCatalogs) List(ctx context.Context, opts v1.ListOptions) (result *camelv1.CamelCatalogList, err error) {
	obj, err := c.Fake.
		Invokes(testing.NewListAction(camelcatalogsResource, camelcatalogsKind, c.ns, opts), &camelv1.CamelCatalogList{})

	if obj == nil {
		return nil, err
	}

	label, _, _ := testing.ExtractFromListOptions(opts)
	if label == nil {
		label = labels.Everything()
	}
	list := &camelv1.CamelCatalogList{ListMeta: obj.(*camelv1.CamelCatalogList).ListMeta}
	for _, item := range obj.(*camelv1.CamelCatalogList).Items {
		if label.Matches(labels.Set(item.Labels)) {
			list.Items = append(list.Items, item)
		}
	}
	return list, err
}

// Watch returns a watch.Interface that watches the requested camelCatalogs.
func (c *FakeCamelCatalogs) Watch(ctx context.Context, opts v1.ListOptions) (watch.Interface, error) {
	return c.Fake.
		InvokesWatch(testing.NewWatchAction(camelcatalogsResource, c.ns, opts))

}

// Create takes the representation of a camelCatalog and creates it.  Returns the server's representation of the camelCatalog, and an error, if there is any.
func (c *FakeCamelCatalogs) Create(ctx context.Context, camelCatalog *camelv1.CamelCatalog, opts v1.CreateOptions) (result *camelv1.CamelCatalog, err error) {
	obj, err := c.Fake.
		Invokes(testing.NewCreateAction(camelcatalogsResource, c.ns, camelCatalog), &camelv1.CamelCatalog{})

	if obj == nil {
		return nil, err
	}
	return obj.(*camelv1.CamelCatalog), err
}

// Update takes the representation of a camelCatalog and updates it. Returns the server's representation of the camelCatalog, and an error, if there is any.
func (c *FakeCamelCatalogs) Update(ctx context.Context, camelCatalog *camelv1.CamelCatalog, opts v1.UpdateOptions) (result *camelv1.CamelCatalog, err error) {
	obj, err := c.Fake.
		Invokes(testing.NewUpdateAction(camelcatalogsResource, c.ns, camelCatalog), &camelv1.CamelCatalog{})

	if obj == nil {
		return nil, err
	}
	return obj.(*camelv1.CamelCatalog), err
}

// UpdateStatus was generated because the type contains a Status member.
// Add a +genclient:noStatus comment above the type to avoid generating UpdateStatus().
func (c *FakeCamelCatalogs) UpdateStatus(ctx context.Context, camelCatalog *camelv1.CamelCatalog, opts v1.UpdateOptions) (*camelv1.CamelCatalog, error) {
	obj, err := c.Fake.
		Invokes(testing.NewUpdateSubresourceAction(camelcatalogsResource, "status", c.ns, camelCatalog), &camelv1.CamelCatalog{})

	if obj == nil {
		return nil, err
	}
	return obj.(*camelv1.CamelCatalog), err
}

// Delete takes name of the camelCatalog and deletes it. Returns an error if one occurs.
func (c *FakeCamelCatalogs) Delete(ctx context.Context, name string, opts v1.DeleteOptions) error {
	_, err := c.Fake.
		Invokes(testing.NewDeleteActionWithOptions(camelcatalogsResource, c.ns, name, opts), &camelv1.CamelCatalog{})

	return err
}

// DeleteCollection deletes a collection of objects.
func (c *FakeCamelCatalogs) DeleteCollection(ctx context.Context, opts v1.DeleteOptions, listOpts v1.ListOptions) error {
	action := testing.NewDeleteCollectionAction(camelcatalogsResource, c.ns, listOpts)

	_, err := c.Fake.Invokes(action, &camelv1.CamelCatalogList{})
	return err
}

// Patch applies the patch and returns the patched camelCatalog.
func (c *FakeCamelCatalogs) Patch(ctx context.Context, name string, pt types.PatchType, data []byte, opts v1.PatchOptions, subresources ...string) (result *camelv1.CamelCatalog, err error) {
	obj, err := c.Fake.
		Invokes(testing.NewPatchSubresourceAction(camelcatalogsResource, c.ns, name, pt, data, subresources...), &camelv1.CamelCatalog{})

	if obj == nil {
		return nil, err
	}
	return obj.(*camelv1.CamelCatalog), err
}

// Apply takes the given apply declarative configuration, applies it and returns the applied camelCatalog.
func (c *FakeCamelCatalogs) Apply(ctx context.Context, camelCatalog *applyconfigurationcamelv1.CamelCatalogApplyConfiguration, opts v1.ApplyOptions) (result *camelv1.CamelCatalog, err error) {
	if camelCatalog == nil {
		return nil, fmt.Errorf("camelCatalog provided to Apply must not be nil")
	}
	data, err := json.Marshal(camelCatalog)
	if err != nil {
		return nil, err
	}
	name := camelCatalog.Name
	if name == nil {
		return nil, fmt.Errorf("camelCatalog.Name must be provided to Apply")
	}
	obj, err := c.Fake.
		Invokes(testing.NewPatchSubresourceAction(camelcatalogsResource, c.ns, *name, types.ApplyPatchType, data), &camelv1.CamelCatalog{})

	if obj == nil {
		return nil, err
	}
	return obj.(*camelv1.CamelCatalog), err
}

// ApplyStatus was generated because the type contains a Status member.
// Add a +genclient:noStatus comment above the type to avoid generating ApplyStatus().
func (c *FakeCamelCatalogs) ApplyStatus(ctx context.Context, camelCatalog *applyconfigurationcamelv1.CamelCatalogApplyConfiguration, opts v1.ApplyOptions) (result *camelv1.CamelCatalog, err error) {
	if camelCatalog == nil {
		return nil, fmt.Errorf("camelCatalog provided to Apply must not be nil")
	}
	data, err := json.Marshal(camelCatalog)
	if err != nil {
		return nil, err
	}
	name := camelCatalog.Name
	if name == nil {
		return nil, fmt.Errorf("camelCatalog.Name must be provided to Apply")
	}
	obj, err := c.Fake.
		Invokes(testing.NewPatchSubresourceAction(camelcatalogsResource, c.ns, *name, types.ApplyPatchType, data, "status"), &camelv1.CamelCatalog{})

	if obj == nil {
		return nil, err
	}
	return obj.(*camelv1.CamelCatalog), err
}
