/*
Licensed to the Apache Software Foundation (ASF) under one or more
contributor license agreements.  See the NOTICE file distributed with
this work for additional information regarding copyright ownership.
The ASF licenses this file to You under the Apache License, Version 2.0
(the "License"); you may not use this file except in compliance with
the License.  You may obtain a copy of the License at

   http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

// Code generated by applyconfiguration-gen. DO NOT EDIT.

package v1

// BuildahTaskApplyConfiguration represents an declarative configuration of the BuildahTask type for use
// with apply.
type BuildahTaskApplyConfiguration struct {
	BaseTaskApplyConfiguration    `json:",inline"`
	PublishTaskApplyConfiguration `json:",inline"`
	Platform                      *string `json:"platform,omitempty"`
	Verbose                       *bool   `json:"verbose,omitempty"`
	ExecutorImage                 *string `json:"executorImage,omitempty"`
}

// BuildahTaskApplyConfiguration constructs an declarative configuration of the BuildahTask type for use with
// apply.
func BuildahTask() *BuildahTaskApplyConfiguration {
	return &BuildahTaskApplyConfiguration{}
}

// WithName sets the Name field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the Name field is set to the value of the last call.
func (b *BuildahTaskApplyConfiguration) WithName(value string) *BuildahTaskApplyConfiguration {
	b.Name = &value
	return b
}

// WithContextDir sets the ContextDir field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the ContextDir field is set to the value of the last call.
func (b *BuildahTaskApplyConfiguration) WithContextDir(value string) *BuildahTaskApplyConfiguration {
	b.ContextDir = &value
	return b
}

// WithBaseImage sets the BaseImage field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the BaseImage field is set to the value of the last call.
func (b *BuildahTaskApplyConfiguration) WithBaseImage(value string) *BuildahTaskApplyConfiguration {
	b.BaseImage = &value
	return b
}

// WithImage sets the Image field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the Image field is set to the value of the last call.
func (b *BuildahTaskApplyConfiguration) WithImage(value string) *BuildahTaskApplyConfiguration {
	b.Image = &value
	return b
}

// WithRegistry sets the Registry field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the Registry field is set to the value of the last call.
func (b *BuildahTaskApplyConfiguration) WithRegistry(value *RegistrySpecApplyConfiguration) *BuildahTaskApplyConfiguration {
	b.Registry = value
	return b
}

// WithPlatform sets the Platform field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the Platform field is set to the value of the last call.
func (b *BuildahTaskApplyConfiguration) WithPlatform(value string) *BuildahTaskApplyConfiguration {
	b.Platform = &value
	return b
}

// WithVerbose sets the Verbose field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the Verbose field is set to the value of the last call.
func (b *BuildahTaskApplyConfiguration) WithVerbose(value bool) *BuildahTaskApplyConfiguration {
	b.Verbose = &value
	return b
}

// WithExecutorImage sets the ExecutorImage field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the ExecutorImage field is set to the value of the last call.
func (b *BuildahTaskApplyConfiguration) WithExecutorImage(value string) *BuildahTaskApplyConfiguration {
	b.ExecutorImage = &value
	return b
}
