/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.wrapper;

import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.URI;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Formatter;
import java.util.List;
import java.util.Locale;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.apache.maven.wrapper.Downloader;
import org.apache.maven.wrapper.Logger;
import org.apache.maven.wrapper.PathAssembler;
import org.apache.maven.wrapper.WrapperConfiguration;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Installer {
    public static final String DEFAULT_DISTRIBUTION_PATH = "wrapper/dists";
    private final Downloader download;
    private final PathAssembler pathAssembler;

    public Installer(Downloader download, PathAssembler pathAssembler) {
        this.download = download;
        this.pathAssembler = pathAssembler;
    }

    public File createDist(WrapperConfiguration configuration) throws Exception {
        URI distributionUrl;
        String mvnwRepoUrl = System.getenv("MVNW_REPOURL");
        if (mvnwRepoUrl != null && !mvnwRepoUrl.isEmpty()) {
            distributionUrl = new URI(String.valueOf(mvnwRepoUrl) + "/" + "org/apache/maven/apache-maven/3.6.0/apache-maven-3.6.0-bin.zip");
            Logger.info("Detected MVNW_REPOURL environment variable " + mvnwRepoUrl);
        } else {
            distributionUrl = configuration.getDistribution();
        }
        Logger.info("Downloading Maven binary from " + distributionUrl);
        boolean alwaysDownload = configuration.isAlwaysDownload();
        boolean alwaysUnpack = configuration.isAlwaysUnpack();
        PathAssembler.LocalDistribution localDistribution = this.pathAssembler.getDistribution(configuration);
        File localZipFile = localDistribution.getZipFile();
        boolean downloaded = false;
        if (alwaysDownload || !localZipFile.exists()) {
            File tmpZipFile = new File(localZipFile.getParentFile(), String.valueOf(localZipFile.getName()) + ".part");
            tmpZipFile.delete();
            Logger.info("Downloading " + distributionUrl);
            this.download.download(distributionUrl, tmpZipFile);
            tmpZipFile.renameTo(localZipFile);
            downloaded = true;
        }
        File distDir = localDistribution.getDistributionDir();
        List<File> dirs = this.listDirs(distDir);
        if (downloaded || alwaysUnpack || dirs.isEmpty()) {
            for (File dir : dirs) {
                Logger.info("Deleting directory " + dir.getAbsolutePath());
                this.deleteDir(dir);
            }
            Logger.info("Unzipping " + localZipFile.getAbsolutePath() + " to " + distDir.getAbsolutePath());
            this.unzip(localZipFile, distDir);
            dirs = this.listDirs(distDir);
            if (dirs.isEmpty()) {
                throw new RuntimeException(String.format("Maven distribution '%s' does not contain any directories. Expected to find exactly 1 directory.", distributionUrl));
            }
            this.setExecutablePermissions(dirs.get(0));
        }
        if (dirs.size() != 1) {
            throw new RuntimeException(String.format("Maven distribution '%s' contains too many directories. Expected to find exactly 1 directory.", distributionUrl));
        }
        return dirs.get(0);
    }

    private List<File> listDirs(File distDir) {
        ArrayList<File> dirs = new ArrayList<File>();
        if (distDir.exists()) {
            File[] fileArray = distDir.listFiles();
            int n = fileArray.length;
            int n2 = 0;
            while (n2 < n) {
                File file = fileArray[n2];
                if (file.isDirectory()) {
                    dirs.add(file);
                }
                ++n2;
            }
        }
        return dirs;
    }

    private void setExecutablePermissions(File mavenHome) {
        if (this.isWindows()) {
            return;
        }
        File mavenCommand = new File(mavenHome, "bin/mvn");
        String errorMessage = null;
        try {
            ProcessBuilder pb = new ProcessBuilder("chmod", "755", mavenCommand.getCanonicalPath());
            Process p = pb.start();
            if (p.waitFor() == 0) {
                Logger.info("Set executable permissions for: " + mavenCommand.getAbsolutePath());
            } else {
                String line;
                BufferedReader is = new BufferedReader(new InputStreamReader(p.getInputStream()));
                Formatter stdout = new Formatter();
                while ((line = is.readLine()) != null) {
                    stdout.format("%s%n", line);
                }
                errorMessage = stdout.toString();
            }
        }
        catch (IOException e) {
            errorMessage = e.getMessage();
        }
        catch (InterruptedException e) {
            errorMessage = e.getMessage();
        }
        if (errorMessage != null) {
            Logger.warn("Could not set executable permissions for: " + mavenCommand.getAbsolutePath());
            Logger.warn("Please do this manually if you want to use maven.");
        }
    }

    private boolean isWindows() {
        String osName = System.getProperty("os.name").toLowerCase(Locale.US);
        return osName.indexOf("windows") > -1;
    }

    private boolean deleteDir(File dir) {
        if (dir.isDirectory()) {
            String[] children = dir.list();
            int i = 0;
            while (i < children.length) {
                boolean success = this.deleteDir(new File(dir, children[i]));
                if (!success) {
                    return false;
                }
                ++i;
            }
        }
        return dir.delete();
    }

    public void unzip(File zip, File dest) throws IOException {
        ZipFile zipFile = new ZipFile(zip);
        Enumeration<? extends ZipEntry> entries = zipFile.entries();
        while (entries.hasMoreElements()) {
            ZipEntry entry = entries.nextElement();
            if (entry.isDirectory()) {
                new File(dest, entry.getName()).mkdirs();
                continue;
            }
            new File(dest, entry.getName()).getParentFile().mkdirs();
            this.copyInputStream(zipFile.getInputStream(entry), new BufferedOutputStream(new FileOutputStream(new File(dest, entry.getName()))));
        }
        zipFile.close();
    }

    public void copyInputStream(InputStream in, OutputStream out) throws IOException {
        int len;
        byte[] buffer = new byte[1024];
        while ((len = in.read(buffer)) >= 0) {
            out.write(buffer, 0, len);
        }
        in.close();
        out.close();
    }
}

