/* Generated by camel build tools - do NOT edit this file! */
/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.apache.camel.builder.endpoint.dsl;

import java.util.*;
import java.util.concurrent.*;
import java.util.function.*;
import java.util.stream.*;
import javax.annotation.processing.Generated;
import org.apache.camel.builder.EndpointConsumerBuilder;
import org.apache.camel.builder.EndpointProducerBuilder;
import org.apache.camel.builder.endpoint.AbstractEndpointBuilder;

/**
 * Store and retrieve objects from AWS S3 Storage Service.
 * 
 * Generated by camel build tools - do NOT edit this file!
 */
@Generated("org.apache.camel.maven.packaging.EndpointDslMojo")
public interface AWS2S3EndpointBuilderFactory {

    /**
     * Builder for endpoint consumers for the AWS S3 Storage Service component.
     */
    public interface AWS2S3EndpointConsumerBuilder
            extends
                EndpointConsumerBuilder {
        default AdvancedAWS2S3EndpointConsumerBuilder advanced() {
            return (AdvancedAWS2S3EndpointConsumerBuilder) this;
        }
        /**
         * Setting the autocreation of the S3 bucket bucketName. This will apply
         * also in case of moveAfterRead option enabled, and it will create the
         * destinationBucket if it doesn't exist already.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Default: false
         * Group: common
         * 
         * @param autoCreateBucket the value to set
         * @return the dsl builder
         */
        default AWS2S3EndpointConsumerBuilder autoCreateBucket(boolean autoCreateBucket) {
            doSetProperty("autoCreateBucket", autoCreateBucket);
            return this;
        }
        /**
         * Setting the autocreation of the S3 bucket bucketName. This will apply
         * also in case of moveAfterRead option enabled, and it will create the
         * destinationBucket if it doesn't exist already.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Default: false
         * Group: common
         * 
         * @param autoCreateBucket the value to set
         * @return the dsl builder
         */
        default AWS2S3EndpointConsumerBuilder autoCreateBucket(String autoCreateBucket) {
            doSetProperty("autoCreateBucket", autoCreateBucket);
            return this;
        }
        /**
         * The delimiter which is used in the
         * com.amazonaws.services.s3.model.ListObjectsRequest to only consume
         * objects we are interested in.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: common
         * 
         * @param delimiter the value to set
         * @return the dsl builder
         */
        default AWS2S3EndpointConsumerBuilder delimiter(String delimiter) {
            doSetProperty("delimiter", delimiter);
            return this;
        }
        /**
         * Set whether the S3 client should use path-style URL instead of
         * virtual-hosted-style.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Default: false
         * Group: common
         * 
         * @param forcePathStyle the value to set
         * @return the dsl builder
         */
        default AWS2S3EndpointConsumerBuilder forcePathStyle(boolean forcePathStyle) {
            doSetProperty("forcePathStyle", forcePathStyle);
            return this;
        }
        /**
         * Set whether the S3 client should use path-style URL instead of
         * virtual-hosted-style.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Default: false
         * Group: common
         * 
         * @param forcePathStyle the value to set
         * @return the dsl builder
         */
        default AWS2S3EndpointConsumerBuilder forcePathStyle(String forcePathStyle) {
            doSetProperty("forcePathStyle", forcePathStyle);
            return this;
        }
        /**
         * Set the need for overriding the endpoint. This option needs to be
         * used in combination with the uriEndpointOverride option.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Default: false
         * Group: common
         * 
         * @param overrideEndpoint the value to set
         * @return the dsl builder
         */
        default AWS2S3EndpointConsumerBuilder overrideEndpoint(boolean overrideEndpoint) {
            doSetProperty("overrideEndpoint", overrideEndpoint);
            return this;
        }
        /**
         * Set the need for overriding the endpoint. This option needs to be
         * used in combination with the uriEndpointOverride option.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Default: false
         * Group: common
         * 
         * @param overrideEndpoint the value to set
         * @return the dsl builder
         */
        default AWS2S3EndpointConsumerBuilder overrideEndpoint(String overrideEndpoint) {
            doSetProperty("overrideEndpoint", overrideEndpoint);
            return this;
        }
        /**
         * If we want to use a POJO request as body or not.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Default: false
         * Group: common
         * 
         * @param pojoRequest the value to set
         * @return the dsl builder
         */
        default AWS2S3EndpointConsumerBuilder pojoRequest(boolean pojoRequest) {
            doSetProperty("pojoRequest", pojoRequest);
            return this;
        }
        /**
         * If we want to use a POJO request as body or not.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Default: false
         * Group: common
         * 
         * @param pojoRequest the value to set
         * @return the dsl builder
         */
        default AWS2S3EndpointConsumerBuilder pojoRequest(String pojoRequest) {
            doSetProperty("pojoRequest", pojoRequest);
            return this;
        }
        /**
         * The policy for this queue to set in the
         * com.amazonaws.services.s3.AmazonS3#setBucketPolicy() method.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: common
         * 
         * @param policy the value to set
         * @return the dsl builder
         */
        default AWS2S3EndpointConsumerBuilder policy(String policy) {
            doSetProperty("policy", policy);
            return this;
        }
        /**
         * The prefix which is used in the
         * com.amazonaws.services.s3.model.ListObjectsRequest to only consume
         * objects we are interested in.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: common
         * 
         * @param prefix the value to set
         * @return the dsl builder
         */
        default AWS2S3EndpointConsumerBuilder prefix(String prefix) {
            doSetProperty("prefix", prefix);
            return this;
        }
        /**
         * The region in which the S3 client needs to work. When using this
         * parameter, the configuration will expect the lowercase name of the
         * region (for example, ap-east-1) You'll need to use the name
         * Region.EU_WEST_1.id().
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: common
         * 
         * @param region the value to set
         * @return the dsl builder
         */
        default AWS2S3EndpointConsumerBuilder region(String region) {
            doSetProperty("region", region);
            return this;
        }
        /**
         * Set the overriding uri endpoint. This option needs to be used in
         * combination with overrideEndpoint option.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: common
         * 
         * @param uriEndpointOverride the value to set
         * @return the dsl builder
         */
        default AWS2S3EndpointConsumerBuilder uriEndpointOverride(String uriEndpointOverride) {
            doSetProperty("uriEndpointOverride", uriEndpointOverride);
            return this;
        }
        /**
         * Delete objects from S3 after they have been retrieved. The deleting
         * is only performed if the Exchange is committed. If a rollback occurs,
         * the object is not deleted. If this option is false, then the same
         * objects will be retrieved over and over again in the polls.
         * Therefore, you need to use the Idempotent Consumer EIP in the route
         * to filter out duplicates. You can filter using the
         * AWS2S3Constants#BUCKET_NAME and AWS2S3Constants#KEY headers, or only
         * the AWS2S3Constants#KEY header.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Default: true
         * Group: consumer
         * 
         * @param deleteAfterRead the value to set
         * @return the dsl builder
         */
        default AWS2S3EndpointConsumerBuilder deleteAfterRead(boolean deleteAfterRead) {
            doSetProperty("deleteAfterRead", deleteAfterRead);
            return this;
        }
        /**
         * Delete objects from S3 after they have been retrieved. The deleting
         * is only performed if the Exchange is committed. If a rollback occurs,
         * the object is not deleted. If this option is false, then the same
         * objects will be retrieved over and over again in the polls.
         * Therefore, you need to use the Idempotent Consumer EIP in the route
         * to filter out duplicates. You can filter using the
         * AWS2S3Constants#BUCKET_NAME and AWS2S3Constants#KEY headers, or only
         * the AWS2S3Constants#KEY header.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Default: true
         * Group: consumer
         * 
         * @param deleteAfterRead the value to set
         * @return the dsl builder
         */
        default AWS2S3EndpointConsumerBuilder deleteAfterRead(String deleteAfterRead) {
            doSetProperty("deleteAfterRead", deleteAfterRead);
            return this;
        }
        /**
         * Define the destination bucket where an object must be moved when
         * moveAfterRead is set to true.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: consumer
         * 
         * @param destinationBucket the value to set
         * @return the dsl builder
         */
        default AWS2S3EndpointConsumerBuilder destinationBucket(String destinationBucket) {
            doSetProperty("destinationBucket", destinationBucket);
            return this;
        }
        /**
         * Define the destination bucket prefix to use when an object must be
         * moved, and moveAfterRead is set to true.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: consumer
         * 
         * @param destinationBucketPrefix the value to set
         * @return the dsl builder
         */
        default AWS2S3EndpointConsumerBuilder destinationBucketPrefix(String destinationBucketPrefix) {
            doSetProperty("destinationBucketPrefix", destinationBucketPrefix);
            return this;
        }
        /**
         * Define the destination bucket suffix to use when an object must be
         * moved, and moveAfterRead is set to true.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: consumer
         * 
         * @param destinationBucketSuffix the value to set
         * @return the dsl builder
         */
        default AWS2S3EndpointConsumerBuilder destinationBucketSuffix(String destinationBucketSuffix) {
            doSetProperty("destinationBucketSuffix", destinationBucketSuffix);
            return this;
        }
        /**
         * If provided, Camel will only consume files if a done file exists.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: consumer
         * 
         * @param doneFileName the value to set
         * @return the dsl builder
         */
        default AWS2S3EndpointConsumerBuilder doneFileName(String doneFileName) {
            doSetProperty("doneFileName", doneFileName);
            return this;
        }
        /**
         * To get the object from the bucket with the given file name.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: consumer
         * 
         * @param fileName the value to set
         * @return the dsl builder
         */
        default AWS2S3EndpointConsumerBuilder fileName(String fileName) {
            doSetProperty("fileName", fileName);
            return this;
        }
        /**
         * If it is true, the S3 Object Body will be ignored completely if it is
         * set to false, the S3 Object will be put in the body. Setting this to
         * true will override any behavior defined by includeBody option.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Default: false
         * Group: consumer
         * 
         * @param ignoreBody the value to set
         * @return the dsl builder
         */
        default AWS2S3EndpointConsumerBuilder ignoreBody(boolean ignoreBody) {
            doSetProperty("ignoreBody", ignoreBody);
            return this;
        }
        /**
         * If it is true, the S3 Object Body will be ignored completely if it is
         * set to false, the S3 Object will be put in the body. Setting this to
         * true will override any behavior defined by includeBody option.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Default: false
         * Group: consumer
         * 
         * @param ignoreBody the value to set
         * @return the dsl builder
         */
        default AWS2S3EndpointConsumerBuilder ignoreBody(String ignoreBody) {
            doSetProperty("ignoreBody", ignoreBody);
            return this;
        }
        /**
         * If it is true, the S3Object exchange will be consumed and put into
         * the body and closed. If false, the S3Object stream will be put raw
         * into the body and the headers will be set with the S3 object
         * metadata. This option is strongly related to the autocloseBody
         * option. In case of setting includeBody to true because the S3Object
         * stream will be consumed then it will also be closed, while in case of
         * includeBody false then it will be up to the caller to close the
         * S3Object stream. However, setting autocloseBody to true when
         * includeBody is false it will schedule to close the S3Object stream
         * automatically on exchange completion.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Default: true
         * Group: consumer
         * 
         * @param includeBody the value to set
         * @return the dsl builder
         */
        default AWS2S3EndpointConsumerBuilder includeBody(boolean includeBody) {
            doSetProperty("includeBody", includeBody);
            return this;
        }
        /**
         * If it is true, the S3Object exchange will be consumed and put into
         * the body and closed. If false, the S3Object stream will be put raw
         * into the body and the headers will be set with the S3 object
         * metadata. This option is strongly related to the autocloseBody
         * option. In case of setting includeBody to true because the S3Object
         * stream will be consumed then it will also be closed, while in case of
         * includeBody false then it will be up to the caller to close the
         * S3Object stream. However, setting autocloseBody to true when
         * includeBody is false it will schedule to close the S3Object stream
         * automatically on exchange completion.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Default: true
         * Group: consumer
         * 
         * @param includeBody the value to set
         * @return the dsl builder
         */
        default AWS2S3EndpointConsumerBuilder includeBody(String includeBody) {
            doSetProperty("includeBody", includeBody);
            return this;
        }
        /**
         * If it is true, the folders/directories will be consumed. If it is
         * false, they will be ignored, and Exchanges will not be created for
         * those.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Default: true
         * Group: consumer
         * 
         * @param includeFolders the value to set
         * @return the dsl builder
         */
        default AWS2S3EndpointConsumerBuilder includeFolders(boolean includeFolders) {
            doSetProperty("includeFolders", includeFolders);
            return this;
        }
        /**
         * If it is true, the folders/directories will be consumed. If it is
         * false, they will be ignored, and Exchanges will not be created for
         * those.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Default: true
         * Group: consumer
         * 
         * @param includeFolders the value to set
         * @return the dsl builder
         */
        default AWS2S3EndpointConsumerBuilder includeFolders(String includeFolders) {
            doSetProperty("includeFolders", includeFolders);
            return this;
        }
        /**
         * Set the maxConnections parameter in the S3 client configuration.
         * 
         * The option is a: <code>int</code> type.
         * 
         * Default: 60
         * Group: consumer
         * 
         * @param maxConnections the value to set
         * @return the dsl builder
         */
        default AWS2S3EndpointConsumerBuilder maxConnections(int maxConnections) {
            doSetProperty("maxConnections", maxConnections);
            return this;
        }
        /**
         * Set the maxConnections parameter in the S3 client configuration.
         * 
         * The option will be converted to a <code>int</code> type.
         * 
         * Default: 60
         * Group: consumer
         * 
         * @param maxConnections the value to set
         * @return the dsl builder
         */
        default AWS2S3EndpointConsumerBuilder maxConnections(String maxConnections) {
            doSetProperty("maxConnections", maxConnections);
            return this;
        }
        /**
         * Gets the maximum number of messages as a limit to poll at each
         * polling. Gets the maximum number of messages as a limit to poll at
         * each polling. The default value is 10. Use 0 or a negative number to
         * set it as unlimited.
         * 
         * The option is a: <code>int</code> type.
         * 
         * Default: 10
         * Group: consumer
         * 
         * @param maxMessagesPerPoll the value to set
         * @return the dsl builder
         */
        default AWS2S3EndpointConsumerBuilder maxMessagesPerPoll(int maxMessagesPerPoll) {
            doSetProperty("maxMessagesPerPoll", maxMessagesPerPoll);
            return this;
        }
        /**
         * Gets the maximum number of messages as a limit to poll at each
         * polling. Gets the maximum number of messages as a limit to poll at
         * each polling. The default value is 10. Use 0 or a negative number to
         * set it as unlimited.
         * 
         * The option will be converted to a <code>int</code> type.
         * 
         * Default: 10
         * Group: consumer
         * 
         * @param maxMessagesPerPoll the value to set
         * @return the dsl builder
         */
        default AWS2S3EndpointConsumerBuilder maxMessagesPerPoll(String maxMessagesPerPoll) {
            doSetProperty("maxMessagesPerPoll", maxMessagesPerPoll);
            return this;
        }
        /**
         * Move objects from S3 bucket to a different bucket after they have
         * been retrieved. To accomplish the operation, the destinationBucket
         * option must be set. The copy bucket operation is only performed if
         * the Exchange is committed. If a rollback occurs, the object is not
         * moved.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Default: false
         * Group: consumer
         * 
         * @param moveAfterRead the value to set
         * @return the dsl builder
         */
        default AWS2S3EndpointConsumerBuilder moveAfterRead(boolean moveAfterRead) {
            doSetProperty("moveAfterRead", moveAfterRead);
            return this;
        }
        /**
         * Move objects from S3 bucket to a different bucket after they have
         * been retrieved. To accomplish the operation, the destinationBucket
         * option must be set. The copy bucket operation is only performed if
         * the Exchange is committed. If a rollback occurs, the object is not
         * moved.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Default: false
         * Group: consumer
         * 
         * @param moveAfterRead the value to set
         * @return the dsl builder
         */
        default AWS2S3EndpointConsumerBuilder moveAfterRead(String moveAfterRead) {
            doSetProperty("moveAfterRead", moveAfterRead);
            return this;
        }
        /**
         * If the polling consumer did not poll any files, you can enable this
         * option to send an empty message (no body) instead.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Default: false
         * Group: consumer
         * 
         * @param sendEmptyMessageWhenIdle the value to set
         * @return the dsl builder
         */
        default AWS2S3EndpointConsumerBuilder sendEmptyMessageWhenIdle(boolean sendEmptyMessageWhenIdle) {
            doSetProperty("sendEmptyMessageWhenIdle", sendEmptyMessageWhenIdle);
            return this;
        }
        /**
         * If the polling consumer did not poll any files, you can enable this
         * option to send an empty message (no body) instead.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Default: false
         * Group: consumer
         * 
         * @param sendEmptyMessageWhenIdle the value to set
         * @return the dsl builder
         */
        default AWS2S3EndpointConsumerBuilder sendEmptyMessageWhenIdle(String sendEmptyMessageWhenIdle) {
            doSetProperty("sendEmptyMessageWhenIdle", sendEmptyMessageWhenIdle);
            return this;
        }
        /**
         * To define a proxy host when instantiating the SQS client.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: proxy
         * 
         * @param proxyHost the value to set
         * @return the dsl builder
         */
        default AWS2S3EndpointConsumerBuilder proxyHost(String proxyHost) {
            doSetProperty("proxyHost", proxyHost);
            return this;
        }
        /**
         * Specify a proxy port to be used inside the client definition.
         * 
         * The option is a: <code>java.lang.Integer</code> type.
         * 
         * Group: proxy
         * 
         * @param proxyPort the value to set
         * @return the dsl builder
         */
        default AWS2S3EndpointConsumerBuilder proxyPort(Integer proxyPort) {
            doSetProperty("proxyPort", proxyPort);
            return this;
        }
        /**
         * Specify a proxy port to be used inside the client definition.
         * 
         * The option will be converted to a <code>java.lang.Integer</code>
         * type.
         * 
         * Group: proxy
         * 
         * @param proxyPort the value to set
         * @return the dsl builder
         */
        default AWS2S3EndpointConsumerBuilder proxyPort(String proxyPort) {
            doSetProperty("proxyPort", proxyPort);
            return this;
        }
        /**
         * To define a proxy protocol when instantiating the S3 client.
         * 
         * The option is a: <code>software.amazon.awssdk.core.Protocol</code>
         * type.
         * 
         * Default: HTTPS
         * Group: proxy
         * 
         * @param proxyProtocol the value to set
         * @return the dsl builder
         */
        default AWS2S3EndpointConsumerBuilder proxyProtocol(software.amazon.awssdk.core.Protocol proxyProtocol) {
            doSetProperty("proxyProtocol", proxyProtocol);
            return this;
        }
        /**
         * To define a proxy protocol when instantiating the S3 client.
         * 
         * The option will be converted to a
         * <code>software.amazon.awssdk.core.Protocol</code> type.
         * 
         * Default: HTTPS
         * Group: proxy
         * 
         * @param proxyProtocol the value to set
         * @return the dsl builder
         */
        default AWS2S3EndpointConsumerBuilder proxyProtocol(String proxyProtocol) {
            doSetProperty("proxyProtocol", proxyProtocol);
            return this;
        }
        /**
         * The number of subsequent error polls (failed due some error) that
         * should happen before the backoffMultipler should kick-in.
         * 
         * The option is a: <code>int</code> type.
         * 
         * Group: scheduler
         * 
         * @param backoffErrorThreshold the value to set
         * @return the dsl builder
         */
        default AWS2S3EndpointConsumerBuilder backoffErrorThreshold(int backoffErrorThreshold) {
            doSetProperty("backoffErrorThreshold", backoffErrorThreshold);
            return this;
        }
        /**
         * The number of subsequent error polls (failed due some error) that
         * should happen before the backoffMultipler should kick-in.
         * 
         * The option will be converted to a <code>int</code> type.
         * 
         * Group: scheduler
         * 
         * @param backoffErrorThreshold the value to set
         * @return the dsl builder
         */
        default AWS2S3EndpointConsumerBuilder backoffErrorThreshold(String backoffErrorThreshold) {
            doSetProperty("backoffErrorThreshold", backoffErrorThreshold);
            return this;
        }
        /**
         * The number of subsequent idle polls that should happen before the
         * backoffMultipler should kick-in.
         * 
         * The option is a: <code>int</code> type.
         * 
         * Group: scheduler
         * 
         * @param backoffIdleThreshold the value to set
         * @return the dsl builder
         */
        default AWS2S3EndpointConsumerBuilder backoffIdleThreshold(int backoffIdleThreshold) {
            doSetProperty("backoffIdleThreshold", backoffIdleThreshold);
            return this;
        }
        /**
         * The number of subsequent idle polls that should happen before the
         * backoffMultipler should kick-in.
         * 
         * The option will be converted to a <code>int</code> type.
         * 
         * Group: scheduler
         * 
         * @param backoffIdleThreshold the value to set
         * @return the dsl builder
         */
        default AWS2S3EndpointConsumerBuilder backoffIdleThreshold(String backoffIdleThreshold) {
            doSetProperty("backoffIdleThreshold", backoffIdleThreshold);
            return this;
        }
        /**
         * To let the scheduled polling consumer backoff if there has been a
         * number of subsequent idles/errors in a row. The multiplier is then
         * the number of polls that will be skipped before the next actual
         * attempt is happening again. When this option is in use then
         * backoffIdleThreshold and/or backoffErrorThreshold must also be
         * configured.
         * 
         * The option is a: <code>int</code> type.
         * 
         * Group: scheduler
         * 
         * @param backoffMultiplier the value to set
         * @return the dsl builder
         */
        default AWS2S3EndpointConsumerBuilder backoffMultiplier(int backoffMultiplier) {
            doSetProperty("backoffMultiplier", backoffMultiplier);
            return this;
        }
        /**
         * To let the scheduled polling consumer backoff if there has been a
         * number of subsequent idles/errors in a row. The multiplier is then
         * the number of polls that will be skipped before the next actual
         * attempt is happening again. When this option is in use then
         * backoffIdleThreshold and/or backoffErrorThreshold must also be
         * configured.
         * 
         * The option will be converted to a <code>int</code> type.
         * 
         * Group: scheduler
         * 
         * @param backoffMultiplier the value to set
         * @return the dsl builder
         */
        default AWS2S3EndpointConsumerBuilder backoffMultiplier(String backoffMultiplier) {
            doSetProperty("backoffMultiplier", backoffMultiplier);
            return this;
        }
        /**
         * Milliseconds before the next poll.
         * 
         * The option is a: <code>long</code> type.
         * 
         * Default: 500
         * Group: scheduler
         * 
         * @param delay the value to set
         * @return the dsl builder
         */
        default AWS2S3EndpointConsumerBuilder delay(long delay) {
            doSetProperty("delay", delay);
            return this;
        }
        /**
         * Milliseconds before the next poll.
         * 
         * The option will be converted to a <code>long</code> type.
         * 
         * Default: 500
         * Group: scheduler
         * 
         * @param delay the value to set
         * @return the dsl builder
         */
        default AWS2S3EndpointConsumerBuilder delay(String delay) {
            doSetProperty("delay", delay);
            return this;
        }
        /**
         * If greedy is enabled, then the ScheduledPollConsumer will run
         * immediately again, if the previous run polled 1 or more messages.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Default: false
         * Group: scheduler
         * 
         * @param greedy the value to set
         * @return the dsl builder
         */
        default AWS2S3EndpointConsumerBuilder greedy(boolean greedy) {
            doSetProperty("greedy", greedy);
            return this;
        }
        /**
         * If greedy is enabled, then the ScheduledPollConsumer will run
         * immediately again, if the previous run polled 1 or more messages.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Default: false
         * Group: scheduler
         * 
         * @param greedy the value to set
         * @return the dsl builder
         */
        default AWS2S3EndpointConsumerBuilder greedy(String greedy) {
            doSetProperty("greedy", greedy);
            return this;
        }
        /**
         * Milliseconds before the first poll starts.
         * 
         * The option is a: <code>long</code> type.
         * 
         * Default: 1000
         * Group: scheduler
         * 
         * @param initialDelay the value to set
         * @return the dsl builder
         */
        default AWS2S3EndpointConsumerBuilder initialDelay(long initialDelay) {
            doSetProperty("initialDelay", initialDelay);
            return this;
        }
        /**
         * Milliseconds before the first poll starts.
         * 
         * The option will be converted to a <code>long</code> type.
         * 
         * Default: 1000
         * Group: scheduler
         * 
         * @param initialDelay the value to set
         * @return the dsl builder
         */
        default AWS2S3EndpointConsumerBuilder initialDelay(String initialDelay) {
            doSetProperty("initialDelay", initialDelay);
            return this;
        }
        /**
         * Specifies a maximum limit of number of fires. So if you set it to 1,
         * the scheduler will only fire once. If you set it to 5, it will only
         * fire five times. A value of zero or negative means fire forever.
         * 
         * The option is a: <code>long</code> type.
         * 
         * Default: 0
         * Group: scheduler
         * 
         * @param repeatCount the value to set
         * @return the dsl builder
         */
        default AWS2S3EndpointConsumerBuilder repeatCount(long repeatCount) {
            doSetProperty("repeatCount", repeatCount);
            return this;
        }
        /**
         * Specifies a maximum limit of number of fires. So if you set it to 1,
         * the scheduler will only fire once. If you set it to 5, it will only
         * fire five times. A value of zero or negative means fire forever.
         * 
         * The option will be converted to a <code>long</code> type.
         * 
         * Default: 0
         * Group: scheduler
         * 
         * @param repeatCount the value to set
         * @return the dsl builder
         */
        default AWS2S3EndpointConsumerBuilder repeatCount(String repeatCount) {
            doSetProperty("repeatCount", repeatCount);
            return this;
        }
        /**
         * The consumer logs a start/complete log line when it polls. This
         * option allows you to configure the logging level for that.
         * 
         * The option is a: <code>org.apache.camel.LoggingLevel</code> type.
         * 
         * Default: TRACE
         * Group: scheduler
         * 
         * @param runLoggingLevel the value to set
         * @return the dsl builder
         */
        default AWS2S3EndpointConsumerBuilder runLoggingLevel(org.apache.camel.LoggingLevel runLoggingLevel) {
            doSetProperty("runLoggingLevel", runLoggingLevel);
            return this;
        }
        /**
         * The consumer logs a start/complete log line when it polls. This
         * option allows you to configure the logging level for that.
         * 
         * The option will be converted to a
         * <code>org.apache.camel.LoggingLevel</code> type.
         * 
         * Default: TRACE
         * Group: scheduler
         * 
         * @param runLoggingLevel the value to set
         * @return the dsl builder
         */
        default AWS2S3EndpointConsumerBuilder runLoggingLevel(String runLoggingLevel) {
            doSetProperty("runLoggingLevel", runLoggingLevel);
            return this;
        }
        /**
         * Allows for configuring a custom/shared thread pool to use for the
         * consumer. By default each consumer has its own single threaded thread
         * pool.
         * 
         * The option is a:
         * <code>java.util.concurrent.ScheduledExecutorService</code> type.
         * 
         * Group: scheduler
         * 
         * @param scheduledExecutorService the value to set
         * @return the dsl builder
         */
        default AWS2S3EndpointConsumerBuilder scheduledExecutorService(ScheduledExecutorService scheduledExecutorService) {
            doSetProperty("scheduledExecutorService", scheduledExecutorService);
            return this;
        }
        /**
         * Allows for configuring a custom/shared thread pool to use for the
         * consumer. By default each consumer has its own single threaded thread
         * pool.
         * 
         * The option will be converted to a
         * <code>java.util.concurrent.ScheduledExecutorService</code> type.
         * 
         * Group: scheduler
         * 
         * @param scheduledExecutorService the value to set
         * @return the dsl builder
         */
        default AWS2S3EndpointConsumerBuilder scheduledExecutorService(String scheduledExecutorService) {
            doSetProperty("scheduledExecutorService", scheduledExecutorService);
            return this;
        }
        /**
         * To use a cron scheduler from either camel-spring or camel-quartz
         * component. Use value spring or quartz for built in scheduler.
         * 
         * The option is a: <code>java.lang.Object</code> type.
         * 
         * Default: none
         * Group: scheduler
         * 
         * @param scheduler the value to set
         * @return the dsl builder
         */
        default AWS2S3EndpointConsumerBuilder scheduler(Object scheduler) {
            doSetProperty("scheduler", scheduler);
            return this;
        }
        /**
         * To use a cron scheduler from either camel-spring or camel-quartz
         * component. Use value spring or quartz for built in scheduler.
         * 
         * The option will be converted to a <code>java.lang.Object</code> type.
         * 
         * Default: none
         * Group: scheduler
         * 
         * @param scheduler the value to set
         * @return the dsl builder
         */
        default AWS2S3EndpointConsumerBuilder scheduler(String scheduler) {
            doSetProperty("scheduler", scheduler);
            return this;
        }
        /**
         * To configure additional properties when using a custom scheduler or
         * any of the Quartz, Spring based scheduler.
         * 
         * The option is a: <code>java.util.Map&lt;java.lang.String,
         * java.lang.Object&gt;</code> type.
         * The option is multivalued, and you can use the
         * schedulerProperties(String, Object) method to add a value (call the
         * method multiple times to set more values).
         * 
         * Group: scheduler
         * 
         * @param key the option key
         * @param value the option value
         * @return the dsl builder
         */
        default AWS2S3EndpointConsumerBuilder schedulerProperties(String key, Object value) {
            doSetMultiValueProperty("schedulerProperties", "scheduler." + key, value);
            return this;
        }
        /**
         * To configure additional properties when using a custom scheduler or
         * any of the Quartz, Spring based scheduler.
         * 
         * The option is a: <code>java.util.Map&lt;java.lang.String,
         * java.lang.Object&gt;</code> type.
         * The option is multivalued, and you can use the
         * schedulerProperties(String, Object) method to add a value (call the
         * method multiple times to set more values).
         * 
         * Group: scheduler
         * 
         * @param values the values
         * @return the dsl builder
         */
        default AWS2S3EndpointConsumerBuilder schedulerProperties(Map values) {
            doSetMultiValueProperties("schedulerProperties", "scheduler.", values);
            return this;
        }
        /**
         * Whether the scheduler should be auto started.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Default: true
         * Group: scheduler
         * 
         * @param startScheduler the value to set
         * @return the dsl builder
         */
        default AWS2S3EndpointConsumerBuilder startScheduler(boolean startScheduler) {
            doSetProperty("startScheduler", startScheduler);
            return this;
        }
        /**
         * Whether the scheduler should be auto started.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Default: true
         * Group: scheduler
         * 
         * @param startScheduler the value to set
         * @return the dsl builder
         */
        default AWS2S3EndpointConsumerBuilder startScheduler(String startScheduler) {
            doSetProperty("startScheduler", startScheduler);
            return this;
        }
        /**
         * Time unit for initialDelay and delay options.
         * 
         * The option is a: <code>java.util.concurrent.TimeUnit</code> type.
         * 
         * Default: MILLISECONDS
         * Group: scheduler
         * 
         * @param timeUnit the value to set
         * @return the dsl builder
         */
        default AWS2S3EndpointConsumerBuilder timeUnit(TimeUnit timeUnit) {
            doSetProperty("timeUnit", timeUnit);
            return this;
        }
        /**
         * Time unit for initialDelay and delay options.
         * 
         * The option will be converted to a
         * <code>java.util.concurrent.TimeUnit</code> type.
         * 
         * Default: MILLISECONDS
         * Group: scheduler
         * 
         * @param timeUnit the value to set
         * @return the dsl builder
         */
        default AWS2S3EndpointConsumerBuilder timeUnit(String timeUnit) {
            doSetProperty("timeUnit", timeUnit);
            return this;
        }
        /**
         * Controls if fixed delay or fixed rate is used. See
         * ScheduledExecutorService in JDK for details.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Default: true
         * Group: scheduler
         * 
         * @param useFixedDelay the value to set
         * @return the dsl builder
         */
        default AWS2S3EndpointConsumerBuilder useFixedDelay(boolean useFixedDelay) {
            doSetProperty("useFixedDelay", useFixedDelay);
            return this;
        }
        /**
         * Controls if fixed delay or fixed rate is used. See
         * ScheduledExecutorService in JDK for details.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Default: true
         * Group: scheduler
         * 
         * @param useFixedDelay the value to set
         * @return the dsl builder
         */
        default AWS2S3EndpointConsumerBuilder useFixedDelay(String useFixedDelay) {
            doSetProperty("useFixedDelay", useFixedDelay);
            return this;
        }
        /**
         * Amazon AWS Access Key.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: security
         * 
         * @param accessKey the value to set
         * @return the dsl builder
         */
        default AWS2S3EndpointConsumerBuilder accessKey(String accessKey) {
            doSetProperty("accessKey", accessKey);
            return this;
        }
        /**
         * If using a profile credentials provider, this parameter will set the
         * profile name.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: security
         * 
         * @param profileCredentialsName the value to set
         * @return the dsl builder
         */
        default AWS2S3EndpointConsumerBuilder profileCredentialsName(String profileCredentialsName) {
            doSetProperty("profileCredentialsName", profileCredentialsName);
            return this;
        }
        /**
         * Amazon AWS Secret Key.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: security
         * 
         * @param secretKey the value to set
         * @return the dsl builder
         */
        default AWS2S3EndpointConsumerBuilder secretKey(String secretKey) {
            doSetProperty("secretKey", secretKey);
            return this;
        }
        /**
         * Amazon AWS Session Token used when the user needs to assume an IAM
         * role.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: security
         * 
         * @param sessionToken the value to set
         * @return the dsl builder
         */
        default AWS2S3EndpointConsumerBuilder sessionToken(String sessionToken) {
            doSetProperty("sessionToken", sessionToken);
            return this;
        }
        /**
         * If we want to trust all certificates in case of overriding the
         * endpoint.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Default: false
         * Group: security
         * 
         * @param trustAllCertificates the value to set
         * @return the dsl builder
         */
        default AWS2S3EndpointConsumerBuilder trustAllCertificates(boolean trustAllCertificates) {
            doSetProperty("trustAllCertificates", trustAllCertificates);
            return this;
        }
        /**
         * If we want to trust all certificates in case of overriding the
         * endpoint.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Default: false
         * Group: security
         * 
         * @param trustAllCertificates the value to set
         * @return the dsl builder
         */
        default AWS2S3EndpointConsumerBuilder trustAllCertificates(String trustAllCertificates) {
            doSetProperty("trustAllCertificates", trustAllCertificates);
            return this;
        }
        /**
         * Set whether the S3 client should expect to load credentials through a
         * default credentials provider.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Default: false
         * Group: security
         * 
         * @param useDefaultCredentialsProvider the value to set
         * @return the dsl builder
         */
        default AWS2S3EndpointConsumerBuilder useDefaultCredentialsProvider(boolean useDefaultCredentialsProvider) {
            doSetProperty("useDefaultCredentialsProvider", useDefaultCredentialsProvider);
            return this;
        }
        /**
         * Set whether the S3 client should expect to load credentials through a
         * default credentials provider.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Default: false
         * Group: security
         * 
         * @param useDefaultCredentialsProvider the value to set
         * @return the dsl builder
         */
        default AWS2S3EndpointConsumerBuilder useDefaultCredentialsProvider(String useDefaultCredentialsProvider) {
            doSetProperty("useDefaultCredentialsProvider", useDefaultCredentialsProvider);
            return this;
        }
        /**
         * Set whether the S3 client should expect to load credentials through a
         * profile credentials provider.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Default: false
         * Group: security
         * 
         * @param useProfileCredentialsProvider the value to set
         * @return the dsl builder
         */
        default AWS2S3EndpointConsumerBuilder useProfileCredentialsProvider(boolean useProfileCredentialsProvider) {
            doSetProperty("useProfileCredentialsProvider", useProfileCredentialsProvider);
            return this;
        }
        /**
         * Set whether the S3 client should expect to load credentials through a
         * profile credentials provider.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Default: false
         * Group: security
         * 
         * @param useProfileCredentialsProvider the value to set
         * @return the dsl builder
         */
        default AWS2S3EndpointConsumerBuilder useProfileCredentialsProvider(String useProfileCredentialsProvider) {
            doSetProperty("useProfileCredentialsProvider", useProfileCredentialsProvider);
            return this;
        }
        /**
         * Set whether the S3 client should expect to use Session Credentials.
         * This is useful in a situation in which the user needs to assume an
         * IAM role for doing operations in S3.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Default: false
         * Group: security
         * 
         * @param useSessionCredentials the value to set
         * @return the dsl builder
         */
        default AWS2S3EndpointConsumerBuilder useSessionCredentials(boolean useSessionCredentials) {
            doSetProperty("useSessionCredentials", useSessionCredentials);
            return this;
        }
        /**
         * Set whether the S3 client should expect to use Session Credentials.
         * This is useful in a situation in which the user needs to assume an
         * IAM role for doing operations in S3.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Default: false
         * Group: security
         * 
         * @param useSessionCredentials the value to set
         * @return the dsl builder
         */
        default AWS2S3EndpointConsumerBuilder useSessionCredentials(String useSessionCredentials) {
            doSetProperty("useSessionCredentials", useSessionCredentials);
            return this;
        }
    }

    /**
     * Advanced builder for endpoint consumers for the AWS S3 Storage Service component.
     */
    public interface AdvancedAWS2S3EndpointConsumerBuilder
            extends
                EndpointConsumerBuilder {
        default AWS2S3EndpointConsumerBuilder basic() {
            return (AWS2S3EndpointConsumerBuilder) this;
        }
        /**
         * Define the customer algorithm to use in case CustomerKey is enabled.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: common (advanced)
         * 
         * @param customerAlgorithm the value to set
         * @return the dsl builder
         */
        default AdvancedAWS2S3EndpointConsumerBuilder customerAlgorithm(String customerAlgorithm) {
            doSetProperty("customerAlgorithm", customerAlgorithm);
            return this;
        }
        /**
         * Define the id of the Customer key to use in case CustomerKey is
         * enabled.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: common (advanced)
         * 
         * @param customerKeyId the value to set
         * @return the dsl builder
         */
        default AdvancedAWS2S3EndpointConsumerBuilder customerKeyId(String customerKeyId) {
            doSetProperty("customerKeyId", customerKeyId);
            return this;
        }
        /**
         * Define the MD5 of Customer key to use in case CustomerKey is enabled.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: common (advanced)
         * 
         * @param customerKeyMD5 the value to set
         * @return the dsl builder
         */
        default AdvancedAWS2S3EndpointConsumerBuilder customerKeyMD5(String customerKeyMD5) {
            doSetProperty("customerKeyMD5", customerKeyMD5);
            return this;
        }
        /**
         * If this option is true and includeBody is false, then the
         * S3Object.close() method will be called on exchange completion. This
         * option is strongly related to includeBody option. In case of setting
         * includeBody to false and autocloseBody to false, it will be up to the
         * caller to close the S3Object stream. Setting autocloseBody to true,
         * will close the S3Object stream automatically.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Default: true
         * Group: consumer (advanced)
         * 
         * @param autocloseBody the value to set
         * @return the dsl builder
         */
        default AdvancedAWS2S3EndpointConsumerBuilder autocloseBody(boolean autocloseBody) {
            doSetProperty("autocloseBody", autocloseBody);
            return this;
        }
        /**
         * If this option is true and includeBody is false, then the
         * S3Object.close() method will be called on exchange completion. This
         * option is strongly related to includeBody option. In case of setting
         * includeBody to false and autocloseBody to false, it will be up to the
         * caller to close the S3Object stream. Setting autocloseBody to true,
         * will close the S3Object stream automatically.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Default: true
         * Group: consumer (advanced)
         * 
         * @param autocloseBody the value to set
         * @return the dsl builder
         */
        default AdvancedAWS2S3EndpointConsumerBuilder autocloseBody(String autocloseBody) {
            doSetProperty("autocloseBody", autocloseBody);
            return this;
        }
        /**
         * Allows for bridging the consumer to the Camel routing Error Handler,
         * which mean any exceptions (if possible) occurred while the Camel
         * consumer is trying to pickup incoming messages, or the likes, will
         * now be processed as a message and handled by the routing Error
         * Handler. Important: This is only possible if the 3rd party component
         * allows Camel to be alerted if an exception was thrown. Some
         * components handle this internally only, and therefore
         * bridgeErrorHandler is not possible. In other situations we may
         * improve the Camel component to hook into the 3rd party component and
         * make this possible for future releases. By default the consumer will
         * use the org.apache.camel.spi.ExceptionHandler to deal with
         * exceptions, that will be logged at WARN or ERROR level and ignored.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Default: false
         * Group: consumer (advanced)
         * 
         * @param bridgeErrorHandler the value to set
         * @return the dsl builder
         */
        default AdvancedAWS2S3EndpointConsumerBuilder bridgeErrorHandler(boolean bridgeErrorHandler) {
            doSetProperty("bridgeErrorHandler", bridgeErrorHandler);
            return this;
        }
        /**
         * Allows for bridging the consumer to the Camel routing Error Handler,
         * which mean any exceptions (if possible) occurred while the Camel
         * consumer is trying to pickup incoming messages, or the likes, will
         * now be processed as a message and handled by the routing Error
         * Handler. Important: This is only possible if the 3rd party component
         * allows Camel to be alerted if an exception was thrown. Some
         * components handle this internally only, and therefore
         * bridgeErrorHandler is not possible. In other situations we may
         * improve the Camel component to hook into the 3rd party component and
         * make this possible for future releases. By default the consumer will
         * use the org.apache.camel.spi.ExceptionHandler to deal with
         * exceptions, that will be logged at WARN or ERROR level and ignored.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Default: false
         * Group: consumer (advanced)
         * 
         * @param bridgeErrorHandler the value to set
         * @return the dsl builder
         */
        default AdvancedAWS2S3EndpointConsumerBuilder bridgeErrorHandler(String bridgeErrorHandler) {
            doSetProperty("bridgeErrorHandler", bridgeErrorHandler);
            return this;
        }
        /**
         * To let the consumer use a custom ExceptionHandler. Notice if the
         * option bridgeErrorHandler is enabled then this option is not in use.
         * By default the consumer will deal with exceptions, that will be
         * logged at WARN or ERROR level and ignored.
         * 
         * The option is a: <code>org.apache.camel.spi.ExceptionHandler</code>
         * type.
         * 
         * Group: consumer (advanced)
         * 
         * @param exceptionHandler the value to set
         * @return the dsl builder
         */
        default AdvancedAWS2S3EndpointConsumerBuilder exceptionHandler(org.apache.camel.spi.ExceptionHandler exceptionHandler) {
            doSetProperty("exceptionHandler", exceptionHandler);
            return this;
        }
        /**
         * To let the consumer use a custom ExceptionHandler. Notice if the
         * option bridgeErrorHandler is enabled then this option is not in use.
         * By default the consumer will deal with exceptions, that will be
         * logged at WARN or ERROR level and ignored.
         * 
         * The option will be converted to a
         * <code>org.apache.camel.spi.ExceptionHandler</code> type.
         * 
         * Group: consumer (advanced)
         * 
         * @param exceptionHandler the value to set
         * @return the dsl builder
         */
        default AdvancedAWS2S3EndpointConsumerBuilder exceptionHandler(String exceptionHandler) {
            doSetProperty("exceptionHandler", exceptionHandler);
            return this;
        }
        /**
         * Sets the exchange pattern when the consumer creates an exchange.
         * 
         * The option is a: <code>org.apache.camel.ExchangePattern</code> type.
         * 
         * Group: consumer (advanced)
         * 
         * @param exchangePattern the value to set
         * @return the dsl builder
         */
        default AdvancedAWS2S3EndpointConsumerBuilder exchangePattern(org.apache.camel.ExchangePattern exchangePattern) {
            doSetProperty("exchangePattern", exchangePattern);
            return this;
        }
        /**
         * Sets the exchange pattern when the consumer creates an exchange.
         * 
         * The option will be converted to a
         * <code>org.apache.camel.ExchangePattern</code> type.
         * 
         * Group: consumer (advanced)
         * 
         * @param exchangePattern the value to set
         * @return the dsl builder
         */
        default AdvancedAWS2S3EndpointConsumerBuilder exchangePattern(String exchangePattern) {
            doSetProperty("exchangePattern", exchangePattern);
            return this;
        }
        /**
         * A pluggable org.apache.camel.PollingConsumerPollingStrategy allowing
         * you to provide your custom implementation to control error handling
         * usually occurred during the poll operation before an Exchange have
         * been created and being routed in Camel.
         * 
         * The option is a:
         * <code>org.apache.camel.spi.PollingConsumerPollStrategy</code> type.
         * 
         * Group: consumer (advanced)
         * 
         * @param pollStrategy the value to set
         * @return the dsl builder
         */
        default AdvancedAWS2S3EndpointConsumerBuilder pollStrategy(org.apache.camel.spi.PollingConsumerPollStrategy pollStrategy) {
            doSetProperty("pollStrategy", pollStrategy);
            return this;
        }
        /**
         * A pluggable org.apache.camel.PollingConsumerPollingStrategy allowing
         * you to provide your custom implementation to control error handling
         * usually occurred during the poll operation before an Exchange have
         * been created and being routed in Camel.
         * 
         * The option will be converted to a
         * <code>org.apache.camel.spi.PollingConsumerPollStrategy</code> type.
         * 
         * Group: consumer (advanced)
         * 
         * @param pollStrategy the value to set
         * @return the dsl builder
         */
        default AdvancedAWS2S3EndpointConsumerBuilder pollStrategy(String pollStrategy) {
            doSetProperty("pollStrategy", pollStrategy);
            return this;
        }
        /**
         * Reference to a com.amazonaws.services.s3.AmazonS3 in the registry.
         * 
         * The option is a:
         * <code>software.amazon.awssdk.services.s3.S3Client</code> type.
         * 
         * Group: advanced
         * 
         * @param amazonS3Client the value to set
         * @return the dsl builder
         */
        default AdvancedAWS2S3EndpointConsumerBuilder amazonS3Client(software.amazon.awssdk.services.s3.S3Client amazonS3Client) {
            doSetProperty("amazonS3Client", amazonS3Client);
            return this;
        }
        /**
         * Reference to a com.amazonaws.services.s3.AmazonS3 in the registry.
         * 
         * The option will be converted to a
         * <code>software.amazon.awssdk.services.s3.S3Client</code> type.
         * 
         * Group: advanced
         * 
         * @param amazonS3Client the value to set
         * @return the dsl builder
         */
        default AdvancedAWS2S3EndpointConsumerBuilder amazonS3Client(String amazonS3Client) {
            doSetProperty("amazonS3Client", amazonS3Client);
            return this;
        }
        /**
         * An S3 Presigner for Request, used mainly in createDownloadLink
         * operation.
         * 
         * The option is a:
         * <code>software.amazon.awssdk.services.s3.presigner.S3Presigner</code>
         * type.
         * 
         * Group: advanced
         * 
         * @param amazonS3Presigner the value to set
         * @return the dsl builder
         */
        default AdvancedAWS2S3EndpointConsumerBuilder amazonS3Presigner(software.amazon.awssdk.services.s3.presigner.S3Presigner amazonS3Presigner) {
            doSetProperty("amazonS3Presigner", amazonS3Presigner);
            return this;
        }
        /**
         * An S3 Presigner for Request, used mainly in createDownloadLink
         * operation.
         * 
         * The option will be converted to a
         * <code>software.amazon.awssdk.services.s3.presigner.S3Presigner</code>
         * type.
         * 
         * Group: advanced
         * 
         * @param amazonS3Presigner the value to set
         * @return the dsl builder
         */
        default AdvancedAWS2S3EndpointConsumerBuilder amazonS3Presigner(String amazonS3Presigner) {
            doSetProperty("amazonS3Presigner", amazonS3Presigner);
            return this;
        }
    }

    /**
     * Builder for endpoint producers for the AWS S3 Storage Service component.
     */
    public interface AWS2S3EndpointProducerBuilder
            extends
                EndpointProducerBuilder {
        default AdvancedAWS2S3EndpointProducerBuilder advanced() {
            return (AdvancedAWS2S3EndpointProducerBuilder) this;
        }

        /**
         * Setting the autocreation of the S3 bucket bucketName. This will apply
         * also in case of moveAfterRead option enabled, and it will create the
         * destinationBucket if it doesn't exist already.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Default: false
         * Group: common
         * 
         * @param autoCreateBucket the value to set
         * @return the dsl builder
         */
        default AWS2S3EndpointProducerBuilder autoCreateBucket(boolean autoCreateBucket) {
            doSetProperty("autoCreateBucket", autoCreateBucket);
            return this;
        }
        /**
         * Setting the autocreation of the S3 bucket bucketName. This will apply
         * also in case of moveAfterRead option enabled, and it will create the
         * destinationBucket if it doesn't exist already.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Default: false
         * Group: common
         * 
         * @param autoCreateBucket the value to set
         * @return the dsl builder
         */
        default AWS2S3EndpointProducerBuilder autoCreateBucket(String autoCreateBucket) {
            doSetProperty("autoCreateBucket", autoCreateBucket);
            return this;
        }
        /**
         * The delimiter which is used in the
         * com.amazonaws.services.s3.model.ListObjectsRequest to only consume
         * objects we are interested in.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: common
         * 
         * @param delimiter the value to set
         * @return the dsl builder
         */
        default AWS2S3EndpointProducerBuilder delimiter(String delimiter) {
            doSetProperty("delimiter", delimiter);
            return this;
        }
        /**
         * Set whether the S3 client should use path-style URL instead of
         * virtual-hosted-style.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Default: false
         * Group: common
         * 
         * @param forcePathStyle the value to set
         * @return the dsl builder
         */
        default AWS2S3EndpointProducerBuilder forcePathStyle(boolean forcePathStyle) {
            doSetProperty("forcePathStyle", forcePathStyle);
            return this;
        }
        /**
         * Set whether the S3 client should use path-style URL instead of
         * virtual-hosted-style.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Default: false
         * Group: common
         * 
         * @param forcePathStyle the value to set
         * @return the dsl builder
         */
        default AWS2S3EndpointProducerBuilder forcePathStyle(String forcePathStyle) {
            doSetProperty("forcePathStyle", forcePathStyle);
            return this;
        }
        /**
         * Set the need for overriding the endpoint. This option needs to be
         * used in combination with the uriEndpointOverride option.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Default: false
         * Group: common
         * 
         * @param overrideEndpoint the value to set
         * @return the dsl builder
         */
        default AWS2S3EndpointProducerBuilder overrideEndpoint(boolean overrideEndpoint) {
            doSetProperty("overrideEndpoint", overrideEndpoint);
            return this;
        }
        /**
         * Set the need for overriding the endpoint. This option needs to be
         * used in combination with the uriEndpointOverride option.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Default: false
         * Group: common
         * 
         * @param overrideEndpoint the value to set
         * @return the dsl builder
         */
        default AWS2S3EndpointProducerBuilder overrideEndpoint(String overrideEndpoint) {
            doSetProperty("overrideEndpoint", overrideEndpoint);
            return this;
        }
        /**
         * If we want to use a POJO request as body or not.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Default: false
         * Group: common
         * 
         * @param pojoRequest the value to set
         * @return the dsl builder
         */
        default AWS2S3EndpointProducerBuilder pojoRequest(boolean pojoRequest) {
            doSetProperty("pojoRequest", pojoRequest);
            return this;
        }
        /**
         * If we want to use a POJO request as body or not.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Default: false
         * Group: common
         * 
         * @param pojoRequest the value to set
         * @return the dsl builder
         */
        default AWS2S3EndpointProducerBuilder pojoRequest(String pojoRequest) {
            doSetProperty("pojoRequest", pojoRequest);
            return this;
        }
        /**
         * The policy for this queue to set in the
         * com.amazonaws.services.s3.AmazonS3#setBucketPolicy() method.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: common
         * 
         * @param policy the value to set
         * @return the dsl builder
         */
        default AWS2S3EndpointProducerBuilder policy(String policy) {
            doSetProperty("policy", policy);
            return this;
        }
        /**
         * The prefix which is used in the
         * com.amazonaws.services.s3.model.ListObjectsRequest to only consume
         * objects we are interested in.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: common
         * 
         * @param prefix the value to set
         * @return the dsl builder
         */
        default AWS2S3EndpointProducerBuilder prefix(String prefix) {
            doSetProperty("prefix", prefix);
            return this;
        }
        /**
         * The region in which the S3 client needs to work. When using this
         * parameter, the configuration will expect the lowercase name of the
         * region (for example, ap-east-1) You'll need to use the name
         * Region.EU_WEST_1.id().
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: common
         * 
         * @param region the value to set
         * @return the dsl builder
         */
        default AWS2S3EndpointProducerBuilder region(String region) {
            doSetProperty("region", region);
            return this;
        }
        /**
         * Set the overriding uri endpoint. This option needs to be used in
         * combination with overrideEndpoint option.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: common
         * 
         * @param uriEndpointOverride the value to set
         * @return the dsl builder
         */
        default AWS2S3EndpointProducerBuilder uriEndpointOverride(String uriEndpointOverride) {
            doSetProperty("uriEndpointOverride", uriEndpointOverride);
            return this;
        }
        /**
         * The number of messages composing a batch in streaming upload mode.
         * 
         * The option is a: <code>int</code> type.
         * 
         * Default: 10
         * Group: producer
         * 
         * @param batchMessageNumber the value to set
         * @return the dsl builder
         */
        default AWS2S3EndpointProducerBuilder batchMessageNumber(int batchMessageNumber) {
            doSetProperty("batchMessageNumber", batchMessageNumber);
            return this;
        }
        /**
         * The number of messages composing a batch in streaming upload mode.
         * 
         * The option will be converted to a <code>int</code> type.
         * 
         * Default: 10
         * Group: producer
         * 
         * @param batchMessageNumber the value to set
         * @return the dsl builder
         */
        default AWS2S3EndpointProducerBuilder batchMessageNumber(String batchMessageNumber) {
            doSetProperty("batchMessageNumber", batchMessageNumber);
            return this;
        }
        /**
         * The batch size (in bytes) in streaming upload mode.
         * 
         * The option is a: <code>int</code> type.
         * 
         * Default: 1000000
         * Group: producer
         * 
         * @param batchSize the value to set
         * @return the dsl builder
         */
        default AWS2S3EndpointProducerBuilder batchSize(int batchSize) {
            doSetProperty("batchSize", batchSize);
            return this;
        }
        /**
         * The batch size (in bytes) in streaming upload mode.
         * 
         * The option will be converted to a <code>int</code> type.
         * 
         * Default: 1000000
         * Group: producer
         * 
         * @param batchSize the value to set
         * @return the dsl builder
         */
        default AWS2S3EndpointProducerBuilder batchSize(String batchSize) {
            doSetProperty("batchSize", batchSize);
            return this;
        }
        /**
         * The buffer size (in bytes) in streaming upload mode.
         * 
         * The option is a: <code>int</code> type.
         * 
         * Default: 1000000
         * Group: producer
         * 
         * @param bufferSize the value to set
         * @return the dsl builder
         */
        default AWS2S3EndpointProducerBuilder bufferSize(int bufferSize) {
            doSetProperty("bufferSize", bufferSize);
            return this;
        }
        /**
         * The buffer size (in bytes) in streaming upload mode.
         * 
         * The option will be converted to a <code>int</code> type.
         * 
         * Default: 1000000
         * Group: producer
         * 
         * @param bufferSize the value to set
         * @return the dsl builder
         */
        default AWS2S3EndpointProducerBuilder bufferSize(String bufferSize) {
            doSetProperty("bufferSize", bufferSize);
            return this;
        }
        /**
         * Delete file object after the S3 file has been uploaded.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Default: false
         * Group: producer
         * 
         * @param deleteAfterWrite the value to set
         * @return the dsl builder
         */
        default AWS2S3EndpointProducerBuilder deleteAfterWrite(boolean deleteAfterWrite) {
            doSetProperty("deleteAfterWrite", deleteAfterWrite);
            return this;
        }
        /**
         * Delete file object after the S3 file has been uploaded.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Default: false
         * Group: producer
         * 
         * @param deleteAfterWrite the value to set
         * @return the dsl builder
         */
        default AWS2S3EndpointProducerBuilder deleteAfterWrite(String deleteAfterWrite) {
            doSetProperty("deleteAfterWrite", deleteAfterWrite);
            return this;
        }
        /**
         * Setting the key name for an element in the bucket through endpoint
         * parameter.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: producer
         * 
         * @param keyName the value to set
         * @return the dsl builder
         */
        default AWS2S3EndpointProducerBuilder keyName(String keyName) {
            doSetProperty("keyName", keyName);
            return this;
        }
        /**
         * If it is true, camel will upload the file with multipart format. The
         * part size is decided by the partSize option. Camel will only do
         * multipart uploads for files that are larger than the part-size
         * thresholds. Files that are smaller will be uploaded in a single
         * operation.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Default: false
         * Group: producer
         * 
         * @param multiPartUpload the value to set
         * @return the dsl builder
         */
        default AWS2S3EndpointProducerBuilder multiPartUpload(boolean multiPartUpload) {
            doSetProperty("multiPartUpload", multiPartUpload);
            return this;
        }
        /**
         * If it is true, camel will upload the file with multipart format. The
         * part size is decided by the partSize option. Camel will only do
         * multipart uploads for files that are larger than the part-size
         * thresholds. Files that are smaller will be uploaded in a single
         * operation.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Default: false
         * Group: producer
         * 
         * @param multiPartUpload the value to set
         * @return the dsl builder
         */
        default AWS2S3EndpointProducerBuilder multiPartUpload(String multiPartUpload) {
            doSetProperty("multiPartUpload", multiPartUpload);
            return this;
        }
        /**
         * The naming strategy to use in streaming upload mode.
         * 
         * The option is a:
         * <code>org.apache.camel.component.aws2.s3.stream.AWSS3NamingStrategyEnum</code> type.
         * 
         * Default: progressive
         * Group: producer
         * 
         * @param namingStrategy the value to set
         * @return the dsl builder
         */
        default AWS2S3EndpointProducerBuilder namingStrategy(org.apache.camel.component.aws2.s3.stream.AWSS3NamingStrategyEnum namingStrategy) {
            doSetProperty("namingStrategy", namingStrategy);
            return this;
        }
        /**
         * The naming strategy to use in streaming upload mode.
         * 
         * The option will be converted to a
         * <code>org.apache.camel.component.aws2.s3.stream.AWSS3NamingStrategyEnum</code> type.
         * 
         * Default: progressive
         * Group: producer
         * 
         * @param namingStrategy the value to set
         * @return the dsl builder
         */
        default AWS2S3EndpointProducerBuilder namingStrategy(String namingStrategy) {
            doSetProperty("namingStrategy", namingStrategy);
            return this;
        }
        /**
         * The operation to do in case the user don't want to do only an upload.
         * 
         * The option is a:
         * <code>org.apache.camel.component.aws2.s3.AWS2S3Operations</code>
         * type.
         * 
         * Group: producer
         * 
         * @param operation the value to set
         * @return the dsl builder
         */
        default AWS2S3EndpointProducerBuilder operation(org.apache.camel.component.aws2.s3.AWS2S3Operations operation) {
            doSetProperty("operation", operation);
            return this;
        }
        /**
         * The operation to do in case the user don't want to do only an upload.
         * 
         * The option will be converted to a
         * <code>org.apache.camel.component.aws2.s3.AWS2S3Operations</code>
         * type.
         * 
         * Group: producer
         * 
         * @param operation the value to set
         * @return the dsl builder
         */
        default AWS2S3EndpointProducerBuilder operation(String operation) {
            doSetProperty("operation", operation);
            return this;
        }
        /**
         * Set up the partSize which is used in multipart upload, the default
         * size is 25M. Camel will only do multipart uploads for files that are
         * larger than the part-size thresholds. Files that are smaller will be
         * uploaded in a single operation.
         * 
         * The option is a: <code>long</code> type.
         * 
         * Default: 26214400
         * Group: producer
         * 
         * @param partSize the value to set
         * @return the dsl builder
         */
        default AWS2S3EndpointProducerBuilder partSize(long partSize) {
            doSetProperty("partSize", partSize);
            return this;
        }
        /**
         * Set up the partSize which is used in multipart upload, the default
         * size is 25M. Camel will only do multipart uploads for files that are
         * larger than the part-size thresholds. Files that are smaller will be
         * uploaded in a single operation.
         * 
         * The option will be converted to a <code>long</code> type.
         * 
         * Default: 26214400
         * Group: producer
         * 
         * @param partSize the value to set
         * @return the dsl builder
         */
        default AWS2S3EndpointProducerBuilder partSize(String partSize) {
            doSetProperty("partSize", partSize);
            return this;
        }
        /**
         * The restarting policy to use in streaming upload mode.
         * 
         * The option is a:
         * <code>org.apache.camel.component.aws2.s3.stream.AWSS3RestartingPolicyEnum</code> type.
         * 
         * Default: override
         * Group: producer
         * 
         * @param restartingPolicy the value to set
         * @return the dsl builder
         */
        default AWS2S3EndpointProducerBuilder restartingPolicy(org.apache.camel.component.aws2.s3.stream.AWSS3RestartingPolicyEnum restartingPolicy) {
            doSetProperty("restartingPolicy", restartingPolicy);
            return this;
        }
        /**
         * The restarting policy to use in streaming upload mode.
         * 
         * The option will be converted to a
         * <code>org.apache.camel.component.aws2.s3.stream.AWSS3RestartingPolicyEnum</code> type.
         * 
         * Default: override
         * Group: producer
         * 
         * @param restartingPolicy the value to set
         * @return the dsl builder
         */
        default AWS2S3EndpointProducerBuilder restartingPolicy(String restartingPolicy) {
            doSetProperty("restartingPolicy", restartingPolicy);
            return this;
        }
        /**
         * The storage class to set in the
         * com.amazonaws.services.s3.model.PutObjectRequest request.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: producer
         * 
         * @param storageClass the value to set
         * @return the dsl builder
         */
        default AWS2S3EndpointProducerBuilder storageClass(String storageClass) {
            doSetProperty("storageClass", storageClass);
            return this;
        }
        /**
         * When stream mode is true, the upload to bucket will be done in
         * streaming.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Default: false
         * Group: producer
         * 
         * @param streamingUploadMode the value to set
         * @return the dsl builder
         */
        default AWS2S3EndpointProducerBuilder streamingUploadMode(boolean streamingUploadMode) {
            doSetProperty("streamingUploadMode", streamingUploadMode);
            return this;
        }
        /**
         * When stream mode is true, the upload to bucket will be done in
         * streaming.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Default: false
         * Group: producer
         * 
         * @param streamingUploadMode the value to set
         * @return the dsl builder
         */
        default AWS2S3EndpointProducerBuilder streamingUploadMode(String streamingUploadMode) {
            doSetProperty("streamingUploadMode", streamingUploadMode);
            return this;
        }
        /**
         * While streaming upload mode is true, this option set the timeout to
         * complete upload.
         * 
         * The option is a: <code>long</code> type.
         * 
         * Group: producer
         * 
         * @param streamingUploadTimeout the value to set
         * @return the dsl builder
         */
        default AWS2S3EndpointProducerBuilder streamingUploadTimeout(long streamingUploadTimeout) {
            doSetProperty("streamingUploadTimeout", streamingUploadTimeout);
            return this;
        }
        /**
         * While streaming upload mode is true, this option set the timeout to
         * complete upload.
         * 
         * The option will be converted to a <code>long</code> type.
         * 
         * Group: producer
         * 
         * @param streamingUploadTimeout the value to set
         * @return the dsl builder
         */
        default AWS2S3EndpointProducerBuilder streamingUploadTimeout(String streamingUploadTimeout) {
            doSetProperty("streamingUploadTimeout", streamingUploadTimeout);
            return this;
        }
        /**
         * To define a proxy host when instantiating the SQS client.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: proxy
         * 
         * @param proxyHost the value to set
         * @return the dsl builder
         */
        default AWS2S3EndpointProducerBuilder proxyHost(String proxyHost) {
            doSetProperty("proxyHost", proxyHost);
            return this;
        }
        /**
         * Specify a proxy port to be used inside the client definition.
         * 
         * The option is a: <code>java.lang.Integer</code> type.
         * 
         * Group: proxy
         * 
         * @param proxyPort the value to set
         * @return the dsl builder
         */
        default AWS2S3EndpointProducerBuilder proxyPort(Integer proxyPort) {
            doSetProperty("proxyPort", proxyPort);
            return this;
        }
        /**
         * Specify a proxy port to be used inside the client definition.
         * 
         * The option will be converted to a <code>java.lang.Integer</code>
         * type.
         * 
         * Group: proxy
         * 
         * @param proxyPort the value to set
         * @return the dsl builder
         */
        default AWS2S3EndpointProducerBuilder proxyPort(String proxyPort) {
            doSetProperty("proxyPort", proxyPort);
            return this;
        }
        /**
         * To define a proxy protocol when instantiating the S3 client.
         * 
         * The option is a: <code>software.amazon.awssdk.core.Protocol</code>
         * type.
         * 
         * Default: HTTPS
         * Group: proxy
         * 
         * @param proxyProtocol the value to set
         * @return the dsl builder
         */
        default AWS2S3EndpointProducerBuilder proxyProtocol(software.amazon.awssdk.core.Protocol proxyProtocol) {
            doSetProperty("proxyProtocol", proxyProtocol);
            return this;
        }
        /**
         * To define a proxy protocol when instantiating the S3 client.
         * 
         * The option will be converted to a
         * <code>software.amazon.awssdk.core.Protocol</code> type.
         * 
         * Default: HTTPS
         * Group: proxy
         * 
         * @param proxyProtocol the value to set
         * @return the dsl builder
         */
        default AWS2S3EndpointProducerBuilder proxyProtocol(String proxyProtocol) {
            doSetProperty("proxyProtocol", proxyProtocol);
            return this;
        }
        /**
         * Amazon AWS Access Key.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: security
         * 
         * @param accessKey the value to set
         * @return the dsl builder
         */
        default AWS2S3EndpointProducerBuilder accessKey(String accessKey) {
            doSetProperty("accessKey", accessKey);
            return this;
        }
        /**
         * If using a profile credentials provider, this parameter will set the
         * profile name.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: security
         * 
         * @param profileCredentialsName the value to set
         * @return the dsl builder
         */
        default AWS2S3EndpointProducerBuilder profileCredentialsName(String profileCredentialsName) {
            doSetProperty("profileCredentialsName", profileCredentialsName);
            return this;
        }
        /**
         * Amazon AWS Secret Key.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: security
         * 
         * @param secretKey the value to set
         * @return the dsl builder
         */
        default AWS2S3EndpointProducerBuilder secretKey(String secretKey) {
            doSetProperty("secretKey", secretKey);
            return this;
        }
        /**
         * Amazon AWS Session Token used when the user needs to assume an IAM
         * role.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: security
         * 
         * @param sessionToken the value to set
         * @return the dsl builder
         */
        default AWS2S3EndpointProducerBuilder sessionToken(String sessionToken) {
            doSetProperty("sessionToken", sessionToken);
            return this;
        }
        /**
         * If we want to trust all certificates in case of overriding the
         * endpoint.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Default: false
         * Group: security
         * 
         * @param trustAllCertificates the value to set
         * @return the dsl builder
         */
        default AWS2S3EndpointProducerBuilder trustAllCertificates(boolean trustAllCertificates) {
            doSetProperty("trustAllCertificates", trustAllCertificates);
            return this;
        }
        /**
         * If we want to trust all certificates in case of overriding the
         * endpoint.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Default: false
         * Group: security
         * 
         * @param trustAllCertificates the value to set
         * @return the dsl builder
         */
        default AWS2S3EndpointProducerBuilder trustAllCertificates(String trustAllCertificates) {
            doSetProperty("trustAllCertificates", trustAllCertificates);
            return this;
        }
        /**
         * Set whether the S3 client should expect to load credentials through a
         * default credentials provider.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Default: false
         * Group: security
         * 
         * @param useDefaultCredentialsProvider the value to set
         * @return the dsl builder
         */
        default AWS2S3EndpointProducerBuilder useDefaultCredentialsProvider(boolean useDefaultCredentialsProvider) {
            doSetProperty("useDefaultCredentialsProvider", useDefaultCredentialsProvider);
            return this;
        }
        /**
         * Set whether the S3 client should expect to load credentials through a
         * default credentials provider.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Default: false
         * Group: security
         * 
         * @param useDefaultCredentialsProvider the value to set
         * @return the dsl builder
         */
        default AWS2S3EndpointProducerBuilder useDefaultCredentialsProvider(String useDefaultCredentialsProvider) {
            doSetProperty("useDefaultCredentialsProvider", useDefaultCredentialsProvider);
            return this;
        }
        /**
         * Set whether the S3 client should expect to load credentials through a
         * profile credentials provider.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Default: false
         * Group: security
         * 
         * @param useProfileCredentialsProvider the value to set
         * @return the dsl builder
         */
        default AWS2S3EndpointProducerBuilder useProfileCredentialsProvider(boolean useProfileCredentialsProvider) {
            doSetProperty("useProfileCredentialsProvider", useProfileCredentialsProvider);
            return this;
        }
        /**
         * Set whether the S3 client should expect to load credentials through a
         * profile credentials provider.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Default: false
         * Group: security
         * 
         * @param useProfileCredentialsProvider the value to set
         * @return the dsl builder
         */
        default AWS2S3EndpointProducerBuilder useProfileCredentialsProvider(String useProfileCredentialsProvider) {
            doSetProperty("useProfileCredentialsProvider", useProfileCredentialsProvider);
            return this;
        }
        /**
         * Set whether the S3 client should expect to use Session Credentials.
         * This is useful in a situation in which the user needs to assume an
         * IAM role for doing operations in S3.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Default: false
         * Group: security
         * 
         * @param useSessionCredentials the value to set
         * @return the dsl builder
         */
        default AWS2S3EndpointProducerBuilder useSessionCredentials(boolean useSessionCredentials) {
            doSetProperty("useSessionCredentials", useSessionCredentials);
            return this;
        }
        /**
         * Set whether the S3 client should expect to use Session Credentials.
         * This is useful in a situation in which the user needs to assume an
         * IAM role for doing operations in S3.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Default: false
         * Group: security
         * 
         * @param useSessionCredentials the value to set
         * @return the dsl builder
         */
        default AWS2S3EndpointProducerBuilder useSessionCredentials(String useSessionCredentials) {
            doSetProperty("useSessionCredentials", useSessionCredentials);
            return this;
        }
    }

    /**
     * Advanced builder for endpoint producers for the AWS S3 Storage Service component.
     */
    public interface AdvancedAWS2S3EndpointProducerBuilder extends EndpointProducerBuilder {
        default AWS2S3EndpointProducerBuilder basic() {
            return (AWS2S3EndpointProducerBuilder) this;
        }

        /**
         * Define the customer algorithm to use in case CustomerKey is enabled.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: common (advanced)
         * 
         * @param customerAlgorithm the value to set
         * @return the dsl builder
         */
        default AdvancedAWS2S3EndpointProducerBuilder customerAlgorithm(String customerAlgorithm) {
            doSetProperty("customerAlgorithm", customerAlgorithm);
            return this;
        }
        /**
         * Define the id of the Customer key to use in case CustomerKey is
         * enabled.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: common (advanced)
         * 
         * @param customerKeyId the value to set
         * @return the dsl builder
         */
        default AdvancedAWS2S3EndpointProducerBuilder customerKeyId(String customerKeyId) {
            doSetProperty("customerKeyId", customerKeyId);
            return this;
        }
        /**
         * Define the MD5 of Customer key to use in case CustomerKey is enabled.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: common (advanced)
         * 
         * @param customerKeyMD5 the value to set
         * @return the dsl builder
         */
        default AdvancedAWS2S3EndpointProducerBuilder customerKeyMD5(String customerKeyMD5) {
            doSetProperty("customerKeyMD5", customerKeyMD5);
            return this;
        }
        /**
         * Define the id of KMS key to use in case KMS is enabled.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: producer (advanced)
         * 
         * @param awsKMSKeyId the value to set
         * @return the dsl builder
         */
        default AdvancedAWS2S3EndpointProducerBuilder awsKMSKeyId(String awsKMSKeyId) {
            doSetProperty("awsKMSKeyId", awsKMSKeyId);
            return this;
        }
        /**
         * Whether the producer should be started lazy (on the first message).
         * By starting lazy you can use this to allow CamelContext and routes to
         * startup in situations where a producer may otherwise fail during
         * starting and cause the route to fail being started. By deferring this
         * startup to be lazy then the startup failure can be handled during
         * routing messages via Camel's routing error handlers. Beware that when
         * the first message is processed then creating and starting the
         * producer may take a little time and prolong the total processing time
         * of the processing.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Default: false
         * Group: producer (advanced)
         * 
         * @param lazyStartProducer the value to set
         * @return the dsl builder
         */
        default AdvancedAWS2S3EndpointProducerBuilder lazyStartProducer(boolean lazyStartProducer) {
            doSetProperty("lazyStartProducer", lazyStartProducer);
            return this;
        }
        /**
         * Whether the producer should be started lazy (on the first message).
         * By starting lazy you can use this to allow CamelContext and routes to
         * startup in situations where a producer may otherwise fail during
         * starting and cause the route to fail being started. By deferring this
         * startup to be lazy then the startup failure can be handled during
         * routing messages via Camel's routing error handlers. Beware that when
         * the first message is processed then creating and starting the
         * producer may take a little time and prolong the total processing time
         * of the processing.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Default: false
         * Group: producer (advanced)
         * 
         * @param lazyStartProducer the value to set
         * @return the dsl builder
         */
        default AdvancedAWS2S3EndpointProducerBuilder lazyStartProducer(String lazyStartProducer) {
            doSetProperty("lazyStartProducer", lazyStartProducer);
            return this;
        }
        /**
         * Define if KMS must be used or not.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Default: false
         * Group: producer (advanced)
         * 
         * @param useAwsKMS the value to set
         * @return the dsl builder
         */
        default AdvancedAWS2S3EndpointProducerBuilder useAwsKMS(boolean useAwsKMS) {
            doSetProperty("useAwsKMS", useAwsKMS);
            return this;
        }
        /**
         * Define if KMS must be used or not.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Default: false
         * Group: producer (advanced)
         * 
         * @param useAwsKMS the value to set
         * @return the dsl builder
         */
        default AdvancedAWS2S3EndpointProducerBuilder useAwsKMS(String useAwsKMS) {
            doSetProperty("useAwsKMS", useAwsKMS);
            return this;
        }
        /**
         * Define if Customer Key must be used or not.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Default: false
         * Group: producer (advanced)
         * 
         * @param useCustomerKey the value to set
         * @return the dsl builder
         */
        default AdvancedAWS2S3EndpointProducerBuilder useCustomerKey(boolean useCustomerKey) {
            doSetProperty("useCustomerKey", useCustomerKey);
            return this;
        }
        /**
         * Define if Customer Key must be used or not.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Default: false
         * Group: producer (advanced)
         * 
         * @param useCustomerKey the value to set
         * @return the dsl builder
         */
        default AdvancedAWS2S3EndpointProducerBuilder useCustomerKey(String useCustomerKey) {
            doSetProperty("useCustomerKey", useCustomerKey);
            return this;
        }
        /**
         * Define if SSE S3 must be used or not.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Default: false
         * Group: producer (advanced)
         * 
         * @param useSSES3 the value to set
         * @return the dsl builder
         */
        default AdvancedAWS2S3EndpointProducerBuilder useSSES3(boolean useSSES3) {
            doSetProperty("useSSES3", useSSES3);
            return this;
        }
        /**
         * Define if SSE S3 must be used or not.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Default: false
         * Group: producer (advanced)
         * 
         * @param useSSES3 the value to set
         * @return the dsl builder
         */
        default AdvancedAWS2S3EndpointProducerBuilder useSSES3(String useSSES3) {
            doSetProperty("useSSES3", useSSES3);
            return this;
        }
        /**
         * Reference to a com.amazonaws.services.s3.AmazonS3 in the registry.
         * 
         * The option is a:
         * <code>software.amazon.awssdk.services.s3.S3Client</code> type.
         * 
         * Group: advanced
         * 
         * @param amazonS3Client the value to set
         * @return the dsl builder
         */
        default AdvancedAWS2S3EndpointProducerBuilder amazonS3Client(software.amazon.awssdk.services.s3.S3Client amazonS3Client) {
            doSetProperty("amazonS3Client", amazonS3Client);
            return this;
        }
        /**
         * Reference to a com.amazonaws.services.s3.AmazonS3 in the registry.
         * 
         * The option will be converted to a
         * <code>software.amazon.awssdk.services.s3.S3Client</code> type.
         * 
         * Group: advanced
         * 
         * @param amazonS3Client the value to set
         * @return the dsl builder
         */
        default AdvancedAWS2S3EndpointProducerBuilder amazonS3Client(String amazonS3Client) {
            doSetProperty("amazonS3Client", amazonS3Client);
            return this;
        }
        /**
         * An S3 Presigner for Request, used mainly in createDownloadLink
         * operation.
         * 
         * The option is a:
         * <code>software.amazon.awssdk.services.s3.presigner.S3Presigner</code>
         * type.
         * 
         * Group: advanced
         * 
         * @param amazonS3Presigner the value to set
         * @return the dsl builder
         */
        default AdvancedAWS2S3EndpointProducerBuilder amazonS3Presigner(software.amazon.awssdk.services.s3.presigner.S3Presigner amazonS3Presigner) {
            doSetProperty("amazonS3Presigner", amazonS3Presigner);
            return this;
        }
        /**
         * An S3 Presigner for Request, used mainly in createDownloadLink
         * operation.
         * 
         * The option will be converted to a
         * <code>software.amazon.awssdk.services.s3.presigner.S3Presigner</code>
         * type.
         * 
         * Group: advanced
         * 
         * @param amazonS3Presigner the value to set
         * @return the dsl builder
         */
        default AdvancedAWS2S3EndpointProducerBuilder amazonS3Presigner(String amazonS3Presigner) {
            doSetProperty("amazonS3Presigner", amazonS3Presigner);
            return this;
        }
    }

    /**
     * Builder for endpoint for the AWS S3 Storage Service component.
     */
    public interface AWS2S3EndpointBuilder
            extends
                AWS2S3EndpointConsumerBuilder,
                AWS2S3EndpointProducerBuilder {
        default AdvancedAWS2S3EndpointBuilder advanced() {
            return (AdvancedAWS2S3EndpointBuilder) this;
        }

        /**
         * Setting the autocreation of the S3 bucket bucketName. This will apply
         * also in case of moveAfterRead option enabled, and it will create the
         * destinationBucket if it doesn't exist already.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Default: false
         * Group: common
         * 
         * @param autoCreateBucket the value to set
         * @return the dsl builder
         */
        default AWS2S3EndpointBuilder autoCreateBucket(boolean autoCreateBucket) {
            doSetProperty("autoCreateBucket", autoCreateBucket);
            return this;
        }
        /**
         * Setting the autocreation of the S3 bucket bucketName. This will apply
         * also in case of moveAfterRead option enabled, and it will create the
         * destinationBucket if it doesn't exist already.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Default: false
         * Group: common
         * 
         * @param autoCreateBucket the value to set
         * @return the dsl builder
         */
        default AWS2S3EndpointBuilder autoCreateBucket(String autoCreateBucket) {
            doSetProperty("autoCreateBucket", autoCreateBucket);
            return this;
        }
        /**
         * The delimiter which is used in the
         * com.amazonaws.services.s3.model.ListObjectsRequest to only consume
         * objects we are interested in.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: common
         * 
         * @param delimiter the value to set
         * @return the dsl builder
         */
        default AWS2S3EndpointBuilder delimiter(String delimiter) {
            doSetProperty("delimiter", delimiter);
            return this;
        }
        /**
         * Set whether the S3 client should use path-style URL instead of
         * virtual-hosted-style.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Default: false
         * Group: common
         * 
         * @param forcePathStyle the value to set
         * @return the dsl builder
         */
        default AWS2S3EndpointBuilder forcePathStyle(boolean forcePathStyle) {
            doSetProperty("forcePathStyle", forcePathStyle);
            return this;
        }
        /**
         * Set whether the S3 client should use path-style URL instead of
         * virtual-hosted-style.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Default: false
         * Group: common
         * 
         * @param forcePathStyle the value to set
         * @return the dsl builder
         */
        default AWS2S3EndpointBuilder forcePathStyle(String forcePathStyle) {
            doSetProperty("forcePathStyle", forcePathStyle);
            return this;
        }
        /**
         * Set the need for overriding the endpoint. This option needs to be
         * used in combination with the uriEndpointOverride option.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Default: false
         * Group: common
         * 
         * @param overrideEndpoint the value to set
         * @return the dsl builder
         */
        default AWS2S3EndpointBuilder overrideEndpoint(boolean overrideEndpoint) {
            doSetProperty("overrideEndpoint", overrideEndpoint);
            return this;
        }
        /**
         * Set the need for overriding the endpoint. This option needs to be
         * used in combination with the uriEndpointOverride option.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Default: false
         * Group: common
         * 
         * @param overrideEndpoint the value to set
         * @return the dsl builder
         */
        default AWS2S3EndpointBuilder overrideEndpoint(String overrideEndpoint) {
            doSetProperty("overrideEndpoint", overrideEndpoint);
            return this;
        }
        /**
         * If we want to use a POJO request as body or not.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Default: false
         * Group: common
         * 
         * @param pojoRequest the value to set
         * @return the dsl builder
         */
        default AWS2S3EndpointBuilder pojoRequest(boolean pojoRequest) {
            doSetProperty("pojoRequest", pojoRequest);
            return this;
        }
        /**
         * If we want to use a POJO request as body or not.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Default: false
         * Group: common
         * 
         * @param pojoRequest the value to set
         * @return the dsl builder
         */
        default AWS2S3EndpointBuilder pojoRequest(String pojoRequest) {
            doSetProperty("pojoRequest", pojoRequest);
            return this;
        }
        /**
         * The policy for this queue to set in the
         * com.amazonaws.services.s3.AmazonS3#setBucketPolicy() method.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: common
         * 
         * @param policy the value to set
         * @return the dsl builder
         */
        default AWS2S3EndpointBuilder policy(String policy) {
            doSetProperty("policy", policy);
            return this;
        }
        /**
         * The prefix which is used in the
         * com.amazonaws.services.s3.model.ListObjectsRequest to only consume
         * objects we are interested in.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: common
         * 
         * @param prefix the value to set
         * @return the dsl builder
         */
        default AWS2S3EndpointBuilder prefix(String prefix) {
            doSetProperty("prefix", prefix);
            return this;
        }
        /**
         * The region in which the S3 client needs to work. When using this
         * parameter, the configuration will expect the lowercase name of the
         * region (for example, ap-east-1) You'll need to use the name
         * Region.EU_WEST_1.id().
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: common
         * 
         * @param region the value to set
         * @return the dsl builder
         */
        default AWS2S3EndpointBuilder region(String region) {
            doSetProperty("region", region);
            return this;
        }
        /**
         * Set the overriding uri endpoint. This option needs to be used in
         * combination with overrideEndpoint option.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: common
         * 
         * @param uriEndpointOverride the value to set
         * @return the dsl builder
         */
        default AWS2S3EndpointBuilder uriEndpointOverride(String uriEndpointOverride) {
            doSetProperty("uriEndpointOverride", uriEndpointOverride);
            return this;
        }
        /**
         * To define a proxy host when instantiating the SQS client.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: proxy
         * 
         * @param proxyHost the value to set
         * @return the dsl builder
         */
        default AWS2S3EndpointBuilder proxyHost(String proxyHost) {
            doSetProperty("proxyHost", proxyHost);
            return this;
        }
        /**
         * Specify a proxy port to be used inside the client definition.
         * 
         * The option is a: <code>java.lang.Integer</code> type.
         * 
         * Group: proxy
         * 
         * @param proxyPort the value to set
         * @return the dsl builder
         */
        default AWS2S3EndpointBuilder proxyPort(Integer proxyPort) {
            doSetProperty("proxyPort", proxyPort);
            return this;
        }
        /**
         * Specify a proxy port to be used inside the client definition.
         * 
         * The option will be converted to a <code>java.lang.Integer</code>
         * type.
         * 
         * Group: proxy
         * 
         * @param proxyPort the value to set
         * @return the dsl builder
         */
        default AWS2S3EndpointBuilder proxyPort(String proxyPort) {
            doSetProperty("proxyPort", proxyPort);
            return this;
        }
        /**
         * To define a proxy protocol when instantiating the S3 client.
         * 
         * The option is a: <code>software.amazon.awssdk.core.Protocol</code>
         * type.
         * 
         * Default: HTTPS
         * Group: proxy
         * 
         * @param proxyProtocol the value to set
         * @return the dsl builder
         */
        default AWS2S3EndpointBuilder proxyProtocol(software.amazon.awssdk.core.Protocol proxyProtocol) {
            doSetProperty("proxyProtocol", proxyProtocol);
            return this;
        }
        /**
         * To define a proxy protocol when instantiating the S3 client.
         * 
         * The option will be converted to a
         * <code>software.amazon.awssdk.core.Protocol</code> type.
         * 
         * Default: HTTPS
         * Group: proxy
         * 
         * @param proxyProtocol the value to set
         * @return the dsl builder
         */
        default AWS2S3EndpointBuilder proxyProtocol(String proxyProtocol) {
            doSetProperty("proxyProtocol", proxyProtocol);
            return this;
        }
        /**
         * Amazon AWS Access Key.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: security
         * 
         * @param accessKey the value to set
         * @return the dsl builder
         */
        default AWS2S3EndpointBuilder accessKey(String accessKey) {
            doSetProperty("accessKey", accessKey);
            return this;
        }
        /**
         * If using a profile credentials provider, this parameter will set the
         * profile name.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: security
         * 
         * @param profileCredentialsName the value to set
         * @return the dsl builder
         */
        default AWS2S3EndpointBuilder profileCredentialsName(String profileCredentialsName) {
            doSetProperty("profileCredentialsName", profileCredentialsName);
            return this;
        }
        /**
         * Amazon AWS Secret Key.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: security
         * 
         * @param secretKey the value to set
         * @return the dsl builder
         */
        default AWS2S3EndpointBuilder secretKey(String secretKey) {
            doSetProperty("secretKey", secretKey);
            return this;
        }
        /**
         * Amazon AWS Session Token used when the user needs to assume an IAM
         * role.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: security
         * 
         * @param sessionToken the value to set
         * @return the dsl builder
         */
        default AWS2S3EndpointBuilder sessionToken(String sessionToken) {
            doSetProperty("sessionToken", sessionToken);
            return this;
        }
        /**
         * If we want to trust all certificates in case of overriding the
         * endpoint.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Default: false
         * Group: security
         * 
         * @param trustAllCertificates the value to set
         * @return the dsl builder
         */
        default AWS2S3EndpointBuilder trustAllCertificates(boolean trustAllCertificates) {
            doSetProperty("trustAllCertificates", trustAllCertificates);
            return this;
        }
        /**
         * If we want to trust all certificates in case of overriding the
         * endpoint.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Default: false
         * Group: security
         * 
         * @param trustAllCertificates the value to set
         * @return the dsl builder
         */
        default AWS2S3EndpointBuilder trustAllCertificates(String trustAllCertificates) {
            doSetProperty("trustAllCertificates", trustAllCertificates);
            return this;
        }
        /**
         * Set whether the S3 client should expect to load credentials through a
         * default credentials provider.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Default: false
         * Group: security
         * 
         * @param useDefaultCredentialsProvider the value to set
         * @return the dsl builder
         */
        default AWS2S3EndpointBuilder useDefaultCredentialsProvider(boolean useDefaultCredentialsProvider) {
            doSetProperty("useDefaultCredentialsProvider", useDefaultCredentialsProvider);
            return this;
        }
        /**
         * Set whether the S3 client should expect to load credentials through a
         * default credentials provider.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Default: false
         * Group: security
         * 
         * @param useDefaultCredentialsProvider the value to set
         * @return the dsl builder
         */
        default AWS2S3EndpointBuilder useDefaultCredentialsProvider(String useDefaultCredentialsProvider) {
            doSetProperty("useDefaultCredentialsProvider", useDefaultCredentialsProvider);
            return this;
        }
        /**
         * Set whether the S3 client should expect to load credentials through a
         * profile credentials provider.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Default: false
         * Group: security
         * 
         * @param useProfileCredentialsProvider the value to set
         * @return the dsl builder
         */
        default AWS2S3EndpointBuilder useProfileCredentialsProvider(boolean useProfileCredentialsProvider) {
            doSetProperty("useProfileCredentialsProvider", useProfileCredentialsProvider);
            return this;
        }
        /**
         * Set whether the S3 client should expect to load credentials through a
         * profile credentials provider.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Default: false
         * Group: security
         * 
         * @param useProfileCredentialsProvider the value to set
         * @return the dsl builder
         */
        default AWS2S3EndpointBuilder useProfileCredentialsProvider(String useProfileCredentialsProvider) {
            doSetProperty("useProfileCredentialsProvider", useProfileCredentialsProvider);
            return this;
        }
        /**
         * Set whether the S3 client should expect to use Session Credentials.
         * This is useful in a situation in which the user needs to assume an
         * IAM role for doing operations in S3.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Default: false
         * Group: security
         * 
         * @param useSessionCredentials the value to set
         * @return the dsl builder
         */
        default AWS2S3EndpointBuilder useSessionCredentials(boolean useSessionCredentials) {
            doSetProperty("useSessionCredentials", useSessionCredentials);
            return this;
        }
        /**
         * Set whether the S3 client should expect to use Session Credentials.
         * This is useful in a situation in which the user needs to assume an
         * IAM role for doing operations in S3.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Default: false
         * Group: security
         * 
         * @param useSessionCredentials the value to set
         * @return the dsl builder
         */
        default AWS2S3EndpointBuilder useSessionCredentials(String useSessionCredentials) {
            doSetProperty("useSessionCredentials", useSessionCredentials);
            return this;
        }
    }

    /**
     * Advanced builder for endpoint for the AWS S3 Storage Service component.
     */
    public interface AdvancedAWS2S3EndpointBuilder
            extends
                AdvancedAWS2S3EndpointConsumerBuilder,
                AdvancedAWS2S3EndpointProducerBuilder {
        default AWS2S3EndpointBuilder basic() {
            return (AWS2S3EndpointBuilder) this;
        }

        /**
         * Define the customer algorithm to use in case CustomerKey is enabled.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: common (advanced)
         * 
         * @param customerAlgorithm the value to set
         * @return the dsl builder
         */
        default AdvancedAWS2S3EndpointBuilder customerAlgorithm(String customerAlgorithm) {
            doSetProperty("customerAlgorithm", customerAlgorithm);
            return this;
        }
        /**
         * Define the id of the Customer key to use in case CustomerKey is
         * enabled.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: common (advanced)
         * 
         * @param customerKeyId the value to set
         * @return the dsl builder
         */
        default AdvancedAWS2S3EndpointBuilder customerKeyId(String customerKeyId) {
            doSetProperty("customerKeyId", customerKeyId);
            return this;
        }
        /**
         * Define the MD5 of Customer key to use in case CustomerKey is enabled.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: common (advanced)
         * 
         * @param customerKeyMD5 the value to set
         * @return the dsl builder
         */
        default AdvancedAWS2S3EndpointBuilder customerKeyMD5(String customerKeyMD5) {
            doSetProperty("customerKeyMD5", customerKeyMD5);
            return this;
        }
        /**
         * Reference to a com.amazonaws.services.s3.AmazonS3 in the registry.
         * 
         * The option is a:
         * <code>software.amazon.awssdk.services.s3.S3Client</code> type.
         * 
         * Group: advanced
         * 
         * @param amazonS3Client the value to set
         * @return the dsl builder
         */
        default AdvancedAWS2S3EndpointBuilder amazonS3Client(software.amazon.awssdk.services.s3.S3Client amazonS3Client) {
            doSetProperty("amazonS3Client", amazonS3Client);
            return this;
        }
        /**
         * Reference to a com.amazonaws.services.s3.AmazonS3 in the registry.
         * 
         * The option will be converted to a
         * <code>software.amazon.awssdk.services.s3.S3Client</code> type.
         * 
         * Group: advanced
         * 
         * @param amazonS3Client the value to set
         * @return the dsl builder
         */
        default AdvancedAWS2S3EndpointBuilder amazonS3Client(String amazonS3Client) {
            doSetProperty("amazonS3Client", amazonS3Client);
            return this;
        }
        /**
         * An S3 Presigner for Request, used mainly in createDownloadLink
         * operation.
         * 
         * The option is a:
         * <code>software.amazon.awssdk.services.s3.presigner.S3Presigner</code>
         * type.
         * 
         * Group: advanced
         * 
         * @param amazonS3Presigner the value to set
         * @return the dsl builder
         */
        default AdvancedAWS2S3EndpointBuilder amazonS3Presigner(software.amazon.awssdk.services.s3.presigner.S3Presigner amazonS3Presigner) {
            doSetProperty("amazonS3Presigner", amazonS3Presigner);
            return this;
        }
        /**
         * An S3 Presigner for Request, used mainly in createDownloadLink
         * operation.
         * 
         * The option will be converted to a
         * <code>software.amazon.awssdk.services.s3.presigner.S3Presigner</code>
         * type.
         * 
         * Group: advanced
         * 
         * @param amazonS3Presigner the value to set
         * @return the dsl builder
         */
        default AdvancedAWS2S3EndpointBuilder amazonS3Presigner(String amazonS3Presigner) {
            doSetProperty("amazonS3Presigner", amazonS3Presigner);
            return this;
        }
    }

    public interface AWS2S3Builders {
        /**
         * AWS S3 Storage Service (camel-aws2-s3)
         * Store and retrieve objects from AWS S3 Storage Service.
         * 
         * Category: cloud,file
         * Since: 3.2
         * Maven coordinates: org.apache.camel:camel-aws2-s3
         * 
         * @return the dsl builder for the headers' name.
         */
        default AWS2S3HeaderNameBuilder aws2S3() {
            return AWS2S3HeaderNameBuilder.INSTANCE;
        }
        /**
         * AWS S3 Storage Service (camel-aws2-s3)
         * Store and retrieve objects from AWS S3 Storage Service.
         * 
         * Category: cloud,file
         * Since: 3.2
         * Maven coordinates: org.apache.camel:camel-aws2-s3
         * 
         * Syntax: <code>aws2-s3://bucketNameOrArn</code>
         * 
         * Path parameter: bucketNameOrArn (required)
         * Bucket name or ARN
         * 
         * @param path bucketNameOrArn
         * @return the dsl builder
         */
        default AWS2S3EndpointBuilder aws2S3(String path) {
            return AWS2S3EndpointBuilderFactory.endpointBuilder("aws2-s3", path);
        }
        /**
         * AWS S3 Storage Service (camel-aws2-s3)
         * Store and retrieve objects from AWS S3 Storage Service.
         * 
         * Category: cloud,file
         * Since: 3.2
         * Maven coordinates: org.apache.camel:camel-aws2-s3
         * 
         * Syntax: <code>aws2-s3://bucketNameOrArn</code>
         * 
         * Path parameter: bucketNameOrArn (required)
         * Bucket name or ARN
         * 
         * @param componentName to use a custom component name for the endpoint
         * instead of the default name
         * @param path bucketNameOrArn
         * @return the dsl builder
         */
        default AWS2S3EndpointBuilder aws2S3(String componentName, String path) {
            return AWS2S3EndpointBuilderFactory.endpointBuilder(componentName, path);
        }

    }
    /**
     * The builder of headers' name for the AWS S3 Storage Service component.
     */
    public static class AWS2S3HeaderNameBuilder {
        /**
         * The internal instance of the builder used to access to all the
         * methods representing the name of headers.
         */
        private static final AWS2S3HeaderNameBuilder INSTANCE = new AWS2S3HeaderNameBuilder();

        /**
         * The bucket Name which this object will be stored or which will be
         * used for the current operation or in which this object is contained.
         * 
         * The option is a: {@code String} type.
         * 
         * Group: common
         * 
         * @return the name of the header {@code AwsS3BucketName}.
         */
        public String awsS3BucketName() {
            return "CamelAwsS3BucketName";
        }
        /**
         * The bucket Destination Name which will be used for the current
         * operation.
         * 
         * The option is a: {@code String} type.
         * 
         * Group: producer
         * 
         * @return the name of the header {@code AwsS3BucketDestinationName}.
         */
        public String awsS3BucketDestinationName() {
            return "CamelAwsS3BucketDestinationName";
        }
        /**
         * The optional Cache-Control HTTP header which allows the user to
         * specify caching behavior along the HTTP request/reply chain.
         * 
         * The option is a: {@code String} type.
         * 
         * Group: common
         * 
         * @return the name of the header {@code AwsS3ContentControl}.
         */
        public String awsS3ContentControl() {
            return "CamelAwsS3ContentControl";
        }
        /**
         * The optional Content-Disposition HTTP header, which specifies
         * presentational information such as the recommended filename for the
         * object to be saved as.
         * 
         * The option is a: {@code String} type.
         * 
         * Group: common
         * 
         * @return the name of the header {@code AwsS3ContentDisposition}.
         */
        public String awsS3ContentDisposition() {
            return "CamelAwsS3ContentDisposition";
        }
        /**
         * The optional Content-Encoding HTTP header specifying what content
         * encodings have been applied to the object and what decoding
         * mechanisms must be applied in order to obtain the media-type
         * referenced by the Content-Type field.
         * 
         * The option is a: {@code String} type.
         * 
         * Group: common
         * 
         * @return the name of the header {@code AwsS3ContentEncoding}.
         */
        public String awsS3ContentEncoding() {
            return "CamelAwsS3ContentEncoding";
        }
        /**
         * The Content-Length HTTP header indicating the size of the associated
         * object in bytes.
         * 
         * The option is a: {@code Long} type.
         * 
         * Group: common
         * 
         * @return the name of the header {@code AwsS3ContentLength}.
         */
        public String awsS3ContentLength() {
            return "CamelAwsS3ContentLength";
        }
        /**
         * The base64 encoded 128-bit MD5 digest of the associated object
         * (content - not including headers) according to RFC 1864. This data is
         * used as a message integrity check to verify that the data received by
         * Amazon S3 is the same data that the caller sent.
         * 
         * The option is a: {@code String} type.
         * 
         * Group: common
         * 
         * @return the name of the header {@code AwsS3ContentMD5}.
         */
        public String awsS3ContentMD5() {
            return "CamelAwsS3ContentMD5";
        }
        /**
         * The Content-Type HTTP header, which indicates the type of content
         * stored in the associated object. The value of this header is a
         * standard MIME type.
         * 
         * The option is a: {@code String} type.
         * 
         * Group: common
         * 
         * @return the name of the header {@code AwsS3ContentType}.
         */
        public String awsS3ContentType() {
            return "CamelAwsS3ContentType";
        }
        /**
         * (producer) The ETag value for the newly uploaded object. (consumer)
         * The hex encoded 128-bit MD5 digest of the associated object according
         * to RFC 1864. This data is used as an integrity check to verify that
         * the data received by the caller is the same data that was sent by
         * Amazon S3.
         * 
         * The option is a: {@code String} type.
         * 
         * Group: common
         * 
         * @return the name of the header {@code AwsS3ETag}.
         */
        public String awsS3ETag() {
            return "CamelAwsS3ETag";
        }
        /**
         * The key under which this object is stored or will be stored or which
         * will be used for the current operation.
         * 
         * The option is a: {@code String} type.
         * 
         * Group: common
         * 
         * @return the name of the header {@code AwsS3Key}.
         */
        public String awsS3Key() {
            return "CamelAwsS3Key";
        }
        /**
         * The Destination key which will be used for the current operation.
         * 
         * The option is a: {@code String} type.
         * 
         * Group: producer
         * 
         * @return the name of the header {@code AwsS3DestinationKey}.
         */
        public String awsS3DestinationKey() {
            return "CamelAwsS3DestinationKey";
        }
        /**
         * The value of the Last-Modified header, indicating the date and time
         * at which Amazon S3 last recorded a modification to the associated
         * object.
         * 
         * The option is a: {@code Date} type.
         * 
         * Group: common
         * 
         * @return the name of the header {@code AwsS3LastModified}.
         */
        public String awsS3LastModified() {
            return "CamelAwsS3LastModified";
        }
        /**
         * The storage class of this object.
         * 
         * The option is a: {@code String} type.
         * 
         * Group: common
         * 
         * @return the name of the header {@code AwsS3StorageClass}.
         */
        public String awsS3StorageClass() {
            return "CamelAwsS3StorageClass";
        }
        /**
         * (producer) The optional version ID of the newly uploaded object.
         * (consumer) The version ID of the associated Amazon S3 object if
         * available. Version IDs are only assigned to objects when an object is
         * uploaded to an Amazon S3 bucket that has object versioning enabled.
         * 
         * The option is a: {@code String} type.
         * 
         * Group: common
         * 
         * @return the name of the header {@code AwsS3VersionId}.
         */
        public String awsS3VersionId() {
            return "CamelAwsS3VersionId";
        }
        /**
         * The canned acl that will be applied to the object. see
         * software.amazon.awssdk.services.s3.model.ObjectCannedACL for allowed
         * values.
         * 
         * The option is a: {@code String} type.
         * 
         * Group: producer
         * 
         * @return the name of the header {@code AwsS3CannedAcl}.
         */
        public String awsS3CannedAcl() {
            return "CamelAwsS3CannedAcl";
        }
        /**
         * A well constructed Amazon S3 Access Control List object.
         * 
         * The option is a: {@code
         * software.amazon.awssdk.services.s3.model.BucketCannedACL} type.
         * 
         * Group: producer
         * 
         * @return the name of the header {@code AwsS3Acl}.
         */
        public String awsS3Acl() {
            return "CamelAwsS3Acl";
        }
        /**
         * The operation to perform. Permitted values are copyObject,
         * deleteObject, listBuckets, deleteBucket, listObjects.
         * 
         * The option is a: {@code String} type.
         * 
         * Group: common
         * 
         * @return the name of the header {@code AwsS3Operation}.
         */
        public String awsS3Operation() {
            return "CamelAwsS3Operation";
        }
        /**
         * Sets the server-side encryption algorithm when encrypting the object
         * using AWS-managed keys. For example use AES256.
         * 
         * The option is a: {@code String} type.
         * 
         * Group: common
         * 
         * @return the name of the header {@code AwsS3ServerSideEncryption}.
         */
        public String awsS3ServerSideEncryption() {
            return "CamelAwsS3ServerSideEncryption";
        }
        /**
         * If the object expiration is configured (see PUT Bucket lifecycle),
         * the response includes this header.
         * 
         * The option is a: {@code String} type.
         * 
         * Group: consumer
         * 
         * @return the name of the header {@code AwsS3ExpirationTime}.
         */
        public String awsS3ExpirationTime() {
            return "CamelAwsS3ExpirationTime";
        }
        /**
         * Amazon S3 can return this if your request involves a bucket that is
         * either a source or destination in a replication rule.
         * 
         * The option is a: {@code
         * software.amazon.awssdk.services.s3.model.ReplicationStatus} type.
         * 
         * Group: consumer
         * 
         * @return the name of the header {@code AwsS3ReplicationStatus}.
         */
        public String awsS3ReplicationStatus() {
            return "CamelAwsS3ReplicationStatus";
        }
        /**
         * The position of the first byte to get.
         * 
         * The option is a: {@code String} type.
         * 
         * Group: producer
         * 
         * @return the name of the header {@code AwsS3RangeStart}.
         */
        public String awsS3RangeStart() {
            return "CamelAwsS3RangeStart";
        }
        /**
         * The position of the last byte to get.
         * 
         * The option is a: {@code String} type.
         * 
         * Group: producer
         * 
         * @return the name of the header {@code AwsS3RangeEnd}.
         */
        public String awsS3RangeEnd() {
            return "CamelAwsS3RangeEnd";
        }
        /**
         * The expiration time of the download link in milliseconds.
         * 
         * The option is a: {@code Long} type.
         * 
         * Group: producer
         * 
         * @return the name of the header {@code
         * AwsS3DowloadLinkExpirationTime}.
         */
        public String awsS3DowloadLinkExpirationTime() {
            return "CamelAwsS3DowloadLinkExpirationTime";
        }
        /**
         * Whether the download link is browser compatible.
         * 
         * The option is a: {@code boolean} type.
         * 
         * Group: producer
         * 
         * @return the name of the header {@code
         * AwsS3DownloadLinkBrowserCompatible}.
         */
        public String awsS3DownloadLinkBrowserCompatible() {
            return "CamelAwsS3DownloadLinkBrowserCompatible";
        }
        /**
         * The headers that are needed by the service (not needed when
         * BrowserCompatible is true).
         * 
         * The option is a: {@code Map<String, List<String>>} type.
         * 
         * Group: producer
         * 
         * @return the name of the header {@code
         * AwsS3DownloadLinkHttpRequestHeaders}.
         */
        public String awsS3DownloadLinkHttpRequestHeaders() {
            return "CamelAwsS3DownloadLinkHttpRequestHeaders";
        }
        /**
         * The request payload that is needed by the service (not needed when
         * BrowserCompatible is true).
         * 
         * The option is a: {@code String} type.
         * 
         * Group: producer
         * 
         * @return the name of the header {@code
         * AwsS3DownloadLinkSignedPayload}.
         */
        public String awsS3DownloadLinkSignedPayload() {
            return "CamelAwsS3DownloadLinkSignedPayload";
        }
        /**
         * A map of metadata to be stored or stored with the object in S3. More
         * details about metadata
         * https://docs.aws.amazon.com/AmazonS3/latest/userguide/UsingMetadata.htmlhere.
         * 
         * The option is a: {@code Map<String, String>} type.
         * 
         * Group: common
         * 
         * @return the name of the header {@code AwsS3Metadata}.
         */
        public String awsS3Metadata() {
            return "CamelAwsS3Metadata";
        }
        /**
         * The timestamp of the message.
         * 
         * The option is a: {@code long} type.
         * 
         * Group: consumer
         * 
         * @return the name of the header {@code MessageTimestamp}.
         */
        public String messageTimestamp() {
            return "CamelMessageTimestamp";
        }
        /**
         * The prefix which is used in the
         * com.amazonaws.services.s3.model.ListObjectsRequest to only list
         * objects we are interested in.
         * 
         * The option is a: {@code } type.
         * 
         * Group: common
         * 
         * @return the name of the header {@code AwsS3Prefix}.
         */
        public String awsS3Prefix() {
            return "CamelAwsS3Prefix";
        }
        /**
         * The delimiter which is used in the
         * com.amazonaws.services.s3.model.ListObjectsRequest to only list
         * objects we are interested in.
         * 
         * The option is a: {@code String} type.
         * 
         * Group: common
         * 
         * @return the name of the header {@code AwsS3Delimiter}.
         */
        public String awsS3Delimiter() {
            return "CamelAwsS3Delimiter";
        }
    }
    static AWS2S3EndpointBuilder endpointBuilder(String componentName, String path) {
        class AWS2S3EndpointBuilderImpl extends AbstractEndpointBuilder implements AWS2S3EndpointBuilder, AdvancedAWS2S3EndpointBuilder {
            public AWS2S3EndpointBuilderImpl(String path) {
                super(componentName, path);
            }
        }
        return new AWS2S3EndpointBuilderImpl(path);
    }
}