/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.apache.camel.builder.component.dsl;

import javax.annotation.processing.Generated;
import org.apache.camel.Component;
import org.apache.camel.builder.component.AbstractComponentBuilder;
import org.apache.camel.builder.component.ComponentBuilder;
import org.apache.camel.component.debezium.DebeziumMongodbComponent;

/**
 * Capture changes from a MongoDB database.
 * 
 * Generated by camel-package-maven-plugin - do not edit this file!
 */
@Generated("org.apache.camel.maven.packaging.ComponentDslMojo")
public interface DebeziumMongodbComponentBuilderFactory {

    /**
     * Debezium MongoDB Connector (camel-debezium-mongodb)
     * Capture changes from a MongoDB database.
     * 
     * Category: database
     * Since: 3.0
     * Maven coordinates: org.apache.camel:camel-debezium-mongodb
     * 
     * @return the dsl builder
     */
    static DebeziumMongodbComponentBuilder debeziumMongodb() {
        return new DebeziumMongodbComponentBuilderImpl();
    }

    /**
     * Builder for the Debezium MongoDB Connector component.
     */
    interface DebeziumMongodbComponentBuilder
            extends
                ComponentBuilder<DebeziumMongodbComponent> {
        /**
         * Additional properties for debezium components in case they can't be
         * set directly on the camel configurations (e.g: setting Kafka Connect
         * properties needed by Debezium engine, for example setting
         * KafkaOffsetBackingStore), the properties have to be prefixed with
         * additionalProperties.. E.g:
         * additionalProperties.transactional.id=12345&amp;amp;additionalProperties.schema.registry.url=http://localhost:8811/avro.
         * 
         * The option is a: &lt;code&gt;java.util.Map&amp;lt;java.lang.String,
         * java.lang.Object&amp;gt;&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param additionalProperties the value to set
         * @return the dsl builder
         */
        default DebeziumMongodbComponentBuilder additionalProperties(
                java.util.Map<java.lang.String, java.lang.Object> additionalProperties) {
            doSetProperty("additionalProperties", additionalProperties);
            return this;
        }
        /**
         * Allows for bridging the consumer to the Camel routing Error Handler,
         * which mean any exceptions (if possible) occurred while the Camel
         * consumer is trying to pickup incoming messages, or the likes, will
         * now be processed as a message and handled by the routing Error
         * Handler. Important: This is only possible if the 3rd party component
         * allows Camel to be alerted if an exception was thrown. Some
         * components handle this internally only, and therefore
         * bridgeErrorHandler is not possible. In other situations we may
         * improve the Camel component to hook into the 3rd party component and
         * make this possible for future releases. By default the consumer will
         * use the org.apache.camel.spi.ExceptionHandler to deal with
         * exceptions, that will be logged at WARN or ERROR level and ignored.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: false
         * Group: consumer
         * 
         * @param bridgeErrorHandler the value to set
         * @return the dsl builder
         */
        default DebeziumMongodbComponentBuilder bridgeErrorHandler(
                boolean bridgeErrorHandler) {
            doSetProperty("bridgeErrorHandler", bridgeErrorHandler);
            return this;
        }
        /**
         * Allow pre-configured Configurations to be set.
         * 
         * The option is a:
         * &lt;code&gt;org.apache.camel.component.debezium.configuration.MongoDbConnectorEmbeddedDebeziumConfiguration&lt;/code&gt; type.
         * 
         * Group: consumer
         * 
         * @param configuration the value to set
         * @return the dsl builder
         */
        default DebeziumMongodbComponentBuilder configuration(
                org.apache.camel.component.debezium.configuration.MongoDbConnectorEmbeddedDebeziumConfiguration configuration) {
            doSetProperty("configuration", configuration);
            return this;
        }
        /**
         * The Converter class that should be used to serialize and deserialize
         * key data for offsets. The default is JSON converter.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Default: org.apache.kafka.connect.json.JsonConverter
         * Group: consumer
         * 
         * @param internalKeyConverter the value to set
         * @return the dsl builder
         */
        default DebeziumMongodbComponentBuilder internalKeyConverter(
                java.lang.String internalKeyConverter) {
            doSetProperty("internalKeyConverter", internalKeyConverter);
            return this;
        }
        /**
         * The Converter class that should be used to serialize and deserialize
         * value data for offsets. The default is JSON converter.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Default: org.apache.kafka.connect.json.JsonConverter
         * Group: consumer
         * 
         * @param internalValueConverter the value to set
         * @return the dsl builder
         */
        default DebeziumMongodbComponentBuilder internalValueConverter(
                java.lang.String internalValueConverter) {
            doSetProperty("internalValueConverter", internalValueConverter);
            return this;
        }
        /**
         * The name of the Java class of the commit policy. It defines when
         * offsets commit has to be triggered based on the number of events
         * processed and the time elapsed since the last commit. This class must
         * implement the interface 'OffsetCommitPolicy'. The default is a
         * periodic commit policy based upon time intervals.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: consumer
         * 
         * @param offsetCommitPolicy the value to set
         * @return the dsl builder
         */
        default DebeziumMongodbComponentBuilder offsetCommitPolicy(
                java.lang.String offsetCommitPolicy) {
            doSetProperty("offsetCommitPolicy", offsetCommitPolicy);
            return this;
        }
        /**
         * Maximum number of milliseconds to wait for records to flush and
         * partition offset data to be committed to offset storage before
         * cancelling the process and restoring the offset data to be committed
         * in a future attempt. The default is 5 seconds.
         * 
         * The option is a: &lt;code&gt;long&lt;/code&gt; type.
         * 
         * Default: 5000
         * Group: consumer
         * 
         * @param offsetCommitTimeoutMs the value to set
         * @return the dsl builder
         */
        default DebeziumMongodbComponentBuilder offsetCommitTimeoutMs(
                long offsetCommitTimeoutMs) {
            doSetProperty("offsetCommitTimeoutMs", offsetCommitTimeoutMs);
            return this;
        }
        /**
         * Interval at which to try committing offsets. The default is 1 minute.
         * 
         * The option is a: &lt;code&gt;long&lt;/code&gt; type.
         * 
         * Default: 60000
         * Group: consumer
         * 
         * @param offsetFlushIntervalMs the value to set
         * @return the dsl builder
         */
        default DebeziumMongodbComponentBuilder offsetFlushIntervalMs(
                long offsetFlushIntervalMs) {
            doSetProperty("offsetFlushIntervalMs", offsetFlushIntervalMs);
            return this;
        }
        /**
         * The name of the Java class that is responsible for persistence of
         * connector offsets.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Default: org.apache.kafka.connect.storage.FileOffsetBackingStore
         * Group: consumer
         * 
         * @param offsetStorage the value to set
         * @return the dsl builder
         */
        default DebeziumMongodbComponentBuilder offsetStorage(
                java.lang.String offsetStorage) {
            doSetProperty("offsetStorage", offsetStorage);
            return this;
        }
        /**
         * Path to file where offsets are to be stored. Required when
         * offset.storage is set to the FileOffsetBackingStore.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: consumer
         * 
         * @param offsetStorageFileName the value to set
         * @return the dsl builder
         */
        default DebeziumMongodbComponentBuilder offsetStorageFileName(
                java.lang.String offsetStorageFileName) {
            doSetProperty("offsetStorageFileName", offsetStorageFileName);
            return this;
        }
        /**
         * The number of partitions used when creating the offset storage topic.
         * Required when offset.storage is set to the 'KafkaOffsetBackingStore'.
         * 
         * The option is a: &lt;code&gt;int&lt;/code&gt; type.
         * 
         * Group: consumer
         * 
         * @param offsetStoragePartitions the value to set
         * @return the dsl builder
         */
        default DebeziumMongodbComponentBuilder offsetStoragePartitions(
                int offsetStoragePartitions) {
            doSetProperty("offsetStoragePartitions", offsetStoragePartitions);
            return this;
        }
        /**
         * Replication factor used when creating the offset storage topic.
         * Required when offset.storage is set to the KafkaOffsetBackingStore.
         * 
         * The option is a: &lt;code&gt;int&lt;/code&gt; type.
         * 
         * Group: consumer
         * 
         * @param offsetStorageReplicationFactor the value to set
         * @return the dsl builder
         */
        default DebeziumMongodbComponentBuilder offsetStorageReplicationFactor(
                int offsetStorageReplicationFactor) {
            doSetProperty("offsetStorageReplicationFactor", offsetStorageReplicationFactor);
            return this;
        }
        /**
         * The name of the Kafka topic where offsets are to be stored. Required
         * when offset.storage is set to the KafkaOffsetBackingStore.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: consumer
         * 
         * @param offsetStorageTopic the value to set
         * @return the dsl builder
         */
        default DebeziumMongodbComponentBuilder offsetStorageTopic(
                java.lang.String offsetStorageTopic) {
            doSetProperty("offsetStorageTopic", offsetStorageTopic);
            return this;
        }
        /**
         * Whether autowiring is enabled. This is used for automatic autowiring
         * options (the option must be marked as autowired) by looking up in the
         * registry to find if there is a single instance of matching type,
         * which then gets configured on the component. This can be used for
         * automatic configuring JDBC data sources, JMS connection factories,
         * AWS Clients, etc.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: true
         * Group: advanced
         * 
         * @param autowiredEnabled the value to set
         * @return the dsl builder
         */
        default DebeziumMongodbComponentBuilder autowiredEnabled(
                boolean autowiredEnabled) {
            doSetProperty("autowiredEnabled", autowiredEnabled);
            return this;
        }
        /**
         * The method used to capture changes from MongoDB server. Options
         * include: 'change_streams' to capture changes via MongoDB Change
         * Streams, update events do not contain full documents;
         * 'change_streams_update_full' (the default) to capture changes via
         * MongoDB Change Streams, update events contain full documents.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Default: change_streams_update_full
         * Group: mongodb
         * 
         * @param captureMode the value to set
         * @return the dsl builder
         */
        default DebeziumMongodbComponentBuilder captureMode(
                java.lang.String captureMode) {
            doSetProperty("captureMode", captureMode);
            return this;
        }
        /**
         * A comma-separated list of regular expressions or literals that match
         * the collection names for which changes are to be excluded.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: mongodb
         * 
         * @param collectionExcludeList the value to set
         * @return the dsl builder
         */
        default DebeziumMongodbComponentBuilder collectionExcludeList(
                java.lang.String collectionExcludeList) {
            doSetProperty("collectionExcludeList", collectionExcludeList);
            return this;
        }
        /**
         * A comma-separated list of regular expressions or literals that match
         * the collection names for which changes are to be captured.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: mongodb
         * 
         * @param collectionIncludeList the value to set
         * @return the dsl builder
         */
        default DebeziumMongodbComponentBuilder collectionIncludeList(
                java.lang.String collectionIncludeList) {
            doSetProperty("collectionIncludeList", collectionIncludeList);
            return this;
        }
        /**
         * Optional list of custom converters that would be used instead of
         * default ones. The converters are defined using '.type' config option
         * and configured using options '.'.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: mongodb
         * 
         * @param converters the value to set
         * @return the dsl builder
         */
        default DebeziumMongodbComponentBuilder converters(
                java.lang.String converters) {
            doSetProperty("converters", converters);
            return this;
        }
        /**
         * The maximum processing time in milliseconds to wait for the oplog
         * cursor to process a single poll request.
         * 
         * The option is a: &lt;code&gt;int&lt;/code&gt; type.
         * 
         * Group: mongodb
         * 
         * @param cursorMaxAwaitTimeMs the value to set
         * @return the dsl builder
         */
        default DebeziumMongodbComponentBuilder cursorMaxAwaitTimeMs(
                int cursorMaxAwaitTimeMs) {
            doSetProperty("cursorMaxAwaitTimeMs", cursorMaxAwaitTimeMs);
            return this;
        }
        /**
         * The custom metric tags will accept key-value pairs to customize the
         * MBean object name which should be appended the end of regular name,
         * each key would represent a tag for the MBean object name, and the
         * corresponding value would be the value of that tag the key is. For
         * example: k1=v1,k2=v2.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: mongodb
         * 
         * @param customMetricTags the value to set
         * @return the dsl builder
         */
        default DebeziumMongodbComponentBuilder customMetricTags(
                java.lang.String customMetricTags) {
            doSetProperty("customMetricTags", customMetricTags);
            return this;
        }
        /**
         * A comma-separated list of regular expressions or literals that match
         * the database names for which changes are to be excluded.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: mongodb
         * 
         * @param databaseExcludeList the value to set
         * @return the dsl builder
         */
        default DebeziumMongodbComponentBuilder databaseExcludeList(
                java.lang.String databaseExcludeList) {
            doSetProperty("databaseExcludeList", databaseExcludeList);
            return this;
        }
        /**
         * A comma-separated list of regular expressions or literals that match
         * the database names for which changes are to be captured.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: mongodb
         * 
         * @param databaseIncludeList the value to set
         * @return the dsl builder
         */
        default DebeziumMongodbComponentBuilder databaseIncludeList(
                java.lang.String databaseIncludeList) {
            doSetProperty("databaseIncludeList", databaseIncludeList);
            return this;
        }
        /**
         * The maximum number of retries on connection errors before failing (-1
         * = no limit, 0 = disabled, 0 = num of retries).
         * 
         * The option is a: &lt;code&gt;int&lt;/code&gt; type.
         * 
         * Default: -1
         * Group: mongodb
         * 
         * @param errorsMaxRetries the value to set
         * @return the dsl builder
         */
        default DebeziumMongodbComponentBuilder errorsMaxRetries(
                int errorsMaxRetries) {
            doSetProperty("errorsMaxRetries", errorsMaxRetries);
            return this;
        }
        /**
         * Specify how failures during processing of events (i.e. when
         * encountering a corrupted event) should be handled, including: 'fail'
         * (the default) an exception indicating the problematic event and its
         * position is raised, causing the connector to be stopped; 'warn' the
         * problematic event and its position will be logged and the event will
         * be skipped; 'ignore' the problematic event will be skipped.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Default: fail
         * Group: mongodb
         * 
         * @param eventProcessingFailureHandlingMode the value to set
         * @return the dsl builder
         */
        default DebeziumMongodbComponentBuilder eventProcessingFailureHandlingMode(
                java.lang.String eventProcessingFailureHandlingMode) {
            doSetProperty("eventProcessingFailureHandlingMode", eventProcessingFailureHandlingMode);
            return this;
        }
        /**
         * A comma-separated list of the fully-qualified names of fields that
         * should be excluded from change event message values.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: mongodb
         * 
         * @param fieldExcludeList the value to set
         * @return the dsl builder
         */
        default DebeziumMongodbComponentBuilder fieldExcludeList(
                java.lang.String fieldExcludeList) {
            doSetProperty("fieldExcludeList", fieldExcludeList);
            return this;
        }
        /**
         * A comma-separated list of the fully-qualified replacements of fields
         * that should be used to rename fields in change event message values.
         * Fully-qualified replacements for fields are of the form
         * databaseName.collectionName.fieldName.nestedFieldName:newNestedFieldName, where databaseName and collectionName may contain the wildcard () which matches any characters, the colon character (:) is used to determine rename mapping of field.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: mongodb
         * 
         * @param fieldRenames the value to set
         * @return the dsl builder
         */
        default DebeziumMongodbComponentBuilder fieldRenames(
                java.lang.String fieldRenames) {
            doSetProperty("fieldRenames", fieldRenames);
            return this;
        }
        /**
         * Length of an interval in milli-seconds in in which the connector
         * periodically sends heartbeat messages to a heartbeat topic. Use 0 to
         * disable heartbeat messages. Disabled by default.
         * 
         * The option is a: &lt;code&gt;int&lt;/code&gt; type.
         * 
         * Default: 0ms
         * Group: mongodb
         * 
         * @param heartbeatIntervalMs the value to set
         * @return the dsl builder
         */
        default DebeziumMongodbComponentBuilder heartbeatIntervalMs(
                int heartbeatIntervalMs) {
            doSetProperty("heartbeatIntervalMs", heartbeatIntervalMs);
            return this;
        }
        /**
         * The prefix that is used to name heartbeat topics.Defaults to
         * __debezium-heartbeat.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Default: __debezium-heartbeat
         * Group: mongodb
         * 
         * @param heartbeatTopicsPrefix the value to set
         * @return the dsl builder
         */
        default DebeziumMongodbComponentBuilder heartbeatTopicsPrefix(
                java.lang.String heartbeatTopicsPrefix) {
            doSetProperty("heartbeatTopicsPrefix", heartbeatTopicsPrefix);
            return this;
        }
        /**
         * Specify the strategy used for watermarking during an incremental
         * snapshot: 'insert_insert' both open and close signal is written into
         * signal data collection (default); 'insert_delete' only open signal is
         * written on signal data collection, the close will delete the relative
         * open signal;.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Default: INSERT_INSERT
         * Group: mongodb
         * 
         * @param incrementalSnapshotWatermarkingStrategy the value to set
         * @return the dsl builder
         */
        default DebeziumMongodbComponentBuilder incrementalSnapshotWatermarkingStrategy(
                java.lang.String incrementalSnapshotWatermarkingStrategy) {
            doSetProperty("incrementalSnapshotWatermarkingStrategy", incrementalSnapshotWatermarkingStrategy);
            return this;
        }
        /**
         * Maximum size of each batch of source records. Defaults to 2048.
         * 
         * The option is a: &lt;code&gt;int&lt;/code&gt; type.
         * 
         * Default: 2048
         * Group: mongodb
         * 
         * @param maxBatchSize the value to set
         * @return the dsl builder
         */
        default DebeziumMongodbComponentBuilder maxBatchSize(int maxBatchSize) {
            doSetProperty("maxBatchSize", maxBatchSize);
            return this;
        }
        /**
         * Maximum size of the queue for change events read from the database
         * log but not yet recorded or forwarded. Defaults to 8192, and should
         * always be larger than the maximum batch size.
         * 
         * The option is a: &lt;code&gt;int&lt;/code&gt; type.
         * 
         * Default: 8192
         * Group: mongodb
         * 
         * @param maxQueueSize the value to set
         * @return the dsl builder
         */
        default DebeziumMongodbComponentBuilder maxQueueSize(int maxQueueSize) {
            doSetProperty("maxQueueSize", maxQueueSize);
            return this;
        }
        /**
         * Maximum size of the queue in bytes for change events read from the
         * database log but not yet recorded or forwarded. Defaults to 0. Mean
         * the feature is not enabled.
         * 
         * The option is a: &lt;code&gt;long&lt;/code&gt; type.
         * 
         * Default: 0
         * Group: mongodb
         * 
         * @param maxQueueSizeInBytes the value to set
         * @return the dsl builder
         */
        default DebeziumMongodbComponentBuilder maxQueueSizeInBytes(
                long maxQueueSizeInBytes) {
            doSetProperty("maxQueueSizeInBytes", maxQueueSizeInBytes);
            return this;
        }
        /**
         * Database containing user credentials.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Default: admin
         * Group: mongodb
         * 
         * @param mongodbAuthsource the value to set
         * @return the dsl builder
         */
        default DebeziumMongodbComponentBuilder mongodbAuthsource(
                java.lang.String mongodbAuthsource) {
            doSetProperty("mongodbAuthsource", mongodbAuthsource);
            return this;
        }
        /**
         * The method used to connect to MongoDB cluster. Options include:
         * 'replica_set' to individually connect to each replica set / shard
         * 'sharded' (the default) to connect via single connection obtained
         * from connection string.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Default: sharded
         * Group: mongodb
         * 
         * @param mongodbConnectionMode the value to set
         * @return the dsl builder
         */
        default DebeziumMongodbComponentBuilder mongodbConnectionMode(
                java.lang.String mongodbConnectionMode) {
            doSetProperty("mongodbConnectionMode", mongodbConnectionMode);
            return this;
        }
        /**
         * Database connection string.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: mongodb
         * 
         * @param mongodbConnectionString the value to set
         * @return the dsl builder
         */
        default DebeziumMongodbComponentBuilder mongodbConnectionString(
                java.lang.String mongodbConnectionString) {
            doSetProperty("mongodbConnectionString", mongodbConnectionString);
            return this;
        }
        /**
         * The connection timeout, given in milliseconds. Defaults to 10 seconds
         * (10,000 ms).
         * 
         * The option is a: &lt;code&gt;int&lt;/code&gt; type.
         * 
         * Default: 10s
         * Group: mongodb
         * 
         * @param mongodbConnectTimeoutMs the value to set
         * @return the dsl builder
         */
        default DebeziumMongodbComponentBuilder mongodbConnectTimeoutMs(
                int mongodbConnectTimeoutMs) {
            doSetProperty("mongodbConnectTimeoutMs", mongodbConnectTimeoutMs);
            return this;
        }
        /**
         * The frequency that the cluster monitor attempts to reach each server.
         * Defaults to 10 seconds (10,000 ms).
         * 
         * The option is a: &lt;code&gt;int&lt;/code&gt; type.
         * 
         * Default: 10s
         * Group: mongodb
         * 
         * @param mongodbHeartbeatFrequencyMs the value to set
         * @return the dsl builder
         */
        default DebeziumMongodbComponentBuilder mongodbHeartbeatFrequencyMs(
                int mongodbHeartbeatFrequencyMs) {
            doSetProperty("mongodbHeartbeatFrequencyMs", mongodbHeartbeatFrequencyMs);
            return this;
        }
        /**
         * Password to be used when connecting to MongoDB, if necessary.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: mongodb
         * 
         * @param mongodbPassword the value to set
         * @return the dsl builder
         */
        default DebeziumMongodbComponentBuilder mongodbPassword(
                java.lang.String mongodbPassword) {
            doSetProperty("mongodbPassword", mongodbPassword);
            return this;
        }
        /**
         * Interval for looking for new, removed, or changed replica sets, given
         * in milliseconds. Defaults to 30 seconds (30,000 ms).
         * 
         * The option is a: &lt;code&gt;long&lt;/code&gt; type.
         * 
         * Default: 30s
         * Group: mongodb
         * 
         * @param mongodbPollIntervalMs the value to set
         * @return the dsl builder
         */
        default DebeziumMongodbComponentBuilder mongodbPollIntervalMs(
                long mongodbPollIntervalMs) {
            doSetProperty("mongodbPollIntervalMs", mongodbPollIntervalMs);
            return this;
        }
        /**
         * The server selection timeout, given in milliseconds. Defaults to 10
         * seconds (10,000 ms).
         * 
         * The option is a: &lt;code&gt;int&lt;/code&gt; type.
         * 
         * Default: 30s
         * Group: mongodb
         * 
         * @param mongodbServerSelectionTimeoutMs the value to set
         * @return the dsl builder
         */
        default DebeziumMongodbComponentBuilder mongodbServerSelectionTimeoutMs(
                int mongodbServerSelectionTimeoutMs) {
            doSetProperty("mongodbServerSelectionTimeoutMs", mongodbServerSelectionTimeoutMs);
            return this;
        }
        /**
         * The socket timeout, given in milliseconds. Defaults to 0 ms.
         * 
         * The option is a: &lt;code&gt;int&lt;/code&gt; type.
         * 
         * Default: 0ms
         * Group: mongodb
         * 
         * @param mongodbSocketTimeoutMs the value to set
         * @return the dsl builder
         */
        default DebeziumMongodbComponentBuilder mongodbSocketTimeoutMs(
                int mongodbSocketTimeoutMs) {
            doSetProperty("mongodbSocketTimeoutMs", mongodbSocketTimeoutMs);
            return this;
        }
        /**
         * Should connector use SSL to connect to MongoDB instances.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: false
         * Group: mongodb
         * 
         * @param mongodbSslEnabled the value to set
         * @return the dsl builder
         */
        default DebeziumMongodbComponentBuilder mongodbSslEnabled(
                boolean mongodbSslEnabled) {
            doSetProperty("mongodbSslEnabled", mongodbSslEnabled);
            return this;
        }
        /**
         * Whether invalid host names are allowed when using SSL. If true the
         * connection will not prevent man-in-the-middle attacks.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: false
         * Group: mongodb
         * 
         * @param mongodbSslInvalidHostnameAllowed the value to set
         * @return the dsl builder
         */
        default DebeziumMongodbComponentBuilder mongodbSslInvalidHostnameAllowed(
                boolean mongodbSslInvalidHostnameAllowed) {
            doSetProperty("mongodbSslInvalidHostnameAllowed", mongodbSslInvalidHostnameAllowed);
            return this;
        }
        /**
         * Database user for connecting to MongoDB, if necessary.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: mongodb
         * 
         * @param mongodbUser the value to set
         * @return the dsl builder
         */
        default DebeziumMongodbComponentBuilder mongodbUser(
                java.lang.String mongodbUser) {
            doSetProperty("mongodbUser", mongodbUser);
            return this;
        }
        /**
         * List of notification channels names that are enabled.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: mongodb
         * 
         * @param notificationEnabledChannels the value to set
         * @return the dsl builder
         */
        default DebeziumMongodbComponentBuilder notificationEnabledChannels(
                java.lang.String notificationEnabledChannels) {
            doSetProperty("notificationEnabledChannels", notificationEnabledChannels);
            return this;
        }
        /**
         * The name of the topic for the notifications. This is required in case
         * 'sink' is in the list of enabled channels.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: mongodb
         * 
         * @param notificationSinkTopicName the value to set
         * @return the dsl builder
         */
        default DebeziumMongodbComponentBuilder notificationSinkTopicName(
                java.lang.String notificationSinkTopicName) {
            doSetProperty("notificationSinkTopicName", notificationSinkTopicName);
            return this;
        }
        /**
         * Time to wait for new change events to appear after receiving no
         * events, given in milliseconds. Defaults to 500 ms.
         * 
         * The option is a: &lt;code&gt;long&lt;/code&gt; type.
         * 
         * Default: 500ms
         * Group: mongodb
         * 
         * @param pollIntervalMs the value to set
         * @return the dsl builder
         */
        default DebeziumMongodbComponentBuilder pollIntervalMs(
                long pollIntervalMs) {
            doSetProperty("pollIntervalMs", pollIntervalMs);
            return this;
        }
        /**
         * Optional list of post processors. The processors are defined using
         * '.type' config option and configured using options ''.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: mongodb
         * 
         * @param postProcessors the value to set
         * @return the dsl builder
         */
        default DebeziumMongodbComponentBuilder postProcessors(
                java.lang.String postProcessors) {
            doSetProperty("postProcessors", postProcessors);
            return this;
        }
        /**
         * Enables transaction metadata extraction together with event counting.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: false
         * Group: mongodb
         * 
         * @param provideTransactionMetadata the value to set
         * @return the dsl builder
         */
        default DebeziumMongodbComponentBuilder provideTransactionMetadata(
                boolean provideTransactionMetadata) {
            doSetProperty("provideTransactionMetadata", provideTransactionMetadata);
            return this;
        }
        /**
         * The maximum number of records that should be loaded into memory while
         * streaming. A value of '0' uses the default JDBC fetch size.
         * 
         * The option is a: &lt;code&gt;int&lt;/code&gt; type.
         * 
         * Default: 0
         * Group: mongodb
         * 
         * @param queryFetchSize the value to set
         * @return the dsl builder
         */
        default DebeziumMongodbComponentBuilder queryFetchSize(
                int queryFetchSize) {
            doSetProperty("queryFetchSize", queryFetchSize);
            return this;
        }
        /**
         * Time to wait before restarting connector after retriable exception
         * occurs. Defaults to 10000ms.
         * 
         * The option is a: &lt;code&gt;long&lt;/code&gt; type.
         * 
         * Default: 10s
         * Group: mongodb
         * 
         * @param retriableRestartConnectorWaitMs the value to set
         * @return the dsl builder
         */
        default DebeziumMongodbComponentBuilder retriableRestartConnectorWaitMs(
                long retriableRestartConnectorWaitMs) {
            doSetProperty("retriableRestartConnectorWaitMs", retriableRestartConnectorWaitMs);
            return this;
        }
        /**
         * The path to the file that will be used to record the database schema
         * history.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: mongodb
         * 
         * @param schemaHistoryInternalFileFilename the value to set
         * @return the dsl builder
         */
        default DebeziumMongodbComponentBuilder schemaHistoryInternalFileFilename(
                java.lang.String schemaHistoryInternalFileFilename) {
            doSetProperty("schemaHistoryInternalFileFilename", schemaHistoryInternalFileFilename);
            return this;
        }
        /**
         * Specify how schema names should be adjusted for compatibility with
         * the message converter used by the connector, including: 'avro'
         * replaces the characters that cannot be used in the Avro type name
         * with underscore; 'avro_unicode' replaces the underscore or characters
         * that cannot be used in the Avro type name with corresponding unicode
         * like _uxxxx. Note: _ is an escape sequence like backslash in
         * Java;'none' does not apply any adjustment (default).
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Default: none
         * Group: mongodb
         * 
         * @param schemaNameAdjustmentMode the value to set
         * @return the dsl builder
         */
        default DebeziumMongodbComponentBuilder schemaNameAdjustmentMode(
                java.lang.String schemaNameAdjustmentMode) {
            doSetProperty("schemaNameAdjustmentMode", schemaNameAdjustmentMode);
            return this;
        }
        /**
         * The name of the data collection that is used to send signals/commands
         * to Debezium. Signaling is disabled when not set.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: mongodb
         * 
         * @param signalDataCollection the value to set
         * @return the dsl builder
         */
        default DebeziumMongodbComponentBuilder signalDataCollection(
                java.lang.String signalDataCollection) {
            doSetProperty("signalDataCollection", signalDataCollection);
            return this;
        }
        /**
         * List of channels names that are enabled. Source channel is enabled by
         * default.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Default: source
         * Group: mongodb
         * 
         * @param signalEnabledChannels the value to set
         * @return the dsl builder
         */
        default DebeziumMongodbComponentBuilder signalEnabledChannels(
                java.lang.String signalEnabledChannels) {
            doSetProperty("signalEnabledChannels", signalEnabledChannels);
            return this;
        }
        /**
         * Interval for looking for new signals in registered channels, given in
         * milliseconds. Defaults to 5 seconds.
         * 
         * The option is a: &lt;code&gt;long&lt;/code&gt; type.
         * 
         * Default: 5s
         * Group: mongodb
         * 
         * @param signalPollIntervalMs the value to set
         * @return the dsl builder
         */
        default DebeziumMongodbComponentBuilder signalPollIntervalMs(
                long signalPollIntervalMs) {
            doSetProperty("signalPollIntervalMs", signalPollIntervalMs);
            return this;
        }
        /**
         * The comma-separated list of operations to skip during streaming,
         * defined as: 'c' for inserts/create; 'u' for updates; 'd' for deletes,
         * 't' for truncates, and 'none' to indicate nothing skipped. By
         * default, only truncate operations will be skipped.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Default: t
         * Group: mongodb
         * 
         * @param skippedOperations the value to set
         * @return the dsl builder
         */
        default DebeziumMongodbComponentBuilder skippedOperations(
                java.lang.String skippedOperations) {
            doSetProperty("skippedOperations", skippedOperations);
            return this;
        }
        /**
         * This property contains a comma-separated list of ., for which the
         * initial snapshot may be a subset of data present in the data source.
         * The subset would be defined by mongodb filter query specified as
         * value for property snapshot.collection.filter.override..
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: mongodb
         * 
         * @param snapshotCollectionFilterOverrides the value to set
         * @return the dsl builder
         */
        default DebeziumMongodbComponentBuilder snapshotCollectionFilterOverrides(
                java.lang.String snapshotCollectionFilterOverrides) {
            doSetProperty("snapshotCollectionFilterOverrides", snapshotCollectionFilterOverrides);
            return this;
        }
        /**
         * A delay period before a snapshot will begin, given in milliseconds.
         * Defaults to 0 ms.
         * 
         * The option is a: &lt;code&gt;long&lt;/code&gt; type.
         * 
         * Default: 0ms
         * Group: mongodb
         * 
         * @param snapshotDelayMs the value to set
         * @return the dsl builder
         */
        default DebeziumMongodbComponentBuilder snapshotDelayMs(
                long snapshotDelayMs) {
            doSetProperty("snapshotDelayMs", snapshotDelayMs);
            return this;
        }
        /**
         * The maximum number of records that should be loaded into memory while
         * performing a snapshot.
         * 
         * The option is a: &lt;code&gt;int&lt;/code&gt; type.
         * 
         * Group: mongodb
         * 
         * @param snapshotFetchSize the value to set
         * @return the dsl builder
         */
        default DebeziumMongodbComponentBuilder snapshotFetchSize(
                int snapshotFetchSize) {
            doSetProperty("snapshotFetchSize", snapshotFetchSize);
            return this;
        }
        /**
         * This setting must be set to specify a list of tables/collections
         * whose snapshot must be taken on creating or restarting the connector.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: mongodb
         * 
         * @param snapshotIncludeCollectionList the value to set
         * @return the dsl builder
         */
        default DebeziumMongodbComponentBuilder snapshotIncludeCollectionList(
                java.lang.String snapshotIncludeCollectionList) {
            doSetProperty("snapshotIncludeCollectionList", snapshotIncludeCollectionList);
            return this;
        }
        /**
         * The maximum number of threads used to perform the snapshot. Defaults
         * to 1.
         * 
         * The option is a: &lt;code&gt;int&lt;/code&gt; type.
         * 
         * Default: 1
         * Group: mongodb
         * 
         * @param snapshotMaxThreads the value to set
         * @return the dsl builder
         */
        default DebeziumMongodbComponentBuilder snapshotMaxThreads(
                int snapshotMaxThreads) {
            doSetProperty("snapshotMaxThreads", snapshotMaxThreads);
            return this;
        }
        /**
         * The criteria for running a snapshot upon startup of the connector.
         * Select one of the following snapshot options: 'initial' (default): If
         * the connector does not detect any offsets for the logical server
         * name, it runs a snapshot that captures the current full state of the
         * configured tables. After the snapshot completes, the connector begins
         * to stream changes from the oplog. 'never': The connector does not run
         * a snapshot. Upon first startup, the connector immediately begins
         * reading from the beginning of the oplog.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Default: initial
         * Group: mongodb
         * 
         * @param snapshotMode the value to set
         * @return the dsl builder
         */
        default DebeziumMongodbComponentBuilder snapshotMode(
                java.lang.String snapshotMode) {
            doSetProperty("snapshotMode", snapshotMode);
            return this;
        }
        /**
         * The name of the SourceInfoStructMaker class that returns SourceInfo
         * schema and struct.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Default: io.debezium.connector.mongodb.MongoDbSourceInfoStructMaker
         * Group: mongodb
         * 
         * @param sourceinfoStructMaker the value to set
         * @return the dsl builder
         */
        default DebeziumMongodbComponentBuilder sourceinfoStructMaker(
                java.lang.String sourceinfoStructMaker) {
            doSetProperty("sourceinfoStructMaker", sourceinfoStructMaker);
            return this;
        }
        /**
         * Whether delete operations should be represented by a delete event and
         * a subsequent tombstone event (true) or only by a delete event
         * (false). Emitting the tombstone event (the default behavior) allows
         * Kafka to completely delete all events pertaining to the given key
         * once the source record got deleted.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: false
         * Group: mongodb
         * 
         * @param tombstonesOnDelete the value to set
         * @return the dsl builder
         */
        default DebeziumMongodbComponentBuilder tombstonesOnDelete(
                boolean tombstonesOnDelete) {
            doSetProperty("tombstonesOnDelete", tombstonesOnDelete);
            return this;
        }
        /**
         * The name of the TopicNamingStrategy class that should be used to
         * determine the topic name for data change, schema change, transaction,
         * heartbeat event etc.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Default: io.debezium.schema.SchemaTopicNamingStrategy
         * Group: mongodb
         * 
         * @param topicNamingStrategy the value to set
         * @return the dsl builder
         */
        default DebeziumMongodbComponentBuilder topicNamingStrategy(
                java.lang.String topicNamingStrategy) {
            doSetProperty("topicNamingStrategy", topicNamingStrategy);
            return this;
        }
        /**
         * Topic prefix that identifies and provides a namespace for the
         * particular database server/cluster is capturing changes. The topic
         * prefix should be unique across all other connectors, since it is used
         * as a prefix for all Kafka topic names that receive events emitted by
         * this connector. Only alphanumeric characters, hyphens, dots and
         * underscores must be accepted.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: mongodb
         * 
         * @param topicPrefix the value to set
         * @return the dsl builder
         */
        default DebeziumMongodbComponentBuilder topicPrefix(
                java.lang.String topicPrefix) {
            doSetProperty("topicPrefix", topicPrefix);
            return this;
        }
    }

    class DebeziumMongodbComponentBuilderImpl
            extends
                AbstractComponentBuilder<DebeziumMongodbComponent>
            implements
                DebeziumMongodbComponentBuilder {
        @Override
        protected DebeziumMongodbComponent buildConcreteComponent() {
            return new DebeziumMongodbComponent();
        }
        private org.apache.camel.component.debezium.configuration.MongoDbConnectorEmbeddedDebeziumConfiguration getOrCreateConfiguration(
                org.apache.camel.component.debezium.DebeziumMongodbComponent component) {
            if (component.getConfiguration() == null) {
                component.setConfiguration(new org.apache.camel.component.debezium.configuration.MongoDbConnectorEmbeddedDebeziumConfiguration());
            }
            return component.getConfiguration();
        }
        @Override
        protected boolean setPropertyOnComponent(
                Component component,
                String name,
                Object value) {
            switch (name) {
            case "additionalProperties": getOrCreateConfiguration((DebeziumMongodbComponent) component).setAdditionalProperties((java.util.Map) value); return true;
            case "bridgeErrorHandler": ((DebeziumMongodbComponent) component).setBridgeErrorHandler((boolean) value); return true;
            case "configuration": ((DebeziumMongodbComponent) component).setConfiguration((org.apache.camel.component.debezium.configuration.MongoDbConnectorEmbeddedDebeziumConfiguration) value); return true;
            case "internalKeyConverter": getOrCreateConfiguration((DebeziumMongodbComponent) component).setInternalKeyConverter((java.lang.String) value); return true;
            case "internalValueConverter": getOrCreateConfiguration((DebeziumMongodbComponent) component).setInternalValueConverter((java.lang.String) value); return true;
            case "offsetCommitPolicy": getOrCreateConfiguration((DebeziumMongodbComponent) component).setOffsetCommitPolicy((java.lang.String) value); return true;
            case "offsetCommitTimeoutMs": getOrCreateConfiguration((DebeziumMongodbComponent) component).setOffsetCommitTimeoutMs((long) value); return true;
            case "offsetFlushIntervalMs": getOrCreateConfiguration((DebeziumMongodbComponent) component).setOffsetFlushIntervalMs((long) value); return true;
            case "offsetStorage": getOrCreateConfiguration((DebeziumMongodbComponent) component).setOffsetStorage((java.lang.String) value); return true;
            case "offsetStorageFileName": getOrCreateConfiguration((DebeziumMongodbComponent) component).setOffsetStorageFileName((java.lang.String) value); return true;
            case "offsetStoragePartitions": getOrCreateConfiguration((DebeziumMongodbComponent) component).setOffsetStoragePartitions((int) value); return true;
            case "offsetStorageReplicationFactor": getOrCreateConfiguration((DebeziumMongodbComponent) component).setOffsetStorageReplicationFactor((int) value); return true;
            case "offsetStorageTopic": getOrCreateConfiguration((DebeziumMongodbComponent) component).setOffsetStorageTopic((java.lang.String) value); return true;
            case "autowiredEnabled": ((DebeziumMongodbComponent) component).setAutowiredEnabled((boolean) value); return true;
            case "captureMode": getOrCreateConfiguration((DebeziumMongodbComponent) component).setCaptureMode((java.lang.String) value); return true;
            case "collectionExcludeList": getOrCreateConfiguration((DebeziumMongodbComponent) component).setCollectionExcludeList((java.lang.String) value); return true;
            case "collectionIncludeList": getOrCreateConfiguration((DebeziumMongodbComponent) component).setCollectionIncludeList((java.lang.String) value); return true;
            case "converters": getOrCreateConfiguration((DebeziumMongodbComponent) component).setConverters((java.lang.String) value); return true;
            case "cursorMaxAwaitTimeMs": getOrCreateConfiguration((DebeziumMongodbComponent) component).setCursorMaxAwaitTimeMs((int) value); return true;
            case "customMetricTags": getOrCreateConfiguration((DebeziumMongodbComponent) component).setCustomMetricTags((java.lang.String) value); return true;
            case "databaseExcludeList": getOrCreateConfiguration((DebeziumMongodbComponent) component).setDatabaseExcludeList((java.lang.String) value); return true;
            case "databaseIncludeList": getOrCreateConfiguration((DebeziumMongodbComponent) component).setDatabaseIncludeList((java.lang.String) value); return true;
            case "errorsMaxRetries": getOrCreateConfiguration((DebeziumMongodbComponent) component).setErrorsMaxRetries((int) value); return true;
            case "eventProcessingFailureHandlingMode": getOrCreateConfiguration((DebeziumMongodbComponent) component).setEventProcessingFailureHandlingMode((java.lang.String) value); return true;
            case "fieldExcludeList": getOrCreateConfiguration((DebeziumMongodbComponent) component).setFieldExcludeList((java.lang.String) value); return true;
            case "fieldRenames": getOrCreateConfiguration((DebeziumMongodbComponent) component).setFieldRenames((java.lang.String) value); return true;
            case "heartbeatIntervalMs": getOrCreateConfiguration((DebeziumMongodbComponent) component).setHeartbeatIntervalMs((int) value); return true;
            case "heartbeatTopicsPrefix": getOrCreateConfiguration((DebeziumMongodbComponent) component).setHeartbeatTopicsPrefix((java.lang.String) value); return true;
            case "incrementalSnapshotWatermarkingStrategy": getOrCreateConfiguration((DebeziumMongodbComponent) component).setIncrementalSnapshotWatermarkingStrategy((java.lang.String) value); return true;
            case "maxBatchSize": getOrCreateConfiguration((DebeziumMongodbComponent) component).setMaxBatchSize((int) value); return true;
            case "maxQueueSize": getOrCreateConfiguration((DebeziumMongodbComponent) component).setMaxQueueSize((int) value); return true;
            case "maxQueueSizeInBytes": getOrCreateConfiguration((DebeziumMongodbComponent) component).setMaxQueueSizeInBytes((long) value); return true;
            case "mongodbAuthsource": getOrCreateConfiguration((DebeziumMongodbComponent) component).setMongodbAuthsource((java.lang.String) value); return true;
            case "mongodbConnectionMode": getOrCreateConfiguration((DebeziumMongodbComponent) component).setMongodbConnectionMode((java.lang.String) value); return true;
            case "mongodbConnectionString": getOrCreateConfiguration((DebeziumMongodbComponent) component).setMongodbConnectionString((java.lang.String) value); return true;
            case "mongodbConnectTimeoutMs": getOrCreateConfiguration((DebeziumMongodbComponent) component).setMongodbConnectTimeoutMs((int) value); return true;
            case "mongodbHeartbeatFrequencyMs": getOrCreateConfiguration((DebeziumMongodbComponent) component).setMongodbHeartbeatFrequencyMs((int) value); return true;
            case "mongodbPassword": getOrCreateConfiguration((DebeziumMongodbComponent) component).setMongodbPassword((java.lang.String) value); return true;
            case "mongodbPollIntervalMs": getOrCreateConfiguration((DebeziumMongodbComponent) component).setMongodbPollIntervalMs((long) value); return true;
            case "mongodbServerSelectionTimeoutMs": getOrCreateConfiguration((DebeziumMongodbComponent) component).setMongodbServerSelectionTimeoutMs((int) value); return true;
            case "mongodbSocketTimeoutMs": getOrCreateConfiguration((DebeziumMongodbComponent) component).setMongodbSocketTimeoutMs((int) value); return true;
            case "mongodbSslEnabled": getOrCreateConfiguration((DebeziumMongodbComponent) component).setMongodbSslEnabled((boolean) value); return true;
            case "mongodbSslInvalidHostnameAllowed": getOrCreateConfiguration((DebeziumMongodbComponent) component).setMongodbSslInvalidHostnameAllowed((boolean) value); return true;
            case "mongodbUser": getOrCreateConfiguration((DebeziumMongodbComponent) component).setMongodbUser((java.lang.String) value); return true;
            case "notificationEnabledChannels": getOrCreateConfiguration((DebeziumMongodbComponent) component).setNotificationEnabledChannels((java.lang.String) value); return true;
            case "notificationSinkTopicName": getOrCreateConfiguration((DebeziumMongodbComponent) component).setNotificationSinkTopicName((java.lang.String) value); return true;
            case "pollIntervalMs": getOrCreateConfiguration((DebeziumMongodbComponent) component).setPollIntervalMs((long) value); return true;
            case "postProcessors": getOrCreateConfiguration((DebeziumMongodbComponent) component).setPostProcessors((java.lang.String) value); return true;
            case "provideTransactionMetadata": getOrCreateConfiguration((DebeziumMongodbComponent) component).setProvideTransactionMetadata((boolean) value); return true;
            case "queryFetchSize": getOrCreateConfiguration((DebeziumMongodbComponent) component).setQueryFetchSize((int) value); return true;
            case "retriableRestartConnectorWaitMs": getOrCreateConfiguration((DebeziumMongodbComponent) component).setRetriableRestartConnectorWaitMs((long) value); return true;
            case "schemaHistoryInternalFileFilename": getOrCreateConfiguration((DebeziumMongodbComponent) component).setSchemaHistoryInternalFileFilename((java.lang.String) value); return true;
            case "schemaNameAdjustmentMode": getOrCreateConfiguration((DebeziumMongodbComponent) component).setSchemaNameAdjustmentMode((java.lang.String) value); return true;
            case "signalDataCollection": getOrCreateConfiguration((DebeziumMongodbComponent) component).setSignalDataCollection((java.lang.String) value); return true;
            case "signalEnabledChannels": getOrCreateConfiguration((DebeziumMongodbComponent) component).setSignalEnabledChannels((java.lang.String) value); return true;
            case "signalPollIntervalMs": getOrCreateConfiguration((DebeziumMongodbComponent) component).setSignalPollIntervalMs((long) value); return true;
            case "skippedOperations": getOrCreateConfiguration((DebeziumMongodbComponent) component).setSkippedOperations((java.lang.String) value); return true;
            case "snapshotCollectionFilterOverrides": getOrCreateConfiguration((DebeziumMongodbComponent) component).setSnapshotCollectionFilterOverrides((java.lang.String) value); return true;
            case "snapshotDelayMs": getOrCreateConfiguration((DebeziumMongodbComponent) component).setSnapshotDelayMs((long) value); return true;
            case "snapshotFetchSize": getOrCreateConfiguration((DebeziumMongodbComponent) component).setSnapshotFetchSize((int) value); return true;
            case "snapshotIncludeCollectionList": getOrCreateConfiguration((DebeziumMongodbComponent) component).setSnapshotIncludeCollectionList((java.lang.String) value); return true;
            case "snapshotMaxThreads": getOrCreateConfiguration((DebeziumMongodbComponent) component).setSnapshotMaxThreads((int) value); return true;
            case "snapshotMode": getOrCreateConfiguration((DebeziumMongodbComponent) component).setSnapshotMode((java.lang.String) value); return true;
            case "sourceinfoStructMaker": getOrCreateConfiguration((DebeziumMongodbComponent) component).setSourceinfoStructMaker((java.lang.String) value); return true;
            case "tombstonesOnDelete": getOrCreateConfiguration((DebeziumMongodbComponent) component).setTombstonesOnDelete((boolean) value); return true;
            case "topicNamingStrategy": getOrCreateConfiguration((DebeziumMongodbComponent) component).setTopicNamingStrategy((java.lang.String) value); return true;
            case "topicPrefix": getOrCreateConfiguration((DebeziumMongodbComponent) component).setTopicPrefix((java.lang.String) value); return true;
            default: return false;
            }
        }
    }
}