/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.apache.camel.builder.component.dsl;

import javax.annotation.processing.Generated;
import org.apache.camel.Component;
import org.apache.camel.builder.component.AbstractComponentBuilder;
import org.apache.camel.builder.component.ComponentBuilder;
import org.apache.camel.component.jcache.JCacheComponent;

/**
 * Perform caching operations against JSR107/JCache.
 * 
 * Generated by camel-package-maven-plugin - do not edit this file!
 */
@Generated("org.apache.camel.maven.packaging.ComponentDslMojo")
public interface JcacheComponentBuilderFactory {

    /**
     * JCache (camel-jcache)
     * Perform caching operations against JSR107/JCache.
     * 
     * Category: cache,clustering
     * Since: 2.17
     * Maven coordinates: org.apache.camel:camel-jcache
     * 
     * @return the dsl builder
     */
    static JcacheComponentBuilder jcache() {
        return new JcacheComponentBuilderImpl();
    }

    /**
     * Builder for the JCache component.
     */
    interface JcacheComponentBuilder
            extends
                ComponentBuilder<JCacheComponent> {
        /**
         * A Configuration for the Cache.
         * 
         * The option is a:
         * &lt;code&gt;javax.cache.configuration.Configuration&lt;/code&gt;
         * type.
         * 
         * Group: common
         * 
         * @param cacheConfiguration the value to set
         * @return the dsl builder
         */
        default JcacheComponentBuilder cacheConfiguration(
                javax.cache.configuration.Configuration cacheConfiguration) {
            doSetProperty("cacheConfiguration", cacheConfiguration);
            return this;
        }
        /**
         * Properties to configure jcache.
         * 
         * The option is a: &lt;code&gt;java.util.Map&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param cacheConfigurationProperties the value to set
         * @return the dsl builder
         */
        default JcacheComponentBuilder cacheConfigurationProperties(
                java.util.Map cacheConfigurationProperties) {
            doSetProperty("cacheConfigurationProperties", cacheConfigurationProperties);
            return this;
        }
        /**
         * References to an existing Properties or Map to lookup in the registry
         * to use for configuring jcache.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param cacheConfigurationPropertiesRef the value to set
         * @return the dsl builder
         */
        default JcacheComponentBuilder cacheConfigurationPropertiesRef(
                java.lang.String cacheConfigurationPropertiesRef) {
            doSetProperty("cacheConfigurationPropertiesRef", cacheConfigurationPropertiesRef);
            return this;
        }
        /**
         * The fully qualified class name of the
         * javax.cache.spi.CachingProvider.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param cachingProvider the value to set
         * @return the dsl builder
         */
        default JcacheComponentBuilder cachingProvider(
                java.lang.String cachingProvider) {
            doSetProperty("cachingProvider", cachingProvider);
            return this;
        }
        /**
         * An implementation specific URI for the CacheManager.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param configurationUri the value to set
         * @return the dsl builder
         */
        default JcacheComponentBuilder configurationUri(
                java.lang.String configurationUri) {
            doSetProperty("configurationUri", configurationUri);
            return this;
        }
        /**
         * Allows for bridging the consumer to the Camel routing Error Handler,
         * which mean any exceptions (if possible) occurred while the Camel
         * consumer is trying to pickup incoming messages, or the likes, will
         * now be processed as a message and handled by the routing Error
         * Handler. Important: This is only possible if the 3rd party component
         * allows Camel to be alerted if an exception was thrown. Some
         * components handle this internally only, and therefore
         * bridgeErrorHandler is not possible. In other situations we may
         * improve the Camel component to hook into the 3rd party component and
         * make this possible for future releases. By default the consumer will
         * use the org.apache.camel.spi.ExceptionHandler to deal with
         * exceptions, that will be logged at WARN or ERROR level and ignored.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: false
         * Group: consumer
         * 
         * @param bridgeErrorHandler the value to set
         * @return the dsl builder
         */
        default JcacheComponentBuilder bridgeErrorHandler(
                boolean bridgeErrorHandler) {
            doSetProperty("bridgeErrorHandler", bridgeErrorHandler);
            return this;
        }
        /**
         * Whether the producer should be started lazy (on the first message).
         * By starting lazy you can use this to allow CamelContext and routes to
         * startup in situations where a producer may otherwise fail during
         * starting and cause the route to fail being started. By deferring this
         * startup to be lazy then the startup failure can be handled during
         * routing messages via Camel's routing error handlers. Beware that when
         * the first message is processed then creating and starting the
         * producer may take a little time and prolong the total processing time
         * of the processing.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: false
         * Group: producer
         * 
         * @param lazyStartProducer the value to set
         * @return the dsl builder
         */
        default JcacheComponentBuilder lazyStartProducer(
                boolean lazyStartProducer) {
            doSetProperty("lazyStartProducer", lazyStartProducer);
            return this;
        }
        /**
         * Whether autowiring is enabled. This is used for automatic autowiring
         * options (the option must be marked as autowired) by looking up in the
         * registry to find if there is a single instance of matching type,
         * which then gets configured on the component. This can be used for
         * automatic configuring JDBC data sources, JMS connection factories,
         * AWS Clients, etc.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: true
         * Group: advanced
         * 
         * @param autowiredEnabled the value to set
         * @return the dsl builder
         */
        default JcacheComponentBuilder autowiredEnabled(boolean autowiredEnabled) {
            doSetProperty("autowiredEnabled", autowiredEnabled);
            return this;
        }
    }

    class JcacheComponentBuilderImpl
            extends
                AbstractComponentBuilder<JCacheComponent>
            implements
                JcacheComponentBuilder {
        @Override
        protected JCacheComponent buildConcreteComponent() {
            return new JCacheComponent();
        }
        @Override
        protected boolean setPropertyOnComponent(
                Component component,
                String name,
                Object value) {
            switch (name) {
            case "cacheConfiguration": ((JCacheComponent) component).setCacheConfiguration((javax.cache.configuration.Configuration) value); return true;
            case "cacheConfigurationProperties": ((JCacheComponent) component).setCacheConfigurationProperties((java.util.Map) value); return true;
            case "cacheConfigurationPropertiesRef": ((JCacheComponent) component).setCacheConfigurationPropertiesRef((java.lang.String) value); return true;
            case "cachingProvider": ((JCacheComponent) component).setCachingProvider((java.lang.String) value); return true;
            case "configurationUri": ((JCacheComponent) component).setConfigurationUri((java.lang.String) value); return true;
            case "bridgeErrorHandler": ((JCacheComponent) component).setBridgeErrorHandler((boolean) value); return true;
            case "lazyStartProducer": ((JCacheComponent) component).setLazyStartProducer((boolean) value); return true;
            case "autowiredEnabled": ((JCacheComponent) component).setAutowiredEnabled((boolean) value); return true;
            default: return false;
            }
        }
    }
}