/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.apache.camel.builder.component.dsl;

import javax.annotation.processing.Generated;
import org.apache.camel.Component;
import org.apache.camel.builder.component.AbstractComponentBuilder;
import org.apache.camel.builder.component.ComponentBuilder;
import org.apache.camel.component.rocketmq.RocketMQComponent;

/**
 * Send and receive messages from RocketMQ cluster.
 * 
 * Generated by camel-package-maven-plugin - do not edit this file!
 */
@Generated("org.apache.camel.maven.packaging.ComponentDslMojo")
public interface RocketmqComponentBuilderFactory {

    /**
     * RocketMQ (camel-rocketmq)
     * Send and receive messages from RocketMQ cluster.
     * 
     * Category: messaging
     * Since: 3.20
     * Maven coordinates: org.apache.camel:camel-rocketmq
     * 
     * @return the dsl builder
     */
    static RocketmqComponentBuilder rocketmq() {
        return new RocketmqComponentBuilderImpl();
    }

    /**
     * Builder for the RocketMQ component.
     */
    interface RocketmqComponentBuilder
            extends
                ComponentBuilder<RocketMQComponent> {
        /**
         * Name server address of RocketMQ cluster.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Default: localhost:9876
         * Group: common
         * 
         * @param namesrvAddr the value to set
         * @return the dsl builder
         */
        default RocketmqComponentBuilder namesrvAddr(
                java.lang.String namesrvAddr) {
            doSetProperty("namesrvAddr", namesrvAddr);
            return this;
        }
        /**
         * Each message would be sent with this tag.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param sendTag the value to set
         * @return the dsl builder
         */
        default RocketmqComponentBuilder sendTag(java.lang.String sendTag) {
            doSetProperty("sendTag", sendTag);
            return this;
        }
        /**
         * Allows for bridging the consumer to the Camel routing Error Handler,
         * which mean any exceptions (if possible) occurred while the Camel
         * consumer is trying to pickup incoming messages, or the likes, will
         * now be processed as a message and handled by the routing Error
         * Handler. Important: This is only possible if the 3rd party component
         * allows Camel to be alerted if an exception was thrown. Some
         * components handle this internally only, and therefore
         * bridgeErrorHandler is not possible. In other situations we may
         * improve the Camel component to hook into the 3rd party component and
         * make this possible for future releases. By default the consumer will
         * use the org.apache.camel.spi.ExceptionHandler to deal with
         * exceptions, that will be logged at WARN or ERROR level and ignored.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: false
         * Group: consumer
         * 
         * @param bridgeErrorHandler the value to set
         * @return the dsl builder
         */
        default RocketmqComponentBuilder bridgeErrorHandler(
                boolean bridgeErrorHandler) {
            doSetProperty("bridgeErrorHandler", bridgeErrorHandler);
            return this;
        }
        /**
         * Consumer group name.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: consumer
         * 
         * @param consumerGroup the value to set
         * @return the dsl builder
         */
        default RocketmqComponentBuilder consumerGroup(
                java.lang.String consumerGroup) {
            doSetProperty("consumerGroup", consumerGroup);
            return this;
        }
        /**
         * Subscribe tags of consumer. Multiple tags could be split by , such as
         * TagATagB.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Default: *
         * Group: consumer
         * 
         * @param subscribeTags the value to set
         * @return the dsl builder
         */
        default RocketmqComponentBuilder subscribeTags(
                java.lang.String subscribeTags) {
            doSetProperty("subscribeTags", subscribeTags);
            return this;
        }
        /**
         * Whether the producer should be started lazy (on the first message).
         * By starting lazy you can use this to allow CamelContext and routes to
         * startup in situations where a producer may otherwise fail during
         * starting and cause the route to fail being started. By deferring this
         * startup to be lazy then the startup failure can be handled during
         * routing messages via Camel's routing error handlers. Beware that when
         * the first message is processed then creating and starting the
         * producer may take a little time and prolong the total processing time
         * of the processing.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: false
         * Group: producer
         * 
         * @param lazyStartProducer the value to set
         * @return the dsl builder
         */
        default RocketmqComponentBuilder lazyStartProducer(
                boolean lazyStartProducer) {
            doSetProperty("lazyStartProducer", lazyStartProducer);
            return this;
        }
        /**
         * Producer group name.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: producer
         * 
         * @param producerGroup the value to set
         * @return the dsl builder
         */
        default RocketmqComponentBuilder producerGroup(
                java.lang.String producerGroup) {
            doSetProperty("producerGroup", producerGroup);
            return this;
        }
        /**
         * Consumer group name used for receiving response.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: producer
         * 
         * @param replyToConsumerGroup the value to set
         * @return the dsl builder
         */
        default RocketmqComponentBuilder replyToConsumerGroup(
                java.lang.String replyToConsumerGroup) {
            doSetProperty("replyToConsumerGroup", replyToConsumerGroup);
            return this;
        }
        /**
         * Topic used for receiving response when using in-out pattern.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: producer
         * 
         * @param replyToTopic the value to set
         * @return the dsl builder
         */
        default RocketmqComponentBuilder replyToTopic(
                java.lang.String replyToTopic) {
            doSetProperty("replyToTopic", replyToTopic);
            return this;
        }
        /**
         * Whether waiting for send result before routing to next endpoint.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: false
         * Group: producer
         * 
         * @param waitForSendResult the value to set
         * @return the dsl builder
         */
        default RocketmqComponentBuilder waitForSendResult(
                boolean waitForSendResult) {
            doSetProperty("waitForSendResult", waitForSendResult);
            return this;
        }
        /**
         * Whether autowiring is enabled. This is used for automatic autowiring
         * options (the option must be marked as autowired) by looking up in the
         * registry to find if there is a single instance of matching type,
         * which then gets configured on the component. This can be used for
         * automatic configuring JDBC data sources, JMS connection factories,
         * AWS Clients, etc.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: true
         * Group: advanced
         * 
         * @param autowiredEnabled the value to set
         * @return the dsl builder
         */
        default RocketmqComponentBuilder autowiredEnabled(
                boolean autowiredEnabled) {
            doSetProperty("autowiredEnabled", autowiredEnabled);
            return this;
        }
        /**
         * Check interval milliseconds of request timeout.
         * 
         * The option is a: &lt;code&gt;long&lt;/code&gt; type.
         * 
         * Default: 1000
         * Group: advanced
         * 
         * @param requestTimeoutCheckerIntervalMillis the value to set
         * @return the dsl builder
         */
        default RocketmqComponentBuilder requestTimeoutCheckerIntervalMillis(
                long requestTimeoutCheckerIntervalMillis) {
            doSetProperty("requestTimeoutCheckerIntervalMillis", requestTimeoutCheckerIntervalMillis);
            return this;
        }
        /**
         * Timeout milliseconds of receiving response when using in-out pattern.
         * 
         * The option is a: &lt;code&gt;long&lt;/code&gt; type.
         * 
         * Default: 10000
         * Group: advanced
         * 
         * @param requestTimeoutMillis the value to set
         * @return the dsl builder
         */
        default RocketmqComponentBuilder requestTimeoutMillis(
                long requestTimeoutMillis) {
            doSetProperty("requestTimeoutMillis", requestTimeoutMillis);
            return this;
        }
        /**
         * Access key for RocketMQ ACL.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: secret
         * 
         * @param accessKey the value to set
         * @return the dsl builder
         */
        default RocketmqComponentBuilder accessKey(java.lang.String accessKey) {
            doSetProperty("accessKey", accessKey);
            return this;
        }
        /**
         * Secret key for RocketMQ ACL.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: secret
         * 
         * @param secretKey the value to set
         * @return the dsl builder
         */
        default RocketmqComponentBuilder secretKey(java.lang.String secretKey) {
            doSetProperty("secretKey", secretKey);
            return this;
        }
    }

    class RocketmqComponentBuilderImpl
            extends
                AbstractComponentBuilder<RocketMQComponent>
            implements
                RocketmqComponentBuilder {
        @Override
        protected RocketMQComponent buildConcreteComponent() {
            return new RocketMQComponent();
        }
        @Override
        protected boolean setPropertyOnComponent(
                Component component,
                String name,
                Object value) {
            switch (name) {
            case "namesrvAddr": ((RocketMQComponent) component).setNamesrvAddr((java.lang.String) value); return true;
            case "sendTag": ((RocketMQComponent) component).setSendTag((java.lang.String) value); return true;
            case "bridgeErrorHandler": ((RocketMQComponent) component).setBridgeErrorHandler((boolean) value); return true;
            case "consumerGroup": ((RocketMQComponent) component).setConsumerGroup((java.lang.String) value); return true;
            case "subscribeTags": ((RocketMQComponent) component).setSubscribeTags((java.lang.String) value); return true;
            case "lazyStartProducer": ((RocketMQComponent) component).setLazyStartProducer((boolean) value); return true;
            case "producerGroup": ((RocketMQComponent) component).setProducerGroup((java.lang.String) value); return true;
            case "replyToConsumerGroup": ((RocketMQComponent) component).setReplyToConsumerGroup((java.lang.String) value); return true;
            case "replyToTopic": ((RocketMQComponent) component).setReplyToTopic((java.lang.String) value); return true;
            case "waitForSendResult": ((RocketMQComponent) component).setWaitForSendResult((boolean) value); return true;
            case "autowiredEnabled": ((RocketMQComponent) component).setAutowiredEnabled((boolean) value); return true;
            case "requestTimeoutCheckerIntervalMillis": ((RocketMQComponent) component).setRequestTimeoutCheckerIntervalMillis((long) value); return true;
            case "requestTimeoutMillis": ((RocketMQComponent) component).setRequestTimeoutMillis((long) value); return true;
            case "accessKey": ((RocketMQComponent) component).setAccessKey((java.lang.String) value); return true;
            case "secretKey": ((RocketMQComponent) component).setSecretKey((java.lang.String) value); return true;
            default: return false;
            }
        }
    }
}