/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.apache.camel.builder.endpoint.dsl;

import java.util.*;
import java.util.concurrent.*;
import java.util.function.*;
import java.util.stream.*;
import javax.annotation.processing.Generated;
import org.apache.camel.builder.EndpointConsumerBuilder;
import org.apache.camel.builder.EndpointProducerBuilder;
import org.apache.camel.builder.endpoint.AbstractEndpointBuilder;

/**
 * Expose REST services or call external REST services.
 * 
 * Generated by camel build tools - do NOT edit this file!
 */
@Generated("org.apache.camel.maven.packaging.EndpointDslMojo")
public interface RestEndpointBuilderFactory {


    /**
     * Builder for endpoint consumers for the REST component.
     */
    public interface RestEndpointConsumerBuilder
            extends
                EndpointConsumerBuilder {
        default AdvancedRestEndpointConsumerBuilder advanced() {
            return (AdvancedRestEndpointConsumerBuilder) this;
        }
        /**
         * Media type such as: 'text/xml', or 'application/json' this REST
         * service accepts. By default we accept all kinds of types.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param consumes the value to set
         * @return the dsl builder
         */
        default RestEndpointConsumerBuilder consumes(String consumes) {
            doSetProperty("consumes", consumes);
            return this;
        }
        /**
         * To declare the incoming POJO binding type as a FQN class name.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param inType the value to set
         * @return the dsl builder
         */
        default RestEndpointConsumerBuilder inType(String inType) {
            doSetProperty("inType", inType);
            return this;
        }
        /**
         * To declare the outgoing POJO binding type as a FQN class name.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param outType the value to set
         * @return the dsl builder
         */
        default RestEndpointConsumerBuilder outType(String outType) {
            doSetProperty("outType", outType);
            return this;
        }
        /**
         * Media type such as: 'text/xml', or 'application/json' this REST
         * service returns.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param produces the value to set
         * @return the dsl builder
         */
        default RestEndpointConsumerBuilder produces(String produces) {
            doSetProperty("produces", produces);
            return this;
        }
        /**
         * Name of the route this REST services creates.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param routeId the value to set
         * @return the dsl builder
         */
        default RestEndpointConsumerBuilder routeId(String routeId) {
            doSetProperty("routeId", routeId);
            return this;
        }
        /**
         * The Camel Rest component to use for the consumer REST transport, such
         * as jetty, servlet, undertow. If no component has been explicitly
         * configured, then Camel will lookup if there is a Camel component that
         * integrates with the Rest DSL, or if a
         * org.apache.camel.spi.RestConsumerFactory is registered in the
         * registry. If either one is found, then that is being used.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: consumer
         * 
         * @param consumerComponentName the value to set
         * @return the dsl builder
         */
        default RestEndpointConsumerBuilder consumerComponentName(
                String consumerComponentName) {
            doSetProperty("consumerComponentName", consumerComponentName);
            return this;
        }
        /**
         * Human description to document this REST service.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: consumer
         * 
         * @param description the value to set
         * @return the dsl builder
         */
        default RestEndpointConsumerBuilder description(String description) {
            doSetProperty("description", description);
            return this;
        }
    }

    /**
     * Advanced builder for endpoint consumers for the REST component.
     */
    public interface AdvancedRestEndpointConsumerBuilder
            extends
                EndpointConsumerBuilder {
        default RestEndpointConsumerBuilder basic() {
            return (RestEndpointConsumerBuilder) this;
        }
        /**
         * Allows for bridging the consumer to the Camel routing Error Handler,
         * which mean any exceptions (if possible) occurred while the Camel
         * consumer is trying to pickup incoming messages, or the likes, will
         * now be processed as a message and handled by the routing Error
         * Handler. Important: This is only possible if the 3rd party component
         * allows Camel to be alerted if an exception was thrown. Some
         * components handle this internally only, and therefore
         * bridgeErrorHandler is not possible. In other situations we may
         * improve the Camel component to hook into the 3rd party component and
         * make this possible for future releases. By default the consumer will
         * use the org.apache.camel.spi.ExceptionHandler to deal with
         * exceptions, that will be logged at WARN or ERROR level and ignored.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: false
         * Group: consumer (advanced)
         * 
         * @param bridgeErrorHandler the value to set
         * @return the dsl builder
         */
        default AdvancedRestEndpointConsumerBuilder bridgeErrorHandler(
                boolean bridgeErrorHandler) {
            doSetProperty("bridgeErrorHandler", bridgeErrorHandler);
            return this;
        }
        /**
         * Allows for bridging the consumer to the Camel routing Error Handler,
         * which mean any exceptions (if possible) occurred while the Camel
         * consumer is trying to pickup incoming messages, or the likes, will
         * now be processed as a message and handled by the routing Error
         * Handler. Important: This is only possible if the 3rd party component
         * allows Camel to be alerted if an exception was thrown. Some
         * components handle this internally only, and therefore
         * bridgeErrorHandler is not possible. In other situations we may
         * improve the Camel component to hook into the 3rd party component and
         * make this possible for future releases. By default the consumer will
         * use the org.apache.camel.spi.ExceptionHandler to deal with
         * exceptions, that will be logged at WARN or ERROR level and ignored.
         * 
         * The option will be converted to a &lt;code&gt;boolean&lt;/code&gt;
         * type.
         * 
         * Default: false
         * Group: consumer (advanced)
         * 
         * @param bridgeErrorHandler the value to set
         * @return the dsl builder
         */
        default AdvancedRestEndpointConsumerBuilder bridgeErrorHandler(
                String bridgeErrorHandler) {
            doSetProperty("bridgeErrorHandler", bridgeErrorHandler);
            return this;
        }
        /**
         * To let the consumer use a custom ExceptionHandler. Notice if the
         * option bridgeErrorHandler is enabled then this option is not in use.
         * By default the consumer will deal with exceptions, that will be
         * logged at WARN or ERROR level and ignored.
         * 
         * The option is a:
         * &lt;code&gt;org.apache.camel.spi.ExceptionHandler&lt;/code&gt; type.
         * 
         * Group: consumer (advanced)
         * 
         * @param exceptionHandler the value to set
         * @return the dsl builder
         */
        default AdvancedRestEndpointConsumerBuilder exceptionHandler(
                org.apache.camel.spi.ExceptionHandler exceptionHandler) {
            doSetProperty("exceptionHandler", exceptionHandler);
            return this;
        }
        /**
         * To let the consumer use a custom ExceptionHandler. Notice if the
         * option bridgeErrorHandler is enabled then this option is not in use.
         * By default the consumer will deal with exceptions, that will be
         * logged at WARN or ERROR level and ignored.
         * 
         * The option will be converted to a
         * &lt;code&gt;org.apache.camel.spi.ExceptionHandler&lt;/code&gt; type.
         * 
         * Group: consumer (advanced)
         * 
         * @param exceptionHandler the value to set
         * @return the dsl builder
         */
        default AdvancedRestEndpointConsumerBuilder exceptionHandler(
                String exceptionHandler) {
            doSetProperty("exceptionHandler", exceptionHandler);
            return this;
        }
        /**
         * Sets the exchange pattern when the consumer creates an exchange.
         * 
         * The option is a:
         * &lt;code&gt;org.apache.camel.ExchangePattern&lt;/code&gt; type.
         * 
         * Group: consumer (advanced)
         * 
         * @param exchangePattern the value to set
         * @return the dsl builder
         */
        default AdvancedRestEndpointConsumerBuilder exchangePattern(
                org.apache.camel.ExchangePattern exchangePattern) {
            doSetProperty("exchangePattern", exchangePattern);
            return this;
        }
        /**
         * Sets the exchange pattern when the consumer creates an exchange.
         * 
         * The option will be converted to a
         * &lt;code&gt;org.apache.camel.ExchangePattern&lt;/code&gt; type.
         * 
         * Group: consumer (advanced)
         * 
         * @param exchangePattern the value to set
         * @return the dsl builder
         */
        default AdvancedRestEndpointConsumerBuilder exchangePattern(
                String exchangePattern) {
            doSetProperty("exchangePattern", exchangePattern);
            return this;
        }
    }

    /**
     * Builder for endpoint producers for the REST component.
     */
    public interface RestEndpointProducerBuilder
            extends
                EndpointProducerBuilder {
        default AdvancedRestEndpointProducerBuilder advanced() {
            return (AdvancedRestEndpointProducerBuilder) this;
        }
        /**
         * Media type such as: 'text/xml', or 'application/json' this REST
         * service accepts. By default we accept all kinds of types.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param consumes the value to set
         * @return the dsl builder
         */
        default RestEndpointProducerBuilder consumes(String consumes) {
            doSetProperty("consumes", consumes);
            return this;
        }
        /**
         * To declare the incoming POJO binding type as a FQN class name.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param inType the value to set
         * @return the dsl builder
         */
        default RestEndpointProducerBuilder inType(String inType) {
            doSetProperty("inType", inType);
            return this;
        }
        /**
         * To declare the outgoing POJO binding type as a FQN class name.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param outType the value to set
         * @return the dsl builder
         */
        default RestEndpointProducerBuilder outType(String outType) {
            doSetProperty("outType", outType);
            return this;
        }
        /**
         * Media type such as: 'text/xml', or 'application/json' this REST
         * service returns.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param produces the value to set
         * @return the dsl builder
         */
        default RestEndpointProducerBuilder produces(String produces) {
            doSetProperty("produces", produces);
            return this;
        }
        /**
         * Name of the route this REST services creates.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param routeId the value to set
         * @return the dsl builder
         */
        default RestEndpointProducerBuilder routeId(String routeId) {
            doSetProperty("routeId", routeId);
            return this;
        }
        /**
         * The openapi api doc resource to use. The resource is loaded from
         * classpath by default and must be in JSON format.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: producer
         * 
         * @param apiDoc the value to set
         * @return the dsl builder
         */
        default RestEndpointProducerBuilder apiDoc(String apiDoc) {
            doSetProperty("apiDoc", apiDoc);
            return this;
        }
        /**
         * Configures the binding mode for the producer. If set to anything
         * other than 'off' the producer will try to convert the body of the
         * incoming message from inType to the json or xml, and the response
         * from json or xml to outType.
         * 
         * The option is a:
         * &lt;code&gt;org.apache.camel.spi.RestConfiguration.RestBindingMode&lt;/code&gt; type.
         * 
         * Group: producer
         * 
         * @param bindingMode the value to set
         * @return the dsl builder
         */
        default RestEndpointProducerBuilder bindingMode(
                org.apache.camel.spi.RestConfiguration.RestBindingMode bindingMode) {
            doSetProperty("bindingMode", bindingMode);
            return this;
        }
        /**
         * Configures the binding mode for the producer. If set to anything
         * other than 'off' the producer will try to convert the body of the
         * incoming message from inType to the json or xml, and the response
         * from json or xml to outType.
         * 
         * The option will be converted to a
         * &lt;code&gt;org.apache.camel.spi.RestConfiguration.RestBindingMode&lt;/code&gt; type.
         * 
         * Group: producer
         * 
         * @param bindingMode the value to set
         * @return the dsl builder
         */
        default RestEndpointProducerBuilder bindingMode(String bindingMode) {
            doSetProperty("bindingMode", bindingMode);
            return this;
        }
        /**
         * Host and port of HTTP service to use (override host in openapi
         * schema).
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: producer
         * 
         * @param host the value to set
         * @return the dsl builder
         */
        default RestEndpointProducerBuilder host(String host) {
            doSetProperty("host", host);
            return this;
        }
        /**
         * The Camel Rest component to use for the producer REST transport, such
         * as http, undertow. If no component has been explicitly configured,
         * then Camel will lookup if there is a Camel component that integrates
         * with the Rest DSL, or if a org.apache.camel.spi.RestProducerFactory
         * is registered in the registry. If either one is found, then that is
         * being used.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: producer
         * 
         * @param producerComponentName the value to set
         * @return the dsl builder
         */
        default RestEndpointProducerBuilder producerComponentName(
                String producerComponentName) {
            doSetProperty("producerComponentName", producerComponentName);
            return this;
        }
        /**
         * Query parameters for the HTTP service to call. The query parameters
         * can contain multiple parameters separated by ampersand such such as
         * foo=123&amp;amp;bar=456.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: producer
         * 
         * @param queryParameters the value to set
         * @return the dsl builder
         */
        default RestEndpointProducerBuilder queryParameters(
                String queryParameters) {
            doSetProperty("queryParameters", queryParameters);
            return this;
        }
    }

    /**
     * Advanced builder for endpoint producers for the REST component.
     */
    public interface AdvancedRestEndpointProducerBuilder
            extends
                EndpointProducerBuilder {
        default RestEndpointProducerBuilder basic() {
            return (RestEndpointProducerBuilder) this;
        }
        /**
         * Whether the producer should be started lazy (on the first message).
         * By starting lazy you can use this to allow CamelContext and routes to
         * startup in situations where a producer may otherwise fail during
         * starting and cause the route to fail being started. By deferring this
         * startup to be lazy then the startup failure can be handled during
         * routing messages via Camel's routing error handlers. Beware that when
         * the first message is processed then creating and starting the
         * producer may take a little time and prolong the total processing time
         * of the processing.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: false
         * Group: producer (advanced)
         * 
         * @param lazyStartProducer the value to set
         * @return the dsl builder
         */
        default AdvancedRestEndpointProducerBuilder lazyStartProducer(
                boolean lazyStartProducer) {
            doSetProperty("lazyStartProducer", lazyStartProducer);
            return this;
        }
        /**
         * Whether the producer should be started lazy (on the first message).
         * By starting lazy you can use this to allow CamelContext and routes to
         * startup in situations where a producer may otherwise fail during
         * starting and cause the route to fail being started. By deferring this
         * startup to be lazy then the startup failure can be handled during
         * routing messages via Camel's routing error handlers. Beware that when
         * the first message is processed then creating and starting the
         * producer may take a little time and prolong the total processing time
         * of the processing.
         * 
         * The option will be converted to a &lt;code&gt;boolean&lt;/code&gt;
         * type.
         * 
         * Default: false
         * Group: producer (advanced)
         * 
         * @param lazyStartProducer the value to set
         * @return the dsl builder
         */
        default AdvancedRestEndpointProducerBuilder lazyStartProducer(
                String lazyStartProducer) {
            doSetProperty("lazyStartProducer", lazyStartProducer);
            return this;
        }
    }

    /**
     * Builder for endpoint for the REST component.
     */
    public interface RestEndpointBuilder
            extends
                RestEndpointConsumerBuilder,
                RestEndpointProducerBuilder {
        default AdvancedRestEndpointBuilder advanced() {
            return (AdvancedRestEndpointBuilder) this;
        }
        /**
         * Media type such as: 'text/xml', or 'application/json' this REST
         * service accepts. By default we accept all kinds of types.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param consumes the value to set
         * @return the dsl builder
         */
        default RestEndpointBuilder consumes(String consumes) {
            doSetProperty("consumes", consumes);
            return this;
        }
        /**
         * To declare the incoming POJO binding type as a FQN class name.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param inType the value to set
         * @return the dsl builder
         */
        default RestEndpointBuilder inType(String inType) {
            doSetProperty("inType", inType);
            return this;
        }
        /**
         * To declare the outgoing POJO binding type as a FQN class name.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param outType the value to set
         * @return the dsl builder
         */
        default RestEndpointBuilder outType(String outType) {
            doSetProperty("outType", outType);
            return this;
        }
        /**
         * Media type such as: 'text/xml', or 'application/json' this REST
         * service returns.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param produces the value to set
         * @return the dsl builder
         */
        default RestEndpointBuilder produces(String produces) {
            doSetProperty("produces", produces);
            return this;
        }
        /**
         * Name of the route this REST services creates.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param routeId the value to set
         * @return the dsl builder
         */
        default RestEndpointBuilder routeId(String routeId) {
            doSetProperty("routeId", routeId);
            return this;
        }
    }

    /**
     * Advanced builder for endpoint for the REST component.
     */
    public interface AdvancedRestEndpointBuilder
            extends
                AdvancedRestEndpointConsumerBuilder,
                AdvancedRestEndpointProducerBuilder {
        default RestEndpointBuilder basic() {
            return (RestEndpointBuilder) this;
        }
    }

    public interface RestBuilders {
        /**
         * REST (camel-rest)
         * Expose REST services or call external REST services.
         * 
         * Category: core,rest
         * Since: 2.14
         * Maven coordinates: org.apache.camel:camel-rest
         * 
         * @return the dsl builder for the headers' name.
         */
        default RestHeaderNameBuilder restEndpoint() {
            return RestHeaderNameBuilder.INSTANCE;
        }
        /**
         * REST (camel-rest)
         * Expose REST services or call external REST services.
         * 
         * Category: core,rest
         * Since: 2.14
         * Maven coordinates: org.apache.camel:camel-rest
         * 
         * Syntax: <code>rest:method:path:uriTemplate</code>
         * 
         * Path parameter: method (required)
         * HTTP method to use.
         * There are 9 enums and the value can be one of: get, post, put,
         * delete, patch, head, trace, connect, options
         * 
         * Path parameter: path (required)
         * The base path, can use &#42; as path suffix to support wildcard HTTP
         * route matching.
         * 
         * Path parameter: uriTemplate
         * The uri template
         * 
         * @param path method:path:uriTemplate
         * @return the dsl builder
         */
        default RestEndpointBuilder restEndpoint(String path) {
            return RestEndpointBuilderFactory.endpointBuilder("rest", path);
        }
        /**
         * REST (camel-rest)
         * Expose REST services or call external REST services.
         * 
         * Category: core,rest
         * Since: 2.14
         * Maven coordinates: org.apache.camel:camel-rest
         * 
         * Syntax: <code>rest:method:path:uriTemplate</code>
         * 
         * Path parameter: method (required)
         * HTTP method to use.
         * There are 9 enums and the value can be one of: get, post, put,
         * delete, patch, head, trace, connect, options
         * 
         * Path parameter: path (required)
         * The base path, can use &#42; as path suffix to support wildcard HTTP
         * route matching.
         * 
         * Path parameter: uriTemplate
         * The uri template
         * 
         * @param componentName to use a custom component name for the endpoint
         * instead of the default name
         * @param path method:path:uriTemplate
         * @return the dsl builder
         */
        default RestEndpointBuilder restEndpoint(
                String componentName,
                String path) {
            return RestEndpointBuilderFactory.endpointBuilder(componentName, path);
        }
    }

    /**
     * The builder of headers' name for the REST component.
     */
    public static class RestHeaderNameBuilder {
        /**
         * The internal instance of the builder used to access to all the
         * methods representing the name of headers.
         */
        private static final RestHeaderNameBuilder INSTANCE = new RestHeaderNameBuilder();

        /**
         * The query parameters for the rest call to be used.
         * 
         * The option is a: {@code String} type.
         * 
         * Group: producer
         * 
         * @return the name of the header {@code RestHttpQuery}.
         */
        public String restHttpQuery() {
            return "CamelRestHttpQuery";
        }

        /**
         * The http uri for the rest call to be used.
         * 
         * The option is a: {@code String} type.
         * 
         * Group: producer
         * 
         * @return the name of the header {@code RestHttpUri}.
         */
        public String restHttpUri() {
            return "CamelRestHttpUri";
        }

        /**
         * The method should be in upper case.
         * 
         * The option is a: {@code String} type.
         * 
         * Group: producer
         * 
         * @return the name of the header {@code HttpMethod}.
         */
        public String httpMethod() {
            return "CamelHttpMethod";
        }

        /**
         * The media type such as: 'text/xml', or 'application/json' this REST
         * service returns.
         * 
         * The option is a: {@code String} type.
         * 
         * Group: producer
         * 
         * @return the name of the header {@code Content-Type}.
         */
        public String contentType() {
            return "Content-Type";
        }

        /**
         * The media type such as: 'text/xml', or 'application/json' this REST
         * service accepts.
         * 
         * The option is a: {@code String} type.
         * 
         * Group: producer
         * 
         * @return the name of the header {@code Accept}.
         */
        public String accept() {
            return "Accept";
        }

        /**
         * The http response code.
         * 
         * The option is a: {@code Integer} type.
         * 
         * Group: producer
         * 
         * @return the name of the header {@code HttpResponseCode}.
         */
        public String httpResponseCode() {
            return "CamelHttpResponseCode";
        }
    }
    static RestEndpointBuilder endpointBuilder(String componentName, String path) {
        class RestEndpointBuilderImpl extends AbstractEndpointBuilder implements RestEndpointBuilder, AdvancedRestEndpointBuilder {
            public RestEndpointBuilderImpl(String path) {
                super(componentName, path);
            }
        }
        return new RestEndpointBuilderImpl(path);
    }
}