/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.apache.camel.builder.endpoint.dsl;

import java.util.*;
import java.util.concurrent.*;
import java.util.function.*;
import java.util.stream.*;
import javax.annotation.processing.Generated;
import org.apache.camel.builder.EndpointConsumerBuilder;
import org.apache.camel.builder.EndpointProducerBuilder;
import org.apache.camel.builder.endpoint.AbstractEndpointBuilder;

/**
 * Send and receive messages to/from and IRC chat.
 * 
 * Generated by camel build tools - do NOT edit this file!
 */
@Generated("org.apache.camel.maven.packaging.EndpointDslMojo")
public interface IrcEndpointBuilderFactory {


    /**
     * Builder for endpoint consumers for the IRC component.
     */
    public interface IrcEndpointConsumerBuilder
            extends
                EndpointConsumerBuilder {
        default AdvancedIrcEndpointConsumerBuilder advanced() {
            return (AdvancedIrcEndpointConsumerBuilder) this;
        }
        /**
         * Whether to auto re-join when being kicked.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: true
         * Group: common
         * 
         * @param autoRejoin the value to set
         * @return the dsl builder
         */
        default IrcEndpointConsumerBuilder autoRejoin(boolean autoRejoin) {
            doSetProperty("autoRejoin", autoRejoin);
            return this;
        }
        /**
         * Whether to auto re-join when being kicked.
         * 
         * The option will be converted to a &lt;code&gt;boolean&lt;/code&gt;
         * type.
         * 
         * Default: true
         * Group: common
         * 
         * @param autoRejoin the value to set
         * @return the dsl builder
         */
        default IrcEndpointConsumerBuilder autoRejoin(String autoRejoin) {
            doSetProperty("autoRejoin", autoRejoin);
            return this;
        }
        /**
         * Comma separated list of IRC channels.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param channels the value to set
         * @return the dsl builder
         */
        default IrcEndpointConsumerBuilder channels(String channels) {
            doSetProperty("channels", channels);
            return this;
        }
        /**
         * Delay in milliseconds before sending commands after the connection is
         * established.
         * 
         * The option is a: &lt;code&gt;long&lt;/code&gt; type.
         * 
         * Default: 5000
         * Group: common
         * 
         * @param commandTimeout the value to set
         * @return the dsl builder
         */
        default IrcEndpointConsumerBuilder commandTimeout(long commandTimeout) {
            doSetProperty("commandTimeout", commandTimeout);
            return this;
        }
        /**
         * Delay in milliseconds before sending commands after the connection is
         * established.
         * 
         * The option will be converted to a &lt;code&gt;long&lt;/code&gt; type.
         * 
         * Default: 5000
         * Group: common
         * 
         * @param commandTimeout the value to set
         * @return the dsl builder
         */
        default IrcEndpointConsumerBuilder commandTimeout(String commandTimeout) {
            doSetProperty("commandTimeout", commandTimeout);
            return this;
        }
        /**
         * Comma separated list of keys for channels.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param keys the value to set
         * @return the dsl builder
         */
        default IrcEndpointConsumerBuilder keys(String keys) {
            doSetProperty("keys", keys);
            return this;
        }
        /**
         * Sends NAMES command to channel after joining it. onReply has to be
         * true in order to process the result which will have the header value
         * irc.num = '353'.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: false
         * Group: common
         * 
         * @param namesOnJoin the value to set
         * @return the dsl builder
         */
        default IrcEndpointConsumerBuilder namesOnJoin(boolean namesOnJoin) {
            doSetProperty("namesOnJoin", namesOnJoin);
            return this;
        }
        /**
         * Sends NAMES command to channel after joining it. onReply has to be
         * true in order to process the result which will have the header value
         * irc.num = '353'.
         * 
         * The option will be converted to a &lt;code&gt;boolean&lt;/code&gt;
         * type.
         * 
         * Default: false
         * Group: common
         * 
         * @param namesOnJoin the value to set
         * @return the dsl builder
         */
        default IrcEndpointConsumerBuilder namesOnJoin(String namesOnJoin) {
            doSetProperty("namesOnJoin", namesOnJoin);
            return this;
        }
        /**
         * The nickname used in chat.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param nickname the value to set
         * @return the dsl builder
         */
        default IrcEndpointConsumerBuilder nickname(String nickname) {
            doSetProperty("nickname", nickname);
            return this;
        }
        /**
         * Use persistent messages.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: true
         * Group: common
         * 
         * @param persistent the value to set
         * @return the dsl builder
         */
        @Deprecated
        default IrcEndpointConsumerBuilder persistent(boolean persistent) {
            doSetProperty("persistent", persistent);
            return this;
        }
        /**
         * Use persistent messages.
         * 
         * The option will be converted to a &lt;code&gt;boolean&lt;/code&gt;
         * type.
         * 
         * Default: true
         * Group: common
         * 
         * @param persistent the value to set
         * @return the dsl builder
         */
        @Deprecated
        default IrcEndpointConsumerBuilder persistent(String persistent) {
            doSetProperty("persistent", persistent);
            return this;
        }
        /**
         * The IRC user's actual name.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param realname the value to set
         * @return the dsl builder
         */
        default IrcEndpointConsumerBuilder realname(String realname) {
            doSetProperty("realname", realname);
            return this;
        }
        /**
         * Handle user join events.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: true
         * Group: filter
         * 
         * @param onJoin the value to set
         * @return the dsl builder
         */
        default IrcEndpointConsumerBuilder onJoin(boolean onJoin) {
            doSetProperty("onJoin", onJoin);
            return this;
        }
        /**
         * Handle user join events.
         * 
         * The option will be converted to a &lt;code&gt;boolean&lt;/code&gt;
         * type.
         * 
         * Default: true
         * Group: filter
         * 
         * @param onJoin the value to set
         * @return the dsl builder
         */
        default IrcEndpointConsumerBuilder onJoin(String onJoin) {
            doSetProperty("onJoin", onJoin);
            return this;
        }
        /**
         * Handle kick events.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: true
         * Group: filter
         * 
         * @param onKick the value to set
         * @return the dsl builder
         */
        default IrcEndpointConsumerBuilder onKick(boolean onKick) {
            doSetProperty("onKick", onKick);
            return this;
        }
        /**
         * Handle kick events.
         * 
         * The option will be converted to a &lt;code&gt;boolean&lt;/code&gt;
         * type.
         * 
         * Default: true
         * Group: filter
         * 
         * @param onKick the value to set
         * @return the dsl builder
         */
        default IrcEndpointConsumerBuilder onKick(String onKick) {
            doSetProperty("onKick", onKick);
            return this;
        }
        /**
         * Handle mode change events.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: true
         * Group: filter
         * 
         * @param onMode the value to set
         * @return the dsl builder
         */
        default IrcEndpointConsumerBuilder onMode(boolean onMode) {
            doSetProperty("onMode", onMode);
            return this;
        }
        /**
         * Handle mode change events.
         * 
         * The option will be converted to a &lt;code&gt;boolean&lt;/code&gt;
         * type.
         * 
         * Default: true
         * Group: filter
         * 
         * @param onMode the value to set
         * @return the dsl builder
         */
        default IrcEndpointConsumerBuilder onMode(String onMode) {
            doSetProperty("onMode", onMode);
            return this;
        }
        /**
         * Handle nickname change events.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: true
         * Group: filter
         * 
         * @param onNick the value to set
         * @return the dsl builder
         */
        default IrcEndpointConsumerBuilder onNick(boolean onNick) {
            doSetProperty("onNick", onNick);
            return this;
        }
        /**
         * Handle nickname change events.
         * 
         * The option will be converted to a &lt;code&gt;boolean&lt;/code&gt;
         * type.
         * 
         * Default: true
         * Group: filter
         * 
         * @param onNick the value to set
         * @return the dsl builder
         */
        default IrcEndpointConsumerBuilder onNick(String onNick) {
            doSetProperty("onNick", onNick);
            return this;
        }
        /**
         * Handle user part events.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: true
         * Group: filter
         * 
         * @param onPart the value to set
         * @return the dsl builder
         */
        default IrcEndpointConsumerBuilder onPart(boolean onPart) {
            doSetProperty("onPart", onPart);
            return this;
        }
        /**
         * Handle user part events.
         * 
         * The option will be converted to a &lt;code&gt;boolean&lt;/code&gt;
         * type.
         * 
         * Default: true
         * Group: filter
         * 
         * @param onPart the value to set
         * @return the dsl builder
         */
        default IrcEndpointConsumerBuilder onPart(String onPart) {
            doSetProperty("onPart", onPart);
            return this;
        }
        /**
         * Handle private message events.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: true
         * Group: filter
         * 
         * @param onPrivmsg the value to set
         * @return the dsl builder
         */
        default IrcEndpointConsumerBuilder onPrivmsg(boolean onPrivmsg) {
            doSetProperty("onPrivmsg", onPrivmsg);
            return this;
        }
        /**
         * Handle private message events.
         * 
         * The option will be converted to a &lt;code&gt;boolean&lt;/code&gt;
         * type.
         * 
         * Default: true
         * Group: filter
         * 
         * @param onPrivmsg the value to set
         * @return the dsl builder
         */
        default IrcEndpointConsumerBuilder onPrivmsg(String onPrivmsg) {
            doSetProperty("onPrivmsg", onPrivmsg);
            return this;
        }
        /**
         * Handle user quit events.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: true
         * Group: filter
         * 
         * @param onQuit the value to set
         * @return the dsl builder
         */
        default IrcEndpointConsumerBuilder onQuit(boolean onQuit) {
            doSetProperty("onQuit", onQuit);
            return this;
        }
        /**
         * Handle user quit events.
         * 
         * The option will be converted to a &lt;code&gt;boolean&lt;/code&gt;
         * type.
         * 
         * Default: true
         * Group: filter
         * 
         * @param onQuit the value to set
         * @return the dsl builder
         */
        default IrcEndpointConsumerBuilder onQuit(String onQuit) {
            doSetProperty("onQuit", onQuit);
            return this;
        }
        /**
         * Whether or not to handle general responses to commands or
         * informational messages.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: false
         * Group: filter
         * 
         * @param onReply the value to set
         * @return the dsl builder
         */
        default IrcEndpointConsumerBuilder onReply(boolean onReply) {
            doSetProperty("onReply", onReply);
            return this;
        }
        /**
         * Whether or not to handle general responses to commands or
         * informational messages.
         * 
         * The option will be converted to a &lt;code&gt;boolean&lt;/code&gt;
         * type.
         * 
         * Default: false
         * Group: filter
         * 
         * @param onReply the value to set
         * @return the dsl builder
         */
        default IrcEndpointConsumerBuilder onReply(String onReply) {
            doSetProperty("onReply", onReply);
            return this;
        }
        /**
         * Handle topic change events.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: true
         * Group: filter
         * 
         * @param onTopic the value to set
         * @return the dsl builder
         */
        default IrcEndpointConsumerBuilder onTopic(boolean onTopic) {
            doSetProperty("onTopic", onTopic);
            return this;
        }
        /**
         * Handle topic change events.
         * 
         * The option will be converted to a &lt;code&gt;boolean&lt;/code&gt;
         * type.
         * 
         * Default: true
         * Group: filter
         * 
         * @param onTopic the value to set
         * @return the dsl builder
         */
        default IrcEndpointConsumerBuilder onTopic(String onTopic) {
            doSetProperty("onTopic", onTopic);
            return this;
        }
        /**
         * Your IRC server nickname password.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: security
         * 
         * @param nickPassword the value to set
         * @return the dsl builder
         */
        default IrcEndpointConsumerBuilder nickPassword(String nickPassword) {
            doSetProperty("nickPassword", nickPassword);
            return this;
        }
        /**
         * The IRC server password.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: security
         * 
         * @param password the value to set
         * @return the dsl builder
         */
        default IrcEndpointConsumerBuilder password(String password) {
            doSetProperty("password", password);
            return this;
        }
        /**
         * Used for configuring security using SSL. Reference to a
         * org.apache.camel.support.jsse.SSLContextParameters in the Registry.
         * This reference overrides any configured SSLContextParameters at the
         * component level. Note that this setting overrides the trustManager
         * option.
         * 
         * The option is a:
         * &lt;code&gt;org.apache.camel.support.jsse.SSLContextParameters&lt;/code&gt; type.
         * 
         * Group: security
         * 
         * @param sslContextParameters the value to set
         * @return the dsl builder
         */
        default IrcEndpointConsumerBuilder sslContextParameters(
                org.apache.camel.support.jsse.SSLContextParameters sslContextParameters) {
            doSetProperty("sslContextParameters", sslContextParameters);
            return this;
        }
        /**
         * Used for configuring security using SSL. Reference to a
         * org.apache.camel.support.jsse.SSLContextParameters in the Registry.
         * This reference overrides any configured SSLContextParameters at the
         * component level. Note that this setting overrides the trustManager
         * option.
         * 
         * The option will be converted to a
         * &lt;code&gt;org.apache.camel.support.jsse.SSLContextParameters&lt;/code&gt; type.
         * 
         * Group: security
         * 
         * @param sslContextParameters the value to set
         * @return the dsl builder
         */
        default IrcEndpointConsumerBuilder sslContextParameters(
                String sslContextParameters) {
            doSetProperty("sslContextParameters", sslContextParameters);
            return this;
        }
        /**
         * The trust manager used to verify the SSL server's certificate.
         * 
         * The option is a:
         * &lt;code&gt;org.schwering.irc.lib.ssl.SSLTrustManager&lt;/code&gt;
         * type.
         * 
         * Group: security
         * 
         * @param trustManager the value to set
         * @return the dsl builder
         */
        default IrcEndpointConsumerBuilder trustManager(
                org.schwering.irc.lib.ssl.SSLTrustManager trustManager) {
            doSetProperty("trustManager", trustManager);
            return this;
        }
        /**
         * The trust manager used to verify the SSL server's certificate.
         * 
         * The option will be converted to a
         * &lt;code&gt;org.schwering.irc.lib.ssl.SSLTrustManager&lt;/code&gt;
         * type.
         * 
         * Group: security
         * 
         * @param trustManager the value to set
         * @return the dsl builder
         */
        default IrcEndpointConsumerBuilder trustManager(String trustManager) {
            doSetProperty("trustManager", trustManager);
            return this;
        }
        /**
         * The IRC server user name.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: security
         * 
         * @param username the value to set
         * @return the dsl builder
         */
        default IrcEndpointConsumerBuilder username(String username) {
            doSetProperty("username", username);
            return this;
        }
    }

    /**
     * Advanced builder for endpoint consumers for the IRC component.
     */
    public interface AdvancedIrcEndpointConsumerBuilder
            extends
                EndpointConsumerBuilder {
        default IrcEndpointConsumerBuilder basic() {
            return (IrcEndpointConsumerBuilder) this;
        }
        /**
         * Allows for bridging the consumer to the Camel routing Error Handler,
         * which mean any exceptions (if possible) occurred while the Camel
         * consumer is trying to pickup incoming messages, or the likes, will
         * now be processed as a message and handled by the routing Error
         * Handler. Important: This is only possible if the 3rd party component
         * allows Camel to be alerted if an exception was thrown. Some
         * components handle this internally only, and therefore
         * bridgeErrorHandler is not possible. In other situations we may
         * improve the Camel component to hook into the 3rd party component and
         * make this possible for future releases. By default the consumer will
         * use the org.apache.camel.spi.ExceptionHandler to deal with
         * exceptions, that will be logged at WARN or ERROR level and ignored.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: false
         * Group: consumer (advanced)
         * 
         * @param bridgeErrorHandler the value to set
         * @return the dsl builder
         */
        default AdvancedIrcEndpointConsumerBuilder bridgeErrorHandler(
                boolean bridgeErrorHandler) {
            doSetProperty("bridgeErrorHandler", bridgeErrorHandler);
            return this;
        }
        /**
         * Allows for bridging the consumer to the Camel routing Error Handler,
         * which mean any exceptions (if possible) occurred while the Camel
         * consumer is trying to pickup incoming messages, or the likes, will
         * now be processed as a message and handled by the routing Error
         * Handler. Important: This is only possible if the 3rd party component
         * allows Camel to be alerted if an exception was thrown. Some
         * components handle this internally only, and therefore
         * bridgeErrorHandler is not possible. In other situations we may
         * improve the Camel component to hook into the 3rd party component and
         * make this possible for future releases. By default the consumer will
         * use the org.apache.camel.spi.ExceptionHandler to deal with
         * exceptions, that will be logged at WARN or ERROR level and ignored.
         * 
         * The option will be converted to a &lt;code&gt;boolean&lt;/code&gt;
         * type.
         * 
         * Default: false
         * Group: consumer (advanced)
         * 
         * @param bridgeErrorHandler the value to set
         * @return the dsl builder
         */
        default AdvancedIrcEndpointConsumerBuilder bridgeErrorHandler(
                String bridgeErrorHandler) {
            doSetProperty("bridgeErrorHandler", bridgeErrorHandler);
            return this;
        }
        /**
         * To let the consumer use a custom ExceptionHandler. Notice if the
         * option bridgeErrorHandler is enabled then this option is not in use.
         * By default the consumer will deal with exceptions, that will be
         * logged at WARN or ERROR level and ignored.
         * 
         * The option is a:
         * &lt;code&gt;org.apache.camel.spi.ExceptionHandler&lt;/code&gt; type.
         * 
         * Group: consumer (advanced)
         * 
         * @param exceptionHandler the value to set
         * @return the dsl builder
         */
        default AdvancedIrcEndpointConsumerBuilder exceptionHandler(
                org.apache.camel.spi.ExceptionHandler exceptionHandler) {
            doSetProperty("exceptionHandler", exceptionHandler);
            return this;
        }
        /**
         * To let the consumer use a custom ExceptionHandler. Notice if the
         * option bridgeErrorHandler is enabled then this option is not in use.
         * By default the consumer will deal with exceptions, that will be
         * logged at WARN or ERROR level and ignored.
         * 
         * The option will be converted to a
         * &lt;code&gt;org.apache.camel.spi.ExceptionHandler&lt;/code&gt; type.
         * 
         * Group: consumer (advanced)
         * 
         * @param exceptionHandler the value to set
         * @return the dsl builder
         */
        default AdvancedIrcEndpointConsumerBuilder exceptionHandler(
                String exceptionHandler) {
            doSetProperty("exceptionHandler", exceptionHandler);
            return this;
        }
        /**
         * Sets the exchange pattern when the consumer creates an exchange.
         * 
         * The option is a:
         * &lt;code&gt;org.apache.camel.ExchangePattern&lt;/code&gt; type.
         * 
         * Group: consumer (advanced)
         * 
         * @param exchangePattern the value to set
         * @return the dsl builder
         */
        default AdvancedIrcEndpointConsumerBuilder exchangePattern(
                org.apache.camel.ExchangePattern exchangePattern) {
            doSetProperty("exchangePattern", exchangePattern);
            return this;
        }
        /**
         * Sets the exchange pattern when the consumer creates an exchange.
         * 
         * The option will be converted to a
         * &lt;code&gt;org.apache.camel.ExchangePattern&lt;/code&gt; type.
         * 
         * Group: consumer (advanced)
         * 
         * @param exchangePattern the value to set
         * @return the dsl builder
         */
        default AdvancedIrcEndpointConsumerBuilder exchangePattern(
                String exchangePattern) {
            doSetProperty("exchangePattern", exchangePattern);
            return this;
        }
        /**
         * Whether or not the server supports color codes.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: true
         * Group: advanced
         * 
         * @param colors the value to set
         * @return the dsl builder
         */
        default AdvancedIrcEndpointConsumerBuilder colors(boolean colors) {
            doSetProperty("colors", colors);
            return this;
        }
        /**
         * Whether or not the server supports color codes.
         * 
         * The option will be converted to a &lt;code&gt;boolean&lt;/code&gt;
         * type.
         * 
         * Default: true
         * Group: advanced
         * 
         * @param colors the value to set
         * @return the dsl builder
         */
        default AdvancedIrcEndpointConsumerBuilder colors(String colors) {
            doSetProperty("colors", colors);
            return this;
        }
    }

    /**
     * Builder for endpoint producers for the IRC component.
     */
    public interface IrcEndpointProducerBuilder
            extends
                EndpointProducerBuilder {
        default AdvancedIrcEndpointProducerBuilder advanced() {
            return (AdvancedIrcEndpointProducerBuilder) this;
        }
        /**
         * Whether to auto re-join when being kicked.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: true
         * Group: common
         * 
         * @param autoRejoin the value to set
         * @return the dsl builder
         */
        default IrcEndpointProducerBuilder autoRejoin(boolean autoRejoin) {
            doSetProperty("autoRejoin", autoRejoin);
            return this;
        }
        /**
         * Whether to auto re-join when being kicked.
         * 
         * The option will be converted to a &lt;code&gt;boolean&lt;/code&gt;
         * type.
         * 
         * Default: true
         * Group: common
         * 
         * @param autoRejoin the value to set
         * @return the dsl builder
         */
        default IrcEndpointProducerBuilder autoRejoin(String autoRejoin) {
            doSetProperty("autoRejoin", autoRejoin);
            return this;
        }
        /**
         * Comma separated list of IRC channels.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param channels the value to set
         * @return the dsl builder
         */
        default IrcEndpointProducerBuilder channels(String channels) {
            doSetProperty("channels", channels);
            return this;
        }
        /**
         * Delay in milliseconds before sending commands after the connection is
         * established.
         * 
         * The option is a: &lt;code&gt;long&lt;/code&gt; type.
         * 
         * Default: 5000
         * Group: common
         * 
         * @param commandTimeout the value to set
         * @return the dsl builder
         */
        default IrcEndpointProducerBuilder commandTimeout(long commandTimeout) {
            doSetProperty("commandTimeout", commandTimeout);
            return this;
        }
        /**
         * Delay in milliseconds before sending commands after the connection is
         * established.
         * 
         * The option will be converted to a &lt;code&gt;long&lt;/code&gt; type.
         * 
         * Default: 5000
         * Group: common
         * 
         * @param commandTimeout the value to set
         * @return the dsl builder
         */
        default IrcEndpointProducerBuilder commandTimeout(String commandTimeout) {
            doSetProperty("commandTimeout", commandTimeout);
            return this;
        }
        /**
         * Comma separated list of keys for channels.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param keys the value to set
         * @return the dsl builder
         */
        default IrcEndpointProducerBuilder keys(String keys) {
            doSetProperty("keys", keys);
            return this;
        }
        /**
         * Sends NAMES command to channel after joining it. onReply has to be
         * true in order to process the result which will have the header value
         * irc.num = '353'.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: false
         * Group: common
         * 
         * @param namesOnJoin the value to set
         * @return the dsl builder
         */
        default IrcEndpointProducerBuilder namesOnJoin(boolean namesOnJoin) {
            doSetProperty("namesOnJoin", namesOnJoin);
            return this;
        }
        /**
         * Sends NAMES command to channel after joining it. onReply has to be
         * true in order to process the result which will have the header value
         * irc.num = '353'.
         * 
         * The option will be converted to a &lt;code&gt;boolean&lt;/code&gt;
         * type.
         * 
         * Default: false
         * Group: common
         * 
         * @param namesOnJoin the value to set
         * @return the dsl builder
         */
        default IrcEndpointProducerBuilder namesOnJoin(String namesOnJoin) {
            doSetProperty("namesOnJoin", namesOnJoin);
            return this;
        }
        /**
         * The nickname used in chat.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param nickname the value to set
         * @return the dsl builder
         */
        default IrcEndpointProducerBuilder nickname(String nickname) {
            doSetProperty("nickname", nickname);
            return this;
        }
        /**
         * Use persistent messages.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: true
         * Group: common
         * 
         * @param persistent the value to set
         * @return the dsl builder
         */
        @Deprecated
        default IrcEndpointProducerBuilder persistent(boolean persistent) {
            doSetProperty("persistent", persistent);
            return this;
        }
        /**
         * Use persistent messages.
         * 
         * The option will be converted to a &lt;code&gt;boolean&lt;/code&gt;
         * type.
         * 
         * Default: true
         * Group: common
         * 
         * @param persistent the value to set
         * @return the dsl builder
         */
        @Deprecated
        default IrcEndpointProducerBuilder persistent(String persistent) {
            doSetProperty("persistent", persistent);
            return this;
        }
        /**
         * The IRC user's actual name.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param realname the value to set
         * @return the dsl builder
         */
        default IrcEndpointProducerBuilder realname(String realname) {
            doSetProperty("realname", realname);
            return this;
        }
        /**
         * Handle user join events.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: true
         * Group: filter
         * 
         * @param onJoin the value to set
         * @return the dsl builder
         */
        default IrcEndpointProducerBuilder onJoin(boolean onJoin) {
            doSetProperty("onJoin", onJoin);
            return this;
        }
        /**
         * Handle user join events.
         * 
         * The option will be converted to a &lt;code&gt;boolean&lt;/code&gt;
         * type.
         * 
         * Default: true
         * Group: filter
         * 
         * @param onJoin the value to set
         * @return the dsl builder
         */
        default IrcEndpointProducerBuilder onJoin(String onJoin) {
            doSetProperty("onJoin", onJoin);
            return this;
        }
        /**
         * Handle kick events.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: true
         * Group: filter
         * 
         * @param onKick the value to set
         * @return the dsl builder
         */
        default IrcEndpointProducerBuilder onKick(boolean onKick) {
            doSetProperty("onKick", onKick);
            return this;
        }
        /**
         * Handle kick events.
         * 
         * The option will be converted to a &lt;code&gt;boolean&lt;/code&gt;
         * type.
         * 
         * Default: true
         * Group: filter
         * 
         * @param onKick the value to set
         * @return the dsl builder
         */
        default IrcEndpointProducerBuilder onKick(String onKick) {
            doSetProperty("onKick", onKick);
            return this;
        }
        /**
         * Handle mode change events.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: true
         * Group: filter
         * 
         * @param onMode the value to set
         * @return the dsl builder
         */
        default IrcEndpointProducerBuilder onMode(boolean onMode) {
            doSetProperty("onMode", onMode);
            return this;
        }
        /**
         * Handle mode change events.
         * 
         * The option will be converted to a &lt;code&gt;boolean&lt;/code&gt;
         * type.
         * 
         * Default: true
         * Group: filter
         * 
         * @param onMode the value to set
         * @return the dsl builder
         */
        default IrcEndpointProducerBuilder onMode(String onMode) {
            doSetProperty("onMode", onMode);
            return this;
        }
        /**
         * Handle nickname change events.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: true
         * Group: filter
         * 
         * @param onNick the value to set
         * @return the dsl builder
         */
        default IrcEndpointProducerBuilder onNick(boolean onNick) {
            doSetProperty("onNick", onNick);
            return this;
        }
        /**
         * Handle nickname change events.
         * 
         * The option will be converted to a &lt;code&gt;boolean&lt;/code&gt;
         * type.
         * 
         * Default: true
         * Group: filter
         * 
         * @param onNick the value to set
         * @return the dsl builder
         */
        default IrcEndpointProducerBuilder onNick(String onNick) {
            doSetProperty("onNick", onNick);
            return this;
        }
        /**
         * Handle user part events.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: true
         * Group: filter
         * 
         * @param onPart the value to set
         * @return the dsl builder
         */
        default IrcEndpointProducerBuilder onPart(boolean onPart) {
            doSetProperty("onPart", onPart);
            return this;
        }
        /**
         * Handle user part events.
         * 
         * The option will be converted to a &lt;code&gt;boolean&lt;/code&gt;
         * type.
         * 
         * Default: true
         * Group: filter
         * 
         * @param onPart the value to set
         * @return the dsl builder
         */
        default IrcEndpointProducerBuilder onPart(String onPart) {
            doSetProperty("onPart", onPart);
            return this;
        }
        /**
         * Handle private message events.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: true
         * Group: filter
         * 
         * @param onPrivmsg the value to set
         * @return the dsl builder
         */
        default IrcEndpointProducerBuilder onPrivmsg(boolean onPrivmsg) {
            doSetProperty("onPrivmsg", onPrivmsg);
            return this;
        }
        /**
         * Handle private message events.
         * 
         * The option will be converted to a &lt;code&gt;boolean&lt;/code&gt;
         * type.
         * 
         * Default: true
         * Group: filter
         * 
         * @param onPrivmsg the value to set
         * @return the dsl builder
         */
        default IrcEndpointProducerBuilder onPrivmsg(String onPrivmsg) {
            doSetProperty("onPrivmsg", onPrivmsg);
            return this;
        }
        /**
         * Handle user quit events.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: true
         * Group: filter
         * 
         * @param onQuit the value to set
         * @return the dsl builder
         */
        default IrcEndpointProducerBuilder onQuit(boolean onQuit) {
            doSetProperty("onQuit", onQuit);
            return this;
        }
        /**
         * Handle user quit events.
         * 
         * The option will be converted to a &lt;code&gt;boolean&lt;/code&gt;
         * type.
         * 
         * Default: true
         * Group: filter
         * 
         * @param onQuit the value to set
         * @return the dsl builder
         */
        default IrcEndpointProducerBuilder onQuit(String onQuit) {
            doSetProperty("onQuit", onQuit);
            return this;
        }
        /**
         * Whether or not to handle general responses to commands or
         * informational messages.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: false
         * Group: filter
         * 
         * @param onReply the value to set
         * @return the dsl builder
         */
        default IrcEndpointProducerBuilder onReply(boolean onReply) {
            doSetProperty("onReply", onReply);
            return this;
        }
        /**
         * Whether or not to handle general responses to commands or
         * informational messages.
         * 
         * The option will be converted to a &lt;code&gt;boolean&lt;/code&gt;
         * type.
         * 
         * Default: false
         * Group: filter
         * 
         * @param onReply the value to set
         * @return the dsl builder
         */
        default IrcEndpointProducerBuilder onReply(String onReply) {
            doSetProperty("onReply", onReply);
            return this;
        }
        /**
         * Handle topic change events.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: true
         * Group: filter
         * 
         * @param onTopic the value to set
         * @return the dsl builder
         */
        default IrcEndpointProducerBuilder onTopic(boolean onTopic) {
            doSetProperty("onTopic", onTopic);
            return this;
        }
        /**
         * Handle topic change events.
         * 
         * The option will be converted to a &lt;code&gt;boolean&lt;/code&gt;
         * type.
         * 
         * Default: true
         * Group: filter
         * 
         * @param onTopic the value to set
         * @return the dsl builder
         */
        default IrcEndpointProducerBuilder onTopic(String onTopic) {
            doSetProperty("onTopic", onTopic);
            return this;
        }
        /**
         * Your IRC server nickname password.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: security
         * 
         * @param nickPassword the value to set
         * @return the dsl builder
         */
        default IrcEndpointProducerBuilder nickPassword(String nickPassword) {
            doSetProperty("nickPassword", nickPassword);
            return this;
        }
        /**
         * The IRC server password.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: security
         * 
         * @param password the value to set
         * @return the dsl builder
         */
        default IrcEndpointProducerBuilder password(String password) {
            doSetProperty("password", password);
            return this;
        }
        /**
         * Used for configuring security using SSL. Reference to a
         * org.apache.camel.support.jsse.SSLContextParameters in the Registry.
         * This reference overrides any configured SSLContextParameters at the
         * component level. Note that this setting overrides the trustManager
         * option.
         * 
         * The option is a:
         * &lt;code&gt;org.apache.camel.support.jsse.SSLContextParameters&lt;/code&gt; type.
         * 
         * Group: security
         * 
         * @param sslContextParameters the value to set
         * @return the dsl builder
         */
        default IrcEndpointProducerBuilder sslContextParameters(
                org.apache.camel.support.jsse.SSLContextParameters sslContextParameters) {
            doSetProperty("sslContextParameters", sslContextParameters);
            return this;
        }
        /**
         * Used for configuring security using SSL. Reference to a
         * org.apache.camel.support.jsse.SSLContextParameters in the Registry.
         * This reference overrides any configured SSLContextParameters at the
         * component level. Note that this setting overrides the trustManager
         * option.
         * 
         * The option will be converted to a
         * &lt;code&gt;org.apache.camel.support.jsse.SSLContextParameters&lt;/code&gt; type.
         * 
         * Group: security
         * 
         * @param sslContextParameters the value to set
         * @return the dsl builder
         */
        default IrcEndpointProducerBuilder sslContextParameters(
                String sslContextParameters) {
            doSetProperty("sslContextParameters", sslContextParameters);
            return this;
        }
        /**
         * The trust manager used to verify the SSL server's certificate.
         * 
         * The option is a:
         * &lt;code&gt;org.schwering.irc.lib.ssl.SSLTrustManager&lt;/code&gt;
         * type.
         * 
         * Group: security
         * 
         * @param trustManager the value to set
         * @return the dsl builder
         */
        default IrcEndpointProducerBuilder trustManager(
                org.schwering.irc.lib.ssl.SSLTrustManager trustManager) {
            doSetProperty("trustManager", trustManager);
            return this;
        }
        /**
         * The trust manager used to verify the SSL server's certificate.
         * 
         * The option will be converted to a
         * &lt;code&gt;org.schwering.irc.lib.ssl.SSLTrustManager&lt;/code&gt;
         * type.
         * 
         * Group: security
         * 
         * @param trustManager the value to set
         * @return the dsl builder
         */
        default IrcEndpointProducerBuilder trustManager(String trustManager) {
            doSetProperty("trustManager", trustManager);
            return this;
        }
        /**
         * The IRC server user name.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: security
         * 
         * @param username the value to set
         * @return the dsl builder
         */
        default IrcEndpointProducerBuilder username(String username) {
            doSetProperty("username", username);
            return this;
        }
    }

    /**
     * Advanced builder for endpoint producers for the IRC component.
     */
    public interface AdvancedIrcEndpointProducerBuilder
            extends
                EndpointProducerBuilder {
        default IrcEndpointProducerBuilder basic() {
            return (IrcEndpointProducerBuilder) this;
        }
        /**
         * Whether the producer should be started lazy (on the first message).
         * By starting lazy you can use this to allow CamelContext and routes to
         * startup in situations where a producer may otherwise fail during
         * starting and cause the route to fail being started. By deferring this
         * startup to be lazy then the startup failure can be handled during
         * routing messages via Camel's routing error handlers. Beware that when
         * the first message is processed then creating and starting the
         * producer may take a little time and prolong the total processing time
         * of the processing.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: false
         * Group: producer (advanced)
         * 
         * @param lazyStartProducer the value to set
         * @return the dsl builder
         */
        default AdvancedIrcEndpointProducerBuilder lazyStartProducer(
                boolean lazyStartProducer) {
            doSetProperty("lazyStartProducer", lazyStartProducer);
            return this;
        }
        /**
         * Whether the producer should be started lazy (on the first message).
         * By starting lazy you can use this to allow CamelContext and routes to
         * startup in situations where a producer may otherwise fail during
         * starting and cause the route to fail being started. By deferring this
         * startup to be lazy then the startup failure can be handled during
         * routing messages via Camel's routing error handlers. Beware that when
         * the first message is processed then creating and starting the
         * producer may take a little time and prolong the total processing time
         * of the processing.
         * 
         * The option will be converted to a &lt;code&gt;boolean&lt;/code&gt;
         * type.
         * 
         * Default: false
         * Group: producer (advanced)
         * 
         * @param lazyStartProducer the value to set
         * @return the dsl builder
         */
        default AdvancedIrcEndpointProducerBuilder lazyStartProducer(
                String lazyStartProducer) {
            doSetProperty("lazyStartProducer", lazyStartProducer);
            return this;
        }
        /**
         * Whether or not the server supports color codes.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: true
         * Group: advanced
         * 
         * @param colors the value to set
         * @return the dsl builder
         */
        default AdvancedIrcEndpointProducerBuilder colors(boolean colors) {
            doSetProperty("colors", colors);
            return this;
        }
        /**
         * Whether or not the server supports color codes.
         * 
         * The option will be converted to a &lt;code&gt;boolean&lt;/code&gt;
         * type.
         * 
         * Default: true
         * Group: advanced
         * 
         * @param colors the value to set
         * @return the dsl builder
         */
        default AdvancedIrcEndpointProducerBuilder colors(String colors) {
            doSetProperty("colors", colors);
            return this;
        }
    }

    /**
     * Builder for endpoint for the IRC component.
     */
    public interface IrcEndpointBuilder
            extends
                IrcEndpointConsumerBuilder,
                IrcEndpointProducerBuilder {
        default AdvancedIrcEndpointBuilder advanced() {
            return (AdvancedIrcEndpointBuilder) this;
        }
        /**
         * Whether to auto re-join when being kicked.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: true
         * Group: common
         * 
         * @param autoRejoin the value to set
         * @return the dsl builder
         */
        default IrcEndpointBuilder autoRejoin(boolean autoRejoin) {
            doSetProperty("autoRejoin", autoRejoin);
            return this;
        }
        /**
         * Whether to auto re-join when being kicked.
         * 
         * The option will be converted to a &lt;code&gt;boolean&lt;/code&gt;
         * type.
         * 
         * Default: true
         * Group: common
         * 
         * @param autoRejoin the value to set
         * @return the dsl builder
         */
        default IrcEndpointBuilder autoRejoin(String autoRejoin) {
            doSetProperty("autoRejoin", autoRejoin);
            return this;
        }
        /**
         * Comma separated list of IRC channels.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param channels the value to set
         * @return the dsl builder
         */
        default IrcEndpointBuilder channels(String channels) {
            doSetProperty("channels", channels);
            return this;
        }
        /**
         * Delay in milliseconds before sending commands after the connection is
         * established.
         * 
         * The option is a: &lt;code&gt;long&lt;/code&gt; type.
         * 
         * Default: 5000
         * Group: common
         * 
         * @param commandTimeout the value to set
         * @return the dsl builder
         */
        default IrcEndpointBuilder commandTimeout(long commandTimeout) {
            doSetProperty("commandTimeout", commandTimeout);
            return this;
        }
        /**
         * Delay in milliseconds before sending commands after the connection is
         * established.
         * 
         * The option will be converted to a &lt;code&gt;long&lt;/code&gt; type.
         * 
         * Default: 5000
         * Group: common
         * 
         * @param commandTimeout the value to set
         * @return the dsl builder
         */
        default IrcEndpointBuilder commandTimeout(String commandTimeout) {
            doSetProperty("commandTimeout", commandTimeout);
            return this;
        }
        /**
         * Comma separated list of keys for channels.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param keys the value to set
         * @return the dsl builder
         */
        default IrcEndpointBuilder keys(String keys) {
            doSetProperty("keys", keys);
            return this;
        }
        /**
         * Sends NAMES command to channel after joining it. onReply has to be
         * true in order to process the result which will have the header value
         * irc.num = '353'.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: false
         * Group: common
         * 
         * @param namesOnJoin the value to set
         * @return the dsl builder
         */
        default IrcEndpointBuilder namesOnJoin(boolean namesOnJoin) {
            doSetProperty("namesOnJoin", namesOnJoin);
            return this;
        }
        /**
         * Sends NAMES command to channel after joining it. onReply has to be
         * true in order to process the result which will have the header value
         * irc.num = '353'.
         * 
         * The option will be converted to a &lt;code&gt;boolean&lt;/code&gt;
         * type.
         * 
         * Default: false
         * Group: common
         * 
         * @param namesOnJoin the value to set
         * @return the dsl builder
         */
        default IrcEndpointBuilder namesOnJoin(String namesOnJoin) {
            doSetProperty("namesOnJoin", namesOnJoin);
            return this;
        }
        /**
         * The nickname used in chat.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param nickname the value to set
         * @return the dsl builder
         */
        default IrcEndpointBuilder nickname(String nickname) {
            doSetProperty("nickname", nickname);
            return this;
        }
        /**
         * Use persistent messages.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: true
         * Group: common
         * 
         * @param persistent the value to set
         * @return the dsl builder
         */
        @Deprecated
        default IrcEndpointBuilder persistent(boolean persistent) {
            doSetProperty("persistent", persistent);
            return this;
        }
        /**
         * Use persistent messages.
         * 
         * The option will be converted to a &lt;code&gt;boolean&lt;/code&gt;
         * type.
         * 
         * Default: true
         * Group: common
         * 
         * @param persistent the value to set
         * @return the dsl builder
         */
        @Deprecated
        default IrcEndpointBuilder persistent(String persistent) {
            doSetProperty("persistent", persistent);
            return this;
        }
        /**
         * The IRC user's actual name.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param realname the value to set
         * @return the dsl builder
         */
        default IrcEndpointBuilder realname(String realname) {
            doSetProperty("realname", realname);
            return this;
        }
        /**
         * Handle user join events.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: true
         * Group: filter
         * 
         * @param onJoin the value to set
         * @return the dsl builder
         */
        default IrcEndpointBuilder onJoin(boolean onJoin) {
            doSetProperty("onJoin", onJoin);
            return this;
        }
        /**
         * Handle user join events.
         * 
         * The option will be converted to a &lt;code&gt;boolean&lt;/code&gt;
         * type.
         * 
         * Default: true
         * Group: filter
         * 
         * @param onJoin the value to set
         * @return the dsl builder
         */
        default IrcEndpointBuilder onJoin(String onJoin) {
            doSetProperty("onJoin", onJoin);
            return this;
        }
        /**
         * Handle kick events.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: true
         * Group: filter
         * 
         * @param onKick the value to set
         * @return the dsl builder
         */
        default IrcEndpointBuilder onKick(boolean onKick) {
            doSetProperty("onKick", onKick);
            return this;
        }
        /**
         * Handle kick events.
         * 
         * The option will be converted to a &lt;code&gt;boolean&lt;/code&gt;
         * type.
         * 
         * Default: true
         * Group: filter
         * 
         * @param onKick the value to set
         * @return the dsl builder
         */
        default IrcEndpointBuilder onKick(String onKick) {
            doSetProperty("onKick", onKick);
            return this;
        }
        /**
         * Handle mode change events.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: true
         * Group: filter
         * 
         * @param onMode the value to set
         * @return the dsl builder
         */
        default IrcEndpointBuilder onMode(boolean onMode) {
            doSetProperty("onMode", onMode);
            return this;
        }
        /**
         * Handle mode change events.
         * 
         * The option will be converted to a &lt;code&gt;boolean&lt;/code&gt;
         * type.
         * 
         * Default: true
         * Group: filter
         * 
         * @param onMode the value to set
         * @return the dsl builder
         */
        default IrcEndpointBuilder onMode(String onMode) {
            doSetProperty("onMode", onMode);
            return this;
        }
        /**
         * Handle nickname change events.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: true
         * Group: filter
         * 
         * @param onNick the value to set
         * @return the dsl builder
         */
        default IrcEndpointBuilder onNick(boolean onNick) {
            doSetProperty("onNick", onNick);
            return this;
        }
        /**
         * Handle nickname change events.
         * 
         * The option will be converted to a &lt;code&gt;boolean&lt;/code&gt;
         * type.
         * 
         * Default: true
         * Group: filter
         * 
         * @param onNick the value to set
         * @return the dsl builder
         */
        default IrcEndpointBuilder onNick(String onNick) {
            doSetProperty("onNick", onNick);
            return this;
        }
        /**
         * Handle user part events.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: true
         * Group: filter
         * 
         * @param onPart the value to set
         * @return the dsl builder
         */
        default IrcEndpointBuilder onPart(boolean onPart) {
            doSetProperty("onPart", onPart);
            return this;
        }
        /**
         * Handle user part events.
         * 
         * The option will be converted to a &lt;code&gt;boolean&lt;/code&gt;
         * type.
         * 
         * Default: true
         * Group: filter
         * 
         * @param onPart the value to set
         * @return the dsl builder
         */
        default IrcEndpointBuilder onPart(String onPart) {
            doSetProperty("onPart", onPart);
            return this;
        }
        /**
         * Handle private message events.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: true
         * Group: filter
         * 
         * @param onPrivmsg the value to set
         * @return the dsl builder
         */
        default IrcEndpointBuilder onPrivmsg(boolean onPrivmsg) {
            doSetProperty("onPrivmsg", onPrivmsg);
            return this;
        }
        /**
         * Handle private message events.
         * 
         * The option will be converted to a &lt;code&gt;boolean&lt;/code&gt;
         * type.
         * 
         * Default: true
         * Group: filter
         * 
         * @param onPrivmsg the value to set
         * @return the dsl builder
         */
        default IrcEndpointBuilder onPrivmsg(String onPrivmsg) {
            doSetProperty("onPrivmsg", onPrivmsg);
            return this;
        }
        /**
         * Handle user quit events.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: true
         * Group: filter
         * 
         * @param onQuit the value to set
         * @return the dsl builder
         */
        default IrcEndpointBuilder onQuit(boolean onQuit) {
            doSetProperty("onQuit", onQuit);
            return this;
        }
        /**
         * Handle user quit events.
         * 
         * The option will be converted to a &lt;code&gt;boolean&lt;/code&gt;
         * type.
         * 
         * Default: true
         * Group: filter
         * 
         * @param onQuit the value to set
         * @return the dsl builder
         */
        default IrcEndpointBuilder onQuit(String onQuit) {
            doSetProperty("onQuit", onQuit);
            return this;
        }
        /**
         * Whether or not to handle general responses to commands or
         * informational messages.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: false
         * Group: filter
         * 
         * @param onReply the value to set
         * @return the dsl builder
         */
        default IrcEndpointBuilder onReply(boolean onReply) {
            doSetProperty("onReply", onReply);
            return this;
        }
        /**
         * Whether or not to handle general responses to commands or
         * informational messages.
         * 
         * The option will be converted to a &lt;code&gt;boolean&lt;/code&gt;
         * type.
         * 
         * Default: false
         * Group: filter
         * 
         * @param onReply the value to set
         * @return the dsl builder
         */
        default IrcEndpointBuilder onReply(String onReply) {
            doSetProperty("onReply", onReply);
            return this;
        }
        /**
         * Handle topic change events.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: true
         * Group: filter
         * 
         * @param onTopic the value to set
         * @return the dsl builder
         */
        default IrcEndpointBuilder onTopic(boolean onTopic) {
            doSetProperty("onTopic", onTopic);
            return this;
        }
        /**
         * Handle topic change events.
         * 
         * The option will be converted to a &lt;code&gt;boolean&lt;/code&gt;
         * type.
         * 
         * Default: true
         * Group: filter
         * 
         * @param onTopic the value to set
         * @return the dsl builder
         */
        default IrcEndpointBuilder onTopic(String onTopic) {
            doSetProperty("onTopic", onTopic);
            return this;
        }
        /**
         * Your IRC server nickname password.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: security
         * 
         * @param nickPassword the value to set
         * @return the dsl builder
         */
        default IrcEndpointBuilder nickPassword(String nickPassword) {
            doSetProperty("nickPassword", nickPassword);
            return this;
        }
        /**
         * The IRC server password.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: security
         * 
         * @param password the value to set
         * @return the dsl builder
         */
        default IrcEndpointBuilder password(String password) {
            doSetProperty("password", password);
            return this;
        }
        /**
         * Used for configuring security using SSL. Reference to a
         * org.apache.camel.support.jsse.SSLContextParameters in the Registry.
         * This reference overrides any configured SSLContextParameters at the
         * component level. Note that this setting overrides the trustManager
         * option.
         * 
         * The option is a:
         * &lt;code&gt;org.apache.camel.support.jsse.SSLContextParameters&lt;/code&gt; type.
         * 
         * Group: security
         * 
         * @param sslContextParameters the value to set
         * @return the dsl builder
         */
        default IrcEndpointBuilder sslContextParameters(
                org.apache.camel.support.jsse.SSLContextParameters sslContextParameters) {
            doSetProperty("sslContextParameters", sslContextParameters);
            return this;
        }
        /**
         * Used for configuring security using SSL. Reference to a
         * org.apache.camel.support.jsse.SSLContextParameters in the Registry.
         * This reference overrides any configured SSLContextParameters at the
         * component level. Note that this setting overrides the trustManager
         * option.
         * 
         * The option will be converted to a
         * &lt;code&gt;org.apache.camel.support.jsse.SSLContextParameters&lt;/code&gt; type.
         * 
         * Group: security
         * 
         * @param sslContextParameters the value to set
         * @return the dsl builder
         */
        default IrcEndpointBuilder sslContextParameters(
                String sslContextParameters) {
            doSetProperty("sslContextParameters", sslContextParameters);
            return this;
        }
        /**
         * The trust manager used to verify the SSL server's certificate.
         * 
         * The option is a:
         * &lt;code&gt;org.schwering.irc.lib.ssl.SSLTrustManager&lt;/code&gt;
         * type.
         * 
         * Group: security
         * 
         * @param trustManager the value to set
         * @return the dsl builder
         */
        default IrcEndpointBuilder trustManager(
                org.schwering.irc.lib.ssl.SSLTrustManager trustManager) {
            doSetProperty("trustManager", trustManager);
            return this;
        }
        /**
         * The trust manager used to verify the SSL server's certificate.
         * 
         * The option will be converted to a
         * &lt;code&gt;org.schwering.irc.lib.ssl.SSLTrustManager&lt;/code&gt;
         * type.
         * 
         * Group: security
         * 
         * @param trustManager the value to set
         * @return the dsl builder
         */
        default IrcEndpointBuilder trustManager(String trustManager) {
            doSetProperty("trustManager", trustManager);
            return this;
        }
        /**
         * The IRC server user name.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: security
         * 
         * @param username the value to set
         * @return the dsl builder
         */
        default IrcEndpointBuilder username(String username) {
            doSetProperty("username", username);
            return this;
        }
    }

    /**
     * Advanced builder for endpoint for the IRC component.
     */
    public interface AdvancedIrcEndpointBuilder
            extends
                AdvancedIrcEndpointConsumerBuilder,
                AdvancedIrcEndpointProducerBuilder {
        default IrcEndpointBuilder basic() {
            return (IrcEndpointBuilder) this;
        }
        /**
         * Whether or not the server supports color codes.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: true
         * Group: advanced
         * 
         * @param colors the value to set
         * @return the dsl builder
         */
        default AdvancedIrcEndpointBuilder colors(boolean colors) {
            doSetProperty("colors", colors);
            return this;
        }
        /**
         * Whether or not the server supports color codes.
         * 
         * The option will be converted to a &lt;code&gt;boolean&lt;/code&gt;
         * type.
         * 
         * Default: true
         * Group: advanced
         * 
         * @param colors the value to set
         * @return the dsl builder
         */
        default AdvancedIrcEndpointBuilder colors(String colors) {
            doSetProperty("colors", colors);
            return this;
        }
    }

    public interface IrcBuilders {
        /**
         * IRC (camel-irc)
         * Send and receive messages to/from and IRC chat.
         * 
         * Category: chat
         * Since: 1.1
         * Maven coordinates: org.apache.camel:camel-irc
         * 
         * @return the dsl builder for the headers' name.
         */
        default IrcHeaderNameBuilder irc() {
            return IrcHeaderNameBuilder.INSTANCE;
        }
        /**
         * IRC (camel-irc)
         * Send and receive messages to/from and IRC chat.
         * 
         * Category: chat
         * Since: 1.1
         * Maven coordinates: org.apache.camel:camel-irc
         * 
         * Syntax: <code>irc:hostname:port</code>
         * 
         * Path parameter: hostname (required)
         * Hostname for the IRC chat server
         * 
         * Path parameter: port
         * Port number for the IRC chat server. If no port is configured then a
         * default port of either 6667, 6668 or 6669 is used.
         * 
         * @param path hostname:port
         * @return the dsl builder
         */
        default IrcEndpointBuilder irc(String path) {
            return IrcEndpointBuilderFactory.endpointBuilder("irc", path);
        }
        /**
         * IRC (camel-irc)
         * Send and receive messages to/from and IRC chat.
         * 
         * Category: chat
         * Since: 1.1
         * Maven coordinates: org.apache.camel:camel-irc
         * 
         * Syntax: <code>irc:hostname:port</code>
         * 
         * Path parameter: hostname (required)
         * Hostname for the IRC chat server
         * 
         * Path parameter: port
         * Port number for the IRC chat server. If no port is configured then a
         * default port of either 6667, 6668 or 6669 is used.
         * 
         * @param componentName to use a custom component name for the endpoint
         * instead of the default name
         * @param path hostname:port
         * @return the dsl builder
         */
        default IrcEndpointBuilder irc(String componentName, String path) {
            return IrcEndpointBuilderFactory.endpointBuilder(componentName, path);
        }
    }

    /**
     * The builder of headers' name for the IRC component.
     */
    public static class IrcHeaderNameBuilder {
        /**
         * The internal instance of the builder used to access to all the
         * methods representing the name of headers.
         */
        private static final IrcHeaderNameBuilder INSTANCE = new IrcHeaderNameBuilder();

        /**
         * The type of message.
         * 
         * The option is a: {@code String} type.
         * 
         * Group: common
         * 
         * @return the name of the header {@code irc.messageType}.
         */
        public String ircMessagetype() {
            return "irc.messageType";
        }

        /**
         * The target.
         * 
         * The option is a: {@code String} type.
         * 
         * Group: common
         * 
         * @return the name of the header {@code irc.target}.
         */
        public String ircTarget() {
            return "irc.target";
        }

        /**
         * The nickname or channel the message should be sent to.
         * 
         * The option is a: {@code String} type.
         * 
         * Group: common
         * 
         * @return the name of the header {@code irc.sendTo}.
         */
        public String ircSendto() {
            return "irc.sendTo";
        }

        /**
         * The nickname of the user who is kicked from a channel (passive).
         * 
         * The option is a: {@code String} type.
         * 
         * Group: common
         * 
         * @return the name of the header {@code irc.user.kicked}.
         */
        public String ircUserKicked() {
            return "irc.user.kicked";
        }

        /**
         * The host of the person who sent the line.
         * 
         * The option is a: {@code String} type.
         * 
         * Group: common
         * 
         * @return the name of the header {@code irc.user.host}.
         */
        public String ircUserHost() {
            return "irc.user.host";
        }

        /**
         * The nickname of the person who sent the line or the server name of
         * the server which sent the line.
         * 
         * The option is a: {@code String} type.
         * 
         * Group: common
         * 
         * @return the name of the header {@code irc.user.nick}.
         */
        public String ircUserNick() {
            return "irc.user.nick";
        }

        /**
         * The server name of the server which sent the line or the nickname of
         * the person who sent the line.
         * 
         * The option is a: {@code String} type.
         * 
         * Group: common
         * 
         * @return the name of the header {@code irc.user.servername}.
         */
        public String ircUserServername() {
            return "irc.user.servername";
        }

        /**
         * The username of the person who sent the line.
         * 
         * The option is a: {@code String} type.
         * 
         * Group: common
         * 
         * @return the name of the header {@code irc.user.username}.
         */
        public String ircUserUsername() {
            return "irc.user.username";
        }

        /**
         * The numeric reply.
         * 
         * The option is a: {@code int} type.
         * 
         * Group: common
         * 
         * @return the name of the header {@code irc.num}.
         */
        public String ircNum() {
            return "irc.num";
        }

        /**
         * The first part of the message.
         * 
         * The option is a: {@code String} type.
         * 
         * Group: common
         * 
         * @return the name of the header {@code irc.value}.
         */
        public String ircValue() {
            return "irc.value";
        }
    }
    static IrcEndpointBuilder endpointBuilder(String componentName, String path) {
        class IrcEndpointBuilderImpl extends AbstractEndpointBuilder implements IrcEndpointBuilder, AdvancedIrcEndpointBuilder {
            public IrcEndpointBuilderImpl(String path) {
                super(componentName, path);
            }
        }
        return new IrcEndpointBuilderImpl(path);
    }
}