/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.apache.camel.builder.endpoint.dsl;

import java.util.*;
import java.util.concurrent.*;
import java.util.function.*;
import java.util.stream.*;
import javax.annotation.processing.Generated;
import org.apache.camel.builder.EndpointConsumerBuilder;
import org.apache.camel.builder.EndpointProducerBuilder;
import org.apache.camel.builder.endpoint.AbstractEndpointBuilder;

/**
 * The Dynamic Router component routes exchanges to recipients, and the
 * recipients (and their rules) may change at runtime.
 * 
 * Generated by camel build tools - do NOT edit this file!
 */
@Generated("org.apache.camel.maven.packaging.EndpointDslMojo")
public interface DynamicRouterEndpointBuilderFactory {


    /**
     * Builder for endpoint for the Dynamic Router component.
     */
    public interface DynamicRouterEndpointBuilder
            extends
                EndpointProducerBuilder {
        default AdvancedDynamicRouterEndpointBuilder advanced() {
            return (AdvancedDynamicRouterEndpointBuilder) this;
        }
        /**
         * Refers to an AggregationStrategy to be used to assemble the replies
         * from the multicasts, into a single outgoing message from the
         * Multicast. By default, Camel will use the last reply as the outgoing
         * message. You can also use a POJO as the AggregationStrategy.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param aggregationStrategy the value to set
         * @return the dsl builder
         */
        default DynamicRouterEndpointBuilder aggregationStrategy(
                String aggregationStrategy) {
            doSetProperty("aggregationStrategy", aggregationStrategy);
            return this;
        }
        /**
         * Refers to a custom Thread Pool to be used for parallel processing.
         * Notice that, if you set this option, then parallel processing is
         * automatically implied, and you do not have to enable that option in
         * addition to this one.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param executorService the value to set
         * @return the dsl builder
         */
        default DynamicRouterEndpointBuilder executorService(
                String executorService) {
            doSetProperty("executorService", executorService);
            return this;
        }
        /**
         * Ignore the invalid endpoint exception when attempting to create a
         * producer with an invalid endpoint.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: false
         * Group: common
         * 
         * @param ignoreInvalidEndpoints the value to set
         * @return the dsl builder
         */
        default DynamicRouterEndpointBuilder ignoreInvalidEndpoints(
                boolean ignoreInvalidEndpoints) {
            doSetProperty("ignoreInvalidEndpoints", ignoreInvalidEndpoints);
            return this;
        }
        /**
         * Ignore the invalid endpoint exception when attempting to create a
         * producer with an invalid endpoint.
         * 
         * The option will be converted to a &lt;code&gt;boolean&lt;/code&gt;
         * type.
         * 
         * Default: false
         * Group: common
         * 
         * @param ignoreInvalidEndpoints the value to set
         * @return the dsl builder
         */
        default DynamicRouterEndpointBuilder ignoreInvalidEndpoints(
                String ignoreInvalidEndpoints) {
            doSetProperty("ignoreInvalidEndpoints", ignoreInvalidEndpoints);
            return this;
        }
        /**
         * Uses the Processor when preparing the org.apache.camel.Exchange to be
         * sent. This can be used to deep-clone messages that should be sent, or
         * to provide any custom logic that is needed before the exchange is
         * sent.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param onPrepare the value to set
         * @return the dsl builder
         */
        default DynamicRouterEndpointBuilder onPrepare(String onPrepare) {
            doSetProperty("onPrepare", onPrepare);
            return this;
        }
        /**
         * If enabled then the aggregate method on AggregationStrategy can be
         * called concurrently. Notice that this would require the
         * implementation of AggregationStrategy to be implemented as
         * thread-safe. By default, this is false, meaning that Camel
         * synchronizes the call to the aggregate method. Though, in some
         * use-cases, this can be used to archive higher performance when the
         * AggregationStrategy is implemented as thread-safe.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: false
         * Group: common
         * 
         * @param parallelAggregate the value to set
         * @return the dsl builder
         */
        default DynamicRouterEndpointBuilder parallelAggregate(
                boolean parallelAggregate) {
            doSetProperty("parallelAggregate", parallelAggregate);
            return this;
        }
        /**
         * If enabled then the aggregate method on AggregationStrategy can be
         * called concurrently. Notice that this would require the
         * implementation of AggregationStrategy to be implemented as
         * thread-safe. By default, this is false, meaning that Camel
         * synchronizes the call to the aggregate method. Though, in some
         * use-cases, this can be used to archive higher performance when the
         * AggregationStrategy is implemented as thread-safe.
         * 
         * The option will be converted to a &lt;code&gt;boolean&lt;/code&gt;
         * type.
         * 
         * Default: false
         * Group: common
         * 
         * @param parallelAggregate the value to set
         * @return the dsl builder
         */
        default DynamicRouterEndpointBuilder parallelAggregate(
                String parallelAggregate) {
            doSetProperty("parallelAggregate", parallelAggregate);
            return this;
        }
        /**
         * If enabled, then sending via multicast occurs concurrently. Note that
         * the caller thread will still wait until all messages have been fully
         * processed before it continues. It is only the sending and processing
         * of the replies from the multicast recipients that happens
         * concurrently. When parallel processing is enabled, then the Camel
         * routing engine will continue processing using the last used thread
         * from the parallel thread pool. However, if you want to use the
         * original thread that called the multicast, then make sure to enable
         * the synchronous option as well.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: false
         * Group: common
         * 
         * @param parallelProcessing the value to set
         * @return the dsl builder
         */
        default DynamicRouterEndpointBuilder parallelProcessing(
                boolean parallelProcessing) {
            doSetProperty("parallelProcessing", parallelProcessing);
            return this;
        }
        /**
         * If enabled, then sending via multicast occurs concurrently. Note that
         * the caller thread will still wait until all messages have been fully
         * processed before it continues. It is only the sending and processing
         * of the replies from the multicast recipients that happens
         * concurrently. When parallel processing is enabled, then the Camel
         * routing engine will continue processing using the last used thread
         * from the parallel thread pool. However, if you want to use the
         * original thread that called the multicast, then make sure to enable
         * the synchronous option as well.
         * 
         * The option will be converted to a &lt;code&gt;boolean&lt;/code&gt;
         * type.
         * 
         * Default: false
         * Group: common
         * 
         * @param parallelProcessing the value to set
         * @return the dsl builder
         */
        default DynamicRouterEndpointBuilder parallelProcessing(
                String parallelProcessing) {
            doSetProperty("parallelProcessing", parallelProcessing);
            return this;
        }
        /**
         * Recipient mode: firstMatch or allMatch.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Default: firstMatch
         * Group: common
         * 
         * @param recipientMode the value to set
         * @return the dsl builder
         */
        default DynamicRouterEndpointBuilder recipientMode(String recipientMode) {
            doSetProperty("recipientMode", recipientMode);
            return this;
        }
        /**
         * Shares the org.apache.camel.spi.UnitOfWork with the parent and each
         * of the sub messages. Multicast will, by default, not share a unit of
         * work between the parent exchange and each multicasted exchange. This
         * means each sub exchange has its own individual unit of work.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: false
         * Group: common
         * 
         * @param shareUnitOfWork the value to set
         * @return the dsl builder
         */
        default DynamicRouterEndpointBuilder shareUnitOfWork(
                boolean shareUnitOfWork) {
            doSetProperty("shareUnitOfWork", shareUnitOfWork);
            return this;
        }
        /**
         * Shares the org.apache.camel.spi.UnitOfWork with the parent and each
         * of the sub messages. Multicast will, by default, not share a unit of
         * work between the parent exchange and each multicasted exchange. This
         * means each sub exchange has its own individual unit of work.
         * 
         * The option will be converted to a &lt;code&gt;boolean&lt;/code&gt;
         * type.
         * 
         * Default: false
         * Group: common
         * 
         * @param shareUnitOfWork the value to set
         * @return the dsl builder
         */
        default DynamicRouterEndpointBuilder shareUnitOfWork(
                String shareUnitOfWork) {
            doSetProperty("shareUnitOfWork", shareUnitOfWork);
            return this;
        }
        /**
         * Will stop further processing if an exception or failure occurred
         * during processing of an org.apache.camel.Exchange and the caused
         * exception will be thrown. Will also stop if processing the exchange
         * failed (has a fault message), or an exception was thrown and handled
         * by the error handler (such as using onException). In all situations,
         * the multicast will stop further processing. This is the same behavior
         * as in the pipeline that is used by the routing engine. The default
         * behavior is to not stop, but to continue processing until the end.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: false
         * Group: common
         * 
         * @param stopOnException the value to set
         * @return the dsl builder
         */
        default DynamicRouterEndpointBuilder stopOnException(
                boolean stopOnException) {
            doSetProperty("stopOnException", stopOnException);
            return this;
        }
        /**
         * Will stop further processing if an exception or failure occurred
         * during processing of an org.apache.camel.Exchange and the caused
         * exception will be thrown. Will also stop if processing the exchange
         * failed (has a fault message), or an exception was thrown and handled
         * by the error handler (such as using onException). In all situations,
         * the multicast will stop further processing. This is the same behavior
         * as in the pipeline that is used by the routing engine. The default
         * behavior is to not stop, but to continue processing until the end.
         * 
         * The option will be converted to a &lt;code&gt;boolean&lt;/code&gt;
         * type.
         * 
         * Default: false
         * Group: common
         * 
         * @param stopOnException the value to set
         * @return the dsl builder
         */
        default DynamicRouterEndpointBuilder stopOnException(
                String stopOnException) {
            doSetProperty("stopOnException", stopOnException);
            return this;
        }
        /**
         * If enabled, then Camel will process replies out-of-order (e.g., in
         * the order they come back). If disabled, Camel will process replies in
         * the same order as defined by the multicast.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: false
         * Group: common
         * 
         * @param streaming the value to set
         * @return the dsl builder
         */
        default DynamicRouterEndpointBuilder streaming(boolean streaming) {
            doSetProperty("streaming", streaming);
            return this;
        }
        /**
         * If enabled, then Camel will process replies out-of-order (e.g., in
         * the order they come back). If disabled, Camel will process replies in
         * the same order as defined by the multicast.
         * 
         * The option will be converted to a &lt;code&gt;boolean&lt;/code&gt;
         * type.
         * 
         * Default: false
         * Group: common
         * 
         * @param streaming the value to set
         * @return the dsl builder
         */
        default DynamicRouterEndpointBuilder streaming(String streaming) {
            doSetProperty("streaming", streaming);
            return this;
        }
        /**
         * Sets whether synchronous processing should be strictly used. When
         * enabled then the same thread is used to continue routing after the
         * multicast is complete, even if parallel processing is enabled.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: false
         * Group: common
         * 
         * @param synchronous the value to set
         * @return the dsl builder
         */
        default DynamicRouterEndpointBuilder synchronous(boolean synchronous) {
            doSetProperty("synchronous", synchronous);
            return this;
        }
        /**
         * Sets whether synchronous processing should be strictly used. When
         * enabled then the same thread is used to continue routing after the
         * multicast is complete, even if parallel processing is enabled.
         * 
         * The option will be converted to a &lt;code&gt;boolean&lt;/code&gt;
         * type.
         * 
         * Default: false
         * Group: common
         * 
         * @param synchronous the value to set
         * @return the dsl builder
         */
        default DynamicRouterEndpointBuilder synchronous(String synchronous) {
            doSetProperty("synchronous", synchronous);
            return this;
        }
        /**
         * Sets a total timeout specified in milliseconds, when using parallel
         * processing. If the Multicast has not been able to send and process
         * all replies within the given timeframe, then the timeout triggers and
         * the Multicast breaks out and continues. Notice that, if you provide a
         * TimeoutAwareAggregationStrategy, then the timeout method is invoked
         * before breaking out. If the timeout is reached with running tasks
         * still remaining, certain tasks (for which it is difficult for Camel
         * to shut down in a graceful manner) may continue to run. So use this
         * option with a bit of care.
         * 
         * The option is a: &lt;code&gt;long&lt;/code&gt; type.
         * 
         * Default: -1
         * Group: common
         * 
         * @param timeout the value to set
         * @return the dsl builder
         */
        default DynamicRouterEndpointBuilder timeout(long timeout) {
            doSetProperty("timeout", timeout);
            return this;
        }
        /**
         * Sets a total timeout specified in milliseconds, when using parallel
         * processing. If the Multicast has not been able to send and process
         * all replies within the given timeframe, then the timeout triggers and
         * the Multicast breaks out and continues. Notice that, if you provide a
         * TimeoutAwareAggregationStrategy, then the timeout method is invoked
         * before breaking out. If the timeout is reached with running tasks
         * still remaining, certain tasks (for which it is difficult for Camel
         * to shut down in a graceful manner) may continue to run. So use this
         * option with a bit of care.
         * 
         * The option will be converted to a &lt;code&gt;long&lt;/code&gt; type.
         * 
         * Default: -1
         * Group: common
         * 
         * @param timeout the value to set
         * @return the dsl builder
         */
        default DynamicRouterEndpointBuilder timeout(String timeout) {
            doSetProperty("timeout", timeout);
            return this;
        }
        /**
         * Flag to log a warning if no predicates match for an exchange.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: false
         * Group: common
         * 
         * @param warnDroppedMessage the value to set
         * @return the dsl builder
         */
        default DynamicRouterEndpointBuilder warnDroppedMessage(
                boolean warnDroppedMessage) {
            doSetProperty("warnDroppedMessage", warnDroppedMessage);
            return this;
        }
        /**
         * Flag to log a warning if no predicates match for an exchange.
         * 
         * The option will be converted to a &lt;code&gt;boolean&lt;/code&gt;
         * type.
         * 
         * Default: false
         * Group: common
         * 
         * @param warnDroppedMessage the value to set
         * @return the dsl builder
         */
        default DynamicRouterEndpointBuilder warnDroppedMessage(
                String warnDroppedMessage) {
            doSetProperty("warnDroppedMessage", warnDroppedMessage);
            return this;
        }
        /**
         * The destination URI for exchanges that match.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: control
         * 
         * @param destinationUri the value to set
         * @return the dsl builder
         */
        default DynamicRouterEndpointBuilder destinationUri(
                String destinationUri) {
            doSetProperty("destinationUri", destinationUri);
            return this;
        }
        /**
         * The subscription predicate language.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Default: simple
         * Group: control
         * 
         * @param expressionLanguage the value to set
         * @return the dsl builder
         */
        default DynamicRouterEndpointBuilder expressionLanguage(
                String expressionLanguage) {
            doSetProperty("expressionLanguage", expressionLanguage);
            return this;
        }
        /**
         * The subscription predicate.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: control
         * 
         * @param predicate the value to set
         * @return the dsl builder
         */
        default DynamicRouterEndpointBuilder predicate(String predicate) {
            doSetProperty("predicate", predicate);
            return this;
        }
        /**
         * A Predicate instance in the registry.
         * 
         * The option is a: &lt;code&gt;org.apache.camel.Predicate&lt;/code&gt;
         * type.
         * 
         * Group: control
         * 
         * @param predicateBean the value to set
         * @return the dsl builder
         */
        default DynamicRouterEndpointBuilder predicateBean(
                org.apache.camel.Predicate predicateBean) {
            doSetProperty("predicateBean", predicateBean);
            return this;
        }
        /**
         * A Predicate instance in the registry.
         * 
         * The option will be converted to a
         * &lt;code&gt;org.apache.camel.Predicate&lt;/code&gt; type.
         * 
         * Group: control
         * 
         * @param predicateBean the value to set
         * @return the dsl builder
         */
        default DynamicRouterEndpointBuilder predicateBean(String predicateBean) {
            doSetProperty("predicateBean", predicateBean);
            return this;
        }
        /**
         * The subscription priority.
         * 
         * The option is a: &lt;code&gt;java.lang.Integer&lt;/code&gt; type.
         * 
         * Group: control
         * 
         * @param priority the value to set
         * @return the dsl builder
         */
        default DynamicRouterEndpointBuilder priority(Integer priority) {
            doSetProperty("priority", priority);
            return this;
        }
        /**
         * The subscription priority.
         * 
         * The option will be converted to a
         * &lt;code&gt;java.lang.Integer&lt;/code&gt; type.
         * 
         * Group: control
         * 
         * @param priority the value to set
         * @return the dsl builder
         */
        default DynamicRouterEndpointBuilder priority(String priority) {
            doSetProperty("priority", priority);
            return this;
        }
        /**
         * The subscription ID; if unspecified, one will be assigned and
         * returned.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: control
         * 
         * @param subscriptionId the value to set
         * @return the dsl builder
         */
        default DynamicRouterEndpointBuilder subscriptionId(
                String subscriptionId) {
            doSetProperty("subscriptionId", subscriptionId);
            return this;
        }
    }

    /**
     * Advanced builder for endpoint for the Dynamic Router component.
     */
    public interface AdvancedDynamicRouterEndpointBuilder
            extends
                EndpointProducerBuilder {
        default DynamicRouterEndpointBuilder basic() {
            return (DynamicRouterEndpointBuilder) this;
        }
        /**
         * Whether the producer should be started lazy (on the first message).
         * By starting lazy you can use this to allow CamelContext and routes to
         * startup in situations where a producer may otherwise fail during
         * starting and cause the route to fail being started. By deferring this
         * startup to be lazy then the startup failure can be handled during
         * routing messages via Camel's routing error handlers. Beware that when
         * the first message is processed then creating and starting the
         * producer may take a little time and prolong the total processing time
         * of the processing.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: false
         * Group: producer (advanced)
         * 
         * @param lazyStartProducer the value to set
         * @return the dsl builder
         */
        default AdvancedDynamicRouterEndpointBuilder lazyStartProducer(
                boolean lazyStartProducer) {
            doSetProperty("lazyStartProducer", lazyStartProducer);
            return this;
        }
        /**
         * Whether the producer should be started lazy (on the first message).
         * By starting lazy you can use this to allow CamelContext and routes to
         * startup in situations where a producer may otherwise fail during
         * starting and cause the route to fail being started. By deferring this
         * startup to be lazy then the startup failure can be handled during
         * routing messages via Camel's routing error handlers. Beware that when
         * the first message is processed then creating and starting the
         * producer may take a little time and prolong the total processing time
         * of the processing.
         * 
         * The option will be converted to a &lt;code&gt;boolean&lt;/code&gt;
         * type.
         * 
         * Default: false
         * Group: producer (advanced)
         * 
         * @param lazyStartProducer the value to set
         * @return the dsl builder
         */
        default AdvancedDynamicRouterEndpointBuilder lazyStartProducer(
                String lazyStartProducer) {
            doSetProperty("lazyStartProducer", lazyStartProducer);
            return this;
        }
    }

    public interface DynamicRouterBuilders {
        /**
         * Dynamic Router (camel-dynamic-router)
         * The Dynamic Router component routes exchanges to recipients, and the
         * recipients (and their rules) may change at runtime.
         * 
         * Category: messaging,core
         * Since: 3.15
         * Maven coordinates: org.apache.camel:camel-dynamic-router
         * 
         * Syntax: <code>dynamic-router:channel</code>
         * 
         * Path parameter: channel (required)
         * Channel of the Dynamic Router
         * 
         * Path parameter: controlAction
         * Control channel action: subscribe or unsubscribe
         * There are 2 enums and the value can be one of: subscribe, unsubscribe
         * 
         * Path parameter: subscribeChannel
         * The channel to subscribe to
         * 
         * @param path channel
         * @return the dsl builder
         */
        default DynamicRouterEndpointBuilder dynamicRouter(String path) {
            return DynamicRouterEndpointBuilderFactory.endpointBuilder("dynamic-router", path);
        }
        /**
         * Dynamic Router (camel-dynamic-router)
         * The Dynamic Router component routes exchanges to recipients, and the
         * recipients (and their rules) may change at runtime.
         * 
         * Category: messaging,core
         * Since: 3.15
         * Maven coordinates: org.apache.camel:camel-dynamic-router
         * 
         * Syntax: <code>dynamic-router:channel</code>
         * 
         * Path parameter: channel (required)
         * Channel of the Dynamic Router
         * 
         * Path parameter: controlAction
         * Control channel action: subscribe or unsubscribe
         * There are 2 enums and the value can be one of: subscribe, unsubscribe
         * 
         * Path parameter: subscribeChannel
         * The channel to subscribe to
         * 
         * @param componentName to use a custom component name for the endpoint
         * instead of the default name
         * @param path channel
         * @return the dsl builder
         */
        default DynamicRouterEndpointBuilder dynamicRouter(
                String componentName,
                String path) {
            return DynamicRouterEndpointBuilderFactory.endpointBuilder(componentName, path);
        }
    }
    static DynamicRouterEndpointBuilder endpointBuilder(
            String componentName,
            String path) {
        class DynamicRouterEndpointBuilderImpl extends AbstractEndpointBuilder implements DynamicRouterEndpointBuilder, AdvancedDynamicRouterEndpointBuilder {
            public DynamicRouterEndpointBuilderImpl(String path) {
                super(componentName, path);
            }
        }
        return new DynamicRouterEndpointBuilderImpl(path);
    }
}