/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.apache.camel.builder.component.dsl;

import javax.annotation.processing.Generated;
import org.apache.camel.Component;
import org.apache.camel.builder.component.AbstractComponentBuilder;
import org.apache.camel.builder.component.ComponentBuilder;
import org.apache.camel.component.debezium.DebeziumOracleComponent;

/**
 * Capture changes from a Oracle database.
 * 
 * Generated by camel-package-maven-plugin - do not edit this file!
 */
@Generated("org.apache.camel.maven.packaging.ComponentDslMojo")
public interface DebeziumOracleComponentBuilderFactory {

    /**
     * Debezium Oracle Connector (camel-debezium-oracle)
     * Capture changes from a Oracle database.
     * 
     * Category: database
     * Since: 3.17
     * Maven coordinates: org.apache.camel:camel-debezium-oracle
     * 
     * @return the dsl builder
     */
    static DebeziumOracleComponentBuilder debeziumOracle() {
        return new DebeziumOracleComponentBuilderImpl();
    }

    /**
     * Builder for the Debezium Oracle Connector component.
     */
    interface DebeziumOracleComponentBuilder
            extends
                ComponentBuilder<DebeziumOracleComponent> {
        /**
         * Additional properties for debezium components in case they can't be
         * set directly on the camel configurations (e.g: setting Kafka Connect
         * properties needed by Debezium engine, for example setting
         * KafkaOffsetBackingStore), the properties have to be prefixed with
         * additionalProperties.. E.g:
         * additionalProperties.transactional.id=12345&amp;amp;additionalProperties.schema.registry.url=http://localhost:8811/avro.
         * 
         * The option is a: &lt;code&gt;java.util.Map&amp;lt;java.lang.String,
         * java.lang.Object&amp;gt;&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param additionalProperties the value to set
         * @return the dsl builder
         */
        default DebeziumOracleComponentBuilder additionalProperties(
                java.util.Map<java.lang.String, java.lang.Object> additionalProperties) {
            doSetProperty("additionalProperties", additionalProperties);
            return this;
        }
        /**
         * Allows for bridging the consumer to the Camel routing Error Handler,
         * which mean any exceptions (if possible) occurred while the Camel
         * consumer is trying to pickup incoming messages, or the likes, will
         * now be processed as a message and handled by the routing Error
         * Handler. Important: This is only possible if the 3rd party component
         * allows Camel to be alerted if an exception was thrown. Some
         * components handle this internally only, and therefore
         * bridgeErrorHandler is not possible. In other situations we may
         * improve the Camel component to hook into the 3rd party component and
         * make this possible for future releases. By default the consumer will
         * use the org.apache.camel.spi.ExceptionHandler to deal with
         * exceptions, that will be logged at WARN or ERROR level and ignored.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: false
         * Group: consumer
         * 
         * @param bridgeErrorHandler the value to set
         * @return the dsl builder
         */
        default DebeziumOracleComponentBuilder bridgeErrorHandler(
                boolean bridgeErrorHandler) {
            doSetProperty("bridgeErrorHandler", bridgeErrorHandler);
            return this;
        }
        /**
         * Allow pre-configured Configurations to be set.
         * 
         * The option is a:
         * &lt;code&gt;org.apache.camel.component.debezium.configuration.OracleConnectorEmbeddedDebeziumConfiguration&lt;/code&gt; type.
         * 
         * Group: consumer
         * 
         * @param configuration the value to set
         * @return the dsl builder
         */
        default DebeziumOracleComponentBuilder configuration(
                org.apache.camel.component.debezium.configuration.OracleConnectorEmbeddedDebeziumConfiguration configuration) {
            doSetProperty("configuration", configuration);
            return this;
        }
        /**
         * The Converter class that should be used to serialize and deserialize
         * key data for offsets. The default is JSON converter.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Default: org.apache.kafka.connect.json.JsonConverter
         * Group: consumer
         * 
         * @param internalKeyConverter the value to set
         * @return the dsl builder
         */
        default DebeziumOracleComponentBuilder internalKeyConverter(
                java.lang.String internalKeyConverter) {
            doSetProperty("internalKeyConverter", internalKeyConverter);
            return this;
        }
        /**
         * The Converter class that should be used to serialize and deserialize
         * value data for offsets. The default is JSON converter.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Default: org.apache.kafka.connect.json.JsonConverter
         * Group: consumer
         * 
         * @param internalValueConverter the value to set
         * @return the dsl builder
         */
        default DebeziumOracleComponentBuilder internalValueConverter(
                java.lang.String internalValueConverter) {
            doSetProperty("internalValueConverter", internalValueConverter);
            return this;
        }
        /**
         * The name of the Java class of the commit policy. It defines when
         * offsets commit has to be triggered based on the number of events
         * processed and the time elapsed since the last commit. This class must
         * implement the interface 'OffsetCommitPolicy'. The default is a
         * periodic commit policy based upon time intervals.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: consumer
         * 
         * @param offsetCommitPolicy the value to set
         * @return the dsl builder
         */
        default DebeziumOracleComponentBuilder offsetCommitPolicy(
                java.lang.String offsetCommitPolicy) {
            doSetProperty("offsetCommitPolicy", offsetCommitPolicy);
            return this;
        }
        /**
         * Maximum number of milliseconds to wait for records to flush and
         * partition offset data to be committed to offset storage before
         * cancelling the process and restoring the offset data to be committed
         * in a future attempt. The default is 5 seconds.
         * 
         * The option is a: &lt;code&gt;long&lt;/code&gt; type.
         * 
         * Default: 5000
         * Group: consumer
         * 
         * @param offsetCommitTimeoutMs the value to set
         * @return the dsl builder
         */
        default DebeziumOracleComponentBuilder offsetCommitTimeoutMs(
                long offsetCommitTimeoutMs) {
            doSetProperty("offsetCommitTimeoutMs", offsetCommitTimeoutMs);
            return this;
        }
        /**
         * Interval at which to try committing offsets. The default is 1 minute.
         * 
         * The option is a: &lt;code&gt;long&lt;/code&gt; type.
         * 
         * Default: 60000
         * Group: consumer
         * 
         * @param offsetFlushIntervalMs the value to set
         * @return the dsl builder
         */
        default DebeziumOracleComponentBuilder offsetFlushIntervalMs(
                long offsetFlushIntervalMs) {
            doSetProperty("offsetFlushIntervalMs", offsetFlushIntervalMs);
            return this;
        }
        /**
         * The name of the Java class that is responsible for persistence of
         * connector offsets.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Default: org.apache.kafka.connect.storage.FileOffsetBackingStore
         * Group: consumer
         * 
         * @param offsetStorage the value to set
         * @return the dsl builder
         */
        default DebeziumOracleComponentBuilder offsetStorage(
                java.lang.String offsetStorage) {
            doSetProperty("offsetStorage", offsetStorage);
            return this;
        }
        /**
         * Path to file where offsets are to be stored. Required when
         * offset.storage is set to the FileOffsetBackingStore.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: consumer
         * 
         * @param offsetStorageFileName the value to set
         * @return the dsl builder
         */
        default DebeziumOracleComponentBuilder offsetStorageFileName(
                java.lang.String offsetStorageFileName) {
            doSetProperty("offsetStorageFileName", offsetStorageFileName);
            return this;
        }
        /**
         * The number of partitions used when creating the offset storage topic.
         * Required when offset.storage is set to the 'KafkaOffsetBackingStore'.
         * 
         * The option is a: &lt;code&gt;int&lt;/code&gt; type.
         * 
         * Group: consumer
         * 
         * @param offsetStoragePartitions the value to set
         * @return the dsl builder
         */
        default DebeziumOracleComponentBuilder offsetStoragePartitions(
                int offsetStoragePartitions) {
            doSetProperty("offsetStoragePartitions", offsetStoragePartitions);
            return this;
        }
        /**
         * Replication factor used when creating the offset storage topic.
         * Required when offset.storage is set to the KafkaOffsetBackingStore.
         * 
         * The option is a: &lt;code&gt;int&lt;/code&gt; type.
         * 
         * Group: consumer
         * 
         * @param offsetStorageReplicationFactor the value to set
         * @return the dsl builder
         */
        default DebeziumOracleComponentBuilder offsetStorageReplicationFactor(
                int offsetStorageReplicationFactor) {
            doSetProperty("offsetStorageReplicationFactor", offsetStorageReplicationFactor);
            return this;
        }
        /**
         * The name of the Kafka topic where offsets are to be stored. Required
         * when offset.storage is set to the KafkaOffsetBackingStore.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: consumer
         * 
         * @param offsetStorageTopic the value to set
         * @return the dsl builder
         */
        default DebeziumOracleComponentBuilder offsetStorageTopic(
                java.lang.String offsetStorageTopic) {
            doSetProperty("offsetStorageTopic", offsetStorageTopic);
            return this;
        }
        /**
         * Whether autowiring is enabled. This is used for automatic autowiring
         * options (the option must be marked as autowired) by looking up in the
         * registry to find if there is a single instance of matching type,
         * which then gets configured on the component. This can be used for
         * automatic configuring JDBC data sources, JMS connection factories,
         * AWS Clients, etc.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: true
         * Group: advanced
         * 
         * @param autowiredEnabled the value to set
         * @return the dsl builder
         */
        default DebeziumOracleComponentBuilder autowiredEnabled(
                boolean autowiredEnabled) {
            doSetProperty("autowiredEnabled", autowiredEnabled);
            return this;
        }
        /**
         * Specify how binary (blob, binary, etc.) columns should be represented
         * in change events, including: 'bytes' represents binary data as byte
         * array (default); 'base64' represents binary data as base64-encoded
         * string; 'base64-url-safe' represents binary data as
         * base64-url-safe-encoded string; 'hex' represents binary data as
         * hex-encoded (base16) string.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Default: bytes
         * Group: oracle
         * 
         * @param binaryHandlingMode the value to set
         * @return the dsl builder
         */
        default DebeziumOracleComponentBuilder binaryHandlingMode(
                java.lang.String binaryHandlingMode) {
            doSetProperty("binaryHandlingMode", binaryHandlingMode);
            return this;
        }
        /**
         * Regular expressions matching columns to exclude from change events.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: oracle
         * 
         * @param columnExcludeList the value to set
         * @return the dsl builder
         */
        default DebeziumOracleComponentBuilder columnExcludeList(
                java.lang.String columnExcludeList) {
            doSetProperty("columnExcludeList", columnExcludeList);
            return this;
        }
        /**
         * Regular expressions matching columns to include in change events.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: oracle
         * 
         * @param columnIncludeList the value to set
         * @return the dsl builder
         */
        default DebeziumOracleComponentBuilder columnIncludeList(
                java.lang.String columnIncludeList) {
            doSetProperty("columnIncludeList", columnIncludeList);
            return this;
        }
        /**
         * A comma-separated list of regular expressions matching
         * fully-qualified names of columns that adds the columns original type
         * and original length as parameters to the corresponding field schemas
         * in the emitted change records.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: oracle
         * 
         * @param columnPropagateSourceType the value to set
         * @return the dsl builder
         */
        default DebeziumOracleComponentBuilder columnPropagateSourceType(
                java.lang.String columnPropagateSourceType) {
            doSetProperty("columnPropagateSourceType", columnPropagateSourceType);
            return this;
        }
        /**
         * Optional list of custom converters that would be used instead of
         * default ones. The converters are defined using '.type' config option
         * and configured using options '.'.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: oracle
         * 
         * @param converters the value to set
         * @return the dsl builder
         */
        default DebeziumOracleComponentBuilder converters(
                java.lang.String converters) {
            doSetProperty("converters", converters);
            return this;
        }
        /**
         * The custom metric tags will accept key-value pairs to customize the
         * MBean object name which should be appended the end of regular name,
         * each key would represent a tag for the MBean object name, and the
         * corresponding value would be the value of that tag the key is. For
         * example: k1=v1,k2=v2.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: oracle
         * 
         * @param customMetricTags the value to set
         * @return the dsl builder
         */
        default DebeziumOracleComponentBuilder customMetricTags(
                java.lang.String customMetricTags) {
            doSetProperty("customMetricTags", customMetricTags);
            return this;
        }
        /**
         * The adapter to use when capturing changes from the database. Options
         * include: 'logminer': (the default) to capture changes using native
         * Oracle LogMiner; 'xstream' to capture changes using Oracle XStreams.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Default: LogMiner
         * Group: oracle
         * 
         * @param databaseConnectionAdapter the value to set
         * @return the dsl builder
         */
        default DebeziumOracleComponentBuilder databaseConnectionAdapter(
                java.lang.String databaseConnectionAdapter) {
            doSetProperty("databaseConnectionAdapter", databaseConnectionAdapter);
            return this;
        }
        /**
         * The name of the database from which the connector should capture
         * changes.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: oracle
         * 
         * @param databaseDbname the value to set
         * @return the dsl builder
         */
        default DebeziumOracleComponentBuilder databaseDbname(
                java.lang.String databaseDbname) {
            doSetProperty("databaseDbname", databaseDbname);
            return this;
        }
        /**
         * Resolvable hostname or IP address of the database server.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: oracle
         * 
         * @param databaseHostname the value to set
         * @return the dsl builder
         */
        default DebeziumOracleComponentBuilder databaseHostname(
                java.lang.String databaseHostname) {
            doSetProperty("databaseHostname", databaseHostname);
            return this;
        }
        /**
         * Name of the XStream Out server to connect to.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: oracle
         * 
         * @param databaseOutServerName the value to set
         * @return the dsl builder
         */
        default DebeziumOracleComponentBuilder databaseOutServerName(
                java.lang.String databaseOutServerName) {
            doSetProperty("databaseOutServerName", databaseOutServerName);
            return this;
        }
        /**
         * Password of the database user to be used when connecting to the
         * database.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: oracle
         * 
         * @param databasePassword the value to set
         * @return the dsl builder
         */
        default DebeziumOracleComponentBuilder databasePassword(
                java.lang.String databasePassword) {
            doSetProperty("databasePassword", databasePassword);
            return this;
        }
        /**
         * Name of the pluggable database when working with a multi-tenant
         * set-up. The CDB name must be given via database.dbname in this case.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: oracle
         * 
         * @param databasePdbName the value to set
         * @return the dsl builder
         */
        default DebeziumOracleComponentBuilder databasePdbName(
                java.lang.String databasePdbName) {
            doSetProperty("databasePdbName", databasePdbName);
            return this;
        }
        /**
         * Port of the database server.
         * 
         * The option is a: &lt;code&gt;int&lt;/code&gt; type.
         * 
         * Default: 1528
         * Group: oracle
         * 
         * @param databasePort the value to set
         * @return the dsl builder
         */
        default DebeziumOracleComponentBuilder databasePort(int databasePort) {
            doSetProperty("databasePort", databasePort);
            return this;
        }
        /**
         * Complete JDBC URL as an alternative to specifying hostname, port and
         * database provided as a way to support alternative connection
         * scenarios.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: oracle
         * 
         * @param databaseUrl the value to set
         * @return the dsl builder
         */
        default DebeziumOracleComponentBuilder databaseUrl(
                java.lang.String databaseUrl) {
            doSetProperty("databaseUrl", databaseUrl);
            return this;
        }
        /**
         * Name of the database user to be used when connecting to the database.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: oracle
         * 
         * @param databaseUser the value to set
         * @return the dsl builder
         */
        default DebeziumOracleComponentBuilder databaseUser(
                java.lang.String databaseUser) {
            doSetProperty("databaseUser", databaseUser);
            return this;
        }
        /**
         * A comma-separated list of regular expressions matching the
         * database-specific data type names that adds the data type's original
         * type and original length as parameters to the corresponding field
         * schemas in the emitted change records.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: oracle
         * 
         * @param datatypePropagateSourceType the value to set
         * @return the dsl builder
         */
        default DebeziumOracleComponentBuilder datatypePropagateSourceType(
                java.lang.String datatypePropagateSourceType) {
            doSetProperty("datatypePropagateSourceType", datatypePropagateSourceType);
            return this;
        }
        /**
         * Specify how DECIMAL and NUMERIC columns should be represented in
         * change events, including: 'precise' (the default) uses
         * java.math.BigDecimal to represent values, which are encoded in the
         * change events using a binary representation and Kafka Connect's
         * 'org.apache.kafka.connect.data.Decimal' type; 'string' uses string to
         * represent values; 'double' represents values using Java's 'double',
         * which may not offer the precision but will be far easier to use in
         * consumers.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Default: precise
         * Group: oracle
         * 
         * @param decimalHandlingMode the value to set
         * @return the dsl builder
         */
        default DebeziumOracleComponentBuilder decimalHandlingMode(
                java.lang.String decimalHandlingMode) {
            doSetProperty("decimalHandlingMode", decimalHandlingMode);
            return this;
        }
        /**
         * The maximum number of retries on connection errors before failing (-1
         * = no limit, 0 = disabled, 0 = num of retries).
         * 
         * The option is a: &lt;code&gt;int&lt;/code&gt; type.
         * 
         * Default: -1
         * Group: oracle
         * 
         * @param errorsMaxRetries the value to set
         * @return the dsl builder
         */
        default DebeziumOracleComponentBuilder errorsMaxRetries(
                int errorsMaxRetries) {
            doSetProperty("errorsMaxRetries", errorsMaxRetries);
            return this;
        }
        /**
         * Specify how failures during processing of events (i.e. when
         * encountering a corrupted event) should be handled, including: 'fail'
         * (the default) an exception indicating the problematic event and its
         * position is raised, causing the connector to be stopped; 'warn' the
         * problematic event and its position will be logged and the event will
         * be skipped; 'ignore' the problematic event will be skipped.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Default: fail
         * Group: oracle
         * 
         * @param eventProcessingFailureHandlingMode the value to set
         * @return the dsl builder
         */
        default DebeziumOracleComponentBuilder eventProcessingFailureHandlingMode(
                java.lang.String eventProcessingFailureHandlingMode) {
            doSetProperty("eventProcessingFailureHandlingMode", eventProcessingFailureHandlingMode);
            return this;
        }
        /**
         * The query executed with every heartbeat.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: oracle
         * 
         * @param heartbeatActionQuery the value to set
         * @return the dsl builder
         */
        default DebeziumOracleComponentBuilder heartbeatActionQuery(
                java.lang.String heartbeatActionQuery) {
            doSetProperty("heartbeatActionQuery", heartbeatActionQuery);
            return this;
        }
        /**
         * Length of an interval in milli-seconds in in which the connector
         * periodically sends heartbeat messages to a heartbeat topic. Use 0 to
         * disable heartbeat messages. Disabled by default.
         * 
         * The option is a: &lt;code&gt;int&lt;/code&gt; type.
         * 
         * Default: 0ms
         * Group: oracle
         * 
         * @param heartbeatIntervalMs the value to set
         * @return the dsl builder
         */
        default DebeziumOracleComponentBuilder heartbeatIntervalMs(
                int heartbeatIntervalMs) {
            doSetProperty("heartbeatIntervalMs", heartbeatIntervalMs);
            return this;
        }
        /**
         * The prefix that is used to name heartbeat topics.Defaults to
         * __debezium-heartbeat.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Default: __debezium-heartbeat
         * Group: oracle
         * 
         * @param heartbeatTopicsPrefix the value to set
         * @return the dsl builder
         */
        default DebeziumOracleComponentBuilder heartbeatTopicsPrefix(
                java.lang.String heartbeatTopicsPrefix) {
            doSetProperty("heartbeatTopicsPrefix", heartbeatTopicsPrefix);
            return this;
        }
        /**
         * Whether the connector should publish changes in the database schema
         * to a Kafka topic with the same name as the database server ID. Each
         * schema change will be recorded using a key that contains the database
         * name and whose value include logical description of the new schema
         * and optionally the DDL statement(s). The default is 'true'. This is
         * independent of how the connector internally records database schema
         * history.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: true
         * Group: oracle
         * 
         * @param includeSchemaChanges the value to set
         * @return the dsl builder
         */
        default DebeziumOracleComponentBuilder includeSchemaChanges(
                boolean includeSchemaChanges) {
            doSetProperty("includeSchemaChanges", includeSchemaChanges);
            return this;
        }
        /**
         * Whether the connector parse table and column's comment to metadata
         * object. Note: Enable this option will bring the implications on
         * memory usage. The number and size of ColumnImpl objects is what
         * largely impacts how much memory is consumed by the Debezium
         * connectors, and adding a String to each of them can potentially be
         * quite heavy. The default is 'false'.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: false
         * Group: oracle
         * 
         * @param includeSchemaComments the value to set
         * @return the dsl builder
         */
        default DebeziumOracleComponentBuilder includeSchemaComments(
                boolean includeSchemaComments) {
            doSetProperty("includeSchemaComments", includeSchemaComments);
            return this;
        }
        /**
         * Specify how INTERVAL columns should be represented in change events,
         * including: 'string' represents values as an exact ISO formatted
         * string; 'numeric' (default) represents values using the inexact
         * conversion into microseconds.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Default: numeric
         * Group: oracle
         * 
         * @param intervalHandlingMode the value to set
         * @return the dsl builder
         */
        default DebeziumOracleComponentBuilder intervalHandlingMode(
                java.lang.String intervalHandlingMode) {
            doSetProperty("intervalHandlingMode", intervalHandlingMode);
            return this;
        }
        /**
         * When set to 'false', the default, LOB fields will not be captured nor
         * emitted. When set to 'true', the connector will capture LOB fields
         * and emit changes for those fields like any other column type.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: false
         * Group: oracle
         * 
         * @param lobEnabled the value to set
         * @return the dsl builder
         */
        default DebeziumOracleComponentBuilder lobEnabled(boolean lobEnabled) {
            doSetProperty("lobEnabled", lobEnabled);
            return this;
        }
        /**
         * Sets the specific archive log destination as the source for reading
         * archive logs.When not set, the connector will automatically select
         * the first LOCAL and VALID destination.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: oracle
         * 
         * @param logMiningArchiveDestinationName the value to set
         * @return the dsl builder
         */
        default DebeziumOracleComponentBuilder logMiningArchiveDestinationName(
                java.lang.String logMiningArchiveDestinationName) {
            doSetProperty("logMiningArchiveDestinationName", logMiningArchiveDestinationName);
            return this;
        }
        /**
         * The number of hours in the past from SYSDATE to mine archive logs.
         * Using 0 mines all available archive logs.
         * 
         * The option is a: &lt;code&gt;long&lt;/code&gt; type.
         * 
         * Default: 0
         * Group: oracle
         * 
         * @param logMiningArchiveLogHours the value to set
         * @return the dsl builder
         */
        default DebeziumOracleComponentBuilder logMiningArchiveLogHours(
                long logMiningArchiveLogHours) {
            doSetProperty("logMiningArchiveLogHours", logMiningArchiveLogHours);
            return this;
        }
        /**
         * When set to 'false', the default, the connector will mine both
         * archive log and redo logs to emit change events. When set to 'true',
         * the connector will only mine archive logs. There are circumstances
         * where its advantageous to only mine archive logs and accept latency
         * in event emission due to frequent revolving redo logs.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: false
         * Group: oracle
         * 
         * @param logMiningArchiveLogOnlyMode the value to set
         * @return the dsl builder
         */
        default DebeziumOracleComponentBuilder logMiningArchiveLogOnlyMode(
                boolean logMiningArchiveLogOnlyMode) {
            doSetProperty("logMiningArchiveLogOnlyMode", logMiningArchiveLogOnlyMode);
            return this;
        }
        /**
         * The interval in milliseconds to wait between polls checking to see if
         * the SCN is in the archive logs.
         * 
         * The option is a: &lt;code&gt;long&lt;/code&gt; type.
         * 
         * Default: 10s
         * Group: oracle
         * 
         * @param logMiningArchiveLogOnlyScnPollIntervalMs the value to set
         * @return the dsl builder
         */
        default DebeziumOracleComponentBuilder logMiningArchiveLogOnlyScnPollIntervalMs(
                long logMiningArchiveLogOnlyScnPollIntervalMs) {
            doSetProperty("logMiningArchiveLogOnlyScnPollIntervalMs", logMiningArchiveLogOnlyScnPollIntervalMs);
            return this;
        }
        /**
         * The starting SCN interval size that the connector will use for
         * reading data from redo/archive logs.
         * 
         * The option is a: &lt;code&gt;long&lt;/code&gt; type.
         * 
         * Default: 20000
         * Group: oracle
         * 
         * @param logMiningBatchSizeDefault the value to set
         * @return the dsl builder
         */
        default DebeziumOracleComponentBuilder logMiningBatchSizeDefault(
                long logMiningBatchSizeDefault) {
            doSetProperty("logMiningBatchSizeDefault", logMiningBatchSizeDefault);
            return this;
        }
        /**
         * The maximum SCN interval size that this connector will use when
         * reading from redo/archive logs.
         * 
         * The option is a: &lt;code&gt;long&lt;/code&gt; type.
         * 
         * Default: 100000
         * Group: oracle
         * 
         * @param logMiningBatchSizeMax the value to set
         * @return the dsl builder
         */
        default DebeziumOracleComponentBuilder logMiningBatchSizeMax(
                long logMiningBatchSizeMax) {
            doSetProperty("logMiningBatchSizeMax", logMiningBatchSizeMax);
            return this;
        }
        /**
         * The minimum SCN interval size that this connector will try to read
         * from redo/archive logs. Active batch size will be also
         * increased/decreased by this amount for tuning connector throughput
         * when needed.
         * 
         * The option is a: &lt;code&gt;long&lt;/code&gt; type.
         * 
         * Default: 1000
         * Group: oracle
         * 
         * @param logMiningBatchSizeMin the value to set
         * @return the dsl builder
         */
        default DebeziumOracleComponentBuilder logMiningBatchSizeMin(
                long logMiningBatchSizeMin) {
            doSetProperty("logMiningBatchSizeMin", logMiningBatchSizeMin);
            return this;
        }
        /**
         * When set to true the underlying buffer cache is not retained when the
         * connector is stopped. When set to false (the default), the buffer
         * cache is retained across restarts.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: false
         * Group: oracle
         * 
         * @param logMiningBufferDropOnStop the value to set
         * @return the dsl builder
         */
        default DebeziumOracleComponentBuilder logMiningBufferDropOnStop(
                boolean logMiningBufferDropOnStop) {
            doSetProperty("logMiningBufferDropOnStop", logMiningBufferDropOnStop);
            return this;
        }
        /**
         * Specifies the XML configuration for the Infinispan 'events' cache.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: oracle
         * 
         * @param logMiningBufferInfinispanCacheEvents the value to set
         * @return the dsl builder
         */
        default DebeziumOracleComponentBuilder logMiningBufferInfinispanCacheEvents(
                java.lang.String logMiningBufferInfinispanCacheEvents) {
            doSetProperty("logMiningBufferInfinispanCacheEvents", logMiningBufferInfinispanCacheEvents);
            return this;
        }
        /**
         * Specifies the XML configuration for the Infinispan 'global'
         * configuration.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: oracle
         * 
         * @param logMiningBufferInfinispanCacheGlobal the value to set
         * @return the dsl builder
         */
        default DebeziumOracleComponentBuilder logMiningBufferInfinispanCacheGlobal(
                java.lang.String logMiningBufferInfinispanCacheGlobal) {
            doSetProperty("logMiningBufferInfinispanCacheGlobal", logMiningBufferInfinispanCacheGlobal);
            return this;
        }
        /**
         * Specifies the XML configuration for the Infinispan
         * 'processed-transactions' cache.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: oracle
         * 
         * @param logMiningBufferInfinispanCacheProcessedTransactions the value
         * to set
         * @return the dsl builder
         */
        default DebeziumOracleComponentBuilder logMiningBufferInfinispanCacheProcessedTransactions(
                java.lang.String logMiningBufferInfinispanCacheProcessedTransactions) {
            doSetProperty("logMiningBufferInfinispanCacheProcessedTransactions", logMiningBufferInfinispanCacheProcessedTransactions);
            return this;
        }
        /**
         * Specifies the XML configuration for the Infinispan 'schema-changes'
         * cache.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: oracle
         * 
         * @param logMiningBufferInfinispanCacheSchemaChanges the value to set
         * @return the dsl builder
         */
        default DebeziumOracleComponentBuilder logMiningBufferInfinispanCacheSchemaChanges(
                java.lang.String logMiningBufferInfinispanCacheSchemaChanges) {
            doSetProperty("logMiningBufferInfinispanCacheSchemaChanges", logMiningBufferInfinispanCacheSchemaChanges);
            return this;
        }
        /**
         * Specifies the XML configuration for the Infinispan 'transactions'
         * cache.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: oracle
         * 
         * @param logMiningBufferInfinispanCacheTransactions the value to set
         * @return the dsl builder
         */
        default DebeziumOracleComponentBuilder logMiningBufferInfinispanCacheTransactions(
                java.lang.String logMiningBufferInfinispanCacheTransactions) {
            doSetProperty("logMiningBufferInfinispanCacheTransactions", logMiningBufferInfinispanCacheTransactions);
            return this;
        }
        /**
         * The number of events a transaction can include before the transaction
         * is discarded. This is useful for managing buffer memory and/or space
         * when dealing with very large transactions. Defaults to 0, meaning
         * that no threshold is applied and transactions can have unlimited
         * events.
         * 
         * The option is a: &lt;code&gt;long&lt;/code&gt; type.
         * 
         * Default: 0
         * Group: oracle
         * 
         * @param logMiningBufferTransactionEventsThreshold the value to set
         * @return the dsl builder
         */
        default DebeziumOracleComponentBuilder logMiningBufferTransactionEventsThreshold(
                long logMiningBufferTransactionEventsThreshold) {
            doSetProperty("logMiningBufferTransactionEventsThreshold", logMiningBufferTransactionEventsThreshold);
            return this;
        }
        /**
         * The buffer type controls how the connector manages buffering
         * transaction data. memory - Uses the JVM process' heap to buffer all
         * transaction data. infinispan_embedded - This option uses an embedded
         * Infinispan cache to buffer transaction data and persist it to disk.
         * infinispan_remote - This option uses a remote Infinispan cluster to
         * buffer transaction data and persist it to disk.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Default: memory
         * Group: oracle
         * 
         * @param logMiningBufferType the value to set
         * @return the dsl builder
         */
        default DebeziumOracleComponentBuilder logMiningBufferType(
                java.lang.String logMiningBufferType) {
            doSetProperty("logMiningBufferType", logMiningBufferType);
            return this;
        }
        /**
         * The name of the flush table used by the connector, defaults to
         * LOG_MINING_FLUSH.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Default: LOG_MINING_FLUSH
         * Group: oracle
         * 
         * @param logMiningFlushTableName the value to set
         * @return the dsl builder
         */
        default DebeziumOracleComponentBuilder logMiningFlushTableName(
                java.lang.String logMiningFlushTableName) {
            doSetProperty("logMiningFlushTableName", logMiningFlushTableName);
            return this;
        }
        /**
         * Specifies how the filter configuration is applied to the LogMiner
         * database query. none - The query does not apply any schema or table
         * filters, all filtering is at runtime by the connector. in - The query
         * uses SQL in-clause expressions to specify the schema or table
         * filters. regex - The query uses Oracle REGEXP_LIKE expressions to
         * specify the schema or table filters.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Default: none
         * Group: oracle
         * 
         * @param logMiningQueryFilterMode the value to set
         * @return the dsl builder
         */
        default DebeziumOracleComponentBuilder logMiningQueryFilterMode(
                java.lang.String logMiningQueryFilterMode) {
            doSetProperty("logMiningQueryFilterMode", logMiningQueryFilterMode);
            return this;
        }
        /**
         * Debezium opens a database connection and keeps that connection open
         * throughout the entire streaming phase. In some situations, this can
         * lead to excessive SGA memory usage. By setting this option to 'true'
         * (the default is 'false'), the connector will close and re-open a
         * database connection after every detected log switch or if the
         * log.mining.session.max.ms has been reached.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: false
         * Group: oracle
         * 
         * @param logMiningRestartConnection the value to set
         * @return the dsl builder
         */
        default DebeziumOracleComponentBuilder logMiningRestartConnection(
                boolean logMiningRestartConnection) {
            doSetProperty("logMiningRestartConnection", logMiningRestartConnection);
            return this;
        }
        /**
         * Used for SCN gap detection, if the difference between current SCN and
         * previous end SCN is bigger than this value, and the time difference
         * of current SCN and previous end SCN is smaller than
         * log.mining.scn.gap.detection.time.interval.max.ms, consider it a SCN
         * gap.
         * 
         * The option is a: &lt;code&gt;long&lt;/code&gt; type.
         * 
         * Default: 1000000
         * Group: oracle
         * 
         * @param logMiningScnGapDetectionGapSizeMin the value to set
         * @return the dsl builder
         */
        default DebeziumOracleComponentBuilder logMiningScnGapDetectionGapSizeMin(
                long logMiningScnGapDetectionGapSizeMin) {
            doSetProperty("logMiningScnGapDetectionGapSizeMin", logMiningScnGapDetectionGapSizeMin);
            return this;
        }
        /**
         * Used for SCN gap detection, if the difference between current SCN and
         * previous end SCN is bigger than
         * log.mining.scn.gap.detection.gap.size.min, and the time difference of
         * current SCN and previous end SCN is smaller than this value, consider
         * it a SCN gap.
         * 
         * The option is a: &lt;code&gt;long&lt;/code&gt; type.
         * 
         * Default: 20s
         * Group: oracle
         * 
         * @param logMiningScnGapDetectionTimeIntervalMaxMs the value to set
         * @return the dsl builder
         */
        default DebeziumOracleComponentBuilder logMiningScnGapDetectionTimeIntervalMaxMs(
                long logMiningScnGapDetectionTimeIntervalMaxMs) {
            doSetProperty("logMiningScnGapDetectionTimeIntervalMaxMs", logMiningScnGapDetectionTimeIntervalMaxMs);
            return this;
        }
        /**
         * The maximum number of milliseconds that a LogMiner session lives for
         * before being restarted. Defaults to 0 (indefinite until a log switch
         * occurs).
         * 
         * The option is a: &lt;code&gt;long&lt;/code&gt; type.
         * 
         * Default: 0ms
         * Group: oracle
         * 
         * @param logMiningSessionMaxMs the value to set
         * @return the dsl builder
         */
        default DebeziumOracleComponentBuilder logMiningSessionMaxMs(
                long logMiningSessionMaxMs) {
            doSetProperty("logMiningSessionMaxMs", logMiningSessionMaxMs);
            return this;
        }
        /**
         * The amount of time that the connector will sleep after reading data
         * from redo/archive logs and before starting reading data again. Value
         * is in milliseconds.
         * 
         * The option is a: &lt;code&gt;long&lt;/code&gt; type.
         * 
         * Default: 1s
         * Group: oracle
         * 
         * @param logMiningSleepTimeDefaultMs the value to set
         * @return the dsl builder
         */
        default DebeziumOracleComponentBuilder logMiningSleepTimeDefaultMs(
                long logMiningSleepTimeDefaultMs) {
            doSetProperty("logMiningSleepTimeDefaultMs", logMiningSleepTimeDefaultMs);
            return this;
        }
        /**
         * The maximum amount of time that the connector will use to tune the
         * optimal sleep time when reading data from LogMiner. Value is in
         * milliseconds.
         * 
         * The option is a: &lt;code&gt;long&lt;/code&gt; type.
         * 
         * Default: 200ms
         * Group: oracle
         * 
         * @param logMiningSleepTimeIncrementMs the value to set
         * @return the dsl builder
         */
        default DebeziumOracleComponentBuilder logMiningSleepTimeIncrementMs(
                long logMiningSleepTimeIncrementMs) {
            doSetProperty("logMiningSleepTimeIncrementMs", logMiningSleepTimeIncrementMs);
            return this;
        }
        /**
         * The maximum amount of time that the connector will sleep after
         * reading data from redo/archive logs and before starting reading data
         * again. Value is in milliseconds.
         * 
         * The option is a: &lt;code&gt;long&lt;/code&gt; type.
         * 
         * Default: 3s
         * Group: oracle
         * 
         * @param logMiningSleepTimeMaxMs the value to set
         * @return the dsl builder
         */
        default DebeziumOracleComponentBuilder logMiningSleepTimeMaxMs(
                long logMiningSleepTimeMaxMs) {
            doSetProperty("logMiningSleepTimeMaxMs", logMiningSleepTimeMaxMs);
            return this;
        }
        /**
         * The minimum amount of time that the connector will sleep after
         * reading data from redo/archive logs and before starting reading data
         * again. Value is in milliseconds.
         * 
         * The option is a: &lt;code&gt;long&lt;/code&gt; type.
         * 
         * Default: 0ms
         * Group: oracle
         * 
         * @param logMiningSleepTimeMinMs the value to set
         * @return the dsl builder
         */
        default DebeziumOracleComponentBuilder logMiningSleepTimeMinMs(
                long logMiningSleepTimeMinMs) {
            doSetProperty("logMiningSleepTimeMinMs", logMiningSleepTimeMinMs);
            return this;
        }
        /**
         * There are strategies: Online catalog with faster mining but no
         * captured DDL. Another - with data dictionary loaded into REDO LOG
         * files.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Default: redo_log_catalog
         * Group: oracle
         * 
         * @param logMiningStrategy the value to set
         * @return the dsl builder
         */
        default DebeziumOracleComponentBuilder logMiningStrategy(
                java.lang.String logMiningStrategy) {
            doSetProperty("logMiningStrategy", logMiningStrategy);
            return this;
        }
        /**
         * Duration in milliseconds to keep long running transactions in
         * transaction buffer between log mining sessions. By default, all
         * transactions are retained.
         * 
         * The option is a: &lt;code&gt;long&lt;/code&gt; type.
         * 
         * Default: 0ms
         * Group: oracle
         * 
         * @param logMiningTransactionRetentionMs the value to set
         * @return the dsl builder
         */
        default DebeziumOracleComponentBuilder logMiningTransactionRetentionMs(
                long logMiningTransactionRetentionMs) {
            doSetProperty("logMiningTransactionRetentionMs", logMiningTransactionRetentionMs);
            return this;
        }
        /**
         * Comma separated list of usernames to exclude from LogMiner query.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: oracle
         * 
         * @param logMiningUsernameExcludeList the value to set
         * @return the dsl builder
         */
        default DebeziumOracleComponentBuilder logMiningUsernameExcludeList(
                java.lang.String logMiningUsernameExcludeList) {
            doSetProperty("logMiningUsernameExcludeList", logMiningUsernameExcludeList);
            return this;
        }
        /**
         * Comma separated list of usernames to include from LogMiner query.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: oracle
         * 
         * @param logMiningUsernameIncludeList the value to set
         * @return the dsl builder
         */
        default DebeziumOracleComponentBuilder logMiningUsernameIncludeList(
                java.lang.String logMiningUsernameIncludeList) {
            doSetProperty("logMiningUsernameIncludeList", logMiningUsernameIncludeList);
            return this;
        }
        /**
         * Maximum size of each batch of source records. Defaults to 2048.
         * 
         * The option is a: &lt;code&gt;int&lt;/code&gt; type.
         * 
         * Default: 2048
         * Group: oracle
         * 
         * @param maxBatchSize the value to set
         * @return the dsl builder
         */
        default DebeziumOracleComponentBuilder maxBatchSize(int maxBatchSize) {
            doSetProperty("maxBatchSize", maxBatchSize);
            return this;
        }
        /**
         * Maximum size of the queue for change events read from the database
         * log but not yet recorded or forwarded. Defaults to 8192, and should
         * always be larger than the maximum batch size.
         * 
         * The option is a: &lt;code&gt;int&lt;/code&gt; type.
         * 
         * Default: 8192
         * Group: oracle
         * 
         * @param maxQueueSize the value to set
         * @return the dsl builder
         */
        default DebeziumOracleComponentBuilder maxQueueSize(int maxQueueSize) {
            doSetProperty("maxQueueSize", maxQueueSize);
            return this;
        }
        /**
         * Maximum size of the queue in bytes for change events read from the
         * database log but not yet recorded or forwarded. Defaults to 0. Mean
         * the feature is not enabled.
         * 
         * The option is a: &lt;code&gt;long&lt;/code&gt; type.
         * 
         * Default: 0
         * Group: oracle
         * 
         * @param maxQueueSizeInBytes the value to set
         * @return the dsl builder
         */
        default DebeziumOracleComponentBuilder maxQueueSizeInBytes(
                long maxQueueSizeInBytes) {
            doSetProperty("maxQueueSizeInBytes", maxQueueSizeInBytes);
            return this;
        }
        /**
         * A semicolon-separated list of expressions that match fully-qualified
         * tables and column(s) to be used as message key. Each expression must
         * match the pattern ':', where the table names could be defined as
         * (DB_NAME.TABLE_NAME) or (SCHEMA_NAME.TABLE_NAME), depending on the
         * specific connector, and the key columns are a comma-separated list of
         * columns representing the custom key. For any table without an
         * explicit key configuration the table's primary key column(s) will be
         * used as message key. Example:
         * dbserver1.inventory.orderlines:orderId,orderLineId;dbserver1.inventory.orders:id.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: oracle
         * 
         * @param messageKeyColumns the value to set
         * @return the dsl builder
         */
        default DebeziumOracleComponentBuilder messageKeyColumns(
                java.lang.String messageKeyColumns) {
            doSetProperty("messageKeyColumns", messageKeyColumns);
            return this;
        }
        /**
         * List of notification channels names that are enabled.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: oracle
         * 
         * @param notificationEnabledChannels the value to set
         * @return the dsl builder
         */
        default DebeziumOracleComponentBuilder notificationEnabledChannels(
                java.lang.String notificationEnabledChannels) {
            doSetProperty("notificationEnabledChannels", notificationEnabledChannels);
            return this;
        }
        /**
         * The name of the topic for the notifications. This is required in case
         * 'sink' is in the list of enabled channels.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: oracle
         * 
         * @param notificationSinkTopicName the value to set
         * @return the dsl builder
         */
        default DebeziumOracleComponentBuilder notificationSinkTopicName(
                java.lang.String notificationSinkTopicName) {
            doSetProperty("notificationSinkTopicName", notificationSinkTopicName);
            return this;
        }
        /**
         * The hostname of the OpenLogReplicator network service.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: oracle
         * 
         * @param openlogreplicatorHost the value to set
         * @return the dsl builder
         */
        default DebeziumOracleComponentBuilder openlogreplicatorHost(
                java.lang.String openlogreplicatorHost) {
            doSetProperty("openlogreplicatorHost", openlogreplicatorHost);
            return this;
        }
        /**
         * The port of the OpenLogReplicator network service.
         * 
         * The option is a: &lt;code&gt;int&lt;/code&gt; type.
         * 
         * Group: oracle
         * 
         * @param openlogreplicatorPort the value to set
         * @return the dsl builder
         */
        default DebeziumOracleComponentBuilder openlogreplicatorPort(
                int openlogreplicatorPort) {
            doSetProperty("openlogreplicatorPort", openlogreplicatorPort);
            return this;
        }
        /**
         * The configured logical source name in the OpenLogReplicator
         * configuration that is to stream changes.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: oracle
         * 
         * @param openlogreplicatorSource the value to set
         * @return the dsl builder
         */
        default DebeziumOracleComponentBuilder openlogreplicatorSource(
                java.lang.String openlogreplicatorSource) {
            doSetProperty("openlogreplicatorSource", openlogreplicatorSource);
            return this;
        }
        /**
         * Time to wait for new change events to appear after receiving no
         * events, given in milliseconds. Defaults to 500 ms.
         * 
         * The option is a: &lt;code&gt;long&lt;/code&gt; type.
         * 
         * Default: 500ms
         * Group: oracle
         * 
         * @param pollIntervalMs the value to set
         * @return the dsl builder
         */
        default DebeziumOracleComponentBuilder pollIntervalMs(
                long pollIntervalMs) {
            doSetProperty("pollIntervalMs", pollIntervalMs);
            return this;
        }
        /**
         * Enables transaction metadata extraction together with event counting.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: false
         * Group: oracle
         * 
         * @param provideTransactionMetadata the value to set
         * @return the dsl builder
         */
        default DebeziumOracleComponentBuilder provideTransactionMetadata(
                boolean provideTransactionMetadata) {
            doSetProperty("provideTransactionMetadata", provideTransactionMetadata);
            return this;
        }
        /**
         * The maximum number of records that should be loaded into memory while
         * streaming. A value of '0' uses the default JDBC fetch size, defaults
         * to '2000'.
         * 
         * The option is a: &lt;code&gt;int&lt;/code&gt; type.
         * 
         * Default: 10000
         * Group: oracle
         * 
         * @param queryFetchSize the value to set
         * @return the dsl builder
         */
        default DebeziumOracleComponentBuilder queryFetchSize(int queryFetchSize) {
            doSetProperty("queryFetchSize", queryFetchSize);
            return this;
        }
        /**
         * A comma-separated list of RAC node hostnames or ip addresses.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: oracle
         * 
         * @param racNodes the value to set
         * @return the dsl builder
         */
        default DebeziumOracleComponentBuilder racNodes(
                java.lang.String racNodes) {
            doSetProperty("racNodes", racNodes);
            return this;
        }
        /**
         * Time to wait before restarting connector after retriable exception
         * occurs. Defaults to 10000ms.
         * 
         * The option is a: &lt;code&gt;long&lt;/code&gt; type.
         * 
         * Default: 10s
         * Group: oracle
         * 
         * @param retriableRestartConnectorWaitMs the value to set
         * @return the dsl builder
         */
        default DebeziumOracleComponentBuilder retriableRestartConnectorWaitMs(
                long retriableRestartConnectorWaitMs) {
            doSetProperty("retriableRestartConnectorWaitMs", retriableRestartConnectorWaitMs);
            return this;
        }
        /**
         * The name of the SchemaHistory class that should be used to store and
         * recover database schema changes. The configuration properties for the
         * history are prefixed with the 'schema.history.internal.' string.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Default: io.debezium.storage.kafka.history.KafkaSchemaHistory
         * Group: oracle
         * 
         * @param schemaHistoryInternal the value to set
         * @return the dsl builder
         */
        default DebeziumOracleComponentBuilder schemaHistoryInternal(
                java.lang.String schemaHistoryInternal) {
            doSetProperty("schemaHistoryInternal", schemaHistoryInternal);
            return this;
        }
        /**
         * The path to the file that will be used to record the database schema
         * history.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: oracle
         * 
         * @param schemaHistoryInternalFileFilename the value to set
         * @return the dsl builder
         */
        default DebeziumOracleComponentBuilder schemaHistoryInternalFileFilename(
                java.lang.String schemaHistoryInternalFileFilename) {
            doSetProperty("schemaHistoryInternalFileFilename", schemaHistoryInternalFileFilename);
            return this;
        }
        /**
         * Controls the action Debezium will take when it meets a DDL statement
         * in binlog, that it cannot parse.By default the connector will stop
         * operating but by changing the setting it can ignore the statements
         * which it cannot parse. If skipping is enabled then Debezium can miss
         * metadata changes.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: false
         * Group: oracle
         * 
         * @param schemaHistoryInternalSkipUnparseableDdl the value to set
         * @return the dsl builder
         */
        default DebeziumOracleComponentBuilder schemaHistoryInternalSkipUnparseableDdl(
                boolean schemaHistoryInternalSkipUnparseableDdl) {
            doSetProperty("schemaHistoryInternalSkipUnparseableDdl", schemaHistoryInternalSkipUnparseableDdl);
            return this;
        }
        /**
         * Controls what DDL will Debezium store in database schema history. By
         * default (true) only DDL that manipulates a table from captured
         * schema/database will be stored. If set to false, then Debezium will
         * store all incoming DDL statements.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: false
         * Group: oracle
         * 
         * @param schemaHistoryInternalStoreOnlyCapturedDatabasesDdl the value
         * to set
         * @return the dsl builder
         */
        default DebeziumOracleComponentBuilder schemaHistoryInternalStoreOnlyCapturedDatabasesDdl(
                boolean schemaHistoryInternalStoreOnlyCapturedDatabasesDdl) {
            doSetProperty("schemaHistoryInternalStoreOnlyCapturedDatabasesDdl", schemaHistoryInternalStoreOnlyCapturedDatabasesDdl);
            return this;
        }
        /**
         * Controls what DDL will Debezium store in database schema history. By
         * default (false) Debezium will store all incoming DDL statements. If
         * set to true, then only DDL that manipulates a captured table will be
         * stored.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: false
         * Group: oracle
         * 
         * @param schemaHistoryInternalStoreOnlyCapturedTablesDdl the value to
         * set
         * @return the dsl builder
         */
        default DebeziumOracleComponentBuilder schemaHistoryInternalStoreOnlyCapturedTablesDdl(
                boolean schemaHistoryInternalStoreOnlyCapturedTablesDdl) {
            doSetProperty("schemaHistoryInternalStoreOnlyCapturedTablesDdl", schemaHistoryInternalStoreOnlyCapturedTablesDdl);
            return this;
        }
        /**
         * Specify how schema names should be adjusted for compatibility with
         * the message converter used by the connector, including: 'avro'
         * replaces the characters that cannot be used in the Avro type name
         * with underscore; 'avro_unicode' replaces the underscore or characters
         * that cannot be used in the Avro type name with corresponding unicode
         * like _uxxxx. Note: _ is an escape sequence like backslash in
         * Java;'none' does not apply any adjustment (default).
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Default: none
         * Group: oracle
         * 
         * @param schemaNameAdjustmentMode the value to set
         * @return the dsl builder
         */
        default DebeziumOracleComponentBuilder schemaNameAdjustmentMode(
                java.lang.String schemaNameAdjustmentMode) {
            doSetProperty("schemaNameAdjustmentMode", schemaNameAdjustmentMode);
            return this;
        }
        /**
         * The name of the data collection that is used to send signals/commands
         * to Debezium. Signaling is disabled when not set.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: oracle
         * 
         * @param signalDataCollection the value to set
         * @return the dsl builder
         */
        default DebeziumOracleComponentBuilder signalDataCollection(
                java.lang.String signalDataCollection) {
            doSetProperty("signalDataCollection", signalDataCollection);
            return this;
        }
        /**
         * List of channels names that are enabled. Source channel is enabled by
         * default.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Default: source
         * Group: oracle
         * 
         * @param signalEnabledChannels the value to set
         * @return the dsl builder
         */
        default DebeziumOracleComponentBuilder signalEnabledChannels(
                java.lang.String signalEnabledChannels) {
            doSetProperty("signalEnabledChannels", signalEnabledChannels);
            return this;
        }
        /**
         * Interval for looking for new signals in registered channels, given in
         * milliseconds. Defaults to 5 seconds.
         * 
         * The option is a: &lt;code&gt;long&lt;/code&gt; type.
         * 
         * Default: 5s
         * Group: oracle
         * 
         * @param signalPollIntervalMs the value to set
         * @return the dsl builder
         */
        default DebeziumOracleComponentBuilder signalPollIntervalMs(
                long signalPollIntervalMs) {
            doSetProperty("signalPollIntervalMs", signalPollIntervalMs);
            return this;
        }
        /**
         * The comma-separated list of operations to skip during streaming,
         * defined as: 'c' for inserts/create; 'u' for updates; 'd' for deletes,
         * 't' for truncates, and 'none' to indicate nothing skipped. By
         * default, only truncate operations will be skipped.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Default: t
         * Group: oracle
         * 
         * @param skippedOperations the value to set
         * @return the dsl builder
         */
        default DebeziumOracleComponentBuilder skippedOperations(
                java.lang.String skippedOperations) {
            doSetProperty("skippedOperations", skippedOperations);
            return this;
        }
        /**
         * A delay period before a snapshot will begin, given in milliseconds.
         * Defaults to 0 ms.
         * 
         * The option is a: &lt;code&gt;long&lt;/code&gt; type.
         * 
         * Default: 0ms
         * Group: oracle
         * 
         * @param snapshotDelayMs the value to set
         * @return the dsl builder
         */
        default DebeziumOracleComponentBuilder snapshotDelayMs(
                long snapshotDelayMs) {
            doSetProperty("snapshotDelayMs", snapshotDelayMs);
            return this;
        }
        /**
         * A token to replace on snapshot predicate template.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: oracle
         * 
         * @param snapshotEnhancePredicateScn the value to set
         * @return the dsl builder
         */
        default DebeziumOracleComponentBuilder snapshotEnhancePredicateScn(
                java.lang.String snapshotEnhancePredicateScn) {
            doSetProperty("snapshotEnhancePredicateScn", snapshotEnhancePredicateScn);
            return this;
        }
        /**
         * The maximum number of records that should be loaded into memory while
         * performing a snapshot.
         * 
         * The option is a: &lt;code&gt;int&lt;/code&gt; type.
         * 
         * Group: oracle
         * 
         * @param snapshotFetchSize the value to set
         * @return the dsl builder
         */
        default DebeziumOracleComponentBuilder snapshotFetchSize(
                int snapshotFetchSize) {
            doSetProperty("snapshotFetchSize", snapshotFetchSize);
            return this;
        }
        /**
         * This setting must be set to specify a list of tables/collections
         * whose snapshot must be taken on creating or restarting the connector.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: oracle
         * 
         * @param snapshotIncludeCollectionList the value to set
         * @return the dsl builder
         */
        default DebeziumOracleComponentBuilder snapshotIncludeCollectionList(
                java.lang.String snapshotIncludeCollectionList) {
            doSetProperty("snapshotIncludeCollectionList", snapshotIncludeCollectionList);
            return this;
        }
        /**
         * Controls how the connector holds locks on tables while performing the
         * schema snapshot. The default is 'shared', which means the connector
         * will hold a table lock that prevents exclusive table access for just
         * the initial portion of the snapshot while the database schemas and
         * other metadata are being read. The remaining work in a snapshot
         * involves selecting all rows from each table, and this is done using a
         * flashback query that requires no locks. However, in some cases it may
         * be desirable to avoid locks entirely which can be done by specifying
         * 'none'. This mode is only safe to use if no schema changes are
         * happening while the snapshot is taken.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Default: shared
         * Group: oracle
         * 
         * @param snapshotLockingMode the value to set
         * @return the dsl builder
         */
        default DebeziumOracleComponentBuilder snapshotLockingMode(
                java.lang.String snapshotLockingMode) {
            doSetProperty("snapshotLockingMode", snapshotLockingMode);
            return this;
        }
        /**
         * The maximum number of millis to wait for table locks at the beginning
         * of a snapshot. If locks cannot be acquired in this time frame, the
         * snapshot will be aborted. Defaults to 10 seconds.
         * 
         * The option is a: &lt;code&gt;long&lt;/code&gt; type.
         * 
         * Default: 10s
         * Group: oracle
         * 
         * @param snapshotLockTimeoutMs the value to set
         * @return the dsl builder
         */
        default DebeziumOracleComponentBuilder snapshotLockTimeoutMs(
                long snapshotLockTimeoutMs) {
            doSetProperty("snapshotLockTimeoutMs", snapshotLockTimeoutMs);
            return this;
        }
        /**
         * The maximum number of threads used to perform the snapshot. Defaults
         * to 1.
         * 
         * The option is a: &lt;code&gt;int&lt;/code&gt; type.
         * 
         * Default: 1
         * Group: oracle
         * 
         * @param snapshotMaxThreads the value to set
         * @return the dsl builder
         */
        default DebeziumOracleComponentBuilder snapshotMaxThreads(
                int snapshotMaxThreads) {
            doSetProperty("snapshotMaxThreads", snapshotMaxThreads);
            return this;
        }
        /**
         * The criteria for running a snapshot upon startup of the connector.
         * Select one of the following snapshot options: 'always': The connector
         * runs a snapshot every time that it starts. After the snapshot
         * completes, the connector begins to stream changes from the redo
         * logs.; 'initial' (default): If the connector does not detect any
         * offsets for the logical server name, it runs a snapshot that captures
         * the current full state of the configured tables. After the snapshot
         * completes, the connector begins to stream changes from the redo logs.
         * 'initial_only': The connector performs a snapshot as it does for the
         * 'initial' option, but after the connector completes the snapshot, it
         * stops, and does not stream changes from the redo logs.;
         * 'schema_only': If the connector does not detect any offsets for the
         * logical server name, it runs a snapshot that captures only the schema
         * (table structures), but not any table data. After the snapshot
         * completes, the connector begins to stream changes from the redo
         * logs.; 'schema_only_recovery': The connector performs a snapshot that
         * captures only the database schema history. The connector then
         * transitions to streaming from the redo logs. Use this setting to
         * restore a corrupted or lost database schema history topic. Do not use
         * if the database schema was modified after the connector stopped.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Default: initial
         * Group: oracle
         * 
         * @param snapshotMode the value to set
         * @return the dsl builder
         */
        default DebeziumOracleComponentBuilder snapshotMode(
                java.lang.String snapshotMode) {
            doSetProperty("snapshotMode", snapshotMode);
            return this;
        }
        /**
         * This property contains a comma-separated list of fully-qualified
         * tables (DB_NAME.TABLE_NAME) or (SCHEMA_NAME.TABLE_NAME), depending on
         * the specific connectors. Select statements for the individual tables
         * are specified in further configuration properties, one for each
         * table, identified by the id
         * 'snapshot.select.statement.overrides.DB_NAME.TABLE_NAME' or
         * 'snapshot.select.statement.overrides.SCHEMA_NAME.TABLE_NAME',
         * respectively. The value of those properties is the select statement
         * to use when retrieving data from the specific table during
         * snapshotting. A possible use case for large append-only tables is
         * setting a specific point where to start (resume) snapshotting, in
         * case a previous snapshotting was interrupted.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: oracle
         * 
         * @param snapshotSelectStatementOverrides the value to set
         * @return the dsl builder
         */
        default DebeziumOracleComponentBuilder snapshotSelectStatementOverrides(
                java.lang.String snapshotSelectStatementOverrides) {
            doSetProperty("snapshotSelectStatementOverrides", snapshotSelectStatementOverrides);
            return this;
        }
        /**
         * Controls the order in which tables are processed in the initial
         * snapshot. A descending value will order the tables by row count
         * descending. A ascending value will order the tables by row count
         * ascending. A value of disabled (the default) will disable ordering by
         * row count.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Default: disabled
         * Group: oracle
         * 
         * @param snapshotTablesOrderByRowCount the value to set
         * @return the dsl builder
         */
        default DebeziumOracleComponentBuilder snapshotTablesOrderByRowCount(
                java.lang.String snapshotTablesOrderByRowCount) {
            doSetProperty("snapshotTablesOrderByRowCount", snapshotTablesOrderByRowCount);
            return this;
        }
        /**
         * The name of the SourceInfoStructMaker class that returns SourceInfo
         * schema and struct.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Default: io.debezium.connector.oracle.OracleSourceInfoStructMaker
         * Group: oracle
         * 
         * @param sourceinfoStructMaker the value to set
         * @return the dsl builder
         */
        default DebeziumOracleComponentBuilder sourceinfoStructMaker(
                java.lang.String sourceinfoStructMaker) {
            doSetProperty("sourceinfoStructMaker", sourceinfoStructMaker);
            return this;
        }
        /**
         * A comma-separated list of regular expressions that match the
         * fully-qualified names of tables to be excluded from monitoring.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: oracle
         * 
         * @param tableExcludeList the value to set
         * @return the dsl builder
         */
        default DebeziumOracleComponentBuilder tableExcludeList(
                java.lang.String tableExcludeList) {
            doSetProperty("tableExcludeList", tableExcludeList);
            return this;
        }
        /**
         * The tables for which changes are to be captured.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: oracle
         * 
         * @param tableIncludeList the value to set
         * @return the dsl builder
         */
        default DebeziumOracleComponentBuilder tableIncludeList(
                java.lang.String tableIncludeList) {
            doSetProperty("tableIncludeList", tableIncludeList);
            return this;
        }
        /**
         * Time, date, and timestamps can be represented with different kinds of
         * precisions, including: 'adaptive' (the default) bases the precision
         * of time, date, and timestamp values on the database column's
         * precision; 'adaptive_time_microseconds' like 'adaptive' mode, but
         * TIME fields always use microseconds precision; 'connect' always
         * represents time, date, and timestamp values using Kafka Connect's
         * built-in representations for Time, Date, and Timestamp, which uses
         * millisecond precision regardless of the database columns' precision.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Default: adaptive
         * Group: oracle
         * 
         * @param timePrecisionMode the value to set
         * @return the dsl builder
         */
        default DebeziumOracleComponentBuilder timePrecisionMode(
                java.lang.String timePrecisionMode) {
            doSetProperty("timePrecisionMode", timePrecisionMode);
            return this;
        }
        /**
         * Whether delete operations should be represented by a delete event and
         * a subsequent tombstone event (true) or only by a delete event
         * (false). Emitting the tombstone event (the default behavior) allows
         * Kafka to completely delete all events pertaining to the given key
         * once the source record got deleted.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: false
         * Group: oracle
         * 
         * @param tombstonesOnDelete the value to set
         * @return the dsl builder
         */
        default DebeziumOracleComponentBuilder tombstonesOnDelete(
                boolean tombstonesOnDelete) {
            doSetProperty("tombstonesOnDelete", tombstonesOnDelete);
            return this;
        }
        /**
         * The name of the TopicNamingStrategy class that should be used to
         * determine the topic name for data change, schema change, transaction,
         * heartbeat event etc.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Default: io.debezium.schema.SchemaTopicNamingStrategy
         * Group: oracle
         * 
         * @param topicNamingStrategy the value to set
         * @return the dsl builder
         */
        default DebeziumOracleComponentBuilder topicNamingStrategy(
                java.lang.String topicNamingStrategy) {
            doSetProperty("topicNamingStrategy", topicNamingStrategy);
            return this;
        }
        /**
         * Topic prefix that identifies and provides a namespace for the
         * particular database server/cluster is capturing changes. The topic
         * prefix should be unique across all other connectors, since it is used
         * as a prefix for all Kafka topic names that receive events emitted by
         * this connector. Only alphanumeric characters, hyphens, dots and
         * underscores must be accepted.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: oracle
         * 
         * @param topicPrefix the value to set
         * @return the dsl builder
         */
        default DebeziumOracleComponentBuilder topicPrefix(
                java.lang.String topicPrefix) {
            doSetProperty("topicPrefix", topicPrefix);
            return this;
        }
        /**
         * Specify the constant that will be provided by Debezium to indicate
         * that the original value is unavailable and not provided by the
         * database.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Default: __debezium_unavailable_value
         * Group: oracle
         * 
         * @param unavailableValuePlaceholder the value to set
         * @return the dsl builder
         */
        default DebeziumOracleComponentBuilder unavailableValuePlaceholder(
                java.lang.String unavailableValuePlaceholder) {
            doSetProperty("unavailableValuePlaceholder", unavailableValuePlaceholder);
            return this;
        }
    }

    class DebeziumOracleComponentBuilderImpl
            extends
                AbstractComponentBuilder<DebeziumOracleComponent>
            implements
                DebeziumOracleComponentBuilder {
        @Override
        protected DebeziumOracleComponent buildConcreteComponent() {
            return new DebeziumOracleComponent();
        }
        private org.apache.camel.component.debezium.configuration.OracleConnectorEmbeddedDebeziumConfiguration getOrCreateConfiguration(
                org.apache.camel.component.debezium.DebeziumOracleComponent component) {
            if (component.getConfiguration() == null) {
                component.setConfiguration(new org.apache.camel.component.debezium.configuration.OracleConnectorEmbeddedDebeziumConfiguration());
            }
            return component.getConfiguration();
        }
        @Override
        protected boolean setPropertyOnComponent(
                Component component,
                String name,
                Object value) {
            switch (name) {
            case "additionalProperties": getOrCreateConfiguration((DebeziumOracleComponent) component).setAdditionalProperties((java.util.Map) value); return true;
            case "bridgeErrorHandler": ((DebeziumOracleComponent) component).setBridgeErrorHandler((boolean) value); return true;
            case "configuration": ((DebeziumOracleComponent) component).setConfiguration((org.apache.camel.component.debezium.configuration.OracleConnectorEmbeddedDebeziumConfiguration) value); return true;
            case "internalKeyConverter": getOrCreateConfiguration((DebeziumOracleComponent) component).setInternalKeyConverter((java.lang.String) value); return true;
            case "internalValueConverter": getOrCreateConfiguration((DebeziumOracleComponent) component).setInternalValueConverter((java.lang.String) value); return true;
            case "offsetCommitPolicy": getOrCreateConfiguration((DebeziumOracleComponent) component).setOffsetCommitPolicy((java.lang.String) value); return true;
            case "offsetCommitTimeoutMs": getOrCreateConfiguration((DebeziumOracleComponent) component).setOffsetCommitTimeoutMs((long) value); return true;
            case "offsetFlushIntervalMs": getOrCreateConfiguration((DebeziumOracleComponent) component).setOffsetFlushIntervalMs((long) value); return true;
            case "offsetStorage": getOrCreateConfiguration((DebeziumOracleComponent) component).setOffsetStorage((java.lang.String) value); return true;
            case "offsetStorageFileName": getOrCreateConfiguration((DebeziumOracleComponent) component).setOffsetStorageFileName((java.lang.String) value); return true;
            case "offsetStoragePartitions": getOrCreateConfiguration((DebeziumOracleComponent) component).setOffsetStoragePartitions((int) value); return true;
            case "offsetStorageReplicationFactor": getOrCreateConfiguration((DebeziumOracleComponent) component).setOffsetStorageReplicationFactor((int) value); return true;
            case "offsetStorageTopic": getOrCreateConfiguration((DebeziumOracleComponent) component).setOffsetStorageTopic((java.lang.String) value); return true;
            case "autowiredEnabled": ((DebeziumOracleComponent) component).setAutowiredEnabled((boolean) value); return true;
            case "binaryHandlingMode": getOrCreateConfiguration((DebeziumOracleComponent) component).setBinaryHandlingMode((java.lang.String) value); return true;
            case "columnExcludeList": getOrCreateConfiguration((DebeziumOracleComponent) component).setColumnExcludeList((java.lang.String) value); return true;
            case "columnIncludeList": getOrCreateConfiguration((DebeziumOracleComponent) component).setColumnIncludeList((java.lang.String) value); return true;
            case "columnPropagateSourceType": getOrCreateConfiguration((DebeziumOracleComponent) component).setColumnPropagateSourceType((java.lang.String) value); return true;
            case "converters": getOrCreateConfiguration((DebeziumOracleComponent) component).setConverters((java.lang.String) value); return true;
            case "customMetricTags": getOrCreateConfiguration((DebeziumOracleComponent) component).setCustomMetricTags((java.lang.String) value); return true;
            case "databaseConnectionAdapter": getOrCreateConfiguration((DebeziumOracleComponent) component).setDatabaseConnectionAdapter((java.lang.String) value); return true;
            case "databaseDbname": getOrCreateConfiguration((DebeziumOracleComponent) component).setDatabaseDbname((java.lang.String) value); return true;
            case "databaseHostname": getOrCreateConfiguration((DebeziumOracleComponent) component).setDatabaseHostname((java.lang.String) value); return true;
            case "databaseOutServerName": getOrCreateConfiguration((DebeziumOracleComponent) component).setDatabaseOutServerName((java.lang.String) value); return true;
            case "databasePassword": getOrCreateConfiguration((DebeziumOracleComponent) component).setDatabasePassword((java.lang.String) value); return true;
            case "databasePdbName": getOrCreateConfiguration((DebeziumOracleComponent) component).setDatabasePdbName((java.lang.String) value); return true;
            case "databasePort": getOrCreateConfiguration((DebeziumOracleComponent) component).setDatabasePort((int) value); return true;
            case "databaseUrl": getOrCreateConfiguration((DebeziumOracleComponent) component).setDatabaseUrl((java.lang.String) value); return true;
            case "databaseUser": getOrCreateConfiguration((DebeziumOracleComponent) component).setDatabaseUser((java.lang.String) value); return true;
            case "datatypePropagateSourceType": getOrCreateConfiguration((DebeziumOracleComponent) component).setDatatypePropagateSourceType((java.lang.String) value); return true;
            case "decimalHandlingMode": getOrCreateConfiguration((DebeziumOracleComponent) component).setDecimalHandlingMode((java.lang.String) value); return true;
            case "errorsMaxRetries": getOrCreateConfiguration((DebeziumOracleComponent) component).setErrorsMaxRetries((int) value); return true;
            case "eventProcessingFailureHandlingMode": getOrCreateConfiguration((DebeziumOracleComponent) component).setEventProcessingFailureHandlingMode((java.lang.String) value); return true;
            case "heartbeatActionQuery": getOrCreateConfiguration((DebeziumOracleComponent) component).setHeartbeatActionQuery((java.lang.String) value); return true;
            case "heartbeatIntervalMs": getOrCreateConfiguration((DebeziumOracleComponent) component).setHeartbeatIntervalMs((int) value); return true;
            case "heartbeatTopicsPrefix": getOrCreateConfiguration((DebeziumOracleComponent) component).setHeartbeatTopicsPrefix((java.lang.String) value); return true;
            case "includeSchemaChanges": getOrCreateConfiguration((DebeziumOracleComponent) component).setIncludeSchemaChanges((boolean) value); return true;
            case "includeSchemaComments": getOrCreateConfiguration((DebeziumOracleComponent) component).setIncludeSchemaComments((boolean) value); return true;
            case "intervalHandlingMode": getOrCreateConfiguration((DebeziumOracleComponent) component).setIntervalHandlingMode((java.lang.String) value); return true;
            case "lobEnabled": getOrCreateConfiguration((DebeziumOracleComponent) component).setLobEnabled((boolean) value); return true;
            case "logMiningArchiveDestinationName": getOrCreateConfiguration((DebeziumOracleComponent) component).setLogMiningArchiveDestinationName((java.lang.String) value); return true;
            case "logMiningArchiveLogHours": getOrCreateConfiguration((DebeziumOracleComponent) component).setLogMiningArchiveLogHours((long) value); return true;
            case "logMiningArchiveLogOnlyMode": getOrCreateConfiguration((DebeziumOracleComponent) component).setLogMiningArchiveLogOnlyMode((boolean) value); return true;
            case "logMiningArchiveLogOnlyScnPollIntervalMs": getOrCreateConfiguration((DebeziumOracleComponent) component).setLogMiningArchiveLogOnlyScnPollIntervalMs((long) value); return true;
            case "logMiningBatchSizeDefault": getOrCreateConfiguration((DebeziumOracleComponent) component).setLogMiningBatchSizeDefault((long) value); return true;
            case "logMiningBatchSizeMax": getOrCreateConfiguration((DebeziumOracleComponent) component).setLogMiningBatchSizeMax((long) value); return true;
            case "logMiningBatchSizeMin": getOrCreateConfiguration((DebeziumOracleComponent) component).setLogMiningBatchSizeMin((long) value); return true;
            case "logMiningBufferDropOnStop": getOrCreateConfiguration((DebeziumOracleComponent) component).setLogMiningBufferDropOnStop((boolean) value); return true;
            case "logMiningBufferInfinispanCacheEvents": getOrCreateConfiguration((DebeziumOracleComponent) component).setLogMiningBufferInfinispanCacheEvents((java.lang.String) value); return true;
            case "logMiningBufferInfinispanCacheGlobal": getOrCreateConfiguration((DebeziumOracleComponent) component).setLogMiningBufferInfinispanCacheGlobal((java.lang.String) value); return true;
            case "logMiningBufferInfinispanCacheProcessedTransactions": getOrCreateConfiguration((DebeziumOracleComponent) component).setLogMiningBufferInfinispanCacheProcessedTransactions((java.lang.String) value); return true;
            case "logMiningBufferInfinispanCacheSchemaChanges": getOrCreateConfiguration((DebeziumOracleComponent) component).setLogMiningBufferInfinispanCacheSchemaChanges((java.lang.String) value); return true;
            case "logMiningBufferInfinispanCacheTransactions": getOrCreateConfiguration((DebeziumOracleComponent) component).setLogMiningBufferInfinispanCacheTransactions((java.lang.String) value); return true;
            case "logMiningBufferTransactionEventsThreshold": getOrCreateConfiguration((DebeziumOracleComponent) component).setLogMiningBufferTransactionEventsThreshold((long) value); return true;
            case "logMiningBufferType": getOrCreateConfiguration((DebeziumOracleComponent) component).setLogMiningBufferType((java.lang.String) value); return true;
            case "logMiningFlushTableName": getOrCreateConfiguration((DebeziumOracleComponent) component).setLogMiningFlushTableName((java.lang.String) value); return true;
            case "logMiningQueryFilterMode": getOrCreateConfiguration((DebeziumOracleComponent) component).setLogMiningQueryFilterMode((java.lang.String) value); return true;
            case "logMiningRestartConnection": getOrCreateConfiguration((DebeziumOracleComponent) component).setLogMiningRestartConnection((boolean) value); return true;
            case "logMiningScnGapDetectionGapSizeMin": getOrCreateConfiguration((DebeziumOracleComponent) component).setLogMiningScnGapDetectionGapSizeMin((long) value); return true;
            case "logMiningScnGapDetectionTimeIntervalMaxMs": getOrCreateConfiguration((DebeziumOracleComponent) component).setLogMiningScnGapDetectionTimeIntervalMaxMs((long) value); return true;
            case "logMiningSessionMaxMs": getOrCreateConfiguration((DebeziumOracleComponent) component).setLogMiningSessionMaxMs((long) value); return true;
            case "logMiningSleepTimeDefaultMs": getOrCreateConfiguration((DebeziumOracleComponent) component).setLogMiningSleepTimeDefaultMs((long) value); return true;
            case "logMiningSleepTimeIncrementMs": getOrCreateConfiguration((DebeziumOracleComponent) component).setLogMiningSleepTimeIncrementMs((long) value); return true;
            case "logMiningSleepTimeMaxMs": getOrCreateConfiguration((DebeziumOracleComponent) component).setLogMiningSleepTimeMaxMs((long) value); return true;
            case "logMiningSleepTimeMinMs": getOrCreateConfiguration((DebeziumOracleComponent) component).setLogMiningSleepTimeMinMs((long) value); return true;
            case "logMiningStrategy": getOrCreateConfiguration((DebeziumOracleComponent) component).setLogMiningStrategy((java.lang.String) value); return true;
            case "logMiningTransactionRetentionMs": getOrCreateConfiguration((DebeziumOracleComponent) component).setLogMiningTransactionRetentionMs((long) value); return true;
            case "logMiningUsernameExcludeList": getOrCreateConfiguration((DebeziumOracleComponent) component).setLogMiningUsernameExcludeList((java.lang.String) value); return true;
            case "logMiningUsernameIncludeList": getOrCreateConfiguration((DebeziumOracleComponent) component).setLogMiningUsernameIncludeList((java.lang.String) value); return true;
            case "maxBatchSize": getOrCreateConfiguration((DebeziumOracleComponent) component).setMaxBatchSize((int) value); return true;
            case "maxQueueSize": getOrCreateConfiguration((DebeziumOracleComponent) component).setMaxQueueSize((int) value); return true;
            case "maxQueueSizeInBytes": getOrCreateConfiguration((DebeziumOracleComponent) component).setMaxQueueSizeInBytes((long) value); return true;
            case "messageKeyColumns": getOrCreateConfiguration((DebeziumOracleComponent) component).setMessageKeyColumns((java.lang.String) value); return true;
            case "notificationEnabledChannels": getOrCreateConfiguration((DebeziumOracleComponent) component).setNotificationEnabledChannels((java.lang.String) value); return true;
            case "notificationSinkTopicName": getOrCreateConfiguration((DebeziumOracleComponent) component).setNotificationSinkTopicName((java.lang.String) value); return true;
            case "openlogreplicatorHost": getOrCreateConfiguration((DebeziumOracleComponent) component).setOpenlogreplicatorHost((java.lang.String) value); return true;
            case "openlogreplicatorPort": getOrCreateConfiguration((DebeziumOracleComponent) component).setOpenlogreplicatorPort((int) value); return true;
            case "openlogreplicatorSource": getOrCreateConfiguration((DebeziumOracleComponent) component).setOpenlogreplicatorSource((java.lang.String) value); return true;
            case "pollIntervalMs": getOrCreateConfiguration((DebeziumOracleComponent) component).setPollIntervalMs((long) value); return true;
            case "provideTransactionMetadata": getOrCreateConfiguration((DebeziumOracleComponent) component).setProvideTransactionMetadata((boolean) value); return true;
            case "queryFetchSize": getOrCreateConfiguration((DebeziumOracleComponent) component).setQueryFetchSize((int) value); return true;
            case "racNodes": getOrCreateConfiguration((DebeziumOracleComponent) component).setRacNodes((java.lang.String) value); return true;
            case "retriableRestartConnectorWaitMs": getOrCreateConfiguration((DebeziumOracleComponent) component).setRetriableRestartConnectorWaitMs((long) value); return true;
            case "schemaHistoryInternal": getOrCreateConfiguration((DebeziumOracleComponent) component).setSchemaHistoryInternal((java.lang.String) value); return true;
            case "schemaHistoryInternalFileFilename": getOrCreateConfiguration((DebeziumOracleComponent) component).setSchemaHistoryInternalFileFilename((java.lang.String) value); return true;
            case "schemaHistoryInternalSkipUnparseableDdl": getOrCreateConfiguration((DebeziumOracleComponent) component).setSchemaHistoryInternalSkipUnparseableDdl((boolean) value); return true;
            case "schemaHistoryInternalStoreOnlyCapturedDatabasesDdl": getOrCreateConfiguration((DebeziumOracleComponent) component).setSchemaHistoryInternalStoreOnlyCapturedDatabasesDdl((boolean) value); return true;
            case "schemaHistoryInternalStoreOnlyCapturedTablesDdl": getOrCreateConfiguration((DebeziumOracleComponent) component).setSchemaHistoryInternalStoreOnlyCapturedTablesDdl((boolean) value); return true;
            case "schemaNameAdjustmentMode": getOrCreateConfiguration((DebeziumOracleComponent) component).setSchemaNameAdjustmentMode((java.lang.String) value); return true;
            case "signalDataCollection": getOrCreateConfiguration((DebeziumOracleComponent) component).setSignalDataCollection((java.lang.String) value); return true;
            case "signalEnabledChannels": getOrCreateConfiguration((DebeziumOracleComponent) component).setSignalEnabledChannels((java.lang.String) value); return true;
            case "signalPollIntervalMs": getOrCreateConfiguration((DebeziumOracleComponent) component).setSignalPollIntervalMs((long) value); return true;
            case "skippedOperations": getOrCreateConfiguration((DebeziumOracleComponent) component).setSkippedOperations((java.lang.String) value); return true;
            case "snapshotDelayMs": getOrCreateConfiguration((DebeziumOracleComponent) component).setSnapshotDelayMs((long) value); return true;
            case "snapshotEnhancePredicateScn": getOrCreateConfiguration((DebeziumOracleComponent) component).setSnapshotEnhancePredicateScn((java.lang.String) value); return true;
            case "snapshotFetchSize": getOrCreateConfiguration((DebeziumOracleComponent) component).setSnapshotFetchSize((int) value); return true;
            case "snapshotIncludeCollectionList": getOrCreateConfiguration((DebeziumOracleComponent) component).setSnapshotIncludeCollectionList((java.lang.String) value); return true;
            case "snapshotLockingMode": getOrCreateConfiguration((DebeziumOracleComponent) component).setSnapshotLockingMode((java.lang.String) value); return true;
            case "snapshotLockTimeoutMs": getOrCreateConfiguration((DebeziumOracleComponent) component).setSnapshotLockTimeoutMs((long) value); return true;
            case "snapshotMaxThreads": getOrCreateConfiguration((DebeziumOracleComponent) component).setSnapshotMaxThreads((int) value); return true;
            case "snapshotMode": getOrCreateConfiguration((DebeziumOracleComponent) component).setSnapshotMode((java.lang.String) value); return true;
            case "snapshotSelectStatementOverrides": getOrCreateConfiguration((DebeziumOracleComponent) component).setSnapshotSelectStatementOverrides((java.lang.String) value); return true;
            case "snapshotTablesOrderByRowCount": getOrCreateConfiguration((DebeziumOracleComponent) component).setSnapshotTablesOrderByRowCount((java.lang.String) value); return true;
            case "sourceinfoStructMaker": getOrCreateConfiguration((DebeziumOracleComponent) component).setSourceinfoStructMaker((java.lang.String) value); return true;
            case "tableExcludeList": getOrCreateConfiguration((DebeziumOracleComponent) component).setTableExcludeList((java.lang.String) value); return true;
            case "tableIncludeList": getOrCreateConfiguration((DebeziumOracleComponent) component).setTableIncludeList((java.lang.String) value); return true;
            case "timePrecisionMode": getOrCreateConfiguration((DebeziumOracleComponent) component).setTimePrecisionMode((java.lang.String) value); return true;
            case "tombstonesOnDelete": getOrCreateConfiguration((DebeziumOracleComponent) component).setTombstonesOnDelete((boolean) value); return true;
            case "topicNamingStrategy": getOrCreateConfiguration((DebeziumOracleComponent) component).setTopicNamingStrategy((java.lang.String) value); return true;
            case "topicPrefix": getOrCreateConfiguration((DebeziumOracleComponent) component).setTopicPrefix((java.lang.String) value); return true;
            case "unavailableValuePlaceholder": getOrCreateConfiguration((DebeziumOracleComponent) component).setUnavailableValuePlaceholder((java.lang.String) value); return true;
            default: return false;
            }
        }
    }
}