/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.apache.camel.builder.endpoint.dsl;

import java.util.*;
import java.util.Map;
import java.util.concurrent.*;
import java.util.function.*;
import java.util.stream.*;
import javax.annotation.processing.Generated;
import org.apache.camel.builder.EndpointConsumerBuilder;
import org.apache.camel.builder.EndpointProducerBuilder;
import org.apache.camel.builder.endpoint.AbstractEndpointBuilder;

/**
 * Read and write from/to an HDFS filesystem using Hadoop 2.x.
 * 
 * Generated by camel build tools - do NOT edit this file!
 */
@Generated("org.apache.camel.maven.packaging.EndpointDslMojo")
public interface HdfsEndpointBuilderFactory {


    /**
     * Builder for endpoint consumers for the HDFS component.
     */
    public interface HdfsEndpointConsumerBuilder
            extends
                EndpointConsumerBuilder {
        default AdvancedHdfsEndpointConsumerBuilder advanced() {
            return (AdvancedHdfsEndpointConsumerBuilder) this;
        }
        /**
         * Whether to connect to the HDFS file system on starting the
         * producer/consumer. If false then the connection is created on-demand.
         * Notice that HDFS may take up till 15 minutes to establish a
         * connection, as it has hardcoded 45 x 20 sec redelivery. By setting
         * this option to false allows your application to startup, and not
         * block for up till 15 minutes.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: true
         * Group: common
         * 
         * @param connectOnStartup the value to set
         * @return the dsl builder
         */
        default HdfsEndpointConsumerBuilder connectOnStartup(
                boolean connectOnStartup) {
            doSetProperty("connectOnStartup", connectOnStartup);
            return this;
        }
        /**
         * Whether to connect to the HDFS file system on starting the
         * producer/consumer. If false then the connection is created on-demand.
         * Notice that HDFS may take up till 15 minutes to establish a
         * connection, as it has hardcoded 45 x 20 sec redelivery. By setting
         * this option to false allows your application to startup, and not
         * block for up till 15 minutes.
         * 
         * The option will be converted to a &lt;code&gt;boolean&lt;/code&gt;
         * type.
         * 
         * Default: true
         * Group: common
         * 
         * @param connectOnStartup the value to set
         * @return the dsl builder
         */
        default HdfsEndpointConsumerBuilder connectOnStartup(
                String connectOnStartup) {
            doSetProperty("connectOnStartup", connectOnStartup);
            return this;
        }
        /**
         * Set to LOCAL to not use HDFS but local java.io.File instead.
         * 
         * The option is a:
         * &lt;code&gt;org.apache.camel.component.hdfs.HdfsFileSystemType&lt;/code&gt; type.
         * 
         * Default: HDFS
         * Group: common
         * 
         * @param fileSystemType the value to set
         * @return the dsl builder
         */
        default HdfsEndpointConsumerBuilder fileSystemType(
                org.apache.camel.component.hdfs.HdfsFileSystemType fileSystemType) {
            doSetProperty("fileSystemType", fileSystemType);
            return this;
        }
        /**
         * Set to LOCAL to not use HDFS but local java.io.File instead.
         * 
         * The option will be converted to a
         * &lt;code&gt;org.apache.camel.component.hdfs.HdfsFileSystemType&lt;/code&gt; type.
         * 
         * Default: HDFS
         * Group: common
         * 
         * @param fileSystemType the value to set
         * @return the dsl builder
         */
        default HdfsEndpointConsumerBuilder fileSystemType(String fileSystemType) {
            doSetProperty("fileSystemType", fileSystemType);
            return this;
        }
        /**
         * The file type to use. For more details see Hadoop HDFS documentation
         * about the various files types.
         * 
         * The option is a:
         * &lt;code&gt;org.apache.camel.component.hdfs.HdfsFileType&lt;/code&gt;
         * type.
         * 
         * Default: NORMAL_FILE
         * Group: common
         * 
         * @param fileType the value to set
         * @return the dsl builder
         */
        default HdfsEndpointConsumerBuilder fileType(
                org.apache.camel.component.hdfs.HdfsFileType fileType) {
            doSetProperty("fileType", fileType);
            return this;
        }
        /**
         * The file type to use. For more details see Hadoop HDFS documentation
         * about the various files types.
         * 
         * The option will be converted to a
         * &lt;code&gt;org.apache.camel.component.hdfs.HdfsFileType&lt;/code&gt;
         * type.
         * 
         * Default: NORMAL_FILE
         * Group: common
         * 
         * @param fileType the value to set
         * @return the dsl builder
         */
        default HdfsEndpointConsumerBuilder fileType(String fileType) {
            doSetProperty("fileType", fileType);
            return this;
        }
        /**
         * The type for the key in case of sequence or map files.
         * 
         * The option is a:
         * &lt;code&gt;org.apache.camel.component.hdfs.WritableType&lt;/code&gt;
         * type.
         * 
         * Default: NULL
         * Group: common
         * 
         * @param keyType the value to set
         * @return the dsl builder
         */
        default HdfsEndpointConsumerBuilder keyType(
                org.apache.camel.component.hdfs.WritableType keyType) {
            doSetProperty("keyType", keyType);
            return this;
        }
        /**
         * The type for the key in case of sequence or map files.
         * 
         * The option will be converted to a
         * &lt;code&gt;org.apache.camel.component.hdfs.WritableType&lt;/code&gt;
         * type.
         * 
         * Default: NULL
         * Group: common
         * 
         * @param keyType the value to set
         * @return the dsl builder
         */
        default HdfsEndpointConsumerBuilder keyType(String keyType) {
            doSetProperty("keyType", keyType);
            return this;
        }
        /**
         * A comma separated list of named nodes (e.g.
         * srv11.example.com:8020,srv12.example.com:8020).
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param namedNodes the value to set
         * @return the dsl builder
         */
        default HdfsEndpointConsumerBuilder namedNodes(String namedNodes) {
            doSetProperty("namedNodes", namedNodes);
            return this;
        }
        /**
         * The file owner must match this owner for the consumer to pickup the
         * file. Otherwise the file is skipped.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param owner the value to set
         * @return the dsl builder
         */
        default HdfsEndpointConsumerBuilder owner(String owner) {
            doSetProperty("owner", owner);
            return this;
        }
        /**
         * The type for the key in case of sequence or map files.
         * 
         * The option is a:
         * &lt;code&gt;org.apache.camel.component.hdfs.WritableType&lt;/code&gt;
         * type.
         * 
         * Default: BYTES
         * Group: common
         * 
         * @param valueType the value to set
         * @return the dsl builder
         */
        default HdfsEndpointConsumerBuilder valueType(
                org.apache.camel.component.hdfs.WritableType valueType) {
            doSetProperty("valueType", valueType);
            return this;
        }
        /**
         * The type for the key in case of sequence or map files.
         * 
         * The option will be converted to a
         * &lt;code&gt;org.apache.camel.component.hdfs.WritableType&lt;/code&gt;
         * type.
         * 
         * Default: BYTES
         * Group: common
         * 
         * @param valueType the value to set
         * @return the dsl builder
         */
        default HdfsEndpointConsumerBuilder valueType(String valueType) {
            doSetProperty("valueType", valueType);
            return this;
        }
        /**
         * The pattern used for scanning the directory.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Default: *
         * Group: consumer
         * 
         * @param pattern the value to set
         * @return the dsl builder
         */
        default HdfsEndpointConsumerBuilder pattern(String pattern) {
            doSetProperty("pattern", pattern);
            return this;
        }
        /**
         * If the polling consumer did not poll any files, you can enable this
         * option to send an empty message (no body) instead.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: false
         * Group: consumer
         * 
         * @param sendEmptyMessageWhenIdle the value to set
         * @return the dsl builder
         */
        default HdfsEndpointConsumerBuilder sendEmptyMessageWhenIdle(
                boolean sendEmptyMessageWhenIdle) {
            doSetProperty("sendEmptyMessageWhenIdle", sendEmptyMessageWhenIdle);
            return this;
        }
        /**
         * If the polling consumer did not poll any files, you can enable this
         * option to send an empty message (no body) instead.
         * 
         * The option will be converted to a &lt;code&gt;boolean&lt;/code&gt;
         * type.
         * 
         * Default: false
         * Group: consumer
         * 
         * @param sendEmptyMessageWhenIdle the value to set
         * @return the dsl builder
         */
        default HdfsEndpointConsumerBuilder sendEmptyMessageWhenIdle(
                String sendEmptyMessageWhenIdle) {
            doSetProperty("sendEmptyMessageWhenIdle", sendEmptyMessageWhenIdle);
            return this;
        }
        /**
         * Sets the download method to use when not using a local working
         * directory. If set to true, the remote files are streamed to the route
         * as they are read. When set to false, the remote files are loaded into
         * memory before being sent into the route.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: false
         * Group: consumer
         * 
         * @param streamDownload the value to set
         * @return the dsl builder
         */
        default HdfsEndpointConsumerBuilder streamDownload(
                boolean streamDownload) {
            doSetProperty("streamDownload", streamDownload);
            return this;
        }
        /**
         * Sets the download method to use when not using a local working
         * directory. If set to true, the remote files are streamed to the route
         * as they are read. When set to false, the remote files are loaded into
         * memory before being sent into the route.
         * 
         * The option will be converted to a &lt;code&gt;boolean&lt;/code&gt;
         * type.
         * 
         * Default: false
         * Group: consumer
         * 
         * @param streamDownload the value to set
         * @return the dsl builder
         */
        default HdfsEndpointConsumerBuilder streamDownload(String streamDownload) {
            doSetProperty("streamDownload", streamDownload);
            return this;
        }
        /**
         * To define a maximum messages to gather per poll. By default a limit
         * of 100 is set. Can be used to set a limit of e.g. 1000 to avoid when
         * starting up the server that there are thousands of files. Values can
         * only be greater than 0. Notice: If this option is in use then the
         * limit will be applied on the valid files. For example if you have
         * 100000 files and use maxMessagesPerPoll=500, then only the first 500
         * files will be picked up.
         * 
         * The option is a: &lt;code&gt;int&lt;/code&gt; type.
         * 
         * Default: 100
         * Group: filter
         * 
         * @param maxMessagesPerPoll the value to set
         * @return the dsl builder
         */
        default HdfsEndpointConsumerBuilder maxMessagesPerPoll(
                int maxMessagesPerPoll) {
            doSetProperty("maxMessagesPerPoll", maxMessagesPerPoll);
            return this;
        }
        /**
         * To define a maximum messages to gather per poll. By default a limit
         * of 100 is set. Can be used to set a limit of e.g. 1000 to avoid when
         * starting up the server that there are thousands of files. Values can
         * only be greater than 0. Notice: If this option is in use then the
         * limit will be applied on the valid files. For example if you have
         * 100000 files and use maxMessagesPerPoll=500, then only the first 500
         * files will be picked up.
         * 
         * The option will be converted to a &lt;code&gt;int&lt;/code&gt; type.
         * 
         * Default: 100
         * Group: filter
         * 
         * @param maxMessagesPerPoll the value to set
         * @return the dsl builder
         */
        default HdfsEndpointConsumerBuilder maxMessagesPerPoll(
                String maxMessagesPerPoll) {
            doSetProperty("maxMessagesPerPoll", maxMessagesPerPoll);
            return this;
        }
        /**
         * The number of subsequent error polls (failed due some error) that
         * should happen before the backoffMultipler should kick-in.
         * 
         * The option is a: &lt;code&gt;int&lt;/code&gt; type.
         * 
         * Group: scheduler
         * 
         * @param backoffErrorThreshold the value to set
         * @return the dsl builder
         */
        default HdfsEndpointConsumerBuilder backoffErrorThreshold(
                int backoffErrorThreshold) {
            doSetProperty("backoffErrorThreshold", backoffErrorThreshold);
            return this;
        }
        /**
         * The number of subsequent error polls (failed due some error) that
         * should happen before the backoffMultipler should kick-in.
         * 
         * The option will be converted to a &lt;code&gt;int&lt;/code&gt; type.
         * 
         * Group: scheduler
         * 
         * @param backoffErrorThreshold the value to set
         * @return the dsl builder
         */
        default HdfsEndpointConsumerBuilder backoffErrorThreshold(
                String backoffErrorThreshold) {
            doSetProperty("backoffErrorThreshold", backoffErrorThreshold);
            return this;
        }
        /**
         * The number of subsequent idle polls that should happen before the
         * backoffMultipler should kick-in.
         * 
         * The option is a: &lt;code&gt;int&lt;/code&gt; type.
         * 
         * Group: scheduler
         * 
         * @param backoffIdleThreshold the value to set
         * @return the dsl builder
         */
        default HdfsEndpointConsumerBuilder backoffIdleThreshold(
                int backoffIdleThreshold) {
            doSetProperty("backoffIdleThreshold", backoffIdleThreshold);
            return this;
        }
        /**
         * The number of subsequent idle polls that should happen before the
         * backoffMultipler should kick-in.
         * 
         * The option will be converted to a &lt;code&gt;int&lt;/code&gt; type.
         * 
         * Group: scheduler
         * 
         * @param backoffIdleThreshold the value to set
         * @return the dsl builder
         */
        default HdfsEndpointConsumerBuilder backoffIdleThreshold(
                String backoffIdleThreshold) {
            doSetProperty("backoffIdleThreshold", backoffIdleThreshold);
            return this;
        }
        /**
         * To let the scheduled polling consumer backoff if there has been a
         * number of subsequent idles/errors in a row. The multiplier is then
         * the number of polls that will be skipped before the next actual
         * attempt is happening again. When this option is in use then
         * backoffIdleThreshold and/or backoffErrorThreshold must also be
         * configured.
         * 
         * The option is a: &lt;code&gt;int&lt;/code&gt; type.
         * 
         * Group: scheduler
         * 
         * @param backoffMultiplier the value to set
         * @return the dsl builder
         */
        default HdfsEndpointConsumerBuilder backoffMultiplier(
                int backoffMultiplier) {
            doSetProperty("backoffMultiplier", backoffMultiplier);
            return this;
        }
        /**
         * To let the scheduled polling consumer backoff if there has been a
         * number of subsequent idles/errors in a row. The multiplier is then
         * the number of polls that will be skipped before the next actual
         * attempt is happening again. When this option is in use then
         * backoffIdleThreshold and/or backoffErrorThreshold must also be
         * configured.
         * 
         * The option will be converted to a &lt;code&gt;int&lt;/code&gt; type.
         * 
         * Group: scheduler
         * 
         * @param backoffMultiplier the value to set
         * @return the dsl builder
         */
        default HdfsEndpointConsumerBuilder backoffMultiplier(
                String backoffMultiplier) {
            doSetProperty("backoffMultiplier", backoffMultiplier);
            return this;
        }
        /**
         * Milliseconds before the next poll.
         * 
         * The option is a: &lt;code&gt;long&lt;/code&gt; type.
         * 
         * Default: 500
         * Group: scheduler
         * 
         * @param delay the value to set
         * @return the dsl builder
         */
        default HdfsEndpointConsumerBuilder delay(long delay) {
            doSetProperty("delay", delay);
            return this;
        }
        /**
         * Milliseconds before the next poll.
         * 
         * The option will be converted to a &lt;code&gt;long&lt;/code&gt; type.
         * 
         * Default: 500
         * Group: scheduler
         * 
         * @param delay the value to set
         * @return the dsl builder
         */
        default HdfsEndpointConsumerBuilder delay(String delay) {
            doSetProperty("delay", delay);
            return this;
        }
        /**
         * If greedy is enabled, then the ScheduledPollConsumer will run
         * immediately again, if the previous run polled 1 or more messages.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: false
         * Group: scheduler
         * 
         * @param greedy the value to set
         * @return the dsl builder
         */
        default HdfsEndpointConsumerBuilder greedy(boolean greedy) {
            doSetProperty("greedy", greedy);
            return this;
        }
        /**
         * If greedy is enabled, then the ScheduledPollConsumer will run
         * immediately again, if the previous run polled 1 or more messages.
         * 
         * The option will be converted to a &lt;code&gt;boolean&lt;/code&gt;
         * type.
         * 
         * Default: false
         * Group: scheduler
         * 
         * @param greedy the value to set
         * @return the dsl builder
         */
        default HdfsEndpointConsumerBuilder greedy(String greedy) {
            doSetProperty("greedy", greedy);
            return this;
        }
        /**
         * Milliseconds before the first poll starts.
         * 
         * The option is a: &lt;code&gt;long&lt;/code&gt; type.
         * 
         * Default: 1000
         * Group: scheduler
         * 
         * @param initialDelay the value to set
         * @return the dsl builder
         */
        default HdfsEndpointConsumerBuilder initialDelay(long initialDelay) {
            doSetProperty("initialDelay", initialDelay);
            return this;
        }
        /**
         * Milliseconds before the first poll starts.
         * 
         * The option will be converted to a &lt;code&gt;long&lt;/code&gt; type.
         * 
         * Default: 1000
         * Group: scheduler
         * 
         * @param initialDelay the value to set
         * @return the dsl builder
         */
        default HdfsEndpointConsumerBuilder initialDelay(String initialDelay) {
            doSetProperty("initialDelay", initialDelay);
            return this;
        }
        /**
         * Specifies a maximum limit of number of fires. So if you set it to 1,
         * the scheduler will only fire once. If you set it to 5, it will only
         * fire five times. A value of zero or negative means fire forever.
         * 
         * The option is a: &lt;code&gt;long&lt;/code&gt; type.
         * 
         * Default: 0
         * Group: scheduler
         * 
         * @param repeatCount the value to set
         * @return the dsl builder
         */
        default HdfsEndpointConsumerBuilder repeatCount(long repeatCount) {
            doSetProperty("repeatCount", repeatCount);
            return this;
        }
        /**
         * Specifies a maximum limit of number of fires. So if you set it to 1,
         * the scheduler will only fire once. If you set it to 5, it will only
         * fire five times. A value of zero or negative means fire forever.
         * 
         * The option will be converted to a &lt;code&gt;long&lt;/code&gt; type.
         * 
         * Default: 0
         * Group: scheduler
         * 
         * @param repeatCount the value to set
         * @return the dsl builder
         */
        default HdfsEndpointConsumerBuilder repeatCount(String repeatCount) {
            doSetProperty("repeatCount", repeatCount);
            return this;
        }
        /**
         * The consumer logs a start/complete log line when it polls. This
         * option allows you to configure the logging level for that.
         * 
         * The option is a:
         * &lt;code&gt;org.apache.camel.LoggingLevel&lt;/code&gt; type.
         * 
         * Default: TRACE
         * Group: scheduler
         * 
         * @param runLoggingLevel the value to set
         * @return the dsl builder
         */
        default HdfsEndpointConsumerBuilder runLoggingLevel(
                org.apache.camel.LoggingLevel runLoggingLevel) {
            doSetProperty("runLoggingLevel", runLoggingLevel);
            return this;
        }
        /**
         * The consumer logs a start/complete log line when it polls. This
         * option allows you to configure the logging level for that.
         * 
         * The option will be converted to a
         * &lt;code&gt;org.apache.camel.LoggingLevel&lt;/code&gt; type.
         * 
         * Default: TRACE
         * Group: scheduler
         * 
         * @param runLoggingLevel the value to set
         * @return the dsl builder
         */
        default HdfsEndpointConsumerBuilder runLoggingLevel(
                String runLoggingLevel) {
            doSetProperty("runLoggingLevel", runLoggingLevel);
            return this;
        }
        /**
         * Allows for configuring a custom/shared thread pool to use for the
         * consumer. By default each consumer has its own single threaded thread
         * pool.
         * 
         * The option is a:
         * &lt;code&gt;java.util.concurrent.ScheduledExecutorService&lt;/code&gt; type.
         * 
         * Group: scheduler
         * 
         * @param scheduledExecutorService the value to set
         * @return the dsl builder
         */
        default HdfsEndpointConsumerBuilder scheduledExecutorService(
                ScheduledExecutorService scheduledExecutorService) {
            doSetProperty("scheduledExecutorService", scheduledExecutorService);
            return this;
        }
        /**
         * Allows for configuring a custom/shared thread pool to use for the
         * consumer. By default each consumer has its own single threaded thread
         * pool.
         * 
         * The option will be converted to a
         * &lt;code&gt;java.util.concurrent.ScheduledExecutorService&lt;/code&gt; type.
         * 
         * Group: scheduler
         * 
         * @param scheduledExecutorService the value to set
         * @return the dsl builder
         */
        default HdfsEndpointConsumerBuilder scheduledExecutorService(
                String scheduledExecutorService) {
            doSetProperty("scheduledExecutorService", scheduledExecutorService);
            return this;
        }
        /**
         * To use a cron scheduler from either camel-spring or camel-quartz
         * component. Use value spring or quartz for built in scheduler.
         * 
         * The option is a: &lt;code&gt;java.lang.Object&lt;/code&gt; type.
         * 
         * Default: none
         * Group: scheduler
         * 
         * @param scheduler the value to set
         * @return the dsl builder
         */
        default HdfsEndpointConsumerBuilder scheduler(Object scheduler) {
            doSetProperty("scheduler", scheduler);
            return this;
        }
        /**
         * To use a cron scheduler from either camel-spring or camel-quartz
         * component. Use value spring or quartz for built in scheduler.
         * 
         * The option will be converted to a
         * &lt;code&gt;java.lang.Object&lt;/code&gt; type.
         * 
         * Default: none
         * Group: scheduler
         * 
         * @param scheduler the value to set
         * @return the dsl builder
         */
        default HdfsEndpointConsumerBuilder scheduler(String scheduler) {
            doSetProperty("scheduler", scheduler);
            return this;
        }
        /**
         * To configure additional properties when using a custom scheduler or
         * any of the Quartz, Spring based scheduler.
         * 
         * The option is a: &lt;code&gt;java.util.Map&amp;lt;java.lang.String,
         * java.lang.Object&amp;gt;&lt;/code&gt; type.
         * The option is multivalued, and you can use the
         * schedulerProperties(String, Object) method to add a value (call the
         * method multiple times to set more values).
         * 
         * Group: scheduler
         * 
         * @param key the option key
         * @param value the option value
         * @return the dsl builder
         */
        default HdfsEndpointConsumerBuilder schedulerProperties(
                String key,
                Object value) {
            doSetMultiValueProperty("schedulerProperties", "scheduler." + key, value);
            return this;
        }
        /**
         * To configure additional properties when using a custom scheduler or
         * any of the Quartz, Spring based scheduler.
         * 
         * The option is a: &lt;code&gt;java.util.Map&amp;lt;java.lang.String,
         * java.lang.Object&amp;gt;&lt;/code&gt; type.
         * The option is multivalued, and you can use the
         * schedulerProperties(String, Object) method to add a value (call the
         * method multiple times to set more values).
         * 
         * Group: scheduler
         * 
         * @param values the values
         * @return the dsl builder
         */
        default HdfsEndpointConsumerBuilder schedulerProperties(Map values) {
            doSetMultiValueProperties("schedulerProperties", "scheduler.", values);
            return this;
        }
        /**
         * Whether the scheduler should be auto started.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: true
         * Group: scheduler
         * 
         * @param startScheduler the value to set
         * @return the dsl builder
         */
        default HdfsEndpointConsumerBuilder startScheduler(
                boolean startScheduler) {
            doSetProperty("startScheduler", startScheduler);
            return this;
        }
        /**
         * Whether the scheduler should be auto started.
         * 
         * The option will be converted to a &lt;code&gt;boolean&lt;/code&gt;
         * type.
         * 
         * Default: true
         * Group: scheduler
         * 
         * @param startScheduler the value to set
         * @return the dsl builder
         */
        default HdfsEndpointConsumerBuilder startScheduler(String startScheduler) {
            doSetProperty("startScheduler", startScheduler);
            return this;
        }
        /**
         * Time unit for initialDelay and delay options.
         * 
         * The option is a:
         * &lt;code&gt;java.util.concurrent.TimeUnit&lt;/code&gt; type.
         * 
         * Default: MILLISECONDS
         * Group: scheduler
         * 
         * @param timeUnit the value to set
         * @return the dsl builder
         */
        default HdfsEndpointConsumerBuilder timeUnit(TimeUnit timeUnit) {
            doSetProperty("timeUnit", timeUnit);
            return this;
        }
        /**
         * Time unit for initialDelay and delay options.
         * 
         * The option will be converted to a
         * &lt;code&gt;java.util.concurrent.TimeUnit&lt;/code&gt; type.
         * 
         * Default: MILLISECONDS
         * Group: scheduler
         * 
         * @param timeUnit the value to set
         * @return the dsl builder
         */
        default HdfsEndpointConsumerBuilder timeUnit(String timeUnit) {
            doSetProperty("timeUnit", timeUnit);
            return this;
        }
        /**
         * Controls if fixed delay or fixed rate is used. See
         * ScheduledExecutorService in JDK for details.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: true
         * Group: scheduler
         * 
         * @param useFixedDelay the value to set
         * @return the dsl builder
         */
        default HdfsEndpointConsumerBuilder useFixedDelay(boolean useFixedDelay) {
            doSetProperty("useFixedDelay", useFixedDelay);
            return this;
        }
        /**
         * Controls if fixed delay or fixed rate is used. See
         * ScheduledExecutorService in JDK for details.
         * 
         * The option will be converted to a &lt;code&gt;boolean&lt;/code&gt;
         * type.
         * 
         * Default: true
         * Group: scheduler
         * 
         * @param useFixedDelay the value to set
         * @return the dsl builder
         */
        default HdfsEndpointConsumerBuilder useFixedDelay(String useFixedDelay) {
            doSetProperty("useFixedDelay", useFixedDelay);
            return this;
        }
        /**
         * The location of the kerb5.conf file
         * (https://web.mit.edu/kerberos/krb5-1.12/doc/admin/conf_files/krb5_conf.html).
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: security
         * 
         * @param kerberosConfigFileLocation the value to set
         * @return the dsl builder
         */
        default HdfsEndpointConsumerBuilder kerberosConfigFileLocation(
                String kerberosConfigFileLocation) {
            doSetProperty("kerberosConfigFileLocation", kerberosConfigFileLocation);
            return this;
        }
        /**
         * The location of the keytab file used to authenticate with the
         * kerberos nodes (contains pairs of kerberos principals and encrypted
         * keys (which are derived from the Kerberos password)).
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: security
         * 
         * @param kerberosKeytabLocation the value to set
         * @return the dsl builder
         */
        default HdfsEndpointConsumerBuilder kerberosKeytabLocation(
                String kerberosKeytabLocation) {
            doSetProperty("kerberosKeytabLocation", kerberosKeytabLocation);
            return this;
        }
        /**
         * The username used to authenticate with the kerberos nodes.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: security
         * 
         * @param kerberosUsername the value to set
         * @return the dsl builder
         */
        default HdfsEndpointConsumerBuilder kerberosUsername(
                String kerberosUsername) {
            doSetProperty("kerberosUsername", kerberosUsername);
            return this;
        }
    }

    /**
     * Advanced builder for endpoint consumers for the HDFS component.
     */
    public interface AdvancedHdfsEndpointConsumerBuilder
            extends
                EndpointConsumerBuilder {
        default HdfsEndpointConsumerBuilder basic() {
            return (HdfsEndpointConsumerBuilder) this;
        }
        /**
         * Allows for bridging the consumer to the Camel routing Error Handler,
         * which mean any exceptions occurred while the consumer is trying to
         * pickup incoming messages, or the likes, will now be processed as a
         * message and handled by the routing Error Handler. By default the
         * consumer will use the org.apache.camel.spi.ExceptionHandler to deal
         * with exceptions, that will be logged at WARN or ERROR level and
         * ignored.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: false
         * Group: consumer (advanced)
         * 
         * @param bridgeErrorHandler the value to set
         * @return the dsl builder
         */
        default AdvancedHdfsEndpointConsumerBuilder bridgeErrorHandler(
                boolean bridgeErrorHandler) {
            doSetProperty("bridgeErrorHandler", bridgeErrorHandler);
            return this;
        }
        /**
         * Allows for bridging the consumer to the Camel routing Error Handler,
         * which mean any exceptions occurred while the consumer is trying to
         * pickup incoming messages, or the likes, will now be processed as a
         * message and handled by the routing Error Handler. By default the
         * consumer will use the org.apache.camel.spi.ExceptionHandler to deal
         * with exceptions, that will be logged at WARN or ERROR level and
         * ignored.
         * 
         * The option will be converted to a &lt;code&gt;boolean&lt;/code&gt;
         * type.
         * 
         * Default: false
         * Group: consumer (advanced)
         * 
         * @param bridgeErrorHandler the value to set
         * @return the dsl builder
         */
        default AdvancedHdfsEndpointConsumerBuilder bridgeErrorHandler(
                String bridgeErrorHandler) {
            doSetProperty("bridgeErrorHandler", bridgeErrorHandler);
            return this;
        }
        /**
         * To let the consumer use a custom ExceptionHandler. Notice if the
         * option bridgeErrorHandler is enabled then this option is not in use.
         * By default the consumer will deal with exceptions, that will be
         * logged at WARN or ERROR level and ignored.
         * 
         * The option is a:
         * &lt;code&gt;org.apache.camel.spi.ExceptionHandler&lt;/code&gt; type.
         * 
         * Group: consumer (advanced)
         * 
         * @param exceptionHandler the value to set
         * @return the dsl builder
         */
        default AdvancedHdfsEndpointConsumerBuilder exceptionHandler(
                org.apache.camel.spi.ExceptionHandler exceptionHandler) {
            doSetProperty("exceptionHandler", exceptionHandler);
            return this;
        }
        /**
         * To let the consumer use a custom ExceptionHandler. Notice if the
         * option bridgeErrorHandler is enabled then this option is not in use.
         * By default the consumer will deal with exceptions, that will be
         * logged at WARN or ERROR level and ignored.
         * 
         * The option will be converted to a
         * &lt;code&gt;org.apache.camel.spi.ExceptionHandler&lt;/code&gt; type.
         * 
         * Group: consumer (advanced)
         * 
         * @param exceptionHandler the value to set
         * @return the dsl builder
         */
        default AdvancedHdfsEndpointConsumerBuilder exceptionHandler(
                String exceptionHandler) {
            doSetProperty("exceptionHandler", exceptionHandler);
            return this;
        }
        /**
         * Sets the exchange pattern when the consumer creates an exchange.
         * 
         * The option is a:
         * &lt;code&gt;org.apache.camel.ExchangePattern&lt;/code&gt; type.
         * 
         * Group: consumer (advanced)
         * 
         * @param exchangePattern the value to set
         * @return the dsl builder
         */
        default AdvancedHdfsEndpointConsumerBuilder exchangePattern(
                org.apache.camel.ExchangePattern exchangePattern) {
            doSetProperty("exchangePattern", exchangePattern);
            return this;
        }
        /**
         * Sets the exchange pattern when the consumer creates an exchange.
         * 
         * The option will be converted to a
         * &lt;code&gt;org.apache.camel.ExchangePattern&lt;/code&gt; type.
         * 
         * Group: consumer (advanced)
         * 
         * @param exchangePattern the value to set
         * @return the dsl builder
         */
        default AdvancedHdfsEndpointConsumerBuilder exchangePattern(
                String exchangePattern) {
            doSetProperty("exchangePattern", exchangePattern);
            return this;
        }
        /**
         * A pluggable org.apache.camel.PollingConsumerPollingStrategy allowing
         * you to provide your custom implementation to control error handling
         * usually occurred during the poll operation before an Exchange have
         * been created and being routed in Camel.
         * 
         * The option is a:
         * &lt;code&gt;org.apache.camel.spi.PollingConsumerPollStrategy&lt;/code&gt; type.
         * 
         * Group: consumer (advanced)
         * 
         * @param pollStrategy the value to set
         * @return the dsl builder
         */
        default AdvancedHdfsEndpointConsumerBuilder pollStrategy(
                org.apache.camel.spi.PollingConsumerPollStrategy pollStrategy) {
            doSetProperty("pollStrategy", pollStrategy);
            return this;
        }
        /**
         * A pluggable org.apache.camel.PollingConsumerPollingStrategy allowing
         * you to provide your custom implementation to control error handling
         * usually occurred during the poll operation before an Exchange have
         * been created and being routed in Camel.
         * 
         * The option will be converted to a
         * &lt;code&gt;org.apache.camel.spi.PollingConsumerPollStrategy&lt;/code&gt; type.
         * 
         * Group: consumer (advanced)
         * 
         * @param pollStrategy the value to set
         * @return the dsl builder
         */
        default AdvancedHdfsEndpointConsumerBuilder pollStrategy(
                String pollStrategy) {
            doSetProperty("pollStrategy", pollStrategy);
            return this;
        }
        /**
         * The size of the HDFS blocks.
         * 
         * The option is a: &lt;code&gt;long&lt;/code&gt; type.
         * 
         * Default: 67108864
         * Group: advanced
         * 
         * @param blockSize the value to set
         * @return the dsl builder
         */
        default AdvancedHdfsEndpointConsumerBuilder blockSize(long blockSize) {
            doSetProperty("blockSize", blockSize);
            return this;
        }
        /**
         * The size of the HDFS blocks.
         * 
         * The option will be converted to a &lt;code&gt;long&lt;/code&gt; type.
         * 
         * Default: 67108864
         * Group: advanced
         * 
         * @param blockSize the value to set
         * @return the dsl builder
         */
        default AdvancedHdfsEndpointConsumerBuilder blockSize(String blockSize) {
            doSetProperty("blockSize", blockSize);
            return this;
        }
        /**
         * The buffer size used by HDFS.
         * 
         * The option is a: &lt;code&gt;int&lt;/code&gt; type.
         * 
         * Default: 4096
         * Group: advanced
         * 
         * @param bufferSize the value to set
         * @return the dsl builder
         */
        default AdvancedHdfsEndpointConsumerBuilder bufferSize(int bufferSize) {
            doSetProperty("bufferSize", bufferSize);
            return this;
        }
        /**
         * The buffer size used by HDFS.
         * 
         * The option will be converted to a &lt;code&gt;int&lt;/code&gt; type.
         * 
         * Default: 4096
         * Group: advanced
         * 
         * @param bufferSize the value to set
         * @return the dsl builder
         */
        default AdvancedHdfsEndpointConsumerBuilder bufferSize(String bufferSize) {
            doSetProperty("bufferSize", bufferSize);
            return this;
        }
        /**
         * How often (time in millis) in to run the idle checker background
         * task. This option is only in use if the splitter strategy is IDLE.
         * 
         * The option is a: &lt;code&gt;int&lt;/code&gt; type.
         * 
         * Default: 500
         * Group: advanced
         * 
         * @param checkIdleInterval the value to set
         * @return the dsl builder
         */
        default AdvancedHdfsEndpointConsumerBuilder checkIdleInterval(
                int checkIdleInterval) {
            doSetProperty("checkIdleInterval", checkIdleInterval);
            return this;
        }
        /**
         * How often (time in millis) in to run the idle checker background
         * task. This option is only in use if the splitter strategy is IDLE.
         * 
         * The option will be converted to a &lt;code&gt;int&lt;/code&gt; type.
         * 
         * Default: 500
         * Group: advanced
         * 
         * @param checkIdleInterval the value to set
         * @return the dsl builder
         */
        default AdvancedHdfsEndpointConsumerBuilder checkIdleInterval(
                String checkIdleInterval) {
            doSetProperty("checkIdleInterval", checkIdleInterval);
            return this;
        }
        /**
         * When reading a normal file, this is split into chunks producing a
         * message per chunk.
         * 
         * The option is a: &lt;code&gt;int&lt;/code&gt; type.
         * 
         * Default: 4096
         * Group: advanced
         * 
         * @param chunkSize the value to set
         * @return the dsl builder
         */
        default AdvancedHdfsEndpointConsumerBuilder chunkSize(int chunkSize) {
            doSetProperty("chunkSize", chunkSize);
            return this;
        }
        /**
         * When reading a normal file, this is split into chunks producing a
         * message per chunk.
         * 
         * The option will be converted to a &lt;code&gt;int&lt;/code&gt; type.
         * 
         * Default: 4096
         * Group: advanced
         * 
         * @param chunkSize the value to set
         * @return the dsl builder
         */
        default AdvancedHdfsEndpointConsumerBuilder chunkSize(String chunkSize) {
            doSetProperty("chunkSize", chunkSize);
            return this;
        }
        /**
         * The compression codec to use.
         * 
         * The option is a:
         * &lt;code&gt;org.apache.camel.component.hdfs.HdfsCompressionCodec&lt;/code&gt; type.
         * 
         * Default: DEFAULT
         * Group: advanced
         * 
         * @param compressionCodec the value to set
         * @return the dsl builder
         */
        default AdvancedHdfsEndpointConsumerBuilder compressionCodec(
                org.apache.camel.component.hdfs.HdfsCompressionCodec compressionCodec) {
            doSetProperty("compressionCodec", compressionCodec);
            return this;
        }
        /**
         * The compression codec to use.
         * 
         * The option will be converted to a
         * &lt;code&gt;org.apache.camel.component.hdfs.HdfsCompressionCodec&lt;/code&gt; type.
         * 
         * Default: DEFAULT
         * Group: advanced
         * 
         * @param compressionCodec the value to set
         * @return the dsl builder
         */
        default AdvancedHdfsEndpointConsumerBuilder compressionCodec(
                String compressionCodec) {
            doSetProperty("compressionCodec", compressionCodec);
            return this;
        }
        /**
         * The compression type to use (is default not in use).
         * 
         * The option is a:
         * &lt;code&gt;org.apache.camel.component.hdfs.HdfsCompressionType&lt;/code&gt; type.
         * 
         * Default: NONE
         * Group: advanced
         * 
         * @param compressionType the value to set
         * @return the dsl builder
         */
        default AdvancedHdfsEndpointConsumerBuilder compressionType(
                org.apache.camel.component.hdfs.HdfsCompressionType compressionType) {
            doSetProperty("compressionType", compressionType);
            return this;
        }
        /**
         * The compression type to use (is default not in use).
         * 
         * The option will be converted to a
         * &lt;code&gt;org.apache.camel.component.hdfs.HdfsCompressionType&lt;/code&gt; type.
         * 
         * Default: NONE
         * Group: advanced
         * 
         * @param compressionType the value to set
         * @return the dsl builder
         */
        default AdvancedHdfsEndpointConsumerBuilder compressionType(
                String compressionType) {
            doSetProperty("compressionType", compressionType);
            return this;
        }
        /**
         * When a file is opened for reading/writing the file is renamed with
         * this suffix to avoid to read it during the writing phase.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Default: opened
         * Group: advanced
         * 
         * @param openedSuffix the value to set
         * @return the dsl builder
         */
        default AdvancedHdfsEndpointConsumerBuilder openedSuffix(
                String openedSuffix) {
            doSetProperty("openedSuffix", openedSuffix);
            return this;
        }
        /**
         * Once the file has been read is renamed with this suffix to avoid to
         * read it again.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Default: read
         * Group: advanced
         * 
         * @param readSuffix the value to set
         * @return the dsl builder
         */
        default AdvancedHdfsEndpointConsumerBuilder readSuffix(String readSuffix) {
            doSetProperty("readSuffix", readSuffix);
            return this;
        }
        /**
         * The HDFS replication factor.
         * 
         * The option is a: &lt;code&gt;short&lt;/code&gt; type.
         * 
         * Default: 3
         * Group: advanced
         * 
         * @param replication the value to set
         * @return the dsl builder
         */
        default AdvancedHdfsEndpointConsumerBuilder replication(
                short replication) {
            doSetProperty("replication", replication);
            return this;
        }
        /**
         * The HDFS replication factor.
         * 
         * The option will be converted to a &lt;code&gt;short&lt;/code&gt;
         * type.
         * 
         * Default: 3
         * Group: advanced
         * 
         * @param replication the value to set
         * @return the dsl builder
         */
        default AdvancedHdfsEndpointConsumerBuilder replication(
                String replication) {
            doSetProperty("replication", replication);
            return this;
        }
        /**
         * In the current version of Hadoop opening a file in append mode is
         * disabled since it's not very reliable. So, for the moment, it's only
         * possible to create new files. The Camel HDFS endpoint tries to solve
         * this problem in this way: If the split strategy option has been
         * defined, the hdfs path will be used as a directory and files will be
         * created using the configured UuidGenerator. Every time a splitting
         * condition is met, a new file is created. The splitStrategy option is
         * defined as a string with the following syntax:
         * splitStrategy=ST:value,ST:value,... where ST can be: BYTES a new file
         * is created, and the old is closed when the number of written bytes is
         * more than value MESSAGES a new file is created, and the old is closed
         * when the number of written messages is more than value IDLE a new
         * file is created, and the old is closed when no writing happened in
         * the last value milliseconds.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: advanced
         * 
         * @param splitStrategy the value to set
         * @return the dsl builder
         */
        default AdvancedHdfsEndpointConsumerBuilder splitStrategy(
                String splitStrategy) {
            doSetProperty("splitStrategy", splitStrategy);
            return this;
        }
    }

    /**
     * Builder for endpoint producers for the HDFS component.
     */
    public interface HdfsEndpointProducerBuilder
            extends
                EndpointProducerBuilder {
        default AdvancedHdfsEndpointProducerBuilder advanced() {
            return (AdvancedHdfsEndpointProducerBuilder) this;
        }
        /**
         * Whether to connect to the HDFS file system on starting the
         * producer/consumer. If false then the connection is created on-demand.
         * Notice that HDFS may take up till 15 minutes to establish a
         * connection, as it has hardcoded 45 x 20 sec redelivery. By setting
         * this option to false allows your application to startup, and not
         * block for up till 15 minutes.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: true
         * Group: common
         * 
         * @param connectOnStartup the value to set
         * @return the dsl builder
         */
        default HdfsEndpointProducerBuilder connectOnStartup(
                boolean connectOnStartup) {
            doSetProperty("connectOnStartup", connectOnStartup);
            return this;
        }
        /**
         * Whether to connect to the HDFS file system on starting the
         * producer/consumer. If false then the connection is created on-demand.
         * Notice that HDFS may take up till 15 minutes to establish a
         * connection, as it has hardcoded 45 x 20 sec redelivery. By setting
         * this option to false allows your application to startup, and not
         * block for up till 15 minutes.
         * 
         * The option will be converted to a &lt;code&gt;boolean&lt;/code&gt;
         * type.
         * 
         * Default: true
         * Group: common
         * 
         * @param connectOnStartup the value to set
         * @return the dsl builder
         */
        default HdfsEndpointProducerBuilder connectOnStartup(
                String connectOnStartup) {
            doSetProperty("connectOnStartup", connectOnStartup);
            return this;
        }
        /**
         * Set to LOCAL to not use HDFS but local java.io.File instead.
         * 
         * The option is a:
         * &lt;code&gt;org.apache.camel.component.hdfs.HdfsFileSystemType&lt;/code&gt; type.
         * 
         * Default: HDFS
         * Group: common
         * 
         * @param fileSystemType the value to set
         * @return the dsl builder
         */
        default HdfsEndpointProducerBuilder fileSystemType(
                org.apache.camel.component.hdfs.HdfsFileSystemType fileSystemType) {
            doSetProperty("fileSystemType", fileSystemType);
            return this;
        }
        /**
         * Set to LOCAL to not use HDFS but local java.io.File instead.
         * 
         * The option will be converted to a
         * &lt;code&gt;org.apache.camel.component.hdfs.HdfsFileSystemType&lt;/code&gt; type.
         * 
         * Default: HDFS
         * Group: common
         * 
         * @param fileSystemType the value to set
         * @return the dsl builder
         */
        default HdfsEndpointProducerBuilder fileSystemType(String fileSystemType) {
            doSetProperty("fileSystemType", fileSystemType);
            return this;
        }
        /**
         * The file type to use. For more details see Hadoop HDFS documentation
         * about the various files types.
         * 
         * The option is a:
         * &lt;code&gt;org.apache.camel.component.hdfs.HdfsFileType&lt;/code&gt;
         * type.
         * 
         * Default: NORMAL_FILE
         * Group: common
         * 
         * @param fileType the value to set
         * @return the dsl builder
         */
        default HdfsEndpointProducerBuilder fileType(
                org.apache.camel.component.hdfs.HdfsFileType fileType) {
            doSetProperty("fileType", fileType);
            return this;
        }
        /**
         * The file type to use. For more details see Hadoop HDFS documentation
         * about the various files types.
         * 
         * The option will be converted to a
         * &lt;code&gt;org.apache.camel.component.hdfs.HdfsFileType&lt;/code&gt;
         * type.
         * 
         * Default: NORMAL_FILE
         * Group: common
         * 
         * @param fileType the value to set
         * @return the dsl builder
         */
        default HdfsEndpointProducerBuilder fileType(String fileType) {
            doSetProperty("fileType", fileType);
            return this;
        }
        /**
         * The type for the key in case of sequence or map files.
         * 
         * The option is a:
         * &lt;code&gt;org.apache.camel.component.hdfs.WritableType&lt;/code&gt;
         * type.
         * 
         * Default: NULL
         * Group: common
         * 
         * @param keyType the value to set
         * @return the dsl builder
         */
        default HdfsEndpointProducerBuilder keyType(
                org.apache.camel.component.hdfs.WritableType keyType) {
            doSetProperty("keyType", keyType);
            return this;
        }
        /**
         * The type for the key in case of sequence or map files.
         * 
         * The option will be converted to a
         * &lt;code&gt;org.apache.camel.component.hdfs.WritableType&lt;/code&gt;
         * type.
         * 
         * Default: NULL
         * Group: common
         * 
         * @param keyType the value to set
         * @return the dsl builder
         */
        default HdfsEndpointProducerBuilder keyType(String keyType) {
            doSetProperty("keyType", keyType);
            return this;
        }
        /**
         * A comma separated list of named nodes (e.g.
         * srv11.example.com:8020,srv12.example.com:8020).
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param namedNodes the value to set
         * @return the dsl builder
         */
        default HdfsEndpointProducerBuilder namedNodes(String namedNodes) {
            doSetProperty("namedNodes", namedNodes);
            return this;
        }
        /**
         * The file owner must match this owner for the consumer to pickup the
         * file. Otherwise the file is skipped.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param owner the value to set
         * @return the dsl builder
         */
        default HdfsEndpointProducerBuilder owner(String owner) {
            doSetProperty("owner", owner);
            return this;
        }
        /**
         * The type for the key in case of sequence or map files.
         * 
         * The option is a:
         * &lt;code&gt;org.apache.camel.component.hdfs.WritableType&lt;/code&gt;
         * type.
         * 
         * Default: BYTES
         * Group: common
         * 
         * @param valueType the value to set
         * @return the dsl builder
         */
        default HdfsEndpointProducerBuilder valueType(
                org.apache.camel.component.hdfs.WritableType valueType) {
            doSetProperty("valueType", valueType);
            return this;
        }
        /**
         * The type for the key in case of sequence or map files.
         * 
         * The option will be converted to a
         * &lt;code&gt;org.apache.camel.component.hdfs.WritableType&lt;/code&gt;
         * type.
         * 
         * Default: BYTES
         * Group: common
         * 
         * @param valueType the value to set
         * @return the dsl builder
         */
        default HdfsEndpointProducerBuilder valueType(String valueType) {
            doSetProperty("valueType", valueType);
            return this;
        }
        /**
         * Append to existing file. Notice that not all HDFS file systems
         * support the append option.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: false
         * Group: producer
         * 
         * @param append the value to set
         * @return the dsl builder
         */
        default HdfsEndpointProducerBuilder append(boolean append) {
            doSetProperty("append", append);
            return this;
        }
        /**
         * Append to existing file. Notice that not all HDFS file systems
         * support the append option.
         * 
         * The option will be converted to a &lt;code&gt;boolean&lt;/code&gt;
         * type.
         * 
         * Default: false
         * Group: producer
         * 
         * @param append the value to set
         * @return the dsl builder
         */
        default HdfsEndpointProducerBuilder append(String append) {
            doSetProperty("append", append);
            return this;
        }
        /**
         * Whether to overwrite existing files with the same name.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: true
         * Group: producer
         * 
         * @param overwrite the value to set
         * @return the dsl builder
         */
        default HdfsEndpointProducerBuilder overwrite(boolean overwrite) {
            doSetProperty("overwrite", overwrite);
            return this;
        }
        /**
         * Whether to overwrite existing files with the same name.
         * 
         * The option will be converted to a &lt;code&gt;boolean&lt;/code&gt;
         * type.
         * 
         * Default: true
         * Group: producer
         * 
         * @param overwrite the value to set
         * @return the dsl builder
         */
        default HdfsEndpointProducerBuilder overwrite(String overwrite) {
            doSetProperty("overwrite", overwrite);
            return this;
        }
        /**
         * The location of the kerb5.conf file
         * (https://web.mit.edu/kerberos/krb5-1.12/doc/admin/conf_files/krb5_conf.html).
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: security
         * 
         * @param kerberosConfigFileLocation the value to set
         * @return the dsl builder
         */
        default HdfsEndpointProducerBuilder kerberosConfigFileLocation(
                String kerberosConfigFileLocation) {
            doSetProperty("kerberosConfigFileLocation", kerberosConfigFileLocation);
            return this;
        }
        /**
         * The location of the keytab file used to authenticate with the
         * kerberos nodes (contains pairs of kerberos principals and encrypted
         * keys (which are derived from the Kerberos password)).
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: security
         * 
         * @param kerberosKeytabLocation the value to set
         * @return the dsl builder
         */
        default HdfsEndpointProducerBuilder kerberosKeytabLocation(
                String kerberosKeytabLocation) {
            doSetProperty("kerberosKeytabLocation", kerberosKeytabLocation);
            return this;
        }
        /**
         * The username used to authenticate with the kerberos nodes.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: security
         * 
         * @param kerberosUsername the value to set
         * @return the dsl builder
         */
        default HdfsEndpointProducerBuilder kerberosUsername(
                String kerberosUsername) {
            doSetProperty("kerberosUsername", kerberosUsername);
            return this;
        }
    }

    /**
     * Advanced builder for endpoint producers for the HDFS component.
     */
    public interface AdvancedHdfsEndpointProducerBuilder
            extends
                EndpointProducerBuilder {
        default HdfsEndpointProducerBuilder basic() {
            return (HdfsEndpointProducerBuilder) this;
        }
        /**
         * Whether the producer should be started lazy (on the first message).
         * By starting lazy you can use this to allow CamelContext and routes to
         * startup in situations where a producer may otherwise fail during
         * starting and cause the route to fail being started. By deferring this
         * startup to be lazy then the startup failure can be handled during
         * routing messages via Camel's routing error handlers. Beware that when
         * the first message is processed then creating and starting the
         * producer may take a little time and prolong the total processing time
         * of the processing.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: false
         * Group: producer (advanced)
         * 
         * @param lazyStartProducer the value to set
         * @return the dsl builder
         */
        default AdvancedHdfsEndpointProducerBuilder lazyStartProducer(
                boolean lazyStartProducer) {
            doSetProperty("lazyStartProducer", lazyStartProducer);
            return this;
        }
        /**
         * Whether the producer should be started lazy (on the first message).
         * By starting lazy you can use this to allow CamelContext and routes to
         * startup in situations where a producer may otherwise fail during
         * starting and cause the route to fail being started. By deferring this
         * startup to be lazy then the startup failure can be handled during
         * routing messages via Camel's routing error handlers. Beware that when
         * the first message is processed then creating and starting the
         * producer may take a little time and prolong the total processing time
         * of the processing.
         * 
         * The option will be converted to a &lt;code&gt;boolean&lt;/code&gt;
         * type.
         * 
         * Default: false
         * Group: producer (advanced)
         * 
         * @param lazyStartProducer the value to set
         * @return the dsl builder
         */
        default AdvancedHdfsEndpointProducerBuilder lazyStartProducer(
                String lazyStartProducer) {
            doSetProperty("lazyStartProducer", lazyStartProducer);
            return this;
        }
        /**
         * The size of the HDFS blocks.
         * 
         * The option is a: &lt;code&gt;long&lt;/code&gt; type.
         * 
         * Default: 67108864
         * Group: advanced
         * 
         * @param blockSize the value to set
         * @return the dsl builder
         */
        default AdvancedHdfsEndpointProducerBuilder blockSize(long blockSize) {
            doSetProperty("blockSize", blockSize);
            return this;
        }
        /**
         * The size of the HDFS blocks.
         * 
         * The option will be converted to a &lt;code&gt;long&lt;/code&gt; type.
         * 
         * Default: 67108864
         * Group: advanced
         * 
         * @param blockSize the value to set
         * @return the dsl builder
         */
        default AdvancedHdfsEndpointProducerBuilder blockSize(String blockSize) {
            doSetProperty("blockSize", blockSize);
            return this;
        }
        /**
         * The buffer size used by HDFS.
         * 
         * The option is a: &lt;code&gt;int&lt;/code&gt; type.
         * 
         * Default: 4096
         * Group: advanced
         * 
         * @param bufferSize the value to set
         * @return the dsl builder
         */
        default AdvancedHdfsEndpointProducerBuilder bufferSize(int bufferSize) {
            doSetProperty("bufferSize", bufferSize);
            return this;
        }
        /**
         * The buffer size used by HDFS.
         * 
         * The option will be converted to a &lt;code&gt;int&lt;/code&gt; type.
         * 
         * Default: 4096
         * Group: advanced
         * 
         * @param bufferSize the value to set
         * @return the dsl builder
         */
        default AdvancedHdfsEndpointProducerBuilder bufferSize(String bufferSize) {
            doSetProperty("bufferSize", bufferSize);
            return this;
        }
        /**
         * How often (time in millis) in to run the idle checker background
         * task. This option is only in use if the splitter strategy is IDLE.
         * 
         * The option is a: &lt;code&gt;int&lt;/code&gt; type.
         * 
         * Default: 500
         * Group: advanced
         * 
         * @param checkIdleInterval the value to set
         * @return the dsl builder
         */
        default AdvancedHdfsEndpointProducerBuilder checkIdleInterval(
                int checkIdleInterval) {
            doSetProperty("checkIdleInterval", checkIdleInterval);
            return this;
        }
        /**
         * How often (time in millis) in to run the idle checker background
         * task. This option is only in use if the splitter strategy is IDLE.
         * 
         * The option will be converted to a &lt;code&gt;int&lt;/code&gt; type.
         * 
         * Default: 500
         * Group: advanced
         * 
         * @param checkIdleInterval the value to set
         * @return the dsl builder
         */
        default AdvancedHdfsEndpointProducerBuilder checkIdleInterval(
                String checkIdleInterval) {
            doSetProperty("checkIdleInterval", checkIdleInterval);
            return this;
        }
        /**
         * When reading a normal file, this is split into chunks producing a
         * message per chunk.
         * 
         * The option is a: &lt;code&gt;int&lt;/code&gt; type.
         * 
         * Default: 4096
         * Group: advanced
         * 
         * @param chunkSize the value to set
         * @return the dsl builder
         */
        default AdvancedHdfsEndpointProducerBuilder chunkSize(int chunkSize) {
            doSetProperty("chunkSize", chunkSize);
            return this;
        }
        /**
         * When reading a normal file, this is split into chunks producing a
         * message per chunk.
         * 
         * The option will be converted to a &lt;code&gt;int&lt;/code&gt; type.
         * 
         * Default: 4096
         * Group: advanced
         * 
         * @param chunkSize the value to set
         * @return the dsl builder
         */
        default AdvancedHdfsEndpointProducerBuilder chunkSize(String chunkSize) {
            doSetProperty("chunkSize", chunkSize);
            return this;
        }
        /**
         * The compression codec to use.
         * 
         * The option is a:
         * &lt;code&gt;org.apache.camel.component.hdfs.HdfsCompressionCodec&lt;/code&gt; type.
         * 
         * Default: DEFAULT
         * Group: advanced
         * 
         * @param compressionCodec the value to set
         * @return the dsl builder
         */
        default AdvancedHdfsEndpointProducerBuilder compressionCodec(
                org.apache.camel.component.hdfs.HdfsCompressionCodec compressionCodec) {
            doSetProperty("compressionCodec", compressionCodec);
            return this;
        }
        /**
         * The compression codec to use.
         * 
         * The option will be converted to a
         * &lt;code&gt;org.apache.camel.component.hdfs.HdfsCompressionCodec&lt;/code&gt; type.
         * 
         * Default: DEFAULT
         * Group: advanced
         * 
         * @param compressionCodec the value to set
         * @return the dsl builder
         */
        default AdvancedHdfsEndpointProducerBuilder compressionCodec(
                String compressionCodec) {
            doSetProperty("compressionCodec", compressionCodec);
            return this;
        }
        /**
         * The compression type to use (is default not in use).
         * 
         * The option is a:
         * &lt;code&gt;org.apache.camel.component.hdfs.HdfsCompressionType&lt;/code&gt; type.
         * 
         * Default: NONE
         * Group: advanced
         * 
         * @param compressionType the value to set
         * @return the dsl builder
         */
        default AdvancedHdfsEndpointProducerBuilder compressionType(
                org.apache.camel.component.hdfs.HdfsCompressionType compressionType) {
            doSetProperty("compressionType", compressionType);
            return this;
        }
        /**
         * The compression type to use (is default not in use).
         * 
         * The option will be converted to a
         * &lt;code&gt;org.apache.camel.component.hdfs.HdfsCompressionType&lt;/code&gt; type.
         * 
         * Default: NONE
         * Group: advanced
         * 
         * @param compressionType the value to set
         * @return the dsl builder
         */
        default AdvancedHdfsEndpointProducerBuilder compressionType(
                String compressionType) {
            doSetProperty("compressionType", compressionType);
            return this;
        }
        /**
         * When a file is opened for reading/writing the file is renamed with
         * this suffix to avoid to read it during the writing phase.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Default: opened
         * Group: advanced
         * 
         * @param openedSuffix the value to set
         * @return the dsl builder
         */
        default AdvancedHdfsEndpointProducerBuilder openedSuffix(
                String openedSuffix) {
            doSetProperty("openedSuffix", openedSuffix);
            return this;
        }
        /**
         * Once the file has been read is renamed with this suffix to avoid to
         * read it again.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Default: read
         * Group: advanced
         * 
         * @param readSuffix the value to set
         * @return the dsl builder
         */
        default AdvancedHdfsEndpointProducerBuilder readSuffix(String readSuffix) {
            doSetProperty("readSuffix", readSuffix);
            return this;
        }
        /**
         * The HDFS replication factor.
         * 
         * The option is a: &lt;code&gt;short&lt;/code&gt; type.
         * 
         * Default: 3
         * Group: advanced
         * 
         * @param replication the value to set
         * @return the dsl builder
         */
        default AdvancedHdfsEndpointProducerBuilder replication(
                short replication) {
            doSetProperty("replication", replication);
            return this;
        }
        /**
         * The HDFS replication factor.
         * 
         * The option will be converted to a &lt;code&gt;short&lt;/code&gt;
         * type.
         * 
         * Default: 3
         * Group: advanced
         * 
         * @param replication the value to set
         * @return the dsl builder
         */
        default AdvancedHdfsEndpointProducerBuilder replication(
                String replication) {
            doSetProperty("replication", replication);
            return this;
        }
        /**
         * In the current version of Hadoop opening a file in append mode is
         * disabled since it's not very reliable. So, for the moment, it's only
         * possible to create new files. The Camel HDFS endpoint tries to solve
         * this problem in this way: If the split strategy option has been
         * defined, the hdfs path will be used as a directory and files will be
         * created using the configured UuidGenerator. Every time a splitting
         * condition is met, a new file is created. The splitStrategy option is
         * defined as a string with the following syntax:
         * splitStrategy=ST:value,ST:value,... where ST can be: BYTES a new file
         * is created, and the old is closed when the number of written bytes is
         * more than value MESSAGES a new file is created, and the old is closed
         * when the number of written messages is more than value IDLE a new
         * file is created, and the old is closed when no writing happened in
         * the last value milliseconds.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: advanced
         * 
         * @param splitStrategy the value to set
         * @return the dsl builder
         */
        default AdvancedHdfsEndpointProducerBuilder splitStrategy(
                String splitStrategy) {
            doSetProperty("splitStrategy", splitStrategy);
            return this;
        }
    }

    /**
     * Builder for endpoint for the HDFS component.
     */
    public interface HdfsEndpointBuilder
            extends
                HdfsEndpointConsumerBuilder,
                HdfsEndpointProducerBuilder {
        default AdvancedHdfsEndpointBuilder advanced() {
            return (AdvancedHdfsEndpointBuilder) this;
        }
        /**
         * Whether to connect to the HDFS file system on starting the
         * producer/consumer. If false then the connection is created on-demand.
         * Notice that HDFS may take up till 15 minutes to establish a
         * connection, as it has hardcoded 45 x 20 sec redelivery. By setting
         * this option to false allows your application to startup, and not
         * block for up till 15 minutes.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: true
         * Group: common
         * 
         * @param connectOnStartup the value to set
         * @return the dsl builder
         */
        default HdfsEndpointBuilder connectOnStartup(boolean connectOnStartup) {
            doSetProperty("connectOnStartup", connectOnStartup);
            return this;
        }
        /**
         * Whether to connect to the HDFS file system on starting the
         * producer/consumer. If false then the connection is created on-demand.
         * Notice that HDFS may take up till 15 minutes to establish a
         * connection, as it has hardcoded 45 x 20 sec redelivery. By setting
         * this option to false allows your application to startup, and not
         * block for up till 15 minutes.
         * 
         * The option will be converted to a &lt;code&gt;boolean&lt;/code&gt;
         * type.
         * 
         * Default: true
         * Group: common
         * 
         * @param connectOnStartup the value to set
         * @return the dsl builder
         */
        default HdfsEndpointBuilder connectOnStartup(String connectOnStartup) {
            doSetProperty("connectOnStartup", connectOnStartup);
            return this;
        }
        /**
         * Set to LOCAL to not use HDFS but local java.io.File instead.
         * 
         * The option is a:
         * &lt;code&gt;org.apache.camel.component.hdfs.HdfsFileSystemType&lt;/code&gt; type.
         * 
         * Default: HDFS
         * Group: common
         * 
         * @param fileSystemType the value to set
         * @return the dsl builder
         */
        default HdfsEndpointBuilder fileSystemType(
                org.apache.camel.component.hdfs.HdfsFileSystemType fileSystemType) {
            doSetProperty("fileSystemType", fileSystemType);
            return this;
        }
        /**
         * Set to LOCAL to not use HDFS but local java.io.File instead.
         * 
         * The option will be converted to a
         * &lt;code&gt;org.apache.camel.component.hdfs.HdfsFileSystemType&lt;/code&gt; type.
         * 
         * Default: HDFS
         * Group: common
         * 
         * @param fileSystemType the value to set
         * @return the dsl builder
         */
        default HdfsEndpointBuilder fileSystemType(String fileSystemType) {
            doSetProperty("fileSystemType", fileSystemType);
            return this;
        }
        /**
         * The file type to use. For more details see Hadoop HDFS documentation
         * about the various files types.
         * 
         * The option is a:
         * &lt;code&gt;org.apache.camel.component.hdfs.HdfsFileType&lt;/code&gt;
         * type.
         * 
         * Default: NORMAL_FILE
         * Group: common
         * 
         * @param fileType the value to set
         * @return the dsl builder
         */
        default HdfsEndpointBuilder fileType(
                org.apache.camel.component.hdfs.HdfsFileType fileType) {
            doSetProperty("fileType", fileType);
            return this;
        }
        /**
         * The file type to use. For more details see Hadoop HDFS documentation
         * about the various files types.
         * 
         * The option will be converted to a
         * &lt;code&gt;org.apache.camel.component.hdfs.HdfsFileType&lt;/code&gt;
         * type.
         * 
         * Default: NORMAL_FILE
         * Group: common
         * 
         * @param fileType the value to set
         * @return the dsl builder
         */
        default HdfsEndpointBuilder fileType(String fileType) {
            doSetProperty("fileType", fileType);
            return this;
        }
        /**
         * The type for the key in case of sequence or map files.
         * 
         * The option is a:
         * &lt;code&gt;org.apache.camel.component.hdfs.WritableType&lt;/code&gt;
         * type.
         * 
         * Default: NULL
         * Group: common
         * 
         * @param keyType the value to set
         * @return the dsl builder
         */
        default HdfsEndpointBuilder keyType(
                org.apache.camel.component.hdfs.WritableType keyType) {
            doSetProperty("keyType", keyType);
            return this;
        }
        /**
         * The type for the key in case of sequence or map files.
         * 
         * The option will be converted to a
         * &lt;code&gt;org.apache.camel.component.hdfs.WritableType&lt;/code&gt;
         * type.
         * 
         * Default: NULL
         * Group: common
         * 
         * @param keyType the value to set
         * @return the dsl builder
         */
        default HdfsEndpointBuilder keyType(String keyType) {
            doSetProperty("keyType", keyType);
            return this;
        }
        /**
         * A comma separated list of named nodes (e.g.
         * srv11.example.com:8020,srv12.example.com:8020).
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param namedNodes the value to set
         * @return the dsl builder
         */
        default HdfsEndpointBuilder namedNodes(String namedNodes) {
            doSetProperty("namedNodes", namedNodes);
            return this;
        }
        /**
         * The file owner must match this owner for the consumer to pickup the
         * file. Otherwise the file is skipped.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param owner the value to set
         * @return the dsl builder
         */
        default HdfsEndpointBuilder owner(String owner) {
            doSetProperty("owner", owner);
            return this;
        }
        /**
         * The type for the key in case of sequence or map files.
         * 
         * The option is a:
         * &lt;code&gt;org.apache.camel.component.hdfs.WritableType&lt;/code&gt;
         * type.
         * 
         * Default: BYTES
         * Group: common
         * 
         * @param valueType the value to set
         * @return the dsl builder
         */
        default HdfsEndpointBuilder valueType(
                org.apache.camel.component.hdfs.WritableType valueType) {
            doSetProperty("valueType", valueType);
            return this;
        }
        /**
         * The type for the key in case of sequence or map files.
         * 
         * The option will be converted to a
         * &lt;code&gt;org.apache.camel.component.hdfs.WritableType&lt;/code&gt;
         * type.
         * 
         * Default: BYTES
         * Group: common
         * 
         * @param valueType the value to set
         * @return the dsl builder
         */
        default HdfsEndpointBuilder valueType(String valueType) {
            doSetProperty("valueType", valueType);
            return this;
        }
        /**
         * The location of the kerb5.conf file
         * (https://web.mit.edu/kerberos/krb5-1.12/doc/admin/conf_files/krb5_conf.html).
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: security
         * 
         * @param kerberosConfigFileLocation the value to set
         * @return the dsl builder
         */
        default HdfsEndpointBuilder kerberosConfigFileLocation(
                String kerberosConfigFileLocation) {
            doSetProperty("kerberosConfigFileLocation", kerberosConfigFileLocation);
            return this;
        }
        /**
         * The location of the keytab file used to authenticate with the
         * kerberos nodes (contains pairs of kerberos principals and encrypted
         * keys (which are derived from the Kerberos password)).
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: security
         * 
         * @param kerberosKeytabLocation the value to set
         * @return the dsl builder
         */
        default HdfsEndpointBuilder kerberosKeytabLocation(
                String kerberosKeytabLocation) {
            doSetProperty("kerberosKeytabLocation", kerberosKeytabLocation);
            return this;
        }
        /**
         * The username used to authenticate with the kerberos nodes.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: security
         * 
         * @param kerberosUsername the value to set
         * @return the dsl builder
         */
        default HdfsEndpointBuilder kerberosUsername(String kerberosUsername) {
            doSetProperty("kerberosUsername", kerberosUsername);
            return this;
        }
    }

    /**
     * Advanced builder for endpoint for the HDFS component.
     */
    public interface AdvancedHdfsEndpointBuilder
            extends
                AdvancedHdfsEndpointConsumerBuilder,
                AdvancedHdfsEndpointProducerBuilder {
        default HdfsEndpointBuilder basic() {
            return (HdfsEndpointBuilder) this;
        }
        /**
         * The size of the HDFS blocks.
         * 
         * The option is a: &lt;code&gt;long&lt;/code&gt; type.
         * 
         * Default: 67108864
         * Group: advanced
         * 
         * @param blockSize the value to set
         * @return the dsl builder
         */
        default AdvancedHdfsEndpointBuilder blockSize(long blockSize) {
            doSetProperty("blockSize", blockSize);
            return this;
        }
        /**
         * The size of the HDFS blocks.
         * 
         * The option will be converted to a &lt;code&gt;long&lt;/code&gt; type.
         * 
         * Default: 67108864
         * Group: advanced
         * 
         * @param blockSize the value to set
         * @return the dsl builder
         */
        default AdvancedHdfsEndpointBuilder blockSize(String blockSize) {
            doSetProperty("blockSize", blockSize);
            return this;
        }
        /**
         * The buffer size used by HDFS.
         * 
         * The option is a: &lt;code&gt;int&lt;/code&gt; type.
         * 
         * Default: 4096
         * Group: advanced
         * 
         * @param bufferSize the value to set
         * @return the dsl builder
         */
        default AdvancedHdfsEndpointBuilder bufferSize(int bufferSize) {
            doSetProperty("bufferSize", bufferSize);
            return this;
        }
        /**
         * The buffer size used by HDFS.
         * 
         * The option will be converted to a &lt;code&gt;int&lt;/code&gt; type.
         * 
         * Default: 4096
         * Group: advanced
         * 
         * @param bufferSize the value to set
         * @return the dsl builder
         */
        default AdvancedHdfsEndpointBuilder bufferSize(String bufferSize) {
            doSetProperty("bufferSize", bufferSize);
            return this;
        }
        /**
         * How often (time in millis) in to run the idle checker background
         * task. This option is only in use if the splitter strategy is IDLE.
         * 
         * The option is a: &lt;code&gt;int&lt;/code&gt; type.
         * 
         * Default: 500
         * Group: advanced
         * 
         * @param checkIdleInterval the value to set
         * @return the dsl builder
         */
        default AdvancedHdfsEndpointBuilder checkIdleInterval(
                int checkIdleInterval) {
            doSetProperty("checkIdleInterval", checkIdleInterval);
            return this;
        }
        /**
         * How often (time in millis) in to run the idle checker background
         * task. This option is only in use if the splitter strategy is IDLE.
         * 
         * The option will be converted to a &lt;code&gt;int&lt;/code&gt; type.
         * 
         * Default: 500
         * Group: advanced
         * 
         * @param checkIdleInterval the value to set
         * @return the dsl builder
         */
        default AdvancedHdfsEndpointBuilder checkIdleInterval(
                String checkIdleInterval) {
            doSetProperty("checkIdleInterval", checkIdleInterval);
            return this;
        }
        /**
         * When reading a normal file, this is split into chunks producing a
         * message per chunk.
         * 
         * The option is a: &lt;code&gt;int&lt;/code&gt; type.
         * 
         * Default: 4096
         * Group: advanced
         * 
         * @param chunkSize the value to set
         * @return the dsl builder
         */
        default AdvancedHdfsEndpointBuilder chunkSize(int chunkSize) {
            doSetProperty("chunkSize", chunkSize);
            return this;
        }
        /**
         * When reading a normal file, this is split into chunks producing a
         * message per chunk.
         * 
         * The option will be converted to a &lt;code&gt;int&lt;/code&gt; type.
         * 
         * Default: 4096
         * Group: advanced
         * 
         * @param chunkSize the value to set
         * @return the dsl builder
         */
        default AdvancedHdfsEndpointBuilder chunkSize(String chunkSize) {
            doSetProperty("chunkSize", chunkSize);
            return this;
        }
        /**
         * The compression codec to use.
         * 
         * The option is a:
         * &lt;code&gt;org.apache.camel.component.hdfs.HdfsCompressionCodec&lt;/code&gt; type.
         * 
         * Default: DEFAULT
         * Group: advanced
         * 
         * @param compressionCodec the value to set
         * @return the dsl builder
         */
        default AdvancedHdfsEndpointBuilder compressionCodec(
                org.apache.camel.component.hdfs.HdfsCompressionCodec compressionCodec) {
            doSetProperty("compressionCodec", compressionCodec);
            return this;
        }
        /**
         * The compression codec to use.
         * 
         * The option will be converted to a
         * &lt;code&gt;org.apache.camel.component.hdfs.HdfsCompressionCodec&lt;/code&gt; type.
         * 
         * Default: DEFAULT
         * Group: advanced
         * 
         * @param compressionCodec the value to set
         * @return the dsl builder
         */
        default AdvancedHdfsEndpointBuilder compressionCodec(
                String compressionCodec) {
            doSetProperty("compressionCodec", compressionCodec);
            return this;
        }
        /**
         * The compression type to use (is default not in use).
         * 
         * The option is a:
         * &lt;code&gt;org.apache.camel.component.hdfs.HdfsCompressionType&lt;/code&gt; type.
         * 
         * Default: NONE
         * Group: advanced
         * 
         * @param compressionType the value to set
         * @return the dsl builder
         */
        default AdvancedHdfsEndpointBuilder compressionType(
                org.apache.camel.component.hdfs.HdfsCompressionType compressionType) {
            doSetProperty("compressionType", compressionType);
            return this;
        }
        /**
         * The compression type to use (is default not in use).
         * 
         * The option will be converted to a
         * &lt;code&gt;org.apache.camel.component.hdfs.HdfsCompressionType&lt;/code&gt; type.
         * 
         * Default: NONE
         * Group: advanced
         * 
         * @param compressionType the value to set
         * @return the dsl builder
         */
        default AdvancedHdfsEndpointBuilder compressionType(
                String compressionType) {
            doSetProperty("compressionType", compressionType);
            return this;
        }
        /**
         * When a file is opened for reading/writing the file is renamed with
         * this suffix to avoid to read it during the writing phase.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Default: opened
         * Group: advanced
         * 
         * @param openedSuffix the value to set
         * @return the dsl builder
         */
        default AdvancedHdfsEndpointBuilder openedSuffix(String openedSuffix) {
            doSetProperty("openedSuffix", openedSuffix);
            return this;
        }
        /**
         * Once the file has been read is renamed with this suffix to avoid to
         * read it again.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Default: read
         * Group: advanced
         * 
         * @param readSuffix the value to set
         * @return the dsl builder
         */
        default AdvancedHdfsEndpointBuilder readSuffix(String readSuffix) {
            doSetProperty("readSuffix", readSuffix);
            return this;
        }
        /**
         * The HDFS replication factor.
         * 
         * The option is a: &lt;code&gt;short&lt;/code&gt; type.
         * 
         * Default: 3
         * Group: advanced
         * 
         * @param replication the value to set
         * @return the dsl builder
         */
        default AdvancedHdfsEndpointBuilder replication(short replication) {
            doSetProperty("replication", replication);
            return this;
        }
        /**
         * The HDFS replication factor.
         * 
         * The option will be converted to a &lt;code&gt;short&lt;/code&gt;
         * type.
         * 
         * Default: 3
         * Group: advanced
         * 
         * @param replication the value to set
         * @return the dsl builder
         */
        default AdvancedHdfsEndpointBuilder replication(String replication) {
            doSetProperty("replication", replication);
            return this;
        }
        /**
         * In the current version of Hadoop opening a file in append mode is
         * disabled since it's not very reliable. So, for the moment, it's only
         * possible to create new files. The Camel HDFS endpoint tries to solve
         * this problem in this way: If the split strategy option has been
         * defined, the hdfs path will be used as a directory and files will be
         * created using the configured UuidGenerator. Every time a splitting
         * condition is met, a new file is created. The splitStrategy option is
         * defined as a string with the following syntax:
         * splitStrategy=ST:value,ST:value,... where ST can be: BYTES a new file
         * is created, and the old is closed when the number of written bytes is
         * more than value MESSAGES a new file is created, and the old is closed
         * when the number of written messages is more than value IDLE a new
         * file is created, and the old is closed when no writing happened in
         * the last value milliseconds.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: advanced
         * 
         * @param splitStrategy the value to set
         * @return the dsl builder
         */
        default AdvancedHdfsEndpointBuilder splitStrategy(String splitStrategy) {
            doSetProperty("splitStrategy", splitStrategy);
            return this;
        }
    }

    public interface HdfsBuilders {
        /**
         * HDFS (camel-hdfs)
         * Read and write from/to an HDFS filesystem using Hadoop 2.x.
         * 
         * Category: bigdata,file
         * Since: 2.14
         * Maven coordinates: org.apache.camel:camel-hdfs
         * 
         * @return the dsl builder for the headers' name.
         */
        default HdfsHeaderNameBuilder hdfs() {
            return HdfsHeaderNameBuilder.INSTANCE;
        }
        /**
         * HDFS (camel-hdfs)
         * Read and write from/to an HDFS filesystem using Hadoop 2.x.
         * 
         * Category: bigdata,file
         * Since: 2.14
         * Maven coordinates: org.apache.camel:camel-hdfs
         * 
         * Syntax: <code>hdfs:hostName:port/path</code>
         * 
         * Path parameter: hostName (required)
         * HDFS host to use
         * 
         * Path parameter: port
         * HDFS port to use
         * Default value: 8020
         * 
         * Path parameter: path (required)
         * The directory path to use
         * 
         * @param path hostName:port/path
         * @return the dsl builder
         */
        default HdfsEndpointBuilder hdfs(String path) {
            return HdfsEndpointBuilderFactory.endpointBuilder("hdfs", path);
        }
        /**
         * HDFS (camel-hdfs)
         * Read and write from/to an HDFS filesystem using Hadoop 2.x.
         * 
         * Category: bigdata,file
         * Since: 2.14
         * Maven coordinates: org.apache.camel:camel-hdfs
         * 
         * Syntax: <code>hdfs:hostName:port/path</code>
         * 
         * Path parameter: hostName (required)
         * HDFS host to use
         * 
         * Path parameter: port
         * HDFS port to use
         * Default value: 8020
         * 
         * Path parameter: path (required)
         * The directory path to use
         * 
         * @param componentName to use a custom component name for the endpoint
         * instead of the default name
         * @param path hostName:port/path
         * @return the dsl builder
         */
        default HdfsEndpointBuilder hdfs(String componentName, String path) {
            return HdfsEndpointBuilderFactory.endpointBuilder(componentName, path);
        }
    }

    /**
     * The builder of headers' name for the HDFS component.
     */
    public static class HdfsHeaderNameBuilder {
        /**
         * The internal instance of the builder used to access to all the
         * methods representing the name of headers.
         */
        private static final HdfsHeaderNameBuilder INSTANCE = new HdfsHeaderNameBuilder();

        /**
         * Indicates to close the stream.
         * 
         * The option is a: {@code Boolean} type.
         * 
         * Group: producer
         * 
         * @return the name of the header {@code HdfsClose}.
         */
        public String hdfsClose() {
            return "CamelHdfsClose";
        }

        /**
         * (producer) Specifies the name of the file to write (relative to the
         * endpoint path). The name can be a String or an Expression object.
         * Only relevant when not using a split strategy. (consumer) Specifies
         * the name of the file to read.
         * 
         * The option is a: {@code String} type.
         * 
         * Group: common
         * 
         * @return the name of the header {@code FileName}.
         */
        public String fileName() {
            return "CamelFileName";
        }

        /**
         * The name of the file consumed.
         * 
         * The option is a: {@code String} type.
         * 
         * Group: consumer
         * 
         * @return the name of the header {@code FileNameConsumed}.
         */
        public String fileNameConsumed() {
            return "CamelFileNameConsumed";
        }

        /**
         * The absolute path of the file.
         * 
         * The option is a: {@code String} type.
         * 
         * Group: consumer
         * 
         * @return the name of the header {@code FileAbsolutePath}.
         */
        public String fileAbsolutePath() {
            return "CamelFileAbsolutePath";
        }

        /**
         * The HDFS key.
         * 
         * The option is a: {@code Object} type.
         * 
         * Group: common
         * 
         * @return the name of the header {@code KEY}.
         */
        public String kEY() {
            return "KEY";
        }

        /**
         * The size of the file.
         * 
         * The option is a: {@code Long} type.
         * 
         * Group: consumer
         * 
         * @return the name of the header {@code FileLength}.
         */
        public String fileLength() {
            return "CamelFileLength";
        }
    }
    static HdfsEndpointBuilder endpointBuilder(String componentName, String path) {
        class HdfsEndpointBuilderImpl extends AbstractEndpointBuilder implements HdfsEndpointBuilder, AdvancedHdfsEndpointBuilder {
            public HdfsEndpointBuilderImpl(String path) {
                super(componentName, path);
            }
        }
        return new HdfsEndpointBuilderImpl(path);
    }
}