/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.apache.camel.builder.endpoint.dsl;

import java.util.*;
import java.util.Map;
import java.util.concurrent.*;
import java.util.function.*;
import java.util.stream.*;
import javax.annotation.processing.Generated;
import org.apache.camel.builder.EndpointConsumerBuilder;
import org.apache.camel.builder.EndpointProducerBuilder;
import org.apache.camel.builder.endpoint.AbstractEndpointBuilder;

/**
 * Receive traps and poll SNMP (Simple Network Management Protocol) capable
 * devices.
 * 
 * Generated by camel build tools - do NOT edit this file!
 */
@Generated("org.apache.camel.maven.packaging.EndpointDslMojo")
public interface SnmpEndpointBuilderFactory {


    /**
     * Builder for endpoint consumers for the SNMP component.
     */
    public interface SnmpEndpointConsumerBuilder
            extends
                EndpointConsumerBuilder {
        default AdvancedSnmpEndpointConsumerBuilder advanced() {
            return (AdvancedSnmpEndpointConsumerBuilder) this;
        }
        /**
         * Defines which values you are interested in. Please have a look at the
         * Wikipedia to get a better understanding. You may provide a single OID
         * or a coma separated list of OIDs. Example:
         * oids=1.3.6.1.2.1.1.3.0,1.3.6.1.2.1.25.3.2.1.5.1,1.3.6.1.2.1.25.3.5.1.1.1,1.3.6.1.2.1.43.5.1.1.11.1.
         * 
         * The option is a:
         * &lt;code&gt;org.apache.camel.component.snmp.OIDList&lt;/code&gt;
         * type.
         * 
         * Group: common
         * 
         * @param oids the value to set
         * @return the dsl builder
         */
        default SnmpEndpointConsumerBuilder oids(
                org.apache.camel.component.snmp.OIDList oids) {
            doSetProperty("oids", oids);
            return this;
        }
        /**
         * Defines which values you are interested in. Please have a look at the
         * Wikipedia to get a better understanding. You may provide a single OID
         * or a coma separated list of OIDs. Example:
         * oids=1.3.6.1.2.1.1.3.0,1.3.6.1.2.1.25.3.2.1.5.1,1.3.6.1.2.1.25.3.5.1.1.1,1.3.6.1.2.1.43.5.1.1.11.1.
         * 
         * The option will be converted to a
         * &lt;code&gt;org.apache.camel.component.snmp.OIDList&lt;/code&gt;
         * type.
         * 
         * Group: common
         * 
         * @param oids the value to set
         * @return the dsl builder
         */
        default SnmpEndpointConsumerBuilder oids(String oids) {
            doSetProperty("oids", oids);
            return this;
        }
        /**
         * Here you can select which protocol to use. You can use either udp or
         * tcp.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Default: udp
         * Group: common
         * 
         * @param protocol the value to set
         * @return the dsl builder
         */
        default SnmpEndpointConsumerBuilder protocol(String protocol) {
            doSetProperty("protocol", protocol);
            return this;
        }
        /**
         * Defines how often a retry is made before canceling the request.
         * 
         * The option is a: &lt;code&gt;int&lt;/code&gt; type.
         * 
         * Default: 2
         * Group: common
         * 
         * @param retries the value to set
         * @return the dsl builder
         */
        default SnmpEndpointConsumerBuilder retries(int retries) {
            doSetProperty("retries", retries);
            return this;
        }
        /**
         * Defines how often a retry is made before canceling the request.
         * 
         * The option will be converted to a &lt;code&gt;int&lt;/code&gt; type.
         * 
         * Default: 2
         * Group: common
         * 
         * @param retries the value to set
         * @return the dsl builder
         */
        default SnmpEndpointConsumerBuilder retries(String retries) {
            doSetProperty("retries", retries);
            return this;
        }
        /**
         * Sets the community octet string for the snmp request.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Default: public
         * Group: common
         * 
         * @param snmpCommunity the value to set
         * @return the dsl builder
         */
        default SnmpEndpointConsumerBuilder snmpCommunity(String snmpCommunity) {
            doSetProperty("snmpCommunity", snmpCommunity);
            return this;
        }
        /**
         * Sets the context engine ID field of the scoped PDU.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param snmpContextEngineId the value to set
         * @return the dsl builder
         */
        default SnmpEndpointConsumerBuilder snmpContextEngineId(
                String snmpContextEngineId) {
            doSetProperty("snmpContextEngineId", snmpContextEngineId);
            return this;
        }
        /**
         * Sets the context name field of this scoped PDU.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param snmpContextName the value to set
         * @return the dsl builder
         */
        default SnmpEndpointConsumerBuilder snmpContextName(
                String snmpContextName) {
            doSetProperty("snmpContextName", snmpContextName);
            return this;
        }
        /**
         * Sets the snmp version for the request. The value 0 means SNMPv1, 1
         * means SNMPv2c, and the value 3 means SNMPv3.
         * 
         * The option is a: &lt;code&gt;int&lt;/code&gt; type.
         * 
         * Default: 0
         * Group: common
         * 
         * @param snmpVersion the value to set
         * @return the dsl builder
         */
        default SnmpEndpointConsumerBuilder snmpVersion(int snmpVersion) {
            doSetProperty("snmpVersion", snmpVersion);
            return this;
        }
        /**
         * Sets the snmp version for the request. The value 0 means SNMPv1, 1
         * means SNMPv2c, and the value 3 means SNMPv3.
         * 
         * The option will be converted to a &lt;code&gt;int&lt;/code&gt; type.
         * 
         * Default: 0
         * Group: common
         * 
         * @param snmpVersion the value to set
         * @return the dsl builder
         */
        default SnmpEndpointConsumerBuilder snmpVersion(String snmpVersion) {
            doSetProperty("snmpVersion", snmpVersion);
            return this;
        }
        /**
         * Sets the timeout value for the request in millis.
         * 
         * The option is a: &lt;code&gt;int&lt;/code&gt; type.
         * 
         * Default: 1500
         * Group: common
         * 
         * @param timeout the value to set
         * @return the dsl builder
         */
        default SnmpEndpointConsumerBuilder timeout(int timeout) {
            doSetProperty("timeout", timeout);
            return this;
        }
        /**
         * Sets the timeout value for the request in millis.
         * 
         * The option will be converted to a &lt;code&gt;int&lt;/code&gt; type.
         * 
         * Default: 1500
         * Group: common
         * 
         * @param timeout the value to set
         * @return the dsl builder
         */
        default SnmpEndpointConsumerBuilder timeout(String timeout) {
            doSetProperty("timeout", timeout);
            return this;
        }
        /**
         * Which operation to perform such as poll, trap, etc.
         * 
         * The option is a:
         * &lt;code&gt;org.apache.camel.component.snmp.SnmpActionType&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param type the value to set
         * @return the dsl builder
         */
        default SnmpEndpointConsumerBuilder type(
                org.apache.camel.component.snmp.SnmpActionType type) {
            doSetProperty("type", type);
            return this;
        }
        /**
         * Which operation to perform such as poll, trap, etc.
         * 
         * The option will be converted to a
         * &lt;code&gt;org.apache.camel.component.snmp.SnmpActionType&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param type the value to set
         * @return the dsl builder
         */
        default SnmpEndpointConsumerBuilder type(String type) {
            doSetProperty("type", type);
            return this;
        }
        /**
         * Milliseconds before the next poll.
         * 
         * The option is a: &lt;code&gt;long&lt;/code&gt; type.
         * 
         * Default: 60000
         * Group: consumer
         * 
         * @param delay the value to set
         * @return the dsl builder
         */
        default SnmpEndpointConsumerBuilder delay(long delay) {
            doSetProperty("delay", delay);
            return this;
        }
        /**
         * Milliseconds before the next poll.
         * 
         * The option will be converted to a &lt;code&gt;long&lt;/code&gt; type.
         * 
         * Default: 60000
         * Group: consumer
         * 
         * @param delay the value to set
         * @return the dsl builder
         */
        default SnmpEndpointConsumerBuilder delay(String delay) {
            doSetProperty("delay", delay);
            return this;
        }
        /**
         * If the polling consumer did not poll any files, you can enable this
         * option to send an empty message (no body) instead.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: false
         * Group: consumer
         * 
         * @param sendEmptyMessageWhenIdle the value to set
         * @return the dsl builder
         */
        default SnmpEndpointConsumerBuilder sendEmptyMessageWhenIdle(
                boolean sendEmptyMessageWhenIdle) {
            doSetProperty("sendEmptyMessageWhenIdle", sendEmptyMessageWhenIdle);
            return this;
        }
        /**
         * If the polling consumer did not poll any files, you can enable this
         * option to send an empty message (no body) instead.
         * 
         * The option will be converted to a &lt;code&gt;boolean&lt;/code&gt;
         * type.
         * 
         * Default: false
         * Group: consumer
         * 
         * @param sendEmptyMessageWhenIdle the value to set
         * @return the dsl builder
         */
        default SnmpEndpointConsumerBuilder sendEmptyMessageWhenIdle(
                String sendEmptyMessageWhenIdle) {
            doSetProperty("sendEmptyMessageWhenIdle", sendEmptyMessageWhenIdle);
            return this;
        }
        /**
         * Sets the flag whether the scoped PDU will be displayed as the list if
         * it has child elements in its tree.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: false
         * Group: consumer
         * 
         * @param treeList the value to set
         * @return the dsl builder
         */
        default SnmpEndpointConsumerBuilder treeList(boolean treeList) {
            doSetProperty("treeList", treeList);
            return this;
        }
        /**
         * Sets the flag whether the scoped PDU will be displayed as the list if
         * it has child elements in its tree.
         * 
         * The option will be converted to a &lt;code&gt;boolean&lt;/code&gt;
         * type.
         * 
         * Default: false
         * Group: consumer
         * 
         * @param treeList the value to set
         * @return the dsl builder
         */
        default SnmpEndpointConsumerBuilder treeList(String treeList) {
            doSetProperty("treeList", treeList);
            return this;
        }
        /**
         * The number of subsequent error polls (failed due some error) that
         * should happen before the backoffMultipler should kick-in.
         * 
         * The option is a: &lt;code&gt;int&lt;/code&gt; type.
         * 
         * Group: scheduler
         * 
         * @param backoffErrorThreshold the value to set
         * @return the dsl builder
         */
        default SnmpEndpointConsumerBuilder backoffErrorThreshold(
                int backoffErrorThreshold) {
            doSetProperty("backoffErrorThreshold", backoffErrorThreshold);
            return this;
        }
        /**
         * The number of subsequent error polls (failed due some error) that
         * should happen before the backoffMultipler should kick-in.
         * 
         * The option will be converted to a &lt;code&gt;int&lt;/code&gt; type.
         * 
         * Group: scheduler
         * 
         * @param backoffErrorThreshold the value to set
         * @return the dsl builder
         */
        default SnmpEndpointConsumerBuilder backoffErrorThreshold(
                String backoffErrorThreshold) {
            doSetProperty("backoffErrorThreshold", backoffErrorThreshold);
            return this;
        }
        /**
         * The number of subsequent idle polls that should happen before the
         * backoffMultipler should kick-in.
         * 
         * The option is a: &lt;code&gt;int&lt;/code&gt; type.
         * 
         * Group: scheduler
         * 
         * @param backoffIdleThreshold the value to set
         * @return the dsl builder
         */
        default SnmpEndpointConsumerBuilder backoffIdleThreshold(
                int backoffIdleThreshold) {
            doSetProperty("backoffIdleThreshold", backoffIdleThreshold);
            return this;
        }
        /**
         * The number of subsequent idle polls that should happen before the
         * backoffMultipler should kick-in.
         * 
         * The option will be converted to a &lt;code&gt;int&lt;/code&gt; type.
         * 
         * Group: scheduler
         * 
         * @param backoffIdleThreshold the value to set
         * @return the dsl builder
         */
        default SnmpEndpointConsumerBuilder backoffIdleThreshold(
                String backoffIdleThreshold) {
            doSetProperty("backoffIdleThreshold", backoffIdleThreshold);
            return this;
        }
        /**
         * To let the scheduled polling consumer backoff if there has been a
         * number of subsequent idles/errors in a row. The multiplier is then
         * the number of polls that will be skipped before the next actual
         * attempt is happening again. When this option is in use then
         * backoffIdleThreshold and/or backoffErrorThreshold must also be
         * configured.
         * 
         * The option is a: &lt;code&gt;int&lt;/code&gt; type.
         * 
         * Group: scheduler
         * 
         * @param backoffMultiplier the value to set
         * @return the dsl builder
         */
        default SnmpEndpointConsumerBuilder backoffMultiplier(
                int backoffMultiplier) {
            doSetProperty("backoffMultiplier", backoffMultiplier);
            return this;
        }
        /**
         * To let the scheduled polling consumer backoff if there has been a
         * number of subsequent idles/errors in a row. The multiplier is then
         * the number of polls that will be skipped before the next actual
         * attempt is happening again. When this option is in use then
         * backoffIdleThreshold and/or backoffErrorThreshold must also be
         * configured.
         * 
         * The option will be converted to a &lt;code&gt;int&lt;/code&gt; type.
         * 
         * Group: scheduler
         * 
         * @param backoffMultiplier the value to set
         * @return the dsl builder
         */
        default SnmpEndpointConsumerBuilder backoffMultiplier(
                String backoffMultiplier) {
            doSetProperty("backoffMultiplier", backoffMultiplier);
            return this;
        }
        /**
         * If greedy is enabled, then the ScheduledPollConsumer will run
         * immediately again, if the previous run polled 1 or more messages.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: false
         * Group: scheduler
         * 
         * @param greedy the value to set
         * @return the dsl builder
         */
        default SnmpEndpointConsumerBuilder greedy(boolean greedy) {
            doSetProperty("greedy", greedy);
            return this;
        }
        /**
         * If greedy is enabled, then the ScheduledPollConsumer will run
         * immediately again, if the previous run polled 1 or more messages.
         * 
         * The option will be converted to a &lt;code&gt;boolean&lt;/code&gt;
         * type.
         * 
         * Default: false
         * Group: scheduler
         * 
         * @param greedy the value to set
         * @return the dsl builder
         */
        default SnmpEndpointConsumerBuilder greedy(String greedy) {
            doSetProperty("greedy", greedy);
            return this;
        }
        /**
         * Milliseconds before the first poll starts.
         * 
         * The option is a: &lt;code&gt;long&lt;/code&gt; type.
         * 
         * Default: 1000
         * Group: scheduler
         * 
         * @param initialDelay the value to set
         * @return the dsl builder
         */
        default SnmpEndpointConsumerBuilder initialDelay(long initialDelay) {
            doSetProperty("initialDelay", initialDelay);
            return this;
        }
        /**
         * Milliseconds before the first poll starts.
         * 
         * The option will be converted to a &lt;code&gt;long&lt;/code&gt; type.
         * 
         * Default: 1000
         * Group: scheduler
         * 
         * @param initialDelay the value to set
         * @return the dsl builder
         */
        default SnmpEndpointConsumerBuilder initialDelay(String initialDelay) {
            doSetProperty("initialDelay", initialDelay);
            return this;
        }
        /**
         * Specifies a maximum limit of number of fires. So if you set it to 1,
         * the scheduler will only fire once. If you set it to 5, it will only
         * fire five times. A value of zero or negative means fire forever.
         * 
         * The option is a: &lt;code&gt;long&lt;/code&gt; type.
         * 
         * Default: 0
         * Group: scheduler
         * 
         * @param repeatCount the value to set
         * @return the dsl builder
         */
        default SnmpEndpointConsumerBuilder repeatCount(long repeatCount) {
            doSetProperty("repeatCount", repeatCount);
            return this;
        }
        /**
         * Specifies a maximum limit of number of fires. So if you set it to 1,
         * the scheduler will only fire once. If you set it to 5, it will only
         * fire five times. A value of zero or negative means fire forever.
         * 
         * The option will be converted to a &lt;code&gt;long&lt;/code&gt; type.
         * 
         * Default: 0
         * Group: scheduler
         * 
         * @param repeatCount the value to set
         * @return the dsl builder
         */
        default SnmpEndpointConsumerBuilder repeatCount(String repeatCount) {
            doSetProperty("repeatCount", repeatCount);
            return this;
        }
        /**
         * The consumer logs a start/complete log line when it polls. This
         * option allows you to configure the logging level for that.
         * 
         * The option is a:
         * &lt;code&gt;org.apache.camel.LoggingLevel&lt;/code&gt; type.
         * 
         * Default: TRACE
         * Group: scheduler
         * 
         * @param runLoggingLevel the value to set
         * @return the dsl builder
         */
        default SnmpEndpointConsumerBuilder runLoggingLevel(
                org.apache.camel.LoggingLevel runLoggingLevel) {
            doSetProperty("runLoggingLevel", runLoggingLevel);
            return this;
        }
        /**
         * The consumer logs a start/complete log line when it polls. This
         * option allows you to configure the logging level for that.
         * 
         * The option will be converted to a
         * &lt;code&gt;org.apache.camel.LoggingLevel&lt;/code&gt; type.
         * 
         * Default: TRACE
         * Group: scheduler
         * 
         * @param runLoggingLevel the value to set
         * @return the dsl builder
         */
        default SnmpEndpointConsumerBuilder runLoggingLevel(
                String runLoggingLevel) {
            doSetProperty("runLoggingLevel", runLoggingLevel);
            return this;
        }
        /**
         * Allows for configuring a custom/shared thread pool to use for the
         * consumer. By default each consumer has its own single threaded thread
         * pool.
         * 
         * The option is a:
         * &lt;code&gt;java.util.concurrent.ScheduledExecutorService&lt;/code&gt; type.
         * 
         * Group: scheduler
         * 
         * @param scheduledExecutorService the value to set
         * @return the dsl builder
         */
        default SnmpEndpointConsumerBuilder scheduledExecutorService(
                ScheduledExecutorService scheduledExecutorService) {
            doSetProperty("scheduledExecutorService", scheduledExecutorService);
            return this;
        }
        /**
         * Allows for configuring a custom/shared thread pool to use for the
         * consumer. By default each consumer has its own single threaded thread
         * pool.
         * 
         * The option will be converted to a
         * &lt;code&gt;java.util.concurrent.ScheduledExecutorService&lt;/code&gt; type.
         * 
         * Group: scheduler
         * 
         * @param scheduledExecutorService the value to set
         * @return the dsl builder
         */
        default SnmpEndpointConsumerBuilder scheduledExecutorService(
                String scheduledExecutorService) {
            doSetProperty("scheduledExecutorService", scheduledExecutorService);
            return this;
        }
        /**
         * To use a cron scheduler from either camel-spring or camel-quartz
         * component. Use value spring or quartz for built in scheduler.
         * 
         * The option is a: &lt;code&gt;java.lang.Object&lt;/code&gt; type.
         * 
         * Default: none
         * Group: scheduler
         * 
         * @param scheduler the value to set
         * @return the dsl builder
         */
        default SnmpEndpointConsumerBuilder scheduler(Object scheduler) {
            doSetProperty("scheduler", scheduler);
            return this;
        }
        /**
         * To use a cron scheduler from either camel-spring or camel-quartz
         * component. Use value spring or quartz for built in scheduler.
         * 
         * The option will be converted to a
         * &lt;code&gt;java.lang.Object&lt;/code&gt; type.
         * 
         * Default: none
         * Group: scheduler
         * 
         * @param scheduler the value to set
         * @return the dsl builder
         */
        default SnmpEndpointConsumerBuilder scheduler(String scheduler) {
            doSetProperty("scheduler", scheduler);
            return this;
        }
        /**
         * To configure additional properties when using a custom scheduler or
         * any of the Quartz, Spring based scheduler.
         * 
         * The option is a: &lt;code&gt;java.util.Map&amp;lt;java.lang.String,
         * java.lang.Object&amp;gt;&lt;/code&gt; type.
         * The option is multivalued, and you can use the
         * schedulerProperties(String, Object) method to add a value (call the
         * method multiple times to set more values).
         * 
         * Group: scheduler
         * 
         * @param key the option key
         * @param value the option value
         * @return the dsl builder
         */
        default SnmpEndpointConsumerBuilder schedulerProperties(
                String key,
                Object value) {
            doSetMultiValueProperty("schedulerProperties", "scheduler." + key, value);
            return this;
        }
        /**
         * To configure additional properties when using a custom scheduler or
         * any of the Quartz, Spring based scheduler.
         * 
         * The option is a: &lt;code&gt;java.util.Map&amp;lt;java.lang.String,
         * java.lang.Object&amp;gt;&lt;/code&gt; type.
         * The option is multivalued, and you can use the
         * schedulerProperties(String, Object) method to add a value (call the
         * method multiple times to set more values).
         * 
         * Group: scheduler
         * 
         * @param values the values
         * @return the dsl builder
         */
        default SnmpEndpointConsumerBuilder schedulerProperties(Map values) {
            doSetMultiValueProperties("schedulerProperties", "scheduler.", values);
            return this;
        }
        /**
         * Whether the scheduler should be auto started.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: true
         * Group: scheduler
         * 
         * @param startScheduler the value to set
         * @return the dsl builder
         */
        default SnmpEndpointConsumerBuilder startScheduler(
                boolean startScheduler) {
            doSetProperty("startScheduler", startScheduler);
            return this;
        }
        /**
         * Whether the scheduler should be auto started.
         * 
         * The option will be converted to a &lt;code&gt;boolean&lt;/code&gt;
         * type.
         * 
         * Default: true
         * Group: scheduler
         * 
         * @param startScheduler the value to set
         * @return the dsl builder
         */
        default SnmpEndpointConsumerBuilder startScheduler(String startScheduler) {
            doSetProperty("startScheduler", startScheduler);
            return this;
        }
        /**
         * Time unit for initialDelay and delay options.
         * 
         * The option is a:
         * &lt;code&gt;java.util.concurrent.TimeUnit&lt;/code&gt; type.
         * 
         * Default: MILLISECONDS
         * Group: scheduler
         * 
         * @param timeUnit the value to set
         * @return the dsl builder
         */
        default SnmpEndpointConsumerBuilder timeUnit(TimeUnit timeUnit) {
            doSetProperty("timeUnit", timeUnit);
            return this;
        }
        /**
         * Time unit for initialDelay and delay options.
         * 
         * The option will be converted to a
         * &lt;code&gt;java.util.concurrent.TimeUnit&lt;/code&gt; type.
         * 
         * Default: MILLISECONDS
         * Group: scheduler
         * 
         * @param timeUnit the value to set
         * @return the dsl builder
         */
        default SnmpEndpointConsumerBuilder timeUnit(String timeUnit) {
            doSetProperty("timeUnit", timeUnit);
            return this;
        }
        /**
         * Controls if fixed delay or fixed rate is used. See
         * ScheduledExecutorService in JDK for details.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: true
         * Group: scheduler
         * 
         * @param useFixedDelay the value to set
         * @return the dsl builder
         */
        default SnmpEndpointConsumerBuilder useFixedDelay(boolean useFixedDelay) {
            doSetProperty("useFixedDelay", useFixedDelay);
            return this;
        }
        /**
         * Controls if fixed delay or fixed rate is used. See
         * ScheduledExecutorService in JDK for details.
         * 
         * The option will be converted to a &lt;code&gt;boolean&lt;/code&gt;
         * type.
         * 
         * Default: true
         * Group: scheduler
         * 
         * @param useFixedDelay the value to set
         * @return the dsl builder
         */
        default SnmpEndpointConsumerBuilder useFixedDelay(String useFixedDelay) {
            doSetProperty("useFixedDelay", useFixedDelay);
            return this;
        }
        /**
         * The authentication passphrase. If not null, authenticationProtocol
         * must also be not null. RFC3414 11.2 requires passphrases to have a
         * minimum length of 8 bytes. If the length of authenticationPassphrase
         * is less than 8 bytes an IllegalArgumentException is thrown.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: security
         * 
         * @param authenticationPassphrase the value to set
         * @return the dsl builder
         */
        default SnmpEndpointConsumerBuilder authenticationPassphrase(
                String authenticationPassphrase) {
            doSetProperty("authenticationPassphrase", authenticationPassphrase);
            return this;
        }
        /**
         * Authentication protocol to use if security level is set to enable
         * authentication The possible values are: MD5, SHA1.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: security
         * 
         * @param authenticationProtocol the value to set
         * @return the dsl builder
         */
        default SnmpEndpointConsumerBuilder authenticationProtocol(
                String authenticationProtocol) {
            doSetProperty("authenticationProtocol", authenticationProtocol);
            return this;
        }
        /**
         * The privacy passphrase. If not null, privacyProtocol must also be not
         * null. RFC3414 11.2 requires passphrases to have a minimum length of 8
         * bytes. If the length of authenticationPassphrase is less than 8 bytes
         * an IllegalArgumentException is thrown.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: security
         * 
         * @param privacyPassphrase the value to set
         * @return the dsl builder
         */
        default SnmpEndpointConsumerBuilder privacyPassphrase(
                String privacyPassphrase) {
            doSetProperty("privacyPassphrase", privacyPassphrase);
            return this;
        }
        /**
         * The privacy protocol ID to be associated with this user. If set to
         * null, this user only supports unencrypted messages.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: security
         * 
         * @param privacyProtocol the value to set
         * @return the dsl builder
         */
        default SnmpEndpointConsumerBuilder privacyProtocol(
                String privacyProtocol) {
            doSetProperty("privacyProtocol", privacyProtocol);
            return this;
        }
        /**
         * Sets the security level for this target. The supplied security level
         * must be supported by the security model dependent information
         * associated with the security name set for this target. The value 1
         * means: No authentication and no encryption. Anyone can create and
         * read messages with this security level The value 2 means:
         * Authentication and no encryption. Only the one with the right
         * authentication key can create messages with this security level, but
         * anyone can read the contents of the message. The value 3 means:
         * Authentication and encryption. Only the one with the right
         * authentication key can create messages with this security level, and
         * only the one with the right encryption/decryption key can read the
         * contents of the message.
         * 
         * The option is a: &lt;code&gt;int&lt;/code&gt; type.
         * 
         * Default: 3
         * Group: security
         * 
         * @param securityLevel the value to set
         * @return the dsl builder
         */
        default SnmpEndpointConsumerBuilder securityLevel(int securityLevel) {
            doSetProperty("securityLevel", securityLevel);
            return this;
        }
        /**
         * Sets the security level for this target. The supplied security level
         * must be supported by the security model dependent information
         * associated with the security name set for this target. The value 1
         * means: No authentication and no encryption. Anyone can create and
         * read messages with this security level The value 2 means:
         * Authentication and no encryption. Only the one with the right
         * authentication key can create messages with this security level, but
         * anyone can read the contents of the message. The value 3 means:
         * Authentication and encryption. Only the one with the right
         * authentication key can create messages with this security level, and
         * only the one with the right encryption/decryption key can read the
         * contents of the message.
         * 
         * The option will be converted to a &lt;code&gt;int&lt;/code&gt; type.
         * 
         * Default: 3
         * Group: security
         * 
         * @param securityLevel the value to set
         * @return the dsl builder
         */
        default SnmpEndpointConsumerBuilder securityLevel(String securityLevel) {
            doSetProperty("securityLevel", securityLevel);
            return this;
        }
        /**
         * Sets the security name to be used with this target.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: security
         * 
         * @param securityName the value to set
         * @return the dsl builder
         */
        default SnmpEndpointConsumerBuilder securityName(String securityName) {
            doSetProperty("securityName", securityName);
            return this;
        }
    }

    /**
     * Advanced builder for endpoint consumers for the SNMP component.
     */
    public interface AdvancedSnmpEndpointConsumerBuilder
            extends
                EndpointConsumerBuilder {
        default SnmpEndpointConsumerBuilder basic() {
            return (SnmpEndpointConsumerBuilder) this;
        }
        /**
         * Allows for bridging the consumer to the Camel routing Error Handler,
         * which mean any exceptions occurred while the consumer is trying to
         * pickup incoming messages, or the likes, will now be processed as a
         * message and handled by the routing Error Handler. By default the
         * consumer will use the org.apache.camel.spi.ExceptionHandler to deal
         * with exceptions, that will be logged at WARN or ERROR level and
         * ignored.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: false
         * Group: consumer (advanced)
         * 
         * @param bridgeErrorHandler the value to set
         * @return the dsl builder
         */
        default AdvancedSnmpEndpointConsumerBuilder bridgeErrorHandler(
                boolean bridgeErrorHandler) {
            doSetProperty("bridgeErrorHandler", bridgeErrorHandler);
            return this;
        }
        /**
         * Allows for bridging the consumer to the Camel routing Error Handler,
         * which mean any exceptions occurred while the consumer is trying to
         * pickup incoming messages, or the likes, will now be processed as a
         * message and handled by the routing Error Handler. By default the
         * consumer will use the org.apache.camel.spi.ExceptionHandler to deal
         * with exceptions, that will be logged at WARN or ERROR level and
         * ignored.
         * 
         * The option will be converted to a &lt;code&gt;boolean&lt;/code&gt;
         * type.
         * 
         * Default: false
         * Group: consumer (advanced)
         * 
         * @param bridgeErrorHandler the value to set
         * @return the dsl builder
         */
        default AdvancedSnmpEndpointConsumerBuilder bridgeErrorHandler(
                String bridgeErrorHandler) {
            doSetProperty("bridgeErrorHandler", bridgeErrorHandler);
            return this;
        }
        /**
         * To let the consumer use a custom ExceptionHandler. Notice if the
         * option bridgeErrorHandler is enabled then this option is not in use.
         * By default the consumer will deal with exceptions, that will be
         * logged at WARN or ERROR level and ignored.
         * 
         * The option is a:
         * &lt;code&gt;org.apache.camel.spi.ExceptionHandler&lt;/code&gt; type.
         * 
         * Group: consumer (advanced)
         * 
         * @param exceptionHandler the value to set
         * @return the dsl builder
         */
        default AdvancedSnmpEndpointConsumerBuilder exceptionHandler(
                org.apache.camel.spi.ExceptionHandler exceptionHandler) {
            doSetProperty("exceptionHandler", exceptionHandler);
            return this;
        }
        /**
         * To let the consumer use a custom ExceptionHandler. Notice if the
         * option bridgeErrorHandler is enabled then this option is not in use.
         * By default the consumer will deal with exceptions, that will be
         * logged at WARN or ERROR level and ignored.
         * 
         * The option will be converted to a
         * &lt;code&gt;org.apache.camel.spi.ExceptionHandler&lt;/code&gt; type.
         * 
         * Group: consumer (advanced)
         * 
         * @param exceptionHandler the value to set
         * @return the dsl builder
         */
        default AdvancedSnmpEndpointConsumerBuilder exceptionHandler(
                String exceptionHandler) {
            doSetProperty("exceptionHandler", exceptionHandler);
            return this;
        }
        /**
         * Sets the exchange pattern when the consumer creates an exchange.
         * 
         * The option is a:
         * &lt;code&gt;org.apache.camel.ExchangePattern&lt;/code&gt; type.
         * 
         * Group: consumer (advanced)
         * 
         * @param exchangePattern the value to set
         * @return the dsl builder
         */
        default AdvancedSnmpEndpointConsumerBuilder exchangePattern(
                org.apache.camel.ExchangePattern exchangePattern) {
            doSetProperty("exchangePattern", exchangePattern);
            return this;
        }
        /**
         * Sets the exchange pattern when the consumer creates an exchange.
         * 
         * The option will be converted to a
         * &lt;code&gt;org.apache.camel.ExchangePattern&lt;/code&gt; type.
         * 
         * Group: consumer (advanced)
         * 
         * @param exchangePattern the value to set
         * @return the dsl builder
         */
        default AdvancedSnmpEndpointConsumerBuilder exchangePattern(
                String exchangePattern) {
            doSetProperty("exchangePattern", exchangePattern);
            return this;
        }
        /**
         * A pluggable org.apache.camel.PollingConsumerPollingStrategy allowing
         * you to provide your custom implementation to control error handling
         * usually occurred during the poll operation before an Exchange have
         * been created and being routed in Camel.
         * 
         * The option is a:
         * &lt;code&gt;org.apache.camel.spi.PollingConsumerPollStrategy&lt;/code&gt; type.
         * 
         * Group: consumer (advanced)
         * 
         * @param pollStrategy the value to set
         * @return the dsl builder
         */
        default AdvancedSnmpEndpointConsumerBuilder pollStrategy(
                org.apache.camel.spi.PollingConsumerPollStrategy pollStrategy) {
            doSetProperty("pollStrategy", pollStrategy);
            return this;
        }
        /**
         * A pluggable org.apache.camel.PollingConsumerPollingStrategy allowing
         * you to provide your custom implementation to control error handling
         * usually occurred during the poll operation before an Exchange have
         * been created and being routed in Camel.
         * 
         * The option will be converted to a
         * &lt;code&gt;org.apache.camel.spi.PollingConsumerPollStrategy&lt;/code&gt; type.
         * 
         * Group: consumer (advanced)
         * 
         * @param pollStrategy the value to set
         * @return the dsl builder
         */
        default AdvancedSnmpEndpointConsumerBuilder pollStrategy(
                String pollStrategy) {
            doSetProperty("pollStrategy", pollStrategy);
            return this;
        }
    }

    /**
     * Builder for endpoint producers for the SNMP component.
     */
    public interface SnmpEndpointProducerBuilder
            extends
                EndpointProducerBuilder {
        default AdvancedSnmpEndpointProducerBuilder advanced() {
            return (AdvancedSnmpEndpointProducerBuilder) this;
        }
        /**
         * Defines which values you are interested in. Please have a look at the
         * Wikipedia to get a better understanding. You may provide a single OID
         * or a coma separated list of OIDs. Example:
         * oids=1.3.6.1.2.1.1.3.0,1.3.6.1.2.1.25.3.2.1.5.1,1.3.6.1.2.1.25.3.5.1.1.1,1.3.6.1.2.1.43.5.1.1.11.1.
         * 
         * The option is a:
         * &lt;code&gt;org.apache.camel.component.snmp.OIDList&lt;/code&gt;
         * type.
         * 
         * Group: common
         * 
         * @param oids the value to set
         * @return the dsl builder
         */
        default SnmpEndpointProducerBuilder oids(
                org.apache.camel.component.snmp.OIDList oids) {
            doSetProperty("oids", oids);
            return this;
        }
        /**
         * Defines which values you are interested in. Please have a look at the
         * Wikipedia to get a better understanding. You may provide a single OID
         * or a coma separated list of OIDs. Example:
         * oids=1.3.6.1.2.1.1.3.0,1.3.6.1.2.1.25.3.2.1.5.1,1.3.6.1.2.1.25.3.5.1.1.1,1.3.6.1.2.1.43.5.1.1.11.1.
         * 
         * The option will be converted to a
         * &lt;code&gt;org.apache.camel.component.snmp.OIDList&lt;/code&gt;
         * type.
         * 
         * Group: common
         * 
         * @param oids the value to set
         * @return the dsl builder
         */
        default SnmpEndpointProducerBuilder oids(String oids) {
            doSetProperty("oids", oids);
            return this;
        }
        /**
         * Here you can select which protocol to use. You can use either udp or
         * tcp.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Default: udp
         * Group: common
         * 
         * @param protocol the value to set
         * @return the dsl builder
         */
        default SnmpEndpointProducerBuilder protocol(String protocol) {
            doSetProperty("protocol", protocol);
            return this;
        }
        /**
         * Defines how often a retry is made before canceling the request.
         * 
         * The option is a: &lt;code&gt;int&lt;/code&gt; type.
         * 
         * Default: 2
         * Group: common
         * 
         * @param retries the value to set
         * @return the dsl builder
         */
        default SnmpEndpointProducerBuilder retries(int retries) {
            doSetProperty("retries", retries);
            return this;
        }
        /**
         * Defines how often a retry is made before canceling the request.
         * 
         * The option will be converted to a &lt;code&gt;int&lt;/code&gt; type.
         * 
         * Default: 2
         * Group: common
         * 
         * @param retries the value to set
         * @return the dsl builder
         */
        default SnmpEndpointProducerBuilder retries(String retries) {
            doSetProperty("retries", retries);
            return this;
        }
        /**
         * Sets the community octet string for the snmp request.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Default: public
         * Group: common
         * 
         * @param snmpCommunity the value to set
         * @return the dsl builder
         */
        default SnmpEndpointProducerBuilder snmpCommunity(String snmpCommunity) {
            doSetProperty("snmpCommunity", snmpCommunity);
            return this;
        }
        /**
         * Sets the context engine ID field of the scoped PDU.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param snmpContextEngineId the value to set
         * @return the dsl builder
         */
        default SnmpEndpointProducerBuilder snmpContextEngineId(
                String snmpContextEngineId) {
            doSetProperty("snmpContextEngineId", snmpContextEngineId);
            return this;
        }
        /**
         * Sets the context name field of this scoped PDU.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param snmpContextName the value to set
         * @return the dsl builder
         */
        default SnmpEndpointProducerBuilder snmpContextName(
                String snmpContextName) {
            doSetProperty("snmpContextName", snmpContextName);
            return this;
        }
        /**
         * Sets the snmp version for the request. The value 0 means SNMPv1, 1
         * means SNMPv2c, and the value 3 means SNMPv3.
         * 
         * The option is a: &lt;code&gt;int&lt;/code&gt; type.
         * 
         * Default: 0
         * Group: common
         * 
         * @param snmpVersion the value to set
         * @return the dsl builder
         */
        default SnmpEndpointProducerBuilder snmpVersion(int snmpVersion) {
            doSetProperty("snmpVersion", snmpVersion);
            return this;
        }
        /**
         * Sets the snmp version for the request. The value 0 means SNMPv1, 1
         * means SNMPv2c, and the value 3 means SNMPv3.
         * 
         * The option will be converted to a &lt;code&gt;int&lt;/code&gt; type.
         * 
         * Default: 0
         * Group: common
         * 
         * @param snmpVersion the value to set
         * @return the dsl builder
         */
        default SnmpEndpointProducerBuilder snmpVersion(String snmpVersion) {
            doSetProperty("snmpVersion", snmpVersion);
            return this;
        }
        /**
         * Sets the timeout value for the request in millis.
         * 
         * The option is a: &lt;code&gt;int&lt;/code&gt; type.
         * 
         * Default: 1500
         * Group: common
         * 
         * @param timeout the value to set
         * @return the dsl builder
         */
        default SnmpEndpointProducerBuilder timeout(int timeout) {
            doSetProperty("timeout", timeout);
            return this;
        }
        /**
         * Sets the timeout value for the request in millis.
         * 
         * The option will be converted to a &lt;code&gt;int&lt;/code&gt; type.
         * 
         * Default: 1500
         * Group: common
         * 
         * @param timeout the value to set
         * @return the dsl builder
         */
        default SnmpEndpointProducerBuilder timeout(String timeout) {
            doSetProperty("timeout", timeout);
            return this;
        }
        /**
         * Which operation to perform such as poll, trap, etc.
         * 
         * The option is a:
         * &lt;code&gt;org.apache.camel.component.snmp.SnmpActionType&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param type the value to set
         * @return the dsl builder
         */
        default SnmpEndpointProducerBuilder type(
                org.apache.camel.component.snmp.SnmpActionType type) {
            doSetProperty("type", type);
            return this;
        }
        /**
         * Which operation to perform such as poll, trap, etc.
         * 
         * The option will be converted to a
         * &lt;code&gt;org.apache.camel.component.snmp.SnmpActionType&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param type the value to set
         * @return the dsl builder
         */
        default SnmpEndpointProducerBuilder type(String type) {
            doSetProperty("type", type);
            return this;
        }
        /**
         * The authentication passphrase. If not null, authenticationProtocol
         * must also be not null. RFC3414 11.2 requires passphrases to have a
         * minimum length of 8 bytes. If the length of authenticationPassphrase
         * is less than 8 bytes an IllegalArgumentException is thrown.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: security
         * 
         * @param authenticationPassphrase the value to set
         * @return the dsl builder
         */
        default SnmpEndpointProducerBuilder authenticationPassphrase(
                String authenticationPassphrase) {
            doSetProperty("authenticationPassphrase", authenticationPassphrase);
            return this;
        }
        /**
         * Authentication protocol to use if security level is set to enable
         * authentication The possible values are: MD5, SHA1.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: security
         * 
         * @param authenticationProtocol the value to set
         * @return the dsl builder
         */
        default SnmpEndpointProducerBuilder authenticationProtocol(
                String authenticationProtocol) {
            doSetProperty("authenticationProtocol", authenticationProtocol);
            return this;
        }
        /**
         * The privacy passphrase. If not null, privacyProtocol must also be not
         * null. RFC3414 11.2 requires passphrases to have a minimum length of 8
         * bytes. If the length of authenticationPassphrase is less than 8 bytes
         * an IllegalArgumentException is thrown.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: security
         * 
         * @param privacyPassphrase the value to set
         * @return the dsl builder
         */
        default SnmpEndpointProducerBuilder privacyPassphrase(
                String privacyPassphrase) {
            doSetProperty("privacyPassphrase", privacyPassphrase);
            return this;
        }
        /**
         * The privacy protocol ID to be associated with this user. If set to
         * null, this user only supports unencrypted messages.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: security
         * 
         * @param privacyProtocol the value to set
         * @return the dsl builder
         */
        default SnmpEndpointProducerBuilder privacyProtocol(
                String privacyProtocol) {
            doSetProperty("privacyProtocol", privacyProtocol);
            return this;
        }
        /**
         * Sets the security level for this target. The supplied security level
         * must be supported by the security model dependent information
         * associated with the security name set for this target. The value 1
         * means: No authentication and no encryption. Anyone can create and
         * read messages with this security level The value 2 means:
         * Authentication and no encryption. Only the one with the right
         * authentication key can create messages with this security level, but
         * anyone can read the contents of the message. The value 3 means:
         * Authentication and encryption. Only the one with the right
         * authentication key can create messages with this security level, and
         * only the one with the right encryption/decryption key can read the
         * contents of the message.
         * 
         * The option is a: &lt;code&gt;int&lt;/code&gt; type.
         * 
         * Default: 3
         * Group: security
         * 
         * @param securityLevel the value to set
         * @return the dsl builder
         */
        default SnmpEndpointProducerBuilder securityLevel(int securityLevel) {
            doSetProperty("securityLevel", securityLevel);
            return this;
        }
        /**
         * Sets the security level for this target. The supplied security level
         * must be supported by the security model dependent information
         * associated with the security name set for this target. The value 1
         * means: No authentication and no encryption. Anyone can create and
         * read messages with this security level The value 2 means:
         * Authentication and no encryption. Only the one with the right
         * authentication key can create messages with this security level, but
         * anyone can read the contents of the message. The value 3 means:
         * Authentication and encryption. Only the one with the right
         * authentication key can create messages with this security level, and
         * only the one with the right encryption/decryption key can read the
         * contents of the message.
         * 
         * The option will be converted to a &lt;code&gt;int&lt;/code&gt; type.
         * 
         * Default: 3
         * Group: security
         * 
         * @param securityLevel the value to set
         * @return the dsl builder
         */
        default SnmpEndpointProducerBuilder securityLevel(String securityLevel) {
            doSetProperty("securityLevel", securityLevel);
            return this;
        }
        /**
         * Sets the security name to be used with this target.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: security
         * 
         * @param securityName the value to set
         * @return the dsl builder
         */
        default SnmpEndpointProducerBuilder securityName(String securityName) {
            doSetProperty("securityName", securityName);
            return this;
        }
    }

    /**
     * Advanced builder for endpoint producers for the SNMP component.
     */
    public interface AdvancedSnmpEndpointProducerBuilder
            extends
                EndpointProducerBuilder {
        default SnmpEndpointProducerBuilder basic() {
            return (SnmpEndpointProducerBuilder) this;
        }
        /**
         * Whether the producer should be started lazy (on the first message).
         * By starting lazy you can use this to allow CamelContext and routes to
         * startup in situations where a producer may otherwise fail during
         * starting and cause the route to fail being started. By deferring this
         * startup to be lazy then the startup failure can be handled during
         * routing messages via Camel's routing error handlers. Beware that when
         * the first message is processed then creating and starting the
         * producer may take a little time and prolong the total processing time
         * of the processing.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: false
         * Group: producer (advanced)
         * 
         * @param lazyStartProducer the value to set
         * @return the dsl builder
         */
        default AdvancedSnmpEndpointProducerBuilder lazyStartProducer(
                boolean lazyStartProducer) {
            doSetProperty("lazyStartProducer", lazyStartProducer);
            return this;
        }
        /**
         * Whether the producer should be started lazy (on the first message).
         * By starting lazy you can use this to allow CamelContext and routes to
         * startup in situations where a producer may otherwise fail during
         * starting and cause the route to fail being started. By deferring this
         * startup to be lazy then the startup failure can be handled during
         * routing messages via Camel's routing error handlers. Beware that when
         * the first message is processed then creating and starting the
         * producer may take a little time and prolong the total processing time
         * of the processing.
         * 
         * The option will be converted to a &lt;code&gt;boolean&lt;/code&gt;
         * type.
         * 
         * Default: false
         * Group: producer (advanced)
         * 
         * @param lazyStartProducer the value to set
         * @return the dsl builder
         */
        default AdvancedSnmpEndpointProducerBuilder lazyStartProducer(
                String lazyStartProducer) {
            doSetProperty("lazyStartProducer", lazyStartProducer);
            return this;
        }
    }

    /**
     * Builder for endpoint for the SNMP component.
     */
    public interface SnmpEndpointBuilder
            extends
                SnmpEndpointConsumerBuilder,
                SnmpEndpointProducerBuilder {
        default AdvancedSnmpEndpointBuilder advanced() {
            return (AdvancedSnmpEndpointBuilder) this;
        }
        /**
         * Defines which values you are interested in. Please have a look at the
         * Wikipedia to get a better understanding. You may provide a single OID
         * or a coma separated list of OIDs. Example:
         * oids=1.3.6.1.2.1.1.3.0,1.3.6.1.2.1.25.3.2.1.5.1,1.3.6.1.2.1.25.3.5.1.1.1,1.3.6.1.2.1.43.5.1.1.11.1.
         * 
         * The option is a:
         * &lt;code&gt;org.apache.camel.component.snmp.OIDList&lt;/code&gt;
         * type.
         * 
         * Group: common
         * 
         * @param oids the value to set
         * @return the dsl builder
         */
        default SnmpEndpointBuilder oids(
                org.apache.camel.component.snmp.OIDList oids) {
            doSetProperty("oids", oids);
            return this;
        }
        /**
         * Defines which values you are interested in. Please have a look at the
         * Wikipedia to get a better understanding. You may provide a single OID
         * or a coma separated list of OIDs. Example:
         * oids=1.3.6.1.2.1.1.3.0,1.3.6.1.2.1.25.3.2.1.5.1,1.3.6.1.2.1.25.3.5.1.1.1,1.3.6.1.2.1.43.5.1.1.11.1.
         * 
         * The option will be converted to a
         * &lt;code&gt;org.apache.camel.component.snmp.OIDList&lt;/code&gt;
         * type.
         * 
         * Group: common
         * 
         * @param oids the value to set
         * @return the dsl builder
         */
        default SnmpEndpointBuilder oids(String oids) {
            doSetProperty("oids", oids);
            return this;
        }
        /**
         * Here you can select which protocol to use. You can use either udp or
         * tcp.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Default: udp
         * Group: common
         * 
         * @param protocol the value to set
         * @return the dsl builder
         */
        default SnmpEndpointBuilder protocol(String protocol) {
            doSetProperty("protocol", protocol);
            return this;
        }
        /**
         * Defines how often a retry is made before canceling the request.
         * 
         * The option is a: &lt;code&gt;int&lt;/code&gt; type.
         * 
         * Default: 2
         * Group: common
         * 
         * @param retries the value to set
         * @return the dsl builder
         */
        default SnmpEndpointBuilder retries(int retries) {
            doSetProperty("retries", retries);
            return this;
        }
        /**
         * Defines how often a retry is made before canceling the request.
         * 
         * The option will be converted to a &lt;code&gt;int&lt;/code&gt; type.
         * 
         * Default: 2
         * Group: common
         * 
         * @param retries the value to set
         * @return the dsl builder
         */
        default SnmpEndpointBuilder retries(String retries) {
            doSetProperty("retries", retries);
            return this;
        }
        /**
         * Sets the community octet string for the snmp request.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Default: public
         * Group: common
         * 
         * @param snmpCommunity the value to set
         * @return the dsl builder
         */
        default SnmpEndpointBuilder snmpCommunity(String snmpCommunity) {
            doSetProperty("snmpCommunity", snmpCommunity);
            return this;
        }
        /**
         * Sets the context engine ID field of the scoped PDU.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param snmpContextEngineId the value to set
         * @return the dsl builder
         */
        default SnmpEndpointBuilder snmpContextEngineId(
                String snmpContextEngineId) {
            doSetProperty("snmpContextEngineId", snmpContextEngineId);
            return this;
        }
        /**
         * Sets the context name field of this scoped PDU.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param snmpContextName the value to set
         * @return the dsl builder
         */
        default SnmpEndpointBuilder snmpContextName(String snmpContextName) {
            doSetProperty("snmpContextName", snmpContextName);
            return this;
        }
        /**
         * Sets the snmp version for the request. The value 0 means SNMPv1, 1
         * means SNMPv2c, and the value 3 means SNMPv3.
         * 
         * The option is a: &lt;code&gt;int&lt;/code&gt; type.
         * 
         * Default: 0
         * Group: common
         * 
         * @param snmpVersion the value to set
         * @return the dsl builder
         */
        default SnmpEndpointBuilder snmpVersion(int snmpVersion) {
            doSetProperty("snmpVersion", snmpVersion);
            return this;
        }
        /**
         * Sets the snmp version for the request. The value 0 means SNMPv1, 1
         * means SNMPv2c, and the value 3 means SNMPv3.
         * 
         * The option will be converted to a &lt;code&gt;int&lt;/code&gt; type.
         * 
         * Default: 0
         * Group: common
         * 
         * @param snmpVersion the value to set
         * @return the dsl builder
         */
        default SnmpEndpointBuilder snmpVersion(String snmpVersion) {
            doSetProperty("snmpVersion", snmpVersion);
            return this;
        }
        /**
         * Sets the timeout value for the request in millis.
         * 
         * The option is a: &lt;code&gt;int&lt;/code&gt; type.
         * 
         * Default: 1500
         * Group: common
         * 
         * @param timeout the value to set
         * @return the dsl builder
         */
        default SnmpEndpointBuilder timeout(int timeout) {
            doSetProperty("timeout", timeout);
            return this;
        }
        /**
         * Sets the timeout value for the request in millis.
         * 
         * The option will be converted to a &lt;code&gt;int&lt;/code&gt; type.
         * 
         * Default: 1500
         * Group: common
         * 
         * @param timeout the value to set
         * @return the dsl builder
         */
        default SnmpEndpointBuilder timeout(String timeout) {
            doSetProperty("timeout", timeout);
            return this;
        }
        /**
         * Which operation to perform such as poll, trap, etc.
         * 
         * The option is a:
         * &lt;code&gt;org.apache.camel.component.snmp.SnmpActionType&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param type the value to set
         * @return the dsl builder
         */
        default SnmpEndpointBuilder type(
                org.apache.camel.component.snmp.SnmpActionType type) {
            doSetProperty("type", type);
            return this;
        }
        /**
         * Which operation to perform such as poll, trap, etc.
         * 
         * The option will be converted to a
         * &lt;code&gt;org.apache.camel.component.snmp.SnmpActionType&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param type the value to set
         * @return the dsl builder
         */
        default SnmpEndpointBuilder type(String type) {
            doSetProperty("type", type);
            return this;
        }
        /**
         * The authentication passphrase. If not null, authenticationProtocol
         * must also be not null. RFC3414 11.2 requires passphrases to have a
         * minimum length of 8 bytes. If the length of authenticationPassphrase
         * is less than 8 bytes an IllegalArgumentException is thrown.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: security
         * 
         * @param authenticationPassphrase the value to set
         * @return the dsl builder
         */
        default SnmpEndpointBuilder authenticationPassphrase(
                String authenticationPassphrase) {
            doSetProperty("authenticationPassphrase", authenticationPassphrase);
            return this;
        }
        /**
         * Authentication protocol to use if security level is set to enable
         * authentication The possible values are: MD5, SHA1.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: security
         * 
         * @param authenticationProtocol the value to set
         * @return the dsl builder
         */
        default SnmpEndpointBuilder authenticationProtocol(
                String authenticationProtocol) {
            doSetProperty("authenticationProtocol", authenticationProtocol);
            return this;
        }
        /**
         * The privacy passphrase. If not null, privacyProtocol must also be not
         * null. RFC3414 11.2 requires passphrases to have a minimum length of 8
         * bytes. If the length of authenticationPassphrase is less than 8 bytes
         * an IllegalArgumentException is thrown.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: security
         * 
         * @param privacyPassphrase the value to set
         * @return the dsl builder
         */
        default SnmpEndpointBuilder privacyPassphrase(String privacyPassphrase) {
            doSetProperty("privacyPassphrase", privacyPassphrase);
            return this;
        }
        /**
         * The privacy protocol ID to be associated with this user. If set to
         * null, this user only supports unencrypted messages.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: security
         * 
         * @param privacyProtocol the value to set
         * @return the dsl builder
         */
        default SnmpEndpointBuilder privacyProtocol(String privacyProtocol) {
            doSetProperty("privacyProtocol", privacyProtocol);
            return this;
        }
        /**
         * Sets the security level for this target. The supplied security level
         * must be supported by the security model dependent information
         * associated with the security name set for this target. The value 1
         * means: No authentication and no encryption. Anyone can create and
         * read messages with this security level The value 2 means:
         * Authentication and no encryption. Only the one with the right
         * authentication key can create messages with this security level, but
         * anyone can read the contents of the message. The value 3 means:
         * Authentication and encryption. Only the one with the right
         * authentication key can create messages with this security level, and
         * only the one with the right encryption/decryption key can read the
         * contents of the message.
         * 
         * The option is a: &lt;code&gt;int&lt;/code&gt; type.
         * 
         * Default: 3
         * Group: security
         * 
         * @param securityLevel the value to set
         * @return the dsl builder
         */
        default SnmpEndpointBuilder securityLevel(int securityLevel) {
            doSetProperty("securityLevel", securityLevel);
            return this;
        }
        /**
         * Sets the security level for this target. The supplied security level
         * must be supported by the security model dependent information
         * associated with the security name set for this target. The value 1
         * means: No authentication and no encryption. Anyone can create and
         * read messages with this security level The value 2 means:
         * Authentication and no encryption. Only the one with the right
         * authentication key can create messages with this security level, but
         * anyone can read the contents of the message. The value 3 means:
         * Authentication and encryption. Only the one with the right
         * authentication key can create messages with this security level, and
         * only the one with the right encryption/decryption key can read the
         * contents of the message.
         * 
         * The option will be converted to a &lt;code&gt;int&lt;/code&gt; type.
         * 
         * Default: 3
         * Group: security
         * 
         * @param securityLevel the value to set
         * @return the dsl builder
         */
        default SnmpEndpointBuilder securityLevel(String securityLevel) {
            doSetProperty("securityLevel", securityLevel);
            return this;
        }
        /**
         * Sets the security name to be used with this target.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: security
         * 
         * @param securityName the value to set
         * @return the dsl builder
         */
        default SnmpEndpointBuilder securityName(String securityName) {
            doSetProperty("securityName", securityName);
            return this;
        }
    }

    /**
     * Advanced builder for endpoint for the SNMP component.
     */
    public interface AdvancedSnmpEndpointBuilder
            extends
                AdvancedSnmpEndpointConsumerBuilder,
                AdvancedSnmpEndpointProducerBuilder {
        default SnmpEndpointBuilder basic() {
            return (SnmpEndpointBuilder) this;
        }
    }

    public interface SnmpBuilders {
        /**
         * SNMP (camel-snmp)
         * Receive traps and poll SNMP (Simple Network Management Protocol)
         * capable devices.
         * 
         * Category: monitoring
         * Since: 2.1
         * Maven coordinates: org.apache.camel:camel-snmp
         * 
         * Syntax: <code>snmp:host:port</code>
         * 
         * Path parameter: host (required)
         * Hostname of the SNMP enabled device
         * 
         * Path parameter: port (required)
         * Port number of the SNMP enabled device
         * 
         * @param path host:port
         * @return the dsl builder
         */
        default SnmpEndpointBuilder snmp(String path) {
            return SnmpEndpointBuilderFactory.endpointBuilder("snmp", path);
        }
        /**
         * SNMP (camel-snmp)
         * Receive traps and poll SNMP (Simple Network Management Protocol)
         * capable devices.
         * 
         * Category: monitoring
         * Since: 2.1
         * Maven coordinates: org.apache.camel:camel-snmp
         * 
         * Syntax: <code>snmp:host:port</code>
         * 
         * Path parameter: host (required)
         * Hostname of the SNMP enabled device
         * 
         * Path parameter: port (required)
         * Port number of the SNMP enabled device
         * 
         * @param componentName to use a custom component name for the endpoint
         * instead of the default name
         * @param path host:port
         * @return the dsl builder
         */
        default SnmpEndpointBuilder snmp(String componentName, String path) {
            return SnmpEndpointBuilderFactory.endpointBuilder(componentName, path);
        }
    }
    static SnmpEndpointBuilder endpointBuilder(String componentName, String path) {
        class SnmpEndpointBuilderImpl extends AbstractEndpointBuilder implements SnmpEndpointBuilder, AdvancedSnmpEndpointBuilder {
            public SnmpEndpointBuilderImpl(String path) {
                super(componentName, path);
            }
        }
        return new SnmpEndpointBuilderImpl(path);
    }
}