/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.apache.camel.builder.endpoint.dsl;

import java.util.*;
import java.util.Map;
import java.util.concurrent.*;
import java.util.function.*;
import java.util.stream.*;
import javax.annotation.processing.Generated;
import org.apache.camel.builder.EndpointConsumerBuilder;
import org.apache.camel.builder.EndpointProducerBuilder;
import org.apache.camel.builder.endpoint.AbstractEndpointBuilder;

/**
 * Netty HTTP server and client using the Netty 4.x.
 * 
 * Generated by camel build tools - do NOT edit this file!
 */
@Generated("org.apache.camel.maven.packaging.EndpointDslMojo")
public interface NettyHttpEndpointBuilderFactory {


    /**
     * Builder for endpoint consumers for the Netty HTTP component.
     */
    public interface NettyHttpEndpointConsumerBuilder
            extends
                EndpointConsumerBuilder {
        default AdvancedNettyHttpEndpointConsumerBuilder advanced() {
            return (AdvancedNettyHttpEndpointConsumerBuilder) this;
        }
        /**
         * If the option is true, the producer will ignore the
         * NettyHttpConstants.HTTP_URI header, and use the endpoint's URI for
         * request. You may also set the throwExceptionOnFailure to be false to
         * let the producer send all the fault response back. The consumer
         * working in the bridge mode will skip the gzip compression and WWW URL
         * form encoding (by adding the Exchange.SKIP_GZIP_ENCODING and
         * Exchange.SKIP_WWW_FORM_URLENCODED headers to the consumed exchange).
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: false
         * Group: common
         * 
         * @param bridgeEndpoint the value to set
         * @return the dsl builder
         */
        default NettyHttpEndpointConsumerBuilder bridgeEndpoint(
                boolean bridgeEndpoint) {
            doSetProperty("bridgeEndpoint", bridgeEndpoint);
            return this;
        }
        /**
         * If the option is true, the producer will ignore the
         * NettyHttpConstants.HTTP_URI header, and use the endpoint's URI for
         * request. You may also set the throwExceptionOnFailure to be false to
         * let the producer send all the fault response back. The consumer
         * working in the bridge mode will skip the gzip compression and WWW URL
         * form encoding (by adding the Exchange.SKIP_GZIP_ENCODING and
         * Exchange.SKIP_WWW_FORM_URLENCODED headers to the consumed exchange).
         * 
         * The option will be converted to a &lt;code&gt;boolean&lt;/code&gt;
         * type.
         * 
         * Default: false
         * Group: common
         * 
         * @param bridgeEndpoint the value to set
         * @return the dsl builder
         */
        default NettyHttpEndpointConsumerBuilder bridgeEndpoint(
                String bridgeEndpoint) {
            doSetProperty("bridgeEndpoint", bridgeEndpoint);
            return this;
        }
        /**
         * Whether or not to disconnect(close) from Netty Channel right after
         * use. Can be used for both consumer and producer.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: false
         * Group: common
         * 
         * @param disconnect the value to set
         * @return the dsl builder
         */
        default NettyHttpEndpointConsumerBuilder disconnect(boolean disconnect) {
            doSetProperty("disconnect", disconnect);
            return this;
        }
        /**
         * Whether or not to disconnect(close) from Netty Channel right after
         * use. Can be used for both consumer and producer.
         * 
         * The option will be converted to a &lt;code&gt;boolean&lt;/code&gt;
         * type.
         * 
         * Default: false
         * Group: common
         * 
         * @param disconnect the value to set
         * @return the dsl builder
         */
        default NettyHttpEndpointConsumerBuilder disconnect(String disconnect) {
            doSetProperty("disconnect", disconnect);
            return this;
        }
        /**
         * Setting to ensure socket is not closed due to inactivity.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: true
         * Group: common
         * 
         * @param keepAlive the value to set
         * @return the dsl builder
         */
        default NettyHttpEndpointConsumerBuilder keepAlive(boolean keepAlive) {
            doSetProperty("keepAlive", keepAlive);
            return this;
        }
        /**
         * Setting to ensure socket is not closed due to inactivity.
         * 
         * The option will be converted to a &lt;code&gt;boolean&lt;/code&gt;
         * type.
         * 
         * Default: true
         * Group: common
         * 
         * @param keepAlive the value to set
         * @return the dsl builder
         */
        default NettyHttpEndpointConsumerBuilder keepAlive(String keepAlive) {
            doSetProperty("keepAlive", keepAlive);
            return this;
        }
        /**
         * Setting to facilitate socket multiplexing.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: true
         * Group: common
         * 
         * @param reuseAddress the value to set
         * @return the dsl builder
         */
        default NettyHttpEndpointConsumerBuilder reuseAddress(
                boolean reuseAddress) {
            doSetProperty("reuseAddress", reuseAddress);
            return this;
        }
        /**
         * Setting to facilitate socket multiplexing.
         * 
         * The option will be converted to a &lt;code&gt;boolean&lt;/code&gt;
         * type.
         * 
         * Default: true
         * Group: common
         * 
         * @param reuseAddress the value to set
         * @return the dsl builder
         */
        default NettyHttpEndpointConsumerBuilder reuseAddress(
                String reuseAddress) {
            doSetProperty("reuseAddress", reuseAddress);
            return this;
        }
        /**
         * This option allows producers and consumers (in client mode) to reuse
         * the same Netty Channel for the lifecycle of processing the Exchange.
         * This is useful if you need to call a server multiple times in a Camel
         * route and want to use the same network connection. When using this,
         * the channel is not returned to the connection pool until the Exchange
         * is done; or disconnected if the disconnect option is set to true. The
         * reused Channel is stored on the Exchange as an exchange property with
         * the key NettyConstants#NETTY_CHANNEL which allows you to obtain the
         * channel during routing and use it as well.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: false
         * Group: common
         * 
         * @param reuseChannel the value to set
         * @return the dsl builder
         */
        default NettyHttpEndpointConsumerBuilder reuseChannel(
                boolean reuseChannel) {
            doSetProperty("reuseChannel", reuseChannel);
            return this;
        }
        /**
         * This option allows producers and consumers (in client mode) to reuse
         * the same Netty Channel for the lifecycle of processing the Exchange.
         * This is useful if you need to call a server multiple times in a Camel
         * route and want to use the same network connection. When using this,
         * the channel is not returned to the connection pool until the Exchange
         * is done; or disconnected if the disconnect option is set to true. The
         * reused Channel is stored on the Exchange as an exchange property with
         * the key NettyConstants#NETTY_CHANNEL which allows you to obtain the
         * channel during routing and use it as well.
         * 
         * The option will be converted to a &lt;code&gt;boolean&lt;/code&gt;
         * type.
         * 
         * Default: false
         * Group: common
         * 
         * @param reuseChannel the value to set
         * @return the dsl builder
         */
        default NettyHttpEndpointConsumerBuilder reuseChannel(
                String reuseChannel) {
            doSetProperty("reuseChannel", reuseChannel);
            return this;
        }
        /**
         * Setting to set endpoint as one-way or request-response.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: true
         * Group: common
         * 
         * @param sync the value to set
         * @return the dsl builder
         */
        default NettyHttpEndpointConsumerBuilder sync(boolean sync) {
            doSetProperty("sync", sync);
            return this;
        }
        /**
         * Setting to set endpoint as one-way or request-response.
         * 
         * The option will be converted to a &lt;code&gt;boolean&lt;/code&gt;
         * type.
         * 
         * Default: true
         * Group: common
         * 
         * @param sync the value to set
         * @return the dsl builder
         */
        default NettyHttpEndpointConsumerBuilder sync(String sync) {
            doSetProperty("sync", sync);
            return this;
        }
        /**
         * Setting to improve TCP protocol performance.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: true
         * Group: common
         * 
         * @param tcpNoDelay the value to set
         * @return the dsl builder
         */
        default NettyHttpEndpointConsumerBuilder tcpNoDelay(boolean tcpNoDelay) {
            doSetProperty("tcpNoDelay", tcpNoDelay);
            return this;
        }
        /**
         * Setting to improve TCP protocol performance.
         * 
         * The option will be converted to a &lt;code&gt;boolean&lt;/code&gt;
         * type.
         * 
         * Default: true
         * Group: common
         * 
         * @param tcpNoDelay the value to set
         * @return the dsl builder
         */
        default NettyHttpEndpointConsumerBuilder tcpNoDelay(String tcpNoDelay) {
            doSetProperty("tcpNoDelay", tcpNoDelay);
            return this;
        }
        /**
         * Whether or not Camel should try to find a target consumer by matching
         * the URI prefix if no exact match is found.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: false
         * Group: consumer
         * 
         * @param matchOnUriPrefix the value to set
         * @return the dsl builder
         */
        default NettyHttpEndpointConsumerBuilder matchOnUriPrefix(
                boolean matchOnUriPrefix) {
            doSetProperty("matchOnUriPrefix", matchOnUriPrefix);
            return this;
        }
        /**
         * Whether or not Camel should try to find a target consumer by matching
         * the URI prefix if no exact match is found.
         * 
         * The option will be converted to a &lt;code&gt;boolean&lt;/code&gt;
         * type.
         * 
         * Default: false
         * Group: consumer
         * 
         * @param matchOnUriPrefix the value to set
         * @return the dsl builder
         */
        default NettyHttpEndpointConsumerBuilder matchOnUriPrefix(
                String matchOnUriPrefix) {
            doSetProperty("matchOnUriPrefix", matchOnUriPrefix);
            return this;
        }
        /**
         * If enabled and an Exchange failed processing on the consumer side the
         * response's body won't contain the exception's stack trace.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: false
         * Group: consumer
         * 
         * @param muteException the value to set
         * @return the dsl builder
         */
        default NettyHttpEndpointConsumerBuilder muteException(
                boolean muteException) {
            doSetProperty("muteException", muteException);
            return this;
        }
        /**
         * If enabled and an Exchange failed processing on the consumer side the
         * response's body won't contain the exception's stack trace.
         * 
         * The option will be converted to a &lt;code&gt;boolean&lt;/code&gt;
         * type.
         * 
         * Default: false
         * Group: consumer
         * 
         * @param muteException the value to set
         * @return the dsl builder
         */
        default NettyHttpEndpointConsumerBuilder muteException(
                String muteException) {
            doSetProperty("muteException", muteException);
            return this;
        }
        /**
         * Whether to send back HTTP status code 503 when the consumer has been
         * suspended. If the option is false then the Netty Acceptor is unbound
         * when the consumer is suspended, so clients cannot connect anymore.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: true
         * Group: consumer
         * 
         * @param send503whenSuspended the value to set
         * @return the dsl builder
         */
        default NettyHttpEndpointConsumerBuilder send503whenSuspended(
                boolean send503whenSuspended) {
            doSetProperty("send503whenSuspended", send503whenSuspended);
            return this;
        }
        /**
         * Whether to send back HTTP status code 503 when the consumer has been
         * suspended. If the option is false then the Netty Acceptor is unbound
         * when the consumer is suspended, so clients cannot connect anymore.
         * 
         * The option will be converted to a &lt;code&gt;boolean&lt;/code&gt;
         * type.
         * 
         * Default: true
         * Group: consumer
         * 
         * @param send503whenSuspended the value to set
         * @return the dsl builder
         */
        default NettyHttpEndpointConsumerBuilder send503whenSuspended(
                String send503whenSuspended) {
            doSetProperty("send503whenSuspended", send503whenSuspended);
            return this;
        }
        /**
         * To enable/disable hostname verification on SSLEngine.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: false
         * Group:  security
         * 
         * @param hostnameVerification the value to set
         * @return the dsl builder
         */
        default NettyHttpEndpointConsumerBuilder hostnameVerification(
                boolean hostnameVerification) {
            doSetProperty("hostnameVerification", hostnameVerification);
            return this;
        }
        /**
         * To enable/disable hostname verification on SSLEngine.
         * 
         * The option will be converted to a &lt;code&gt;boolean&lt;/code&gt;
         * type.
         * 
         * Default: false
         * Group:  security
         * 
         * @param hostnameVerification the value to set
         * @return the dsl builder
         */
        default NettyHttpEndpointConsumerBuilder hostnameVerification(
                String hostnameVerification) {
            doSetProperty("hostnameVerification", hostnameVerification);
            return this;
        }
        /**
         * A list of decoders to be used. You can use a String which have values
         * separated by comma, and have the values be looked up in the Registry.
         * Just remember to prefix the value with # so Camel knows it should
         * lookup.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: codec
         * 
         * @param decoders the value to set
         * @return the dsl builder
         */
        default NettyHttpEndpointConsumerBuilder decoders(String decoders) {
            doSetProperty("decoders", decoders);
            return this;
        }
        /**
         * A list of encoders to be used. You can use a String which have values
         * separated by comma, and have the values be looked up in the Registry.
         * Just remember to prefix the value with # so Camel knows it should
         * lookup.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: codec
         * 
         * @param encoders the value to set
         * @return the dsl builder
         */
        default NettyHttpEndpointConsumerBuilder encoders(String encoders) {
            doSetProperty("encoders", encoders);
            return this;
        }
        /**
         * Which protocols to enable when using SSL.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Default: TLSv1.2,TLSv1.3
         * Group: security
         * 
         * @param enabledProtocols the value to set
         * @return the dsl builder
         */
        default NettyHttpEndpointConsumerBuilder enabledProtocols(
                String enabledProtocols) {
            doSetProperty("enabledProtocols", enabledProtocols);
            return this;
        }
        /**
         * Client side certificate keystore to be used for encryption.
         * 
         * The option is a: &lt;code&gt;java.io.File&lt;/code&gt; type.
         * 
         * Group: security
         * 
         * @param keyStoreFile the value to set
         * @return the dsl builder
         */
        default NettyHttpEndpointConsumerBuilder keyStoreFile(
                java.io.File keyStoreFile) {
            doSetProperty("keyStoreFile", keyStoreFile);
            return this;
        }
        /**
         * Client side certificate keystore to be used for encryption.
         * 
         * The option will be converted to a
         * &lt;code&gt;java.io.File&lt;/code&gt; type.
         * 
         * Group: security
         * 
         * @param keyStoreFile the value to set
         * @return the dsl builder
         */
        default NettyHttpEndpointConsumerBuilder keyStoreFile(
                String keyStoreFile) {
            doSetProperty("keyStoreFile", keyStoreFile);
            return this;
        }
        /**
         * Keystore format to be used for payload encryption. Defaults to JKS if
         * not set.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: security
         * 
         * @param keyStoreFormat the value to set
         * @return the dsl builder
         */
        default NettyHttpEndpointConsumerBuilder keyStoreFormat(
                String keyStoreFormat) {
            doSetProperty("keyStoreFormat", keyStoreFormat);
            return this;
        }
        /**
         * Client side certificate keystore to be used for encryption. Is loaded
         * by default from classpath, but you can prefix with classpath:, file:,
         * or http: to load the resource from different systems.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: security
         * 
         * @param keyStoreResource the value to set
         * @return the dsl builder
         */
        default NettyHttpEndpointConsumerBuilder keyStoreResource(
                String keyStoreResource) {
            doSetProperty("keyStoreResource", keyStoreResource);
            return this;
        }
        /**
         * Configures whether the server needs client authentication when using
         * SSL.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: false
         * Group: security
         * 
         * @param needClientAuth the value to set
         * @return the dsl builder
         */
        default NettyHttpEndpointConsumerBuilder needClientAuth(
                boolean needClientAuth) {
            doSetProperty("needClientAuth", needClientAuth);
            return this;
        }
        /**
         * Configures whether the server needs client authentication when using
         * SSL.
         * 
         * The option will be converted to a &lt;code&gt;boolean&lt;/code&gt;
         * type.
         * 
         * Default: false
         * Group: security
         * 
         * @param needClientAuth the value to set
         * @return the dsl builder
         */
        default NettyHttpEndpointConsumerBuilder needClientAuth(
                String needClientAuth) {
            doSetProperty("needClientAuth", needClientAuth);
            return this;
        }
        /**
         * Password setting to use in order to encrypt/decrypt payloads sent
         * using SSH.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: security
         * 
         * @param passphrase the value to set
         * @return the dsl builder
         */
        default NettyHttpEndpointConsumerBuilder passphrase(String passphrase) {
            doSetProperty("passphrase", passphrase);
            return this;
        }
        /**
         * Refers to a
         * org.apache.camel.component.netty.http.NettyHttpSecurityConfiguration
         * for configuring secure web resources.
         * 
         * The option is a:
         * &lt;code&gt;org.apache.camel.component.netty.http.NettyHttpSecurityConfiguration&lt;/code&gt; type.
         * 
         * Group: security
         * 
         * @param securityConfiguration the value to set
         * @return the dsl builder
         */
        default NettyHttpEndpointConsumerBuilder securityConfiguration(
                org.apache.camel.component.netty.http.NettyHttpSecurityConfiguration securityConfiguration) {
            doSetProperty("securityConfiguration", securityConfiguration);
            return this;
        }
        /**
         * Refers to a
         * org.apache.camel.component.netty.http.NettyHttpSecurityConfiguration
         * for configuring secure web resources.
         * 
         * The option will be converted to a
         * &lt;code&gt;org.apache.camel.component.netty.http.NettyHttpSecurityConfiguration&lt;/code&gt; type.
         * 
         * Group: security
         * 
         * @param securityConfiguration the value to set
         * @return the dsl builder
         */
        default NettyHttpEndpointConsumerBuilder securityConfiguration(
                String securityConfiguration) {
            doSetProperty("securityConfiguration", securityConfiguration);
            return this;
        }
        /**
         * To configure NettyHttpSecurityConfiguration using key/value pairs
         * from the map.
         * 
         * The option is a: &lt;code&gt;java.util.Map&amp;lt;java.lang.String,
         * java.lang.Object&amp;gt;&lt;/code&gt; type.
         * The option is multivalued, and you can use the
         * securityOptions(String, Object) method to add a value (call the
         * method multiple times to set more values).
         * 
         * Group: security
         * 
         * @param key the option key
         * @param value the option value
         * @return the dsl builder
         */
        default NettyHttpEndpointConsumerBuilder securityOptions(
                String key,
                Object value) {
            doSetMultiValueProperty("securityOptions", "securityConfiguration." + key, value);
            return this;
        }
        /**
         * To configure NettyHttpSecurityConfiguration using key/value pairs
         * from the map.
         * 
         * The option is a: &lt;code&gt;java.util.Map&amp;lt;java.lang.String,
         * java.lang.Object&amp;gt;&lt;/code&gt; type.
         * The option is multivalued, and you can use the
         * securityOptions(String, Object) method to add a value (call the
         * method multiple times to set more values).
         * 
         * Group: security
         * 
         * @param values the values
         * @return the dsl builder
         */
        default NettyHttpEndpointConsumerBuilder securityOptions(Map values) {
            doSetMultiValueProperties("securityOptions", "securityConfiguration.", values);
            return this;
        }
        /**
         * Security provider to be used for payload encryption. Defaults to
         * SunX509 if not set.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: security
         * 
         * @param securityProvider the value to set
         * @return the dsl builder
         */
        default NettyHttpEndpointConsumerBuilder securityProvider(
                String securityProvider) {
            doSetProperty("securityProvider", securityProvider);
            return this;
        }
        /**
         * Setting to specify whether SSL encryption is applied to this
         * endpoint.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: false
         * Group: security
         * 
         * @param ssl the value to set
         * @return the dsl builder
         */
        default NettyHttpEndpointConsumerBuilder ssl(boolean ssl) {
            doSetProperty("ssl", ssl);
            return this;
        }
        /**
         * Setting to specify whether SSL encryption is applied to this
         * endpoint.
         * 
         * The option will be converted to a &lt;code&gt;boolean&lt;/code&gt;
         * type.
         * 
         * Default: false
         * Group: security
         * 
         * @param ssl the value to set
         * @return the dsl builder
         */
        default NettyHttpEndpointConsumerBuilder ssl(String ssl) {
            doSetProperty("ssl", ssl);
            return this;
        }
        /**
         * When enabled and in SSL mode, then the Netty consumer will enrich the
         * Camel Message with headers having information about the client
         * certificate such as subject name, issuer name, serial number, and the
         * valid date range.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: false
         * Group: security
         * 
         * @param sslClientCertHeaders the value to set
         * @return the dsl builder
         */
        default NettyHttpEndpointConsumerBuilder sslClientCertHeaders(
                boolean sslClientCertHeaders) {
            doSetProperty("sslClientCertHeaders", sslClientCertHeaders);
            return this;
        }
        /**
         * When enabled and in SSL mode, then the Netty consumer will enrich the
         * Camel Message with headers having information about the client
         * certificate such as subject name, issuer name, serial number, and the
         * valid date range.
         * 
         * The option will be converted to a &lt;code&gt;boolean&lt;/code&gt;
         * type.
         * 
         * Default: false
         * Group: security
         * 
         * @param sslClientCertHeaders the value to set
         * @return the dsl builder
         */
        default NettyHttpEndpointConsumerBuilder sslClientCertHeaders(
                String sslClientCertHeaders) {
            doSetProperty("sslClientCertHeaders", sslClientCertHeaders);
            return this;
        }
        /**
         * To configure security using SSLContextParameters.
         * 
         * The option is a:
         * &lt;code&gt;org.apache.camel.support.jsse.SSLContextParameters&lt;/code&gt; type.
         * 
         * Group: security
         * 
         * @param sslContextParameters the value to set
         * @return the dsl builder
         */
        default NettyHttpEndpointConsumerBuilder sslContextParameters(
                org.apache.camel.support.jsse.SSLContextParameters sslContextParameters) {
            doSetProperty("sslContextParameters", sslContextParameters);
            return this;
        }
        /**
         * To configure security using SSLContextParameters.
         * 
         * The option will be converted to a
         * &lt;code&gt;org.apache.camel.support.jsse.SSLContextParameters&lt;/code&gt; type.
         * 
         * Group: security
         * 
         * @param sslContextParameters the value to set
         * @return the dsl builder
         */
        default NettyHttpEndpointConsumerBuilder sslContextParameters(
                String sslContextParameters) {
            doSetProperty("sslContextParameters", sslContextParameters);
            return this;
        }
        /**
         * Reference to a class that could be used to return an SSL Handler.
         * 
         * The option is a:
         * &lt;code&gt;io.netty.handler.ssl.SslHandler&lt;/code&gt; type.
         * 
         * Group: security
         * 
         * @param sslHandler the value to set
         * @return the dsl builder
         */
        default NettyHttpEndpointConsumerBuilder sslHandler(
                io.netty.handler.ssl.SslHandler sslHandler) {
            doSetProperty("sslHandler", sslHandler);
            return this;
        }
        /**
         * Reference to a class that could be used to return an SSL Handler.
         * 
         * The option will be converted to a
         * &lt;code&gt;io.netty.handler.ssl.SslHandler&lt;/code&gt; type.
         * 
         * Group: security
         * 
         * @param sslHandler the value to set
         * @return the dsl builder
         */
        default NettyHttpEndpointConsumerBuilder sslHandler(String sslHandler) {
            doSetProperty("sslHandler", sslHandler);
            return this;
        }
        /**
         * Server side certificate keystore to be used for encryption.
         * 
         * The option is a: &lt;code&gt;java.io.File&lt;/code&gt; type.
         * 
         * Group: security
         * 
         * @param trustStoreFile the value to set
         * @return the dsl builder
         */
        default NettyHttpEndpointConsumerBuilder trustStoreFile(
                java.io.File trustStoreFile) {
            doSetProperty("trustStoreFile", trustStoreFile);
            return this;
        }
        /**
         * Server side certificate keystore to be used for encryption.
         * 
         * The option will be converted to a
         * &lt;code&gt;java.io.File&lt;/code&gt; type.
         * 
         * Group: security
         * 
         * @param trustStoreFile the value to set
         * @return the dsl builder
         */
        default NettyHttpEndpointConsumerBuilder trustStoreFile(
                String trustStoreFile) {
            doSetProperty("trustStoreFile", trustStoreFile);
            return this;
        }
        /**
         * Server side certificate keystore to be used for encryption. Is loaded
         * by default from classpath, but you can prefix with classpath:, file:,
         * or http: to load the resource from different systems.
         * 
         * This option can also be loaded from an existing file, by prefixing
         * with file: or classpath: followed by the location of the file.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: security
         * 
         * @param trustStoreResource the value to set
         * @return the dsl builder
         */
        default NettyHttpEndpointConsumerBuilder trustStoreResource(
                String trustStoreResource) {
            doSetProperty("trustStoreResource", trustStoreResource);
            return this;
        }
    }

    /**
     * Advanced builder for endpoint consumers for the Netty HTTP component.
     */
    public interface AdvancedNettyHttpEndpointConsumerBuilder
            extends
                EndpointConsumerBuilder {
        default NettyHttpEndpointConsumerBuilder basic() {
            return (NettyHttpEndpointConsumerBuilder) this;
        }
        /**
         * Allows to configure a backlog for netty consumer (server). Note the
         * backlog is just a best effort depending on the OS. Setting this
         * option to a value such as 200, 500 or 1000, tells the TCP stack how
         * long the accept queue can be If this option is not configured, then
         * the backlog depends on OS setting.
         * 
         * The option is a: &lt;code&gt;int&lt;/code&gt; type.
         * 
         * Group: consumer (advanced)
         * 
         * @param backlog the value to set
         * @return the dsl builder
         */
        default AdvancedNettyHttpEndpointConsumerBuilder backlog(int backlog) {
            doSetProperty("backlog", backlog);
            return this;
        }
        /**
         * Allows to configure a backlog for netty consumer (server). Note the
         * backlog is just a best effort depending on the OS. Setting this
         * option to a value such as 200, 500 or 1000, tells the TCP stack how
         * long the accept queue can be If this option is not configured, then
         * the backlog depends on OS setting.
         * 
         * The option will be converted to a &lt;code&gt;int&lt;/code&gt; type.
         * 
         * Group: consumer (advanced)
         * 
         * @param backlog the value to set
         * @return the dsl builder
         */
        default AdvancedNettyHttpEndpointConsumerBuilder backlog(String backlog) {
            doSetProperty("backlog", backlog);
            return this;
        }
        /**
         * When netty works on nio mode, it uses default bossCount parameter
         * from Netty, which is 1. User can use this option to override the
         * default bossCount from Netty.
         * 
         * The option is a: &lt;code&gt;int&lt;/code&gt; type.
         * 
         * Default: 1
         * Group: consumer (advanced)
         * 
         * @param bossCount the value to set
         * @return the dsl builder
         */
        default AdvancedNettyHttpEndpointConsumerBuilder bossCount(int bossCount) {
            doSetProperty("bossCount", bossCount);
            return this;
        }
        /**
         * When netty works on nio mode, it uses default bossCount parameter
         * from Netty, which is 1. User can use this option to override the
         * default bossCount from Netty.
         * 
         * The option will be converted to a &lt;code&gt;int&lt;/code&gt; type.
         * 
         * Default: 1
         * Group: consumer (advanced)
         * 
         * @param bossCount the value to set
         * @return the dsl builder
         */
        default AdvancedNettyHttpEndpointConsumerBuilder bossCount(
                String bossCount) {
            doSetProperty("bossCount", bossCount);
            return this;
        }
        /**
         * Set the BossGroup which could be used for handling the new connection
         * of the server side across the NettyEndpoint.
         * 
         * The option is a:
         * &lt;code&gt;io.netty.channel.EventLoopGroup&lt;/code&gt; type.
         * 
         * Group: consumer (advanced)
         * 
         * @param bossGroup the value to set
         * @return the dsl builder
         */
        default AdvancedNettyHttpEndpointConsumerBuilder bossGroup(
                io.netty.channel.EventLoopGroup bossGroup) {
            doSetProperty("bossGroup", bossGroup);
            return this;
        }
        /**
         * Set the BossGroup which could be used for handling the new connection
         * of the server side across the NettyEndpoint.
         * 
         * The option will be converted to a
         * &lt;code&gt;io.netty.channel.EventLoopGroup&lt;/code&gt; type.
         * 
         * Group: consumer (advanced)
         * 
         * @param bossGroup the value to set
         * @return the dsl builder
         */
        default AdvancedNettyHttpEndpointConsumerBuilder bossGroup(
                String bossGroup) {
            doSetProperty("bossGroup", bossGroup);
            return this;
        }
        /**
         * Allows for bridging the consumer to the Camel routing Error Handler,
         * which mean any exceptions occurred while the consumer is trying to
         * pickup incoming messages, or the likes, will now be processed as a
         * message and handled by the routing Error Handler. By default the
         * consumer will use the org.apache.camel.spi.ExceptionHandler to deal
         * with exceptions, that will be logged at WARN or ERROR level and
         * ignored.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: false
         * Group: consumer (advanced)
         * 
         * @param bridgeErrorHandler the value to set
         * @return the dsl builder
         */
        default AdvancedNettyHttpEndpointConsumerBuilder bridgeErrorHandler(
                boolean bridgeErrorHandler) {
            doSetProperty("bridgeErrorHandler", bridgeErrorHandler);
            return this;
        }
        /**
         * Allows for bridging the consumer to the Camel routing Error Handler,
         * which mean any exceptions occurred while the consumer is trying to
         * pickup incoming messages, or the likes, will now be processed as a
         * message and handled by the routing Error Handler. By default the
         * consumer will use the org.apache.camel.spi.ExceptionHandler to deal
         * with exceptions, that will be logged at WARN or ERROR level and
         * ignored.
         * 
         * The option will be converted to a &lt;code&gt;boolean&lt;/code&gt;
         * type.
         * 
         * Default: false
         * Group: consumer (advanced)
         * 
         * @param bridgeErrorHandler the value to set
         * @return the dsl builder
         */
        default AdvancedNettyHttpEndpointConsumerBuilder bridgeErrorHandler(
                String bridgeErrorHandler) {
            doSetProperty("bridgeErrorHandler", bridgeErrorHandler);
            return this;
        }
        /**
         * Value in bytes the max content length per chunked frame received on
         * the Netty HTTP server.
         * 
         * The option is a: &lt;code&gt;int&lt;/code&gt; type.
         * 
         * Default: 1048576
         * Group: consumer (advanced)
         * 
         * @param chunkedMaxContentLength the value to set
         * @return the dsl builder
         */
        default AdvancedNettyHttpEndpointConsumerBuilder chunkedMaxContentLength(
                int chunkedMaxContentLength) {
            doSetProperty("chunkedMaxContentLength", chunkedMaxContentLength);
            return this;
        }
        /**
         * Value in bytes the max content length per chunked frame received on
         * the Netty HTTP server.
         * 
         * The option will be converted to a &lt;code&gt;int&lt;/code&gt; type.
         * 
         * Default: 1048576
         * Group: consumer (advanced)
         * 
         * @param chunkedMaxContentLength the value to set
         * @return the dsl builder
         */
        default AdvancedNettyHttpEndpointConsumerBuilder chunkedMaxContentLength(
                String chunkedMaxContentLength) {
            doSetProperty("chunkedMaxContentLength", chunkedMaxContentLength);
            return this;
        }
        /**
         * Allow using gzip/deflate for compression on the Netty HTTP server if
         * the client supports it from the HTTP headers.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: false
         * Group: consumer (advanced)
         * 
         * @param compression the value to set
         * @return the dsl builder
         */
        default AdvancedNettyHttpEndpointConsumerBuilder compression(
                boolean compression) {
            doSetProperty("compression", compression);
            return this;
        }
        /**
         * Allow using gzip/deflate for compression on the Netty HTTP server if
         * the client supports it from the HTTP headers.
         * 
         * The option will be converted to a &lt;code&gt;boolean&lt;/code&gt;
         * type.
         * 
         * Default: false
         * Group: consumer (advanced)
         * 
         * @param compression the value to set
         * @return the dsl builder
         */
        default AdvancedNettyHttpEndpointConsumerBuilder compression(
                String compression) {
            doSetProperty("compression", compression);
            return this;
        }
        /**
         * If sync is enabled then this option dictates NettyConsumer if it
         * should disconnect where there is no reply to send back.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: true
         * Group: consumer (advanced)
         * 
         * @param disconnectOnNoReply the value to set
         * @return the dsl builder
         */
        default AdvancedNettyHttpEndpointConsumerBuilder disconnectOnNoReply(
                boolean disconnectOnNoReply) {
            doSetProperty("disconnectOnNoReply", disconnectOnNoReply);
            return this;
        }
        /**
         * If sync is enabled then this option dictates NettyConsumer if it
         * should disconnect where there is no reply to send back.
         * 
         * The option will be converted to a &lt;code&gt;boolean&lt;/code&gt;
         * type.
         * 
         * Default: true
         * Group: consumer (advanced)
         * 
         * @param disconnectOnNoReply the value to set
         * @return the dsl builder
         */
        default AdvancedNettyHttpEndpointConsumerBuilder disconnectOnNoReply(
                String disconnectOnNoReply) {
            doSetProperty("disconnectOnNoReply", disconnectOnNoReply);
            return this;
        }
        /**
         * To let the consumer use a custom ExceptionHandler. Notice if the
         * option bridgeErrorHandler is enabled then this option is not in use.
         * By default the consumer will deal with exceptions, that will be
         * logged at WARN or ERROR level and ignored.
         * 
         * The option is a:
         * &lt;code&gt;org.apache.camel.spi.ExceptionHandler&lt;/code&gt; type.
         * 
         * Group: consumer (advanced)
         * 
         * @param exceptionHandler the value to set
         * @return the dsl builder
         */
        default AdvancedNettyHttpEndpointConsumerBuilder exceptionHandler(
                org.apache.camel.spi.ExceptionHandler exceptionHandler) {
            doSetProperty("exceptionHandler", exceptionHandler);
            return this;
        }
        /**
         * To let the consumer use a custom ExceptionHandler. Notice if the
         * option bridgeErrorHandler is enabled then this option is not in use.
         * By default the consumer will deal with exceptions, that will be
         * logged at WARN or ERROR level and ignored.
         * 
         * The option will be converted to a
         * &lt;code&gt;org.apache.camel.spi.ExceptionHandler&lt;/code&gt; type.
         * 
         * Group: consumer (advanced)
         * 
         * @param exceptionHandler the value to set
         * @return the dsl builder
         */
        default AdvancedNettyHttpEndpointConsumerBuilder exceptionHandler(
                String exceptionHandler) {
            doSetProperty("exceptionHandler", exceptionHandler);
            return this;
        }
        /**
         * Sets the exchange pattern when the consumer creates an exchange.
         * 
         * The option is a:
         * &lt;code&gt;org.apache.camel.ExchangePattern&lt;/code&gt; type.
         * 
         * Group: consumer (advanced)
         * 
         * @param exchangePattern the value to set
         * @return the dsl builder
         */
        default AdvancedNettyHttpEndpointConsumerBuilder exchangePattern(
                org.apache.camel.ExchangePattern exchangePattern) {
            doSetProperty("exchangePattern", exchangePattern);
            return this;
        }
        /**
         * Sets the exchange pattern when the consumer creates an exchange.
         * 
         * The option will be converted to a
         * &lt;code&gt;org.apache.camel.ExchangePattern&lt;/code&gt; type.
         * 
         * Group: consumer (advanced)
         * 
         * @param exchangePattern the value to set
         * @return the dsl builder
         */
        default AdvancedNettyHttpEndpointConsumerBuilder exchangePattern(
                String exchangePattern) {
            doSetProperty("exchangePattern", exchangePattern);
            return this;
        }
        /**
         * To disable HTTP methods on the Netty HTTP consumer. You can specify
         * multiple separated by comma.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: consumer (advanced)
         * 
         * @param httpMethodRestrict the value to set
         * @return the dsl builder
         */
        default AdvancedNettyHttpEndpointConsumerBuilder httpMethodRestrict(
                String httpMethodRestrict) {
            doSetProperty("httpMethodRestrict", httpMethodRestrict);
            return this;
        }
        /**
         * Whether Netty HTTP server should log a WARN if decoding the HTTP
         * request failed and a HTTP Status 400 (bad request) is returned.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: true
         * Group: consumer (advanced)
         * 
         * @param logWarnOnBadRequest the value to set
         * @return the dsl builder
         */
        default AdvancedNettyHttpEndpointConsumerBuilder logWarnOnBadRequest(
                boolean logWarnOnBadRequest) {
            doSetProperty("logWarnOnBadRequest", logWarnOnBadRequest);
            return this;
        }
        /**
         * Whether Netty HTTP server should log a WARN if decoding the HTTP
         * request failed and a HTTP Status 400 (bad request) is returned.
         * 
         * The option will be converted to a &lt;code&gt;boolean&lt;/code&gt;
         * type.
         * 
         * Default: true
         * Group: consumer (advanced)
         * 
         * @param logWarnOnBadRequest the value to set
         * @return the dsl builder
         */
        default AdvancedNettyHttpEndpointConsumerBuilder logWarnOnBadRequest(
                String logWarnOnBadRequest) {
            doSetProperty("logWarnOnBadRequest", logWarnOnBadRequest);
            return this;
        }
        /**
         * If this option is enabled, then during binding from Netty to Camel
         * Message then the headers will be mapped as well (eg added as header
         * to the Camel Message as well). You can turn off this option to
         * disable this. The headers can still be accessed from the
         * org.apache.camel.component.netty.http.NettyHttpMessage message with
         * the method getHttpRequest() that returns the Netty HTTP request
         * io.netty.handler.codec.http.HttpRequest instance.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: true
         * Group: consumer (advanced)
         * 
         * @param mapHeaders the value to set
         * @return the dsl builder
         */
        default AdvancedNettyHttpEndpointConsumerBuilder mapHeaders(
                boolean mapHeaders) {
            doSetProperty("mapHeaders", mapHeaders);
            return this;
        }
        /**
         * If this option is enabled, then during binding from Netty to Camel
         * Message then the headers will be mapped as well (eg added as header
         * to the Camel Message as well). You can turn off this option to
         * disable this. The headers can still be accessed from the
         * org.apache.camel.component.netty.http.NettyHttpMessage message with
         * the method getHttpRequest() that returns the Netty HTTP request
         * io.netty.handler.codec.http.HttpRequest instance.
         * 
         * The option will be converted to a &lt;code&gt;boolean&lt;/code&gt;
         * type.
         * 
         * Default: true
         * Group: consumer (advanced)
         * 
         * @param mapHeaders the value to set
         * @return the dsl builder
         */
        default AdvancedNettyHttpEndpointConsumerBuilder mapHeaders(
                String mapHeaders) {
            doSetProperty("mapHeaders", mapHeaders);
            return this;
        }
        /**
         * The maximum length of the content or each chunk. If the content
         * length (or the length of each chunk) exceeds this value, the content
         * or chunk will be split into multiple
         * io.netty.handler.codec.http.HttpContents whose length is maxChunkSize
         * at maximum. See io.netty.handler.codec.http.HttpObjectDecoder.
         * 
         * The option is a: &lt;code&gt;int&lt;/code&gt; type.
         * 
         * Default: 8192
         * Group: consumer (advanced)
         * 
         * @param maxChunkSize the value to set
         * @return the dsl builder
         */
        default AdvancedNettyHttpEndpointConsumerBuilder maxChunkSize(
                int maxChunkSize) {
            doSetProperty("maxChunkSize", maxChunkSize);
            return this;
        }
        /**
         * The maximum length of the content or each chunk. If the content
         * length (or the length of each chunk) exceeds this value, the content
         * or chunk will be split into multiple
         * io.netty.handler.codec.http.HttpContents whose length is maxChunkSize
         * at maximum. See io.netty.handler.codec.http.HttpObjectDecoder.
         * 
         * The option will be converted to a &lt;code&gt;int&lt;/code&gt; type.
         * 
         * Default: 8192
         * Group: consumer (advanced)
         * 
         * @param maxChunkSize the value to set
         * @return the dsl builder
         */
        default AdvancedNettyHttpEndpointConsumerBuilder maxChunkSize(
                String maxChunkSize) {
            doSetProperty("maxChunkSize", maxChunkSize);
            return this;
        }
        /**
         * The maximum length of all headers. If the sum of the length of each
         * header exceeds this value, a
         * io.netty.handler.codec.TooLongFrameException will be raised.
         * 
         * The option is a: &lt;code&gt;int&lt;/code&gt; type.
         * 
         * Default: 8192
         * Group: consumer (advanced)
         * 
         * @param maxHeaderSize the value to set
         * @return the dsl builder
         */
        default AdvancedNettyHttpEndpointConsumerBuilder maxHeaderSize(
                int maxHeaderSize) {
            doSetProperty("maxHeaderSize", maxHeaderSize);
            return this;
        }
        /**
         * The maximum length of all headers. If the sum of the length of each
         * header exceeds this value, a
         * io.netty.handler.codec.TooLongFrameException will be raised.
         * 
         * The option will be converted to a &lt;code&gt;int&lt;/code&gt; type.
         * 
         * Default: 8192
         * Group: consumer (advanced)
         * 
         * @param maxHeaderSize the value to set
         * @return the dsl builder
         */
        default AdvancedNettyHttpEndpointConsumerBuilder maxHeaderSize(
                String maxHeaderSize) {
            doSetProperty("maxHeaderSize", maxHeaderSize);
            return this;
        }
        /**
         * The maximum length of the initial line (e.g. {code GET / HTTP/1.0} or
         * {code HTTP/1.0 200 OK}) If the length of the initial line exceeds
         * this value, a TooLongFrameException will be raised. See
         * io.netty.handler.codec.http.HttpObjectDecoder.
         * 
         * The option is a: &lt;code&gt;int&lt;/code&gt; type.
         * 
         * Default: 4096
         * Group: consumer (advanced)
         * 
         * @param maxInitialLineLength the value to set
         * @return the dsl builder
         */
        default AdvancedNettyHttpEndpointConsumerBuilder maxInitialLineLength(
                int maxInitialLineLength) {
            doSetProperty("maxInitialLineLength", maxInitialLineLength);
            return this;
        }
        /**
         * The maximum length of the initial line (e.g. {code GET / HTTP/1.0} or
         * {code HTTP/1.0 200 OK}) If the length of the initial line exceeds
         * this value, a TooLongFrameException will be raised. See
         * io.netty.handler.codec.http.HttpObjectDecoder.
         * 
         * The option will be converted to a &lt;code&gt;int&lt;/code&gt; type.
         * 
         * Default: 4096
         * Group: consumer (advanced)
         * 
         * @param maxInitialLineLength the value to set
         * @return the dsl builder
         */
        default AdvancedNettyHttpEndpointConsumerBuilder maxInitialLineLength(
                String maxInitialLineLength) {
            doSetProperty("maxInitialLineLength", maxInitialLineLength);
            return this;
        }
        /**
         * To use a custom NettyServerBootstrapFactory.
         * 
         * The option is a:
         * &lt;code&gt;org.apache.camel.component.netty.NettyServerBootstrapFactory&lt;/code&gt; type.
         * 
         * Group: consumer (advanced)
         * 
         * @param nettyServerBootstrapFactory the value to set
         * @return the dsl builder
         */
        default AdvancedNettyHttpEndpointConsumerBuilder nettyServerBootstrapFactory(
                org.apache.camel.component.netty.NettyServerBootstrapFactory nettyServerBootstrapFactory) {
            doSetProperty("nettyServerBootstrapFactory", nettyServerBootstrapFactory);
            return this;
        }
        /**
         * To use a custom NettyServerBootstrapFactory.
         * 
         * The option will be converted to a
         * &lt;code&gt;org.apache.camel.component.netty.NettyServerBootstrapFactory&lt;/code&gt; type.
         * 
         * Group: consumer (advanced)
         * 
         * @param nettyServerBootstrapFactory the value to set
         * @return the dsl builder
         */
        default AdvancedNettyHttpEndpointConsumerBuilder nettyServerBootstrapFactory(
                String nettyServerBootstrapFactory) {
            doSetProperty("nettyServerBootstrapFactory", nettyServerBootstrapFactory);
            return this;
        }
        /**
         * To use a shared Netty HTTP server. See Netty HTTP Server Example for
         * more details.
         * 
         * The option is a:
         * &lt;code&gt;org.apache.camel.component.netty.http.NettySharedHttpServer&lt;/code&gt; type.
         * 
         * Group: consumer (advanced)
         * 
         * @param nettySharedHttpServer the value to set
         * @return the dsl builder
         */
        default AdvancedNettyHttpEndpointConsumerBuilder nettySharedHttpServer(
                org.apache.camel.component.netty.http.NettySharedHttpServer nettySharedHttpServer) {
            doSetProperty("nettySharedHttpServer", nettySharedHttpServer);
            return this;
        }
        /**
         * To use a shared Netty HTTP server. See Netty HTTP Server Example for
         * more details.
         * 
         * The option will be converted to a
         * &lt;code&gt;org.apache.camel.component.netty.http.NettySharedHttpServer&lt;/code&gt; type.
         * 
         * Group: consumer (advanced)
         * 
         * @param nettySharedHttpServer the value to set
         * @return the dsl builder
         */
        default AdvancedNettyHttpEndpointConsumerBuilder nettySharedHttpServer(
                String nettySharedHttpServer) {
            doSetProperty("nettySharedHttpServer", nettySharedHttpServer);
            return this;
        }
        /**
         * If sync is enabled this option dictates NettyConsumer which logging
         * level to use when logging a there is no reply to send back.
         * 
         * The option is a:
         * &lt;code&gt;org.apache.camel.LoggingLevel&lt;/code&gt; type.
         * 
         * Default: WARN
         * Group: consumer (advanced)
         * 
         * @param noReplyLogLevel the value to set
         * @return the dsl builder
         */
        default AdvancedNettyHttpEndpointConsumerBuilder noReplyLogLevel(
                org.apache.camel.LoggingLevel noReplyLogLevel) {
            doSetProperty("noReplyLogLevel", noReplyLogLevel);
            return this;
        }
        /**
         * If sync is enabled this option dictates NettyConsumer which logging
         * level to use when logging a there is no reply to send back.
         * 
         * The option will be converted to a
         * &lt;code&gt;org.apache.camel.LoggingLevel&lt;/code&gt; type.
         * 
         * Default: WARN
         * Group: consumer (advanced)
         * 
         * @param noReplyLogLevel the value to set
         * @return the dsl builder
         */
        default AdvancedNettyHttpEndpointConsumerBuilder noReplyLogLevel(
                String noReplyLogLevel) {
            doSetProperty("noReplyLogLevel", noReplyLogLevel);
            return this;
        }
        /**
         * If the server (NettyConsumer) catches an
         * java.nio.channels.ClosedChannelException then its logged using this
         * logging level. This is used to avoid logging the closed channel
         * exceptions, as clients can disconnect abruptly and then cause a flood
         * of closed exceptions in the Netty server.
         * 
         * The option is a:
         * &lt;code&gt;org.apache.camel.LoggingLevel&lt;/code&gt; type.
         * 
         * Default: DEBUG
         * Group: consumer (advanced)
         * 
         * @param serverClosedChannelExceptionCaughtLogLevel the value to set
         * @return the dsl builder
         */
        default AdvancedNettyHttpEndpointConsumerBuilder serverClosedChannelExceptionCaughtLogLevel(
                org.apache.camel.LoggingLevel serverClosedChannelExceptionCaughtLogLevel) {
            doSetProperty("serverClosedChannelExceptionCaughtLogLevel", serverClosedChannelExceptionCaughtLogLevel);
            return this;
        }
        /**
         * If the server (NettyConsumer) catches an
         * java.nio.channels.ClosedChannelException then its logged using this
         * logging level. This is used to avoid logging the closed channel
         * exceptions, as clients can disconnect abruptly and then cause a flood
         * of closed exceptions in the Netty server.
         * 
         * The option will be converted to a
         * &lt;code&gt;org.apache.camel.LoggingLevel&lt;/code&gt; type.
         * 
         * Default: DEBUG
         * Group: consumer (advanced)
         * 
         * @param serverClosedChannelExceptionCaughtLogLevel the value to set
         * @return the dsl builder
         */
        default AdvancedNettyHttpEndpointConsumerBuilder serverClosedChannelExceptionCaughtLogLevel(
                String serverClosedChannelExceptionCaughtLogLevel) {
            doSetProperty("serverClosedChannelExceptionCaughtLogLevel", serverClosedChannelExceptionCaughtLogLevel);
            return this;
        }
        /**
         * If the server (NettyConsumer) catches an exception then its logged
         * using this logging level.
         * 
         * The option is a:
         * &lt;code&gt;org.apache.camel.LoggingLevel&lt;/code&gt; type.
         * 
         * Default: WARN
         * Group: consumer (advanced)
         * 
         * @param serverExceptionCaughtLogLevel the value to set
         * @return the dsl builder
         */
        default AdvancedNettyHttpEndpointConsumerBuilder serverExceptionCaughtLogLevel(
                org.apache.camel.LoggingLevel serverExceptionCaughtLogLevel) {
            doSetProperty("serverExceptionCaughtLogLevel", serverExceptionCaughtLogLevel);
            return this;
        }
        /**
         * If the server (NettyConsumer) catches an exception then its logged
         * using this logging level.
         * 
         * The option will be converted to a
         * &lt;code&gt;org.apache.camel.LoggingLevel&lt;/code&gt; type.
         * 
         * Default: WARN
         * Group: consumer (advanced)
         * 
         * @param serverExceptionCaughtLogLevel the value to set
         * @return the dsl builder
         */
        default AdvancedNettyHttpEndpointConsumerBuilder serverExceptionCaughtLogLevel(
                String serverExceptionCaughtLogLevel) {
            doSetProperty("serverExceptionCaughtLogLevel", serverExceptionCaughtLogLevel);
            return this;
        }
        /**
         * To use a custom ServerInitializerFactory.
         * 
         * The option is a:
         * &lt;code&gt;org.apache.camel.component.netty.ServerInitializerFactory&lt;/code&gt; type.
         * 
         * Group: consumer (advanced)
         * 
         * @param serverInitializerFactory the value to set
         * @return the dsl builder
         */
        default AdvancedNettyHttpEndpointConsumerBuilder serverInitializerFactory(
                org.apache.camel.component.netty.ServerInitializerFactory serverInitializerFactory) {
            doSetProperty("serverInitializerFactory", serverInitializerFactory);
            return this;
        }
        /**
         * To use a custom ServerInitializerFactory.
         * 
         * The option will be converted to a
         * &lt;code&gt;org.apache.camel.component.netty.ServerInitializerFactory&lt;/code&gt; type.
         * 
         * Group: consumer (advanced)
         * 
         * @param serverInitializerFactory the value to set
         * @return the dsl builder
         */
        default AdvancedNettyHttpEndpointConsumerBuilder serverInitializerFactory(
                String serverInitializerFactory) {
            doSetProperty("serverInitializerFactory", serverInitializerFactory);
            return this;
        }
        /**
         * Specifies whether to enable HTTP TRACE for this Netty HTTP consumer.
         * By default TRACE is turned off.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: false
         * Group: consumer (advanced)
         * 
         * @param traceEnabled the value to set
         * @return the dsl builder
         */
        default AdvancedNettyHttpEndpointConsumerBuilder traceEnabled(
                boolean traceEnabled) {
            doSetProperty("traceEnabled", traceEnabled);
            return this;
        }
        /**
         * Specifies whether to enable HTTP TRACE for this Netty HTTP consumer.
         * By default TRACE is turned off.
         * 
         * The option will be converted to a &lt;code&gt;boolean&lt;/code&gt;
         * type.
         * 
         * Default: false
         * Group: consumer (advanced)
         * 
         * @param traceEnabled the value to set
         * @return the dsl builder
         */
        default AdvancedNettyHttpEndpointConsumerBuilder traceEnabled(
                String traceEnabled) {
            doSetProperty("traceEnabled", traceEnabled);
            return this;
        }
        /**
         * If this option is enabled, then during binding from Netty to Camel
         * Message then the header values will be URL decoded (eg %20 will be a
         * space character. Notice this option is used by the default
         * org.apache.camel.component.netty.http.NettyHttpBinding and therefore
         * if you implement a custom
         * org.apache.camel.component.netty.http.NettyHttpBinding then you would
         * need to decode the headers accordingly to this option.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: false
         * Group: consumer (advanced)
         * 
         * @param urlDecodeHeaders the value to set
         * @return the dsl builder
         */
        default AdvancedNettyHttpEndpointConsumerBuilder urlDecodeHeaders(
                boolean urlDecodeHeaders) {
            doSetProperty("urlDecodeHeaders", urlDecodeHeaders);
            return this;
        }
        /**
         * If this option is enabled, then during binding from Netty to Camel
         * Message then the header values will be URL decoded (eg %20 will be a
         * space character. Notice this option is used by the default
         * org.apache.camel.component.netty.http.NettyHttpBinding and therefore
         * if you implement a custom
         * org.apache.camel.component.netty.http.NettyHttpBinding then you would
         * need to decode the headers accordingly to this option.
         * 
         * The option will be converted to a &lt;code&gt;boolean&lt;/code&gt;
         * type.
         * 
         * Default: false
         * Group: consumer (advanced)
         * 
         * @param urlDecodeHeaders the value to set
         * @return the dsl builder
         */
        default AdvancedNettyHttpEndpointConsumerBuilder urlDecodeHeaders(
                String urlDecodeHeaders) {
            doSetProperty("urlDecodeHeaders", urlDecodeHeaders);
            return this;
        }
        /**
         * Whether to use ordered thread pool, to ensure events are processed
         * orderly on the same channel.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: true
         * Group: consumer (advanced)
         * 
         * @param usingExecutorService the value to set
         * @return the dsl builder
         */
        default AdvancedNettyHttpEndpointConsumerBuilder usingExecutorService(
                boolean usingExecutorService) {
            doSetProperty("usingExecutorService", usingExecutorService);
            return this;
        }
        /**
         * Whether to use ordered thread pool, to ensure events are processed
         * orderly on the same channel.
         * 
         * The option will be converted to a &lt;code&gt;boolean&lt;/code&gt;
         * type.
         * 
         * Default: true
         * Group: consumer (advanced)
         * 
         * @param usingExecutorService the value to set
         * @return the dsl builder
         */
        default AdvancedNettyHttpEndpointConsumerBuilder usingExecutorService(
                String usingExecutorService) {
            doSetProperty("usingExecutorService", usingExecutorService);
            return this;
        }
        /**
         * Only used for TCP when transferExchange is true. When set to true,
         * serializable objects in headers and properties will be added to the
         * exchange. Otherwise Camel will exclude any non-serializable objects
         * and log it at WARN level.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: false
         * Group: advanced
         * 
         * @param allowSerializedHeaders the value to set
         * @return the dsl builder
         */
        default AdvancedNettyHttpEndpointConsumerBuilder allowSerializedHeaders(
                boolean allowSerializedHeaders) {
            doSetProperty("allowSerializedHeaders", allowSerializedHeaders);
            return this;
        }
        /**
         * Only used for TCP when transferExchange is true. When set to true,
         * serializable objects in headers and properties will be added to the
         * exchange. Otherwise Camel will exclude any non-serializable objects
         * and log it at WARN level.
         * 
         * The option will be converted to a &lt;code&gt;boolean&lt;/code&gt;
         * type.
         * 
         * Default: false
         * Group: advanced
         * 
         * @param allowSerializedHeaders the value to set
         * @return the dsl builder
         */
        default AdvancedNettyHttpEndpointConsumerBuilder allowSerializedHeaders(
                String allowSerializedHeaders) {
            doSetProperty("allowSerializedHeaders", allowSerializedHeaders);
            return this;
        }
        /**
         * To use a explicit ChannelGroup.
         * 
         * The option is a:
         * &lt;code&gt;io.netty.channel.group.ChannelGroup&lt;/code&gt; type.
         * 
         * Group: advanced
         * 
         * @param channelGroup the value to set
         * @return the dsl builder
         */
        default AdvancedNettyHttpEndpointConsumerBuilder channelGroup(
                io.netty.channel.group.ChannelGroup channelGroup) {
            doSetProperty("channelGroup", channelGroup);
            return this;
        }
        /**
         * To use a explicit ChannelGroup.
         * 
         * The option will be converted to a
         * &lt;code&gt;io.netty.channel.group.ChannelGroup&lt;/code&gt; type.
         * 
         * Group: advanced
         * 
         * @param channelGroup the value to set
         * @return the dsl builder
         */
        default AdvancedNettyHttpEndpointConsumerBuilder channelGroup(
                String channelGroup) {
            doSetProperty("channelGroup", channelGroup);
            return this;
        }
        /**
         * To use a custom configured NettyHttpConfiguration for configuring
         * this endpoint.
         * 
         * The option is a:
         * &lt;code&gt;org.apache.camel.component.netty.http.NettyHttpConfiguration&lt;/code&gt; type.
         * 
         * Group: advanced
         * 
         * @param configuration the value to set
         * @return the dsl builder
         */
        default AdvancedNettyHttpEndpointConsumerBuilder configuration(
                org.apache.camel.component.netty.http.NettyHttpConfiguration configuration) {
            doSetProperty("configuration", configuration);
            return this;
        }
        /**
         * To use a custom configured NettyHttpConfiguration for configuring
         * this endpoint.
         * 
         * The option will be converted to a
         * &lt;code&gt;org.apache.camel.component.netty.http.NettyHttpConfiguration&lt;/code&gt; type.
         * 
         * Group: advanced
         * 
         * @param configuration the value to set
         * @return the dsl builder
         */
        default AdvancedNettyHttpEndpointConsumerBuilder configuration(
                String configuration) {
            doSetProperty("configuration", configuration);
            return this;
        }
        /**
         * Determines whether or not the raw input stream from Netty
         * HttpRequest#getContent() or HttpResponset#getContent() is cached or
         * not (Camel will read the stream into a in light-weight memory based
         * Stream caching) cache. By default Camel will cache the Netty input
         * stream to support reading it multiple times to ensure it Camel can
         * retrieve all data from the stream. However you can set this option to
         * true when you for example need to access the raw stream, such as
         * streaming it directly to a file or other persistent store. Mind that
         * if you enable this option, then you cannot read the Netty stream
         * multiple times out of the box, and you would need manually to reset
         * the reader index on the Netty raw stream. Also Netty will auto-close
         * the Netty stream when the Netty HTTP server/HTTP client is done
         * processing, which means that if the asynchronous routing engine is in
         * use then any asynchronous thread that may continue routing the
         * org.apache.camel.Exchange may not be able to read the Netty stream,
         * because Netty has closed it.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: false
         * Group: advanced
         * 
         * @param disableStreamCache the value to set
         * @return the dsl builder
         */
        default AdvancedNettyHttpEndpointConsumerBuilder disableStreamCache(
                boolean disableStreamCache) {
            doSetProperty("disableStreamCache", disableStreamCache);
            return this;
        }
        /**
         * Determines whether or not the raw input stream from Netty
         * HttpRequest#getContent() or HttpResponset#getContent() is cached or
         * not (Camel will read the stream into a in light-weight memory based
         * Stream caching) cache. By default Camel will cache the Netty input
         * stream to support reading it multiple times to ensure it Camel can
         * retrieve all data from the stream. However you can set this option to
         * true when you for example need to access the raw stream, such as
         * streaming it directly to a file or other persistent store. Mind that
         * if you enable this option, then you cannot read the Netty stream
         * multiple times out of the box, and you would need manually to reset
         * the reader index on the Netty raw stream. Also Netty will auto-close
         * the Netty stream when the Netty HTTP server/HTTP client is done
         * processing, which means that if the asynchronous routing engine is in
         * use then any asynchronous thread that may continue routing the
         * org.apache.camel.Exchange may not be able to read the Netty stream,
         * because Netty has closed it.
         * 
         * The option will be converted to a &lt;code&gt;boolean&lt;/code&gt;
         * type.
         * 
         * Default: false
         * Group: advanced
         * 
         * @param disableStreamCache the value to set
         * @return the dsl builder
         */
        default AdvancedNettyHttpEndpointConsumerBuilder disableStreamCache(
                String disableStreamCache) {
            doSetProperty("disableStreamCache", disableStreamCache);
            return this;
        }
        /**
         * To use a custom org.apache.camel.spi.HeaderFilterStrategy to filter
         * headers.
         * 
         * The option is a:
         * &lt;code&gt;org.apache.camel.spi.HeaderFilterStrategy&lt;/code&gt;
         * type.
         * 
         * Group: advanced
         * 
         * @param headerFilterStrategy the value to set
         * @return the dsl builder
         */
        default AdvancedNettyHttpEndpointConsumerBuilder headerFilterStrategy(
                org.apache.camel.spi.HeaderFilterStrategy headerFilterStrategy) {
            doSetProperty("headerFilterStrategy", headerFilterStrategy);
            return this;
        }
        /**
         * To use a custom org.apache.camel.spi.HeaderFilterStrategy to filter
         * headers.
         * 
         * The option will be converted to a
         * &lt;code&gt;org.apache.camel.spi.HeaderFilterStrategy&lt;/code&gt;
         * type.
         * 
         * Group: advanced
         * 
         * @param headerFilterStrategy the value to set
         * @return the dsl builder
         */
        default AdvancedNettyHttpEndpointConsumerBuilder headerFilterStrategy(
                String headerFilterStrategy) {
            doSetProperty("headerFilterStrategy", headerFilterStrategy);
            return this;
        }
        /**
         * Whether to use native transport instead of NIO. Native transport
         * takes advantage of the host operating system and is only supported on
         * some platforms. You need to add the netty JAR for the host operating
         * system you are using. See more details at:
         * http://netty.io/wiki/native-transports.html.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: false
         * Group: advanced
         * 
         * @param nativeTransport the value to set
         * @return the dsl builder
         */
        default AdvancedNettyHttpEndpointConsumerBuilder nativeTransport(
                boolean nativeTransport) {
            doSetProperty("nativeTransport", nativeTransport);
            return this;
        }
        /**
         * Whether to use native transport instead of NIO. Native transport
         * takes advantage of the host operating system and is only supported on
         * some platforms. You need to add the netty JAR for the host operating
         * system you are using. See more details at:
         * http://netty.io/wiki/native-transports.html.
         * 
         * The option will be converted to a &lt;code&gt;boolean&lt;/code&gt;
         * type.
         * 
         * Default: false
         * Group: advanced
         * 
         * @param nativeTransport the value to set
         * @return the dsl builder
         */
        default AdvancedNettyHttpEndpointConsumerBuilder nativeTransport(
                String nativeTransport) {
            doSetProperty("nativeTransport", nativeTransport);
            return this;
        }
        /**
         * To use a custom
         * org.apache.camel.component.netty.http.NettyHttpBinding for binding
         * to/from Netty and Camel Message API.
         * 
         * The option is a:
         * &lt;code&gt;org.apache.camel.component.netty.http.NettyHttpBinding&lt;/code&gt; type.
         * 
         * Group: advanced
         * 
         * @param nettyHttpBinding the value to set
         * @return the dsl builder
         */
        default AdvancedNettyHttpEndpointConsumerBuilder nettyHttpBinding(
                org.apache.camel.component.netty.http.NettyHttpBinding nettyHttpBinding) {
            doSetProperty("nettyHttpBinding", nettyHttpBinding);
            return this;
        }
        /**
         * To use a custom
         * org.apache.camel.component.netty.http.NettyHttpBinding for binding
         * to/from Netty and Camel Message API.
         * 
         * The option will be converted to a
         * &lt;code&gt;org.apache.camel.component.netty.http.NettyHttpBinding&lt;/code&gt; type.
         * 
         * Group: advanced
         * 
         * @param nettyHttpBinding the value to set
         * @return the dsl builder
         */
        default AdvancedNettyHttpEndpointConsumerBuilder nettyHttpBinding(
                String nettyHttpBinding) {
            doSetProperty("nettyHttpBinding", nettyHttpBinding);
            return this;
        }
        /**
         * Allows to configure additional netty options using option. as prefix.
         * For example option.child.keepAlive=false to set the netty option
         * child.keepAlive=false. See the Netty documentation for possible
         * options that can be used.
         * 
         * The option is a: &lt;code&gt;java.util.Map&amp;lt;java.lang.String,
         * java.lang.Object&amp;gt;&lt;/code&gt; type.
         * The option is multivalued, and you can use the options(String,
         * Object) method to add a value (call the method multiple times to set
         * more values).
         * 
         * Group: advanced
         * 
         * @param key the option key
         * @param value the option value
         * @return the dsl builder
         */
        default AdvancedNettyHttpEndpointConsumerBuilder options(
                String key,
                Object value) {
            doSetMultiValueProperty("options", "option." + key, value);
            return this;
        }
        /**
         * Allows to configure additional netty options using option. as prefix.
         * For example option.child.keepAlive=false to set the netty option
         * child.keepAlive=false. See the Netty documentation for possible
         * options that can be used.
         * 
         * The option is a: &lt;code&gt;java.util.Map&amp;lt;java.lang.String,
         * java.lang.Object&amp;gt;&lt;/code&gt; type.
         * The option is multivalued, and you can use the options(String,
         * Object) method to add a value (call the method multiple times to set
         * more values).
         * 
         * Group: advanced
         * 
         * @param values the values
         * @return the dsl builder
         */
        default AdvancedNettyHttpEndpointConsumerBuilder options(Map values) {
            doSetMultiValueProperties("options", "option.", values);
            return this;
        }
        /**
         * The TCP/UDP buffer sizes to be used during inbound communication.
         * Size is bytes.
         * 
         * The option is a: &lt;code&gt;int&lt;/code&gt; type.
         * 
         * Default: 65536
         * Group: advanced
         * 
         * @param receiveBufferSize the value to set
         * @return the dsl builder
         */
        default AdvancedNettyHttpEndpointConsumerBuilder receiveBufferSize(
                int receiveBufferSize) {
            doSetProperty("receiveBufferSize", receiveBufferSize);
            return this;
        }
        /**
         * The TCP/UDP buffer sizes to be used during inbound communication.
         * Size is bytes.
         * 
         * The option will be converted to a &lt;code&gt;int&lt;/code&gt; type.
         * 
         * Default: 65536
         * Group: advanced
         * 
         * @param receiveBufferSize the value to set
         * @return the dsl builder
         */
        default AdvancedNettyHttpEndpointConsumerBuilder receiveBufferSize(
                String receiveBufferSize) {
            doSetProperty("receiveBufferSize", receiveBufferSize);
            return this;
        }
        /**
         * Configures the buffer size predictor. See details at Jetty
         * documentation and this mail thread.
         * 
         * The option is a: &lt;code&gt;int&lt;/code&gt; type.
         * 
         * Group: advanced
         * 
         * @param receiveBufferSizePredictor the value to set
         * @return the dsl builder
         */
        default AdvancedNettyHttpEndpointConsumerBuilder receiveBufferSizePredictor(
                int receiveBufferSizePredictor) {
            doSetProperty("receiveBufferSizePredictor", receiveBufferSizePredictor);
            return this;
        }
        /**
         * Configures the buffer size predictor. See details at Jetty
         * documentation and this mail thread.
         * 
         * The option will be converted to a &lt;code&gt;int&lt;/code&gt; type.
         * 
         * Group: advanced
         * 
         * @param receiveBufferSizePredictor the value to set
         * @return the dsl builder
         */
        default AdvancedNettyHttpEndpointConsumerBuilder receiveBufferSizePredictor(
                String receiveBufferSizePredictor) {
            doSetProperty("receiveBufferSizePredictor", receiveBufferSizePredictor);
            return this;
        }
        /**
         * The TCP/UDP buffer sizes to be used during outbound communication.
         * Size is bytes.
         * 
         * The option is a: &lt;code&gt;int&lt;/code&gt; type.
         * 
         * Default: 65536
         * Group: advanced
         * 
         * @param sendBufferSize the value to set
         * @return the dsl builder
         */
        default AdvancedNettyHttpEndpointConsumerBuilder sendBufferSize(
                int sendBufferSize) {
            doSetProperty("sendBufferSize", sendBufferSize);
            return this;
        }
        /**
         * The TCP/UDP buffer sizes to be used during outbound communication.
         * Size is bytes.
         * 
         * The option will be converted to a &lt;code&gt;int&lt;/code&gt; type.
         * 
         * Default: 65536
         * Group: advanced
         * 
         * @param sendBufferSize the value to set
         * @return the dsl builder
         */
        default AdvancedNettyHttpEndpointConsumerBuilder sendBufferSize(
                String sendBufferSize) {
            doSetProperty("sendBufferSize", sendBufferSize);
            return this;
        }
        /**
         * Sets whether synchronous processing should be strictly used.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: false
         * Group: advanced
         * 
         * @param synchronous the value to set
         * @return the dsl builder
         */
        default AdvancedNettyHttpEndpointConsumerBuilder synchronous(
                boolean synchronous) {
            doSetProperty("synchronous", synchronous);
            return this;
        }
        /**
         * Sets whether synchronous processing should be strictly used.
         * 
         * The option will be converted to a &lt;code&gt;boolean&lt;/code&gt;
         * type.
         * 
         * Default: false
         * Group: advanced
         * 
         * @param synchronous the value to set
         * @return the dsl builder
         */
        default AdvancedNettyHttpEndpointConsumerBuilder synchronous(
                String synchronous) {
            doSetProperty("synchronous", synchronous);
            return this;
        }
        /**
         * If enabled and an Exchange failed processing on the consumer side,
         * and if the caused Exception was send back serialized in the response
         * as a application/x-java-serialized-object content type. On the
         * producer side the exception will be deserialized and thrown as is,
         * instead of the HttpOperationFailedException. The caused exception is
         * required to be serialized. This is by default turned off. If you
         * enable this then be aware that Java will deserialize the incoming
         * data from the request to Java and that can be a potential security
         * risk.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: false
         * Group: advanced
         * 
         * @param transferException the value to set
         * @return the dsl builder
         */
        default AdvancedNettyHttpEndpointConsumerBuilder transferException(
                boolean transferException) {
            doSetProperty("transferException", transferException);
            return this;
        }
        /**
         * If enabled and an Exchange failed processing on the consumer side,
         * and if the caused Exception was send back serialized in the response
         * as a application/x-java-serialized-object content type. On the
         * producer side the exception will be deserialized and thrown as is,
         * instead of the HttpOperationFailedException. The caused exception is
         * required to be serialized. This is by default turned off. If you
         * enable this then be aware that Java will deserialize the incoming
         * data from the request to Java and that can be a potential security
         * risk.
         * 
         * The option will be converted to a &lt;code&gt;boolean&lt;/code&gt;
         * type.
         * 
         * Default: false
         * Group: advanced
         * 
         * @param transferException the value to set
         * @return the dsl builder
         */
        default AdvancedNettyHttpEndpointConsumerBuilder transferException(
                String transferException) {
            doSetProperty("transferException", transferException);
            return this;
        }
        /**
         * Only used for TCP. You can transfer the exchange over the wire
         * instead of just the body. The following fields are transferred: In
         * body, Out body, fault body, In headers, Out headers, fault headers,
         * exchange properties, exchange exception. This requires that the
         * objects are serializable. Camel will exclude any non-serializable
         * objects and log it at WARN level.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: false
         * Group: advanced
         * 
         * @param transferExchange the value to set
         * @return the dsl builder
         */
        default AdvancedNettyHttpEndpointConsumerBuilder transferExchange(
                boolean transferExchange) {
            doSetProperty("transferExchange", transferExchange);
            return this;
        }
        /**
         * Only used for TCP. You can transfer the exchange over the wire
         * instead of just the body. The following fields are transferred: In
         * body, Out body, fault body, In headers, Out headers, fault headers,
         * exchange properties, exchange exception. This requires that the
         * objects are serializable. Camel will exclude any non-serializable
         * objects and log it at WARN level.
         * 
         * The option will be converted to a &lt;code&gt;boolean&lt;/code&gt;
         * type.
         * 
         * Default: false
         * Group: advanced
         * 
         * @param transferExchange the value to set
         * @return the dsl builder
         */
        default AdvancedNettyHttpEndpointConsumerBuilder transferExchange(
                String transferExchange) {
            doSetProperty("transferExchange", transferExchange);
            return this;
        }
        /**
         * Path to unix domain socket to use instead of inet socket. Host and
         * port parameters will not be used, however required. It is ok to set
         * dummy values for them. Must be used with nativeTransport=true and
         * clientMode=false.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: advanced
         * 
         * @param unixDomainSocketPath the value to set
         * @return the dsl builder
         */
        default AdvancedNettyHttpEndpointConsumerBuilder unixDomainSocketPath(
                String unixDomainSocketPath) {
            doSetProperty("unixDomainSocketPath", unixDomainSocketPath);
            return this;
        }
        /**
         * When netty works on nio mode, it uses default workerCount parameter
         * from Netty (which is cpu_core_threads x 2). User can use this option
         * to override the default workerCount from Netty.
         * 
         * The option is a: &lt;code&gt;int&lt;/code&gt; type.
         * 
         * Group: advanced
         * 
         * @param workerCount the value to set
         * @return the dsl builder
         */
        default AdvancedNettyHttpEndpointConsumerBuilder workerCount(
                int workerCount) {
            doSetProperty("workerCount", workerCount);
            return this;
        }
        /**
         * When netty works on nio mode, it uses default workerCount parameter
         * from Netty (which is cpu_core_threads x 2). User can use this option
         * to override the default workerCount from Netty.
         * 
         * The option will be converted to a &lt;code&gt;int&lt;/code&gt; type.
         * 
         * Group: advanced
         * 
         * @param workerCount the value to set
         * @return the dsl builder
         */
        default AdvancedNettyHttpEndpointConsumerBuilder workerCount(
                String workerCount) {
            doSetProperty("workerCount", workerCount);
            return this;
        }
        /**
         * To use a explicit EventLoopGroup as the boss thread pool. For example
         * to share a thread pool with multiple consumers or producers. By
         * default each consumer or producer has their own worker pool with 2 x
         * cpu count core threads.
         * 
         * The option is a:
         * &lt;code&gt;io.netty.channel.EventLoopGroup&lt;/code&gt; type.
         * 
         * Group: advanced
         * 
         * @param workerGroup the value to set
         * @return the dsl builder
         */
        default AdvancedNettyHttpEndpointConsumerBuilder workerGroup(
                io.netty.channel.EventLoopGroup workerGroup) {
            doSetProperty("workerGroup", workerGroup);
            return this;
        }
        /**
         * To use a explicit EventLoopGroup as the boss thread pool. For example
         * to share a thread pool with multiple consumers or producers. By
         * default each consumer or producer has their own worker pool with 2 x
         * cpu count core threads.
         * 
         * The option will be converted to a
         * &lt;code&gt;io.netty.channel.EventLoopGroup&lt;/code&gt; type.
         * 
         * Group: advanced
         * 
         * @param workerGroup the value to set
         * @return the dsl builder
         */
        default AdvancedNettyHttpEndpointConsumerBuilder workerGroup(
                String workerGroup) {
            doSetProperty("workerGroup", workerGroup);
            return this;
        }
    }

    /**
     * Builder for endpoint producers for the Netty HTTP component.
     */
    public interface NettyHttpEndpointProducerBuilder
            extends
                EndpointProducerBuilder {
        default AdvancedNettyHttpEndpointProducerBuilder advanced() {
            return (AdvancedNettyHttpEndpointProducerBuilder) this;
        }
        /**
         * If the option is true, the producer will ignore the
         * NettyHttpConstants.HTTP_URI header, and use the endpoint's URI for
         * request. You may also set the throwExceptionOnFailure to be false to
         * let the producer send all the fault response back. The consumer
         * working in the bridge mode will skip the gzip compression and WWW URL
         * form encoding (by adding the Exchange.SKIP_GZIP_ENCODING and
         * Exchange.SKIP_WWW_FORM_URLENCODED headers to the consumed exchange).
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: false
         * Group: common
         * 
         * @param bridgeEndpoint the value to set
         * @return the dsl builder
         */
        default NettyHttpEndpointProducerBuilder bridgeEndpoint(
                boolean bridgeEndpoint) {
            doSetProperty("bridgeEndpoint", bridgeEndpoint);
            return this;
        }
        /**
         * If the option is true, the producer will ignore the
         * NettyHttpConstants.HTTP_URI header, and use the endpoint's URI for
         * request. You may also set the throwExceptionOnFailure to be false to
         * let the producer send all the fault response back. The consumer
         * working in the bridge mode will skip the gzip compression and WWW URL
         * form encoding (by adding the Exchange.SKIP_GZIP_ENCODING and
         * Exchange.SKIP_WWW_FORM_URLENCODED headers to the consumed exchange).
         * 
         * The option will be converted to a &lt;code&gt;boolean&lt;/code&gt;
         * type.
         * 
         * Default: false
         * Group: common
         * 
         * @param bridgeEndpoint the value to set
         * @return the dsl builder
         */
        default NettyHttpEndpointProducerBuilder bridgeEndpoint(
                String bridgeEndpoint) {
            doSetProperty("bridgeEndpoint", bridgeEndpoint);
            return this;
        }
        /**
         * Whether or not to disconnect(close) from Netty Channel right after
         * use. Can be used for both consumer and producer.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: false
         * Group: common
         * 
         * @param disconnect the value to set
         * @return the dsl builder
         */
        default NettyHttpEndpointProducerBuilder disconnect(boolean disconnect) {
            doSetProperty("disconnect", disconnect);
            return this;
        }
        /**
         * Whether or not to disconnect(close) from Netty Channel right after
         * use. Can be used for both consumer and producer.
         * 
         * The option will be converted to a &lt;code&gt;boolean&lt;/code&gt;
         * type.
         * 
         * Default: false
         * Group: common
         * 
         * @param disconnect the value to set
         * @return the dsl builder
         */
        default NettyHttpEndpointProducerBuilder disconnect(String disconnect) {
            doSetProperty("disconnect", disconnect);
            return this;
        }
        /**
         * Setting to ensure socket is not closed due to inactivity.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: true
         * Group: common
         * 
         * @param keepAlive the value to set
         * @return the dsl builder
         */
        default NettyHttpEndpointProducerBuilder keepAlive(boolean keepAlive) {
            doSetProperty("keepAlive", keepAlive);
            return this;
        }
        /**
         * Setting to ensure socket is not closed due to inactivity.
         * 
         * The option will be converted to a &lt;code&gt;boolean&lt;/code&gt;
         * type.
         * 
         * Default: true
         * Group: common
         * 
         * @param keepAlive the value to set
         * @return the dsl builder
         */
        default NettyHttpEndpointProducerBuilder keepAlive(String keepAlive) {
            doSetProperty("keepAlive", keepAlive);
            return this;
        }
        /**
         * Setting to facilitate socket multiplexing.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: true
         * Group: common
         * 
         * @param reuseAddress the value to set
         * @return the dsl builder
         */
        default NettyHttpEndpointProducerBuilder reuseAddress(
                boolean reuseAddress) {
            doSetProperty("reuseAddress", reuseAddress);
            return this;
        }
        /**
         * Setting to facilitate socket multiplexing.
         * 
         * The option will be converted to a &lt;code&gt;boolean&lt;/code&gt;
         * type.
         * 
         * Default: true
         * Group: common
         * 
         * @param reuseAddress the value to set
         * @return the dsl builder
         */
        default NettyHttpEndpointProducerBuilder reuseAddress(
                String reuseAddress) {
            doSetProperty("reuseAddress", reuseAddress);
            return this;
        }
        /**
         * This option allows producers and consumers (in client mode) to reuse
         * the same Netty Channel for the lifecycle of processing the Exchange.
         * This is useful if you need to call a server multiple times in a Camel
         * route and want to use the same network connection. When using this,
         * the channel is not returned to the connection pool until the Exchange
         * is done; or disconnected if the disconnect option is set to true. The
         * reused Channel is stored on the Exchange as an exchange property with
         * the key NettyConstants#NETTY_CHANNEL which allows you to obtain the
         * channel during routing and use it as well.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: false
         * Group: common
         * 
         * @param reuseChannel the value to set
         * @return the dsl builder
         */
        default NettyHttpEndpointProducerBuilder reuseChannel(
                boolean reuseChannel) {
            doSetProperty("reuseChannel", reuseChannel);
            return this;
        }
        /**
         * This option allows producers and consumers (in client mode) to reuse
         * the same Netty Channel for the lifecycle of processing the Exchange.
         * This is useful if you need to call a server multiple times in a Camel
         * route and want to use the same network connection. When using this,
         * the channel is not returned to the connection pool until the Exchange
         * is done; or disconnected if the disconnect option is set to true. The
         * reused Channel is stored on the Exchange as an exchange property with
         * the key NettyConstants#NETTY_CHANNEL which allows you to obtain the
         * channel during routing and use it as well.
         * 
         * The option will be converted to a &lt;code&gt;boolean&lt;/code&gt;
         * type.
         * 
         * Default: false
         * Group: common
         * 
         * @param reuseChannel the value to set
         * @return the dsl builder
         */
        default NettyHttpEndpointProducerBuilder reuseChannel(
                String reuseChannel) {
            doSetProperty("reuseChannel", reuseChannel);
            return this;
        }
        /**
         * Setting to set endpoint as one-way or request-response.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: true
         * Group: common
         * 
         * @param sync the value to set
         * @return the dsl builder
         */
        default NettyHttpEndpointProducerBuilder sync(boolean sync) {
            doSetProperty("sync", sync);
            return this;
        }
        /**
         * Setting to set endpoint as one-way or request-response.
         * 
         * The option will be converted to a &lt;code&gt;boolean&lt;/code&gt;
         * type.
         * 
         * Default: true
         * Group: common
         * 
         * @param sync the value to set
         * @return the dsl builder
         */
        default NettyHttpEndpointProducerBuilder sync(String sync) {
            doSetProperty("sync", sync);
            return this;
        }
        /**
         * Setting to improve TCP protocol performance.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: true
         * Group: common
         * 
         * @param tcpNoDelay the value to set
         * @return the dsl builder
         */
        default NettyHttpEndpointProducerBuilder tcpNoDelay(boolean tcpNoDelay) {
            doSetProperty("tcpNoDelay", tcpNoDelay);
            return this;
        }
        /**
         * Setting to improve TCP protocol performance.
         * 
         * The option will be converted to a &lt;code&gt;boolean&lt;/code&gt;
         * type.
         * 
         * Default: true
         * Group: common
         * 
         * @param tcpNoDelay the value to set
         * @return the dsl builder
         */
        default NettyHttpEndpointProducerBuilder tcpNoDelay(String tcpNoDelay) {
            doSetProperty("tcpNoDelay", tcpNoDelay);
            return this;
        }
        /**
         * Time to wait for a socket connection to be available. Value is in
         * milliseconds.
         * 
         * The option is a: &lt;code&gt;int&lt;/code&gt; type.
         * 
         * Default: 10000
         * Group: producer
         * 
         * @param connectTimeout the value to set
         * @return the dsl builder
         */
        default NettyHttpEndpointProducerBuilder connectTimeout(
                int connectTimeout) {
            doSetProperty("connectTimeout", connectTimeout);
            return this;
        }
        /**
         * Time to wait for a socket connection to be available. Value is in
         * milliseconds.
         * 
         * The option will be converted to a &lt;code&gt;int&lt;/code&gt; type.
         * 
         * Default: 10000
         * Group: producer
         * 
         * @param connectTimeout the value to set
         * @return the dsl builder
         */
        default NettyHttpEndpointProducerBuilder connectTimeout(
                String connectTimeout) {
            doSetProperty("connectTimeout", connectTimeout);
            return this;
        }
        /**
         * Configure a cookie handler to maintain a HTTP session.
         * 
         * The option is a:
         * &lt;code&gt;org.apache.camel.http.base.cookie.CookieHandler&lt;/code&gt; type.
         * 
         * Group: producer
         * 
         * @param cookieHandler the value to set
         * @return the dsl builder
         */
        default NettyHttpEndpointProducerBuilder cookieHandler(
                org.apache.camel.http.base.cookie.CookieHandler cookieHandler) {
            doSetProperty("cookieHandler", cookieHandler);
            return this;
        }
        /**
         * Configure a cookie handler to maintain a HTTP session.
         * 
         * The option will be converted to a
         * &lt;code&gt;org.apache.camel.http.base.cookie.CookieHandler&lt;/code&gt; type.
         * 
         * Group: producer
         * 
         * @param cookieHandler the value to set
         * @return the dsl builder
         */
        default NettyHttpEndpointProducerBuilder cookieHandler(
                String cookieHandler) {
            doSetProperty("cookieHandler", cookieHandler);
            return this;
        }
        /**
         * Allows to use a timeout for the Netty producer when calling a remote
         * server. By default no timeout is in use. The value is in milli
         * seconds, so eg 30000 is 30 seconds. The requestTimeout is using
         * Netty's ReadTimeoutHandler to trigger the timeout.
         * 
         * The option is a: &lt;code&gt;long&lt;/code&gt; type.
         * 
         * Group: producer
         * 
         * @param requestTimeout the value to set
         * @return the dsl builder
         */
        default NettyHttpEndpointProducerBuilder requestTimeout(
                long requestTimeout) {
            doSetProperty("requestTimeout", requestTimeout);
            return this;
        }
        /**
         * Allows to use a timeout for the Netty producer when calling a remote
         * server. By default no timeout is in use. The value is in milli
         * seconds, so eg 30000 is 30 seconds. The requestTimeout is using
         * Netty's ReadTimeoutHandler to trigger the timeout.
         * 
         * The option will be converted to a &lt;code&gt;long&lt;/code&gt; type.
         * 
         * Group: producer
         * 
         * @param requestTimeout the value to set
         * @return the dsl builder
         */
        default NettyHttpEndpointProducerBuilder requestTimeout(
                String requestTimeout) {
            doSetProperty("requestTimeout", requestTimeout);
            return this;
        }
        /**
         * Option to disable throwing the HttpOperationFailedException in case
         * of failed responses from the remote server. This allows you to get
         * all responses regardless of the HTTP status code.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: true
         * Group: producer
         * 
         * @param throwExceptionOnFailure the value to set
         * @return the dsl builder
         */
        default NettyHttpEndpointProducerBuilder throwExceptionOnFailure(
                boolean throwExceptionOnFailure) {
            doSetProperty("throwExceptionOnFailure", throwExceptionOnFailure);
            return this;
        }
        /**
         * Option to disable throwing the HttpOperationFailedException in case
         * of failed responses from the remote server. This allows you to get
         * all responses regardless of the HTTP status code.
         * 
         * The option will be converted to a &lt;code&gt;boolean&lt;/code&gt;
         * type.
         * 
         * Default: true
         * Group: producer
         * 
         * @param throwExceptionOnFailure the value to set
         * @return the dsl builder
         */
        default NettyHttpEndpointProducerBuilder throwExceptionOnFailure(
                String throwExceptionOnFailure) {
            doSetProperty("throwExceptionOnFailure", throwExceptionOnFailure);
            return this;
        }
        /**
         * To enable/disable hostname verification on SSLEngine.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: false
         * Group:  security
         * 
         * @param hostnameVerification the value to set
         * @return the dsl builder
         */
        default NettyHttpEndpointProducerBuilder hostnameVerification(
                boolean hostnameVerification) {
            doSetProperty("hostnameVerification", hostnameVerification);
            return this;
        }
        /**
         * To enable/disable hostname verification on SSLEngine.
         * 
         * The option will be converted to a &lt;code&gt;boolean&lt;/code&gt;
         * type.
         * 
         * Default: false
         * Group:  security
         * 
         * @param hostnameVerification the value to set
         * @return the dsl builder
         */
        default NettyHttpEndpointProducerBuilder hostnameVerification(
                String hostnameVerification) {
            doSetProperty("hostnameVerification", hostnameVerification);
            return this;
        }
        /**
         * A list of decoders to be used. You can use a String which have values
         * separated by comma, and have the values be looked up in the Registry.
         * Just remember to prefix the value with # so Camel knows it should
         * lookup.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: codec
         * 
         * @param decoders the value to set
         * @return the dsl builder
         */
        default NettyHttpEndpointProducerBuilder decoders(String decoders) {
            doSetProperty("decoders", decoders);
            return this;
        }
        /**
         * A list of encoders to be used. You can use a String which have values
         * separated by comma, and have the values be looked up in the Registry.
         * Just remember to prefix the value with # so Camel knows it should
         * lookup.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: codec
         * 
         * @param encoders the value to set
         * @return the dsl builder
         */
        default NettyHttpEndpointProducerBuilder encoders(String encoders) {
            doSetProperty("encoders", encoders);
            return this;
        }
        /**
         * Which protocols to enable when using SSL.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Default: TLSv1.2,TLSv1.3
         * Group: security
         * 
         * @param enabledProtocols the value to set
         * @return the dsl builder
         */
        default NettyHttpEndpointProducerBuilder enabledProtocols(
                String enabledProtocols) {
            doSetProperty("enabledProtocols", enabledProtocols);
            return this;
        }
        /**
         * Client side certificate keystore to be used for encryption.
         * 
         * The option is a: &lt;code&gt;java.io.File&lt;/code&gt; type.
         * 
         * Group: security
         * 
         * @param keyStoreFile the value to set
         * @return the dsl builder
         */
        default NettyHttpEndpointProducerBuilder keyStoreFile(
                java.io.File keyStoreFile) {
            doSetProperty("keyStoreFile", keyStoreFile);
            return this;
        }
        /**
         * Client side certificate keystore to be used for encryption.
         * 
         * The option will be converted to a
         * &lt;code&gt;java.io.File&lt;/code&gt; type.
         * 
         * Group: security
         * 
         * @param keyStoreFile the value to set
         * @return the dsl builder
         */
        default NettyHttpEndpointProducerBuilder keyStoreFile(
                String keyStoreFile) {
            doSetProperty("keyStoreFile", keyStoreFile);
            return this;
        }
        /**
         * Keystore format to be used for payload encryption. Defaults to JKS if
         * not set.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: security
         * 
         * @param keyStoreFormat the value to set
         * @return the dsl builder
         */
        default NettyHttpEndpointProducerBuilder keyStoreFormat(
                String keyStoreFormat) {
            doSetProperty("keyStoreFormat", keyStoreFormat);
            return this;
        }
        /**
         * Client side certificate keystore to be used for encryption. Is loaded
         * by default from classpath, but you can prefix with classpath:, file:,
         * or http: to load the resource from different systems.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: security
         * 
         * @param keyStoreResource the value to set
         * @return the dsl builder
         */
        default NettyHttpEndpointProducerBuilder keyStoreResource(
                String keyStoreResource) {
            doSetProperty("keyStoreResource", keyStoreResource);
            return this;
        }
        /**
         * Password setting to use in order to encrypt/decrypt payloads sent
         * using SSH.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: security
         * 
         * @param passphrase the value to set
         * @return the dsl builder
         */
        default NettyHttpEndpointProducerBuilder passphrase(String passphrase) {
            doSetProperty("passphrase", passphrase);
            return this;
        }
        /**
         * Security provider to be used for payload encryption. Defaults to
         * SunX509 if not set.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: security
         * 
         * @param securityProvider the value to set
         * @return the dsl builder
         */
        default NettyHttpEndpointProducerBuilder securityProvider(
                String securityProvider) {
            doSetProperty("securityProvider", securityProvider);
            return this;
        }
        /**
         * Setting to specify whether SSL encryption is applied to this
         * endpoint.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: false
         * Group: security
         * 
         * @param ssl the value to set
         * @return the dsl builder
         */
        default NettyHttpEndpointProducerBuilder ssl(boolean ssl) {
            doSetProperty("ssl", ssl);
            return this;
        }
        /**
         * Setting to specify whether SSL encryption is applied to this
         * endpoint.
         * 
         * The option will be converted to a &lt;code&gt;boolean&lt;/code&gt;
         * type.
         * 
         * Default: false
         * Group: security
         * 
         * @param ssl the value to set
         * @return the dsl builder
         */
        default NettyHttpEndpointProducerBuilder ssl(String ssl) {
            doSetProperty("ssl", ssl);
            return this;
        }
        /**
         * When enabled and in SSL mode, then the Netty consumer will enrich the
         * Camel Message with headers having information about the client
         * certificate such as subject name, issuer name, serial number, and the
         * valid date range.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: false
         * Group: security
         * 
         * @param sslClientCertHeaders the value to set
         * @return the dsl builder
         */
        default NettyHttpEndpointProducerBuilder sslClientCertHeaders(
                boolean sslClientCertHeaders) {
            doSetProperty("sslClientCertHeaders", sslClientCertHeaders);
            return this;
        }
        /**
         * When enabled and in SSL mode, then the Netty consumer will enrich the
         * Camel Message with headers having information about the client
         * certificate such as subject name, issuer name, serial number, and the
         * valid date range.
         * 
         * The option will be converted to a &lt;code&gt;boolean&lt;/code&gt;
         * type.
         * 
         * Default: false
         * Group: security
         * 
         * @param sslClientCertHeaders the value to set
         * @return the dsl builder
         */
        default NettyHttpEndpointProducerBuilder sslClientCertHeaders(
                String sslClientCertHeaders) {
            doSetProperty("sslClientCertHeaders", sslClientCertHeaders);
            return this;
        }
        /**
         * To configure security using SSLContextParameters.
         * 
         * The option is a:
         * &lt;code&gt;org.apache.camel.support.jsse.SSLContextParameters&lt;/code&gt; type.
         * 
         * Group: security
         * 
         * @param sslContextParameters the value to set
         * @return the dsl builder
         */
        default NettyHttpEndpointProducerBuilder sslContextParameters(
                org.apache.camel.support.jsse.SSLContextParameters sslContextParameters) {
            doSetProperty("sslContextParameters", sslContextParameters);
            return this;
        }
        /**
         * To configure security using SSLContextParameters.
         * 
         * The option will be converted to a
         * &lt;code&gt;org.apache.camel.support.jsse.SSLContextParameters&lt;/code&gt; type.
         * 
         * Group: security
         * 
         * @param sslContextParameters the value to set
         * @return the dsl builder
         */
        default NettyHttpEndpointProducerBuilder sslContextParameters(
                String sslContextParameters) {
            doSetProperty("sslContextParameters", sslContextParameters);
            return this;
        }
        /**
         * Reference to a class that could be used to return an SSL Handler.
         * 
         * The option is a:
         * &lt;code&gt;io.netty.handler.ssl.SslHandler&lt;/code&gt; type.
         * 
         * Group: security
         * 
         * @param sslHandler the value to set
         * @return the dsl builder
         */
        default NettyHttpEndpointProducerBuilder sslHandler(
                io.netty.handler.ssl.SslHandler sslHandler) {
            doSetProperty("sslHandler", sslHandler);
            return this;
        }
        /**
         * Reference to a class that could be used to return an SSL Handler.
         * 
         * The option will be converted to a
         * &lt;code&gt;io.netty.handler.ssl.SslHandler&lt;/code&gt; type.
         * 
         * Group: security
         * 
         * @param sslHandler the value to set
         * @return the dsl builder
         */
        default NettyHttpEndpointProducerBuilder sslHandler(String sslHandler) {
            doSetProperty("sslHandler", sslHandler);
            return this;
        }
        /**
         * Server side certificate keystore to be used for encryption.
         * 
         * The option is a: &lt;code&gt;java.io.File&lt;/code&gt; type.
         * 
         * Group: security
         * 
         * @param trustStoreFile the value to set
         * @return the dsl builder
         */
        default NettyHttpEndpointProducerBuilder trustStoreFile(
                java.io.File trustStoreFile) {
            doSetProperty("trustStoreFile", trustStoreFile);
            return this;
        }
        /**
         * Server side certificate keystore to be used for encryption.
         * 
         * The option will be converted to a
         * &lt;code&gt;java.io.File&lt;/code&gt; type.
         * 
         * Group: security
         * 
         * @param trustStoreFile the value to set
         * @return the dsl builder
         */
        default NettyHttpEndpointProducerBuilder trustStoreFile(
                String trustStoreFile) {
            doSetProperty("trustStoreFile", trustStoreFile);
            return this;
        }
        /**
         * Server side certificate keystore to be used for encryption. Is loaded
         * by default from classpath, but you can prefix with classpath:, file:,
         * or http: to load the resource from different systems.
         * 
         * This option can also be loaded from an existing file, by prefixing
         * with file: or classpath: followed by the location of the file.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: security
         * 
         * @param trustStoreResource the value to set
         * @return the dsl builder
         */
        default NettyHttpEndpointProducerBuilder trustStoreResource(
                String trustStoreResource) {
            doSetProperty("trustStoreResource", trustStoreResource);
            return this;
        }
    }

    /**
     * Advanced builder for endpoint producers for the Netty HTTP component.
     */
    public interface AdvancedNettyHttpEndpointProducerBuilder
            extends
                EndpointProducerBuilder {
        default NettyHttpEndpointProducerBuilder basic() {
            return (NettyHttpEndpointProducerBuilder) this;
        }
        /**
         * To use a custom ClientInitializerFactory.
         * 
         * The option is a:
         * &lt;code&gt;org.apache.camel.component.netty.ClientInitializerFactory&lt;/code&gt; type.
         * 
         * Group: producer (advanced)
         * 
         * @param clientInitializerFactory the value to set
         * @return the dsl builder
         */
        default AdvancedNettyHttpEndpointProducerBuilder clientInitializerFactory(
                org.apache.camel.component.netty.ClientInitializerFactory clientInitializerFactory) {
            doSetProperty("clientInitializerFactory", clientInitializerFactory);
            return this;
        }
        /**
         * To use a custom ClientInitializerFactory.
         * 
         * The option will be converted to a
         * &lt;code&gt;org.apache.camel.component.netty.ClientInitializerFactory&lt;/code&gt; type.
         * 
         * Group: producer (advanced)
         * 
         * @param clientInitializerFactory the value to set
         * @return the dsl builder
         */
        default AdvancedNettyHttpEndpointProducerBuilder clientInitializerFactory(
                String clientInitializerFactory) {
            doSetProperty("clientInitializerFactory", clientInitializerFactory);
            return this;
        }
        /**
         * Channels can be lazily created to avoid exceptions, if the remote
         * server is not up and running when the Camel producer is started.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: true
         * Group: producer (advanced)
         * 
         * @param lazyChannelCreation the value to set
         * @return the dsl builder
         */
        default AdvancedNettyHttpEndpointProducerBuilder lazyChannelCreation(
                boolean lazyChannelCreation) {
            doSetProperty("lazyChannelCreation", lazyChannelCreation);
            return this;
        }
        /**
         * Channels can be lazily created to avoid exceptions, if the remote
         * server is not up and running when the Camel producer is started.
         * 
         * The option will be converted to a &lt;code&gt;boolean&lt;/code&gt;
         * type.
         * 
         * Default: true
         * Group: producer (advanced)
         * 
         * @param lazyChannelCreation the value to set
         * @return the dsl builder
         */
        default AdvancedNettyHttpEndpointProducerBuilder lazyChannelCreation(
                String lazyChannelCreation) {
            doSetProperty("lazyChannelCreation", lazyChannelCreation);
            return this;
        }
        /**
         * Whether the producer should be started lazy (on the first message).
         * By starting lazy you can use this to allow CamelContext and routes to
         * startup in situations where a producer may otherwise fail during
         * starting and cause the route to fail being started. By deferring this
         * startup to be lazy then the startup failure can be handled during
         * routing messages via Camel's routing error handlers. Beware that when
         * the first message is processed then creating and starting the
         * producer may take a little time and prolong the total processing time
         * of the processing.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: false
         * Group: producer (advanced)
         * 
         * @param lazyStartProducer the value to set
         * @return the dsl builder
         */
        default AdvancedNettyHttpEndpointProducerBuilder lazyStartProducer(
                boolean lazyStartProducer) {
            doSetProperty("lazyStartProducer", lazyStartProducer);
            return this;
        }
        /**
         * Whether the producer should be started lazy (on the first message).
         * By starting lazy you can use this to allow CamelContext and routes to
         * startup in situations where a producer may otherwise fail during
         * starting and cause the route to fail being started. By deferring this
         * startup to be lazy then the startup failure can be handled during
         * routing messages via Camel's routing error handlers. Beware that when
         * the first message is processed then creating and starting the
         * producer may take a little time and prolong the total processing time
         * of the processing.
         * 
         * The option will be converted to a &lt;code&gt;boolean&lt;/code&gt;
         * type.
         * 
         * Default: false
         * Group: producer (advanced)
         * 
         * @param lazyStartProducer the value to set
         * @return the dsl builder
         */
        default AdvancedNettyHttpEndpointProducerBuilder lazyStartProducer(
                String lazyStartProducer) {
            doSetProperty("lazyStartProducer", lazyStartProducer);
            return this;
        }
        /**
         * The status codes which are considered a success response. The values
         * are inclusive. Multiple ranges can be defined, separated by comma,
         * e.g. 200-204,209,301-304. Each range must be a single number or
         * from-to with the dash included. The default range is 200-299.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Default: 200-299
         * Group: producer (advanced)
         * 
         * @param okStatusCodeRange the value to set
         * @return the dsl builder
         */
        default AdvancedNettyHttpEndpointProducerBuilder okStatusCodeRange(
                String okStatusCodeRange) {
            doSetProperty("okStatusCodeRange", okStatusCodeRange);
            return this;
        }
        /**
         * Sets the value for the blockWhenExhausted configuration attribute. It
         * determines whether to block when the borrowObject() method is invoked
         * when the pool is exhausted (the maximum number of active objects has
         * been reached).
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: true
         * Group: producer (advanced)
         * 
         * @param producerPoolBlockWhenExhausted the value to set
         * @return the dsl builder
         */
        default AdvancedNettyHttpEndpointProducerBuilder producerPoolBlockWhenExhausted(
                boolean producerPoolBlockWhenExhausted) {
            doSetProperty("producerPoolBlockWhenExhausted", producerPoolBlockWhenExhausted);
            return this;
        }
        /**
         * Sets the value for the blockWhenExhausted configuration attribute. It
         * determines whether to block when the borrowObject() method is invoked
         * when the pool is exhausted (the maximum number of active objects has
         * been reached).
         * 
         * The option will be converted to a &lt;code&gt;boolean&lt;/code&gt;
         * type.
         * 
         * Default: true
         * Group: producer (advanced)
         * 
         * @param producerPoolBlockWhenExhausted the value to set
         * @return the dsl builder
         */
        default AdvancedNettyHttpEndpointProducerBuilder producerPoolBlockWhenExhausted(
                String producerPoolBlockWhenExhausted) {
            doSetProperty("producerPoolBlockWhenExhausted", producerPoolBlockWhenExhausted);
            return this;
        }
        /**
         * Whether producer pool is enabled or not. Important: If you turn this
         * off then a single shared connection is used for the producer, also if
         * you are doing request/reply. That means there is a potential issue
         * with interleaved responses if replies comes back out-of-order.
         * Therefore you need to have a correlation id in both the request and
         * reply messages so you can properly correlate the replies to the Camel
         * callback that is responsible for continue processing the message in
         * Camel. To do this you need to implement
         * NettyCamelStateCorrelationManager as correlation manager and
         * configure it via the correlationManager option. See also the
         * correlationManager option for more details.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: true
         * Group: producer (advanced)
         * 
         * @param producerPoolEnabled the value to set
         * @return the dsl builder
         */
        default AdvancedNettyHttpEndpointProducerBuilder producerPoolEnabled(
                boolean producerPoolEnabled) {
            doSetProperty("producerPoolEnabled", producerPoolEnabled);
            return this;
        }
        /**
         * Whether producer pool is enabled or not. Important: If you turn this
         * off then a single shared connection is used for the producer, also if
         * you are doing request/reply. That means there is a potential issue
         * with interleaved responses if replies comes back out-of-order.
         * Therefore you need to have a correlation id in both the request and
         * reply messages so you can properly correlate the replies to the Camel
         * callback that is responsible for continue processing the message in
         * Camel. To do this you need to implement
         * NettyCamelStateCorrelationManager as correlation manager and
         * configure it via the correlationManager option. See also the
         * correlationManager option for more details.
         * 
         * The option will be converted to a &lt;code&gt;boolean&lt;/code&gt;
         * type.
         * 
         * Default: true
         * Group: producer (advanced)
         * 
         * @param producerPoolEnabled the value to set
         * @return the dsl builder
         */
        default AdvancedNettyHttpEndpointProducerBuilder producerPoolEnabled(
                String producerPoolEnabled) {
            doSetProperty("producerPoolEnabled", producerPoolEnabled);
            return this;
        }
        /**
         * Sets the cap on the number of idle instances in the pool.
         * 
         * The option is a: &lt;code&gt;int&lt;/code&gt; type.
         * 
         * Default: 100
         * Group: producer (advanced)
         * 
         * @param producerPoolMaxIdle the value to set
         * @return the dsl builder
         */
        default AdvancedNettyHttpEndpointProducerBuilder producerPoolMaxIdle(
                int producerPoolMaxIdle) {
            doSetProperty("producerPoolMaxIdle", producerPoolMaxIdle);
            return this;
        }
        /**
         * Sets the cap on the number of idle instances in the pool.
         * 
         * The option will be converted to a &lt;code&gt;int&lt;/code&gt; type.
         * 
         * Default: 100
         * Group: producer (advanced)
         * 
         * @param producerPoolMaxIdle the value to set
         * @return the dsl builder
         */
        default AdvancedNettyHttpEndpointProducerBuilder producerPoolMaxIdle(
                String producerPoolMaxIdle) {
            doSetProperty("producerPoolMaxIdle", producerPoolMaxIdle);
            return this;
        }
        /**
         * Sets the cap on the number of objects that can be allocated by the
         * pool (checked out to clients, or idle awaiting checkout) at a given
         * time. Use a negative value for no limit.
         * 
         * The option is a: &lt;code&gt;int&lt;/code&gt; type.
         * 
         * Default: -1
         * Group: producer (advanced)
         * 
         * @param producerPoolMaxTotal the value to set
         * @return the dsl builder
         */
        default AdvancedNettyHttpEndpointProducerBuilder producerPoolMaxTotal(
                int producerPoolMaxTotal) {
            doSetProperty("producerPoolMaxTotal", producerPoolMaxTotal);
            return this;
        }
        /**
         * Sets the cap on the number of objects that can be allocated by the
         * pool (checked out to clients, or idle awaiting checkout) at a given
         * time. Use a negative value for no limit.
         * 
         * The option will be converted to a &lt;code&gt;int&lt;/code&gt; type.
         * 
         * Default: -1
         * Group: producer (advanced)
         * 
         * @param producerPoolMaxTotal the value to set
         * @return the dsl builder
         */
        default AdvancedNettyHttpEndpointProducerBuilder producerPoolMaxTotal(
                String producerPoolMaxTotal) {
            doSetProperty("producerPoolMaxTotal", producerPoolMaxTotal);
            return this;
        }
        /**
         * Sets the maximum duration (value in millis) the borrowObject() method
         * should block before throwing an exception when the pool is exhausted
         * and producerPoolBlockWhenExhausted is true. When less than 0, the
         * borrowObject() method may block indefinitely.
         * 
         * The option is a: &lt;code&gt;long&lt;/code&gt; type.
         * 
         * Default: -1
         * Group: producer (advanced)
         * 
         * @param producerPoolMaxWait the value to set
         * @return the dsl builder
         */
        default AdvancedNettyHttpEndpointProducerBuilder producerPoolMaxWait(
                long producerPoolMaxWait) {
            doSetProperty("producerPoolMaxWait", producerPoolMaxWait);
            return this;
        }
        /**
         * Sets the maximum duration (value in millis) the borrowObject() method
         * should block before throwing an exception when the pool is exhausted
         * and producerPoolBlockWhenExhausted is true. When less than 0, the
         * borrowObject() method may block indefinitely.
         * 
         * The option will be converted to a &lt;code&gt;long&lt;/code&gt; type.
         * 
         * Default: -1
         * Group: producer (advanced)
         * 
         * @param producerPoolMaxWait the value to set
         * @return the dsl builder
         */
        default AdvancedNettyHttpEndpointProducerBuilder producerPoolMaxWait(
                String producerPoolMaxWait) {
            doSetProperty("producerPoolMaxWait", producerPoolMaxWait);
            return this;
        }
        /**
         * Sets the minimum amount of time (value in millis) an object may sit
         * idle in the pool before it is eligible for eviction by the idle
         * object evictor.
         * 
         * The option is a: &lt;code&gt;long&lt;/code&gt; type.
         * 
         * Default: 300000
         * Group: producer (advanced)
         * 
         * @param producerPoolMinEvictableIdle the value to set
         * @return the dsl builder
         */
        default AdvancedNettyHttpEndpointProducerBuilder producerPoolMinEvictableIdle(
                long producerPoolMinEvictableIdle) {
            doSetProperty("producerPoolMinEvictableIdle", producerPoolMinEvictableIdle);
            return this;
        }
        /**
         * Sets the minimum amount of time (value in millis) an object may sit
         * idle in the pool before it is eligible for eviction by the idle
         * object evictor.
         * 
         * The option will be converted to a &lt;code&gt;long&lt;/code&gt; type.
         * 
         * Default: 300000
         * Group: producer (advanced)
         * 
         * @param producerPoolMinEvictableIdle the value to set
         * @return the dsl builder
         */
        default AdvancedNettyHttpEndpointProducerBuilder producerPoolMinEvictableIdle(
                String producerPoolMinEvictableIdle) {
            doSetProperty("producerPoolMinEvictableIdle", producerPoolMinEvictableIdle);
            return this;
        }
        /**
         * Sets the minimum number of instances allowed in the producer pool
         * before the evictor thread (if active) spawns new objects.
         * 
         * The option is a: &lt;code&gt;int&lt;/code&gt; type.
         * 
         * Group: producer (advanced)
         * 
         * @param producerPoolMinIdle the value to set
         * @return the dsl builder
         */
        default AdvancedNettyHttpEndpointProducerBuilder producerPoolMinIdle(
                int producerPoolMinIdle) {
            doSetProperty("producerPoolMinIdle", producerPoolMinIdle);
            return this;
        }
        /**
         * Sets the minimum number of instances allowed in the producer pool
         * before the evictor thread (if active) spawns new objects.
         * 
         * The option will be converted to a &lt;code&gt;int&lt;/code&gt; type.
         * 
         * Group: producer (advanced)
         * 
         * @param producerPoolMinIdle the value to set
         * @return the dsl builder
         */
        default AdvancedNettyHttpEndpointProducerBuilder producerPoolMinIdle(
                String producerPoolMinIdle) {
            doSetProperty("producerPoolMinIdle", producerPoolMinIdle);
            return this;
        }
        /**
         * Sets whether to use a relative path in HTTP requests.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: true
         * Group: producer (advanced)
         * 
         * @param useRelativePath the value to set
         * @return the dsl builder
         */
        default AdvancedNettyHttpEndpointProducerBuilder useRelativePath(
                boolean useRelativePath) {
            doSetProperty("useRelativePath", useRelativePath);
            return this;
        }
        /**
         * Sets whether to use a relative path in HTTP requests.
         * 
         * The option will be converted to a &lt;code&gt;boolean&lt;/code&gt;
         * type.
         * 
         * Default: true
         * Group: producer (advanced)
         * 
         * @param useRelativePath the value to set
         * @return the dsl builder
         */
        default AdvancedNettyHttpEndpointProducerBuilder useRelativePath(
                String useRelativePath) {
            doSetProperty("useRelativePath", useRelativePath);
            return this;
        }
        /**
         * Only used for TCP when transferExchange is true. When set to true,
         * serializable objects in headers and properties will be added to the
         * exchange. Otherwise Camel will exclude any non-serializable objects
         * and log it at WARN level.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: false
         * Group: advanced
         * 
         * @param allowSerializedHeaders the value to set
         * @return the dsl builder
         */
        default AdvancedNettyHttpEndpointProducerBuilder allowSerializedHeaders(
                boolean allowSerializedHeaders) {
            doSetProperty("allowSerializedHeaders", allowSerializedHeaders);
            return this;
        }
        /**
         * Only used for TCP when transferExchange is true. When set to true,
         * serializable objects in headers and properties will be added to the
         * exchange. Otherwise Camel will exclude any non-serializable objects
         * and log it at WARN level.
         * 
         * The option will be converted to a &lt;code&gt;boolean&lt;/code&gt;
         * type.
         * 
         * Default: false
         * Group: advanced
         * 
         * @param allowSerializedHeaders the value to set
         * @return the dsl builder
         */
        default AdvancedNettyHttpEndpointProducerBuilder allowSerializedHeaders(
                String allowSerializedHeaders) {
            doSetProperty("allowSerializedHeaders", allowSerializedHeaders);
            return this;
        }
        /**
         * To use a explicit ChannelGroup.
         * 
         * The option is a:
         * &lt;code&gt;io.netty.channel.group.ChannelGroup&lt;/code&gt; type.
         * 
         * Group: advanced
         * 
         * @param channelGroup the value to set
         * @return the dsl builder
         */
        default AdvancedNettyHttpEndpointProducerBuilder channelGroup(
                io.netty.channel.group.ChannelGroup channelGroup) {
            doSetProperty("channelGroup", channelGroup);
            return this;
        }
        /**
         * To use a explicit ChannelGroup.
         * 
         * The option will be converted to a
         * &lt;code&gt;io.netty.channel.group.ChannelGroup&lt;/code&gt; type.
         * 
         * Group: advanced
         * 
         * @param channelGroup the value to set
         * @return the dsl builder
         */
        default AdvancedNettyHttpEndpointProducerBuilder channelGroup(
                String channelGroup) {
            doSetProperty("channelGroup", channelGroup);
            return this;
        }
        /**
         * To use a custom configured NettyHttpConfiguration for configuring
         * this endpoint.
         * 
         * The option is a:
         * &lt;code&gt;org.apache.camel.component.netty.http.NettyHttpConfiguration&lt;/code&gt; type.
         * 
         * Group: advanced
         * 
         * @param configuration the value to set
         * @return the dsl builder
         */
        default AdvancedNettyHttpEndpointProducerBuilder configuration(
                org.apache.camel.component.netty.http.NettyHttpConfiguration configuration) {
            doSetProperty("configuration", configuration);
            return this;
        }
        /**
         * To use a custom configured NettyHttpConfiguration for configuring
         * this endpoint.
         * 
         * The option will be converted to a
         * &lt;code&gt;org.apache.camel.component.netty.http.NettyHttpConfiguration&lt;/code&gt; type.
         * 
         * Group: advanced
         * 
         * @param configuration the value to set
         * @return the dsl builder
         */
        default AdvancedNettyHttpEndpointProducerBuilder configuration(
                String configuration) {
            doSetProperty("configuration", configuration);
            return this;
        }
        /**
         * Determines whether or not the raw input stream from Netty
         * HttpRequest#getContent() or HttpResponset#getContent() is cached or
         * not (Camel will read the stream into a in light-weight memory based
         * Stream caching) cache. By default Camel will cache the Netty input
         * stream to support reading it multiple times to ensure it Camel can
         * retrieve all data from the stream. However you can set this option to
         * true when you for example need to access the raw stream, such as
         * streaming it directly to a file or other persistent store. Mind that
         * if you enable this option, then you cannot read the Netty stream
         * multiple times out of the box, and you would need manually to reset
         * the reader index on the Netty raw stream. Also Netty will auto-close
         * the Netty stream when the Netty HTTP server/HTTP client is done
         * processing, which means that if the asynchronous routing engine is in
         * use then any asynchronous thread that may continue routing the
         * org.apache.camel.Exchange may not be able to read the Netty stream,
         * because Netty has closed it.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: false
         * Group: advanced
         * 
         * @param disableStreamCache the value to set
         * @return the dsl builder
         */
        default AdvancedNettyHttpEndpointProducerBuilder disableStreamCache(
                boolean disableStreamCache) {
            doSetProperty("disableStreamCache", disableStreamCache);
            return this;
        }
        /**
         * Determines whether or not the raw input stream from Netty
         * HttpRequest#getContent() or HttpResponset#getContent() is cached or
         * not (Camel will read the stream into a in light-weight memory based
         * Stream caching) cache. By default Camel will cache the Netty input
         * stream to support reading it multiple times to ensure it Camel can
         * retrieve all data from the stream. However you can set this option to
         * true when you for example need to access the raw stream, such as
         * streaming it directly to a file or other persistent store. Mind that
         * if you enable this option, then you cannot read the Netty stream
         * multiple times out of the box, and you would need manually to reset
         * the reader index on the Netty raw stream. Also Netty will auto-close
         * the Netty stream when the Netty HTTP server/HTTP client is done
         * processing, which means that if the asynchronous routing engine is in
         * use then any asynchronous thread that may continue routing the
         * org.apache.camel.Exchange may not be able to read the Netty stream,
         * because Netty has closed it.
         * 
         * The option will be converted to a &lt;code&gt;boolean&lt;/code&gt;
         * type.
         * 
         * Default: false
         * Group: advanced
         * 
         * @param disableStreamCache the value to set
         * @return the dsl builder
         */
        default AdvancedNettyHttpEndpointProducerBuilder disableStreamCache(
                String disableStreamCache) {
            doSetProperty("disableStreamCache", disableStreamCache);
            return this;
        }
        /**
         * To use a custom org.apache.camel.spi.HeaderFilterStrategy to filter
         * headers.
         * 
         * The option is a:
         * &lt;code&gt;org.apache.camel.spi.HeaderFilterStrategy&lt;/code&gt;
         * type.
         * 
         * Group: advanced
         * 
         * @param headerFilterStrategy the value to set
         * @return the dsl builder
         */
        default AdvancedNettyHttpEndpointProducerBuilder headerFilterStrategy(
                org.apache.camel.spi.HeaderFilterStrategy headerFilterStrategy) {
            doSetProperty("headerFilterStrategy", headerFilterStrategy);
            return this;
        }
        /**
         * To use a custom org.apache.camel.spi.HeaderFilterStrategy to filter
         * headers.
         * 
         * The option will be converted to a
         * &lt;code&gt;org.apache.camel.spi.HeaderFilterStrategy&lt;/code&gt;
         * type.
         * 
         * Group: advanced
         * 
         * @param headerFilterStrategy the value to set
         * @return the dsl builder
         */
        default AdvancedNettyHttpEndpointProducerBuilder headerFilterStrategy(
                String headerFilterStrategy) {
            doSetProperty("headerFilterStrategy", headerFilterStrategy);
            return this;
        }
        /**
         * Whether to use native transport instead of NIO. Native transport
         * takes advantage of the host operating system and is only supported on
         * some platforms. You need to add the netty JAR for the host operating
         * system you are using. See more details at:
         * http://netty.io/wiki/native-transports.html.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: false
         * Group: advanced
         * 
         * @param nativeTransport the value to set
         * @return the dsl builder
         */
        default AdvancedNettyHttpEndpointProducerBuilder nativeTransport(
                boolean nativeTransport) {
            doSetProperty("nativeTransport", nativeTransport);
            return this;
        }
        /**
         * Whether to use native transport instead of NIO. Native transport
         * takes advantage of the host operating system and is only supported on
         * some platforms. You need to add the netty JAR for the host operating
         * system you are using. See more details at:
         * http://netty.io/wiki/native-transports.html.
         * 
         * The option will be converted to a &lt;code&gt;boolean&lt;/code&gt;
         * type.
         * 
         * Default: false
         * Group: advanced
         * 
         * @param nativeTransport the value to set
         * @return the dsl builder
         */
        default AdvancedNettyHttpEndpointProducerBuilder nativeTransport(
                String nativeTransport) {
            doSetProperty("nativeTransport", nativeTransport);
            return this;
        }
        /**
         * To use a custom
         * org.apache.camel.component.netty.http.NettyHttpBinding for binding
         * to/from Netty and Camel Message API.
         * 
         * The option is a:
         * &lt;code&gt;org.apache.camel.component.netty.http.NettyHttpBinding&lt;/code&gt; type.
         * 
         * Group: advanced
         * 
         * @param nettyHttpBinding the value to set
         * @return the dsl builder
         */
        default AdvancedNettyHttpEndpointProducerBuilder nettyHttpBinding(
                org.apache.camel.component.netty.http.NettyHttpBinding nettyHttpBinding) {
            doSetProperty("nettyHttpBinding", nettyHttpBinding);
            return this;
        }
        /**
         * To use a custom
         * org.apache.camel.component.netty.http.NettyHttpBinding for binding
         * to/from Netty and Camel Message API.
         * 
         * The option will be converted to a
         * &lt;code&gt;org.apache.camel.component.netty.http.NettyHttpBinding&lt;/code&gt; type.
         * 
         * Group: advanced
         * 
         * @param nettyHttpBinding the value to set
         * @return the dsl builder
         */
        default AdvancedNettyHttpEndpointProducerBuilder nettyHttpBinding(
                String nettyHttpBinding) {
            doSetProperty("nettyHttpBinding", nettyHttpBinding);
            return this;
        }
        /**
         * Allows to configure additional netty options using option. as prefix.
         * For example option.child.keepAlive=false to set the netty option
         * child.keepAlive=false. See the Netty documentation for possible
         * options that can be used.
         * 
         * The option is a: &lt;code&gt;java.util.Map&amp;lt;java.lang.String,
         * java.lang.Object&amp;gt;&lt;/code&gt; type.
         * The option is multivalued, and you can use the options(String,
         * Object) method to add a value (call the method multiple times to set
         * more values).
         * 
         * Group: advanced
         * 
         * @param key the option key
         * @param value the option value
         * @return the dsl builder
         */
        default AdvancedNettyHttpEndpointProducerBuilder options(
                String key,
                Object value) {
            doSetMultiValueProperty("options", "option." + key, value);
            return this;
        }
        /**
         * Allows to configure additional netty options using option. as prefix.
         * For example option.child.keepAlive=false to set the netty option
         * child.keepAlive=false. See the Netty documentation for possible
         * options that can be used.
         * 
         * The option is a: &lt;code&gt;java.util.Map&amp;lt;java.lang.String,
         * java.lang.Object&amp;gt;&lt;/code&gt; type.
         * The option is multivalued, and you can use the options(String,
         * Object) method to add a value (call the method multiple times to set
         * more values).
         * 
         * Group: advanced
         * 
         * @param values the values
         * @return the dsl builder
         */
        default AdvancedNettyHttpEndpointProducerBuilder options(Map values) {
            doSetMultiValueProperties("options", "option.", values);
            return this;
        }
        /**
         * The TCP/UDP buffer sizes to be used during inbound communication.
         * Size is bytes.
         * 
         * The option is a: &lt;code&gt;int&lt;/code&gt; type.
         * 
         * Default: 65536
         * Group: advanced
         * 
         * @param receiveBufferSize the value to set
         * @return the dsl builder
         */
        default AdvancedNettyHttpEndpointProducerBuilder receiveBufferSize(
                int receiveBufferSize) {
            doSetProperty("receiveBufferSize", receiveBufferSize);
            return this;
        }
        /**
         * The TCP/UDP buffer sizes to be used during inbound communication.
         * Size is bytes.
         * 
         * The option will be converted to a &lt;code&gt;int&lt;/code&gt; type.
         * 
         * Default: 65536
         * Group: advanced
         * 
         * @param receiveBufferSize the value to set
         * @return the dsl builder
         */
        default AdvancedNettyHttpEndpointProducerBuilder receiveBufferSize(
                String receiveBufferSize) {
            doSetProperty("receiveBufferSize", receiveBufferSize);
            return this;
        }
        /**
         * Configures the buffer size predictor. See details at Jetty
         * documentation and this mail thread.
         * 
         * The option is a: &lt;code&gt;int&lt;/code&gt; type.
         * 
         * Group: advanced
         * 
         * @param receiveBufferSizePredictor the value to set
         * @return the dsl builder
         */
        default AdvancedNettyHttpEndpointProducerBuilder receiveBufferSizePredictor(
                int receiveBufferSizePredictor) {
            doSetProperty("receiveBufferSizePredictor", receiveBufferSizePredictor);
            return this;
        }
        /**
         * Configures the buffer size predictor. See details at Jetty
         * documentation and this mail thread.
         * 
         * The option will be converted to a &lt;code&gt;int&lt;/code&gt; type.
         * 
         * Group: advanced
         * 
         * @param receiveBufferSizePredictor the value to set
         * @return the dsl builder
         */
        default AdvancedNettyHttpEndpointProducerBuilder receiveBufferSizePredictor(
                String receiveBufferSizePredictor) {
            doSetProperty("receiveBufferSizePredictor", receiveBufferSizePredictor);
            return this;
        }
        /**
         * The TCP/UDP buffer sizes to be used during outbound communication.
         * Size is bytes.
         * 
         * The option is a: &lt;code&gt;int&lt;/code&gt; type.
         * 
         * Default: 65536
         * Group: advanced
         * 
         * @param sendBufferSize the value to set
         * @return the dsl builder
         */
        default AdvancedNettyHttpEndpointProducerBuilder sendBufferSize(
                int sendBufferSize) {
            doSetProperty("sendBufferSize", sendBufferSize);
            return this;
        }
        /**
         * The TCP/UDP buffer sizes to be used during outbound communication.
         * Size is bytes.
         * 
         * The option will be converted to a &lt;code&gt;int&lt;/code&gt; type.
         * 
         * Default: 65536
         * Group: advanced
         * 
         * @param sendBufferSize the value to set
         * @return the dsl builder
         */
        default AdvancedNettyHttpEndpointProducerBuilder sendBufferSize(
                String sendBufferSize) {
            doSetProperty("sendBufferSize", sendBufferSize);
            return this;
        }
        /**
         * Sets whether synchronous processing should be strictly used.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: false
         * Group: advanced
         * 
         * @param synchronous the value to set
         * @return the dsl builder
         */
        default AdvancedNettyHttpEndpointProducerBuilder synchronous(
                boolean synchronous) {
            doSetProperty("synchronous", synchronous);
            return this;
        }
        /**
         * Sets whether synchronous processing should be strictly used.
         * 
         * The option will be converted to a &lt;code&gt;boolean&lt;/code&gt;
         * type.
         * 
         * Default: false
         * Group: advanced
         * 
         * @param synchronous the value to set
         * @return the dsl builder
         */
        default AdvancedNettyHttpEndpointProducerBuilder synchronous(
                String synchronous) {
            doSetProperty("synchronous", synchronous);
            return this;
        }
        /**
         * If enabled and an Exchange failed processing on the consumer side,
         * and if the caused Exception was send back serialized in the response
         * as a application/x-java-serialized-object content type. On the
         * producer side the exception will be deserialized and thrown as is,
         * instead of the HttpOperationFailedException. The caused exception is
         * required to be serialized. This is by default turned off. If you
         * enable this then be aware that Java will deserialize the incoming
         * data from the request to Java and that can be a potential security
         * risk.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: false
         * Group: advanced
         * 
         * @param transferException the value to set
         * @return the dsl builder
         */
        default AdvancedNettyHttpEndpointProducerBuilder transferException(
                boolean transferException) {
            doSetProperty("transferException", transferException);
            return this;
        }
        /**
         * If enabled and an Exchange failed processing on the consumer side,
         * and if the caused Exception was send back serialized in the response
         * as a application/x-java-serialized-object content type. On the
         * producer side the exception will be deserialized and thrown as is,
         * instead of the HttpOperationFailedException. The caused exception is
         * required to be serialized. This is by default turned off. If you
         * enable this then be aware that Java will deserialize the incoming
         * data from the request to Java and that can be a potential security
         * risk.
         * 
         * The option will be converted to a &lt;code&gt;boolean&lt;/code&gt;
         * type.
         * 
         * Default: false
         * Group: advanced
         * 
         * @param transferException the value to set
         * @return the dsl builder
         */
        default AdvancedNettyHttpEndpointProducerBuilder transferException(
                String transferException) {
            doSetProperty("transferException", transferException);
            return this;
        }
        /**
         * Only used for TCP. You can transfer the exchange over the wire
         * instead of just the body. The following fields are transferred: In
         * body, Out body, fault body, In headers, Out headers, fault headers,
         * exchange properties, exchange exception. This requires that the
         * objects are serializable. Camel will exclude any non-serializable
         * objects and log it at WARN level.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: false
         * Group: advanced
         * 
         * @param transferExchange the value to set
         * @return the dsl builder
         */
        default AdvancedNettyHttpEndpointProducerBuilder transferExchange(
                boolean transferExchange) {
            doSetProperty("transferExchange", transferExchange);
            return this;
        }
        /**
         * Only used for TCP. You can transfer the exchange over the wire
         * instead of just the body. The following fields are transferred: In
         * body, Out body, fault body, In headers, Out headers, fault headers,
         * exchange properties, exchange exception. This requires that the
         * objects are serializable. Camel will exclude any non-serializable
         * objects and log it at WARN level.
         * 
         * The option will be converted to a &lt;code&gt;boolean&lt;/code&gt;
         * type.
         * 
         * Default: false
         * Group: advanced
         * 
         * @param transferExchange the value to set
         * @return the dsl builder
         */
        default AdvancedNettyHttpEndpointProducerBuilder transferExchange(
                String transferExchange) {
            doSetProperty("transferExchange", transferExchange);
            return this;
        }
        /**
         * Path to unix domain socket to use instead of inet socket. Host and
         * port parameters will not be used, however required. It is ok to set
         * dummy values for them. Must be used with nativeTransport=true and
         * clientMode=false.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: advanced
         * 
         * @param unixDomainSocketPath the value to set
         * @return the dsl builder
         */
        default AdvancedNettyHttpEndpointProducerBuilder unixDomainSocketPath(
                String unixDomainSocketPath) {
            doSetProperty("unixDomainSocketPath", unixDomainSocketPath);
            return this;
        }
        /**
         * When netty works on nio mode, it uses default workerCount parameter
         * from Netty (which is cpu_core_threads x 2). User can use this option
         * to override the default workerCount from Netty.
         * 
         * The option is a: &lt;code&gt;int&lt;/code&gt; type.
         * 
         * Group: advanced
         * 
         * @param workerCount the value to set
         * @return the dsl builder
         */
        default AdvancedNettyHttpEndpointProducerBuilder workerCount(
                int workerCount) {
            doSetProperty("workerCount", workerCount);
            return this;
        }
        /**
         * When netty works on nio mode, it uses default workerCount parameter
         * from Netty (which is cpu_core_threads x 2). User can use this option
         * to override the default workerCount from Netty.
         * 
         * The option will be converted to a &lt;code&gt;int&lt;/code&gt; type.
         * 
         * Group: advanced
         * 
         * @param workerCount the value to set
         * @return the dsl builder
         */
        default AdvancedNettyHttpEndpointProducerBuilder workerCount(
                String workerCount) {
            doSetProperty("workerCount", workerCount);
            return this;
        }
        /**
         * To use a explicit EventLoopGroup as the boss thread pool. For example
         * to share a thread pool with multiple consumers or producers. By
         * default each consumer or producer has their own worker pool with 2 x
         * cpu count core threads.
         * 
         * The option is a:
         * &lt;code&gt;io.netty.channel.EventLoopGroup&lt;/code&gt; type.
         * 
         * Group: advanced
         * 
         * @param workerGroup the value to set
         * @return the dsl builder
         */
        default AdvancedNettyHttpEndpointProducerBuilder workerGroup(
                io.netty.channel.EventLoopGroup workerGroup) {
            doSetProperty("workerGroup", workerGroup);
            return this;
        }
        /**
         * To use a explicit EventLoopGroup as the boss thread pool. For example
         * to share a thread pool with multiple consumers or producers. By
         * default each consumer or producer has their own worker pool with 2 x
         * cpu count core threads.
         * 
         * The option will be converted to a
         * &lt;code&gt;io.netty.channel.EventLoopGroup&lt;/code&gt; type.
         * 
         * Group: advanced
         * 
         * @param workerGroup the value to set
         * @return the dsl builder
         */
        default AdvancedNettyHttpEndpointProducerBuilder workerGroup(
                String workerGroup) {
            doSetProperty("workerGroup", workerGroup);
            return this;
        }
    }

    /**
     * Builder for endpoint for the Netty HTTP component.
     */
    public interface NettyHttpEndpointBuilder
            extends
                NettyHttpEndpointConsumerBuilder,
                NettyHttpEndpointProducerBuilder {
        default AdvancedNettyHttpEndpointBuilder advanced() {
            return (AdvancedNettyHttpEndpointBuilder) this;
        }
        /**
         * If the option is true, the producer will ignore the
         * NettyHttpConstants.HTTP_URI header, and use the endpoint's URI for
         * request. You may also set the throwExceptionOnFailure to be false to
         * let the producer send all the fault response back. The consumer
         * working in the bridge mode will skip the gzip compression and WWW URL
         * form encoding (by adding the Exchange.SKIP_GZIP_ENCODING and
         * Exchange.SKIP_WWW_FORM_URLENCODED headers to the consumed exchange).
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: false
         * Group: common
         * 
         * @param bridgeEndpoint the value to set
         * @return the dsl builder
         */
        default NettyHttpEndpointBuilder bridgeEndpoint(boolean bridgeEndpoint) {
            doSetProperty("bridgeEndpoint", bridgeEndpoint);
            return this;
        }
        /**
         * If the option is true, the producer will ignore the
         * NettyHttpConstants.HTTP_URI header, and use the endpoint's URI for
         * request. You may also set the throwExceptionOnFailure to be false to
         * let the producer send all the fault response back. The consumer
         * working in the bridge mode will skip the gzip compression and WWW URL
         * form encoding (by adding the Exchange.SKIP_GZIP_ENCODING and
         * Exchange.SKIP_WWW_FORM_URLENCODED headers to the consumed exchange).
         * 
         * The option will be converted to a &lt;code&gt;boolean&lt;/code&gt;
         * type.
         * 
         * Default: false
         * Group: common
         * 
         * @param bridgeEndpoint the value to set
         * @return the dsl builder
         */
        default NettyHttpEndpointBuilder bridgeEndpoint(String bridgeEndpoint) {
            doSetProperty("bridgeEndpoint", bridgeEndpoint);
            return this;
        }
        /**
         * Whether or not to disconnect(close) from Netty Channel right after
         * use. Can be used for both consumer and producer.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: false
         * Group: common
         * 
         * @param disconnect the value to set
         * @return the dsl builder
         */
        default NettyHttpEndpointBuilder disconnect(boolean disconnect) {
            doSetProperty("disconnect", disconnect);
            return this;
        }
        /**
         * Whether or not to disconnect(close) from Netty Channel right after
         * use. Can be used for both consumer and producer.
         * 
         * The option will be converted to a &lt;code&gt;boolean&lt;/code&gt;
         * type.
         * 
         * Default: false
         * Group: common
         * 
         * @param disconnect the value to set
         * @return the dsl builder
         */
        default NettyHttpEndpointBuilder disconnect(String disconnect) {
            doSetProperty("disconnect", disconnect);
            return this;
        }
        /**
         * Setting to ensure socket is not closed due to inactivity.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: true
         * Group: common
         * 
         * @param keepAlive the value to set
         * @return the dsl builder
         */
        default NettyHttpEndpointBuilder keepAlive(boolean keepAlive) {
            doSetProperty("keepAlive", keepAlive);
            return this;
        }
        /**
         * Setting to ensure socket is not closed due to inactivity.
         * 
         * The option will be converted to a &lt;code&gt;boolean&lt;/code&gt;
         * type.
         * 
         * Default: true
         * Group: common
         * 
         * @param keepAlive the value to set
         * @return the dsl builder
         */
        default NettyHttpEndpointBuilder keepAlive(String keepAlive) {
            doSetProperty("keepAlive", keepAlive);
            return this;
        }
        /**
         * Setting to facilitate socket multiplexing.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: true
         * Group: common
         * 
         * @param reuseAddress the value to set
         * @return the dsl builder
         */
        default NettyHttpEndpointBuilder reuseAddress(boolean reuseAddress) {
            doSetProperty("reuseAddress", reuseAddress);
            return this;
        }
        /**
         * Setting to facilitate socket multiplexing.
         * 
         * The option will be converted to a &lt;code&gt;boolean&lt;/code&gt;
         * type.
         * 
         * Default: true
         * Group: common
         * 
         * @param reuseAddress the value to set
         * @return the dsl builder
         */
        default NettyHttpEndpointBuilder reuseAddress(String reuseAddress) {
            doSetProperty("reuseAddress", reuseAddress);
            return this;
        }
        /**
         * This option allows producers and consumers (in client mode) to reuse
         * the same Netty Channel for the lifecycle of processing the Exchange.
         * This is useful if you need to call a server multiple times in a Camel
         * route and want to use the same network connection. When using this,
         * the channel is not returned to the connection pool until the Exchange
         * is done; or disconnected if the disconnect option is set to true. The
         * reused Channel is stored on the Exchange as an exchange property with
         * the key NettyConstants#NETTY_CHANNEL which allows you to obtain the
         * channel during routing and use it as well.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: false
         * Group: common
         * 
         * @param reuseChannel the value to set
         * @return the dsl builder
         */
        default NettyHttpEndpointBuilder reuseChannel(boolean reuseChannel) {
            doSetProperty("reuseChannel", reuseChannel);
            return this;
        }
        /**
         * This option allows producers and consumers (in client mode) to reuse
         * the same Netty Channel for the lifecycle of processing the Exchange.
         * This is useful if you need to call a server multiple times in a Camel
         * route and want to use the same network connection. When using this,
         * the channel is not returned to the connection pool until the Exchange
         * is done; or disconnected if the disconnect option is set to true. The
         * reused Channel is stored on the Exchange as an exchange property with
         * the key NettyConstants#NETTY_CHANNEL which allows you to obtain the
         * channel during routing and use it as well.
         * 
         * The option will be converted to a &lt;code&gt;boolean&lt;/code&gt;
         * type.
         * 
         * Default: false
         * Group: common
         * 
         * @param reuseChannel the value to set
         * @return the dsl builder
         */
        default NettyHttpEndpointBuilder reuseChannel(String reuseChannel) {
            doSetProperty("reuseChannel", reuseChannel);
            return this;
        }
        /**
         * Setting to set endpoint as one-way or request-response.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: true
         * Group: common
         * 
         * @param sync the value to set
         * @return the dsl builder
         */
        default NettyHttpEndpointBuilder sync(boolean sync) {
            doSetProperty("sync", sync);
            return this;
        }
        /**
         * Setting to set endpoint as one-way or request-response.
         * 
         * The option will be converted to a &lt;code&gt;boolean&lt;/code&gt;
         * type.
         * 
         * Default: true
         * Group: common
         * 
         * @param sync the value to set
         * @return the dsl builder
         */
        default NettyHttpEndpointBuilder sync(String sync) {
            doSetProperty("sync", sync);
            return this;
        }
        /**
         * Setting to improve TCP protocol performance.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: true
         * Group: common
         * 
         * @param tcpNoDelay the value to set
         * @return the dsl builder
         */
        default NettyHttpEndpointBuilder tcpNoDelay(boolean tcpNoDelay) {
            doSetProperty("tcpNoDelay", tcpNoDelay);
            return this;
        }
        /**
         * Setting to improve TCP protocol performance.
         * 
         * The option will be converted to a &lt;code&gt;boolean&lt;/code&gt;
         * type.
         * 
         * Default: true
         * Group: common
         * 
         * @param tcpNoDelay the value to set
         * @return the dsl builder
         */
        default NettyHttpEndpointBuilder tcpNoDelay(String tcpNoDelay) {
            doSetProperty("tcpNoDelay", tcpNoDelay);
            return this;
        }
        /**
         * To enable/disable hostname verification on SSLEngine.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: false
         * Group:  security
         * 
         * @param hostnameVerification the value to set
         * @return the dsl builder
         */
        default NettyHttpEndpointBuilder hostnameVerification(
                boolean hostnameVerification) {
            doSetProperty("hostnameVerification", hostnameVerification);
            return this;
        }
        /**
         * To enable/disable hostname verification on SSLEngine.
         * 
         * The option will be converted to a &lt;code&gt;boolean&lt;/code&gt;
         * type.
         * 
         * Default: false
         * Group:  security
         * 
         * @param hostnameVerification the value to set
         * @return the dsl builder
         */
        default NettyHttpEndpointBuilder hostnameVerification(
                String hostnameVerification) {
            doSetProperty("hostnameVerification", hostnameVerification);
            return this;
        }
        /**
         * A list of decoders to be used. You can use a String which have values
         * separated by comma, and have the values be looked up in the Registry.
         * Just remember to prefix the value with # so Camel knows it should
         * lookup.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: codec
         * 
         * @param decoders the value to set
         * @return the dsl builder
         */
        default NettyHttpEndpointBuilder decoders(String decoders) {
            doSetProperty("decoders", decoders);
            return this;
        }
        /**
         * A list of encoders to be used. You can use a String which have values
         * separated by comma, and have the values be looked up in the Registry.
         * Just remember to prefix the value with # so Camel knows it should
         * lookup.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: codec
         * 
         * @param encoders the value to set
         * @return the dsl builder
         */
        default NettyHttpEndpointBuilder encoders(String encoders) {
            doSetProperty("encoders", encoders);
            return this;
        }
        /**
         * Which protocols to enable when using SSL.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Default: TLSv1.2,TLSv1.3
         * Group: security
         * 
         * @param enabledProtocols the value to set
         * @return the dsl builder
         */
        default NettyHttpEndpointBuilder enabledProtocols(
                String enabledProtocols) {
            doSetProperty("enabledProtocols", enabledProtocols);
            return this;
        }
        /**
         * Client side certificate keystore to be used for encryption.
         * 
         * The option is a: &lt;code&gt;java.io.File&lt;/code&gt; type.
         * 
         * Group: security
         * 
         * @param keyStoreFile the value to set
         * @return the dsl builder
         */
        default NettyHttpEndpointBuilder keyStoreFile(java.io.File keyStoreFile) {
            doSetProperty("keyStoreFile", keyStoreFile);
            return this;
        }
        /**
         * Client side certificate keystore to be used for encryption.
         * 
         * The option will be converted to a
         * &lt;code&gt;java.io.File&lt;/code&gt; type.
         * 
         * Group: security
         * 
         * @param keyStoreFile the value to set
         * @return the dsl builder
         */
        default NettyHttpEndpointBuilder keyStoreFile(String keyStoreFile) {
            doSetProperty("keyStoreFile", keyStoreFile);
            return this;
        }
        /**
         * Keystore format to be used for payload encryption. Defaults to JKS if
         * not set.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: security
         * 
         * @param keyStoreFormat the value to set
         * @return the dsl builder
         */
        default NettyHttpEndpointBuilder keyStoreFormat(String keyStoreFormat) {
            doSetProperty("keyStoreFormat", keyStoreFormat);
            return this;
        }
        /**
         * Client side certificate keystore to be used for encryption. Is loaded
         * by default from classpath, but you can prefix with classpath:, file:,
         * or http: to load the resource from different systems.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: security
         * 
         * @param keyStoreResource the value to set
         * @return the dsl builder
         */
        default NettyHttpEndpointBuilder keyStoreResource(
                String keyStoreResource) {
            doSetProperty("keyStoreResource", keyStoreResource);
            return this;
        }
        /**
         * Password setting to use in order to encrypt/decrypt payloads sent
         * using SSH.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: security
         * 
         * @param passphrase the value to set
         * @return the dsl builder
         */
        default NettyHttpEndpointBuilder passphrase(String passphrase) {
            doSetProperty("passphrase", passphrase);
            return this;
        }
        /**
         * Security provider to be used for payload encryption. Defaults to
         * SunX509 if not set.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: security
         * 
         * @param securityProvider the value to set
         * @return the dsl builder
         */
        default NettyHttpEndpointBuilder securityProvider(
                String securityProvider) {
            doSetProperty("securityProvider", securityProvider);
            return this;
        }
        /**
         * Setting to specify whether SSL encryption is applied to this
         * endpoint.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: false
         * Group: security
         * 
         * @param ssl the value to set
         * @return the dsl builder
         */
        default NettyHttpEndpointBuilder ssl(boolean ssl) {
            doSetProperty("ssl", ssl);
            return this;
        }
        /**
         * Setting to specify whether SSL encryption is applied to this
         * endpoint.
         * 
         * The option will be converted to a &lt;code&gt;boolean&lt;/code&gt;
         * type.
         * 
         * Default: false
         * Group: security
         * 
         * @param ssl the value to set
         * @return the dsl builder
         */
        default NettyHttpEndpointBuilder ssl(String ssl) {
            doSetProperty("ssl", ssl);
            return this;
        }
        /**
         * When enabled and in SSL mode, then the Netty consumer will enrich the
         * Camel Message with headers having information about the client
         * certificate such as subject name, issuer name, serial number, and the
         * valid date range.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: false
         * Group: security
         * 
         * @param sslClientCertHeaders the value to set
         * @return the dsl builder
         */
        default NettyHttpEndpointBuilder sslClientCertHeaders(
                boolean sslClientCertHeaders) {
            doSetProperty("sslClientCertHeaders", sslClientCertHeaders);
            return this;
        }
        /**
         * When enabled and in SSL mode, then the Netty consumer will enrich the
         * Camel Message with headers having information about the client
         * certificate such as subject name, issuer name, serial number, and the
         * valid date range.
         * 
         * The option will be converted to a &lt;code&gt;boolean&lt;/code&gt;
         * type.
         * 
         * Default: false
         * Group: security
         * 
         * @param sslClientCertHeaders the value to set
         * @return the dsl builder
         */
        default NettyHttpEndpointBuilder sslClientCertHeaders(
                String sslClientCertHeaders) {
            doSetProperty("sslClientCertHeaders", sslClientCertHeaders);
            return this;
        }
        /**
         * To configure security using SSLContextParameters.
         * 
         * The option is a:
         * &lt;code&gt;org.apache.camel.support.jsse.SSLContextParameters&lt;/code&gt; type.
         * 
         * Group: security
         * 
         * @param sslContextParameters the value to set
         * @return the dsl builder
         */
        default NettyHttpEndpointBuilder sslContextParameters(
                org.apache.camel.support.jsse.SSLContextParameters sslContextParameters) {
            doSetProperty("sslContextParameters", sslContextParameters);
            return this;
        }
        /**
         * To configure security using SSLContextParameters.
         * 
         * The option will be converted to a
         * &lt;code&gt;org.apache.camel.support.jsse.SSLContextParameters&lt;/code&gt; type.
         * 
         * Group: security
         * 
         * @param sslContextParameters the value to set
         * @return the dsl builder
         */
        default NettyHttpEndpointBuilder sslContextParameters(
                String sslContextParameters) {
            doSetProperty("sslContextParameters", sslContextParameters);
            return this;
        }
        /**
         * Reference to a class that could be used to return an SSL Handler.
         * 
         * The option is a:
         * &lt;code&gt;io.netty.handler.ssl.SslHandler&lt;/code&gt; type.
         * 
         * Group: security
         * 
         * @param sslHandler the value to set
         * @return the dsl builder
         */
        default NettyHttpEndpointBuilder sslHandler(
                io.netty.handler.ssl.SslHandler sslHandler) {
            doSetProperty("sslHandler", sslHandler);
            return this;
        }
        /**
         * Reference to a class that could be used to return an SSL Handler.
         * 
         * The option will be converted to a
         * &lt;code&gt;io.netty.handler.ssl.SslHandler&lt;/code&gt; type.
         * 
         * Group: security
         * 
         * @param sslHandler the value to set
         * @return the dsl builder
         */
        default NettyHttpEndpointBuilder sslHandler(String sslHandler) {
            doSetProperty("sslHandler", sslHandler);
            return this;
        }
        /**
         * Server side certificate keystore to be used for encryption.
         * 
         * The option is a: &lt;code&gt;java.io.File&lt;/code&gt; type.
         * 
         * Group: security
         * 
         * @param trustStoreFile the value to set
         * @return the dsl builder
         */
        default NettyHttpEndpointBuilder trustStoreFile(
                java.io.File trustStoreFile) {
            doSetProperty("trustStoreFile", trustStoreFile);
            return this;
        }
        /**
         * Server side certificate keystore to be used for encryption.
         * 
         * The option will be converted to a
         * &lt;code&gt;java.io.File&lt;/code&gt; type.
         * 
         * Group: security
         * 
         * @param trustStoreFile the value to set
         * @return the dsl builder
         */
        default NettyHttpEndpointBuilder trustStoreFile(String trustStoreFile) {
            doSetProperty("trustStoreFile", trustStoreFile);
            return this;
        }
        /**
         * Server side certificate keystore to be used for encryption. Is loaded
         * by default from classpath, but you can prefix with classpath:, file:,
         * or http: to load the resource from different systems.
         * 
         * This option can also be loaded from an existing file, by prefixing
         * with file: or classpath: followed by the location of the file.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: security
         * 
         * @param trustStoreResource the value to set
         * @return the dsl builder
         */
        default NettyHttpEndpointBuilder trustStoreResource(
                String trustStoreResource) {
            doSetProperty("trustStoreResource", trustStoreResource);
            return this;
        }
    }

    /**
     * Advanced builder for endpoint for the Netty HTTP component.
     */
    public interface AdvancedNettyHttpEndpointBuilder
            extends
                AdvancedNettyHttpEndpointConsumerBuilder,
                AdvancedNettyHttpEndpointProducerBuilder {
        default NettyHttpEndpointBuilder basic() {
            return (NettyHttpEndpointBuilder) this;
        }
        /**
         * Only used for TCP when transferExchange is true. When set to true,
         * serializable objects in headers and properties will be added to the
         * exchange. Otherwise Camel will exclude any non-serializable objects
         * and log it at WARN level.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: false
         * Group: advanced
         * 
         * @param allowSerializedHeaders the value to set
         * @return the dsl builder
         */
        default AdvancedNettyHttpEndpointBuilder allowSerializedHeaders(
                boolean allowSerializedHeaders) {
            doSetProperty("allowSerializedHeaders", allowSerializedHeaders);
            return this;
        }
        /**
         * Only used for TCP when transferExchange is true. When set to true,
         * serializable objects in headers and properties will be added to the
         * exchange. Otherwise Camel will exclude any non-serializable objects
         * and log it at WARN level.
         * 
         * The option will be converted to a &lt;code&gt;boolean&lt;/code&gt;
         * type.
         * 
         * Default: false
         * Group: advanced
         * 
         * @param allowSerializedHeaders the value to set
         * @return the dsl builder
         */
        default AdvancedNettyHttpEndpointBuilder allowSerializedHeaders(
                String allowSerializedHeaders) {
            doSetProperty("allowSerializedHeaders", allowSerializedHeaders);
            return this;
        }
        /**
         * To use a explicit ChannelGroup.
         * 
         * The option is a:
         * &lt;code&gt;io.netty.channel.group.ChannelGroup&lt;/code&gt; type.
         * 
         * Group: advanced
         * 
         * @param channelGroup the value to set
         * @return the dsl builder
         */
        default AdvancedNettyHttpEndpointBuilder channelGroup(
                io.netty.channel.group.ChannelGroup channelGroup) {
            doSetProperty("channelGroup", channelGroup);
            return this;
        }
        /**
         * To use a explicit ChannelGroup.
         * 
         * The option will be converted to a
         * &lt;code&gt;io.netty.channel.group.ChannelGroup&lt;/code&gt; type.
         * 
         * Group: advanced
         * 
         * @param channelGroup the value to set
         * @return the dsl builder
         */
        default AdvancedNettyHttpEndpointBuilder channelGroup(
                String channelGroup) {
            doSetProperty("channelGroup", channelGroup);
            return this;
        }
        /**
         * To use a custom configured NettyHttpConfiguration for configuring
         * this endpoint.
         * 
         * The option is a:
         * &lt;code&gt;org.apache.camel.component.netty.http.NettyHttpConfiguration&lt;/code&gt; type.
         * 
         * Group: advanced
         * 
         * @param configuration the value to set
         * @return the dsl builder
         */
        default AdvancedNettyHttpEndpointBuilder configuration(
                org.apache.camel.component.netty.http.NettyHttpConfiguration configuration) {
            doSetProperty("configuration", configuration);
            return this;
        }
        /**
         * To use a custom configured NettyHttpConfiguration for configuring
         * this endpoint.
         * 
         * The option will be converted to a
         * &lt;code&gt;org.apache.camel.component.netty.http.NettyHttpConfiguration&lt;/code&gt; type.
         * 
         * Group: advanced
         * 
         * @param configuration the value to set
         * @return the dsl builder
         */
        default AdvancedNettyHttpEndpointBuilder configuration(
                String configuration) {
            doSetProperty("configuration", configuration);
            return this;
        }
        /**
         * Determines whether or not the raw input stream from Netty
         * HttpRequest#getContent() or HttpResponset#getContent() is cached or
         * not (Camel will read the stream into a in light-weight memory based
         * Stream caching) cache. By default Camel will cache the Netty input
         * stream to support reading it multiple times to ensure it Camel can
         * retrieve all data from the stream. However you can set this option to
         * true when you for example need to access the raw stream, such as
         * streaming it directly to a file or other persistent store. Mind that
         * if you enable this option, then you cannot read the Netty stream
         * multiple times out of the box, and you would need manually to reset
         * the reader index on the Netty raw stream. Also Netty will auto-close
         * the Netty stream when the Netty HTTP server/HTTP client is done
         * processing, which means that if the asynchronous routing engine is in
         * use then any asynchronous thread that may continue routing the
         * org.apache.camel.Exchange may not be able to read the Netty stream,
         * because Netty has closed it.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: false
         * Group: advanced
         * 
         * @param disableStreamCache the value to set
         * @return the dsl builder
         */
        default AdvancedNettyHttpEndpointBuilder disableStreamCache(
                boolean disableStreamCache) {
            doSetProperty("disableStreamCache", disableStreamCache);
            return this;
        }
        /**
         * Determines whether or not the raw input stream from Netty
         * HttpRequest#getContent() or HttpResponset#getContent() is cached or
         * not (Camel will read the stream into a in light-weight memory based
         * Stream caching) cache. By default Camel will cache the Netty input
         * stream to support reading it multiple times to ensure it Camel can
         * retrieve all data from the stream. However you can set this option to
         * true when you for example need to access the raw stream, such as
         * streaming it directly to a file or other persistent store. Mind that
         * if you enable this option, then you cannot read the Netty stream
         * multiple times out of the box, and you would need manually to reset
         * the reader index on the Netty raw stream. Also Netty will auto-close
         * the Netty stream when the Netty HTTP server/HTTP client is done
         * processing, which means that if the asynchronous routing engine is in
         * use then any asynchronous thread that may continue routing the
         * org.apache.camel.Exchange may not be able to read the Netty stream,
         * because Netty has closed it.
         * 
         * The option will be converted to a &lt;code&gt;boolean&lt;/code&gt;
         * type.
         * 
         * Default: false
         * Group: advanced
         * 
         * @param disableStreamCache the value to set
         * @return the dsl builder
         */
        default AdvancedNettyHttpEndpointBuilder disableStreamCache(
                String disableStreamCache) {
            doSetProperty("disableStreamCache", disableStreamCache);
            return this;
        }
        /**
         * To use a custom org.apache.camel.spi.HeaderFilterStrategy to filter
         * headers.
         * 
         * The option is a:
         * &lt;code&gt;org.apache.camel.spi.HeaderFilterStrategy&lt;/code&gt;
         * type.
         * 
         * Group: advanced
         * 
         * @param headerFilterStrategy the value to set
         * @return the dsl builder
         */
        default AdvancedNettyHttpEndpointBuilder headerFilterStrategy(
                org.apache.camel.spi.HeaderFilterStrategy headerFilterStrategy) {
            doSetProperty("headerFilterStrategy", headerFilterStrategy);
            return this;
        }
        /**
         * To use a custom org.apache.camel.spi.HeaderFilterStrategy to filter
         * headers.
         * 
         * The option will be converted to a
         * &lt;code&gt;org.apache.camel.spi.HeaderFilterStrategy&lt;/code&gt;
         * type.
         * 
         * Group: advanced
         * 
         * @param headerFilterStrategy the value to set
         * @return the dsl builder
         */
        default AdvancedNettyHttpEndpointBuilder headerFilterStrategy(
                String headerFilterStrategy) {
            doSetProperty("headerFilterStrategy", headerFilterStrategy);
            return this;
        }
        /**
         * Whether to use native transport instead of NIO. Native transport
         * takes advantage of the host operating system and is only supported on
         * some platforms. You need to add the netty JAR for the host operating
         * system you are using. See more details at:
         * http://netty.io/wiki/native-transports.html.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: false
         * Group: advanced
         * 
         * @param nativeTransport the value to set
         * @return the dsl builder
         */
        default AdvancedNettyHttpEndpointBuilder nativeTransport(
                boolean nativeTransport) {
            doSetProperty("nativeTransport", nativeTransport);
            return this;
        }
        /**
         * Whether to use native transport instead of NIO. Native transport
         * takes advantage of the host operating system and is only supported on
         * some platforms. You need to add the netty JAR for the host operating
         * system you are using. See more details at:
         * http://netty.io/wiki/native-transports.html.
         * 
         * The option will be converted to a &lt;code&gt;boolean&lt;/code&gt;
         * type.
         * 
         * Default: false
         * Group: advanced
         * 
         * @param nativeTransport the value to set
         * @return the dsl builder
         */
        default AdvancedNettyHttpEndpointBuilder nativeTransport(
                String nativeTransport) {
            doSetProperty("nativeTransport", nativeTransport);
            return this;
        }
        /**
         * To use a custom
         * org.apache.camel.component.netty.http.NettyHttpBinding for binding
         * to/from Netty and Camel Message API.
         * 
         * The option is a:
         * &lt;code&gt;org.apache.camel.component.netty.http.NettyHttpBinding&lt;/code&gt; type.
         * 
         * Group: advanced
         * 
         * @param nettyHttpBinding the value to set
         * @return the dsl builder
         */
        default AdvancedNettyHttpEndpointBuilder nettyHttpBinding(
                org.apache.camel.component.netty.http.NettyHttpBinding nettyHttpBinding) {
            doSetProperty("nettyHttpBinding", nettyHttpBinding);
            return this;
        }
        /**
         * To use a custom
         * org.apache.camel.component.netty.http.NettyHttpBinding for binding
         * to/from Netty and Camel Message API.
         * 
         * The option will be converted to a
         * &lt;code&gt;org.apache.camel.component.netty.http.NettyHttpBinding&lt;/code&gt; type.
         * 
         * Group: advanced
         * 
         * @param nettyHttpBinding the value to set
         * @return the dsl builder
         */
        default AdvancedNettyHttpEndpointBuilder nettyHttpBinding(
                String nettyHttpBinding) {
            doSetProperty("nettyHttpBinding", nettyHttpBinding);
            return this;
        }
        /**
         * Allows to configure additional netty options using option. as prefix.
         * For example option.child.keepAlive=false to set the netty option
         * child.keepAlive=false. See the Netty documentation for possible
         * options that can be used.
         * 
         * The option is a: &lt;code&gt;java.util.Map&amp;lt;java.lang.String,
         * java.lang.Object&amp;gt;&lt;/code&gt; type.
         * The option is multivalued, and you can use the options(String,
         * Object) method to add a value (call the method multiple times to set
         * more values).
         * 
         * Group: advanced
         * 
         * @param key the option key
         * @param value the option value
         * @return the dsl builder
         */
        default AdvancedNettyHttpEndpointBuilder options(
                String key,
                Object value) {
            doSetMultiValueProperty("options", "option." + key, value);
            return this;
        }
        /**
         * Allows to configure additional netty options using option. as prefix.
         * For example option.child.keepAlive=false to set the netty option
         * child.keepAlive=false. See the Netty documentation for possible
         * options that can be used.
         * 
         * The option is a: &lt;code&gt;java.util.Map&amp;lt;java.lang.String,
         * java.lang.Object&amp;gt;&lt;/code&gt; type.
         * The option is multivalued, and you can use the options(String,
         * Object) method to add a value (call the method multiple times to set
         * more values).
         * 
         * Group: advanced
         * 
         * @param values the values
         * @return the dsl builder
         */
        default AdvancedNettyHttpEndpointBuilder options(Map values) {
            doSetMultiValueProperties("options", "option.", values);
            return this;
        }
        /**
         * The TCP/UDP buffer sizes to be used during inbound communication.
         * Size is bytes.
         * 
         * The option is a: &lt;code&gt;int&lt;/code&gt; type.
         * 
         * Default: 65536
         * Group: advanced
         * 
         * @param receiveBufferSize the value to set
         * @return the dsl builder
         */
        default AdvancedNettyHttpEndpointBuilder receiveBufferSize(
                int receiveBufferSize) {
            doSetProperty("receiveBufferSize", receiveBufferSize);
            return this;
        }
        /**
         * The TCP/UDP buffer sizes to be used during inbound communication.
         * Size is bytes.
         * 
         * The option will be converted to a &lt;code&gt;int&lt;/code&gt; type.
         * 
         * Default: 65536
         * Group: advanced
         * 
         * @param receiveBufferSize the value to set
         * @return the dsl builder
         */
        default AdvancedNettyHttpEndpointBuilder receiveBufferSize(
                String receiveBufferSize) {
            doSetProperty("receiveBufferSize", receiveBufferSize);
            return this;
        }
        /**
         * Configures the buffer size predictor. See details at Jetty
         * documentation and this mail thread.
         * 
         * The option is a: &lt;code&gt;int&lt;/code&gt; type.
         * 
         * Group: advanced
         * 
         * @param receiveBufferSizePredictor the value to set
         * @return the dsl builder
         */
        default AdvancedNettyHttpEndpointBuilder receiveBufferSizePredictor(
                int receiveBufferSizePredictor) {
            doSetProperty("receiveBufferSizePredictor", receiveBufferSizePredictor);
            return this;
        }
        /**
         * Configures the buffer size predictor. See details at Jetty
         * documentation and this mail thread.
         * 
         * The option will be converted to a &lt;code&gt;int&lt;/code&gt; type.
         * 
         * Group: advanced
         * 
         * @param receiveBufferSizePredictor the value to set
         * @return the dsl builder
         */
        default AdvancedNettyHttpEndpointBuilder receiveBufferSizePredictor(
                String receiveBufferSizePredictor) {
            doSetProperty("receiveBufferSizePredictor", receiveBufferSizePredictor);
            return this;
        }
        /**
         * The TCP/UDP buffer sizes to be used during outbound communication.
         * Size is bytes.
         * 
         * The option is a: &lt;code&gt;int&lt;/code&gt; type.
         * 
         * Default: 65536
         * Group: advanced
         * 
         * @param sendBufferSize the value to set
         * @return the dsl builder
         */
        default AdvancedNettyHttpEndpointBuilder sendBufferSize(
                int sendBufferSize) {
            doSetProperty("sendBufferSize", sendBufferSize);
            return this;
        }
        /**
         * The TCP/UDP buffer sizes to be used during outbound communication.
         * Size is bytes.
         * 
         * The option will be converted to a &lt;code&gt;int&lt;/code&gt; type.
         * 
         * Default: 65536
         * Group: advanced
         * 
         * @param sendBufferSize the value to set
         * @return the dsl builder
         */
        default AdvancedNettyHttpEndpointBuilder sendBufferSize(
                String sendBufferSize) {
            doSetProperty("sendBufferSize", sendBufferSize);
            return this;
        }
        /**
         * Sets whether synchronous processing should be strictly used.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: false
         * Group: advanced
         * 
         * @param synchronous the value to set
         * @return the dsl builder
         */
        default AdvancedNettyHttpEndpointBuilder synchronous(boolean synchronous) {
            doSetProperty("synchronous", synchronous);
            return this;
        }
        /**
         * Sets whether synchronous processing should be strictly used.
         * 
         * The option will be converted to a &lt;code&gt;boolean&lt;/code&gt;
         * type.
         * 
         * Default: false
         * Group: advanced
         * 
         * @param synchronous the value to set
         * @return the dsl builder
         */
        default AdvancedNettyHttpEndpointBuilder synchronous(String synchronous) {
            doSetProperty("synchronous", synchronous);
            return this;
        }
        /**
         * If enabled and an Exchange failed processing on the consumer side,
         * and if the caused Exception was send back serialized in the response
         * as a application/x-java-serialized-object content type. On the
         * producer side the exception will be deserialized and thrown as is,
         * instead of the HttpOperationFailedException. The caused exception is
         * required to be serialized. This is by default turned off. If you
         * enable this then be aware that Java will deserialize the incoming
         * data from the request to Java and that can be a potential security
         * risk.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: false
         * Group: advanced
         * 
         * @param transferException the value to set
         * @return the dsl builder
         */
        default AdvancedNettyHttpEndpointBuilder transferException(
                boolean transferException) {
            doSetProperty("transferException", transferException);
            return this;
        }
        /**
         * If enabled and an Exchange failed processing on the consumer side,
         * and if the caused Exception was send back serialized in the response
         * as a application/x-java-serialized-object content type. On the
         * producer side the exception will be deserialized and thrown as is,
         * instead of the HttpOperationFailedException. The caused exception is
         * required to be serialized. This is by default turned off. If you
         * enable this then be aware that Java will deserialize the incoming
         * data from the request to Java and that can be a potential security
         * risk.
         * 
         * The option will be converted to a &lt;code&gt;boolean&lt;/code&gt;
         * type.
         * 
         * Default: false
         * Group: advanced
         * 
         * @param transferException the value to set
         * @return the dsl builder
         */
        default AdvancedNettyHttpEndpointBuilder transferException(
                String transferException) {
            doSetProperty("transferException", transferException);
            return this;
        }
        /**
         * Only used for TCP. You can transfer the exchange over the wire
         * instead of just the body. The following fields are transferred: In
         * body, Out body, fault body, In headers, Out headers, fault headers,
         * exchange properties, exchange exception. This requires that the
         * objects are serializable. Camel will exclude any non-serializable
         * objects and log it at WARN level.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: false
         * Group: advanced
         * 
         * @param transferExchange the value to set
         * @return the dsl builder
         */
        default AdvancedNettyHttpEndpointBuilder transferExchange(
                boolean transferExchange) {
            doSetProperty("transferExchange", transferExchange);
            return this;
        }
        /**
         * Only used for TCP. You can transfer the exchange over the wire
         * instead of just the body. The following fields are transferred: In
         * body, Out body, fault body, In headers, Out headers, fault headers,
         * exchange properties, exchange exception. This requires that the
         * objects are serializable. Camel will exclude any non-serializable
         * objects and log it at WARN level.
         * 
         * The option will be converted to a &lt;code&gt;boolean&lt;/code&gt;
         * type.
         * 
         * Default: false
         * Group: advanced
         * 
         * @param transferExchange the value to set
         * @return the dsl builder
         */
        default AdvancedNettyHttpEndpointBuilder transferExchange(
                String transferExchange) {
            doSetProperty("transferExchange", transferExchange);
            return this;
        }
        /**
         * Path to unix domain socket to use instead of inet socket. Host and
         * port parameters will not be used, however required. It is ok to set
         * dummy values for them. Must be used with nativeTransport=true and
         * clientMode=false.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: advanced
         * 
         * @param unixDomainSocketPath the value to set
         * @return the dsl builder
         */
        default AdvancedNettyHttpEndpointBuilder unixDomainSocketPath(
                String unixDomainSocketPath) {
            doSetProperty("unixDomainSocketPath", unixDomainSocketPath);
            return this;
        }
        /**
         * When netty works on nio mode, it uses default workerCount parameter
         * from Netty (which is cpu_core_threads x 2). User can use this option
         * to override the default workerCount from Netty.
         * 
         * The option is a: &lt;code&gt;int&lt;/code&gt; type.
         * 
         * Group: advanced
         * 
         * @param workerCount the value to set
         * @return the dsl builder
         */
        default AdvancedNettyHttpEndpointBuilder workerCount(int workerCount) {
            doSetProperty("workerCount", workerCount);
            return this;
        }
        /**
         * When netty works on nio mode, it uses default workerCount parameter
         * from Netty (which is cpu_core_threads x 2). User can use this option
         * to override the default workerCount from Netty.
         * 
         * The option will be converted to a &lt;code&gt;int&lt;/code&gt; type.
         * 
         * Group: advanced
         * 
         * @param workerCount the value to set
         * @return the dsl builder
         */
        default AdvancedNettyHttpEndpointBuilder workerCount(String workerCount) {
            doSetProperty("workerCount", workerCount);
            return this;
        }
        /**
         * To use a explicit EventLoopGroup as the boss thread pool. For example
         * to share a thread pool with multiple consumers or producers. By
         * default each consumer or producer has their own worker pool with 2 x
         * cpu count core threads.
         * 
         * The option is a:
         * &lt;code&gt;io.netty.channel.EventLoopGroup&lt;/code&gt; type.
         * 
         * Group: advanced
         * 
         * @param workerGroup the value to set
         * @return the dsl builder
         */
        default AdvancedNettyHttpEndpointBuilder workerGroup(
                io.netty.channel.EventLoopGroup workerGroup) {
            doSetProperty("workerGroup", workerGroup);
            return this;
        }
        /**
         * To use a explicit EventLoopGroup as the boss thread pool. For example
         * to share a thread pool with multiple consumers or producers. By
         * default each consumer or producer has their own worker pool with 2 x
         * cpu count core threads.
         * 
         * The option will be converted to a
         * &lt;code&gt;io.netty.channel.EventLoopGroup&lt;/code&gt; type.
         * 
         * Group: advanced
         * 
         * @param workerGroup the value to set
         * @return the dsl builder
         */
        default AdvancedNettyHttpEndpointBuilder workerGroup(String workerGroup) {
            doSetProperty("workerGroup", workerGroup);
            return this;
        }
    }

    public interface NettyHttpBuilders {
        /**
         * Netty HTTP (camel-netty-http)
         * Netty HTTP server and client using the Netty 4.x.
         * 
         * Category: networking,http
         * Since: 2.14
         * Maven coordinates: org.apache.camel:camel-netty-http
         * 
         * @return the dsl builder for the headers' name.
         */
        default NettyHttpHeaderNameBuilder nettyHttp() {
            return NettyHttpHeaderNameBuilder.INSTANCE;
        }
        /**
         * Netty HTTP (camel-netty-http)
         * Netty HTTP server and client using the Netty 4.x.
         * 
         * Category: networking,http
         * Since: 2.14
         * Maven coordinates: org.apache.camel:camel-netty-http
         * 
         * Syntax: <code>netty-http:protocol://host:port/path</code>
         * 
         * Path parameter: protocol (required)
         * The protocol to use which is either http, https or proxy - a consumer
         * only option.
         * There are 2 enums and the value can be one of: http, https
         * 
         * Path parameter: host (required)
         * The local hostname such as localhost, or 0.0.0.0 when being a
         * consumer. The remote HTTP server hostname when using producer.
         * 
         * Path parameter: port
         * The host port number
         * 
         * Path parameter: path
         * Resource path
         * 
         * @param path protocol://host:port/path
         * @return the dsl builder
         */
        default NettyHttpEndpointBuilder nettyHttp(String path) {
            return NettyHttpEndpointBuilderFactory.endpointBuilder("netty-http", path);
        }
        /**
         * Netty HTTP (camel-netty-http)
         * Netty HTTP server and client using the Netty 4.x.
         * 
         * Category: networking,http
         * Since: 2.14
         * Maven coordinates: org.apache.camel:camel-netty-http
         * 
         * Syntax: <code>netty-http:protocol://host:port/path</code>
         * 
         * Path parameter: protocol (required)
         * The protocol to use which is either http, https or proxy - a consumer
         * only option.
         * There are 2 enums and the value can be one of: http, https
         * 
         * Path parameter: host (required)
         * The local hostname such as localhost, or 0.0.0.0 when being a
         * consumer. The remote HTTP server hostname when using producer.
         * 
         * Path parameter: port
         * The host port number
         * 
         * Path parameter: path
         * Resource path
         * 
         * @param componentName to use a custom component name for the endpoint
         * instead of the default name
         * @param path protocol://host:port/path
         * @return the dsl builder
         */
        default NettyHttpEndpointBuilder nettyHttp(
                String componentName,
                String path) {
            return NettyHttpEndpointBuilderFactory.endpointBuilder(componentName, path);
        }
    }

    /**
     * The builder of headers' name for the Netty HTTP component.
     */
    public static class NettyHttpHeaderNameBuilder {
        /**
         * The internal instance of the builder used to access to all the
         * methods representing the name of headers.
         */
        private static final NettyHttpHeaderNameBuilder INSTANCE = new NettyHttpHeaderNameBuilder();

        /**
         * If the user was authenticated using HTTP Basic then this header is
         * added with the value Basic.
         * 
         * The option is a: {@code String} type.
         * 
         * Group: common
         * 
         * @return the name of the header {@code HttpAuthentication}.
         */
        public String httpAuthentication() {
            return "CamelHttpAuthentication";
        }

        /**
         * To set the content-type of the HTTP body. For example: text/plain;
         * charset=UTF-8.
         * 
         * The option is a: {@code String} type.
         * 
         * Group: common
         * 
         * @return the name of the header {@code Content-Type}.
         */
        public String contentType() {
            return "Content-Type";
        }

        /**
         * The value of the HTTP header connection to use.
         * 
         * The option is a: {@code String} type.
         * 
         * Group: common
         * 
         * @return the name of the header {@code connection}.
         */
        public String connection() {
            return "connection";
        }

        /**
         * Indicates whether the channel should be closed after complete.
         * 
         * The option is a: {@code Boolean} type.
         * 
         * Group: common
         * 
         * @return the name of the header {@code NettyCloseChannelWhenComplete}.
         */
        public String nettyCloseChannelWhenComplete() {
            return "CamelNettyCloseChannelWhenComplete";
        }

        /**
         * Allows to set the HTTP Status code to use. By default 200 is used for
         * success, and 500 for failure.
         * 
         * The option is a: {@code Integer} type.
         * 
         * Group: common
         * 
         * @return the name of the header {@code HttpResponseCode}.
         */
        public String httpResponseCode() {
            return "CamelHttpResponseCode";
        }

        /**
         * The version of the HTTP protocol.
         * 
         * The option is a: {@code String} type.
         * 
         * Default: HTTP/1.1
         * Group: common
         * 
         * @return the name of the header {@code HttpProtocolVersion}.
         */
        public String httpProtocolVersion() {
            return "CamelHttpProtocolVersion";
        }

        /**
         * The HTTP method used, such as GET, POST, TRACE etc.
         * 
         * The option is a: {@code String} type.
         * 
         * Default: GET
         * Group: common
         * 
         * @return the name of the header {@code HttpMethod}.
         */
        public String httpMethod() {
            return "CamelHttpMethod";
        }

        /**
         * Any query parameters, such as foo=bar&amp;beer=yes.
         * 
         * The option is a: {@code String} type.
         * 
         * Group: common
         * 
         * @return the name of the header {@code HttpQuery}.
         */
        public String httpQuery() {
            return "CamelHttpQuery";
        }

        /**
         * Allows to provide URI context-path and query parameters as a String
         * value that overrides the endpoint configuration. This allows to reuse
         * the same producer for calling same remote http server, but using a
         * dynamic context-path and query parameters.
         * 
         * The option is a: {@code String} type.
         * 
         * Group: common
         * 
         * @return the name of the header {@code HttpPath}.
         */
        public String httpPath() {
            return "CamelHttpPath";
        }

        /**
         * Any query parameters, such as foo=bar&amp;beer=yes. Stored in the raw
         * form, as they arrived to the consumer (i.e. before URL decoding).
         * 
         * The option is a: {@code String} type.
         * 
         * Group: common
         * 
         * @return the name of the header {@code HttpRawQuery}.
         */
        public String httpRawQuery() {
            return "CamelHttpRawQuery";
        }

        /**
         * The URL including protocol, host and port, etc:
         * http://0.0.0.0:8080/myapp.
         * 
         * The option is a: {@code String} type.
         * 
         * Group: common
         * 
         * @return the name of the header {@code HttpUrl}.
         */
        public String httpUrl() {
            return "CamelHttpUrl";
        }

        /**
         * The charset from the content-type header.
         * 
         * The option is a: {@code String} type.
         * 
         * Group: common
         * 
         * @return the name of the header {@code HttpCharacterEncoding}.
         */
        public String httpCharacterEncoding() {
            return "CamelHttpCharacterEncoding";
        }

        /**
         * The URI without protocol, host and port, etc: /myapp.
         * 
         * The option is a: {@code String} type.
         * 
         * Group: common
         * 
         * @return the name of the header {@code HttpUri}.
         */
        public String httpUri() {
            return "CamelHttpUri";
        }

        /**
         * The channel handler context.
         * 
         * The option is a: {@code io.netty.channel.ChannelHandlerContext} type.
         * 
         * Group: common
         * 
         * @return the name of the header {@code NettyChannelHandlerContext}.
         */
        public String nettyChannelHandlerContext() {
            return "CamelNettyChannelHandlerContext";
        }

        /**
         * The remote address.
         * 
         * The option is a: {@code java.net.SocketAddress} type.
         * 
         * Group: common
         * 
         * @return the name of the header {@code NettyRemoteAddress}.
         */
        public String nettyRemoteAddress() {
            return "CamelNettyRemoteAddress";
        }

        /**
         * The local address.
         * 
         * The option is a: {@code java.net.SocketAddress} type.
         * 
         * Group: common
         * 
         * @return the name of the header {@code NettyLocalAddress}.
         */
        public String nettyLocalAddress() {
            return "CamelNettyLocalAddress";
        }

        /**
         * The SSL session.
         * 
         * The option is a: {@code javax.net.ssl.SSLSession} type.
         * 
         * Group: common
         * 
         * @return the name of the header {@code NettySSLSession}.
         */
        public String nettySSLSession() {
            return "CamelNettySSLSession";
        }

        /**
         * The SSL client certificate subject name.
         * 
         * The option is a: {@code String} type.
         * 
         * Group: common
         * 
         * @return the name of the header {@code NettySSLClientCertSubjectName}.
         */
        public String nettySSLClientCertSubjectName() {
            return "CamelNettySSLClientCertSubjectName";
        }

        /**
         * The SSL client certificate issuer name.
         * 
         * The option is a: {@code String} type.
         * 
         * Group: common
         * 
         * @return the name of the header {@code NettySSLClientCertIssuerName}.
         */
        public String nettySSLClientCertIssuerName() {
            return "CamelNettySSLClientCertIssuerName";
        }

        /**
         * The SSL client certificate serial number.
         * 
         * The option is a: {@code String} type.
         * 
         * Group: common
         * 
         * @return the name of the header {@code
         * NettySSLClientCertSerialNumber}.
         */
        public String nettySSLClientCertSerialNumber() {
            return "CamelNettySSLClientCertSerialNumber";
        }

        /**
         * The SSL client certificate not before.
         * 
         * The option is a: {@code java.util.Date} type.
         * 
         * Group: common
         * 
         * @return the name of the header {@code NettySSLClientCertNotBefore}.
         */
        public String nettySSLClientCertNotBefore() {
            return "CamelNettySSLClientCertNotBefore";
        }

        /**
         * The SSL client certificate not after.
         * 
         * The option is a: {@code java.util.Date} type.
         * 
         * Group: common
         * 
         * @return the name of the header {@code NettySSLClientCertNotAfter}.
         */
        public String nettySSLClientCertNotAfter() {
            return "CamelNettySSLClientCertNotAfter";
        }

        /**
         * The read timeout.
         * 
         * The option is a: {@code Long} type.
         * 
         * Group: common
         * 
         * @return the name of the header {@code NettyRequestTimeout}.
         */
        public String nettyRequestTimeout() {
            return "CamelNettyRequestTimeout";
        }
    }
    static NettyHttpEndpointBuilder endpointBuilder(
            String componentName,
            String path) {
        class NettyHttpEndpointBuilderImpl extends AbstractEndpointBuilder implements NettyHttpEndpointBuilder, AdvancedNettyHttpEndpointBuilder {
            public NettyHttpEndpointBuilderImpl(String path) {
                super(componentName, path);
            }
        }
        return new NettyHttpEndpointBuilderImpl(path);
    }
}