/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.apache.camel.builder.endpoint.dsl;

import java.util.*;
import java.util.Map;
import java.util.concurrent.*;
import java.util.function.*;
import java.util.stream.*;
import javax.annotation.processing.Generated;
import org.apache.camel.builder.EndpointConsumerBuilder;
import org.apache.camel.builder.EndpointProducerBuilder;
import org.apache.camel.builder.endpoint.AbstractEndpointBuilder;

/**
 * Send and receive messages from RabbitMQ using Spring RabbitMQ client.
 * 
 * Generated by camel build tools - do NOT edit this file!
 */
@Generated("org.apache.camel.maven.packaging.EndpointDslMojo")
public interface SpringRabbitMQEndpointBuilderFactory {


    /**
     * Builder for endpoint consumers for the Spring RabbitMQ component.
     */
    public interface SpringRabbitMQEndpointConsumerBuilder
            extends
                EndpointConsumerBuilder {
        default AdvancedSpringRabbitMQEndpointConsumerBuilder advanced() {
            return (AdvancedSpringRabbitMQEndpointConsumerBuilder) this;
        }
        /**
         * The connection factory to be use. A connection factory must be
         * configured either on the component or endpoint.
         * 
         * The option is a:
         * &lt;code&gt;org.springframework.amqp.rabbit.connection.ConnectionFactory&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param connectionFactory the value to set
         * @return the dsl builder
         */
        default SpringRabbitMQEndpointConsumerBuilder connectionFactory(
                org.springframework.amqp.rabbit.connection.ConnectionFactory connectionFactory) {
            doSetProperty("connectionFactory", connectionFactory);
            return this;
        }
        /**
         * The connection factory to be use. A connection factory must be
         * configured either on the component or endpoint.
         * 
         * The option will be converted to a
         * &lt;code&gt;org.springframework.amqp.rabbit.connection.ConnectionFactory&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param connectionFactory the value to set
         * @return the dsl builder
         */
        default SpringRabbitMQEndpointConsumerBuilder connectionFactory(
                String connectionFactory) {
            doSetProperty("connectionFactory", connectionFactory);
            return this;
        }
        /**
         * Specifies whether Camel ignores the ReplyTo header in messages. If
         * true, Camel does not send a reply back to the destination specified
         * in the ReplyTo header. You can use this option if you want Camel to
         * consume from a route and you do not want Camel to automatically send
         * back a reply message because another component in your code handles
         * the reply message. You can also use this option if you want to use
         * Camel as a proxy between different message brokers and you want to
         * route message from one system to another.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: false
         * Group: common
         * 
         * @param disableReplyTo the value to set
         * @return the dsl builder
         */
        default SpringRabbitMQEndpointConsumerBuilder disableReplyTo(
                boolean disableReplyTo) {
            doSetProperty("disableReplyTo", disableReplyTo);
            return this;
        }
        /**
         * Specifies whether Camel ignores the ReplyTo header in messages. If
         * true, Camel does not send a reply back to the destination specified
         * in the ReplyTo header. You can use this option if you want Camel to
         * consume from a route and you do not want Camel to automatically send
         * back a reply message because another component in your code handles
         * the reply message. You can also use this option if you want to use
         * Camel as a proxy between different message brokers and you want to
         * route message from one system to another.
         * 
         * The option will be converted to a &lt;code&gt;boolean&lt;/code&gt;
         * type.
         * 
         * Default: false
         * Group: common
         * 
         * @param disableReplyTo the value to set
         * @return the dsl builder
         */
        default SpringRabbitMQEndpointConsumerBuilder disableReplyTo(
                String disableReplyTo) {
            doSetProperty("disableReplyTo", disableReplyTo);
            return this;
        }
        /**
         * The value of a routing key to use. Default is empty which is not
         * helpful when using the default (or any direct) exchange, but fine if
         * the exchange is a headers exchange for instance.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param routingKey the value to set
         * @return the dsl builder
         */
        default SpringRabbitMQEndpointConsumerBuilder routingKey(
                String routingKey) {
            doSetProperty("routingKey", routingKey);
            return this;
        }
        /**
         * Specifies whether to test the connection on startup. This ensures
         * that when Camel starts that all the JMS consumers have a valid
         * connection to the JMS broker. If a connection cannot be granted then
         * Camel throws an exception on startup. This ensures that Camel is not
         * started with failed connections. The JMS producers is tested as well.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: false
         * Group: common
         * 
         * @param testConnectionOnStartup the value to set
         * @return the dsl builder
         */
        default SpringRabbitMQEndpointConsumerBuilder testConnectionOnStartup(
                boolean testConnectionOnStartup) {
            doSetProperty("testConnectionOnStartup", testConnectionOnStartup);
            return this;
        }
        /**
         * Specifies whether to test the connection on startup. This ensures
         * that when Camel starts that all the JMS consumers have a valid
         * connection to the JMS broker. If a connection cannot be granted then
         * Camel throws an exception on startup. This ensures that Camel is not
         * started with failed connections. The JMS producers is tested as well.
         * 
         * The option will be converted to a &lt;code&gt;boolean&lt;/code&gt;
         * type.
         * 
         * Default: false
         * Group: common
         * 
         * @param testConnectionOnStartup the value to set
         * @return the dsl builder
         */
        default SpringRabbitMQEndpointConsumerBuilder testConnectionOnStartup(
                String testConnectionOnStartup) {
            doSetProperty("testConnectionOnStartup", testConnectionOnStartup);
            return this;
        }
        /**
         * Flag controlling the behaviour of the container with respect to
         * message acknowledgement. The most common usage is to let the
         * container handle the acknowledgements (so the listener doesn't need
         * to know about the channel or the message). Set to
         * AcknowledgeMode.MANUAL if the listener will send the acknowledgements
         * itself using Channel.basicAck(long, boolean). Manual acks are
         * consistent with either a transactional or non-transactional channel,
         * but if you are doing no other work on the channel at the same other
         * than receiving a single message then the transaction is probably
         * unnecessary. Set to AcknowledgeMode.NONE to tell the broker not to
         * expect any acknowledgements, and it will assume all messages are
         * acknowledged as soon as they are sent (this is autoack in native
         * Rabbit broker terms). If AcknowledgeMode.NONE then the channel cannot
         * be transactional (so the container will fail on start up if that flag
         * is accidentally set).
         * 
         * The option is a:
         * &lt;code&gt;org.springframework.amqp.core.AcknowledgeMode&lt;/code&gt; type.
         * 
         * Group: consumer
         * 
         * @param acknowledgeMode the value to set
         * @return the dsl builder
         */
        default SpringRabbitMQEndpointConsumerBuilder acknowledgeMode(
                org.springframework.amqp.core.AcknowledgeMode acknowledgeMode) {
            doSetProperty("acknowledgeMode", acknowledgeMode);
            return this;
        }
        /**
         * Flag controlling the behaviour of the container with respect to
         * message acknowledgement. The most common usage is to let the
         * container handle the acknowledgements (so the listener doesn't need
         * to know about the channel or the message). Set to
         * AcknowledgeMode.MANUAL if the listener will send the acknowledgements
         * itself using Channel.basicAck(long, boolean). Manual acks are
         * consistent with either a transactional or non-transactional channel,
         * but if you are doing no other work on the channel at the same other
         * than receiving a single message then the transaction is probably
         * unnecessary. Set to AcknowledgeMode.NONE to tell the broker not to
         * expect any acknowledgements, and it will assume all messages are
         * acknowledged as soon as they are sent (this is autoack in native
         * Rabbit broker terms). If AcknowledgeMode.NONE then the channel cannot
         * be transactional (so the container will fail on start up if that flag
         * is accidentally set).
         * 
         * The option will be converted to a
         * &lt;code&gt;org.springframework.amqp.core.AcknowledgeMode&lt;/code&gt; type.
         * 
         * Group: consumer
         * 
         * @param acknowledgeMode the value to set
         * @return the dsl builder
         */
        default SpringRabbitMQEndpointConsumerBuilder acknowledgeMode(
                String acknowledgeMode) {
            doSetProperty("acknowledgeMode", acknowledgeMode);
            return this;
        }
        /**
         * Whether the consumer processes the Exchange asynchronously. If
         * enabled then the consumer may pickup the next message from the queue,
         * while the previous message is being processed asynchronously (by the
         * Asynchronous Routing Engine). This means that messages may be
         * processed not 100% strictly in order. If disabled (as default) then
         * the Exchange is fully processed before the consumer will pickup the
         * next message from the queue.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: false
         * Group: consumer
         * 
         * @param asyncConsumer the value to set
         * @return the dsl builder
         */
        default SpringRabbitMQEndpointConsumerBuilder asyncConsumer(
                boolean asyncConsumer) {
            doSetProperty("asyncConsumer", asyncConsumer);
            return this;
        }
        /**
         * Whether the consumer processes the Exchange asynchronously. If
         * enabled then the consumer may pickup the next message from the queue,
         * while the previous message is being processed asynchronously (by the
         * Asynchronous Routing Engine). This means that messages may be
         * processed not 100% strictly in order. If disabled (as default) then
         * the Exchange is fully processed before the consumer will pickup the
         * next message from the queue.
         * 
         * The option will be converted to a &lt;code&gt;boolean&lt;/code&gt;
         * type.
         * 
         * Default: false
         * Group: consumer
         * 
         * @param asyncConsumer the value to set
         * @return the dsl builder
         */
        default SpringRabbitMQEndpointConsumerBuilder asyncConsumer(
                String asyncConsumer) {
            doSetProperty("asyncConsumer", asyncConsumer);
            return this;
        }
        /**
         * Specifies whether the consumer should auto declare binding between
         * exchange, queue and routing key when starting.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: true
         * Group: consumer
         * 
         * @param autoDeclare the value to set
         * @return the dsl builder
         */
        default SpringRabbitMQEndpointConsumerBuilder autoDeclare(
                boolean autoDeclare) {
            doSetProperty("autoDeclare", autoDeclare);
            return this;
        }
        /**
         * Specifies whether the consumer should auto declare binding between
         * exchange, queue and routing key when starting.
         * 
         * The option will be converted to a &lt;code&gt;boolean&lt;/code&gt;
         * type.
         * 
         * Default: true
         * Group: consumer
         * 
         * @param autoDeclare the value to set
         * @return the dsl builder
         */
        default SpringRabbitMQEndpointConsumerBuilder autoDeclare(
                String autoDeclare) {
            doSetProperty("autoDeclare", autoDeclare);
            return this;
        }
        /**
         * Specifies whether the consumer container should auto-startup.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: true
         * Group: consumer
         * 
         * @param autoStartup the value to set
         * @return the dsl builder
         */
        default SpringRabbitMQEndpointConsumerBuilder autoStartup(
                boolean autoStartup) {
            doSetProperty("autoStartup", autoStartup);
            return this;
        }
        /**
         * Specifies whether the consumer container should auto-startup.
         * 
         * The option will be converted to a &lt;code&gt;boolean&lt;/code&gt;
         * type.
         * 
         * Default: true
         * Group: consumer
         * 
         * @param autoStartup the value to set
         * @return the dsl builder
         */
        default SpringRabbitMQEndpointConsumerBuilder autoStartup(
                String autoStartup) {
            doSetProperty("autoStartup", autoStartup);
            return this;
        }
        /**
         * The name of the dead letter exchange.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: consumer
         * 
         * @param deadLetterExchange the value to set
         * @return the dsl builder
         */
        default SpringRabbitMQEndpointConsumerBuilder deadLetterExchange(
                String deadLetterExchange) {
            doSetProperty("deadLetterExchange", deadLetterExchange);
            return this;
        }
        /**
         * The type of the dead letter exchange.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Default: direct
         * Group: consumer
         * 
         * @param deadLetterExchangeType the value to set
         * @return the dsl builder
         */
        default SpringRabbitMQEndpointConsumerBuilder deadLetterExchangeType(
                String deadLetterExchangeType) {
            doSetProperty("deadLetterExchangeType", deadLetterExchangeType);
            return this;
        }
        /**
         * The name of the dead letter queue.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: consumer
         * 
         * @param deadLetterQueue the value to set
         * @return the dsl builder
         */
        default SpringRabbitMQEndpointConsumerBuilder deadLetterQueue(
                String deadLetterQueue) {
            doSetProperty("deadLetterQueue", deadLetterQueue);
            return this;
        }
        /**
         * The routing key for the dead letter exchange.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: consumer
         * 
         * @param deadLetterRoutingKey the value to set
         * @return the dsl builder
         */
        default SpringRabbitMQEndpointConsumerBuilder deadLetterRoutingKey(
                String deadLetterRoutingKey) {
            doSetProperty("deadLetterRoutingKey", deadLetterRoutingKey);
            return this;
        }
        /**
         * The type of the exchange.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Default: direct
         * Group: consumer
         * 
         * @param exchangeType the value to set
         * @return the dsl builder
         */
        default SpringRabbitMQEndpointConsumerBuilder exchangeType(
                String exchangeType) {
            doSetProperty("exchangeType", exchangeType);
            return this;
        }
        /**
         * Set to true for an exclusive consumer.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: false
         * Group: consumer
         * 
         * @param exclusive the value to set
         * @return the dsl builder
         */
        default SpringRabbitMQEndpointConsumerBuilder exclusive(
                boolean exclusive) {
            doSetProperty("exclusive", exclusive);
            return this;
        }
        /**
         * Set to true for an exclusive consumer.
         * 
         * The option will be converted to a &lt;code&gt;boolean&lt;/code&gt;
         * type.
         * 
         * Default: false
         * Group: consumer
         * 
         * @param exclusive the value to set
         * @return the dsl builder
         */
        default SpringRabbitMQEndpointConsumerBuilder exclusive(String exclusive) {
            doSetProperty("exclusive", exclusive);
            return this;
        }
        /**
         * How many times a Rabbitmq consumer will retry the same message if
         * Camel failed to process the message.
         * 
         * The option is a: &lt;code&gt;int&lt;/code&gt; type.
         * 
         * Default: 5
         * Group: consumer
         * 
         * @param maximumRetryAttempts the value to set
         * @return the dsl builder
         */
        default SpringRabbitMQEndpointConsumerBuilder maximumRetryAttempts(
                int maximumRetryAttempts) {
            doSetProperty("maximumRetryAttempts", maximumRetryAttempts);
            return this;
        }
        /**
         * How many times a Rabbitmq consumer will retry the same message if
         * Camel failed to process the message.
         * 
         * The option will be converted to a &lt;code&gt;int&lt;/code&gt; type.
         * 
         * Default: 5
         * Group: consumer
         * 
         * @param maximumRetryAttempts the value to set
         * @return the dsl builder
         */
        default SpringRabbitMQEndpointConsumerBuilder maximumRetryAttempts(
                String maximumRetryAttempts) {
            doSetProperty("maximumRetryAttempts", maximumRetryAttempts);
            return this;
        }
        /**
         * Set to true for an no-local consumer.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: false
         * Group: consumer
         * 
         * @param noLocal the value to set
         * @return the dsl builder
         */
        default SpringRabbitMQEndpointConsumerBuilder noLocal(boolean noLocal) {
            doSetProperty("noLocal", noLocal);
            return this;
        }
        /**
         * Set to true for an no-local consumer.
         * 
         * The option will be converted to a &lt;code&gt;boolean&lt;/code&gt;
         * type.
         * 
         * Default: false
         * Group: consumer
         * 
         * @param noLocal the value to set
         * @return the dsl builder
         */
        default SpringRabbitMQEndpointConsumerBuilder noLocal(String noLocal) {
            doSetProperty("noLocal", noLocal);
            return this;
        }
        /**
         * The queue(s) to use for consuming messages. Multiple queue names can
         * be separated by comma. If none has been configured then Camel will
         * generate an unique id as the queue name for the consumer.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: consumer
         * 
         * @param queues the value to set
         * @return the dsl builder
         */
        default SpringRabbitMQEndpointConsumerBuilder queues(String queues) {
            doSetProperty("queues", queues);
            return this;
        }
        /**
         * Whether a Rabbitmq consumer should reject the message without
         * requeuing. This enables failed messages to be sent to a Dead Letter
         * Exchange/Queue, if the broker is so configured.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: true
         * Group: consumer
         * 
         * @param rejectAndDontRequeue the value to set
         * @return the dsl builder
         */
        default SpringRabbitMQEndpointConsumerBuilder rejectAndDontRequeue(
                boolean rejectAndDontRequeue) {
            doSetProperty("rejectAndDontRequeue", rejectAndDontRequeue);
            return this;
        }
        /**
         * Whether a Rabbitmq consumer should reject the message without
         * requeuing. This enables failed messages to be sent to a Dead Letter
         * Exchange/Queue, if the broker is so configured.
         * 
         * The option will be converted to a &lt;code&gt;boolean&lt;/code&gt;
         * type.
         * 
         * Default: true
         * Group: consumer
         * 
         * @param rejectAndDontRequeue the value to set
         * @return the dsl builder
         */
        default SpringRabbitMQEndpointConsumerBuilder rejectAndDontRequeue(
                String rejectAndDontRequeue) {
            doSetProperty("rejectAndDontRequeue", rejectAndDontRequeue);
            return this;
        }
        /**
         * Delay in millis a Rabbitmq consumer will wait before redelivering a
         * message that Camel failed to process.
         * 
         * The option is a: &lt;code&gt;int&lt;/code&gt; type.
         * 
         * Default: 1000
         * Group: consumer
         * 
         * @param retryDelay the value to set
         * @return the dsl builder
         */
        default SpringRabbitMQEndpointConsumerBuilder retryDelay(int retryDelay) {
            doSetProperty("retryDelay", retryDelay);
            return this;
        }
        /**
         * Delay in millis a Rabbitmq consumer will wait before redelivering a
         * message that Camel failed to process.
         * 
         * The option will be converted to a &lt;code&gt;int&lt;/code&gt; type.
         * 
         * Default: 1000
         * Group: consumer
         * 
         * @param retryDelay the value to set
         * @return the dsl builder
         */
        default SpringRabbitMQEndpointConsumerBuilder retryDelay(
                String retryDelay) {
            doSetProperty("retryDelay", retryDelay);
            return this;
        }
    }

    /**
     * Advanced builder for endpoint consumers for the Spring RabbitMQ
     * component.
     */
    public interface AdvancedSpringRabbitMQEndpointConsumerBuilder
            extends
                EndpointConsumerBuilder {
        default SpringRabbitMQEndpointConsumerBuilder basic() {
            return (SpringRabbitMQEndpointConsumerBuilder) this;
        }
        /**
         * Allows for bridging the consumer to the Camel routing Error Handler,
         * which mean any exceptions occurred while the consumer is trying to
         * pickup incoming messages, or the likes, will now be processed as a
         * message and handled by the routing Error Handler. By default the
         * consumer will use the org.apache.camel.spi.ExceptionHandler to deal
         * with exceptions, that will be logged at WARN or ERROR level and
         * ignored.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: false
         * Group: consumer (advanced)
         * 
         * @param bridgeErrorHandler the value to set
         * @return the dsl builder
         */
        default AdvancedSpringRabbitMQEndpointConsumerBuilder bridgeErrorHandler(
                boolean bridgeErrorHandler) {
            doSetProperty("bridgeErrorHandler", bridgeErrorHandler);
            return this;
        }
        /**
         * Allows for bridging the consumer to the Camel routing Error Handler,
         * which mean any exceptions occurred while the consumer is trying to
         * pickup incoming messages, or the likes, will now be processed as a
         * message and handled by the routing Error Handler. By default the
         * consumer will use the org.apache.camel.spi.ExceptionHandler to deal
         * with exceptions, that will be logged at WARN or ERROR level and
         * ignored.
         * 
         * The option will be converted to a &lt;code&gt;boolean&lt;/code&gt;
         * type.
         * 
         * Default: false
         * Group: consumer (advanced)
         * 
         * @param bridgeErrorHandler the value to set
         * @return the dsl builder
         */
        default AdvancedSpringRabbitMQEndpointConsumerBuilder bridgeErrorHandler(
                String bridgeErrorHandler) {
            doSetProperty("bridgeErrorHandler", bridgeErrorHandler);
            return this;
        }
        /**
         * The number of consumers.
         * 
         * The option is a: &lt;code&gt;java.lang.Integer&lt;/code&gt; type.
         * 
         * Group: consumer (advanced)
         * 
         * @param concurrentConsumers the value to set
         * @return the dsl builder
         */
        default AdvancedSpringRabbitMQEndpointConsumerBuilder concurrentConsumers(
                Integer concurrentConsumers) {
            doSetProperty("concurrentConsumers", concurrentConsumers);
            return this;
        }
        /**
         * The number of consumers.
         * 
         * The option will be converted to a
         * &lt;code&gt;java.lang.Integer&lt;/code&gt; type.
         * 
         * Group: consumer (advanced)
         * 
         * @param concurrentConsumers the value to set
         * @return the dsl builder
         */
        default AdvancedSpringRabbitMQEndpointConsumerBuilder concurrentConsumers(
                String concurrentConsumers) {
            doSetProperty("concurrentConsumers", concurrentConsumers);
            return this;
        }
        /**
         * To let the consumer use a custom ExceptionHandler. Notice if the
         * option bridgeErrorHandler is enabled then this option is not in use.
         * By default the consumer will deal with exceptions, that will be
         * logged at WARN or ERROR level and ignored.
         * 
         * The option is a:
         * &lt;code&gt;org.apache.camel.spi.ExceptionHandler&lt;/code&gt; type.
         * 
         * Group: consumer (advanced)
         * 
         * @param exceptionHandler the value to set
         * @return the dsl builder
         */
        default AdvancedSpringRabbitMQEndpointConsumerBuilder exceptionHandler(
                org.apache.camel.spi.ExceptionHandler exceptionHandler) {
            doSetProperty("exceptionHandler", exceptionHandler);
            return this;
        }
        /**
         * To let the consumer use a custom ExceptionHandler. Notice if the
         * option bridgeErrorHandler is enabled then this option is not in use.
         * By default the consumer will deal with exceptions, that will be
         * logged at WARN or ERROR level and ignored.
         * 
         * The option will be converted to a
         * &lt;code&gt;org.apache.camel.spi.ExceptionHandler&lt;/code&gt; type.
         * 
         * Group: consumer (advanced)
         * 
         * @param exceptionHandler the value to set
         * @return the dsl builder
         */
        default AdvancedSpringRabbitMQEndpointConsumerBuilder exceptionHandler(
                String exceptionHandler) {
            doSetProperty("exceptionHandler", exceptionHandler);
            return this;
        }
        /**
         * Sets the exchange pattern when the consumer creates an exchange.
         * 
         * The option is a:
         * &lt;code&gt;org.apache.camel.ExchangePattern&lt;/code&gt; type.
         * 
         * Group: consumer (advanced)
         * 
         * @param exchangePattern the value to set
         * @return the dsl builder
         */
        default AdvancedSpringRabbitMQEndpointConsumerBuilder exchangePattern(
                org.apache.camel.ExchangePattern exchangePattern) {
            doSetProperty("exchangePattern", exchangePattern);
            return this;
        }
        /**
         * Sets the exchange pattern when the consumer creates an exchange.
         * 
         * The option will be converted to a
         * &lt;code&gt;org.apache.camel.ExchangePattern&lt;/code&gt; type.
         * 
         * Group: consumer (advanced)
         * 
         * @param exchangePattern the value to set
         * @return the dsl builder
         */
        default AdvancedSpringRabbitMQEndpointConsumerBuilder exchangePattern(
                String exchangePattern) {
            doSetProperty("exchangePattern", exchangePattern);
            return this;
        }
        /**
         * The maximum number of consumers (available only with SMLC).
         * 
         * The option is a: &lt;code&gt;java.lang.Integer&lt;/code&gt; type.
         * 
         * Group: consumer (advanced)
         * 
         * @param maxConcurrentConsumers the value to set
         * @return the dsl builder
         */
        default AdvancedSpringRabbitMQEndpointConsumerBuilder maxConcurrentConsumers(
                Integer maxConcurrentConsumers) {
            doSetProperty("maxConcurrentConsumers", maxConcurrentConsumers);
            return this;
        }
        /**
         * The maximum number of consumers (available only with SMLC).
         * 
         * The option will be converted to a
         * &lt;code&gt;java.lang.Integer&lt;/code&gt; type.
         * 
         * Group: consumer (advanced)
         * 
         * @param maxConcurrentConsumers the value to set
         * @return the dsl builder
         */
        default AdvancedSpringRabbitMQEndpointConsumerBuilder maxConcurrentConsumers(
                String maxConcurrentConsumers) {
            doSetProperty("maxConcurrentConsumers", maxConcurrentConsumers);
            return this;
        }
        /**
         * The type of the MessageListenerContainer.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Default: DMLC
         * Group: consumer (advanced)
         * 
         * @param messageListenerContainerType the value to set
         * @return the dsl builder
         */
        default AdvancedSpringRabbitMQEndpointConsumerBuilder messageListenerContainerType(
                String messageListenerContainerType) {
            doSetProperty("messageListenerContainerType", messageListenerContainerType);
            return this;
        }
        /**
         * Tell the broker how many messages to send in a single request. Often
         * this can be set quite high to improve throughput.
         * 
         * The option is a: &lt;code&gt;java.lang.Integer&lt;/code&gt; type.
         * 
         * Group: consumer (advanced)
         * 
         * @param prefetchCount the value to set
         * @return the dsl builder
         */
        default AdvancedSpringRabbitMQEndpointConsumerBuilder prefetchCount(
                Integer prefetchCount) {
            doSetProperty("prefetchCount", prefetchCount);
            return this;
        }
        /**
         * Tell the broker how many messages to send in a single request. Often
         * this can be set quite high to improve throughput.
         * 
         * The option will be converted to a
         * &lt;code&gt;java.lang.Integer&lt;/code&gt; type.
         * 
         * Group: consumer (advanced)
         * 
         * @param prefetchCount the value to set
         * @return the dsl builder
         */
        default AdvancedSpringRabbitMQEndpointConsumerBuilder prefetchCount(
                String prefetchCount) {
            doSetProperty("prefetchCount", prefetchCount);
            return this;
        }
        /**
         * Custom retry configuration to use. If this is configured then the
         * other settings such as maximumRetryAttempts for retry are not in use.
         * 
         * The option is a:
         * &lt;code&gt;org.springframework.retry.interceptor.RetryOperationsInterceptor&lt;/code&gt; type.
         * 
         * Group: consumer (advanced)
         * 
         * @param retry the value to set
         * @return the dsl builder
         */
        default AdvancedSpringRabbitMQEndpointConsumerBuilder retry(
                org.springframework.retry.interceptor.RetryOperationsInterceptor retry) {
            doSetProperty("retry", retry);
            return this;
        }
        /**
         * Custom retry configuration to use. If this is configured then the
         * other settings such as maximumRetryAttempts for retry are not in use.
         * 
         * The option will be converted to a
         * &lt;code&gt;org.springframework.retry.interceptor.RetryOperationsInterceptor&lt;/code&gt; type.
         * 
         * Group: consumer (advanced)
         * 
         * @param retry the value to set
         * @return the dsl builder
         */
        default AdvancedSpringRabbitMQEndpointConsumerBuilder retry(String retry) {
            doSetProperty("retry", retry);
            return this;
        }
        /**
         * Specify arguments for configuring the different RabbitMQ concepts, a
         * different prefix is required for each element: arg.consumer.
         * arg.exchange. arg.queue. arg.binding. arg.dlq.exchange.
         * arg.dlq.queue. arg.dlq.binding. For example to declare a queue with
         * message ttl argument: args=arg.queue.x-message-ttl=60000.
         * 
         * The option is a: &lt;code&gt;java.util.Map&amp;lt;java.lang.String,
         * java.lang.Object&amp;gt;&lt;/code&gt; type.
         * The option is multivalued, and you can use the args(String, Object)
         * method to add a value (call the method multiple times to set more
         * values).
         * 
         * Group: advanced
         * 
         * @param key the option key
         * @param value the option value
         * @return the dsl builder
         */
        default AdvancedSpringRabbitMQEndpointConsumerBuilder args(
                String key,
                Object value) {
            doSetMultiValueProperty("args", "arg." + key, value);
            return this;
        }
        /**
         * Specify arguments for configuring the different RabbitMQ concepts, a
         * different prefix is required for each element: arg.consumer.
         * arg.exchange. arg.queue. arg.binding. arg.dlq.exchange.
         * arg.dlq.queue. arg.dlq.binding. For example to declare a queue with
         * message ttl argument: args=arg.queue.x-message-ttl=60000.
         * 
         * The option is a: &lt;code&gt;java.util.Map&amp;lt;java.lang.String,
         * java.lang.Object&amp;gt;&lt;/code&gt; type.
         * The option is multivalued, and you can use the args(String, Object)
         * method to add a value (call the method multiple times to set more
         * values).
         * 
         * Group: advanced
         * 
         * @param values the values
         * @return the dsl builder
         */
        default AdvancedSpringRabbitMQEndpointConsumerBuilder args(Map values) {
            doSetMultiValueProperties("args", "arg.", values);
            return this;
        }
        /**
         * To use a custom MessageConverter so you can be in control how to map
         * to/from a org.springframework.amqp.core.Message.
         * 
         * The option is a:
         * &lt;code&gt;org.springframework.amqp.support.converter.MessageConverter&lt;/code&gt; type.
         * 
         * Group: advanced
         * 
         * @param messageConverter the value to set
         * @return the dsl builder
         */
        default AdvancedSpringRabbitMQEndpointConsumerBuilder messageConverter(
                org.springframework.amqp.support.converter.MessageConverter messageConverter) {
            doSetProperty("messageConverter", messageConverter);
            return this;
        }
        /**
         * To use a custom MessageConverter so you can be in control how to map
         * to/from a org.springframework.amqp.core.Message.
         * 
         * The option will be converted to a
         * &lt;code&gt;org.springframework.amqp.support.converter.MessageConverter&lt;/code&gt; type.
         * 
         * Group: advanced
         * 
         * @param messageConverter the value to set
         * @return the dsl builder
         */
        default AdvancedSpringRabbitMQEndpointConsumerBuilder messageConverter(
                String messageConverter) {
            doSetProperty("messageConverter", messageConverter);
            return this;
        }
        /**
         * To use a custom MessagePropertiesConverter so you can be in control
         * how to map to/from a org.springframework.amqp.core.MessageProperties.
         * 
         * The option is a:
         * &lt;code&gt;org.apache.camel.component.springrabbit.MessagePropertiesConverter&lt;/code&gt; type.
         * 
         * Group: advanced
         * 
         * @param messagePropertiesConverter the value to set
         * @return the dsl builder
         */
        default AdvancedSpringRabbitMQEndpointConsumerBuilder messagePropertiesConverter(
                org.apache.camel.component.springrabbit.MessagePropertiesConverter messagePropertiesConverter) {
            doSetProperty("messagePropertiesConverter", messagePropertiesConverter);
            return this;
        }
        /**
         * To use a custom MessagePropertiesConverter so you can be in control
         * how to map to/from a org.springframework.amqp.core.MessageProperties.
         * 
         * The option will be converted to a
         * &lt;code&gt;org.apache.camel.component.springrabbit.MessagePropertiesConverter&lt;/code&gt; type.
         * 
         * Group: advanced
         * 
         * @param messagePropertiesConverter the value to set
         * @return the dsl builder
         */
        default AdvancedSpringRabbitMQEndpointConsumerBuilder messagePropertiesConverter(
                String messagePropertiesConverter) {
            doSetProperty("messagePropertiesConverter", messagePropertiesConverter);
            return this;
        }
        /**
         * Sets whether synchronous processing should be strictly used.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: false
         * Group: advanced
         * 
         * @param synchronous the value to set
         * @return the dsl builder
         */
        default AdvancedSpringRabbitMQEndpointConsumerBuilder synchronous(
                boolean synchronous) {
            doSetProperty("synchronous", synchronous);
            return this;
        }
        /**
         * Sets whether synchronous processing should be strictly used.
         * 
         * The option will be converted to a &lt;code&gt;boolean&lt;/code&gt;
         * type.
         * 
         * Default: false
         * Group: advanced
         * 
         * @param synchronous the value to set
         * @return the dsl builder
         */
        default AdvancedSpringRabbitMQEndpointConsumerBuilder synchronous(
                String synchronous) {
            doSetProperty("synchronous", synchronous);
            return this;
        }
    }

    /**
     * Builder for endpoint producers for the Spring RabbitMQ component.
     */
    public interface SpringRabbitMQEndpointProducerBuilder
            extends
                EndpointProducerBuilder {
        default AdvancedSpringRabbitMQEndpointProducerBuilder advanced() {
            return (AdvancedSpringRabbitMQEndpointProducerBuilder) this;
        }
        /**
         * The connection factory to be use. A connection factory must be
         * configured either on the component or endpoint.
         * 
         * The option is a:
         * &lt;code&gt;org.springframework.amqp.rabbit.connection.ConnectionFactory&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param connectionFactory the value to set
         * @return the dsl builder
         */
        default SpringRabbitMQEndpointProducerBuilder connectionFactory(
                org.springframework.amqp.rabbit.connection.ConnectionFactory connectionFactory) {
            doSetProperty("connectionFactory", connectionFactory);
            return this;
        }
        /**
         * The connection factory to be use. A connection factory must be
         * configured either on the component or endpoint.
         * 
         * The option will be converted to a
         * &lt;code&gt;org.springframework.amqp.rabbit.connection.ConnectionFactory&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param connectionFactory the value to set
         * @return the dsl builder
         */
        default SpringRabbitMQEndpointProducerBuilder connectionFactory(
                String connectionFactory) {
            doSetProperty("connectionFactory", connectionFactory);
            return this;
        }
        /**
         * Specifies whether Camel ignores the ReplyTo header in messages. If
         * true, Camel does not send a reply back to the destination specified
         * in the ReplyTo header. You can use this option if you want Camel to
         * consume from a route and you do not want Camel to automatically send
         * back a reply message because another component in your code handles
         * the reply message. You can also use this option if you want to use
         * Camel as a proxy between different message brokers and you want to
         * route message from one system to another.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: false
         * Group: common
         * 
         * @param disableReplyTo the value to set
         * @return the dsl builder
         */
        default SpringRabbitMQEndpointProducerBuilder disableReplyTo(
                boolean disableReplyTo) {
            doSetProperty("disableReplyTo", disableReplyTo);
            return this;
        }
        /**
         * Specifies whether Camel ignores the ReplyTo header in messages. If
         * true, Camel does not send a reply back to the destination specified
         * in the ReplyTo header. You can use this option if you want Camel to
         * consume from a route and you do not want Camel to automatically send
         * back a reply message because another component in your code handles
         * the reply message. You can also use this option if you want to use
         * Camel as a proxy between different message brokers and you want to
         * route message from one system to another.
         * 
         * The option will be converted to a &lt;code&gt;boolean&lt;/code&gt;
         * type.
         * 
         * Default: false
         * Group: common
         * 
         * @param disableReplyTo the value to set
         * @return the dsl builder
         */
        default SpringRabbitMQEndpointProducerBuilder disableReplyTo(
                String disableReplyTo) {
            doSetProperty("disableReplyTo", disableReplyTo);
            return this;
        }
        /**
         * The value of a routing key to use. Default is empty which is not
         * helpful when using the default (or any direct) exchange, but fine if
         * the exchange is a headers exchange for instance.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param routingKey the value to set
         * @return the dsl builder
         */
        default SpringRabbitMQEndpointProducerBuilder routingKey(
                String routingKey) {
            doSetProperty("routingKey", routingKey);
            return this;
        }
        /**
         * Specifies whether to test the connection on startup. This ensures
         * that when Camel starts that all the JMS consumers have a valid
         * connection to the JMS broker. If a connection cannot be granted then
         * Camel throws an exception on startup. This ensures that Camel is not
         * started with failed connections. The JMS producers is tested as well.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: false
         * Group: common
         * 
         * @param testConnectionOnStartup the value to set
         * @return the dsl builder
         */
        default SpringRabbitMQEndpointProducerBuilder testConnectionOnStartup(
                boolean testConnectionOnStartup) {
            doSetProperty("testConnectionOnStartup", testConnectionOnStartup);
            return this;
        }
        /**
         * Specifies whether to test the connection on startup. This ensures
         * that when Camel starts that all the JMS consumers have a valid
         * connection to the JMS broker. If a connection cannot be granted then
         * Camel throws an exception on startup. This ensures that Camel is not
         * started with failed connections. The JMS producers is tested as well.
         * 
         * The option will be converted to a &lt;code&gt;boolean&lt;/code&gt;
         * type.
         * 
         * Default: false
         * Group: common
         * 
         * @param testConnectionOnStartup the value to set
         * @return the dsl builder
         */
        default SpringRabbitMQEndpointProducerBuilder testConnectionOnStartup(
                String testConnectionOnStartup) {
            doSetProperty("testConnectionOnStartup", testConnectionOnStartup);
            return this;
        }
        /**
         * Whether to allow sending messages with no body. If this option is
         * false and the message body is null, then an
         * MessageConversionException is thrown.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: false
         * Group: producer
         * 
         * @param allowNullBody the value to set
         * @return the dsl builder
         */
        default SpringRabbitMQEndpointProducerBuilder allowNullBody(
                boolean allowNullBody) {
            doSetProperty("allowNullBody", allowNullBody);
            return this;
        }
        /**
         * Whether to allow sending messages with no body. If this option is
         * false and the message body is null, then an
         * MessageConversionException is thrown.
         * 
         * The option will be converted to a &lt;code&gt;boolean&lt;/code&gt;
         * type.
         * 
         * Default: false
         * Group: producer
         * 
         * @param allowNullBody the value to set
         * @return the dsl builder
         */
        default SpringRabbitMQEndpointProducerBuilder allowNullBody(
                String allowNullBody) {
            doSetProperty("allowNullBody", allowNullBody);
            return this;
        }
        /**
         * Controls whether to wait for confirms. The connection factory must be
         * configured for publisher confirms and this method. auto = Camel
         * detects if the connection factory uses confirms or not. disabled =
         * Confirms is disabled. enabled = Confirms is enabled.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Default: auto
         * Group: producer
         * 
         * @param confirm the value to set
         * @return the dsl builder
         */
        default SpringRabbitMQEndpointProducerBuilder confirm(String confirm) {
            doSetProperty("confirm", confirm);
            return this;
        }
        /**
         * Specify the timeout in milliseconds to be used when waiting for a
         * message sent to be confirmed by RabbitMQ when doing send only
         * messaging (InOnly). The default value is 5 seconds. A negative value
         * indicates an indefinite timeout.
         * 
         * The option is a: &lt;code&gt;long&lt;/code&gt; type.
         * 
         * Default: 5000
         * Group: producer
         * 
         * @param confirmTimeout the value to set
         * @return the dsl builder
         */
        default SpringRabbitMQEndpointProducerBuilder confirmTimeout(
                long confirmTimeout) {
            doSetProperty("confirmTimeout", confirmTimeout);
            return this;
        }
        /**
         * Specify the timeout in milliseconds to be used when waiting for a
         * message sent to be confirmed by RabbitMQ when doing send only
         * messaging (InOnly). The default value is 5 seconds. A negative value
         * indicates an indefinite timeout.
         * 
         * The option will be converted to a &lt;code&gt;long&lt;/code&gt; type.
         * 
         * Default: 5000
         * Group: producer
         * 
         * @param confirmTimeout the value to set
         * @return the dsl builder
         */
        default SpringRabbitMQEndpointProducerBuilder confirmTimeout(
                String confirmTimeout) {
            doSetProperty("confirmTimeout", confirmTimeout);
            return this;
        }
        /**
         * Specify the timeout in milliseconds to be used when waiting for a
         * reply message when doing request/reply (InOut) messaging. The default
         * value is 30 seconds. A negative value indicates an indefinite timeout
         * (Beware that this will cause a memory leak if a reply is not
         * received).
         * 
         * The option is a: &lt;code&gt;long&lt;/code&gt; type.
         * 
         * Default: 30000
         * Group: producer
         * 
         * @param replyTimeout the value to set
         * @return the dsl builder
         */
        default SpringRabbitMQEndpointProducerBuilder replyTimeout(
                long replyTimeout) {
            doSetProperty("replyTimeout", replyTimeout);
            return this;
        }
        /**
         * Specify the timeout in milliseconds to be used when waiting for a
         * reply message when doing request/reply (InOut) messaging. The default
         * value is 30 seconds. A negative value indicates an indefinite timeout
         * (Beware that this will cause a memory leak if a reply is not
         * received).
         * 
         * The option will be converted to a &lt;code&gt;long&lt;/code&gt; type.
         * 
         * Default: 30000
         * Group: producer
         * 
         * @param replyTimeout the value to set
         * @return the dsl builder
         */
        default SpringRabbitMQEndpointProducerBuilder replyTimeout(
                String replyTimeout) {
            doSetProperty("replyTimeout", replyTimeout);
            return this;
        }
        /**
         * Use a separate connection for publishers and consumers.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: false
         * Group: producer
         * 
         * @param usePublisherConnection the value to set
         * @return the dsl builder
         */
        default SpringRabbitMQEndpointProducerBuilder usePublisherConnection(
                boolean usePublisherConnection) {
            doSetProperty("usePublisherConnection", usePublisherConnection);
            return this;
        }
        /**
         * Use a separate connection for publishers and consumers.
         * 
         * The option will be converted to a &lt;code&gt;boolean&lt;/code&gt;
         * type.
         * 
         * Default: false
         * Group: producer
         * 
         * @param usePublisherConnection the value to set
         * @return the dsl builder
         */
        default SpringRabbitMQEndpointProducerBuilder usePublisherConnection(
                String usePublisherConnection) {
            doSetProperty("usePublisherConnection", usePublisherConnection);
            return this;
        }
    }

    /**
     * Advanced builder for endpoint producers for the Spring RabbitMQ
     * component.
     */
    public interface AdvancedSpringRabbitMQEndpointProducerBuilder
            extends
                EndpointProducerBuilder {
        default SpringRabbitMQEndpointProducerBuilder basic() {
            return (SpringRabbitMQEndpointProducerBuilder) this;
        }
        /**
         * Whether the producer should be started lazy (on the first message).
         * By starting lazy you can use this to allow CamelContext and routes to
         * startup in situations where a producer may otherwise fail during
         * starting and cause the route to fail being started. By deferring this
         * startup to be lazy then the startup failure can be handled during
         * routing messages via Camel's routing error handlers. Beware that when
         * the first message is processed then creating and starting the
         * producer may take a little time and prolong the total processing time
         * of the processing.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: false
         * Group: producer (advanced)
         * 
         * @param lazyStartProducer the value to set
         * @return the dsl builder
         */
        default AdvancedSpringRabbitMQEndpointProducerBuilder lazyStartProducer(
                boolean lazyStartProducer) {
            doSetProperty("lazyStartProducer", lazyStartProducer);
            return this;
        }
        /**
         * Whether the producer should be started lazy (on the first message).
         * By starting lazy you can use this to allow CamelContext and routes to
         * startup in situations where a producer may otherwise fail during
         * starting and cause the route to fail being started. By deferring this
         * startup to be lazy then the startup failure can be handled during
         * routing messages via Camel's routing error handlers. Beware that when
         * the first message is processed then creating and starting the
         * producer may take a little time and prolong the total processing time
         * of the processing.
         * 
         * The option will be converted to a &lt;code&gt;boolean&lt;/code&gt;
         * type.
         * 
         * Default: false
         * Group: producer (advanced)
         * 
         * @param lazyStartProducer the value to set
         * @return the dsl builder
         */
        default AdvancedSpringRabbitMQEndpointProducerBuilder lazyStartProducer(
                String lazyStartProducer) {
            doSetProperty("lazyStartProducer", lazyStartProducer);
            return this;
        }
        /**
         * Specify arguments for configuring the different RabbitMQ concepts, a
         * different prefix is required for each element: arg.consumer.
         * arg.exchange. arg.queue. arg.binding. arg.dlq.exchange.
         * arg.dlq.queue. arg.dlq.binding. For example to declare a queue with
         * message ttl argument: args=arg.queue.x-message-ttl=60000.
         * 
         * The option is a: &lt;code&gt;java.util.Map&amp;lt;java.lang.String,
         * java.lang.Object&amp;gt;&lt;/code&gt; type.
         * The option is multivalued, and you can use the args(String, Object)
         * method to add a value (call the method multiple times to set more
         * values).
         * 
         * Group: advanced
         * 
         * @param key the option key
         * @param value the option value
         * @return the dsl builder
         */
        default AdvancedSpringRabbitMQEndpointProducerBuilder args(
                String key,
                Object value) {
            doSetMultiValueProperty("args", "arg." + key, value);
            return this;
        }
        /**
         * Specify arguments for configuring the different RabbitMQ concepts, a
         * different prefix is required for each element: arg.consumer.
         * arg.exchange. arg.queue. arg.binding. arg.dlq.exchange.
         * arg.dlq.queue. arg.dlq.binding. For example to declare a queue with
         * message ttl argument: args=arg.queue.x-message-ttl=60000.
         * 
         * The option is a: &lt;code&gt;java.util.Map&amp;lt;java.lang.String,
         * java.lang.Object&amp;gt;&lt;/code&gt; type.
         * The option is multivalued, and you can use the args(String, Object)
         * method to add a value (call the method multiple times to set more
         * values).
         * 
         * Group: advanced
         * 
         * @param values the values
         * @return the dsl builder
         */
        default AdvancedSpringRabbitMQEndpointProducerBuilder args(Map values) {
            doSetMultiValueProperties("args", "arg.", values);
            return this;
        }
        /**
         * To use a custom MessageConverter so you can be in control how to map
         * to/from a org.springframework.amqp.core.Message.
         * 
         * The option is a:
         * &lt;code&gt;org.springframework.amqp.support.converter.MessageConverter&lt;/code&gt; type.
         * 
         * Group: advanced
         * 
         * @param messageConverter the value to set
         * @return the dsl builder
         */
        default AdvancedSpringRabbitMQEndpointProducerBuilder messageConverter(
                org.springframework.amqp.support.converter.MessageConverter messageConverter) {
            doSetProperty("messageConverter", messageConverter);
            return this;
        }
        /**
         * To use a custom MessageConverter so you can be in control how to map
         * to/from a org.springframework.amqp.core.Message.
         * 
         * The option will be converted to a
         * &lt;code&gt;org.springframework.amqp.support.converter.MessageConverter&lt;/code&gt; type.
         * 
         * Group: advanced
         * 
         * @param messageConverter the value to set
         * @return the dsl builder
         */
        default AdvancedSpringRabbitMQEndpointProducerBuilder messageConverter(
                String messageConverter) {
            doSetProperty("messageConverter", messageConverter);
            return this;
        }
        /**
         * To use a custom MessagePropertiesConverter so you can be in control
         * how to map to/from a org.springframework.amqp.core.MessageProperties.
         * 
         * The option is a:
         * &lt;code&gt;org.apache.camel.component.springrabbit.MessagePropertiesConverter&lt;/code&gt; type.
         * 
         * Group: advanced
         * 
         * @param messagePropertiesConverter the value to set
         * @return the dsl builder
         */
        default AdvancedSpringRabbitMQEndpointProducerBuilder messagePropertiesConverter(
                org.apache.camel.component.springrabbit.MessagePropertiesConverter messagePropertiesConverter) {
            doSetProperty("messagePropertiesConverter", messagePropertiesConverter);
            return this;
        }
        /**
         * To use a custom MessagePropertiesConverter so you can be in control
         * how to map to/from a org.springframework.amqp.core.MessageProperties.
         * 
         * The option will be converted to a
         * &lt;code&gt;org.apache.camel.component.springrabbit.MessagePropertiesConverter&lt;/code&gt; type.
         * 
         * Group: advanced
         * 
         * @param messagePropertiesConverter the value to set
         * @return the dsl builder
         */
        default AdvancedSpringRabbitMQEndpointProducerBuilder messagePropertiesConverter(
                String messagePropertiesConverter) {
            doSetProperty("messagePropertiesConverter", messagePropertiesConverter);
            return this;
        }
        /**
         * Sets whether synchronous processing should be strictly used.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: false
         * Group: advanced
         * 
         * @param synchronous the value to set
         * @return the dsl builder
         */
        default AdvancedSpringRabbitMQEndpointProducerBuilder synchronous(
                boolean synchronous) {
            doSetProperty("synchronous", synchronous);
            return this;
        }
        /**
         * Sets whether synchronous processing should be strictly used.
         * 
         * The option will be converted to a &lt;code&gt;boolean&lt;/code&gt;
         * type.
         * 
         * Default: false
         * Group: advanced
         * 
         * @param synchronous the value to set
         * @return the dsl builder
         */
        default AdvancedSpringRabbitMQEndpointProducerBuilder synchronous(
                String synchronous) {
            doSetProperty("synchronous", synchronous);
            return this;
        }
    }

    /**
     * Builder for endpoint for the Spring RabbitMQ component.
     */
    public interface SpringRabbitMQEndpointBuilder
            extends
                SpringRabbitMQEndpointConsumerBuilder,
                SpringRabbitMQEndpointProducerBuilder {
        default AdvancedSpringRabbitMQEndpointBuilder advanced() {
            return (AdvancedSpringRabbitMQEndpointBuilder) this;
        }
        /**
         * The connection factory to be use. A connection factory must be
         * configured either on the component or endpoint.
         * 
         * The option is a:
         * &lt;code&gt;org.springframework.amqp.rabbit.connection.ConnectionFactory&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param connectionFactory the value to set
         * @return the dsl builder
         */
        default SpringRabbitMQEndpointBuilder connectionFactory(
                org.springframework.amqp.rabbit.connection.ConnectionFactory connectionFactory) {
            doSetProperty("connectionFactory", connectionFactory);
            return this;
        }
        /**
         * The connection factory to be use. A connection factory must be
         * configured either on the component or endpoint.
         * 
         * The option will be converted to a
         * &lt;code&gt;org.springframework.amqp.rabbit.connection.ConnectionFactory&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param connectionFactory the value to set
         * @return the dsl builder
         */
        default SpringRabbitMQEndpointBuilder connectionFactory(
                String connectionFactory) {
            doSetProperty("connectionFactory", connectionFactory);
            return this;
        }
        /**
         * Specifies whether Camel ignores the ReplyTo header in messages. If
         * true, Camel does not send a reply back to the destination specified
         * in the ReplyTo header. You can use this option if you want Camel to
         * consume from a route and you do not want Camel to automatically send
         * back a reply message because another component in your code handles
         * the reply message. You can also use this option if you want to use
         * Camel as a proxy between different message brokers and you want to
         * route message from one system to another.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: false
         * Group: common
         * 
         * @param disableReplyTo the value to set
         * @return the dsl builder
         */
        default SpringRabbitMQEndpointBuilder disableReplyTo(
                boolean disableReplyTo) {
            doSetProperty("disableReplyTo", disableReplyTo);
            return this;
        }
        /**
         * Specifies whether Camel ignores the ReplyTo header in messages. If
         * true, Camel does not send a reply back to the destination specified
         * in the ReplyTo header. You can use this option if you want Camel to
         * consume from a route and you do not want Camel to automatically send
         * back a reply message because another component in your code handles
         * the reply message. You can also use this option if you want to use
         * Camel as a proxy between different message brokers and you want to
         * route message from one system to another.
         * 
         * The option will be converted to a &lt;code&gt;boolean&lt;/code&gt;
         * type.
         * 
         * Default: false
         * Group: common
         * 
         * @param disableReplyTo the value to set
         * @return the dsl builder
         */
        default SpringRabbitMQEndpointBuilder disableReplyTo(
                String disableReplyTo) {
            doSetProperty("disableReplyTo", disableReplyTo);
            return this;
        }
        /**
         * The value of a routing key to use. Default is empty which is not
         * helpful when using the default (or any direct) exchange, but fine if
         * the exchange is a headers exchange for instance.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param routingKey the value to set
         * @return the dsl builder
         */
        default SpringRabbitMQEndpointBuilder routingKey(String routingKey) {
            doSetProperty("routingKey", routingKey);
            return this;
        }
        /**
         * Specifies whether to test the connection on startup. This ensures
         * that when Camel starts that all the JMS consumers have a valid
         * connection to the JMS broker. If a connection cannot be granted then
         * Camel throws an exception on startup. This ensures that Camel is not
         * started with failed connections. The JMS producers is tested as well.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: false
         * Group: common
         * 
         * @param testConnectionOnStartup the value to set
         * @return the dsl builder
         */
        default SpringRabbitMQEndpointBuilder testConnectionOnStartup(
                boolean testConnectionOnStartup) {
            doSetProperty("testConnectionOnStartup", testConnectionOnStartup);
            return this;
        }
        /**
         * Specifies whether to test the connection on startup. This ensures
         * that when Camel starts that all the JMS consumers have a valid
         * connection to the JMS broker. If a connection cannot be granted then
         * Camel throws an exception on startup. This ensures that Camel is not
         * started with failed connections. The JMS producers is tested as well.
         * 
         * The option will be converted to a &lt;code&gt;boolean&lt;/code&gt;
         * type.
         * 
         * Default: false
         * Group: common
         * 
         * @param testConnectionOnStartup the value to set
         * @return the dsl builder
         */
        default SpringRabbitMQEndpointBuilder testConnectionOnStartup(
                String testConnectionOnStartup) {
            doSetProperty("testConnectionOnStartup", testConnectionOnStartup);
            return this;
        }
    }

    /**
     * Advanced builder for endpoint for the Spring RabbitMQ component.
     */
    public interface AdvancedSpringRabbitMQEndpointBuilder
            extends
                AdvancedSpringRabbitMQEndpointConsumerBuilder,
                AdvancedSpringRabbitMQEndpointProducerBuilder {
        default SpringRabbitMQEndpointBuilder basic() {
            return (SpringRabbitMQEndpointBuilder) this;
        }
        /**
         * Specify arguments for configuring the different RabbitMQ concepts, a
         * different prefix is required for each element: arg.consumer.
         * arg.exchange. arg.queue. arg.binding. arg.dlq.exchange.
         * arg.dlq.queue. arg.dlq.binding. For example to declare a queue with
         * message ttl argument: args=arg.queue.x-message-ttl=60000.
         * 
         * The option is a: &lt;code&gt;java.util.Map&amp;lt;java.lang.String,
         * java.lang.Object&amp;gt;&lt;/code&gt; type.
         * The option is multivalued, and you can use the args(String, Object)
         * method to add a value (call the method multiple times to set more
         * values).
         * 
         * Group: advanced
         * 
         * @param key the option key
         * @param value the option value
         * @return the dsl builder
         */
        default AdvancedSpringRabbitMQEndpointBuilder args(
                String key,
                Object value) {
            doSetMultiValueProperty("args", "arg." + key, value);
            return this;
        }
        /**
         * Specify arguments for configuring the different RabbitMQ concepts, a
         * different prefix is required for each element: arg.consumer.
         * arg.exchange. arg.queue. arg.binding. arg.dlq.exchange.
         * arg.dlq.queue. arg.dlq.binding. For example to declare a queue with
         * message ttl argument: args=arg.queue.x-message-ttl=60000.
         * 
         * The option is a: &lt;code&gt;java.util.Map&amp;lt;java.lang.String,
         * java.lang.Object&amp;gt;&lt;/code&gt; type.
         * The option is multivalued, and you can use the args(String, Object)
         * method to add a value (call the method multiple times to set more
         * values).
         * 
         * Group: advanced
         * 
         * @param values the values
         * @return the dsl builder
         */
        default AdvancedSpringRabbitMQEndpointBuilder args(Map values) {
            doSetMultiValueProperties("args", "arg.", values);
            return this;
        }
        /**
         * To use a custom MessageConverter so you can be in control how to map
         * to/from a org.springframework.amqp.core.Message.
         * 
         * The option is a:
         * &lt;code&gt;org.springframework.amqp.support.converter.MessageConverter&lt;/code&gt; type.
         * 
         * Group: advanced
         * 
         * @param messageConverter the value to set
         * @return the dsl builder
         */
        default AdvancedSpringRabbitMQEndpointBuilder messageConverter(
                org.springframework.amqp.support.converter.MessageConverter messageConverter) {
            doSetProperty("messageConverter", messageConverter);
            return this;
        }
        /**
         * To use a custom MessageConverter so you can be in control how to map
         * to/from a org.springframework.amqp.core.Message.
         * 
         * The option will be converted to a
         * &lt;code&gt;org.springframework.amqp.support.converter.MessageConverter&lt;/code&gt; type.
         * 
         * Group: advanced
         * 
         * @param messageConverter the value to set
         * @return the dsl builder
         */
        default AdvancedSpringRabbitMQEndpointBuilder messageConverter(
                String messageConverter) {
            doSetProperty("messageConverter", messageConverter);
            return this;
        }
        /**
         * To use a custom MessagePropertiesConverter so you can be in control
         * how to map to/from a org.springframework.amqp.core.MessageProperties.
         * 
         * The option is a:
         * &lt;code&gt;org.apache.camel.component.springrabbit.MessagePropertiesConverter&lt;/code&gt; type.
         * 
         * Group: advanced
         * 
         * @param messagePropertiesConverter the value to set
         * @return the dsl builder
         */
        default AdvancedSpringRabbitMQEndpointBuilder messagePropertiesConverter(
                org.apache.camel.component.springrabbit.MessagePropertiesConverter messagePropertiesConverter) {
            doSetProperty("messagePropertiesConverter", messagePropertiesConverter);
            return this;
        }
        /**
         * To use a custom MessagePropertiesConverter so you can be in control
         * how to map to/from a org.springframework.amqp.core.MessageProperties.
         * 
         * The option will be converted to a
         * &lt;code&gt;org.apache.camel.component.springrabbit.MessagePropertiesConverter&lt;/code&gt; type.
         * 
         * Group: advanced
         * 
         * @param messagePropertiesConverter the value to set
         * @return the dsl builder
         */
        default AdvancedSpringRabbitMQEndpointBuilder messagePropertiesConverter(
                String messagePropertiesConverter) {
            doSetProperty("messagePropertiesConverter", messagePropertiesConverter);
            return this;
        }
        /**
         * Sets whether synchronous processing should be strictly used.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: false
         * Group: advanced
         * 
         * @param synchronous the value to set
         * @return the dsl builder
         */
        default AdvancedSpringRabbitMQEndpointBuilder synchronous(
                boolean synchronous) {
            doSetProperty("synchronous", synchronous);
            return this;
        }
        /**
         * Sets whether synchronous processing should be strictly used.
         * 
         * The option will be converted to a &lt;code&gt;boolean&lt;/code&gt;
         * type.
         * 
         * Default: false
         * Group: advanced
         * 
         * @param synchronous the value to set
         * @return the dsl builder
         */
        default AdvancedSpringRabbitMQEndpointBuilder synchronous(
                String synchronous) {
            doSetProperty("synchronous", synchronous);
            return this;
        }
    }

    public interface SpringRabbitMQBuilders {
        /**
         * Spring RabbitMQ (camel-spring-rabbitmq)
         * Send and receive messages from RabbitMQ using Spring RabbitMQ client.
         * 
         * Category: messaging
         * Since: 3.8
         * Maven coordinates: org.apache.camel:camel-spring-rabbitmq
         * 
         * @return the dsl builder for the headers' name.
         */
        default SpringRabbitMQHeaderNameBuilder springRabbitmq() {
            return SpringRabbitMQHeaderNameBuilder.INSTANCE;
        }
        /**
         * Spring RabbitMQ (camel-spring-rabbitmq)
         * Send and receive messages from RabbitMQ using Spring RabbitMQ client.
         * 
         * Category: messaging
         * Since: 3.8
         * Maven coordinates: org.apache.camel:camel-spring-rabbitmq
         * 
         * Syntax: <code>spring-rabbitmq:exchangeName</code>
         * 
         * Path parameter: exchangeName (required)
         * The exchange name determines the exchange to which the produced
         * messages will be sent to. In the case of consumers, the exchange name
         * determines the exchange the queue will be bound to. Note: to use
         * default exchange then do not use empty name, but use default instead.
         * 
         * @param path exchangeName
         * @return the dsl builder
         */
        default SpringRabbitMQEndpointBuilder springRabbitmq(String path) {
            return SpringRabbitMQEndpointBuilderFactory.endpointBuilder("spring-rabbitmq", path);
        }
        /**
         * Spring RabbitMQ (camel-spring-rabbitmq)
         * Send and receive messages from RabbitMQ using Spring RabbitMQ client.
         * 
         * Category: messaging
         * Since: 3.8
         * Maven coordinates: org.apache.camel:camel-spring-rabbitmq
         * 
         * Syntax: <code>spring-rabbitmq:exchangeName</code>
         * 
         * Path parameter: exchangeName (required)
         * The exchange name determines the exchange to which the produced
         * messages will be sent to. In the case of consumers, the exchange name
         * determines the exchange the queue will be bound to. Note: to use
         * default exchange then do not use empty name, but use default instead.
         * 
         * @param componentName to use a custom component name for the endpoint
         * instead of the default name
         * @param path exchangeName
         * @return the dsl builder
         */
        default SpringRabbitMQEndpointBuilder springRabbitmq(
                String componentName,
                String path) {
            return SpringRabbitMQEndpointBuilderFactory.endpointBuilder(componentName, path);
        }
    }

    /**
     * The builder of headers' name for the Spring RabbitMQ component.
     */
    public static class SpringRabbitMQHeaderNameBuilder {
        /**
         * The internal instance of the builder used to access to all the
         * methods representing the name of headers.
         */
        private static final SpringRabbitMQHeaderNameBuilder INSTANCE = new SpringRabbitMQHeaderNameBuilder();

        /**
         * To override the endpoint configuration's routing key.
         * 
         * The option is a: {@code String} type.
         * 
         * Group: producer
         * 
         * @return the name of the header {@code
         * SpringRabbitmqRoutingOverrideKey}.
         */
        public String springRabbitmqRoutingOverrideKey() {
            return "CamelSpringRabbitmqRoutingOverrideKey";
        }

        /**
         * To override the endpoint configuration's exchange name.
         * 
         * The option is a: {@code String} type.
         * 
         * Group: producer
         * 
         * @return the name of the header {@code
         * SpringRabbitmqExchangeOverrideName}.
         */
        public String springRabbitmqExchangeOverrideName() {
            return "CamelSpringRabbitmqExchangeOverrideName";
        }

        /**
         * Whether the message was previously delivered and requeued.
         * 
         * The option is a: {@code Boolean} type.
         * 
         * Group: consumer
         * 
         * @return the name of the header {@code SpringRabbitmqRedelivered}.
         */
        public String springRabbitmqRedelivered() {
            return "CamelSpringRabbitmqRedelivered";
        }

        /**
         * Delivery tag for manual acknowledge mode.
         * 
         * The option is a: {@code long} type.
         * 
         * Group: consumer
         * 
         * @return the name of the header {@code SpringRabbitmqDeliveryTag}.
         */
        public String springRabbitmqDeliveryTag() {
            return "CamelSpringRabbitmqDeliveryTag";
        }

        /**
         * The exchange name that was used when publishing the message.
         * 
         * The option is a: {@code String} type.
         * 
         * Group: consumer
         * 
         * @return the name of the header {@code SpringRabbitmqExchangeName}.
         */
        public String springRabbitmqExchangeName() {
            return "CamelSpringRabbitmqExchangeName";
        }

        /**
         * The routing key that was used when publishing the message.
         * 
         * The option is a: {@code String} type.
         * 
         * Group: consumer
         * 
         * @return the name of the header {@code SpringRabbitmqRoutingKey}.
         */
        public String springRabbitmqRoutingKey() {
            return "CamelSpringRabbitmqRoutingKey";
        }

        /**
         * The message delivery mode.
         * 
         * The option is a: {@code MessageDeliveryMode} type.
         * 
         * Group: common
         * 
         * @return the name of the header {@code SpringRabbitmqDeliveryMode}.
         */
        public String springRabbitmqDeliveryMode() {
            return "CamelSpringRabbitmqDeliveryMode";
        }

        /**
         * Application-specific message type.
         * 
         * The option is a: {@code String} type.
         * 
         * Group: common
         * 
         * @return the name of the header {@code SpringRabbitmqType}.
         */
        public String springRabbitmqType() {
            return "CamelSpringRabbitmqType";
        }

        /**
         * The message content type.
         * 
         * The option is a: {@code String} type.
         * 
         * Group: common
         * 
         * @return the name of the header {@code SpringRabbitmqContentType}.
         */
        public String springRabbitmqContentType() {
            return "CamelSpringRabbitmqContentType";
        }

        /**
         * The message content length.
         * 
         * The option is a: {@code long} type.
         * 
         * Group: common
         * 
         * @return the name of the header {@code SpringRabbitmqContentLength}.
         */
        public String springRabbitmqContentLength() {
            return "CamelSpringRabbitmqContentLength";
        }

        /**
         * Content encoding used by applications.
         * 
         * The option is a: {@code String} type.
         * 
         * Group: common
         * 
         * @return the name of the header {@code SpringRabbitmqContentEncoding}.
         */
        public String springRabbitmqContentEncoding() {
            return "CamelSpringRabbitmqContentEncoding";
        }

        /**
         * Arbitrary message id.
         * 
         * The option is a: {@code String} type.
         * 
         * Group: common
         * 
         * @return the name of the header {@code SpringRabbitmqMessageId}.
         */
        public String springRabbitmqMessageId() {
            return "CamelSpringRabbitmqMessageId";
        }

        /**
         * Identifier to correlate RPC responses with requests.
         * 
         * The option is a: {@code String} type.
         * 
         * Group: common
         * 
         * @return the name of the header {@code SpringRabbitmqCorrelationId}.
         */
        public String springRabbitmqCorrelationId() {
            return "CamelSpringRabbitmqCorrelationId";
        }

        /**
         * Commonly used to name a callback queue.
         * 
         * The option is a: {@code String} type.
         * 
         * Group: common
         * 
         * @return the name of the header {@code SpringRabbitmqReplyTo}.
         */
        public String springRabbitmqReplyTo() {
            return "CamelSpringRabbitmqReplyTo";
        }

        /**
         * Per-message TTL.
         * 
         * The option is a: {@code String} type.
         * 
         * Group: common
         * 
         * @return the name of the header {@code SpringRabbitmqExpiration}.
         */
        public String springRabbitmqExpiration() {
            return "CamelSpringRabbitmqExpiration";
        }

        /**
         * Application-provided timestamp.
         * 
         * The option is a: {@code Date} type.
         * 
         * Group: common
         * 
         * @return the name of the header {@code SpringRabbitmqTimestamp}.
         */
        public String springRabbitmqTimestamp() {
            return "CamelSpringRabbitmqTimestamp";
        }

        /**
         * Validated user id.
         * 
         * The option is a: {@code String} type.
         * 
         * Group: common
         * 
         * @return the name of the header {@code SpringRabbitmqUserId}.
         */
        public String springRabbitmqUserId() {
            return "CamelSpringRabbitmqUserId";
        }

        /**
         * The application name.
         * 
         * The option is a: {@code String} type.
         * 
         * Group: common
         * 
         * @return the name of the header {@code SpringRabbitmqAppId}.
         */
        public String springRabbitmqAppId() {
            return "CamelSpringRabbitmqAppId";
        }

        /**
         * The message priority.
         * 
         * The option is a: {@code Integer} type.
         * 
         * Group: common
         * 
         * @return the name of the header {@code SpringRabbitmqPriority}.
         */
        public String springRabbitmqPriority() {
            return "CamelSpringRabbitmqPriority";
        }

        /**
         * The cluster id.
         * 
         * The option is a: {@code String} type.
         * 
         * Group: common
         * 
         * @return the name of the header {@code SpringRabbitmqClusterId}.
         */
        public String springRabbitmqClusterId() {
            return "CamelSpringRabbitmqClusterId";
        }
    }
    static SpringRabbitMQEndpointBuilder endpointBuilder(
            String componentName,
            String path) {
        class SpringRabbitMQEndpointBuilderImpl extends AbstractEndpointBuilder implements SpringRabbitMQEndpointBuilder, AdvancedSpringRabbitMQEndpointBuilder {
            public SpringRabbitMQEndpointBuilderImpl(String path) {
                super(componentName, path);
            }
        }
        return new SpringRabbitMQEndpointBuilderImpl(path);
    }
}