/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.apache.camel.builder.endpoint.dsl;

import java.util.*;
import java.util.Map;
import java.util.concurrent.*;
import java.util.function.*;
import java.util.stream.*;
import javax.annotation.processing.Generated;
import org.apache.camel.builder.EndpointConsumerBuilder;
import org.apache.camel.builder.EndpointProducerBuilder;
import org.apache.camel.builder.endpoint.AbstractEndpointBuilder;

/**
 * Expose HTTP endpoints using Jetty 11.
 * 
 * Generated by camel build tools - do NOT edit this file!
 */
@Generated("org.apache.camel.maven.packaging.EndpointDslMojo")
public interface JettyHttp11EndpointBuilderFactory {


    /**
     * Builder for endpoint for the Jetty component.
     */
    public interface JettyHttp11EndpointBuilder
            extends
                EndpointConsumerBuilder {
        default AdvancedJettyHttp11EndpointBuilder advanced() {
            return (AdvancedJettyHttp11EndpointBuilder) this;
        }
        /**
         * If this option is false the Servlet will disable the HTTP streaming
         * and set the content-length header on the response.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: true
         * Group: consumer
         * 
         * @param chunked the value to set
         * @return the dsl builder
         */
        default JettyHttp11EndpointBuilder chunked(boolean chunked) {
            doSetProperty("chunked", chunked);
            return this;
        }
        /**
         * If this option is false the Servlet will disable the HTTP streaming
         * and set the content-length header on the response.
         * 
         * The option will be converted to a &lt;code&gt;boolean&lt;/code&gt;
         * type.
         * 
         * Default: true
         * Group: consumer
         * 
         * @param chunked the value to set
         * @return the dsl builder
         */
        default JettyHttp11EndpointBuilder chunked(String chunked) {
            doSetProperty("chunked", chunked);
            return this;
        }
        /**
         * Determines whether or not the raw input stream from Servlet is cached
         * or not (Camel will read the stream into a in memory/overflow to file,
         * Stream caching) cache. By default Camel will cache the Servlet input
         * stream to support reading it multiple times to ensure it Camel can
         * retrieve all data from the stream. However you can set this option to
         * true when you for example need to access the raw stream, such as
         * streaming it directly to a file or other persistent store.
         * DefaultHttpBinding will copy the request input stream into a stream
         * cache and put it into message body if this option is false to support
         * reading the stream multiple times. If you use Servlet to bridge/proxy
         * an endpoint then consider enabling this option to improve
         * performance, in case you do not need to read the message payload
         * multiple times. The http producer will by default cache the response
         * body stream. If setting this option to true, then the producers will
         * not cache the response body stream but use the response stream as-is
         * as the message body.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: false
         * Group: common
         * 
         * @param disableStreamCache the value to set
         * @return the dsl builder
         */
        default JettyHttp11EndpointBuilder disableStreamCache(
                boolean disableStreamCache) {
            doSetProperty("disableStreamCache", disableStreamCache);
            return this;
        }
        /**
         * Determines whether or not the raw input stream from Servlet is cached
         * or not (Camel will read the stream into a in memory/overflow to file,
         * Stream caching) cache. By default Camel will cache the Servlet input
         * stream to support reading it multiple times to ensure it Camel can
         * retrieve all data from the stream. However you can set this option to
         * true when you for example need to access the raw stream, such as
         * streaming it directly to a file or other persistent store.
         * DefaultHttpBinding will copy the request input stream into a stream
         * cache and put it into message body if this option is false to support
         * reading the stream multiple times. If you use Servlet to bridge/proxy
         * an endpoint then consider enabling this option to improve
         * performance, in case you do not need to read the message payload
         * multiple times. The http producer will by default cache the response
         * body stream. If setting this option to true, then the producers will
         * not cache the response body stream but use the response stream as-is
         * as the message body.
         * 
         * The option will be converted to a &lt;code&gt;boolean&lt;/code&gt;
         * type.
         * 
         * Default: false
         * Group: common
         * 
         * @param disableStreamCache the value to set
         * @return the dsl builder
         */
        default JettyHttp11EndpointBuilder disableStreamCache(
                String disableStreamCache) {
            doSetProperty("disableStreamCache", disableStreamCache);
            return this;
        }
        /**
         * If enabled and an Exchange failed processing on the consumer side,
         * and if the caused Exception was send back serialized in the response
         * as a application/x-java-serialized-object content type. On the
         * producer side the exception will be deserialized and thrown as is,
         * instead of the HttpOperationFailedException. The caused exception is
         * required to be serialized. This is by default turned off. If you
         * enable this then be aware that Java will deserialize the incoming
         * data from the request to Java and that can be a potential security
         * risk.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: false
         * Group: common
         * 
         * @param transferException the value to set
         * @return the dsl builder
         */
        default JettyHttp11EndpointBuilder transferException(
                boolean transferException) {
            doSetProperty("transferException", transferException);
            return this;
        }
        /**
         * If enabled and an Exchange failed processing on the consumer side,
         * and if the caused Exception was send back serialized in the response
         * as a application/x-java-serialized-object content type. On the
         * producer side the exception will be deserialized and thrown as is,
         * instead of the HttpOperationFailedException. The caused exception is
         * required to be serialized. This is by default turned off. If you
         * enable this then be aware that Java will deserialize the incoming
         * data from the request to Java and that can be a potential security
         * risk.
         * 
         * The option will be converted to a &lt;code&gt;boolean&lt;/code&gt;
         * type.
         * 
         * Default: false
         * Group: common
         * 
         * @param transferException the value to set
         * @return the dsl builder
         */
        default JettyHttp11EndpointBuilder transferException(
                String transferException) {
            doSetProperty("transferException", transferException);
            return this;
        }
        /**
         * Configure the consumer to work in async mode.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: false
         * Group: consumer
         * 
         * @param async the value to set
         * @return the dsl builder
         */
        default JettyHttp11EndpointBuilder async(boolean async) {
            doSetProperty("async", async);
            return this;
        }
        /**
         * Configure the consumer to work in async mode.
         * 
         * The option will be converted to a &lt;code&gt;boolean&lt;/code&gt;
         * type.
         * 
         * Default: false
         * Group: consumer
         * 
         * @param async the value to set
         * @return the dsl builder
         */
        default JettyHttp11EndpointBuilder async(String async) {
            doSetProperty("async", async);
            return this;
        }
        /**
         * Allows to set a timeout in millis when using Jetty as consumer
         * (server). By default Jetty uses 30000. You can use a value of = 0 to
         * never expire. If a timeout occurs then the request will be expired
         * and Jetty will return back a http error 503 to the client. This
         * option is only in use when using Jetty with the Asynchronous Routing
         * Engine.
         * 
         * The option is a: &lt;code&gt;java.lang.Long&lt;/code&gt; type.
         * 
         * Default: 30000
         * Group: consumer
         * 
         * @param continuationTimeout the value to set
         * @return the dsl builder
         */
        default JettyHttp11EndpointBuilder continuationTimeout(
                Long continuationTimeout) {
            doSetProperty("continuationTimeout", continuationTimeout);
            return this;
        }
        /**
         * Allows to set a timeout in millis when using Jetty as consumer
         * (server). By default Jetty uses 30000. You can use a value of = 0 to
         * never expire. If a timeout occurs then the request will be expired
         * and Jetty will return back a http error 503 to the client. This
         * option is only in use when using Jetty with the Asynchronous Routing
         * Engine.
         * 
         * The option will be converted to a
         * &lt;code&gt;java.lang.Long&lt;/code&gt; type.
         * 
         * Default: 30000
         * Group: consumer
         * 
         * @param continuationTimeout the value to set
         * @return the dsl builder
         */
        default JettyHttp11EndpointBuilder continuationTimeout(
                String continuationTimeout) {
            doSetProperty("continuationTimeout", continuationTimeout);
            return this;
        }
        /**
         * If the option is true, Jetty server will setup the CrossOriginFilter
         * which supports the CORS out of box.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: false
         * Group: consumer
         * 
         * @param enableCORS the value to set
         * @return the dsl builder
         */
        default JettyHttp11EndpointBuilder enableCORS(boolean enableCORS) {
            doSetProperty("enableCORS", enableCORS);
            return this;
        }
        /**
         * If the option is true, Jetty server will setup the CrossOriginFilter
         * which supports the CORS out of box.
         * 
         * The option will be converted to a &lt;code&gt;boolean&lt;/code&gt;
         * type.
         * 
         * Default: false
         * Group: consumer
         * 
         * @param enableCORS the value to set
         * @return the dsl builder
         */
        default JettyHttp11EndpointBuilder enableCORS(String enableCORS) {
            doSetProperty("enableCORS", enableCORS);
            return this;
        }
        /**
         * If this option is true, Jetty JMX support will be enabled for this
         * endpoint. See Jetty JMX support for more details.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: false
         * Group: consumer
         * 
         * @param enableJmx the value to set
         * @return the dsl builder
         */
        default JettyHttp11EndpointBuilder enableJmx(boolean enableJmx) {
            doSetProperty("enableJmx", enableJmx);
            return this;
        }
        /**
         * If this option is true, Jetty JMX support will be enabled for this
         * endpoint. See Jetty JMX support for more details.
         * 
         * The option will be converted to a &lt;code&gt;boolean&lt;/code&gt;
         * type.
         * 
         * Default: false
         * Group: consumer
         * 
         * @param enableJmx the value to set
         * @return the dsl builder
         */
        default JettyHttp11EndpointBuilder enableJmx(String enableJmx) {
            doSetProperty("enableJmx", enableJmx);
            return this;
        }
        /**
         * Whether org.apache.camel.component.jetty.MultiPartFilter is enabled
         * or not. You should set this value to false when bridging endpoints,
         * to ensure multipart requests is proxied/bridged as well.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: false
         * Group: consumer
         * 
         * @param enableMultipartFilter the value to set
         * @return the dsl builder
         */
        default JettyHttp11EndpointBuilder enableMultipartFilter(
                boolean enableMultipartFilter) {
            doSetProperty("enableMultipartFilter", enableMultipartFilter);
            return this;
        }
        /**
         * Whether org.apache.camel.component.jetty.MultiPartFilter is enabled
         * or not. You should set this value to false when bridging endpoints,
         * to ensure multipart requests is proxied/bridged as well.
         * 
         * The option will be converted to a &lt;code&gt;boolean&lt;/code&gt;
         * type.
         * 
         * Default: false
         * Group: consumer
         * 
         * @param enableMultipartFilter the value to set
         * @return the dsl builder
         */
        default JettyHttp11EndpointBuilder enableMultipartFilter(
                String enableMultipartFilter) {
            doSetProperty("enableMultipartFilter", enableMultipartFilter);
            return this;
        }
        /**
         * Used to only allow consuming if the HttpMethod matches, such as
         * GET/POST/PUT etc. Multiple methods can be specified separated by
         * comma.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: consumer
         * 
         * @param httpMethodRestrict the value to set
         * @return the dsl builder
         */
        default JettyHttp11EndpointBuilder httpMethodRestrict(
                String httpMethodRestrict) {
            doSetProperty("httpMethodRestrict", httpMethodRestrict);
            return this;
        }
        /**
         * Whether or not the consumer should try to find a target consumer by
         * matching the URI prefix if no exact match is found.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: false
         * Group: consumer
         * 
         * @param matchOnUriPrefix the value to set
         * @return the dsl builder
         */
        default JettyHttp11EndpointBuilder matchOnUriPrefix(
                boolean matchOnUriPrefix) {
            doSetProperty("matchOnUriPrefix", matchOnUriPrefix);
            return this;
        }
        /**
         * Whether or not the consumer should try to find a target consumer by
         * matching the URI prefix if no exact match is found.
         * 
         * The option will be converted to a &lt;code&gt;boolean&lt;/code&gt;
         * type.
         * 
         * Default: false
         * Group: consumer
         * 
         * @param matchOnUriPrefix the value to set
         * @return the dsl builder
         */
        default JettyHttp11EndpointBuilder matchOnUriPrefix(
                String matchOnUriPrefix) {
            doSetProperty("matchOnUriPrefix", matchOnUriPrefix);
            return this;
        }
        /**
         * If enabled and an Exchange failed processing on the consumer side the
         * response's body won't contain the exception's stack trace.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: false
         * Group: consumer
         * 
         * @param muteException the value to set
         * @return the dsl builder
         */
        default JettyHttp11EndpointBuilder muteException(boolean muteException) {
            doSetProperty("muteException", muteException);
            return this;
        }
        /**
         * If enabled and an Exchange failed processing on the consumer side the
         * response's body won't contain the exception's stack trace.
         * 
         * The option will be converted to a &lt;code&gt;boolean&lt;/code&gt;
         * type.
         * 
         * Default: false
         * Group: consumer
         * 
         * @param muteException the value to set
         * @return the dsl builder
         */
        default JettyHttp11EndpointBuilder muteException(String muteException) {
            doSetProperty("muteException", muteException);
            return this;
        }
        /**
         * To use a custom buffer size on the jakarta.servlet.ServletResponse.
         * 
         * The option is a: &lt;code&gt;java.lang.Integer&lt;/code&gt; type.
         * 
         * Group: consumer
         * 
         * @param responseBufferSize the value to set
         * @return the dsl builder
         */
        default JettyHttp11EndpointBuilder responseBufferSize(
                Integer responseBufferSize) {
            doSetProperty("responseBufferSize", responseBufferSize);
            return this;
        }
        /**
         * To use a custom buffer size on the jakarta.servlet.ServletResponse.
         * 
         * The option will be converted to a
         * &lt;code&gt;java.lang.Integer&lt;/code&gt; type.
         * 
         * Group: consumer
         * 
         * @param responseBufferSize the value to set
         * @return the dsl builder
         */
        default JettyHttp11EndpointBuilder responseBufferSize(
                String responseBufferSize) {
            doSetProperty("responseBufferSize", responseBufferSize);
            return this;
        }
        /**
         * If the option is true, jetty server will send the date header to the
         * client which sends the request. NOTE please make sure there is no any
         * other camel-jetty endpoint is share the same port, otherwise this
         * option may not work as expected.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: false
         * Group: consumer
         * 
         * @param sendDateHeader the value to set
         * @return the dsl builder
         */
        default JettyHttp11EndpointBuilder sendDateHeader(boolean sendDateHeader) {
            doSetProperty("sendDateHeader", sendDateHeader);
            return this;
        }
        /**
         * If the option is true, jetty server will send the date header to the
         * client which sends the request. NOTE please make sure there is no any
         * other camel-jetty endpoint is share the same port, otherwise this
         * option may not work as expected.
         * 
         * The option will be converted to a &lt;code&gt;boolean&lt;/code&gt;
         * type.
         * 
         * Default: false
         * Group: consumer
         * 
         * @param sendDateHeader the value to set
         * @return the dsl builder
         */
        default JettyHttp11EndpointBuilder sendDateHeader(String sendDateHeader) {
            doSetProperty("sendDateHeader", sendDateHeader);
            return this;
        }
        /**
         * If the option is true, jetty will send the server header with the
         * jetty version information to the client which sends the request. NOTE
         * please make sure there is no any other camel-jetty endpoint is share
         * the same port, otherwise this option may not work as expected.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: true
         * Group: consumer
         * 
         * @param sendServerVersion the value to set
         * @return the dsl builder
         */
        default JettyHttp11EndpointBuilder sendServerVersion(
                boolean sendServerVersion) {
            doSetProperty("sendServerVersion", sendServerVersion);
            return this;
        }
        /**
         * If the option is true, jetty will send the server header with the
         * jetty version information to the client which sends the request. NOTE
         * please make sure there is no any other camel-jetty endpoint is share
         * the same port, otherwise this option may not work as expected.
         * 
         * The option will be converted to a &lt;code&gt;boolean&lt;/code&gt;
         * type.
         * 
         * Default: true
         * Group: consumer
         * 
         * @param sendServerVersion the value to set
         * @return the dsl builder
         */
        default JettyHttp11EndpointBuilder sendServerVersion(
                String sendServerVersion) {
            doSetProperty("sendServerVersion", sendServerVersion);
            return this;
        }
        /**
         * Specifies whether to enable the session manager on the server side of
         * Jetty.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: false
         * Group: consumer
         * 
         * @param sessionSupport the value to set
         * @return the dsl builder
         */
        default JettyHttp11EndpointBuilder sessionSupport(boolean sessionSupport) {
            doSetProperty("sessionSupport", sessionSupport);
            return this;
        }
        /**
         * Specifies whether to enable the session manager on the server side of
         * Jetty.
         * 
         * The option will be converted to a &lt;code&gt;boolean&lt;/code&gt;
         * type.
         * 
         * Default: false
         * Group: consumer
         * 
         * @param sessionSupport the value to set
         * @return the dsl builder
         */
        default JettyHttp11EndpointBuilder sessionSupport(String sessionSupport) {
            doSetProperty("sessionSupport", sessionSupport);
            return this;
        }
        /**
         * Whether or not to use Jetty continuations for the Jetty Server.
         * 
         * The option is a: &lt;code&gt;java.lang.Boolean&lt;/code&gt; type.
         * 
         * Group: consumer
         * 
         * @param useContinuation the value to set
         * @return the dsl builder
         */
        default JettyHttp11EndpointBuilder useContinuation(
                Boolean useContinuation) {
            doSetProperty("useContinuation", useContinuation);
            return this;
        }
        /**
         * Whether or not to use Jetty continuations for the Jetty Server.
         * 
         * The option will be converted to a
         * &lt;code&gt;java.lang.Boolean&lt;/code&gt; type.
         * 
         * Group: consumer
         * 
         * @param useContinuation the value to set
         * @return the dsl builder
         */
        default JettyHttp11EndpointBuilder useContinuation(
                String useContinuation) {
            doSetProperty("useContinuation", useContinuation);
            return this;
        }
        /**
         * To configure security using SSLContextParameters.
         * 
         * The option is a:
         * &lt;code&gt;org.apache.camel.support.jsse.SSLContextParameters&lt;/code&gt; type.
         * 
         * Group: security
         * 
         * @param sslContextParameters the value to set
         * @return the dsl builder
         */
        default JettyHttp11EndpointBuilder sslContextParameters(
                org.apache.camel.support.jsse.SSLContextParameters sslContextParameters) {
            doSetProperty("sslContextParameters", sslContextParameters);
            return this;
        }
        /**
         * To configure security using SSLContextParameters.
         * 
         * The option will be converted to a
         * &lt;code&gt;org.apache.camel.support.jsse.SSLContextParameters&lt;/code&gt; type.
         * 
         * Group: security
         * 
         * @param sslContextParameters the value to set
         * @return the dsl builder
         */
        default JettyHttp11EndpointBuilder sslContextParameters(
                String sslContextParameters) {
            doSetProperty("sslContextParameters", sslContextParameters);
            return this;
        }
    }

    /**
     * Advanced builder for endpoint for the Jetty component.
     */
    public interface AdvancedJettyHttp11EndpointBuilder
            extends
                EndpointConsumerBuilder {
        default JettyHttp11EndpointBuilder basic() {
            return (JettyHttp11EndpointBuilder) this;
        }
        /**
         * To use a custom HeaderFilterStrategy to filter header to and from
         * Camel message.
         * 
         * The option is a:
         * &lt;code&gt;org.apache.camel.spi.HeaderFilterStrategy&lt;/code&gt;
         * type.
         * 
         * Group: common (advanced)
         * 
         * @param headerFilterStrategy the value to set
         * @return the dsl builder
         */
        default AdvancedJettyHttp11EndpointBuilder headerFilterStrategy(
                org.apache.camel.spi.HeaderFilterStrategy headerFilterStrategy) {
            doSetProperty("headerFilterStrategy", headerFilterStrategy);
            return this;
        }
        /**
         * To use a custom HeaderFilterStrategy to filter header to and from
         * Camel message.
         * 
         * The option will be converted to a
         * &lt;code&gt;org.apache.camel.spi.HeaderFilterStrategy&lt;/code&gt;
         * type.
         * 
         * Group: common (advanced)
         * 
         * @param headerFilterStrategy the value to set
         * @return the dsl builder
         */
        default AdvancedJettyHttp11EndpointBuilder headerFilterStrategy(
                String headerFilterStrategy) {
            doSetProperty("headerFilterStrategy", headerFilterStrategy);
            return this;
        }
        /**
         * To use a custom HttpBinding to control the mapping between Camel
         * message and HttpClient.
         * 
         * The option is a:
         * &lt;code&gt;org.apache.camel.http.common.HttpBinding&lt;/code&gt;
         * type.
         * 
         * Group: common (advanced)
         * 
         * @param httpBinding the value to set
         * @return the dsl builder
         */
        default AdvancedJettyHttp11EndpointBuilder httpBinding(
                org.apache.camel.http.common.HttpBinding httpBinding) {
            doSetProperty("httpBinding", httpBinding);
            return this;
        }
        /**
         * To use a custom HttpBinding to control the mapping between Camel
         * message and HttpClient.
         * 
         * The option will be converted to a
         * &lt;code&gt;org.apache.camel.http.common.HttpBinding&lt;/code&gt;
         * type.
         * 
         * Group: common (advanced)
         * 
         * @param httpBinding the value to set
         * @return the dsl builder
         */
        default AdvancedJettyHttp11EndpointBuilder httpBinding(
                String httpBinding) {
            doSetProperty("httpBinding", httpBinding);
            return this;
        }
        /**
         * Allows for bridging the consumer to the Camel routing Error Handler,
         * which mean any exceptions occurred while the consumer is trying to
         * pickup incoming messages, or the likes, will now be processed as a
         * message and handled by the routing Error Handler. By default the
         * consumer will use the org.apache.camel.spi.ExceptionHandler to deal
         * with exceptions, that will be logged at WARN or ERROR level and
         * ignored.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: false
         * Group: consumer (advanced)
         * 
         * @param bridgeErrorHandler the value to set
         * @return the dsl builder
         */
        default AdvancedJettyHttp11EndpointBuilder bridgeErrorHandler(
                boolean bridgeErrorHandler) {
            doSetProperty("bridgeErrorHandler", bridgeErrorHandler);
            return this;
        }
        /**
         * Allows for bridging the consumer to the Camel routing Error Handler,
         * which mean any exceptions occurred while the consumer is trying to
         * pickup incoming messages, or the likes, will now be processed as a
         * message and handled by the routing Error Handler. By default the
         * consumer will use the org.apache.camel.spi.ExceptionHandler to deal
         * with exceptions, that will be logged at WARN or ERROR level and
         * ignored.
         * 
         * The option will be converted to a &lt;code&gt;boolean&lt;/code&gt;
         * type.
         * 
         * Default: false
         * Group: consumer (advanced)
         * 
         * @param bridgeErrorHandler the value to set
         * @return the dsl builder
         */
        default AdvancedJettyHttp11EndpointBuilder bridgeErrorHandler(
                String bridgeErrorHandler) {
            doSetProperty("bridgeErrorHandler", bridgeErrorHandler);
            return this;
        }
        /**
         * Whether to eager check whether the HTTP requests has content if the
         * content-length header is 0 or not present. This can be turned on in
         * case HTTP clients do not send streamed data.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: false
         * Group: consumer (advanced)
         * 
         * @param eagerCheckContentAvailable the value to set
         * @return the dsl builder
         */
        default AdvancedJettyHttp11EndpointBuilder eagerCheckContentAvailable(
                boolean eagerCheckContentAvailable) {
            doSetProperty("eagerCheckContentAvailable", eagerCheckContentAvailable);
            return this;
        }
        /**
         * Whether to eager check whether the HTTP requests has content if the
         * content-length header is 0 or not present. This can be turned on in
         * case HTTP clients do not send streamed data.
         * 
         * The option will be converted to a &lt;code&gt;boolean&lt;/code&gt;
         * type.
         * 
         * Default: false
         * Group: consumer (advanced)
         * 
         * @param eagerCheckContentAvailable the value to set
         * @return the dsl builder
         */
        default AdvancedJettyHttp11EndpointBuilder eagerCheckContentAvailable(
                String eagerCheckContentAvailable) {
            doSetProperty("eagerCheckContentAvailable", eagerCheckContentAvailable);
            return this;
        }
        /**
         * To let the consumer use a custom ExceptionHandler. Notice if the
         * option bridgeErrorHandler is enabled then this option is not in use.
         * By default the consumer will deal with exceptions, that will be
         * logged at WARN or ERROR level and ignored.
         * 
         * The option is a:
         * &lt;code&gt;org.apache.camel.spi.ExceptionHandler&lt;/code&gt; type.
         * 
         * Group: consumer (advanced)
         * 
         * @param exceptionHandler the value to set
         * @return the dsl builder
         */
        default AdvancedJettyHttp11EndpointBuilder exceptionHandler(
                org.apache.camel.spi.ExceptionHandler exceptionHandler) {
            doSetProperty("exceptionHandler", exceptionHandler);
            return this;
        }
        /**
         * To let the consumer use a custom ExceptionHandler. Notice if the
         * option bridgeErrorHandler is enabled then this option is not in use.
         * By default the consumer will deal with exceptions, that will be
         * logged at WARN or ERROR level and ignored.
         * 
         * The option will be converted to a
         * &lt;code&gt;org.apache.camel.spi.ExceptionHandler&lt;/code&gt; type.
         * 
         * Group: consumer (advanced)
         * 
         * @param exceptionHandler the value to set
         * @return the dsl builder
         */
        default AdvancedJettyHttp11EndpointBuilder exceptionHandler(
                String exceptionHandler) {
            doSetProperty("exceptionHandler", exceptionHandler);
            return this;
        }
        /**
         * Sets the exchange pattern when the consumer creates an exchange.
         * 
         * The option is a:
         * &lt;code&gt;org.apache.camel.ExchangePattern&lt;/code&gt; type.
         * 
         * Group: consumer (advanced)
         * 
         * @param exchangePattern the value to set
         * @return the dsl builder
         */
        default AdvancedJettyHttp11EndpointBuilder exchangePattern(
                org.apache.camel.ExchangePattern exchangePattern) {
            doSetProperty("exchangePattern", exchangePattern);
            return this;
        }
        /**
         * Sets the exchange pattern when the consumer creates an exchange.
         * 
         * The option will be converted to a
         * &lt;code&gt;org.apache.camel.ExchangePattern&lt;/code&gt; type.
         * 
         * Group: consumer (advanced)
         * 
         * @param exchangePattern the value to set
         * @return the dsl builder
         */
        default AdvancedJettyHttp11EndpointBuilder exchangePattern(
                String exchangePattern) {
            doSetProperty("exchangePattern", exchangePattern);
            return this;
        }
        /**
         * Configuration of the filter init parameters. These parameters will be
         * applied to the filter list before starting the jetty server.
         * 
         * The option is a: &lt;code&gt;java.util.Map&amp;lt;java.lang.String,
         * java.lang.String&amp;gt;&lt;/code&gt; type.
         * The option is multivalued, and you can use the
         * filterInitParameters(String, Object) method to add a value (call the
         * method multiple times to set more values).
         * 
         * Group: consumer (advanced)
         * 
         * @param key the option key
         * @param value the option value
         * @return the dsl builder
         */
        default AdvancedJettyHttp11EndpointBuilder filterInitParameters(
                String key,
                Object value) {
            doSetMultiValueProperty("filterInitParameters", "filter." + key, value);
            return this;
        }
        /**
         * Configuration of the filter init parameters. These parameters will be
         * applied to the filter list before starting the jetty server.
         * 
         * The option is a: &lt;code&gt;java.util.Map&amp;lt;java.lang.String,
         * java.lang.String&amp;gt;&lt;/code&gt; type.
         * The option is multivalued, and you can use the
         * filterInitParameters(String, Object) method to add a value (call the
         * method multiple times to set more values).
         * 
         * Group: consumer (advanced)
         * 
         * @param values the values
         * @return the dsl builder
         */
        default AdvancedJettyHttp11EndpointBuilder filterInitParameters(
                Map values) {
            doSetMultiValueProperties("filterInitParameters", "filter.", values);
            return this;
        }
        /**
         * Allows using a custom filters which is putted into a list and can be
         * find in the Registry. Multiple values can be separated by comma.
         * 
         * The option is a:
         * &lt;code&gt;java.util.List&amp;lt;jakarta.servlet.Filter&amp;gt;&lt;/code&gt; type.
         * 
         * Group: consumer (advanced)
         * 
         * @param filters the value to set
         * @return the dsl builder
         */
        default AdvancedJettyHttp11EndpointBuilder filters(
                List<jakarta.servlet.Filter> filters) {
            doSetProperty("filters", filters);
            return this;
        }
        /**
         * Allows using a custom filters which is putted into a list and can be
         * find in the Registry. Multiple values can be separated by comma.
         * 
         * The option will be converted to a
         * &lt;code&gt;java.util.List&amp;lt;jakarta.servlet.Filter&amp;gt;&lt;/code&gt; type.
         * 
         * Group: consumer (advanced)
         * 
         * @param filters the value to set
         * @return the dsl builder
         */
        default AdvancedJettyHttp11EndpointBuilder filters(String filters) {
            doSetProperty("filters", filters);
            return this;
        }
        /**
         * Specifies a comma-delimited set of Handler instances to lookup in
         * your Registry. These handlers are added to the Jetty servlet context
         * (for example, to add security). Important: You can not use different
         * handlers with different Jetty endpoints using the same port number.
         * The handlers is associated to the port number. If you need different
         * handlers, then use different port numbers.
         * 
         * The option is a:
         * &lt;code&gt;java.util.List&amp;lt;org.eclipse.jetty.server.Handler&amp;gt;&lt;/code&gt; type.
         * 
         * Group: consumer (advanced)
         * 
         * @param handlers the value to set
         * @return the dsl builder
         */
        default AdvancedJettyHttp11EndpointBuilder handlers(
                List<org.eclipse.jetty.server.Handler> handlers) {
            doSetProperty("handlers", handlers);
            return this;
        }
        /**
         * Specifies a comma-delimited set of Handler instances to lookup in
         * your Registry. These handlers are added to the Jetty servlet context
         * (for example, to add security). Important: You can not use different
         * handlers with different Jetty endpoints using the same port number.
         * The handlers is associated to the port number. If you need different
         * handlers, then use different port numbers.
         * 
         * The option will be converted to a
         * &lt;code&gt;java.util.List&amp;lt;org.eclipse.jetty.server.Handler&amp;gt;&lt;/code&gt; type.
         * 
         * Group: consumer (advanced)
         * 
         * @param handlers the value to set
         * @return the dsl builder
         */
        default AdvancedJettyHttp11EndpointBuilder handlers(String handlers) {
            doSetProperty("handlers", handlers);
            return this;
        }
        /**
         * If this option is true then IN exchange Body of the exchange will be
         * mapped to HTTP body. Setting this to false will avoid the HTTP
         * mapping.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: true
         * Group: consumer (advanced)
         * 
         * @param mapHttpMessageBody the value to set
         * @return the dsl builder
         */
        default AdvancedJettyHttp11EndpointBuilder mapHttpMessageBody(
                boolean mapHttpMessageBody) {
            doSetProperty("mapHttpMessageBody", mapHttpMessageBody);
            return this;
        }
        /**
         * If this option is true then IN exchange Body of the exchange will be
         * mapped to HTTP body. Setting this to false will avoid the HTTP
         * mapping.
         * 
         * The option will be converted to a &lt;code&gt;boolean&lt;/code&gt;
         * type.
         * 
         * Default: true
         * Group: consumer (advanced)
         * 
         * @param mapHttpMessageBody the value to set
         * @return the dsl builder
         */
        default AdvancedJettyHttp11EndpointBuilder mapHttpMessageBody(
                String mapHttpMessageBody) {
            doSetProperty("mapHttpMessageBody", mapHttpMessageBody);
            return this;
        }
        /**
         * If this option is true then IN exchange Form Encoded body of the
         * exchange will be mapped to HTTP. Setting this to false will avoid the
         * HTTP Form Encoded body mapping.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: true
         * Group: consumer (advanced)
         * 
         * @param mapHttpMessageFormUrlEncodedBody the value to set
         * @return the dsl builder
         */
        default AdvancedJettyHttp11EndpointBuilder mapHttpMessageFormUrlEncodedBody(
                boolean mapHttpMessageFormUrlEncodedBody) {
            doSetProperty("mapHttpMessageFormUrlEncodedBody", mapHttpMessageFormUrlEncodedBody);
            return this;
        }
        /**
         * If this option is true then IN exchange Form Encoded body of the
         * exchange will be mapped to HTTP. Setting this to false will avoid the
         * HTTP Form Encoded body mapping.
         * 
         * The option will be converted to a &lt;code&gt;boolean&lt;/code&gt;
         * type.
         * 
         * Default: true
         * Group: consumer (advanced)
         * 
         * @param mapHttpMessageFormUrlEncodedBody the value to set
         * @return the dsl builder
         */
        default AdvancedJettyHttp11EndpointBuilder mapHttpMessageFormUrlEncodedBody(
                String mapHttpMessageFormUrlEncodedBody) {
            doSetProperty("mapHttpMessageFormUrlEncodedBody", mapHttpMessageFormUrlEncodedBody);
            return this;
        }
        /**
         * If this option is true then IN exchange Headers of the exchange will
         * be mapped to HTTP headers. Setting this to false will avoid the HTTP
         * Headers mapping.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: true
         * Group: consumer (advanced)
         * 
         * @param mapHttpMessageHeaders the value to set
         * @return the dsl builder
         */
        default AdvancedJettyHttp11EndpointBuilder mapHttpMessageHeaders(
                boolean mapHttpMessageHeaders) {
            doSetProperty("mapHttpMessageHeaders", mapHttpMessageHeaders);
            return this;
        }
        /**
         * If this option is true then IN exchange Headers of the exchange will
         * be mapped to HTTP headers. Setting this to false will avoid the HTTP
         * Headers mapping.
         * 
         * The option will be converted to a &lt;code&gt;boolean&lt;/code&gt;
         * type.
         * 
         * Default: true
         * Group: consumer (advanced)
         * 
         * @param mapHttpMessageHeaders the value to set
         * @return the dsl builder
         */
        default AdvancedJettyHttp11EndpointBuilder mapHttpMessageHeaders(
                String mapHttpMessageHeaders) {
            doSetProperty("mapHttpMessageHeaders", mapHttpMessageHeaders);
            return this;
        }
        /**
         * Allows using a custom multipart filter. Note: setting
         * multipartFilterRef forces the value of enableMultipartFilter to true.
         * 
         * The option is a: &lt;code&gt;jakarta.servlet.Filter&lt;/code&gt;
         * type.
         * 
         * Group: consumer (advanced)
         * 
         * @param multipartFilter the value to set
         * @return the dsl builder
         */
        default AdvancedJettyHttp11EndpointBuilder multipartFilter(
                jakarta.servlet.Filter multipartFilter) {
            doSetProperty("multipartFilter", multipartFilter);
            return this;
        }
        /**
         * Allows using a custom multipart filter. Note: setting
         * multipartFilterRef forces the value of enableMultipartFilter to true.
         * 
         * The option will be converted to a
         * &lt;code&gt;jakarta.servlet.Filter&lt;/code&gt; type.
         * 
         * Group: consumer (advanced)
         * 
         * @param multipartFilter the value to set
         * @return the dsl builder
         */
        default AdvancedJettyHttp11EndpointBuilder multipartFilter(
                String multipartFilter) {
            doSetProperty("multipartFilter", multipartFilter);
            return this;
        }
        /**
         * Specifies whether to enable HTTP OPTIONS for this Servlet consumer.
         * By default OPTIONS is turned off.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: false
         * Group: consumer (advanced)
         * 
         * @param optionsEnabled the value to set
         * @return the dsl builder
         */
        default AdvancedJettyHttp11EndpointBuilder optionsEnabled(
                boolean optionsEnabled) {
            doSetProperty("optionsEnabled", optionsEnabled);
            return this;
        }
        /**
         * Specifies whether to enable HTTP OPTIONS for this Servlet consumer.
         * By default OPTIONS is turned off.
         * 
         * The option will be converted to a &lt;code&gt;boolean&lt;/code&gt;
         * type.
         * 
         * Default: false
         * Group: consumer (advanced)
         * 
         * @param optionsEnabled the value to set
         * @return the dsl builder
         */
        default AdvancedJettyHttp11EndpointBuilder optionsEnabled(
                String optionsEnabled) {
            doSetProperty("optionsEnabled", optionsEnabled);
            return this;
        }
        /**
         * Specifies whether to enable HTTP TRACE for this Servlet consumer. By
         * default TRACE is turned off.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: false
         * Group: consumer (advanced)
         * 
         * @param traceEnabled the value to set
         * @return the dsl builder
         */
        default AdvancedJettyHttp11EndpointBuilder traceEnabled(
                boolean traceEnabled) {
            doSetProperty("traceEnabled", traceEnabled);
            return this;
        }
        /**
         * Specifies whether to enable HTTP TRACE for this Servlet consumer. By
         * default TRACE is turned off.
         * 
         * The option will be converted to a &lt;code&gt;boolean&lt;/code&gt;
         * type.
         * 
         * Default: false
         * Group: consumer (advanced)
         * 
         * @param traceEnabled the value to set
         * @return the dsl builder
         */
        default AdvancedJettyHttp11EndpointBuilder traceEnabled(
                String traceEnabled) {
            doSetProperty("traceEnabled", traceEnabled);
            return this;
        }
    }

    public interface JettyHttp11Builders {
        /**
         * Jetty (camel-jetty)
         * Expose HTTP endpoints using Jetty 11.
         * 
         * Category: http
         * Since: 1.2
         * Maven coordinates: org.apache.camel:camel-jetty
         * 
         * @return the dsl builder for the headers' name.
         */
        default JettyHttp11HeaderNameBuilder jetty() {
            return JettyHttp11HeaderNameBuilder.INSTANCE;
        }
        /**
         * Jetty (camel-jetty)
         * Expose HTTP endpoints using Jetty 11.
         * 
         * Category: http
         * Since: 1.2
         * Maven coordinates: org.apache.camel:camel-jetty
         * 
         * Syntax: <code>jetty:httpUri</code>
         * 
         * Path parameter: httpUri (required)
         * The url of the HTTP endpoint to call.
         * 
         * @param path httpUri
         * @return the dsl builder
         */
        default JettyHttp11EndpointBuilder jetty(String path) {
            return JettyHttp11EndpointBuilderFactory.endpointBuilder("jetty", path);
        }
        /**
         * Jetty (camel-jetty)
         * Expose HTTP endpoints using Jetty 11.
         * 
         * Category: http
         * Since: 1.2
         * Maven coordinates: org.apache.camel:camel-jetty
         * 
         * Syntax: <code>jetty:httpUri</code>
         * 
         * Path parameter: httpUri (required)
         * The url of the HTTP endpoint to call.
         * 
         * @param componentName to use a custom component name for the endpoint
         * instead of the default name
         * @param path httpUri
         * @return the dsl builder
         */
        default JettyHttp11EndpointBuilder jetty(
                String componentName,
                String path) {
            return JettyHttp11EndpointBuilderFactory.endpointBuilder(componentName, path);
        }
    }

    /**
     * The builder of headers' name for the Jetty component.
     */
    public static class JettyHttp11HeaderNameBuilder {
        /**
         * The internal instance of the builder used to access to all the
         * methods representing the name of headers.
         */
        private static final JettyHttp11HeaderNameBuilder INSTANCE = new JettyHttp11HeaderNameBuilder();

        /**
         * The servlet context path used.
         * 
         * The option is a: {@code String} type.
         * 
         * Group: consumer
         * 
         * @return the name of the header {@code ServletContextPath}.
         */
        public String servletContextPath() {
            return "CamelServletContextPath";
        }

        /**
         * Request URI's path, the header will be used to build the request URI
         * with the HTTP_URI.
         * 
         * The option is a: {@code String} type.
         * 
         * Group: consumer
         * 
         * @return the name of the header {@code HttpPath}.
         */
        public String httpPath() {
            return "CamelHttpPath";
        }
    }
    static JettyHttp11EndpointBuilder endpointBuilder(
            String componentName,
            String path) {
        class JettyHttp11EndpointBuilderImpl extends AbstractEndpointBuilder implements JettyHttp11EndpointBuilder, AdvancedJettyHttp11EndpointBuilder {
            public JettyHttp11EndpointBuilderImpl(String path) {
                super(componentName, path);
            }
        }
        return new JettyHttp11EndpointBuilderImpl(path);
    }
}