/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.apache.camel.builder.endpoint.dsl;

import java.util.*;
import java.util.concurrent.*;
import java.util.function.*;
import java.util.stream.*;
import javax.annotation.processing.Generated;
import org.apache.camel.builder.EndpointConsumerBuilder;
import org.apache.camel.builder.EndpointProducerBuilder;
import org.apache.camel.builder.endpoint.AbstractEndpointBuilder;

/**
 * Offers publish/subscribe, peer-to-peer (via a server), and RPC style
 * messaging using the CometD/Bayeux protocol.
 * 
 * Generated by camel build tools - do NOT edit this file!
 */
@Generated("org.apache.camel.maven.packaging.EndpointDslMojo")
public interface CometdEndpointBuilderFactory {


    /**
     * Builder for endpoint consumers for the CometD component.
     */
    public interface CometdEndpointConsumerBuilder
            extends
                EndpointConsumerBuilder {
        default AdvancedCometdEndpointConsumerBuilder advanced() {
            return (AdvancedCometdEndpointConsumerBuilder) this;
        }
        /**
         * The origins domain that support to cross, if the crosssOriginFilterOn
         * is true.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Default: *
         * Group: common
         * 
         * @param allowedOrigins the value to set
         * @return the dsl builder
         */
        default CometdEndpointConsumerBuilder allowedOrigins(
                String allowedOrigins) {
            doSetProperty("allowedOrigins", allowedOrigins);
            return this;
        }
        /**
         * The root directory for the web resources or classpath. Use the
         * protocol file: or classpath: depending if you want that the component
         * loads the resource from file system or classpath. Classpath is
         * required for OSGI deployment where the resources are packaged in the
         * jar.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param baseResource the value to set
         * @return the dsl builder
         */
        default CometdEndpointConsumerBuilder baseResource(String baseResource) {
            doSetProperty("baseResource", baseResource);
            return this;
        }
        /**
         * If true, the server will support for cross-domain filtering.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: false
         * Group: common
         * 
         * @param crossOriginFilterOn the value to set
         * @return the dsl builder
         */
        default CometdEndpointConsumerBuilder crossOriginFilterOn(
                boolean crossOriginFilterOn) {
            doSetProperty("crossOriginFilterOn", crossOriginFilterOn);
            return this;
        }
        /**
         * If true, the server will support for cross-domain filtering.
         * 
         * The option will be converted to a &lt;code&gt;boolean&lt;/code&gt;
         * type.
         * 
         * Default: false
         * Group: common
         * 
         * @param crossOriginFilterOn the value to set
         * @return the dsl builder
         */
        default CometdEndpointConsumerBuilder crossOriginFilterOn(
                String crossOriginFilterOn) {
            doSetProperty("crossOriginFilterOn", crossOriginFilterOn);
            return this;
        }
        /**
         * The filterPath will be used by the CrossOriginFilter, if the
         * crosssOriginFilterOn is true.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param filterPath the value to set
         * @return the dsl builder
         */
        default CometdEndpointConsumerBuilder filterPath(String filterPath) {
            doSetProperty("filterPath", filterPath);
            return this;
        }
        /**
         * The client side poll timeout in milliseconds. How long a client will
         * wait between reconnects.
         * 
         * The option is a: &lt;code&gt;int&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param interval the value to set
         * @return the dsl builder
         */
        default CometdEndpointConsumerBuilder interval(int interval) {
            doSetProperty("interval", interval);
            return this;
        }
        /**
         * The client side poll timeout in milliseconds. How long a client will
         * wait between reconnects.
         * 
         * The option will be converted to a &lt;code&gt;int&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param interval the value to set
         * @return the dsl builder
         */
        default CometdEndpointConsumerBuilder interval(String interval) {
            doSetProperty("interval", interval);
            return this;
        }
        /**
         * If true, the server will accept JSON wrapped in a comment and will
         * generate JSON wrapped in a comment. This is a defence against Ajax
         * Hijacking.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: true
         * Group: common
         * 
         * @param jsonCommented the value to set
         * @return the dsl builder
         */
        default CometdEndpointConsumerBuilder jsonCommented(
                boolean jsonCommented) {
            doSetProperty("jsonCommented", jsonCommented);
            return this;
        }
        /**
         * If true, the server will accept JSON wrapped in a comment and will
         * generate JSON wrapped in a comment. This is a defence against Ajax
         * Hijacking.
         * 
         * The option will be converted to a &lt;code&gt;boolean&lt;/code&gt;
         * type.
         * 
         * Default: true
         * Group: common
         * 
         * @param jsonCommented the value to set
         * @return the dsl builder
         */
        default CometdEndpointConsumerBuilder jsonCommented(String jsonCommented) {
            doSetProperty("jsonCommented", jsonCommented);
            return this;
        }
        /**
         * Logging level. 0=none, 1=info, 2=debug.
         * 
         * The option is a: &lt;code&gt;int&lt;/code&gt; type.
         * 
         * Default: 1
         * Group: common
         * 
         * @param logLevel the value to set
         * @return the dsl builder
         */
        default CometdEndpointConsumerBuilder logLevel(int logLevel) {
            doSetProperty("logLevel", logLevel);
            return this;
        }
        /**
         * Logging level. 0=none, 1=info, 2=debug.
         * 
         * The option will be converted to a &lt;code&gt;int&lt;/code&gt; type.
         * 
         * Default: 1
         * Group: common
         * 
         * @param logLevel the value to set
         * @return the dsl builder
         */
        default CometdEndpointConsumerBuilder logLevel(String logLevel) {
            doSetProperty("logLevel", logLevel);
            return this;
        }
        /**
         * The max client side poll timeout in milliseconds. A client will be
         * removed if a connection is not received in this time.
         * 
         * The option is a: &lt;code&gt;int&lt;/code&gt; type.
         * 
         * Default: 30000
         * Group: common
         * 
         * @param maxInterval the value to set
         * @return the dsl builder
         */
        default CometdEndpointConsumerBuilder maxInterval(int maxInterval) {
            doSetProperty("maxInterval", maxInterval);
            return this;
        }
        /**
         * The max client side poll timeout in milliseconds. A client will be
         * removed if a connection is not received in this time.
         * 
         * The option will be converted to a &lt;code&gt;int&lt;/code&gt; type.
         * 
         * Default: 30000
         * Group: common
         * 
         * @param maxInterval the value to set
         * @return the dsl builder
         */
        default CometdEndpointConsumerBuilder maxInterval(String maxInterval) {
            doSetProperty("maxInterval", maxInterval);
            return this;
        }
        /**
         * The client side poll timeout, if multiple connections are detected
         * from the same browser.
         * 
         * The option is a: &lt;code&gt;int&lt;/code&gt; type.
         * 
         * Default: 1500
         * Group: common
         * 
         * @param multiFrameInterval the value to set
         * @return the dsl builder
         */
        default CometdEndpointConsumerBuilder multiFrameInterval(
                int multiFrameInterval) {
            doSetProperty("multiFrameInterval", multiFrameInterval);
            return this;
        }
        /**
         * The client side poll timeout, if multiple connections are detected
         * from the same browser.
         * 
         * The option will be converted to a &lt;code&gt;int&lt;/code&gt; type.
         * 
         * Default: 1500
         * Group: common
         * 
         * @param multiFrameInterval the value to set
         * @return the dsl builder
         */
        default CometdEndpointConsumerBuilder multiFrameInterval(
                String multiFrameInterval) {
            doSetProperty("multiFrameInterval", multiFrameInterval);
            return this;
        }
        /**
         * The server side poll timeout in milliseconds. This is how long the
         * server will hold a reconnect request before responding.
         * 
         * The option is a: &lt;code&gt;int&lt;/code&gt; type.
         * 
         * Default: 240000
         * Group: common
         * 
         * @param timeout the value to set
         * @return the dsl builder
         */
        default CometdEndpointConsumerBuilder timeout(int timeout) {
            doSetProperty("timeout", timeout);
            return this;
        }
        /**
         * The server side poll timeout in milliseconds. This is how long the
         * server will hold a reconnect request before responding.
         * 
         * The option will be converted to a &lt;code&gt;int&lt;/code&gt; type.
         * 
         * Default: 240000
         * Group: common
         * 
         * @param timeout the value to set
         * @return the dsl builder
         */
        default CometdEndpointConsumerBuilder timeout(String timeout) {
            doSetProperty("timeout", timeout);
            return this;
        }
        /**
         * Whether to include the server session headers in the Camel message
         * when creating a Camel Message for incoming requests.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: false
         * Group: consumer
         * 
         * @param sessionHeadersEnabled the value to set
         * @return the dsl builder
         */
        default CometdEndpointConsumerBuilder sessionHeadersEnabled(
                boolean sessionHeadersEnabled) {
            doSetProperty("sessionHeadersEnabled", sessionHeadersEnabled);
            return this;
        }
        /**
         * Whether to include the server session headers in the Camel message
         * when creating a Camel Message for incoming requests.
         * 
         * The option will be converted to a &lt;code&gt;boolean&lt;/code&gt;
         * type.
         * 
         * Default: false
         * Group: consumer
         * 
         * @param sessionHeadersEnabled the value to set
         * @return the dsl builder
         */
        default CometdEndpointConsumerBuilder sessionHeadersEnabled(
                String sessionHeadersEnabled) {
            doSetProperty("sessionHeadersEnabled", sessionHeadersEnabled);
            return this;
        }
    }

    /**
     * Advanced builder for endpoint consumers for the CometD component.
     */
    public interface AdvancedCometdEndpointConsumerBuilder
            extends
                EndpointConsumerBuilder {
        default CometdEndpointConsumerBuilder basic() {
            return (CometdEndpointConsumerBuilder) this;
        }
        /**
         * Allows for bridging the consumer to the Camel routing Error Handler,
         * which mean any exceptions occurred while the consumer is trying to
         * pickup incoming messages, or the likes, will now be processed as a
         * message and handled by the routing Error Handler. By default the
         * consumer will use the org.apache.camel.spi.ExceptionHandler to deal
         * with exceptions, that will be logged at WARN or ERROR level and
         * ignored.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: false
         * Group: consumer (advanced)
         * 
         * @param bridgeErrorHandler the value to set
         * @return the dsl builder
         */
        default AdvancedCometdEndpointConsumerBuilder bridgeErrorHandler(
                boolean bridgeErrorHandler) {
            doSetProperty("bridgeErrorHandler", bridgeErrorHandler);
            return this;
        }
        /**
         * Allows for bridging the consumer to the Camel routing Error Handler,
         * which mean any exceptions occurred while the consumer is trying to
         * pickup incoming messages, or the likes, will now be processed as a
         * message and handled by the routing Error Handler. By default the
         * consumer will use the org.apache.camel.spi.ExceptionHandler to deal
         * with exceptions, that will be logged at WARN or ERROR level and
         * ignored.
         * 
         * The option will be converted to a &lt;code&gt;boolean&lt;/code&gt;
         * type.
         * 
         * Default: false
         * Group: consumer (advanced)
         * 
         * @param bridgeErrorHandler the value to set
         * @return the dsl builder
         */
        default AdvancedCometdEndpointConsumerBuilder bridgeErrorHandler(
                String bridgeErrorHandler) {
            doSetProperty("bridgeErrorHandler", bridgeErrorHandler);
            return this;
        }
        /**
         * To let the consumer use a custom ExceptionHandler. Notice if the
         * option bridgeErrorHandler is enabled then this option is not in use.
         * By default the consumer will deal with exceptions, that will be
         * logged at WARN or ERROR level and ignored.
         * 
         * The option is a:
         * &lt;code&gt;org.apache.camel.spi.ExceptionHandler&lt;/code&gt; type.
         * 
         * Group: consumer (advanced)
         * 
         * @param exceptionHandler the value to set
         * @return the dsl builder
         */
        default AdvancedCometdEndpointConsumerBuilder exceptionHandler(
                org.apache.camel.spi.ExceptionHandler exceptionHandler) {
            doSetProperty("exceptionHandler", exceptionHandler);
            return this;
        }
        /**
         * To let the consumer use a custom ExceptionHandler. Notice if the
         * option bridgeErrorHandler is enabled then this option is not in use.
         * By default the consumer will deal with exceptions, that will be
         * logged at WARN or ERROR level and ignored.
         * 
         * The option will be converted to a
         * &lt;code&gt;org.apache.camel.spi.ExceptionHandler&lt;/code&gt; type.
         * 
         * Group: consumer (advanced)
         * 
         * @param exceptionHandler the value to set
         * @return the dsl builder
         */
        default AdvancedCometdEndpointConsumerBuilder exceptionHandler(
                String exceptionHandler) {
            doSetProperty("exceptionHandler", exceptionHandler);
            return this;
        }
        /**
         * Sets the exchange pattern when the consumer creates an exchange.
         * 
         * The option is a:
         * &lt;code&gt;org.apache.camel.ExchangePattern&lt;/code&gt; type.
         * 
         * Group: consumer (advanced)
         * 
         * @param exchangePattern the value to set
         * @return the dsl builder
         */
        default AdvancedCometdEndpointConsumerBuilder exchangePattern(
                org.apache.camel.ExchangePattern exchangePattern) {
            doSetProperty("exchangePattern", exchangePattern);
            return this;
        }
        /**
         * Sets the exchange pattern when the consumer creates an exchange.
         * 
         * The option will be converted to a
         * &lt;code&gt;org.apache.camel.ExchangePattern&lt;/code&gt; type.
         * 
         * Group: consumer (advanced)
         * 
         * @param exchangePattern the value to set
         * @return the dsl builder
         */
        default AdvancedCometdEndpointConsumerBuilder exchangePattern(
                String exchangePattern) {
            doSetProperty("exchangePattern", exchangePattern);
            return this;
        }
    }

    /**
     * Builder for endpoint producers for the CometD component.
     */
    public interface CometdEndpointProducerBuilder
            extends
                EndpointProducerBuilder {
        default AdvancedCometdEndpointProducerBuilder advanced() {
            return (AdvancedCometdEndpointProducerBuilder) this;
        }
        /**
         * The origins domain that support to cross, if the crosssOriginFilterOn
         * is true.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Default: *
         * Group: common
         * 
         * @param allowedOrigins the value to set
         * @return the dsl builder
         */
        default CometdEndpointProducerBuilder allowedOrigins(
                String allowedOrigins) {
            doSetProperty("allowedOrigins", allowedOrigins);
            return this;
        }
        /**
         * The root directory for the web resources or classpath. Use the
         * protocol file: or classpath: depending if you want that the component
         * loads the resource from file system or classpath. Classpath is
         * required for OSGI deployment where the resources are packaged in the
         * jar.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param baseResource the value to set
         * @return the dsl builder
         */
        default CometdEndpointProducerBuilder baseResource(String baseResource) {
            doSetProperty("baseResource", baseResource);
            return this;
        }
        /**
         * If true, the server will support for cross-domain filtering.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: false
         * Group: common
         * 
         * @param crossOriginFilterOn the value to set
         * @return the dsl builder
         */
        default CometdEndpointProducerBuilder crossOriginFilterOn(
                boolean crossOriginFilterOn) {
            doSetProperty("crossOriginFilterOn", crossOriginFilterOn);
            return this;
        }
        /**
         * If true, the server will support for cross-domain filtering.
         * 
         * The option will be converted to a &lt;code&gt;boolean&lt;/code&gt;
         * type.
         * 
         * Default: false
         * Group: common
         * 
         * @param crossOriginFilterOn the value to set
         * @return the dsl builder
         */
        default CometdEndpointProducerBuilder crossOriginFilterOn(
                String crossOriginFilterOn) {
            doSetProperty("crossOriginFilterOn", crossOriginFilterOn);
            return this;
        }
        /**
         * The filterPath will be used by the CrossOriginFilter, if the
         * crosssOriginFilterOn is true.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param filterPath the value to set
         * @return the dsl builder
         */
        default CometdEndpointProducerBuilder filterPath(String filterPath) {
            doSetProperty("filterPath", filterPath);
            return this;
        }
        /**
         * The client side poll timeout in milliseconds. How long a client will
         * wait between reconnects.
         * 
         * The option is a: &lt;code&gt;int&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param interval the value to set
         * @return the dsl builder
         */
        default CometdEndpointProducerBuilder interval(int interval) {
            doSetProperty("interval", interval);
            return this;
        }
        /**
         * The client side poll timeout in milliseconds. How long a client will
         * wait between reconnects.
         * 
         * The option will be converted to a &lt;code&gt;int&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param interval the value to set
         * @return the dsl builder
         */
        default CometdEndpointProducerBuilder interval(String interval) {
            doSetProperty("interval", interval);
            return this;
        }
        /**
         * If true, the server will accept JSON wrapped in a comment and will
         * generate JSON wrapped in a comment. This is a defence against Ajax
         * Hijacking.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: true
         * Group: common
         * 
         * @param jsonCommented the value to set
         * @return the dsl builder
         */
        default CometdEndpointProducerBuilder jsonCommented(
                boolean jsonCommented) {
            doSetProperty("jsonCommented", jsonCommented);
            return this;
        }
        /**
         * If true, the server will accept JSON wrapped in a comment and will
         * generate JSON wrapped in a comment. This is a defence against Ajax
         * Hijacking.
         * 
         * The option will be converted to a &lt;code&gt;boolean&lt;/code&gt;
         * type.
         * 
         * Default: true
         * Group: common
         * 
         * @param jsonCommented the value to set
         * @return the dsl builder
         */
        default CometdEndpointProducerBuilder jsonCommented(String jsonCommented) {
            doSetProperty("jsonCommented", jsonCommented);
            return this;
        }
        /**
         * Logging level. 0=none, 1=info, 2=debug.
         * 
         * The option is a: &lt;code&gt;int&lt;/code&gt; type.
         * 
         * Default: 1
         * Group: common
         * 
         * @param logLevel the value to set
         * @return the dsl builder
         */
        default CometdEndpointProducerBuilder logLevel(int logLevel) {
            doSetProperty("logLevel", logLevel);
            return this;
        }
        /**
         * Logging level. 0=none, 1=info, 2=debug.
         * 
         * The option will be converted to a &lt;code&gt;int&lt;/code&gt; type.
         * 
         * Default: 1
         * Group: common
         * 
         * @param logLevel the value to set
         * @return the dsl builder
         */
        default CometdEndpointProducerBuilder logLevel(String logLevel) {
            doSetProperty("logLevel", logLevel);
            return this;
        }
        /**
         * The max client side poll timeout in milliseconds. A client will be
         * removed if a connection is not received in this time.
         * 
         * The option is a: &lt;code&gt;int&lt;/code&gt; type.
         * 
         * Default: 30000
         * Group: common
         * 
         * @param maxInterval the value to set
         * @return the dsl builder
         */
        default CometdEndpointProducerBuilder maxInterval(int maxInterval) {
            doSetProperty("maxInterval", maxInterval);
            return this;
        }
        /**
         * The max client side poll timeout in milliseconds. A client will be
         * removed if a connection is not received in this time.
         * 
         * The option will be converted to a &lt;code&gt;int&lt;/code&gt; type.
         * 
         * Default: 30000
         * Group: common
         * 
         * @param maxInterval the value to set
         * @return the dsl builder
         */
        default CometdEndpointProducerBuilder maxInterval(String maxInterval) {
            doSetProperty("maxInterval", maxInterval);
            return this;
        }
        /**
         * The client side poll timeout, if multiple connections are detected
         * from the same browser.
         * 
         * The option is a: &lt;code&gt;int&lt;/code&gt; type.
         * 
         * Default: 1500
         * Group: common
         * 
         * @param multiFrameInterval the value to set
         * @return the dsl builder
         */
        default CometdEndpointProducerBuilder multiFrameInterval(
                int multiFrameInterval) {
            doSetProperty("multiFrameInterval", multiFrameInterval);
            return this;
        }
        /**
         * The client side poll timeout, if multiple connections are detected
         * from the same browser.
         * 
         * The option will be converted to a &lt;code&gt;int&lt;/code&gt; type.
         * 
         * Default: 1500
         * Group: common
         * 
         * @param multiFrameInterval the value to set
         * @return the dsl builder
         */
        default CometdEndpointProducerBuilder multiFrameInterval(
                String multiFrameInterval) {
            doSetProperty("multiFrameInterval", multiFrameInterval);
            return this;
        }
        /**
         * The server side poll timeout in milliseconds. This is how long the
         * server will hold a reconnect request before responding.
         * 
         * The option is a: &lt;code&gt;int&lt;/code&gt; type.
         * 
         * Default: 240000
         * Group: common
         * 
         * @param timeout the value to set
         * @return the dsl builder
         */
        default CometdEndpointProducerBuilder timeout(int timeout) {
            doSetProperty("timeout", timeout);
            return this;
        }
        /**
         * The server side poll timeout in milliseconds. This is how long the
         * server will hold a reconnect request before responding.
         * 
         * The option will be converted to a &lt;code&gt;int&lt;/code&gt; type.
         * 
         * Default: 240000
         * Group: common
         * 
         * @param timeout the value to set
         * @return the dsl builder
         */
        default CometdEndpointProducerBuilder timeout(String timeout) {
            doSetProperty("timeout", timeout);
            return this;
        }
        /**
         * Whether to disconnect local sessions after publishing a message to
         * its channel. Disconnecting local session is needed as they are not
         * swept by default by CometD, and therefore you can run out of memory.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: false
         * Group: producer
         * 
         * @param disconnectLocalSession the value to set
         * @return the dsl builder
         */
        default CometdEndpointProducerBuilder disconnectLocalSession(
                boolean disconnectLocalSession) {
            doSetProperty("disconnectLocalSession", disconnectLocalSession);
            return this;
        }
        /**
         * Whether to disconnect local sessions after publishing a message to
         * its channel. Disconnecting local session is needed as they are not
         * swept by default by CometD, and therefore you can run out of memory.
         * 
         * The option will be converted to a &lt;code&gt;boolean&lt;/code&gt;
         * type.
         * 
         * Default: false
         * Group: producer
         * 
         * @param disconnectLocalSession the value to set
         * @return the dsl builder
         */
        default CometdEndpointProducerBuilder disconnectLocalSession(
                String disconnectLocalSession) {
            doSetProperty("disconnectLocalSession", disconnectLocalSession);
            return this;
        }
    }

    /**
     * Advanced builder for endpoint producers for the CometD component.
     */
    public interface AdvancedCometdEndpointProducerBuilder
            extends
                EndpointProducerBuilder {
        default CometdEndpointProducerBuilder basic() {
            return (CometdEndpointProducerBuilder) this;
        }
        /**
         * Whether the producer should be started lazy (on the first message).
         * By starting lazy you can use this to allow CamelContext and routes to
         * startup in situations where a producer may otherwise fail during
         * starting and cause the route to fail being started. By deferring this
         * startup to be lazy then the startup failure can be handled during
         * routing messages via Camel's routing error handlers. Beware that when
         * the first message is processed then creating and starting the
         * producer may take a little time and prolong the total processing time
         * of the processing.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: false
         * Group: producer (advanced)
         * 
         * @param lazyStartProducer the value to set
         * @return the dsl builder
         */
        default AdvancedCometdEndpointProducerBuilder lazyStartProducer(
                boolean lazyStartProducer) {
            doSetProperty("lazyStartProducer", lazyStartProducer);
            return this;
        }
        /**
         * Whether the producer should be started lazy (on the first message).
         * By starting lazy you can use this to allow CamelContext and routes to
         * startup in situations where a producer may otherwise fail during
         * starting and cause the route to fail being started. By deferring this
         * startup to be lazy then the startup failure can be handled during
         * routing messages via Camel's routing error handlers. Beware that when
         * the first message is processed then creating and starting the
         * producer may take a little time and prolong the total processing time
         * of the processing.
         * 
         * The option will be converted to a &lt;code&gt;boolean&lt;/code&gt;
         * type.
         * 
         * Default: false
         * Group: producer (advanced)
         * 
         * @param lazyStartProducer the value to set
         * @return the dsl builder
         */
        default AdvancedCometdEndpointProducerBuilder lazyStartProducer(
                String lazyStartProducer) {
            doSetProperty("lazyStartProducer", lazyStartProducer);
            return this;
        }
    }

    /**
     * Builder for endpoint for the CometD component.
     */
    public interface CometdEndpointBuilder
            extends
                CometdEndpointConsumerBuilder,
                CometdEndpointProducerBuilder {
        default AdvancedCometdEndpointBuilder advanced() {
            return (AdvancedCometdEndpointBuilder) this;
        }
        /**
         * The origins domain that support to cross, if the crosssOriginFilterOn
         * is true.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Default: *
         * Group: common
         * 
         * @param allowedOrigins the value to set
         * @return the dsl builder
         */
        default CometdEndpointBuilder allowedOrigins(String allowedOrigins) {
            doSetProperty("allowedOrigins", allowedOrigins);
            return this;
        }
        /**
         * The root directory for the web resources or classpath. Use the
         * protocol file: or classpath: depending if you want that the component
         * loads the resource from file system or classpath. Classpath is
         * required for OSGI deployment where the resources are packaged in the
         * jar.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param baseResource the value to set
         * @return the dsl builder
         */
        default CometdEndpointBuilder baseResource(String baseResource) {
            doSetProperty("baseResource", baseResource);
            return this;
        }
        /**
         * If true, the server will support for cross-domain filtering.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: false
         * Group: common
         * 
         * @param crossOriginFilterOn the value to set
         * @return the dsl builder
         */
        default CometdEndpointBuilder crossOriginFilterOn(
                boolean crossOriginFilterOn) {
            doSetProperty("crossOriginFilterOn", crossOriginFilterOn);
            return this;
        }
        /**
         * If true, the server will support for cross-domain filtering.
         * 
         * The option will be converted to a &lt;code&gt;boolean&lt;/code&gt;
         * type.
         * 
         * Default: false
         * Group: common
         * 
         * @param crossOriginFilterOn the value to set
         * @return the dsl builder
         */
        default CometdEndpointBuilder crossOriginFilterOn(
                String crossOriginFilterOn) {
            doSetProperty("crossOriginFilterOn", crossOriginFilterOn);
            return this;
        }
        /**
         * The filterPath will be used by the CrossOriginFilter, if the
         * crosssOriginFilterOn is true.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param filterPath the value to set
         * @return the dsl builder
         */
        default CometdEndpointBuilder filterPath(String filterPath) {
            doSetProperty("filterPath", filterPath);
            return this;
        }
        /**
         * The client side poll timeout in milliseconds. How long a client will
         * wait between reconnects.
         * 
         * The option is a: &lt;code&gt;int&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param interval the value to set
         * @return the dsl builder
         */
        default CometdEndpointBuilder interval(int interval) {
            doSetProperty("interval", interval);
            return this;
        }
        /**
         * The client side poll timeout in milliseconds. How long a client will
         * wait between reconnects.
         * 
         * The option will be converted to a &lt;code&gt;int&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param interval the value to set
         * @return the dsl builder
         */
        default CometdEndpointBuilder interval(String interval) {
            doSetProperty("interval", interval);
            return this;
        }
        /**
         * If true, the server will accept JSON wrapped in a comment and will
         * generate JSON wrapped in a comment. This is a defence against Ajax
         * Hijacking.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: true
         * Group: common
         * 
         * @param jsonCommented the value to set
         * @return the dsl builder
         */
        default CometdEndpointBuilder jsonCommented(boolean jsonCommented) {
            doSetProperty("jsonCommented", jsonCommented);
            return this;
        }
        /**
         * If true, the server will accept JSON wrapped in a comment and will
         * generate JSON wrapped in a comment. This is a defence against Ajax
         * Hijacking.
         * 
         * The option will be converted to a &lt;code&gt;boolean&lt;/code&gt;
         * type.
         * 
         * Default: true
         * Group: common
         * 
         * @param jsonCommented the value to set
         * @return the dsl builder
         */
        default CometdEndpointBuilder jsonCommented(String jsonCommented) {
            doSetProperty("jsonCommented", jsonCommented);
            return this;
        }
        /**
         * Logging level. 0=none, 1=info, 2=debug.
         * 
         * The option is a: &lt;code&gt;int&lt;/code&gt; type.
         * 
         * Default: 1
         * Group: common
         * 
         * @param logLevel the value to set
         * @return the dsl builder
         */
        default CometdEndpointBuilder logLevel(int logLevel) {
            doSetProperty("logLevel", logLevel);
            return this;
        }
        /**
         * Logging level. 0=none, 1=info, 2=debug.
         * 
         * The option will be converted to a &lt;code&gt;int&lt;/code&gt; type.
         * 
         * Default: 1
         * Group: common
         * 
         * @param logLevel the value to set
         * @return the dsl builder
         */
        default CometdEndpointBuilder logLevel(String logLevel) {
            doSetProperty("logLevel", logLevel);
            return this;
        }
        /**
         * The max client side poll timeout in milliseconds. A client will be
         * removed if a connection is not received in this time.
         * 
         * The option is a: &lt;code&gt;int&lt;/code&gt; type.
         * 
         * Default: 30000
         * Group: common
         * 
         * @param maxInterval the value to set
         * @return the dsl builder
         */
        default CometdEndpointBuilder maxInterval(int maxInterval) {
            doSetProperty("maxInterval", maxInterval);
            return this;
        }
        /**
         * The max client side poll timeout in milliseconds. A client will be
         * removed if a connection is not received in this time.
         * 
         * The option will be converted to a &lt;code&gt;int&lt;/code&gt; type.
         * 
         * Default: 30000
         * Group: common
         * 
         * @param maxInterval the value to set
         * @return the dsl builder
         */
        default CometdEndpointBuilder maxInterval(String maxInterval) {
            doSetProperty("maxInterval", maxInterval);
            return this;
        }
        /**
         * The client side poll timeout, if multiple connections are detected
         * from the same browser.
         * 
         * The option is a: &lt;code&gt;int&lt;/code&gt; type.
         * 
         * Default: 1500
         * Group: common
         * 
         * @param multiFrameInterval the value to set
         * @return the dsl builder
         */
        default CometdEndpointBuilder multiFrameInterval(int multiFrameInterval) {
            doSetProperty("multiFrameInterval", multiFrameInterval);
            return this;
        }
        /**
         * The client side poll timeout, if multiple connections are detected
         * from the same browser.
         * 
         * The option will be converted to a &lt;code&gt;int&lt;/code&gt; type.
         * 
         * Default: 1500
         * Group: common
         * 
         * @param multiFrameInterval the value to set
         * @return the dsl builder
         */
        default CometdEndpointBuilder multiFrameInterval(
                String multiFrameInterval) {
            doSetProperty("multiFrameInterval", multiFrameInterval);
            return this;
        }
        /**
         * The server side poll timeout in milliseconds. This is how long the
         * server will hold a reconnect request before responding.
         * 
         * The option is a: &lt;code&gt;int&lt;/code&gt; type.
         * 
         * Default: 240000
         * Group: common
         * 
         * @param timeout the value to set
         * @return the dsl builder
         */
        default CometdEndpointBuilder timeout(int timeout) {
            doSetProperty("timeout", timeout);
            return this;
        }
        /**
         * The server side poll timeout in milliseconds. This is how long the
         * server will hold a reconnect request before responding.
         * 
         * The option will be converted to a &lt;code&gt;int&lt;/code&gt; type.
         * 
         * Default: 240000
         * Group: common
         * 
         * @param timeout the value to set
         * @return the dsl builder
         */
        default CometdEndpointBuilder timeout(String timeout) {
            doSetProperty("timeout", timeout);
            return this;
        }
    }

    /**
     * Advanced builder for endpoint for the CometD component.
     */
    public interface AdvancedCometdEndpointBuilder
            extends
                AdvancedCometdEndpointConsumerBuilder,
                AdvancedCometdEndpointProducerBuilder {
        default CometdEndpointBuilder basic() {
            return (CometdEndpointBuilder) this;
        }
    }

    public interface CometdBuilders {
        /**
         * CometD (camel-cometd)
         * Offers publish/subscribe, peer-to-peer (via a server), and RPC style
         * messaging using the CometD/Bayeux protocol.
         * 
         * Category: networking,messaging
         * Since: 2.0
         * Maven coordinates: org.apache.camel:camel-cometd
         * 
         * @return the dsl builder for the headers' name.
         */
        default CometdHeaderNameBuilder cometd() {
            return CometdHeaderNameBuilder.INSTANCE;
        }
        /**
         * CometD (camel-cometd)
         * Offers publish/subscribe, peer-to-peer (via a server), and RPC style
         * messaging using the CometD/Bayeux protocol.
         * 
         * Category: networking,messaging
         * Since: 2.0
         * Maven coordinates: org.apache.camel:camel-cometd
         * 
         * Syntax: <code>cometd:host:port/channelName</code>
         * 
         * Path parameter: host (required)
         * Hostname
         * 
         * Path parameter: port (required)
         * Host port number
         * 
         * Path parameter: channelName (required)
         * The channelName represents a topic that can be subscribed to by the
         * Camel endpoints.
         * 
         * @param path host:port/channelName
         * @return the dsl builder
         */
        default CometdEndpointBuilder cometd(String path) {
            return CometdEndpointBuilderFactory.endpointBuilder("cometd", path);
        }
        /**
         * CometD (camel-cometd)
         * Offers publish/subscribe, peer-to-peer (via a server), and RPC style
         * messaging using the CometD/Bayeux protocol.
         * 
         * Category: networking,messaging
         * Since: 2.0
         * Maven coordinates: org.apache.camel:camel-cometd
         * 
         * Syntax: <code>cometd:host:port/channelName</code>
         * 
         * Path parameter: host (required)
         * Hostname
         * 
         * Path parameter: port (required)
         * Host port number
         * 
         * Path parameter: channelName (required)
         * The channelName represents a topic that can be subscribed to by the
         * Camel endpoints.
         * 
         * @param componentName to use a custom component name for the endpoint
         * instead of the default name
         * @param path host:port/channelName
         * @return the dsl builder
         */
        default CometdEndpointBuilder cometd(String componentName, String path) {
            return CometdEndpointBuilderFactory.endpointBuilder(componentName, path);
        }
        /**
         * CometD (Secure) (camel-cometd)
         * Offers publish/subscribe, peer-to-peer (via a server), and RPC style
         * messaging using the CometD/Bayeux protocol.
         * 
         * Category: networking,messaging
         * Since: 2.0
         * Maven coordinates: org.apache.camel:camel-cometd
         * 
         * Syntax: <code>cometds:host:port/channelName</code>
         * 
         * Path parameter: host (required)
         * Hostname
         * 
         * Path parameter: port (required)
         * Host port number
         * 
         * Path parameter: channelName (required)
         * The channelName represents a topic that can be subscribed to by the
         * Camel endpoints.
         * 
         * @param path host:port/channelName
         * @return the dsl builder
         */
        default CometdEndpointBuilder cometds(String path) {
            return CometdEndpointBuilderFactory.endpointBuilder("cometds", path);
        }
    }

    /**
     * The builder of headers' name for the CometD component.
     */
    public static class CometdHeaderNameBuilder {
        /**
         * The internal instance of the builder used to access to all the
         * methods representing the name of headers.
         */
        private static final CometdHeaderNameBuilder INSTANCE = new CometdHeaderNameBuilder();

        /**
         * The clientId of the session.
         * 
         * The option is a: {@code String} type.
         * 
         * Group: common
         * 
         * @return the name of the header {@code CometdClientId}.
         */
        public String cometdClientId() {
            return "CometdClientId";
        }

        /**
         * The subscription.
         * 
         * The option is a: {@code String} type.
         * 
         * Group: common
         * 
         * @return the name of the header {@code subscription}.
         */
        public String subscription() {
            return "subscription";
        }
    }
    static CometdEndpointBuilder endpointBuilder(
            String componentName,
            String path) {
        class CometdEndpointBuilderImpl extends AbstractEndpointBuilder implements CometdEndpointBuilder, AdvancedCometdEndpointBuilder {
            public CometdEndpointBuilderImpl(String path) {
                super(componentName, path);
            }
        }
        return new CometdEndpointBuilderImpl(path);
    }
}