/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.apache.camel.builder.endpoint.dsl;

import java.util.*;
import java.util.Map;
import java.util.concurrent.*;
import java.util.function.*;
import java.util.stream.*;
import javax.annotation.processing.Generated;
import org.apache.camel.builder.EndpointConsumerBuilder;
import org.apache.camel.builder.EndpointProducerBuilder;
import org.apache.camel.builder.endpoint.AbstractEndpointBuilder;

/**
 * Sends and receives files to/from Azure DataLake Storage.
 * 
 * Generated by camel build tools - do NOT edit this file!
 */
@Generated("org.apache.camel.maven.packaging.EndpointDslMojo")
public interface DataLakeEndpointBuilderFactory {


    /**
     * Builder for endpoint consumers for the Azure Storage Datalake Service
     * component.
     */
    public interface DataLakeEndpointConsumerBuilder
            extends
                EndpointConsumerBuilder {
        default AdvancedDataLakeEndpointConsumerBuilder advanced() {
            return (AdvancedDataLakeEndpointConsumerBuilder) this;
        }
        /**
         * client id for azure account.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param clientId the value to set
         * @return the dsl builder
         */
        default DataLakeEndpointConsumerBuilder clientId(String clientId) {
            doSetProperty("clientId", clientId);
            return this;
        }
        /**
         * Whether or not a file changed event raised indicates completion
         * (true) or modification (false).
         * 
         * The option is a: &lt;code&gt;java.lang.Boolean&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param close the value to set
         * @return the dsl builder
         */
        default DataLakeEndpointConsumerBuilder close(Boolean close) {
            doSetProperty("close", close);
            return this;
        }
        /**
         * Whether or not a file changed event raised indicates completion
         * (true) or modification (false).
         * 
         * The option will be converted to a
         * &lt;code&gt;java.lang.Boolean&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param close the value to set
         * @return the dsl builder
         */
        default DataLakeEndpointConsumerBuilder close(String close) {
            doSetProperty("close", close);
            return this;
        }
        /**
         * check for closing stream after read.
         * 
         * The option is a: &lt;code&gt;java.lang.Boolean&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param closeStreamAfterRead the value to set
         * @return the dsl builder
         */
        default DataLakeEndpointConsumerBuilder closeStreamAfterRead(
                Boolean closeStreamAfterRead) {
            doSetProperty("closeStreamAfterRead", closeStreamAfterRead);
            return this;
        }
        /**
         * check for closing stream after read.
         * 
         * The option will be converted to a
         * &lt;code&gt;java.lang.Boolean&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param closeStreamAfterRead the value to set
         * @return the dsl builder
         */
        default DataLakeEndpointConsumerBuilder closeStreamAfterRead(
                String closeStreamAfterRead) {
            doSetProperty("closeStreamAfterRead", closeStreamAfterRead);
            return this;
        }
        /**
         * count number of bytes to download.
         * 
         * The option is a: &lt;code&gt;java.lang.Long&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param dataCount the value to set
         * @return the dsl builder
         */
        default DataLakeEndpointConsumerBuilder dataCount(Long dataCount) {
            doSetProperty("dataCount", dataCount);
            return this;
        }
        /**
         * count number of bytes to download.
         * 
         * The option will be converted to a
         * &lt;code&gt;java.lang.Long&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param dataCount the value to set
         * @return the dsl builder
         */
        default DataLakeEndpointConsumerBuilder dataCount(String dataCount) {
            doSetProperty("dataCount", dataCount);
            return this;
        }
        /**
         * service client of datalake.
         * 
         * The option is a:
         * &lt;code&gt;com.azure.storage.file.datalake.DataLakeServiceClient&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param dataLakeServiceClient the value to set
         * @return the dsl builder
         */
        default DataLakeEndpointConsumerBuilder dataLakeServiceClient(
                com.azure.storage.file.datalake.DataLakeServiceClient dataLakeServiceClient) {
            doSetProperty("dataLakeServiceClient", dataLakeServiceClient);
            return this;
        }
        /**
         * service client of datalake.
         * 
         * The option will be converted to a
         * &lt;code&gt;com.azure.storage.file.datalake.DataLakeServiceClient&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param dataLakeServiceClient the value to set
         * @return the dsl builder
         */
        default DataLakeEndpointConsumerBuilder dataLakeServiceClient(
                String dataLakeServiceClient) {
            doSetProperty("dataLakeServiceClient", dataLakeServiceClient);
            return this;
        }
        /**
         * directory of the file to be handled in component.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param directoryName the value to set
         * @return the dsl builder
         */
        default DataLakeEndpointConsumerBuilder directoryName(
                String directoryName) {
            doSetProperty("directoryName", directoryName);
            return this;
        }
        /**
         * download link expiration time.
         * 
         * The option is a: &lt;code&gt;java.lang.Long&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param downloadLinkExpiration the value to set
         * @return the dsl builder
         */
        default DataLakeEndpointConsumerBuilder downloadLinkExpiration(
                Long downloadLinkExpiration) {
            doSetProperty("downloadLinkExpiration", downloadLinkExpiration);
            return this;
        }
        /**
         * download link expiration time.
         * 
         * The option will be converted to a
         * &lt;code&gt;java.lang.Long&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param downloadLinkExpiration the value to set
         * @return the dsl builder
         */
        default DataLakeEndpointConsumerBuilder downloadLinkExpiration(
                String downloadLinkExpiration) {
            doSetProperty("downloadLinkExpiration", downloadLinkExpiration);
            return this;
        }
        /**
         * expression for queryInputStream.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param expression the value to set
         * @return the dsl builder
         */
        default DataLakeEndpointConsumerBuilder expression(String expression) {
            doSetProperty("expression", expression);
            return this;
        }
        /**
         * directory of file to do operations in the local system.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param fileDir the value to set
         * @return the dsl builder
         */
        default DataLakeEndpointConsumerBuilder fileDir(String fileDir) {
            doSetProperty("fileDir", fileDir);
            return this;
        }
        /**
         * name of file to be handled in component.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param fileName the value to set
         * @return the dsl builder
         */
        default DataLakeEndpointConsumerBuilder fileName(String fileName) {
            doSetProperty("fileName", fileName);
            return this;
        }
        /**
         * offset position in file for different operations.
         * 
         * The option is a: &lt;code&gt;java.lang.Long&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param fileOffset the value to set
         * @return the dsl builder
         */
        default DataLakeEndpointConsumerBuilder fileOffset(Long fileOffset) {
            doSetProperty("fileOffset", fileOffset);
            return this;
        }
        /**
         * offset position in file for different operations.
         * 
         * The option will be converted to a
         * &lt;code&gt;java.lang.Long&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param fileOffset the value to set
         * @return the dsl builder
         */
        default DataLakeEndpointConsumerBuilder fileOffset(String fileOffset) {
            doSetProperty("fileOffset", fileOffset);
            return this;
        }
        /**
         * maximum number of results to show at a time.
         * 
         * The option is a: &lt;code&gt;java.lang.Integer&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param maxResults the value to set
         * @return the dsl builder
         */
        default DataLakeEndpointConsumerBuilder maxResults(Integer maxResults) {
            doSetProperty("maxResults", maxResults);
            return this;
        }
        /**
         * maximum number of results to show at a time.
         * 
         * The option will be converted to a
         * &lt;code&gt;java.lang.Integer&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param maxResults the value to set
         * @return the dsl builder
         */
        default DataLakeEndpointConsumerBuilder maxResults(String maxResults) {
            doSetProperty("maxResults", maxResults);
            return this;
        }
        /**
         * no of retries to a given request.
         * 
         * The option is a: &lt;code&gt;int&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param maxRetryRequests the value to set
         * @return the dsl builder
         */
        default DataLakeEndpointConsumerBuilder maxRetryRequests(
                int maxRetryRequests) {
            doSetProperty("maxRetryRequests", maxRetryRequests);
            return this;
        }
        /**
         * no of retries to a given request.
         * 
         * The option will be converted to a &lt;code&gt;int&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param maxRetryRequests the value to set
         * @return the dsl builder
         */
        default DataLakeEndpointConsumerBuilder maxRetryRequests(
                String maxRetryRequests) {
            doSetProperty("maxRetryRequests", maxRetryRequests);
            return this;
        }
        /**
         * set open options for creating file.
         * 
         * The option is a:
         * &lt;code&gt;java.util.Set&amp;lt;java.nio.file.OpenOption&amp;gt;&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param openOptions the value to set
         * @return the dsl builder
         */
        default DataLakeEndpointConsumerBuilder openOptions(
                Set<java.nio.file.OpenOption> openOptions) {
            doSetProperty("openOptions", openOptions);
            return this;
        }
        /**
         * set open options for creating file.
         * 
         * The option will be converted to a
         * &lt;code&gt;java.util.Set&amp;lt;java.nio.file.OpenOption&amp;gt;&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param openOptions the value to set
         * @return the dsl builder
         */
        default DataLakeEndpointConsumerBuilder openOptions(String openOptions) {
            doSetProperty("openOptions", openOptions);
            return this;
        }
        /**
         * path in azure datalake for operations.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param path the value to set
         * @return the dsl builder
         */
        default DataLakeEndpointConsumerBuilder path(String path) {
            doSetProperty("path", path);
            return this;
        }
        /**
         * permission string for the file.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param permission the value to set
         * @return the dsl builder
         */
        default DataLakeEndpointConsumerBuilder permission(String permission) {
            doSetProperty("permission", permission);
            return this;
        }
        /**
         * This parameter allows the caller to upload data in parallel and
         * control the order in which it is appended to the file.
         * 
         * The option is a: &lt;code&gt;java.lang.Long&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param position the value to set
         * @return the dsl builder
         */
        default DataLakeEndpointConsumerBuilder position(Long position) {
            doSetProperty("position", position);
            return this;
        }
        /**
         * This parameter allows the caller to upload data in parallel and
         * control the order in which it is appended to the file.
         * 
         * The option will be converted to a
         * &lt;code&gt;java.lang.Long&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param position the value to set
         * @return the dsl builder
         */
        default DataLakeEndpointConsumerBuilder position(String position) {
            doSetProperty("position", position);
            return this;
        }
        /**
         * recursively include all paths.
         * 
         * The option is a: &lt;code&gt;java.lang.Boolean&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param recursive the value to set
         * @return the dsl builder
         */
        default DataLakeEndpointConsumerBuilder recursive(Boolean recursive) {
            doSetProperty("recursive", recursive);
            return this;
        }
        /**
         * recursively include all paths.
         * 
         * The option will be converted to a
         * &lt;code&gt;java.lang.Boolean&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param recursive the value to set
         * @return the dsl builder
         */
        default DataLakeEndpointConsumerBuilder recursive(String recursive) {
            doSetProperty("recursive", recursive);
            return this;
        }
        /**
         * regular expression for matching file names.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param regex the value to set
         * @return the dsl builder
         */
        default DataLakeEndpointConsumerBuilder regex(String regex) {
            doSetProperty("regex", regex);
            return this;
        }
        /**
         * Whether or not uncommitted data is to be retained after the
         * operation.
         * 
         * The option is a: &lt;code&gt;java.lang.Boolean&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param retainUncommitedData the value to set
         * @return the dsl builder
         */
        default DataLakeEndpointConsumerBuilder retainUncommitedData(
                Boolean retainUncommitedData) {
            doSetProperty("retainUncommitedData", retainUncommitedData);
            return this;
        }
        /**
         * Whether or not uncommitted data is to be retained after the
         * operation.
         * 
         * The option will be converted to a
         * &lt;code&gt;java.lang.Boolean&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param retainUncommitedData the value to set
         * @return the dsl builder
         */
        default DataLakeEndpointConsumerBuilder retainUncommitedData(
                String retainUncommitedData) {
            doSetProperty("retainUncommitedData", retainUncommitedData);
            return this;
        }
        /**
         * datalake service client for azure storage datalake.
         * 
         * The option is a:
         * &lt;code&gt;com.azure.storage.file.datalake.DataLakeServiceClient&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param serviceClient the value to set
         * @return the dsl builder
         */
        default DataLakeEndpointConsumerBuilder serviceClient(
                com.azure.storage.file.datalake.DataLakeServiceClient serviceClient) {
            doSetProperty("serviceClient", serviceClient);
            return this;
        }
        /**
         * datalake service client for azure storage datalake.
         * 
         * The option will be converted to a
         * &lt;code&gt;com.azure.storage.file.datalake.DataLakeServiceClient&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param serviceClient the value to set
         * @return the dsl builder
         */
        default DataLakeEndpointConsumerBuilder serviceClient(
                String serviceClient) {
            doSetProperty("serviceClient", serviceClient);
            return this;
        }
        /**
         * shared key credential for azure datalake gen2.
         * 
         * The option is a:
         * &lt;code&gt;com.azure.storage.common.StorageSharedKeyCredential&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param sharedKeyCredential the value to set
         * @return the dsl builder
         */
        default DataLakeEndpointConsumerBuilder sharedKeyCredential(
                com.azure.storage.common.StorageSharedKeyCredential sharedKeyCredential) {
            doSetProperty("sharedKeyCredential", sharedKeyCredential);
            return this;
        }
        /**
         * shared key credential for azure datalake gen2.
         * 
         * The option will be converted to a
         * &lt;code&gt;com.azure.storage.common.StorageSharedKeyCredential&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param sharedKeyCredential the value to set
         * @return the dsl builder
         */
        default DataLakeEndpointConsumerBuilder sharedKeyCredential(
                String sharedKeyCredential) {
            doSetProperty("sharedKeyCredential", sharedKeyCredential);
            return this;
        }
        /**
         * tenant id for azure account.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param tenantId the value to set
         * @return the dsl builder
         */
        default DataLakeEndpointConsumerBuilder tenantId(String tenantId) {
            doSetProperty("tenantId", tenantId);
            return this;
        }
        /**
         * Timeout for operation.
         * 
         * The option is a: &lt;code&gt;java.time.Duration&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param timeout the value to set
         * @return the dsl builder
         */
        default DataLakeEndpointConsumerBuilder timeout(
                java.time.Duration timeout) {
            doSetProperty("timeout", timeout);
            return this;
        }
        /**
         * Timeout for operation.
         * 
         * The option will be converted to a
         * &lt;code&gt;java.time.Duration&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param timeout the value to set
         * @return the dsl builder
         */
        default DataLakeEndpointConsumerBuilder timeout(String timeout) {
            doSetProperty("timeout", timeout);
            return this;
        }
        /**
         * umask permission for file.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param umask the value to set
         * @return the dsl builder
         */
        default DataLakeEndpointConsumerBuilder umask(String umask) {
            doSetProperty("umask", umask);
            return this;
        }
        /**
         * whether or not to use upn.
         * 
         * The option is a: &lt;code&gt;java.lang.Boolean&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param userPrincipalNameReturned the value to set
         * @return the dsl builder
         */
        default DataLakeEndpointConsumerBuilder userPrincipalNameReturned(
                Boolean userPrincipalNameReturned) {
            doSetProperty("userPrincipalNameReturned", userPrincipalNameReturned);
            return this;
        }
        /**
         * whether or not to use upn.
         * 
         * The option will be converted to a
         * &lt;code&gt;java.lang.Boolean&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param userPrincipalNameReturned the value to set
         * @return the dsl builder
         */
        default DataLakeEndpointConsumerBuilder userPrincipalNameReturned(
                String userPrincipalNameReturned) {
            doSetProperty("userPrincipalNameReturned", userPrincipalNameReturned);
            return this;
        }
        /**
         * If the polling consumer did not poll any files, you can enable this
         * option to send an empty message (no body) instead.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: false
         * Group: consumer
         * 
         * @param sendEmptyMessageWhenIdle the value to set
         * @return the dsl builder
         */
        default DataLakeEndpointConsumerBuilder sendEmptyMessageWhenIdle(
                boolean sendEmptyMessageWhenIdle) {
            doSetProperty("sendEmptyMessageWhenIdle", sendEmptyMessageWhenIdle);
            return this;
        }
        /**
         * If the polling consumer did not poll any files, you can enable this
         * option to send an empty message (no body) instead.
         * 
         * The option will be converted to a &lt;code&gt;boolean&lt;/code&gt;
         * type.
         * 
         * Default: false
         * Group: consumer
         * 
         * @param sendEmptyMessageWhenIdle the value to set
         * @return the dsl builder
         */
        default DataLakeEndpointConsumerBuilder sendEmptyMessageWhenIdle(
                String sendEmptyMessageWhenIdle) {
            doSetProperty("sendEmptyMessageWhenIdle", sendEmptyMessageWhenIdle);
            return this;
        }
        /**
         * The number of subsequent error polls (failed due some error) that
         * should happen before the backoffMultipler should kick-in.
         * 
         * The option is a: &lt;code&gt;int&lt;/code&gt; type.
         * 
         * Group: scheduler
         * 
         * @param backoffErrorThreshold the value to set
         * @return the dsl builder
         */
        default DataLakeEndpointConsumerBuilder backoffErrorThreshold(
                int backoffErrorThreshold) {
            doSetProperty("backoffErrorThreshold", backoffErrorThreshold);
            return this;
        }
        /**
         * The number of subsequent error polls (failed due some error) that
         * should happen before the backoffMultipler should kick-in.
         * 
         * The option will be converted to a &lt;code&gt;int&lt;/code&gt; type.
         * 
         * Group: scheduler
         * 
         * @param backoffErrorThreshold the value to set
         * @return the dsl builder
         */
        default DataLakeEndpointConsumerBuilder backoffErrorThreshold(
                String backoffErrorThreshold) {
            doSetProperty("backoffErrorThreshold", backoffErrorThreshold);
            return this;
        }
        /**
         * The number of subsequent idle polls that should happen before the
         * backoffMultipler should kick-in.
         * 
         * The option is a: &lt;code&gt;int&lt;/code&gt; type.
         * 
         * Group: scheduler
         * 
         * @param backoffIdleThreshold the value to set
         * @return the dsl builder
         */
        default DataLakeEndpointConsumerBuilder backoffIdleThreshold(
                int backoffIdleThreshold) {
            doSetProperty("backoffIdleThreshold", backoffIdleThreshold);
            return this;
        }
        /**
         * The number of subsequent idle polls that should happen before the
         * backoffMultipler should kick-in.
         * 
         * The option will be converted to a &lt;code&gt;int&lt;/code&gt; type.
         * 
         * Group: scheduler
         * 
         * @param backoffIdleThreshold the value to set
         * @return the dsl builder
         */
        default DataLakeEndpointConsumerBuilder backoffIdleThreshold(
                String backoffIdleThreshold) {
            doSetProperty("backoffIdleThreshold", backoffIdleThreshold);
            return this;
        }
        /**
         * To let the scheduled polling consumer backoff if there has been a
         * number of subsequent idles/errors in a row. The multiplier is then
         * the number of polls that will be skipped before the next actual
         * attempt is happening again. When this option is in use then
         * backoffIdleThreshold and/or backoffErrorThreshold must also be
         * configured.
         * 
         * The option is a: &lt;code&gt;int&lt;/code&gt; type.
         * 
         * Group: scheduler
         * 
         * @param backoffMultiplier the value to set
         * @return the dsl builder
         */
        default DataLakeEndpointConsumerBuilder backoffMultiplier(
                int backoffMultiplier) {
            doSetProperty("backoffMultiplier", backoffMultiplier);
            return this;
        }
        /**
         * To let the scheduled polling consumer backoff if there has been a
         * number of subsequent idles/errors in a row. The multiplier is then
         * the number of polls that will be skipped before the next actual
         * attempt is happening again. When this option is in use then
         * backoffIdleThreshold and/or backoffErrorThreshold must also be
         * configured.
         * 
         * The option will be converted to a &lt;code&gt;int&lt;/code&gt; type.
         * 
         * Group: scheduler
         * 
         * @param backoffMultiplier the value to set
         * @return the dsl builder
         */
        default DataLakeEndpointConsumerBuilder backoffMultiplier(
                String backoffMultiplier) {
            doSetProperty("backoffMultiplier", backoffMultiplier);
            return this;
        }
        /**
         * Milliseconds before the next poll.
         * 
         * The option is a: &lt;code&gt;long&lt;/code&gt; type.
         * 
         * Default: 500
         * Group: scheduler
         * 
         * @param delay the value to set
         * @return the dsl builder
         */
        default DataLakeEndpointConsumerBuilder delay(long delay) {
            doSetProperty("delay", delay);
            return this;
        }
        /**
         * Milliseconds before the next poll.
         * 
         * The option will be converted to a &lt;code&gt;long&lt;/code&gt; type.
         * 
         * Default: 500
         * Group: scheduler
         * 
         * @param delay the value to set
         * @return the dsl builder
         */
        default DataLakeEndpointConsumerBuilder delay(String delay) {
            doSetProperty("delay", delay);
            return this;
        }
        /**
         * If greedy is enabled, then the ScheduledPollConsumer will run
         * immediately again, if the previous run polled 1 or more messages.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: false
         * Group: scheduler
         * 
         * @param greedy the value to set
         * @return the dsl builder
         */
        default DataLakeEndpointConsumerBuilder greedy(boolean greedy) {
            doSetProperty("greedy", greedy);
            return this;
        }
        /**
         * If greedy is enabled, then the ScheduledPollConsumer will run
         * immediately again, if the previous run polled 1 or more messages.
         * 
         * The option will be converted to a &lt;code&gt;boolean&lt;/code&gt;
         * type.
         * 
         * Default: false
         * Group: scheduler
         * 
         * @param greedy the value to set
         * @return the dsl builder
         */
        default DataLakeEndpointConsumerBuilder greedy(String greedy) {
            doSetProperty("greedy", greedy);
            return this;
        }
        /**
         * Milliseconds before the first poll starts.
         * 
         * The option is a: &lt;code&gt;long&lt;/code&gt; type.
         * 
         * Default: 1000
         * Group: scheduler
         * 
         * @param initialDelay the value to set
         * @return the dsl builder
         */
        default DataLakeEndpointConsumerBuilder initialDelay(long initialDelay) {
            doSetProperty("initialDelay", initialDelay);
            return this;
        }
        /**
         * Milliseconds before the first poll starts.
         * 
         * The option will be converted to a &lt;code&gt;long&lt;/code&gt; type.
         * 
         * Default: 1000
         * Group: scheduler
         * 
         * @param initialDelay the value to set
         * @return the dsl builder
         */
        default DataLakeEndpointConsumerBuilder initialDelay(String initialDelay) {
            doSetProperty("initialDelay", initialDelay);
            return this;
        }
        /**
         * Specifies a maximum limit of number of fires. So if you set it to 1,
         * the scheduler will only fire once. If you set it to 5, it will only
         * fire five times. A value of zero or negative means fire forever.
         * 
         * The option is a: &lt;code&gt;long&lt;/code&gt; type.
         * 
         * Default: 0
         * Group: scheduler
         * 
         * @param repeatCount the value to set
         * @return the dsl builder
         */
        default DataLakeEndpointConsumerBuilder repeatCount(long repeatCount) {
            doSetProperty("repeatCount", repeatCount);
            return this;
        }
        /**
         * Specifies a maximum limit of number of fires. So if you set it to 1,
         * the scheduler will only fire once. If you set it to 5, it will only
         * fire five times. A value of zero or negative means fire forever.
         * 
         * The option will be converted to a &lt;code&gt;long&lt;/code&gt; type.
         * 
         * Default: 0
         * Group: scheduler
         * 
         * @param repeatCount the value to set
         * @return the dsl builder
         */
        default DataLakeEndpointConsumerBuilder repeatCount(String repeatCount) {
            doSetProperty("repeatCount", repeatCount);
            return this;
        }
        /**
         * The consumer logs a start/complete log line when it polls. This
         * option allows you to configure the logging level for that.
         * 
         * The option is a:
         * &lt;code&gt;org.apache.camel.LoggingLevel&lt;/code&gt; type.
         * 
         * Default: TRACE
         * Group: scheduler
         * 
         * @param runLoggingLevel the value to set
         * @return the dsl builder
         */
        default DataLakeEndpointConsumerBuilder runLoggingLevel(
                org.apache.camel.LoggingLevel runLoggingLevel) {
            doSetProperty("runLoggingLevel", runLoggingLevel);
            return this;
        }
        /**
         * The consumer logs a start/complete log line when it polls. This
         * option allows you to configure the logging level for that.
         * 
         * The option will be converted to a
         * &lt;code&gt;org.apache.camel.LoggingLevel&lt;/code&gt; type.
         * 
         * Default: TRACE
         * Group: scheduler
         * 
         * @param runLoggingLevel the value to set
         * @return the dsl builder
         */
        default DataLakeEndpointConsumerBuilder runLoggingLevel(
                String runLoggingLevel) {
            doSetProperty("runLoggingLevel", runLoggingLevel);
            return this;
        }
        /**
         * Allows for configuring a custom/shared thread pool to use for the
         * consumer. By default each consumer has its own single threaded thread
         * pool.
         * 
         * The option is a:
         * &lt;code&gt;java.util.concurrent.ScheduledExecutorService&lt;/code&gt; type.
         * 
         * Group: scheduler
         * 
         * @param scheduledExecutorService the value to set
         * @return the dsl builder
         */
        default DataLakeEndpointConsumerBuilder scheduledExecutorService(
                ScheduledExecutorService scheduledExecutorService) {
            doSetProperty("scheduledExecutorService", scheduledExecutorService);
            return this;
        }
        /**
         * Allows for configuring a custom/shared thread pool to use for the
         * consumer. By default each consumer has its own single threaded thread
         * pool.
         * 
         * The option will be converted to a
         * &lt;code&gt;java.util.concurrent.ScheduledExecutorService&lt;/code&gt; type.
         * 
         * Group: scheduler
         * 
         * @param scheduledExecutorService the value to set
         * @return the dsl builder
         */
        default DataLakeEndpointConsumerBuilder scheduledExecutorService(
                String scheduledExecutorService) {
            doSetProperty("scheduledExecutorService", scheduledExecutorService);
            return this;
        }
        /**
         * To use a cron scheduler from either camel-spring or camel-quartz
         * component. Use value spring or quartz for built in scheduler.
         * 
         * The option is a: &lt;code&gt;java.lang.Object&lt;/code&gt; type.
         * 
         * Default: none
         * Group: scheduler
         * 
         * @param scheduler the value to set
         * @return the dsl builder
         */
        default DataLakeEndpointConsumerBuilder scheduler(Object scheduler) {
            doSetProperty("scheduler", scheduler);
            return this;
        }
        /**
         * To use a cron scheduler from either camel-spring or camel-quartz
         * component. Use value spring or quartz for built in scheduler.
         * 
         * The option will be converted to a
         * &lt;code&gt;java.lang.Object&lt;/code&gt; type.
         * 
         * Default: none
         * Group: scheduler
         * 
         * @param scheduler the value to set
         * @return the dsl builder
         */
        default DataLakeEndpointConsumerBuilder scheduler(String scheduler) {
            doSetProperty("scheduler", scheduler);
            return this;
        }
        /**
         * To configure additional properties when using a custom scheduler or
         * any of the Quartz, Spring based scheduler.
         * 
         * The option is a: &lt;code&gt;java.util.Map&amp;lt;java.lang.String,
         * java.lang.Object&amp;gt;&lt;/code&gt; type.
         * The option is multivalued, and you can use the
         * schedulerProperties(String, Object) method to add a value (call the
         * method multiple times to set more values).
         * 
         * Group: scheduler
         * 
         * @param key the option key
         * @param value the option value
         * @return the dsl builder
         */
        default DataLakeEndpointConsumerBuilder schedulerProperties(
                String key,
                Object value) {
            doSetMultiValueProperty("schedulerProperties", "scheduler." + key, value);
            return this;
        }
        /**
         * To configure additional properties when using a custom scheduler or
         * any of the Quartz, Spring based scheduler.
         * 
         * The option is a: &lt;code&gt;java.util.Map&amp;lt;java.lang.String,
         * java.lang.Object&amp;gt;&lt;/code&gt; type.
         * The option is multivalued, and you can use the
         * schedulerProperties(String, Object) method to add a value (call the
         * method multiple times to set more values).
         * 
         * Group: scheduler
         * 
         * @param values the values
         * @return the dsl builder
         */
        default DataLakeEndpointConsumerBuilder schedulerProperties(Map values) {
            doSetMultiValueProperties("schedulerProperties", "scheduler.", values);
            return this;
        }
        /**
         * Whether the scheduler should be auto started.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: true
         * Group: scheduler
         * 
         * @param startScheduler the value to set
         * @return the dsl builder
         */
        default DataLakeEndpointConsumerBuilder startScheduler(
                boolean startScheduler) {
            doSetProperty("startScheduler", startScheduler);
            return this;
        }
        /**
         * Whether the scheduler should be auto started.
         * 
         * The option will be converted to a &lt;code&gt;boolean&lt;/code&gt;
         * type.
         * 
         * Default: true
         * Group: scheduler
         * 
         * @param startScheduler the value to set
         * @return the dsl builder
         */
        default DataLakeEndpointConsumerBuilder startScheduler(
                String startScheduler) {
            doSetProperty("startScheduler", startScheduler);
            return this;
        }
        /**
         * Time unit for initialDelay and delay options.
         * 
         * The option is a:
         * &lt;code&gt;java.util.concurrent.TimeUnit&lt;/code&gt; type.
         * 
         * Default: MILLISECONDS
         * Group: scheduler
         * 
         * @param timeUnit the value to set
         * @return the dsl builder
         */
        default DataLakeEndpointConsumerBuilder timeUnit(TimeUnit timeUnit) {
            doSetProperty("timeUnit", timeUnit);
            return this;
        }
        /**
         * Time unit for initialDelay and delay options.
         * 
         * The option will be converted to a
         * &lt;code&gt;java.util.concurrent.TimeUnit&lt;/code&gt; type.
         * 
         * Default: MILLISECONDS
         * Group: scheduler
         * 
         * @param timeUnit the value to set
         * @return the dsl builder
         */
        default DataLakeEndpointConsumerBuilder timeUnit(String timeUnit) {
            doSetProperty("timeUnit", timeUnit);
            return this;
        }
        /**
         * Controls if fixed delay or fixed rate is used. See
         * ScheduledExecutorService in JDK for details.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: true
         * Group: scheduler
         * 
         * @param useFixedDelay the value to set
         * @return the dsl builder
         */
        default DataLakeEndpointConsumerBuilder useFixedDelay(
                boolean useFixedDelay) {
            doSetProperty("useFixedDelay", useFixedDelay);
            return this;
        }
        /**
         * Controls if fixed delay or fixed rate is used. See
         * ScheduledExecutorService in JDK for details.
         * 
         * The option will be converted to a &lt;code&gt;boolean&lt;/code&gt;
         * type.
         * 
         * Default: true
         * Group: scheduler
         * 
         * @param useFixedDelay the value to set
         * @return the dsl builder
         */
        default DataLakeEndpointConsumerBuilder useFixedDelay(
                String useFixedDelay) {
            doSetProperty("useFixedDelay", useFixedDelay);
            return this;
        }
        /**
         * account key for authentication.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: security
         * 
         * @param accountKey the value to set
         * @return the dsl builder
         */
        default DataLakeEndpointConsumerBuilder accountKey(String accountKey) {
            doSetProperty("accountKey", accountKey);
            return this;
        }
        /**
         * client secret for azure account.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: security
         * 
         * @param clientSecret the value to set
         * @return the dsl builder
         */
        default DataLakeEndpointConsumerBuilder clientSecret(String clientSecret) {
            doSetProperty("clientSecret", clientSecret);
            return this;
        }
        /**
         * client secret credential for authentication.
         * 
         * The option is a:
         * &lt;code&gt;com.azure.identity.ClientSecretCredential&lt;/code&gt;
         * type.
         * 
         * Group: security
         * 
         * @param clientSecretCredential the value to set
         * @return the dsl builder
         */
        default DataLakeEndpointConsumerBuilder clientSecretCredential(
                com.azure.identity.ClientSecretCredential clientSecretCredential) {
            doSetProperty("clientSecretCredential", clientSecretCredential);
            return this;
        }
        /**
         * client secret credential for authentication.
         * 
         * The option will be converted to a
         * &lt;code&gt;com.azure.identity.ClientSecretCredential&lt;/code&gt;
         * type.
         * 
         * Group: security
         * 
         * @param clientSecretCredential the value to set
         * @return the dsl builder
         */
        default DataLakeEndpointConsumerBuilder clientSecretCredential(
                String clientSecretCredential) {
            doSetProperty("clientSecretCredential", clientSecretCredential);
            return this;
        }
        /**
         * SAS token credential.
         * 
         * The option is a:
         * &lt;code&gt;com.azure.core.credential.AzureSasCredential&lt;/code&gt;
         * type.
         * 
         * Group: security
         * 
         * @param sasCredential the value to set
         * @return the dsl builder
         */
        default DataLakeEndpointConsumerBuilder sasCredential(
                com.azure.core.credential.AzureSasCredential sasCredential) {
            doSetProperty("sasCredential", sasCredential);
            return this;
        }
        /**
         * SAS token credential.
         * 
         * The option will be converted to a
         * &lt;code&gt;com.azure.core.credential.AzureSasCredential&lt;/code&gt;
         * type.
         * 
         * Group: security
         * 
         * @param sasCredential the value to set
         * @return the dsl builder
         */
        default DataLakeEndpointConsumerBuilder sasCredential(
                String sasCredential) {
            doSetProperty("sasCredential", sasCredential);
            return this;
        }
        /**
         * SAS token signature.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: security
         * 
         * @param sasSignature the value to set
         * @return the dsl builder
         */
        default DataLakeEndpointConsumerBuilder sasSignature(String sasSignature) {
            doSetProperty("sasSignature", sasSignature);
            return this;
        }
        /**
         * Use default identity.
         * 
         * The option is a: &lt;code&gt;java.lang.Boolean&lt;/code&gt; type.
         * 
         * Group: security
         * 
         * @param useDefaultIdentity the value to set
         * @return the dsl builder
         */
        default DataLakeEndpointConsumerBuilder useDefaultIdentity(
                Boolean useDefaultIdentity) {
            doSetProperty("useDefaultIdentity", useDefaultIdentity);
            return this;
        }
        /**
         * Use default identity.
         * 
         * The option will be converted to a
         * &lt;code&gt;java.lang.Boolean&lt;/code&gt; type.
         * 
         * Group: security
         * 
         * @param useDefaultIdentity the value to set
         * @return the dsl builder
         */
        default DataLakeEndpointConsumerBuilder useDefaultIdentity(
                String useDefaultIdentity) {
            doSetProperty("useDefaultIdentity", useDefaultIdentity);
            return this;
        }
    }

    /**
     * Advanced builder for endpoint consumers for the Azure Storage Datalake
     * Service component.
     */
    public interface AdvancedDataLakeEndpointConsumerBuilder
            extends
                EndpointConsumerBuilder {
        default DataLakeEndpointConsumerBuilder basic() {
            return (DataLakeEndpointConsumerBuilder) this;
        }
        /**
         * Allows for bridging the consumer to the Camel routing Error Handler,
         * which mean any exceptions occurred while the consumer is trying to
         * pickup incoming messages, or the likes, will now be processed as a
         * message and handled by the routing Error Handler. By default the
         * consumer will use the org.apache.camel.spi.ExceptionHandler to deal
         * with exceptions, that will be logged at WARN or ERROR level and
         * ignored.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: false
         * Group: consumer (advanced)
         * 
         * @param bridgeErrorHandler the value to set
         * @return the dsl builder
         */
        default AdvancedDataLakeEndpointConsumerBuilder bridgeErrorHandler(
                boolean bridgeErrorHandler) {
            doSetProperty("bridgeErrorHandler", bridgeErrorHandler);
            return this;
        }
        /**
         * Allows for bridging the consumer to the Camel routing Error Handler,
         * which mean any exceptions occurred while the consumer is trying to
         * pickup incoming messages, or the likes, will now be processed as a
         * message and handled by the routing Error Handler. By default the
         * consumer will use the org.apache.camel.spi.ExceptionHandler to deal
         * with exceptions, that will be logged at WARN or ERROR level and
         * ignored.
         * 
         * The option will be converted to a &lt;code&gt;boolean&lt;/code&gt;
         * type.
         * 
         * Default: false
         * Group: consumer (advanced)
         * 
         * @param bridgeErrorHandler the value to set
         * @return the dsl builder
         */
        default AdvancedDataLakeEndpointConsumerBuilder bridgeErrorHandler(
                String bridgeErrorHandler) {
            doSetProperty("bridgeErrorHandler", bridgeErrorHandler);
            return this;
        }
        /**
         * To let the consumer use a custom ExceptionHandler. Notice if the
         * option bridgeErrorHandler is enabled then this option is not in use.
         * By default the consumer will deal with exceptions, that will be
         * logged at WARN or ERROR level and ignored.
         * 
         * The option is a:
         * &lt;code&gt;org.apache.camel.spi.ExceptionHandler&lt;/code&gt; type.
         * 
         * Group: consumer (advanced)
         * 
         * @param exceptionHandler the value to set
         * @return the dsl builder
         */
        default AdvancedDataLakeEndpointConsumerBuilder exceptionHandler(
                org.apache.camel.spi.ExceptionHandler exceptionHandler) {
            doSetProperty("exceptionHandler", exceptionHandler);
            return this;
        }
        /**
         * To let the consumer use a custom ExceptionHandler. Notice if the
         * option bridgeErrorHandler is enabled then this option is not in use.
         * By default the consumer will deal with exceptions, that will be
         * logged at WARN or ERROR level and ignored.
         * 
         * The option will be converted to a
         * &lt;code&gt;org.apache.camel.spi.ExceptionHandler&lt;/code&gt; type.
         * 
         * Group: consumer (advanced)
         * 
         * @param exceptionHandler the value to set
         * @return the dsl builder
         */
        default AdvancedDataLakeEndpointConsumerBuilder exceptionHandler(
                String exceptionHandler) {
            doSetProperty("exceptionHandler", exceptionHandler);
            return this;
        }
        /**
         * Sets the exchange pattern when the consumer creates an exchange.
         * 
         * The option is a:
         * &lt;code&gt;org.apache.camel.ExchangePattern&lt;/code&gt; type.
         * 
         * Group: consumer (advanced)
         * 
         * @param exchangePattern the value to set
         * @return the dsl builder
         */
        default AdvancedDataLakeEndpointConsumerBuilder exchangePattern(
                org.apache.camel.ExchangePattern exchangePattern) {
            doSetProperty("exchangePattern", exchangePattern);
            return this;
        }
        /**
         * Sets the exchange pattern when the consumer creates an exchange.
         * 
         * The option will be converted to a
         * &lt;code&gt;org.apache.camel.ExchangePattern&lt;/code&gt; type.
         * 
         * Group: consumer (advanced)
         * 
         * @param exchangePattern the value to set
         * @return the dsl builder
         */
        default AdvancedDataLakeEndpointConsumerBuilder exchangePattern(
                String exchangePattern) {
            doSetProperty("exchangePattern", exchangePattern);
            return this;
        }
        /**
         * A pluggable org.apache.camel.PollingConsumerPollingStrategy allowing
         * you to provide your custom implementation to control error handling
         * usually occurred during the poll operation before an Exchange have
         * been created and being routed in Camel.
         * 
         * The option is a:
         * &lt;code&gt;org.apache.camel.spi.PollingConsumerPollStrategy&lt;/code&gt; type.
         * 
         * Group: consumer (advanced)
         * 
         * @param pollStrategy the value to set
         * @return the dsl builder
         */
        default AdvancedDataLakeEndpointConsumerBuilder pollStrategy(
                org.apache.camel.spi.PollingConsumerPollStrategy pollStrategy) {
            doSetProperty("pollStrategy", pollStrategy);
            return this;
        }
        /**
         * A pluggable org.apache.camel.PollingConsumerPollingStrategy allowing
         * you to provide your custom implementation to control error handling
         * usually occurred during the poll operation before an Exchange have
         * been created and being routed in Camel.
         * 
         * The option will be converted to a
         * &lt;code&gt;org.apache.camel.spi.PollingConsumerPollStrategy&lt;/code&gt; type.
         * 
         * Group: consumer (advanced)
         * 
         * @param pollStrategy the value to set
         * @return the dsl builder
         */
        default AdvancedDataLakeEndpointConsumerBuilder pollStrategy(
                String pollStrategy) {
            doSetProperty("pollStrategy", pollStrategy);
            return this;
        }
    }

    /**
     * Builder for endpoint producers for the Azure Storage Datalake Service
     * component.
     */
    public interface DataLakeEndpointProducerBuilder
            extends
                EndpointProducerBuilder {
        default AdvancedDataLakeEndpointProducerBuilder advanced() {
            return (AdvancedDataLakeEndpointProducerBuilder) this;
        }
        /**
         * client id for azure account.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param clientId the value to set
         * @return the dsl builder
         */
        default DataLakeEndpointProducerBuilder clientId(String clientId) {
            doSetProperty("clientId", clientId);
            return this;
        }
        /**
         * Whether or not a file changed event raised indicates completion
         * (true) or modification (false).
         * 
         * The option is a: &lt;code&gt;java.lang.Boolean&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param close the value to set
         * @return the dsl builder
         */
        default DataLakeEndpointProducerBuilder close(Boolean close) {
            doSetProperty("close", close);
            return this;
        }
        /**
         * Whether or not a file changed event raised indicates completion
         * (true) or modification (false).
         * 
         * The option will be converted to a
         * &lt;code&gt;java.lang.Boolean&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param close the value to set
         * @return the dsl builder
         */
        default DataLakeEndpointProducerBuilder close(String close) {
            doSetProperty("close", close);
            return this;
        }
        /**
         * check for closing stream after read.
         * 
         * The option is a: &lt;code&gt;java.lang.Boolean&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param closeStreamAfterRead the value to set
         * @return the dsl builder
         */
        default DataLakeEndpointProducerBuilder closeStreamAfterRead(
                Boolean closeStreamAfterRead) {
            doSetProperty("closeStreamAfterRead", closeStreamAfterRead);
            return this;
        }
        /**
         * check for closing stream after read.
         * 
         * The option will be converted to a
         * &lt;code&gt;java.lang.Boolean&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param closeStreamAfterRead the value to set
         * @return the dsl builder
         */
        default DataLakeEndpointProducerBuilder closeStreamAfterRead(
                String closeStreamAfterRead) {
            doSetProperty("closeStreamAfterRead", closeStreamAfterRead);
            return this;
        }
        /**
         * count number of bytes to download.
         * 
         * The option is a: &lt;code&gt;java.lang.Long&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param dataCount the value to set
         * @return the dsl builder
         */
        default DataLakeEndpointProducerBuilder dataCount(Long dataCount) {
            doSetProperty("dataCount", dataCount);
            return this;
        }
        /**
         * count number of bytes to download.
         * 
         * The option will be converted to a
         * &lt;code&gt;java.lang.Long&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param dataCount the value to set
         * @return the dsl builder
         */
        default DataLakeEndpointProducerBuilder dataCount(String dataCount) {
            doSetProperty("dataCount", dataCount);
            return this;
        }
        /**
         * service client of datalake.
         * 
         * The option is a:
         * &lt;code&gt;com.azure.storage.file.datalake.DataLakeServiceClient&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param dataLakeServiceClient the value to set
         * @return the dsl builder
         */
        default DataLakeEndpointProducerBuilder dataLakeServiceClient(
                com.azure.storage.file.datalake.DataLakeServiceClient dataLakeServiceClient) {
            doSetProperty("dataLakeServiceClient", dataLakeServiceClient);
            return this;
        }
        /**
         * service client of datalake.
         * 
         * The option will be converted to a
         * &lt;code&gt;com.azure.storage.file.datalake.DataLakeServiceClient&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param dataLakeServiceClient the value to set
         * @return the dsl builder
         */
        default DataLakeEndpointProducerBuilder dataLakeServiceClient(
                String dataLakeServiceClient) {
            doSetProperty("dataLakeServiceClient", dataLakeServiceClient);
            return this;
        }
        /**
         * directory of the file to be handled in component.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param directoryName the value to set
         * @return the dsl builder
         */
        default DataLakeEndpointProducerBuilder directoryName(
                String directoryName) {
            doSetProperty("directoryName", directoryName);
            return this;
        }
        /**
         * download link expiration time.
         * 
         * The option is a: &lt;code&gt;java.lang.Long&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param downloadLinkExpiration the value to set
         * @return the dsl builder
         */
        default DataLakeEndpointProducerBuilder downloadLinkExpiration(
                Long downloadLinkExpiration) {
            doSetProperty("downloadLinkExpiration", downloadLinkExpiration);
            return this;
        }
        /**
         * download link expiration time.
         * 
         * The option will be converted to a
         * &lt;code&gt;java.lang.Long&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param downloadLinkExpiration the value to set
         * @return the dsl builder
         */
        default DataLakeEndpointProducerBuilder downloadLinkExpiration(
                String downloadLinkExpiration) {
            doSetProperty("downloadLinkExpiration", downloadLinkExpiration);
            return this;
        }
        /**
         * expression for queryInputStream.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param expression the value to set
         * @return the dsl builder
         */
        default DataLakeEndpointProducerBuilder expression(String expression) {
            doSetProperty("expression", expression);
            return this;
        }
        /**
         * directory of file to do operations in the local system.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param fileDir the value to set
         * @return the dsl builder
         */
        default DataLakeEndpointProducerBuilder fileDir(String fileDir) {
            doSetProperty("fileDir", fileDir);
            return this;
        }
        /**
         * name of file to be handled in component.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param fileName the value to set
         * @return the dsl builder
         */
        default DataLakeEndpointProducerBuilder fileName(String fileName) {
            doSetProperty("fileName", fileName);
            return this;
        }
        /**
         * offset position in file for different operations.
         * 
         * The option is a: &lt;code&gt;java.lang.Long&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param fileOffset the value to set
         * @return the dsl builder
         */
        default DataLakeEndpointProducerBuilder fileOffset(Long fileOffset) {
            doSetProperty("fileOffset", fileOffset);
            return this;
        }
        /**
         * offset position in file for different operations.
         * 
         * The option will be converted to a
         * &lt;code&gt;java.lang.Long&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param fileOffset the value to set
         * @return the dsl builder
         */
        default DataLakeEndpointProducerBuilder fileOffset(String fileOffset) {
            doSetProperty("fileOffset", fileOffset);
            return this;
        }
        /**
         * maximum number of results to show at a time.
         * 
         * The option is a: &lt;code&gt;java.lang.Integer&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param maxResults the value to set
         * @return the dsl builder
         */
        default DataLakeEndpointProducerBuilder maxResults(Integer maxResults) {
            doSetProperty("maxResults", maxResults);
            return this;
        }
        /**
         * maximum number of results to show at a time.
         * 
         * The option will be converted to a
         * &lt;code&gt;java.lang.Integer&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param maxResults the value to set
         * @return the dsl builder
         */
        default DataLakeEndpointProducerBuilder maxResults(String maxResults) {
            doSetProperty("maxResults", maxResults);
            return this;
        }
        /**
         * no of retries to a given request.
         * 
         * The option is a: &lt;code&gt;int&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param maxRetryRequests the value to set
         * @return the dsl builder
         */
        default DataLakeEndpointProducerBuilder maxRetryRequests(
                int maxRetryRequests) {
            doSetProperty("maxRetryRequests", maxRetryRequests);
            return this;
        }
        /**
         * no of retries to a given request.
         * 
         * The option will be converted to a &lt;code&gt;int&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param maxRetryRequests the value to set
         * @return the dsl builder
         */
        default DataLakeEndpointProducerBuilder maxRetryRequests(
                String maxRetryRequests) {
            doSetProperty("maxRetryRequests", maxRetryRequests);
            return this;
        }
        /**
         * set open options for creating file.
         * 
         * The option is a:
         * &lt;code&gt;java.util.Set&amp;lt;java.nio.file.OpenOption&amp;gt;&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param openOptions the value to set
         * @return the dsl builder
         */
        default DataLakeEndpointProducerBuilder openOptions(
                Set<java.nio.file.OpenOption> openOptions) {
            doSetProperty("openOptions", openOptions);
            return this;
        }
        /**
         * set open options for creating file.
         * 
         * The option will be converted to a
         * &lt;code&gt;java.util.Set&amp;lt;java.nio.file.OpenOption&amp;gt;&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param openOptions the value to set
         * @return the dsl builder
         */
        default DataLakeEndpointProducerBuilder openOptions(String openOptions) {
            doSetProperty("openOptions", openOptions);
            return this;
        }
        /**
         * path in azure datalake for operations.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param path the value to set
         * @return the dsl builder
         */
        default DataLakeEndpointProducerBuilder path(String path) {
            doSetProperty("path", path);
            return this;
        }
        /**
         * permission string for the file.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param permission the value to set
         * @return the dsl builder
         */
        default DataLakeEndpointProducerBuilder permission(String permission) {
            doSetProperty("permission", permission);
            return this;
        }
        /**
         * This parameter allows the caller to upload data in parallel and
         * control the order in which it is appended to the file.
         * 
         * The option is a: &lt;code&gt;java.lang.Long&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param position the value to set
         * @return the dsl builder
         */
        default DataLakeEndpointProducerBuilder position(Long position) {
            doSetProperty("position", position);
            return this;
        }
        /**
         * This parameter allows the caller to upload data in parallel and
         * control the order in which it is appended to the file.
         * 
         * The option will be converted to a
         * &lt;code&gt;java.lang.Long&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param position the value to set
         * @return the dsl builder
         */
        default DataLakeEndpointProducerBuilder position(String position) {
            doSetProperty("position", position);
            return this;
        }
        /**
         * recursively include all paths.
         * 
         * The option is a: &lt;code&gt;java.lang.Boolean&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param recursive the value to set
         * @return the dsl builder
         */
        default DataLakeEndpointProducerBuilder recursive(Boolean recursive) {
            doSetProperty("recursive", recursive);
            return this;
        }
        /**
         * recursively include all paths.
         * 
         * The option will be converted to a
         * &lt;code&gt;java.lang.Boolean&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param recursive the value to set
         * @return the dsl builder
         */
        default DataLakeEndpointProducerBuilder recursive(String recursive) {
            doSetProperty("recursive", recursive);
            return this;
        }
        /**
         * regular expression for matching file names.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param regex the value to set
         * @return the dsl builder
         */
        default DataLakeEndpointProducerBuilder regex(String regex) {
            doSetProperty("regex", regex);
            return this;
        }
        /**
         * Whether or not uncommitted data is to be retained after the
         * operation.
         * 
         * The option is a: &lt;code&gt;java.lang.Boolean&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param retainUncommitedData the value to set
         * @return the dsl builder
         */
        default DataLakeEndpointProducerBuilder retainUncommitedData(
                Boolean retainUncommitedData) {
            doSetProperty("retainUncommitedData", retainUncommitedData);
            return this;
        }
        /**
         * Whether or not uncommitted data is to be retained after the
         * operation.
         * 
         * The option will be converted to a
         * &lt;code&gt;java.lang.Boolean&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param retainUncommitedData the value to set
         * @return the dsl builder
         */
        default DataLakeEndpointProducerBuilder retainUncommitedData(
                String retainUncommitedData) {
            doSetProperty("retainUncommitedData", retainUncommitedData);
            return this;
        }
        /**
         * datalake service client for azure storage datalake.
         * 
         * The option is a:
         * &lt;code&gt;com.azure.storage.file.datalake.DataLakeServiceClient&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param serviceClient the value to set
         * @return the dsl builder
         */
        default DataLakeEndpointProducerBuilder serviceClient(
                com.azure.storage.file.datalake.DataLakeServiceClient serviceClient) {
            doSetProperty("serviceClient", serviceClient);
            return this;
        }
        /**
         * datalake service client for azure storage datalake.
         * 
         * The option will be converted to a
         * &lt;code&gt;com.azure.storage.file.datalake.DataLakeServiceClient&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param serviceClient the value to set
         * @return the dsl builder
         */
        default DataLakeEndpointProducerBuilder serviceClient(
                String serviceClient) {
            doSetProperty("serviceClient", serviceClient);
            return this;
        }
        /**
         * shared key credential for azure datalake gen2.
         * 
         * The option is a:
         * &lt;code&gt;com.azure.storage.common.StorageSharedKeyCredential&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param sharedKeyCredential the value to set
         * @return the dsl builder
         */
        default DataLakeEndpointProducerBuilder sharedKeyCredential(
                com.azure.storage.common.StorageSharedKeyCredential sharedKeyCredential) {
            doSetProperty("sharedKeyCredential", sharedKeyCredential);
            return this;
        }
        /**
         * shared key credential for azure datalake gen2.
         * 
         * The option will be converted to a
         * &lt;code&gt;com.azure.storage.common.StorageSharedKeyCredential&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param sharedKeyCredential the value to set
         * @return the dsl builder
         */
        default DataLakeEndpointProducerBuilder sharedKeyCredential(
                String sharedKeyCredential) {
            doSetProperty("sharedKeyCredential", sharedKeyCredential);
            return this;
        }
        /**
         * tenant id for azure account.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param tenantId the value to set
         * @return the dsl builder
         */
        default DataLakeEndpointProducerBuilder tenantId(String tenantId) {
            doSetProperty("tenantId", tenantId);
            return this;
        }
        /**
         * Timeout for operation.
         * 
         * The option is a: &lt;code&gt;java.time.Duration&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param timeout the value to set
         * @return the dsl builder
         */
        default DataLakeEndpointProducerBuilder timeout(
                java.time.Duration timeout) {
            doSetProperty("timeout", timeout);
            return this;
        }
        /**
         * Timeout for operation.
         * 
         * The option will be converted to a
         * &lt;code&gt;java.time.Duration&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param timeout the value to set
         * @return the dsl builder
         */
        default DataLakeEndpointProducerBuilder timeout(String timeout) {
            doSetProperty("timeout", timeout);
            return this;
        }
        /**
         * umask permission for file.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param umask the value to set
         * @return the dsl builder
         */
        default DataLakeEndpointProducerBuilder umask(String umask) {
            doSetProperty("umask", umask);
            return this;
        }
        /**
         * whether or not to use upn.
         * 
         * The option is a: &lt;code&gt;java.lang.Boolean&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param userPrincipalNameReturned the value to set
         * @return the dsl builder
         */
        default DataLakeEndpointProducerBuilder userPrincipalNameReturned(
                Boolean userPrincipalNameReturned) {
            doSetProperty("userPrincipalNameReturned", userPrincipalNameReturned);
            return this;
        }
        /**
         * whether or not to use upn.
         * 
         * The option will be converted to a
         * &lt;code&gt;java.lang.Boolean&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param userPrincipalNameReturned the value to set
         * @return the dsl builder
         */
        default DataLakeEndpointProducerBuilder userPrincipalNameReturned(
                String userPrincipalNameReturned) {
            doSetProperty("userPrincipalNameReturned", userPrincipalNameReturned);
            return this;
        }
        /**
         * operation to be performed.
         * 
         * The option is a:
         * &lt;code&gt;org.apache.camel.component.azure.storage.datalake.DataLakeOperationsDefinition&lt;/code&gt; type.
         * 
         * Default: listFileSystem
         * Group: producer
         * 
         * @param operation the value to set
         * @return the dsl builder
         */
        default DataLakeEndpointProducerBuilder operation(
                org.apache.camel.component.azure.storage.datalake.DataLakeOperationsDefinition operation) {
            doSetProperty("operation", operation);
            return this;
        }
        /**
         * operation to be performed.
         * 
         * The option will be converted to a
         * &lt;code&gt;org.apache.camel.component.azure.storage.datalake.DataLakeOperationsDefinition&lt;/code&gt; type.
         * 
         * Default: listFileSystem
         * Group: producer
         * 
         * @param operation the value to set
         * @return the dsl builder
         */
        default DataLakeEndpointProducerBuilder operation(String operation) {
            doSetProperty("operation", operation);
            return this;
        }
        /**
         * account key for authentication.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: security
         * 
         * @param accountKey the value to set
         * @return the dsl builder
         */
        default DataLakeEndpointProducerBuilder accountKey(String accountKey) {
            doSetProperty("accountKey", accountKey);
            return this;
        }
        /**
         * client secret for azure account.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: security
         * 
         * @param clientSecret the value to set
         * @return the dsl builder
         */
        default DataLakeEndpointProducerBuilder clientSecret(String clientSecret) {
            doSetProperty("clientSecret", clientSecret);
            return this;
        }
        /**
         * client secret credential for authentication.
         * 
         * The option is a:
         * &lt;code&gt;com.azure.identity.ClientSecretCredential&lt;/code&gt;
         * type.
         * 
         * Group: security
         * 
         * @param clientSecretCredential the value to set
         * @return the dsl builder
         */
        default DataLakeEndpointProducerBuilder clientSecretCredential(
                com.azure.identity.ClientSecretCredential clientSecretCredential) {
            doSetProperty("clientSecretCredential", clientSecretCredential);
            return this;
        }
        /**
         * client secret credential for authentication.
         * 
         * The option will be converted to a
         * &lt;code&gt;com.azure.identity.ClientSecretCredential&lt;/code&gt;
         * type.
         * 
         * Group: security
         * 
         * @param clientSecretCredential the value to set
         * @return the dsl builder
         */
        default DataLakeEndpointProducerBuilder clientSecretCredential(
                String clientSecretCredential) {
            doSetProperty("clientSecretCredential", clientSecretCredential);
            return this;
        }
        /**
         * SAS token credential.
         * 
         * The option is a:
         * &lt;code&gt;com.azure.core.credential.AzureSasCredential&lt;/code&gt;
         * type.
         * 
         * Group: security
         * 
         * @param sasCredential the value to set
         * @return the dsl builder
         */
        default DataLakeEndpointProducerBuilder sasCredential(
                com.azure.core.credential.AzureSasCredential sasCredential) {
            doSetProperty("sasCredential", sasCredential);
            return this;
        }
        /**
         * SAS token credential.
         * 
         * The option will be converted to a
         * &lt;code&gt;com.azure.core.credential.AzureSasCredential&lt;/code&gt;
         * type.
         * 
         * Group: security
         * 
         * @param sasCredential the value to set
         * @return the dsl builder
         */
        default DataLakeEndpointProducerBuilder sasCredential(
                String sasCredential) {
            doSetProperty("sasCredential", sasCredential);
            return this;
        }
        /**
         * SAS token signature.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: security
         * 
         * @param sasSignature the value to set
         * @return the dsl builder
         */
        default DataLakeEndpointProducerBuilder sasSignature(String sasSignature) {
            doSetProperty("sasSignature", sasSignature);
            return this;
        }
        /**
         * Use default identity.
         * 
         * The option is a: &lt;code&gt;java.lang.Boolean&lt;/code&gt; type.
         * 
         * Group: security
         * 
         * @param useDefaultIdentity the value to set
         * @return the dsl builder
         */
        default DataLakeEndpointProducerBuilder useDefaultIdentity(
                Boolean useDefaultIdentity) {
            doSetProperty("useDefaultIdentity", useDefaultIdentity);
            return this;
        }
        /**
         * Use default identity.
         * 
         * The option will be converted to a
         * &lt;code&gt;java.lang.Boolean&lt;/code&gt; type.
         * 
         * Group: security
         * 
         * @param useDefaultIdentity the value to set
         * @return the dsl builder
         */
        default DataLakeEndpointProducerBuilder useDefaultIdentity(
                String useDefaultIdentity) {
            doSetProperty("useDefaultIdentity", useDefaultIdentity);
            return this;
        }
    }

    /**
     * Advanced builder for endpoint producers for the Azure Storage Datalake
     * Service component.
     */
    public interface AdvancedDataLakeEndpointProducerBuilder
            extends
                EndpointProducerBuilder {
        default DataLakeEndpointProducerBuilder basic() {
            return (DataLakeEndpointProducerBuilder) this;
        }
        /**
         * Whether the producer should be started lazy (on the first message).
         * By starting lazy you can use this to allow CamelContext and routes to
         * startup in situations where a producer may otherwise fail during
         * starting and cause the route to fail being started. By deferring this
         * startup to be lazy then the startup failure can be handled during
         * routing messages via Camel's routing error handlers. Beware that when
         * the first message is processed then creating and starting the
         * producer may take a little time and prolong the total processing time
         * of the processing.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: false
         * Group: producer (advanced)
         * 
         * @param lazyStartProducer the value to set
         * @return the dsl builder
         */
        default AdvancedDataLakeEndpointProducerBuilder lazyStartProducer(
                boolean lazyStartProducer) {
            doSetProperty("lazyStartProducer", lazyStartProducer);
            return this;
        }
        /**
         * Whether the producer should be started lazy (on the first message).
         * By starting lazy you can use this to allow CamelContext and routes to
         * startup in situations where a producer may otherwise fail during
         * starting and cause the route to fail being started. By deferring this
         * startup to be lazy then the startup failure can be handled during
         * routing messages via Camel's routing error handlers. Beware that when
         * the first message is processed then creating and starting the
         * producer may take a little time and prolong the total processing time
         * of the processing.
         * 
         * The option will be converted to a &lt;code&gt;boolean&lt;/code&gt;
         * type.
         * 
         * Default: false
         * Group: producer (advanced)
         * 
         * @param lazyStartProducer the value to set
         * @return the dsl builder
         */
        default AdvancedDataLakeEndpointProducerBuilder lazyStartProducer(
                String lazyStartProducer) {
            doSetProperty("lazyStartProducer", lazyStartProducer);
            return this;
        }
    }

    /**
     * Builder for endpoint for the Azure Storage Datalake Service component.
     */
    public interface DataLakeEndpointBuilder
            extends
                DataLakeEndpointConsumerBuilder,
                DataLakeEndpointProducerBuilder {
        default AdvancedDataLakeEndpointBuilder advanced() {
            return (AdvancedDataLakeEndpointBuilder) this;
        }
        /**
         * client id for azure account.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param clientId the value to set
         * @return the dsl builder
         */
        default DataLakeEndpointBuilder clientId(String clientId) {
            doSetProperty("clientId", clientId);
            return this;
        }
        /**
         * Whether or not a file changed event raised indicates completion
         * (true) or modification (false).
         * 
         * The option is a: &lt;code&gt;java.lang.Boolean&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param close the value to set
         * @return the dsl builder
         */
        default DataLakeEndpointBuilder close(Boolean close) {
            doSetProperty("close", close);
            return this;
        }
        /**
         * Whether or not a file changed event raised indicates completion
         * (true) or modification (false).
         * 
         * The option will be converted to a
         * &lt;code&gt;java.lang.Boolean&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param close the value to set
         * @return the dsl builder
         */
        default DataLakeEndpointBuilder close(String close) {
            doSetProperty("close", close);
            return this;
        }
        /**
         * check for closing stream after read.
         * 
         * The option is a: &lt;code&gt;java.lang.Boolean&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param closeStreamAfterRead the value to set
         * @return the dsl builder
         */
        default DataLakeEndpointBuilder closeStreamAfterRead(
                Boolean closeStreamAfterRead) {
            doSetProperty("closeStreamAfterRead", closeStreamAfterRead);
            return this;
        }
        /**
         * check for closing stream after read.
         * 
         * The option will be converted to a
         * &lt;code&gt;java.lang.Boolean&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param closeStreamAfterRead the value to set
         * @return the dsl builder
         */
        default DataLakeEndpointBuilder closeStreamAfterRead(
                String closeStreamAfterRead) {
            doSetProperty("closeStreamAfterRead", closeStreamAfterRead);
            return this;
        }
        /**
         * count number of bytes to download.
         * 
         * The option is a: &lt;code&gt;java.lang.Long&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param dataCount the value to set
         * @return the dsl builder
         */
        default DataLakeEndpointBuilder dataCount(Long dataCount) {
            doSetProperty("dataCount", dataCount);
            return this;
        }
        /**
         * count number of bytes to download.
         * 
         * The option will be converted to a
         * &lt;code&gt;java.lang.Long&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param dataCount the value to set
         * @return the dsl builder
         */
        default DataLakeEndpointBuilder dataCount(String dataCount) {
            doSetProperty("dataCount", dataCount);
            return this;
        }
        /**
         * service client of datalake.
         * 
         * The option is a:
         * &lt;code&gt;com.azure.storage.file.datalake.DataLakeServiceClient&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param dataLakeServiceClient the value to set
         * @return the dsl builder
         */
        default DataLakeEndpointBuilder dataLakeServiceClient(
                com.azure.storage.file.datalake.DataLakeServiceClient dataLakeServiceClient) {
            doSetProperty("dataLakeServiceClient", dataLakeServiceClient);
            return this;
        }
        /**
         * service client of datalake.
         * 
         * The option will be converted to a
         * &lt;code&gt;com.azure.storage.file.datalake.DataLakeServiceClient&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param dataLakeServiceClient the value to set
         * @return the dsl builder
         */
        default DataLakeEndpointBuilder dataLakeServiceClient(
                String dataLakeServiceClient) {
            doSetProperty("dataLakeServiceClient", dataLakeServiceClient);
            return this;
        }
        /**
         * directory of the file to be handled in component.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param directoryName the value to set
         * @return the dsl builder
         */
        default DataLakeEndpointBuilder directoryName(String directoryName) {
            doSetProperty("directoryName", directoryName);
            return this;
        }
        /**
         * download link expiration time.
         * 
         * The option is a: &lt;code&gt;java.lang.Long&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param downloadLinkExpiration the value to set
         * @return the dsl builder
         */
        default DataLakeEndpointBuilder downloadLinkExpiration(
                Long downloadLinkExpiration) {
            doSetProperty("downloadLinkExpiration", downloadLinkExpiration);
            return this;
        }
        /**
         * download link expiration time.
         * 
         * The option will be converted to a
         * &lt;code&gt;java.lang.Long&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param downloadLinkExpiration the value to set
         * @return the dsl builder
         */
        default DataLakeEndpointBuilder downloadLinkExpiration(
                String downloadLinkExpiration) {
            doSetProperty("downloadLinkExpiration", downloadLinkExpiration);
            return this;
        }
        /**
         * expression for queryInputStream.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param expression the value to set
         * @return the dsl builder
         */
        default DataLakeEndpointBuilder expression(String expression) {
            doSetProperty("expression", expression);
            return this;
        }
        /**
         * directory of file to do operations in the local system.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param fileDir the value to set
         * @return the dsl builder
         */
        default DataLakeEndpointBuilder fileDir(String fileDir) {
            doSetProperty("fileDir", fileDir);
            return this;
        }
        /**
         * name of file to be handled in component.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param fileName the value to set
         * @return the dsl builder
         */
        default DataLakeEndpointBuilder fileName(String fileName) {
            doSetProperty("fileName", fileName);
            return this;
        }
        /**
         * offset position in file for different operations.
         * 
         * The option is a: &lt;code&gt;java.lang.Long&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param fileOffset the value to set
         * @return the dsl builder
         */
        default DataLakeEndpointBuilder fileOffset(Long fileOffset) {
            doSetProperty("fileOffset", fileOffset);
            return this;
        }
        /**
         * offset position in file for different operations.
         * 
         * The option will be converted to a
         * &lt;code&gt;java.lang.Long&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param fileOffset the value to set
         * @return the dsl builder
         */
        default DataLakeEndpointBuilder fileOffset(String fileOffset) {
            doSetProperty("fileOffset", fileOffset);
            return this;
        }
        /**
         * maximum number of results to show at a time.
         * 
         * The option is a: &lt;code&gt;java.lang.Integer&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param maxResults the value to set
         * @return the dsl builder
         */
        default DataLakeEndpointBuilder maxResults(Integer maxResults) {
            doSetProperty("maxResults", maxResults);
            return this;
        }
        /**
         * maximum number of results to show at a time.
         * 
         * The option will be converted to a
         * &lt;code&gt;java.lang.Integer&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param maxResults the value to set
         * @return the dsl builder
         */
        default DataLakeEndpointBuilder maxResults(String maxResults) {
            doSetProperty("maxResults", maxResults);
            return this;
        }
        /**
         * no of retries to a given request.
         * 
         * The option is a: &lt;code&gt;int&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param maxRetryRequests the value to set
         * @return the dsl builder
         */
        default DataLakeEndpointBuilder maxRetryRequests(int maxRetryRequests) {
            doSetProperty("maxRetryRequests", maxRetryRequests);
            return this;
        }
        /**
         * no of retries to a given request.
         * 
         * The option will be converted to a &lt;code&gt;int&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param maxRetryRequests the value to set
         * @return the dsl builder
         */
        default DataLakeEndpointBuilder maxRetryRequests(String maxRetryRequests) {
            doSetProperty("maxRetryRequests", maxRetryRequests);
            return this;
        }
        /**
         * set open options for creating file.
         * 
         * The option is a:
         * &lt;code&gt;java.util.Set&amp;lt;java.nio.file.OpenOption&amp;gt;&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param openOptions the value to set
         * @return the dsl builder
         */
        default DataLakeEndpointBuilder openOptions(
                Set<java.nio.file.OpenOption> openOptions) {
            doSetProperty("openOptions", openOptions);
            return this;
        }
        /**
         * set open options for creating file.
         * 
         * The option will be converted to a
         * &lt;code&gt;java.util.Set&amp;lt;java.nio.file.OpenOption&amp;gt;&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param openOptions the value to set
         * @return the dsl builder
         */
        default DataLakeEndpointBuilder openOptions(String openOptions) {
            doSetProperty("openOptions", openOptions);
            return this;
        }
        /**
         * path in azure datalake for operations.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param path the value to set
         * @return the dsl builder
         */
        default DataLakeEndpointBuilder path(String path) {
            doSetProperty("path", path);
            return this;
        }
        /**
         * permission string for the file.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param permission the value to set
         * @return the dsl builder
         */
        default DataLakeEndpointBuilder permission(String permission) {
            doSetProperty("permission", permission);
            return this;
        }
        /**
         * This parameter allows the caller to upload data in parallel and
         * control the order in which it is appended to the file.
         * 
         * The option is a: &lt;code&gt;java.lang.Long&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param position the value to set
         * @return the dsl builder
         */
        default DataLakeEndpointBuilder position(Long position) {
            doSetProperty("position", position);
            return this;
        }
        /**
         * This parameter allows the caller to upload data in parallel and
         * control the order in which it is appended to the file.
         * 
         * The option will be converted to a
         * &lt;code&gt;java.lang.Long&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param position the value to set
         * @return the dsl builder
         */
        default DataLakeEndpointBuilder position(String position) {
            doSetProperty("position", position);
            return this;
        }
        /**
         * recursively include all paths.
         * 
         * The option is a: &lt;code&gt;java.lang.Boolean&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param recursive the value to set
         * @return the dsl builder
         */
        default DataLakeEndpointBuilder recursive(Boolean recursive) {
            doSetProperty("recursive", recursive);
            return this;
        }
        /**
         * recursively include all paths.
         * 
         * The option will be converted to a
         * &lt;code&gt;java.lang.Boolean&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param recursive the value to set
         * @return the dsl builder
         */
        default DataLakeEndpointBuilder recursive(String recursive) {
            doSetProperty("recursive", recursive);
            return this;
        }
        /**
         * regular expression for matching file names.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param regex the value to set
         * @return the dsl builder
         */
        default DataLakeEndpointBuilder regex(String regex) {
            doSetProperty("regex", regex);
            return this;
        }
        /**
         * Whether or not uncommitted data is to be retained after the
         * operation.
         * 
         * The option is a: &lt;code&gt;java.lang.Boolean&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param retainUncommitedData the value to set
         * @return the dsl builder
         */
        default DataLakeEndpointBuilder retainUncommitedData(
                Boolean retainUncommitedData) {
            doSetProperty("retainUncommitedData", retainUncommitedData);
            return this;
        }
        /**
         * Whether or not uncommitted data is to be retained after the
         * operation.
         * 
         * The option will be converted to a
         * &lt;code&gt;java.lang.Boolean&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param retainUncommitedData the value to set
         * @return the dsl builder
         */
        default DataLakeEndpointBuilder retainUncommitedData(
                String retainUncommitedData) {
            doSetProperty("retainUncommitedData", retainUncommitedData);
            return this;
        }
        /**
         * datalake service client for azure storage datalake.
         * 
         * The option is a:
         * &lt;code&gt;com.azure.storage.file.datalake.DataLakeServiceClient&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param serviceClient the value to set
         * @return the dsl builder
         */
        default DataLakeEndpointBuilder serviceClient(
                com.azure.storage.file.datalake.DataLakeServiceClient serviceClient) {
            doSetProperty("serviceClient", serviceClient);
            return this;
        }
        /**
         * datalake service client for azure storage datalake.
         * 
         * The option will be converted to a
         * &lt;code&gt;com.azure.storage.file.datalake.DataLakeServiceClient&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param serviceClient the value to set
         * @return the dsl builder
         */
        default DataLakeEndpointBuilder serviceClient(String serviceClient) {
            doSetProperty("serviceClient", serviceClient);
            return this;
        }
        /**
         * shared key credential for azure datalake gen2.
         * 
         * The option is a:
         * &lt;code&gt;com.azure.storage.common.StorageSharedKeyCredential&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param sharedKeyCredential the value to set
         * @return the dsl builder
         */
        default DataLakeEndpointBuilder sharedKeyCredential(
                com.azure.storage.common.StorageSharedKeyCredential sharedKeyCredential) {
            doSetProperty("sharedKeyCredential", sharedKeyCredential);
            return this;
        }
        /**
         * shared key credential for azure datalake gen2.
         * 
         * The option will be converted to a
         * &lt;code&gt;com.azure.storage.common.StorageSharedKeyCredential&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param sharedKeyCredential the value to set
         * @return the dsl builder
         */
        default DataLakeEndpointBuilder sharedKeyCredential(
                String sharedKeyCredential) {
            doSetProperty("sharedKeyCredential", sharedKeyCredential);
            return this;
        }
        /**
         * tenant id for azure account.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param tenantId the value to set
         * @return the dsl builder
         */
        default DataLakeEndpointBuilder tenantId(String tenantId) {
            doSetProperty("tenantId", tenantId);
            return this;
        }
        /**
         * Timeout for operation.
         * 
         * The option is a: &lt;code&gt;java.time.Duration&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param timeout the value to set
         * @return the dsl builder
         */
        default DataLakeEndpointBuilder timeout(java.time.Duration timeout) {
            doSetProperty("timeout", timeout);
            return this;
        }
        /**
         * Timeout for operation.
         * 
         * The option will be converted to a
         * &lt;code&gt;java.time.Duration&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param timeout the value to set
         * @return the dsl builder
         */
        default DataLakeEndpointBuilder timeout(String timeout) {
            doSetProperty("timeout", timeout);
            return this;
        }
        /**
         * umask permission for file.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param umask the value to set
         * @return the dsl builder
         */
        default DataLakeEndpointBuilder umask(String umask) {
            doSetProperty("umask", umask);
            return this;
        }
        /**
         * whether or not to use upn.
         * 
         * The option is a: &lt;code&gt;java.lang.Boolean&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param userPrincipalNameReturned the value to set
         * @return the dsl builder
         */
        default DataLakeEndpointBuilder userPrincipalNameReturned(
                Boolean userPrincipalNameReturned) {
            doSetProperty("userPrincipalNameReturned", userPrincipalNameReturned);
            return this;
        }
        /**
         * whether or not to use upn.
         * 
         * The option will be converted to a
         * &lt;code&gt;java.lang.Boolean&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param userPrincipalNameReturned the value to set
         * @return the dsl builder
         */
        default DataLakeEndpointBuilder userPrincipalNameReturned(
                String userPrincipalNameReturned) {
            doSetProperty("userPrincipalNameReturned", userPrincipalNameReturned);
            return this;
        }
        /**
         * account key for authentication.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: security
         * 
         * @param accountKey the value to set
         * @return the dsl builder
         */
        default DataLakeEndpointBuilder accountKey(String accountKey) {
            doSetProperty("accountKey", accountKey);
            return this;
        }
        /**
         * client secret for azure account.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: security
         * 
         * @param clientSecret the value to set
         * @return the dsl builder
         */
        default DataLakeEndpointBuilder clientSecret(String clientSecret) {
            doSetProperty("clientSecret", clientSecret);
            return this;
        }
        /**
         * client secret credential for authentication.
         * 
         * The option is a:
         * &lt;code&gt;com.azure.identity.ClientSecretCredential&lt;/code&gt;
         * type.
         * 
         * Group: security
         * 
         * @param clientSecretCredential the value to set
         * @return the dsl builder
         */
        default DataLakeEndpointBuilder clientSecretCredential(
                com.azure.identity.ClientSecretCredential clientSecretCredential) {
            doSetProperty("clientSecretCredential", clientSecretCredential);
            return this;
        }
        /**
         * client secret credential for authentication.
         * 
         * The option will be converted to a
         * &lt;code&gt;com.azure.identity.ClientSecretCredential&lt;/code&gt;
         * type.
         * 
         * Group: security
         * 
         * @param clientSecretCredential the value to set
         * @return the dsl builder
         */
        default DataLakeEndpointBuilder clientSecretCredential(
                String clientSecretCredential) {
            doSetProperty("clientSecretCredential", clientSecretCredential);
            return this;
        }
        /**
         * SAS token credential.
         * 
         * The option is a:
         * &lt;code&gt;com.azure.core.credential.AzureSasCredential&lt;/code&gt;
         * type.
         * 
         * Group: security
         * 
         * @param sasCredential the value to set
         * @return the dsl builder
         */
        default DataLakeEndpointBuilder sasCredential(
                com.azure.core.credential.AzureSasCredential sasCredential) {
            doSetProperty("sasCredential", sasCredential);
            return this;
        }
        /**
         * SAS token credential.
         * 
         * The option will be converted to a
         * &lt;code&gt;com.azure.core.credential.AzureSasCredential&lt;/code&gt;
         * type.
         * 
         * Group: security
         * 
         * @param sasCredential the value to set
         * @return the dsl builder
         */
        default DataLakeEndpointBuilder sasCredential(String sasCredential) {
            doSetProperty("sasCredential", sasCredential);
            return this;
        }
        /**
         * SAS token signature.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: security
         * 
         * @param sasSignature the value to set
         * @return the dsl builder
         */
        default DataLakeEndpointBuilder sasSignature(String sasSignature) {
            doSetProperty("sasSignature", sasSignature);
            return this;
        }
        /**
         * Use default identity.
         * 
         * The option is a: &lt;code&gt;java.lang.Boolean&lt;/code&gt; type.
         * 
         * Group: security
         * 
         * @param useDefaultIdentity the value to set
         * @return the dsl builder
         */
        default DataLakeEndpointBuilder useDefaultIdentity(
                Boolean useDefaultIdentity) {
            doSetProperty("useDefaultIdentity", useDefaultIdentity);
            return this;
        }
        /**
         * Use default identity.
         * 
         * The option will be converted to a
         * &lt;code&gt;java.lang.Boolean&lt;/code&gt; type.
         * 
         * Group: security
         * 
         * @param useDefaultIdentity the value to set
         * @return the dsl builder
         */
        default DataLakeEndpointBuilder useDefaultIdentity(
                String useDefaultIdentity) {
            doSetProperty("useDefaultIdentity", useDefaultIdentity);
            return this;
        }
    }

    /**
     * Advanced builder for endpoint for the Azure Storage Datalake Service
     * component.
     */
    public interface AdvancedDataLakeEndpointBuilder
            extends
                AdvancedDataLakeEndpointConsumerBuilder,
                AdvancedDataLakeEndpointProducerBuilder {
        default DataLakeEndpointBuilder basic() {
            return (DataLakeEndpointBuilder) this;
        }
    }

    public interface DataLakeBuilders {
        /**
         * Azure Storage Datalake Service (camel-azure-storage-datalake)
         * Sends and receives files to/from Azure DataLake Storage.
         * 
         * Category: cloud,file,bigdata
         * Since: 3.8
         * Maven coordinates: org.apache.camel:camel-azure-storage-datalake
         * 
         * @return the dsl builder for the headers' name.
         */
        default DataLakeHeaderNameBuilder azureStorageDatalake() {
            return DataLakeHeaderNameBuilder.INSTANCE;
        }
        /**
         * Azure Storage Datalake Service (camel-azure-storage-datalake)
         * Sends and receives files to/from Azure DataLake Storage.
         * 
         * Category: cloud,file,bigdata
         * Since: 3.8
         * Maven coordinates: org.apache.camel:camel-azure-storage-datalake
         * 
         * Syntax:
         * <code>azure-storage-datalake:accountName/fileSystemName</code>
         * 
         * Path parameter: accountName
         * name of the azure account
         * 
         * Path parameter: fileSystemName
         * name of filesystem to be used
         * 
         * @param path accountName/fileSystemName
         * @return the dsl builder
         */
        default DataLakeEndpointBuilder azureStorageDatalake(String path) {
            return DataLakeEndpointBuilderFactory.endpointBuilder("azure-storage-datalake", path);
        }
        /**
         * Azure Storage Datalake Service (camel-azure-storage-datalake)
         * Sends and receives files to/from Azure DataLake Storage.
         * 
         * Category: cloud,file,bigdata
         * Since: 3.8
         * Maven coordinates: org.apache.camel:camel-azure-storage-datalake
         * 
         * Syntax:
         * <code>azure-storage-datalake:accountName/fileSystemName</code>
         * 
         * Path parameter: accountName
         * name of the azure account
         * 
         * Path parameter: fileSystemName
         * name of filesystem to be used
         * 
         * @param componentName to use a custom component name for the endpoint
         * instead of the default name
         * @param path accountName/fileSystemName
         * @return the dsl builder
         */
        default DataLakeEndpointBuilder azureStorageDatalake(
                String componentName,
                String path) {
            return DataLakeEndpointBuilderFactory.endpointBuilder(componentName, path);
        }
    }

    /**
     * The builder of headers' name for the Azure Storage Datalake Service
     * component.
     */
    public static class DataLakeHeaderNameBuilder {
        /**
         * The internal instance of the builder used to access to all the
         * methods representing the name of headers.
         */
        private static final DataLakeHeaderNameBuilder INSTANCE = new DataLakeHeaderNameBuilder();

        /**
         * Defines options available to configure the behavior of a call to
         * listFileSystemsSegment on a DataLakeServiceAsyncClient object. Null
         * may be passed.
         * 
         * The option is a: {@code ListFileSystemsOptions} type.
         * 
         * Group: from user
         * 
         * @return the name of the header {@code
         * AzureStorageDataLakeListFileSystemsOptions}.
         */
        public String azureStorageDataLakeListFileSystemsOptions() {
            return "AzureStorageDataLakeListFileSystemsOptions";
        }

        /**
         * An optional timeout value beyond which a RuntimeException will be
         * raised.
         * 
         * The option is a: {@code Duration} type.
         * 
         * Group: from user
         * 
         * @return the name of the header {@code AzureStorageDataLakeTimeout}.
         */
        public String azureStorageDataLakeTimeout() {
            return "AzureStorageDataLakeTimeout";
        }

        /**
         * Specify the producer operation to execute. Different operations
         * allowed are shown below.
         * 
         * The option is a: {@code
         * org.apache.camel.component.azure.storage.datalake.DataLakeOperationsDefinition} type.
         * 
         * Group: from user
         * 
         * @return the name of the header {@code AzureStorageDataLakeOperation}.
         */
        public String azureStorageDataLakeOperation() {
            return "AzureStorageDataLakeOperation";
        }

        /**
         * Name of the file system in azure datalake on which operation is to be
         * performed. Please make sure that filesystem name is all lowercase.
         * 
         * The option is a: {@code String} type.
         * 
         * Group: from user
         * 
         * @return the name of the header {@code
         * AzureStorageDataLakeFileSystemName}.
         */
        public String azureStorageDataLakeFileSystemName() {
            return "AzureStorageDataLakeFileSystemName";
        }

        /**
         * Name of the directory in azure datalake on which operation is to be
         * performed.
         * 
         * The option is a: {@code String} type.
         * 
         * Group: from user
         * 
         * @return the name of the header {@code
         * AzureStorageDataLakeDirectoryName}.
         */
        public String azureStorageDataLakeDirectoryName() {
            return "AzureStorageDataLakeDirectoryName";
        }

        /**
         * Name of the file in azure datalake on which operation is to be
         * performed.
         * 
         * The option is a: {@code String} type.
         * 
         * Group: from user
         * 
         * @return the name of the header {@code AzureStorageDataLakeFileName}.
         */
        public String azureStorageDataLakeFileName() {
            return "AzureStorageDataLakeFileName";
        }

        /**
         * The metadata to associate with the file.
         * 
         * The option is a: {@code Map<String, String>} type.
         * 
         * Group: from both
         * 
         * @return the name of the header {@code AzureStorageDataLakeMetadata}.
         */
        public String azureStorageDataLakeMetadata() {
            return "AzureStorageDataLakeMetadata";
        }

        /**
         * Defines options available to configure the behavior of a call to
         * listFileSystemsSegment on a DataLakeServiceAsyncClient object.
         * 
         * The option is a: {@code PublicAccessType} type.
         * 
         * Group: from user
         * 
         * @return the name of the header {@code
         * AzureStorageDataLakePublicAccessType}.
         */
        public String azureStorageDataLakePublicAccessType() {
            return "AzureStorageDataLakePublicAccessType";
        }

        /**
         * Non parsed http headers that can be used by the user.
         * 
         * The option is a: {@code HttpHeaders} type.
         * 
         * Group: from component
         * 
         * @return the name of the header {@code
         * AzureStorageDataLakeRawHttpHeaders}.
         */
        public String azureStorageDataLakeRawHttpHeaders() {
            return "AzureStorageDataLakeRawHttpHeaders";
        }

        /**
         * This contains values which will restrict the successful operation of
         * a variety of requests to the conditions present. These conditions are
         * entirely optional.
         * 
         * The option is a: {@code DataLakeRequestConditions} type.
         * 
         * Group: from user
         * 
         * @return the name of the header {@code
         * AzureStorageDataLakeRequestCondition}.
         */
        public String azureStorageDataLakeRequestCondition() {
            return "AzureStorageDataLakeRequestCondition";
        }

        /**
         * Defines options available to configure the behavior of a call to
         * listContainersSegment on a DataLakeFileSystemClient object. Null may
         * be passed.
         * 
         * The option is a: {@code ListPathOptions} type.
         * 
         * Group: from user
         * 
         * @return the name of the header {@code
         * AzureStorageDataLakeListPathOptions}.
         */
        public String azureStorageDataLakeListPathOptions() {
            return "AzureStorageDataLakeListPathOptions";
        }

        /**
         * Path of the file to be used for upload operations.
         * 
         * The option is a: {@code String} type.
         * 
         * Group: from user
         * 
         * @return the name of the header {@code AzureStorageDataLakePath}.
         */
        public String azureStorageDataLakePath() {
            return "AzureStorageDataLakePath";
        }

        /**
         * Specifies if the call to listContainersSegment should recursively
         * include all paths.
         * 
         * The option is a: {@code Boolean} type.
         * 
         * Group: from user
         * 
         * @return the name of the header {@code AzureStorageDataLakeRecursive}.
         */
        public String azureStorageDataLakeRecursive() {
            return "AzureStorageDataLakeRecursive";
        }

        /**
         * Specifies the maximum number of blobs to return, including all
         * BlobPrefix elements.
         * 
         * The option is a: {@code Integer} type.
         * 
         * Group: from user
         * 
         * @return the name of the header {@code
         * AzureStorageDataLakeMaxResults}.
         */
        public String azureStorageDataLakeMaxResults() {
            return "AzureStorageDataLakeMaxResults";
        }

        /**
         * Specifies if the name of the user principal should be returned.
         * 
         * The option is a: {@code Boolean} type.
         * 
         * Group: from user
         * 
         * @return the name of the header {@code
         * AzureStorageDataLakeUserPrincipalNameReturned}.
         */
        public String azureStorageDataLakeUserPrincipalNameReturned() {
            return "AzureStorageDataLakeUserPrincipalNameReturned";
        }

        /**
         * Filter the results to return only those files with match the
         * specified regular expression.
         * 
         * The option is a: {@code String} type.
         * 
         * Group: from user
         * 
         * @return the name of the header {@code AzureStorageDataLakeRegex}.
         */
        public String azureStorageDataLakeRegex() {
            return "AzureStorageDataLakeRegex";
        }

        /**
         * Directory in which the file is to be downloaded.
         * 
         * The option is a: {@code String} type.
         * 
         * Group: from user
         * 
         * @return the name of the header {@code AzureStorageDataLakeFileDir}.
         */
        public String azureStorageDataLakeFileDir() {
            return "AzureStorageDataLakeFileDir";
        }

        /**
         * Access tier of file.
         * 
         * The option is a: {@code AccessTier} type.
         * 
         * Group: from component
         * 
         * @return the name of the header {@code
         * AzureStorageDataLakeAccessTier}.
         */
        public String azureStorageDataLakeAccessTier() {
            return "AzureStorageDataLakeAccessTier";
        }

        /**
         * An MD5 hash of the content. The hash is used to verify the integrity
         * of the file during transport.
         * 
         * The option is a: {@code byte[]} type.
         * 
         * Group: from user
         * 
         * @return the name of the header {@code
         * AzureStorageDataLakeContentMD5}.
         */
        public String azureStorageDataLakeContentMD5() {
            return "AzureStorageDataLakeContentMD5";
        }

        /**
         * This is a representation of a range of bytes on a file, typically
         * used during a download operation. Passing null as a FileRange value
         * will default to the entire range of the file.
         * 
         * The option is a: {@code FileRange} type.
         * 
         * Group: from user
         * 
         * @return the name of the header {@code AzureStorageDataLakeFileRange}.
         */
        public String azureStorageDataLakeFileRange() {
            return "AzureStorageDataLakeFileRange";
        }

        /**
         * The configuration used to parallelize data transfer operations.
         * 
         * The option is a: {@code ParallelTransferOptions} type.
         * 
         * Group: from user
         * 
         * @return the name of the header {@code
         * AzureStorageDataLakeParallelTransferOptions}.
         */
        public String azureStorageDataLakeParallelTransferOptions() {
            return "AzureStorageDataLakeParallelTransferOptions";
        }

        /**
         * Set of OpenOption used to configure how to open or create a file.
         * 
         * The option is a: {@code Set<OpenOption>} type.
         * 
         * Group: from user
         * 
         * @return the name of the header {@code
         * AzureStorageDataLakeOpenOptions}.
         */
        public String azureStorageDataLakeOpenOptions() {
            return "AzureStorageDataLakeOpenOptions";
        }

        /**
         * Datetime when the access tier of the blob last changed.
         * 
         * The option is a: {@code OffsetDateTime} type.
         * 
         * Group: from component
         * 
         * @return the name of the header {@code
         * AzureStorageDataLakeAccessTierChangeTime}.
         */
        public String azureStorageDataLakeAccessTierChangeTime() {
            return "AzureStorageDataLakeAccessTierChangeTime";
        }

        /**
         * Archive status of file.
         * 
         * The option is a: {@code ArchiveStatus} type.
         * 
         * Group: from component
         * 
         * @return the name of the header {@code
         * AzureStorageDataLakeArchiveStatus}.
         */
        public String azureStorageDataLakeArchiveStatus() {
            return "AzureStorageDataLakeArchiveStatus";
        }

        /**
         * Cache control specified for the file.
         * 
         * The option is a: {@code String} type.
         * 
         * Group: from component
         * 
         * @return the name of the header {@code
         * AzureStorageDataLakeCacheControl}.
         */
        public String azureStorageDataLakeCacheControl() {
            return "AzureStorageDataLakeCacheControl";
        }

        /**
         * Content disposition specified for the file.
         * 
         * The option is a: {@code String} type.
         * 
         * Group: from component
         * 
         * @return the name of the header {@code
         * AzureStorageDataLakeContentDisposition}.
         */
        public String azureStorageDataLakeContentDisposition() {
            return "AzureStorageDataLakeContentDisposition";
        }

        /**
         * Content encoding specified for the file.
         * 
         * The option is a: {@code String} type.
         * 
         * Group: from component
         * 
         * @return the name of the header {@code
         * AzureStorageDataLakeContentEncoding}.
         */
        public String azureStorageDataLakeContentEncoding() {
            return "AzureStorageDataLakeContentEncoding";
        }

        /**
         * Content language specified for the file.
         * 
         * The option is a: {@code String} type.
         * 
         * Group: from component
         * 
         * @return the name of the header {@code
         * AzureStorageDataLakeContentLanguage}.
         */
        public String azureStorageDataLakeContentLanguage() {
            return "AzureStorageDataLakeContentLanguage";
        }

        /**
         * Content type specified for the file.
         * 
         * The option is a: {@code String} type.
         * 
         * Group: from component
         * 
         * @return the name of the header {@code
         * AzureStorageDataLakeContentType}.
         */
        public String azureStorageDataLakeContentType() {
            return "AzureStorageDataLakeContentType";
        }

        /**
         * Conclusion time of the last attempted Copy Blob operation where this
         * file was the destination file.
         * 
         * The option is a: {@code OffsetDateTime} type.
         * 
         * Group: from component
         * 
         * @return the name of the header {@code
         * AzureStorageDataLakeCopyCompletionTime}.
         */
        public String azureStorageDataLakeCopyCompletionTime() {
            return "AzureStorageDataLakeCopyCompletionTime";
        }

        /**
         * String identifier for this copy operation.
         * 
         * The option is a: {@code String} type.
         * 
         * Group: from component
         * 
         * @return the name of the header {@code AzureStorageDataLakeCopyId}.
         */
        public String azureStorageDataLakeCopyId() {
            return "AzureStorageDataLakeCopyId";
        }

        /**
         * Contains the number of bytes copied and the total bytes in the source
         * in the last attempted Copy Blob operation where this file was the
         * destination file.
         * 
         * The option is a: {@code String} type.
         * 
         * Group: from component
         * 
         * @return the name of the header {@code
         * AzureStorageDataLakeCopyProgress}.
         */
        public String azureStorageDataLakeCopyProgress() {
            return "AzureStorageDataLakeCopyProgress";
        }

        /**
         * URL up to 2 KB in length that specifies the source file or file used
         * in the last attempted Copy Blob operation where this file was the
         * destination file.
         * 
         * The option is a: {@code String} type.
         * 
         * Group: from component
         * 
         * @return the name of the header {@code
         * AzureStorageDataLakeCopySource}.
         */
        public String azureStorageDataLakeCopySource() {
            return "AzureStorageDataLakeCopySource";
        }

        /**
         * Status of the last copy operation performed on the file.
         * 
         * The option is a: {@code
         * com.azure.storage.file.datalake.models.CopyStatusType} type.
         * 
         * Group: from component
         * 
         * @return the name of the header {@code
         * AzureStorageDataLakeCopyStatus}.
         */
        public String azureStorageDataLakeCopyStatus() {
            return "AzureStorageDataLakeCopyStatus";
        }

        /**
         * The description of the copy's status.
         * 
         * The option is a: {@code String} type.
         * 
         * Group: from component
         * 
         * @return the name of the header {@code
         * AzureStorageDataLakeCopyStatusDescription}.
         */
        public String azureStorageDataLakeCopyStatusDescription() {
            return "AzureStorageDataLakeCopyStatusDescription";
        }

        /**
         * Creation time of the file.
         * 
         * The option is a: {@code OffsetDateTime} type.
         * 
         * Group: from component
         * 
         * @return the name of the header {@code
         * AzureStorageDataLakeCreationTime}.
         */
        public String azureStorageDataLakeCreationTime() {
            return "AzureStorageDataLakeCreationTime";
        }

        /**
         * The SHA-256 hash of the encryption key used to encrypt the file.
         * 
         * The option is a: {@code String} type.
         * 
         * Group: from component
         * 
         * @return the name of the header {@code
         * AzureStorageDataLakeEncryptionKeySha256}.
         */
        public String azureStorageDataLakeEncryptionKeySha256() {
            return "AzureStorageDataLakeEncryptionKeySha256";
        }

        /**
         * The E Tag of the file.
         * 
         * The option is a: {@code String} type.
         * 
         * Group: from component
         * 
         * @return the name of the header {@code AzureStorageDataLakeETag}.
         */
        public String azureStorageDataLakeETag() {
            return "AzureStorageDataLakeETag";
        }

        /**
         * Size of the file.
         * 
         * The option is a: {@code Long} type.
         * 
         * Group: from component
         * 
         * @return the name of the header {@code AzureStorageDataLakeFileSize}.
         */
        public String azureStorageDataLakeFileSize() {
            return "AzureStorageDataLakeFileSize";
        }

        /**
         * Datetime when the file was last modified.
         * 
         * The option is a: {@code OffsetDateTime} type.
         * 
         * Group: from component
         * 
         * @return the name of the header {@code
         * AzureStorageDataLakeLastModified}.
         */
        public String azureStorageDataLakeLastModified() {
            return "AzureStorageDataLakeLastModified";
        }

        /**
         * Type of lease on the file.
         * 
         * The option is a: {@code
         * com.azure.storage.file.datalake.models.LeaseDurationType} type.
         * 
         * Group: from component
         * 
         * @return the name of the header {@code
         * AzureStorageDataLakeLeaseDuration}.
         */
        public String azureStorageDataLakeLeaseDuration() {
            return "AzureStorageDataLakeLeaseDuration";
        }

        /**
         * State of the lease on the file.
         * 
         * The option is a: {@code
         * com.azure.storage.file.datalake.models.LeaseStateType} type.
         * 
         * Group: from component
         * 
         * @return the name of the header {@code
         * AzureStorageDataLakeLeaseState}.
         */
        public String azureStorageDataLakeLeaseState() {
            return "AzureStorageDataLakeLeaseState";
        }

        /**
         * Status of the lease on the file.
         * 
         * The option is a: {@code
         * com.azure.storage.file.datalake.models.LeaseStatusType} type.
         * 
         * Group: from component
         * 
         * @return the name of the header {@code
         * AzureStorageDataLakeLeaseStatus}.
         */
        public String azureStorageDataLakeLeaseStatus() {
            return "AzureStorageDataLakeLeaseStatus";
        }

        /**
         * Flag indicating if the file was incrementally copied.
         * 
         * The option is a: {@code Boolean} type.
         * 
         * Group: from user
         * 
         * @return the name of the header {@code
         * AzureStorageDataLakeIncrementalCopy}.
         */
        public String azureStorageDataLakeIncrementalCopy() {
            return "AzureStorageDataLakeIncrementalCopy";
        }

        /**
         * Flag indicating if the file's content is encrypted on the server.
         * 
         * The option is a: {@code Boolean} type.
         * 
         * Group: from component
         * 
         * @return the name of the header {@code
         * AzureStorageDataLakeServerEncrypted}.
         */
        public String azureStorageDataLakeServerEncrypted() {
            return "AzureStorageDataLakeServerEncrypted";
        }

        /**
         * Set the Expiration time of the download link.
         * 
         * The option is a: {@code Long} type.
         * 
         * Group: from user
         * 
         * @return the name of the header {@code
         * AzureStorageDataLakeDownloadLinkExpiration}.
         */
        public String azureStorageDataLakeDownloadLinkExpiration() {
            return "AzureStorageDataLakeDownloadLinkExpiration";
        }

        /**
         * The link that can be used to download the file from datalake.
         * 
         * The option is a: {@code String} type.
         * 
         * Group: from component
         * 
         * @return the name of the header {@code
         * AzureStorageDataLakeDownloadLink}.
         */
        public String azureStorageDataLakeDownloadLink() {
            return "AzureStorageDataLakeDownloadLink";
        }

        /**
         * The position where the data is to be appended.
         * 
         * The option is a: {@code Long} type.
         * 
         * Group: from user
         * 
         * @return the name of the header {@code
         * AzureStorageDataLakeFileOffset}.
         */
        public String azureStorageDataLakeFileOffset() {
            return "AzureStorageDataLakeFileOffset";
        }

        /**
         * By setting lease id, requests will fail if the provided lease does
         * not match the active lease on the file.
         * 
         * The option is a: {@code String} type.
         * 
         * Group: from user
         * 
         * @return the name of the header {@code AzureStorageDataLakeLeaseId}.
         */
        public String azureStorageDataLakeLeaseId() {
            return "AzureStorageDataLakeLeaseId";
        }

        /**
         * Additional parameters for a set of operations.
         * 
         * The option is a: {@code PathHttpHeaders} type.
         * 
         * Group: from user
         * 
         * @return the name of the header {@code
         * AzureStorageDataLakePathHttpHeaders}.
         */
        public String azureStorageDataLakePathHttpHeaders() {
            return "AzureStorageDataLakePathHttpHeaders";
        }

        /**
         * Determines Whether or not uncommitted data is to be retained after
         * the operation.
         * 
         * The option is a: {@code Boolean} type.
         * 
         * Group: from user
         * 
         * @return the name of the header {@code
         * AzureStorageDataLakeRetainCommitedData}.
         */
        public String azureStorageDataLakeRetainCommitedData() {
            return "AzureStorageDataLakeRetainCommitedData";
        }

        /**
         * Whether or not a file changed event raised indicates completion
         * (true) or modification (false).
         * 
         * The option is a: {@code Boolean} type.
         * 
         * Group: from user
         * 
         * @return the name of the header {@code AzureStorageDataLakeClose}.
         */
        public String azureStorageDataLakeClose() {
            return "AzureStorageDataLakeClose";
        }

        /**
         * The length of the file after all data has been written.
         * 
         * The option is a: {@code Long} type.
         * 
         * Group: from user
         * 
         * @return the name of the header {@code AzureStorageDataLakePosition}.
         */
        public String azureStorageDataLakePosition() {
            return "AzureStorageDataLakePosition";
        }

        /**
         * The query expression on the file.
         * 
         * The option is a: {@code String} type.
         * 
         * Group: from user
         * 
         * @return the name of the header {@code
         * AzureStorageDataLakeExpression}.
         */
        public String azureStorageDataLakeExpression() {
            return "AzureStorageDataLakeExpression";
        }

        /**
         * Defines the input serialization for a file query request. either
         * FileQueryJsonSerialization or FileQueryDelimitedSerialization.
         * 
         * The option is a: {@code FileQuerySerialization} type.
         * 
         * Group: from user
         * 
         * @return the name of the header {@code
         * AzureStorageDataLakeInputSerialization}.
         */
        public String azureStorageDataLakeInputSerialization() {
            return "AzureStorageDataLakeInputSerialization";
        }

        /**
         * Defines the output serialization for a file query request. either
         * FileQueryJsonSerialization or FileQueryDelimitedSerialization.
         * 
         * The option is a: {@code FileQuerySerialization} type.
         * 
         * Group: from user
         * 
         * @return the name of the header {@code
         * AzureStorageDataLakeOutputSerialization}.
         */
        public String azureStorageDataLakeOutputSerialization() {
            return "AzureStorageDataLakeOutputSerialization";
        }

        /**
         * Sets error consumer for file query.
         * 
         * The option is a: {@code Consumer<FileQueryError>} type.
         * 
         * Group: from user
         * 
         * @return the name of the header {@code
         * AzureStorageDataLakeErrorConsumer}.
         */
        public String azureStorageDataLakeErrorConsumer() {
            return "AzureStorageDataLakeErrorConsumer";
        }

        /**
         * Sets progress consumer for file query.
         * 
         * The option is a: {@code Consumer<FileQueryProgress>} type.
         * 
         * Group: from user
         * 
         * @return the name of the header {@code
         * AzureStorageDataLakeProgressConsumer}.
         */
        public String azureStorageDataLakeProgressConsumer() {
            return "AzureStorageDataLakeProgressConsumer";
        }

        /**
         * Optional parameters for File Query.
         * 
         * The option is a: {@code FileQueryOptions} type.
         * 
         * Group: from user
         * 
         * @return the name of the header {@code
         * AzureStorageDataLakeQueryOptions}.
         */
        public String azureStorageDataLakeQueryOptions() {
            return "AzureStorageDataLakeQueryOptions";
        }

        /**
         * Sets the permission for file.
         * 
         * The option is a: {@code String} type.
         * 
         * Group: from user
         * 
         * @return the name of the header {@code
         * AzureStorageDataLakePermission}.
         */
        public String azureStorageDataLakePermission() {
            return "AzureStorageDataLakePermission";
        }

        /**
         * Sets the umask for file.
         * 
         * The option is a: {@code String} type.
         * 
         * Group: from user
         * 
         * @return the name of the header {@code AzureStorageDataLakeUmask}.
         */
        public String azureStorageDataLakeUmask() {
            return "AzureStorageDataLakeUmask";
        }

        /**
         * Sets the file client to use.
         * 
         * The option is a: {@code DataLakeFileClient} type.
         * 
         * Group: from user
         * 
         * @return the name of the header {@code
         * AzureStorageDataLakeFileClient}.
         */
        public String azureStorageDataLakeFileClient() {
            return "AzureStorageDataLakeFileClient";
        }

        /**
         * Sets whether to flush on append.
         * 
         * The option is a: {@code Boolean} type.
         * 
         * Group: from user
         * 
         * @return the name of the header {@code AzureStorageDataLakeFlush}.
         */
        public String azureStorageDataLakeFlush() {
            return "AzureStorageDataLakeFlush";
        }
    }
    static DataLakeEndpointBuilder endpointBuilder(
            String componentName,
            String path) {
        class DataLakeEndpointBuilderImpl extends AbstractEndpointBuilder implements DataLakeEndpointBuilder, AdvancedDataLakeEndpointBuilder {
            public DataLakeEndpointBuilderImpl(String path) {
                super(componentName, path);
            }
        }
        return new DataLakeEndpointBuilderImpl(path);
    }
}