/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.apache.camel.builder.endpoint.dsl;

import java.util.*;
import java.util.concurrent.*;
import java.util.function.*;
import java.util.stream.*;
import javax.annotation.processing.Generated;
import org.apache.camel.builder.EndpointConsumerBuilder;
import org.apache.camel.builder.EndpointProducerBuilder;
import org.apache.camel.builder.endpoint.AbstractEndpointBuilder;

/**
 * Get notified about file events in a directory using
 * java.nio.file.WatchService.
 * 
 * Generated by camel build tools - do NOT edit this file!
 */
@Generated("org.apache.camel.maven.packaging.EndpointDslMojo")
public interface FileWatchEndpointBuilderFactory {


    /**
     * Builder for endpoint for the File Watch component.
     */
    public interface FileWatchEndpointBuilder extends EndpointConsumerBuilder {
        default AdvancedFileWatchEndpointBuilder advanced() {
            return (AdvancedFileWatchEndpointBuilder) this;
        }
        /**
         * ANT style pattern to match files. The file is matched against path
         * relative to endpoint path. Pattern must be also relative (not
         * starting with slash).
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Default: **
         * Group: consumer
         * 
         * @param antInclude the value to set
         * @return the dsl builder
         */
        default FileWatchEndpointBuilder antInclude(String antInclude) {
            doSetProperty("antInclude", antInclude);
            return this;
        }
        /**
         * Auto create directory if does not exists.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: true
         * Group: consumer
         * 
         * @param autoCreate the value to set
         * @return the dsl builder
         */
        default FileWatchEndpointBuilder autoCreate(boolean autoCreate) {
            doSetProperty("autoCreate", autoCreate);
            return this;
        }
        /**
         * Auto create directory if does not exists.
         * 
         * The option will be converted to a &lt;code&gt;boolean&lt;/code&gt;
         * type.
         * 
         * Default: true
         * Group: consumer
         * 
         * @param autoCreate the value to set
         * @return the dsl builder
         */
        default FileWatchEndpointBuilder autoCreate(String autoCreate) {
            doSetProperty("autoCreate", autoCreate);
            return this;
        }
        /**
         * The number of concurrent consumers. Increase this value, if your
         * route is slow to prevent buffering in queue.
         * 
         * The option is a: &lt;code&gt;int&lt;/code&gt; type.
         * 
         * Default: 1
         * Group: consumer
         * 
         * @param concurrentConsumers the value to set
         * @return the dsl builder
         */
        default FileWatchEndpointBuilder concurrentConsumers(
                int concurrentConsumers) {
            doSetProperty("concurrentConsumers", concurrentConsumers);
            return this;
        }
        /**
         * The number of concurrent consumers. Increase this value, if your
         * route is slow to prevent buffering in queue.
         * 
         * The option will be converted to a &lt;code&gt;int&lt;/code&gt; type.
         * 
         * Default: 1
         * Group: consumer
         * 
         * @param concurrentConsumers the value to set
         * @return the dsl builder
         */
        default FileWatchEndpointBuilder concurrentConsumers(
                String concurrentConsumers) {
            doSetProperty("concurrentConsumers", concurrentConsumers);
            return this;
        }
        /**
         * Comma separated list of events to watch.
         * 
         * The option is a:
         * &lt;code&gt;java.util.Set&amp;lt;org.apache.camel.component.file.watch.constants.FileEventEnum&amp;gt;&lt;/code&gt; type.
         * 
         * Default: CREATE,MODIFY,DELETE
         * Group: consumer
         * 
         * @param events the value to set
         * @return the dsl builder
         */
        default FileWatchEndpointBuilder events(
                Set<org.apache.camel.component.file.watch.constants.FileEventEnum> events) {
            doSetProperty("events", events);
            return this;
        }
        /**
         * Comma separated list of events to watch.
         * 
         * The option will be converted to a
         * &lt;code&gt;java.util.Set&amp;lt;org.apache.camel.component.file.watch.constants.FileEventEnum&amp;gt;&lt;/code&gt; type.
         * 
         * Default: CREATE,MODIFY,DELETE
         * Group: consumer
         * 
         * @param events the value to set
         * @return the dsl builder
         */
        default FileWatchEndpointBuilder events(String events) {
            doSetProperty("events", events);
            return this;
        }
        /**
         * Reference to io.methvin.watcher.hashing.FileHasher. This prevents
         * emitting duplicate events on some platforms. For working with large
         * files and if you dont need detect multiple modifications per second
         * per file, use #lastModifiedTimeFileHasher. You can also provide
         * custom implementation in registry.
         * 
         * The option is a:
         * &lt;code&gt;io.methvin.watcher.hashing.FileHasher&lt;/code&gt; type.
         * 
         * Default: #murmur3FFileHasher
         * Group: consumer
         * 
         * @param fileHasher the value to set
         * @return the dsl builder
         */
        default FileWatchEndpointBuilder fileHasher(
                io.methvin.watcher.hashing.FileHasher fileHasher) {
            doSetProperty("fileHasher", fileHasher);
            return this;
        }
        /**
         * Reference to io.methvin.watcher.hashing.FileHasher. This prevents
         * emitting duplicate events on some platforms. For working with large
         * files and if you dont need detect multiple modifications per second
         * per file, use #lastModifiedTimeFileHasher. You can also provide
         * custom implementation in registry.
         * 
         * The option will be converted to a
         * &lt;code&gt;io.methvin.watcher.hashing.FileHasher&lt;/code&gt; type.
         * 
         * Default: #murmur3FFileHasher
         * Group: consumer
         * 
         * @param fileHasher the value to set
         * @return the dsl builder
         */
        default FileWatchEndpointBuilder fileHasher(String fileHasher) {
            doSetProperty("fileHasher", fileHasher);
            return this;
        }
        /**
         * The number of threads polling WatchService. Increase this value, if
         * you see OVERFLOW messages in log.
         * 
         * The option is a: &lt;code&gt;int&lt;/code&gt; type.
         * 
         * Default: 1
         * Group: consumer
         * 
         * @param pollThreads the value to set
         * @return the dsl builder
         */
        default FileWatchEndpointBuilder pollThreads(int pollThreads) {
            doSetProperty("pollThreads", pollThreads);
            return this;
        }
        /**
         * The number of threads polling WatchService. Increase this value, if
         * you see OVERFLOW messages in log.
         * 
         * The option will be converted to a &lt;code&gt;int&lt;/code&gt; type.
         * 
         * Default: 1
         * Group: consumer
         * 
         * @param pollThreads the value to set
         * @return the dsl builder
         */
        default FileWatchEndpointBuilder pollThreads(String pollThreads) {
            doSetProperty("pollThreads", pollThreads);
            return this;
        }
        /**
         * Maximum size of queue between WatchService and consumer. Unbounded by
         * default.
         * 
         * The option is a: &lt;code&gt;int&lt;/code&gt; type.
         * 
         * Default: 2147483647
         * Group: consumer
         * 
         * @param queueSize the value to set
         * @return the dsl builder
         */
        default FileWatchEndpointBuilder queueSize(int queueSize) {
            doSetProperty("queueSize", queueSize);
            return this;
        }
        /**
         * Maximum size of queue between WatchService and consumer. Unbounded by
         * default.
         * 
         * The option will be converted to a &lt;code&gt;int&lt;/code&gt; type.
         * 
         * Default: 2147483647
         * Group: consumer
         * 
         * @param queueSize the value to set
         * @return the dsl builder
         */
        default FileWatchEndpointBuilder queueSize(String queueSize) {
            doSetProperty("queueSize", queueSize);
            return this;
        }
        /**
         * Watch recursive in current and child directories (including newly
         * created directories).
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: true
         * Group: consumer
         * 
         * @param recursive the value to set
         * @return the dsl builder
         */
        default FileWatchEndpointBuilder recursive(boolean recursive) {
            doSetProperty("recursive", recursive);
            return this;
        }
        /**
         * Watch recursive in current and child directories (including newly
         * created directories).
         * 
         * The option will be converted to a &lt;code&gt;boolean&lt;/code&gt;
         * type.
         * 
         * Default: true
         * Group: consumer
         * 
         * @param recursive the value to set
         * @return the dsl builder
         */
        default FileWatchEndpointBuilder recursive(String recursive) {
            doSetProperty("recursive", recursive);
            return this;
        }
        /**
         * Enables or disables file hashing to detect duplicate events. If you
         * disable this, you can get some events multiple times on some
         * platforms and JDKs. Check java.nio.file.WatchService limitations for
         * your target platform.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: true
         * Group: consumer
         * 
         * @param useFileHashing the value to set
         * @return the dsl builder
         */
        default FileWatchEndpointBuilder useFileHashing(boolean useFileHashing) {
            doSetProperty("useFileHashing", useFileHashing);
            return this;
        }
        /**
         * Enables or disables file hashing to detect duplicate events. If you
         * disable this, you can get some events multiple times on some
         * platforms and JDKs. Check java.nio.file.WatchService limitations for
         * your target platform.
         * 
         * The option will be converted to a &lt;code&gt;boolean&lt;/code&gt;
         * type.
         * 
         * Default: true
         * Group: consumer
         * 
         * @param useFileHashing the value to set
         * @return the dsl builder
         */
        default FileWatchEndpointBuilder useFileHashing(String useFileHashing) {
            doSetProperty("useFileHashing", useFileHashing);
            return this;
        }
    }

    /**
     * Advanced builder for endpoint for the File Watch component.
     */
    public interface AdvancedFileWatchEndpointBuilder
            extends
                EndpointConsumerBuilder {
        default FileWatchEndpointBuilder basic() {
            return (FileWatchEndpointBuilder) this;
        }
        /**
         * Allows for bridging the consumer to the Camel routing Error Handler,
         * which mean any exceptions occurred while the consumer is trying to
         * pickup incoming messages, or the likes, will now be processed as a
         * message and handled by the routing Error Handler. By default the
         * consumer will use the org.apache.camel.spi.ExceptionHandler to deal
         * with exceptions, that will be logged at WARN or ERROR level and
         * ignored.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: false
         * Group: consumer (advanced)
         * 
         * @param bridgeErrorHandler the value to set
         * @return the dsl builder
         */
        default AdvancedFileWatchEndpointBuilder bridgeErrorHandler(
                boolean bridgeErrorHandler) {
            doSetProperty("bridgeErrorHandler", bridgeErrorHandler);
            return this;
        }
        /**
         * Allows for bridging the consumer to the Camel routing Error Handler,
         * which mean any exceptions occurred while the consumer is trying to
         * pickup incoming messages, or the likes, will now be processed as a
         * message and handled by the routing Error Handler. By default the
         * consumer will use the org.apache.camel.spi.ExceptionHandler to deal
         * with exceptions, that will be logged at WARN or ERROR level and
         * ignored.
         * 
         * The option will be converted to a &lt;code&gt;boolean&lt;/code&gt;
         * type.
         * 
         * Default: false
         * Group: consumer (advanced)
         * 
         * @param bridgeErrorHandler the value to set
         * @return the dsl builder
         */
        default AdvancedFileWatchEndpointBuilder bridgeErrorHandler(
                String bridgeErrorHandler) {
            doSetProperty("bridgeErrorHandler", bridgeErrorHandler);
            return this;
        }
        /**
         * To let the consumer use a custom ExceptionHandler. Notice if the
         * option bridgeErrorHandler is enabled then this option is not in use.
         * By default the consumer will deal with exceptions, that will be
         * logged at WARN or ERROR level and ignored.
         * 
         * The option is a:
         * &lt;code&gt;org.apache.camel.spi.ExceptionHandler&lt;/code&gt; type.
         * 
         * Group: consumer (advanced)
         * 
         * @param exceptionHandler the value to set
         * @return the dsl builder
         */
        default AdvancedFileWatchEndpointBuilder exceptionHandler(
                org.apache.camel.spi.ExceptionHandler exceptionHandler) {
            doSetProperty("exceptionHandler", exceptionHandler);
            return this;
        }
        /**
         * To let the consumer use a custom ExceptionHandler. Notice if the
         * option bridgeErrorHandler is enabled then this option is not in use.
         * By default the consumer will deal with exceptions, that will be
         * logged at WARN or ERROR level and ignored.
         * 
         * The option will be converted to a
         * &lt;code&gt;org.apache.camel.spi.ExceptionHandler&lt;/code&gt; type.
         * 
         * Group: consumer (advanced)
         * 
         * @param exceptionHandler the value to set
         * @return the dsl builder
         */
        default AdvancedFileWatchEndpointBuilder exceptionHandler(
                String exceptionHandler) {
            doSetProperty("exceptionHandler", exceptionHandler);
            return this;
        }
        /**
         * Sets the exchange pattern when the consumer creates an exchange.
         * 
         * The option is a:
         * &lt;code&gt;org.apache.camel.ExchangePattern&lt;/code&gt; type.
         * 
         * Group: consumer (advanced)
         * 
         * @param exchangePattern the value to set
         * @return the dsl builder
         */
        default AdvancedFileWatchEndpointBuilder exchangePattern(
                org.apache.camel.ExchangePattern exchangePattern) {
            doSetProperty("exchangePattern", exchangePattern);
            return this;
        }
        /**
         * Sets the exchange pattern when the consumer creates an exchange.
         * 
         * The option will be converted to a
         * &lt;code&gt;org.apache.camel.ExchangePattern&lt;/code&gt; type.
         * 
         * Group: consumer (advanced)
         * 
         * @param exchangePattern the value to set
         * @return the dsl builder
         */
        default AdvancedFileWatchEndpointBuilder exchangePattern(
                String exchangePattern) {
            doSetProperty("exchangePattern", exchangePattern);
            return this;
        }
    }

    public interface FileWatchBuilders {
        /**
         * File Watch (camel-file-watch)
         * Get notified about file events in a directory using
         * java.nio.file.WatchService.
         * 
         * Category: file
         * Since: 3.0
         * Maven coordinates: org.apache.camel:camel-file-watch
         * 
         * @return the dsl builder for the headers' name.
         */
        default FileWatchHeaderNameBuilder fileWatch() {
            return FileWatchHeaderNameBuilder.INSTANCE;
        }
        /**
         * File Watch (camel-file-watch)
         * Get notified about file events in a directory using
         * java.nio.file.WatchService.
         * 
         * Category: file
         * Since: 3.0
         * Maven coordinates: org.apache.camel:camel-file-watch
         * 
         * Syntax: <code>file-watch:path</code>
         * 
         * Path parameter: path (required)
         * Path of directory to consume events from.
         * 
         * @param path path
         * @return the dsl builder
         */
        default FileWatchEndpointBuilder fileWatch(String path) {
            return FileWatchEndpointBuilderFactory.endpointBuilder("file-watch", path);
        }
        /**
         * File Watch (camel-file-watch)
         * Get notified about file events in a directory using
         * java.nio.file.WatchService.
         * 
         * Category: file
         * Since: 3.0
         * Maven coordinates: org.apache.camel:camel-file-watch
         * 
         * Syntax: <code>file-watch:path</code>
         * 
         * Path parameter: path (required)
         * Path of directory to consume events from.
         * 
         * @param componentName to use a custom component name for the endpoint
         * instead of the default name
         * @param path path
         * @return the dsl builder
         */
        default FileWatchEndpointBuilder fileWatch(
                String componentName,
                String path) {
            return FileWatchEndpointBuilderFactory.endpointBuilder(componentName, path);
        }
    }

    /**
     * The builder of headers' name for the File Watch component.
     */
    public static class FileWatchHeaderNameBuilder {
        /**
         * The internal instance of the builder used to access to all the
         * methods representing the name of headers.
         */
        private static final FileWatchHeaderNameBuilder INSTANCE = new FileWatchHeaderNameBuilder();

        /**
         * Type of event. Possible values: CREATE, DELETE, MODIFY.
         * 
         * The option is a: {@code String} type.
         * 
         * Group: consumer
         * 
         * @return the name of the header {@code FileEventType}.
         */
        public String fileEventType() {
            return "FileEventType";
        }

        /**
         * Only the file name (the name with no leading paths).
         * 
         * The option is a: {@code String} type.
         * 
         * Group: consumer
         * 
         * @return the name of the header {@code FileNameOnly}.
         */
        public String fileNameOnly() {
            return "FileNameOnly";
        }

        /**
         * A boolean option specifying whether the consumed file denotes an
         * absolute path or not. Should normally be false for relative paths.
         * Absolute paths should normally not be used but we added to the move
         * option to allow moving files to absolute paths. But can be used
         * elsewhere as well.
         * 
         * The option is a: {@code Boolean} type.
         * 
         * Group: consumer
         * 
         * @return the name of the header {@code FileAbsolute}.
         */
        public String fileAbsolute() {
            return "FileAbsolute";
        }

        /**
         * The absolute path to the file. For relative files this path holds the
         * relative path instead.
         * 
         * The option is a: {@code String} type.
         * 
         * Group: consumer
         * 
         * @return the name of the header {@code FileAbsolutePath}.
         */
        public String fileAbsolutePath() {
            return "FileAbsolutePath";
        }

        /**
         * The file path. For relative files this is the starting directory the
         * relative filename. For absolute files this is the absolute path.
         * 
         * The option is a: {@code String} type.
         * 
         * Group: consumer
         * 
         * @return the name of the header {@code FilePath}.
         */
        public String filePath() {
            return "FilePath";
        }

        /**
         * Name of the consumed file as a relative file path with offset from
         * the starting directory configured on the endpoint.
         * 
         * The option is a: {@code String} type.
         * 
         * Group: consumer
         * 
         * @return the name of the header {@code FileName}.
         */
        public String fileName() {
            return "FileName";
        }

        /**
         * The relative path.
         * 
         * The option is a: {@code String} type.
         * 
         * Group: consumer
         * 
         * @return the name of the header {@code FileRelativePath}.
         */
        public String fileRelativePath() {
            return "FileRelativePath";
        }

        /**
         * The name of the file that has been consumed.
         * 
         * The option is a: {@code String} type.
         * 
         * Group: consumer
         * 
         * @return the name of the header {@code FileNameConsumed}.
         */
        public String fileNameConsumed() {
            return "FileNameConsumed";
        }

        /**
         * The parent path.
         * 
         * The option is a: {@code String} type.
         * 
         * Group: consumer
         * 
         * @return the name of the header {@code FileParent}.
         */
        public String fileParent() {
            return "FileParent";
        }

        /**
         * A Long value containing the last modified timestamp of the file.
         * 
         * The option is a: {@code long} type.
         * 
         * Group: consumer
         * 
         * @return the name of the header {@code FileLastModified}.
         */
        public String fileLastModified() {
            return "FileLastModified";
        }
    }
    static FileWatchEndpointBuilder endpointBuilder(
            String componentName,
            String path) {
        class FileWatchEndpointBuilderImpl extends AbstractEndpointBuilder implements FileWatchEndpointBuilder, AdvancedFileWatchEndpointBuilder {
            public FileWatchEndpointBuilderImpl(String path) {
                super(componentName, path);
            }
        }
        return new FileWatchEndpointBuilderImpl(path);
    }
}