
/*
 * Camel ApiCollection generated by camel-api-component-maven-plugin
 */
package org.apache.camel.component.zendesk.internal;

import java.util.Arrays;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import org.apache.camel.component.zendesk.ZendeskConfiguration;
import org.apache.camel.component.zendesk.ZendeskEndpointConfiguration;

import org.apache.camel.support.component.ApiCollection;
import org.apache.camel.support.component.ApiMethod;
import org.apache.camel.support.component.ApiMethodHelper;

/**
 * Camel {@link ApiCollection} for Zendesk
 */
public final class ZendeskApiCollection extends ApiCollection<ZendeskApiName, ZendeskConfiguration> {

    private static ZendeskApiCollection collection;

    private ZendeskApiCollection() {
        final Map<String, String> aliases = new HashMap<>();
        final Map<ZendeskApiName, ApiMethodHelper<? extends ApiMethod>> apiHelpers = new EnumMap<>(ZendeskApiName.class);
        final Map<Class<? extends ApiMethod>, ZendeskApiName> apiMethods = new HashMap<>();

        List<String> nullableArgs;

        aliases.clear();
        nullableArgs = Arrays.asList();
        apiHelpers.put(ZendeskApiName.DEFAULT, new ApiMethodHelper<>(ZendeskApiMethod.class, aliases, nullableArgs));
        apiMethods.put(ZendeskApiMethod.class, ZendeskApiName.DEFAULT);

        setApiHelpers(apiHelpers);
        setApiMethods(apiMethods);
    }

    public ZendeskConfiguration getEndpointConfiguration(ZendeskApiName apiName) {
        ZendeskConfiguration result = null;
        switch (apiName) {
            case DEFAULT:
                result = new ZendeskEndpointConfiguration();
                break;
        }
        return result;
    }

    public static synchronized ZendeskApiCollection getCollection() {
        if (collection == null) {
            collection = new ZendeskApiCollection();
        }
        return collection;
    }
}
