
/*
 * Camel ApiCollection generated by camel-api-component-maven-plugin
 */
package org.apache.camel.component.olingo2.internal;

import java.util.Arrays;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import org.apache.camel.component.olingo2.Olingo2Configuration;
import org.apache.camel.component.olingo2.Olingo2AppEndpointConfiguration;

import org.apache.camel.support.component.ApiCollection;
import org.apache.camel.support.component.ApiMethod;
import org.apache.camel.support.component.ApiMethodHelper;

/**
 * Camel {@link ApiCollection} for Olingo2
 */
public final class Olingo2ApiCollection extends ApiCollection<Olingo2ApiName, Olingo2Configuration> {

    private static Olingo2ApiCollection collection;

    private Olingo2ApiCollection() {
        final Map<String, String> aliases = new HashMap<>();
        final Map<Olingo2ApiName, ApiMethodHelper<? extends ApiMethod>> apiHelpers = new EnumMap<>(Olingo2ApiName.class);
        final Map<Class<? extends ApiMethod>, Olingo2ApiName> apiMethods = new HashMap<>();

        List<String> nullableArgs;

        aliases.clear();
        nullableArgs = Arrays.asList("queryParams", "endpointHttpHeaders", "edm", "responseHandler");
        apiHelpers.put(Olingo2ApiName.DEFAULT, new ApiMethodHelper<>(Olingo2AppApiMethod.class, aliases, nullableArgs));
        apiMethods.put(Olingo2AppApiMethod.class, Olingo2ApiName.DEFAULT);

        setApiHelpers(apiHelpers);
        setApiMethods(apiMethods);
    }

    public Olingo2Configuration getEndpointConfiguration(Olingo2ApiName apiName) {
        Olingo2Configuration result = null;
        switch (apiName) {
            case DEFAULT:
                result = new Olingo2AppEndpointConfiguration();
                break;
        }
        return result;
    }

    public static synchronized Olingo2ApiCollection getCollection() {
        if (collection == null) {
            collection = new Olingo2ApiCollection();
        }
        return collection;
    }
}
