
/*
 * Camel ApiCollection generated by camel-api-component-maven-plugin
 */
package org.apache.camel.component.as2.internal;

import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.HashMap;

import org.apache.camel.component.as2.AS2Configuration;
import org.apache.camel.component.as2.AS2ClientManagerEndpointConfiguration;
import org.apache.camel.component.as2.AS2ServerManagerEndpointConfiguration;

import org.apache.camel.support.component.ApiCollection;
import org.apache.camel.support.component.ApiMethod;
import org.apache.camel.support.component.ApiMethodHelper;

/**
 * Camel {@link ApiCollection} for AS2
 */
public final class AS2ApiCollection extends ApiCollection<AS2ApiName, AS2Configuration> {

    private static AS2ApiCollection collection;

    private AS2ApiCollection() {
        final Map<String, String> aliases = new HashMap<String, String>();
        final Map<AS2ApiName, ApiMethodHelper<? extends ApiMethod>> apiHelpers = new HashMap<>();
        final Map<Class<? extends ApiMethod>, AS2ApiName> apiMethods = new HashMap<>();

        List<String> nullableArgs;

        aliases.clear();
        nullableArgs = Arrays.asList("ediMessageTransferEncoding", "signingAlgorithm", "signingCertificateChain", "signingPrivateKey", "compressionAlgorithm", "dispositionNotificationTo", "signedReceiptMicAlgorithms", "encryptingAlgorithm", "encryptingCertificateChain", "attachedFileName");
        apiHelpers.put(AS2ApiName.CLIENT, new ApiMethodHelper<AS2ClientManagerApiMethod>(AS2ClientManagerApiMethod.class, aliases, nullableArgs));
        apiMethods.put(AS2ClientManagerApiMethod.class, AS2ApiName.CLIENT);

        aliases.clear();
        nullableArgs = Arrays.asList();
        apiHelpers.put(AS2ApiName.SERVER, new ApiMethodHelper<AS2ServerManagerApiMethod>(AS2ServerManagerApiMethod.class, aliases, nullableArgs));
        apiMethods.put(AS2ServerManagerApiMethod.class, AS2ApiName.SERVER);

        setApiHelpers(apiHelpers);
        setApiMethods(apiMethods);
    }

    public AS2Configuration getEndpointConfiguration(AS2ApiName apiName) {
        AS2Configuration result = null;
        switch (apiName) {
            case CLIENT:
                result = new AS2ClientManagerEndpointConfiguration();
                break;
            case SERVER:
                result = new AS2ServerManagerEndpointConfiguration();
                break;
        }
        return result;
    }

    public static synchronized AS2ApiCollection getCollection() {
        if (collection == null) {
            collection = new AS2ApiCollection();
        }
        return collection;
    }
}
