/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.apache.camel.test.infra.minio.common;

public final class MinioProperties {
    public static final String ACCESS_KEY = "minio.access.key";
    public static final String SECRET_KEY = "minio.secret.key";
    public static final String USERNAME = "minio.access.username";
    public static final String SERVICE_HOST = "minio.service.host";
    public static final String SERVICE_PORT = "minio.service.port";
    public static final int DEFAULT_SERVICE_PORT = 9000;

    private MinioProperties() {

    }
}
