/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.apache.camel.builder.endpoint.dsl;

import java.time.Duration;
import javax.annotation.Generated;
import org.apache.camel.ExchangePattern;
import org.apache.camel.builder.EndpointConsumerBuilder;
import org.apache.camel.builder.EndpointProducerBuilder;
import org.apache.camel.builder.endpoint.AbstractEndpointBuilder;
import org.apache.camel.spi.ExceptionHandler;

/**
 * The azure-storage-queue component is used for storing and retrieving the
 * messages to/from Azure Storage Queue using Azure SDK v12.
 * 
 * Generated by camel build tools - do NOT edit this file!
 */
@Generated("org.apache.camel.maven.packaging.EndpointDslMojo")
public interface QueueEndpointBuilderFactory {


    /**
     * Builder for endpoint consumers for the Azure Storage Queue Service
     * component.
     */
    public interface QueueEndpointConsumerBuilder
            extends
                EndpointConsumerBuilder {
        default AdvancedQueueEndpointConsumerBuilder advanced() {
            return (AdvancedQueueEndpointConsumerBuilder) this;
        }
        /**
         * Setting the autoDiscoverClient mechanism, if true, the component will
         * look for a client instance in the registry automatically otherwise it
         * will skip that checking.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: true
         * Group: common
         * 
         * @param autoDiscoverClient the value to set
         * @return the dsl builder
         */
        default QueueEndpointConsumerBuilder autoDiscoverClient(
                boolean autoDiscoverClient) {
            doSetProperty("autoDiscoverClient", autoDiscoverClient);
            return this;
        }
        /**
         * Setting the autoDiscoverClient mechanism, if true, the component will
         * look for a client instance in the registry automatically otherwise it
         * will skip that checking.
         * 
         * The option will be converted to a &lt;code&gt;boolean&lt;/code&gt;
         * type.
         * 
         * Default: true
         * Group: common
         * 
         * @param autoDiscoverClient the value to set
         * @return the dsl builder
         */
        default QueueEndpointConsumerBuilder autoDiscoverClient(
                String autoDiscoverClient) {
            doSetProperty("autoDiscoverClient", autoDiscoverClient);
            return this;
        }
        /**
         * Service client to a storage account to interact with the queue
         * service. This client does not hold any state about a particular
         * storage account but is instead a convenient way of sending off
         * appropriate requests to the resource on the service. This client
         * contains all the operations for interacting with a queue account in
         * Azure Storage. Operations allowed by the client are creating,
         * listing, and deleting queues, retrieving and updating properties of
         * the account, and retrieving statistics of the account.
         * 
         * The option is a:
         * &lt;code&gt;com.azure.storage.queue.QueueServiceClient&lt;/code&gt;
         * type.
         * 
         * Group: common
         * 
         * @param serviceClient the value to set
         * @return the dsl builder
         */
        default QueueEndpointConsumerBuilder serviceClient(Object serviceClient) {
            doSetProperty("serviceClient", serviceClient);
            return this;
        }
        /**
         * Service client to a storage account to interact with the queue
         * service. This client does not hold any state about a particular
         * storage account but is instead a convenient way of sending off
         * appropriate requests to the resource on the service. This client
         * contains all the operations for interacting with a queue account in
         * Azure Storage. Operations allowed by the client are creating,
         * listing, and deleting queues, retrieving and updating properties of
         * the account, and retrieving statistics of the account.
         * 
         * The option will be converted to a
         * &lt;code&gt;com.azure.storage.queue.QueueServiceClient&lt;/code&gt;
         * type.
         * 
         * Group: common
         * 
         * @param serviceClient the value to set
         * @return the dsl builder
         */
        default QueueEndpointConsumerBuilder serviceClient(String serviceClient) {
            doSetProperty("serviceClient", serviceClient);
            return this;
        }
        /**
         * Allows for bridging the consumer to the Camel routing Error Handler,
         * which mean any exceptions occurred while the consumer is trying to
         * pickup incoming messages, or the likes, will now be processed as a
         * message and handled by the routing Error Handler. By default the
         * consumer will use the org.apache.camel.spi.ExceptionHandler to deal
         * with exceptions, that will be logged at WARN or ERROR level and
         * ignored.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: false
         * Group: consumer
         * 
         * @param bridgeErrorHandler the value to set
         * @return the dsl builder
         */
        default QueueEndpointConsumerBuilder bridgeErrorHandler(
                boolean bridgeErrorHandler) {
            doSetProperty("bridgeErrorHandler", bridgeErrorHandler);
            return this;
        }
        /**
         * Allows for bridging the consumer to the Camel routing Error Handler,
         * which mean any exceptions occurred while the consumer is trying to
         * pickup incoming messages, or the likes, will now be processed as a
         * message and handled by the routing Error Handler. By default the
         * consumer will use the org.apache.camel.spi.ExceptionHandler to deal
         * with exceptions, that will be logged at WARN or ERROR level and
         * ignored.
         * 
         * The option will be converted to a &lt;code&gt;boolean&lt;/code&gt;
         * type.
         * 
         * Default: false
         * Group: consumer
         * 
         * @param bridgeErrorHandler the value to set
         * @return the dsl builder
         */
        default QueueEndpointConsumerBuilder bridgeErrorHandler(
                String bridgeErrorHandler) {
            doSetProperty("bridgeErrorHandler", bridgeErrorHandler);
            return this;
        }
        /**
         * Maximum number of messages to get, if there are less messages exist
         * in the queue than requested all the messages will be returned. If
         * left empty only 1 message will be retrieved, the allowed range is 1
         * to 32 messages.
         * 
         * The option is a: &lt;code&gt;java.lang.Integer&lt;/code&gt; type.
         * 
         * Default: 1
         * Group: queue
         * 
         * @param maxMessages the value to set
         * @return the dsl builder
         */
        default QueueEndpointConsumerBuilder maxMessages(Integer maxMessages) {
            doSetProperty("maxMessages", maxMessages);
            return this;
        }
        /**
         * Maximum number of messages to get, if there are less messages exist
         * in the queue than requested all the messages will be returned. If
         * left empty only 1 message will be retrieved, the allowed range is 1
         * to 32 messages.
         * 
         * The option will be converted to a
         * &lt;code&gt;java.lang.Integer&lt;/code&gt; type.
         * 
         * Default: 1
         * Group: queue
         * 
         * @param maxMessages the value to set
         * @return the dsl builder
         */
        default QueueEndpointConsumerBuilder maxMessages(String maxMessages) {
            doSetProperty("maxMessages", maxMessages);
            return this;
        }
        /**
         * The ID of the message to be deleted or updated.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: queue
         * 
         * @param messageId the value to set
         * @return the dsl builder
         */
        default QueueEndpointConsumerBuilder messageId(String messageId) {
            doSetProperty("messageId", messageId);
            return this;
        }
        /**
         * Unique identifier that must match for the message to be deleted or
         * updated.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: queue
         * 
         * @param popReceipt the value to set
         * @return the dsl builder
         */
        default QueueEndpointConsumerBuilder popReceipt(String popReceipt) {
            doSetProperty("popReceipt", popReceipt);
            return this;
        }
        /**
         * An optional timeout applied to the operation. If a response is not
         * returned before the timeout concludes a RuntimeException will be
         * thrown.
         * 
         * The option is a: &lt;code&gt;java.time.Duration&lt;/code&gt; type.
         * 
         * Group: queue
         * 
         * @param timeout the value to set
         * @return the dsl builder
         */
        default QueueEndpointConsumerBuilder timeout(Duration timeout) {
            doSetProperty("timeout", timeout);
            return this;
        }
        /**
         * An optional timeout applied to the operation. If a response is not
         * returned before the timeout concludes a RuntimeException will be
         * thrown.
         * 
         * The option will be converted to a
         * &lt;code&gt;java.time.Duration&lt;/code&gt; type.
         * 
         * Group: queue
         * 
         * @param timeout the value to set
         * @return the dsl builder
         */
        default QueueEndpointConsumerBuilder timeout(String timeout) {
            doSetProperty("timeout", timeout);
            return this;
        }
        /**
         * How long the message will stay alive in the queue. If unset the value
         * will default to 7 days, if -1 is passed the message will not expire.
         * The time to live must be -1 or any positive number. The format should
         * be in this form: PnDTnHnMn.nS., e.g: PT20.345S -- parses as 20.345
         * seconds, P2D -- parses as 2 days However, in case you are using
         * EndpointDsl/ComponentDsl, you can do something like
         * Duration.ofSeconds() since these Java APIs are typesafe.
         * 
         * The option is a: &lt;code&gt;java.time.Duration&lt;/code&gt; type.
         * 
         * Group: queue
         * 
         * @param timeToLive the value to set
         * @return the dsl builder
         */
        default QueueEndpointConsumerBuilder timeToLive(Duration timeToLive) {
            doSetProperty("timeToLive", timeToLive);
            return this;
        }
        /**
         * How long the message will stay alive in the queue. If unset the value
         * will default to 7 days, if -1 is passed the message will not expire.
         * The time to live must be -1 or any positive number. The format should
         * be in this form: PnDTnHnMn.nS., e.g: PT20.345S -- parses as 20.345
         * seconds, P2D -- parses as 2 days However, in case you are using
         * EndpointDsl/ComponentDsl, you can do something like
         * Duration.ofSeconds() since these Java APIs are typesafe.
         * 
         * The option will be converted to a
         * &lt;code&gt;java.time.Duration&lt;/code&gt; type.
         * 
         * Group: queue
         * 
         * @param timeToLive the value to set
         * @return the dsl builder
         */
        default QueueEndpointConsumerBuilder timeToLive(String timeToLive) {
            doSetProperty("timeToLive", timeToLive);
            return this;
        }
        /**
         * The timeout period for how long the message is invisible in the
         * queue. The timeout must be between 1 seconds and 7 days. The format
         * should be in this form: PnDTnHnMn.nS., e.g: PT20.345S -- parses as
         * 20.345 seconds, P2D -- parses as 2 days However, in case you are
         * using EndpointDsl/ComponentDsl, you can do something like
         * Duration.ofSeconds() since these Java APIs are typesafe.
         * 
         * The option is a: &lt;code&gt;java.time.Duration&lt;/code&gt; type.
         * 
         * Group: queue
         * 
         * @param visibilityTimeout the value to set
         * @return the dsl builder
         */
        default QueueEndpointConsumerBuilder visibilityTimeout(
                Duration visibilityTimeout) {
            doSetProperty("visibilityTimeout", visibilityTimeout);
            return this;
        }
        /**
         * The timeout period for how long the message is invisible in the
         * queue. The timeout must be between 1 seconds and 7 days. The format
         * should be in this form: PnDTnHnMn.nS., e.g: PT20.345S -- parses as
         * 20.345 seconds, P2D -- parses as 2 days However, in case you are
         * using EndpointDsl/ComponentDsl, you can do something like
         * Duration.ofSeconds() since these Java APIs are typesafe.
         * 
         * The option will be converted to a
         * &lt;code&gt;java.time.Duration&lt;/code&gt; type.
         * 
         * Group: queue
         * 
         * @param visibilityTimeout the value to set
         * @return the dsl builder
         */
        default QueueEndpointConsumerBuilder visibilityTimeout(
                String visibilityTimeout) {
            doSetProperty("visibilityTimeout", visibilityTimeout);
            return this;
        }
        /**
         * Access key for the associated azure account name to be used for
         * authentication with azure queue services.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: security
         * 
         * @param accessKey the value to set
         * @return the dsl builder
         */
        default QueueEndpointConsumerBuilder accessKey(String accessKey) {
            doSetProperty("accessKey", accessKey);
            return this;
        }
        /**
         * StorageSharedKeyCredential can be injected to create the azure
         * client, this holds the important authentication information.
         * 
         * The option is a:
         * &lt;code&gt;com.azure.storage.common.StorageSharedKeyCredential&lt;/code&gt; type.
         * 
         * Group: security
         * 
         * @param credentials the value to set
         * @return the dsl builder
         */
        default QueueEndpointConsumerBuilder credentials(Object credentials) {
            doSetProperty("credentials", credentials);
            return this;
        }
        /**
         * StorageSharedKeyCredential can be injected to create the azure
         * client, this holds the important authentication information.
         * 
         * The option will be converted to a
         * &lt;code&gt;com.azure.storage.common.StorageSharedKeyCredential&lt;/code&gt; type.
         * 
         * Group: security
         * 
         * @param credentials the value to set
         * @return the dsl builder
         */
        default QueueEndpointConsumerBuilder credentials(String credentials) {
            doSetProperty("credentials", credentials);
            return this;
        }
    }

    /**
     * Advanced builder for endpoint consumers for the Azure Storage Queue
     * Service component.
     */
    public interface AdvancedQueueEndpointConsumerBuilder
            extends
                EndpointConsumerBuilder {
        default QueueEndpointConsumerBuilder basic() {
            return (QueueEndpointConsumerBuilder) this;
        }
        /**
         * To let the consumer use a custom ExceptionHandler. Notice if the
         * option bridgeErrorHandler is enabled then this option is not in use.
         * By default the consumer will deal with exceptions, that will be
         * logged at WARN or ERROR level and ignored.
         * 
         * The option is a:
         * &lt;code&gt;org.apache.camel.spi.ExceptionHandler&lt;/code&gt; type.
         * 
         * Group: consumer (advanced)
         * 
         * @param exceptionHandler the value to set
         * @return the dsl builder
         */
        default AdvancedQueueEndpointConsumerBuilder exceptionHandler(
                ExceptionHandler exceptionHandler) {
            doSetProperty("exceptionHandler", exceptionHandler);
            return this;
        }
        /**
         * To let the consumer use a custom ExceptionHandler. Notice if the
         * option bridgeErrorHandler is enabled then this option is not in use.
         * By default the consumer will deal with exceptions, that will be
         * logged at WARN or ERROR level and ignored.
         * 
         * The option will be converted to a
         * &lt;code&gt;org.apache.camel.spi.ExceptionHandler&lt;/code&gt; type.
         * 
         * Group: consumer (advanced)
         * 
         * @param exceptionHandler the value to set
         * @return the dsl builder
         */
        default AdvancedQueueEndpointConsumerBuilder exceptionHandler(
                String exceptionHandler) {
            doSetProperty("exceptionHandler", exceptionHandler);
            return this;
        }
        /**
         * Sets the exchange pattern when the consumer creates an exchange.
         * 
         * The option is a:
         * &lt;code&gt;org.apache.camel.ExchangePattern&lt;/code&gt; type.
         * 
         * Group: consumer (advanced)
         * 
         * @param exchangePattern the value to set
         * @return the dsl builder
         */
        default AdvancedQueueEndpointConsumerBuilder exchangePattern(
                ExchangePattern exchangePattern) {
            doSetProperty("exchangePattern", exchangePattern);
            return this;
        }
        /**
         * Sets the exchange pattern when the consumer creates an exchange.
         * 
         * The option will be converted to a
         * &lt;code&gt;org.apache.camel.ExchangePattern&lt;/code&gt; type.
         * 
         * Group: consumer (advanced)
         * 
         * @param exchangePattern the value to set
         * @return the dsl builder
         */
        default AdvancedQueueEndpointConsumerBuilder exchangePattern(
                String exchangePattern) {
            doSetProperty("exchangePattern", exchangePattern);
            return this;
        }
    }

    /**
     * Builder for endpoint producers for the Azure Storage Queue Service
     * component.
     */
    public interface QueueEndpointProducerBuilder
            extends
                EndpointProducerBuilder {
        default AdvancedQueueEndpointProducerBuilder advanced() {
            return (AdvancedQueueEndpointProducerBuilder) this;
        }
        /**
         * Setting the autoDiscoverClient mechanism, if true, the component will
         * look for a client instance in the registry automatically otherwise it
         * will skip that checking.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: true
         * Group: common
         * 
         * @param autoDiscoverClient the value to set
         * @return the dsl builder
         */
        default QueueEndpointProducerBuilder autoDiscoverClient(
                boolean autoDiscoverClient) {
            doSetProperty("autoDiscoverClient", autoDiscoverClient);
            return this;
        }
        /**
         * Setting the autoDiscoverClient mechanism, if true, the component will
         * look for a client instance in the registry automatically otherwise it
         * will skip that checking.
         * 
         * The option will be converted to a &lt;code&gt;boolean&lt;/code&gt;
         * type.
         * 
         * Default: true
         * Group: common
         * 
         * @param autoDiscoverClient the value to set
         * @return the dsl builder
         */
        default QueueEndpointProducerBuilder autoDiscoverClient(
                String autoDiscoverClient) {
            doSetProperty("autoDiscoverClient", autoDiscoverClient);
            return this;
        }
        /**
         * Service client to a storage account to interact with the queue
         * service. This client does not hold any state about a particular
         * storage account but is instead a convenient way of sending off
         * appropriate requests to the resource on the service. This client
         * contains all the operations for interacting with a queue account in
         * Azure Storage. Operations allowed by the client are creating,
         * listing, and deleting queues, retrieving and updating properties of
         * the account, and retrieving statistics of the account.
         * 
         * The option is a:
         * &lt;code&gt;com.azure.storage.queue.QueueServiceClient&lt;/code&gt;
         * type.
         * 
         * Group: common
         * 
         * @param serviceClient the value to set
         * @return the dsl builder
         */
        default QueueEndpointProducerBuilder serviceClient(Object serviceClient) {
            doSetProperty("serviceClient", serviceClient);
            return this;
        }
        /**
         * Service client to a storage account to interact with the queue
         * service. This client does not hold any state about a particular
         * storage account but is instead a convenient way of sending off
         * appropriate requests to the resource on the service. This client
         * contains all the operations for interacting with a queue account in
         * Azure Storage. Operations allowed by the client are creating,
         * listing, and deleting queues, retrieving and updating properties of
         * the account, and retrieving statistics of the account.
         * 
         * The option will be converted to a
         * &lt;code&gt;com.azure.storage.queue.QueueServiceClient&lt;/code&gt;
         * type.
         * 
         * Group: common
         * 
         * @param serviceClient the value to set
         * @return the dsl builder
         */
        default QueueEndpointProducerBuilder serviceClient(String serviceClient) {
            doSetProperty("serviceClient", serviceClient);
            return this;
        }
        /**
         * When is set to true, the queue will be automatically created when
         * sending messages to the queue.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: true
         * Group: producer
         * 
         * @param createQueue the value to set
         * @return the dsl builder
         */
        default QueueEndpointProducerBuilder createQueue(boolean createQueue) {
            doSetProperty("createQueue", createQueue);
            return this;
        }
        /**
         * When is set to true, the queue will be automatically created when
         * sending messages to the queue.
         * 
         * The option will be converted to a &lt;code&gt;boolean&lt;/code&gt;
         * type.
         * 
         * Default: true
         * Group: producer
         * 
         * @param createQueue the value to set
         * @return the dsl builder
         */
        default QueueEndpointProducerBuilder createQueue(String createQueue) {
            doSetProperty("createQueue", createQueue);
            return this;
        }
        /**
         * Whether the producer should be started lazy (on the first message).
         * By starting lazy you can use this to allow CamelContext and routes to
         * startup in situations where a producer may otherwise fail during
         * starting and cause the route to fail being started. By deferring this
         * startup to be lazy then the startup failure can be handled during
         * routing messages via Camel's routing error handlers. Beware that when
         * the first message is processed then creating and starting the
         * producer may take a little time and prolong the total processing time
         * of the processing.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: false
         * Group: producer
         * 
         * @param lazyStartProducer the value to set
         * @return the dsl builder
         */
        default QueueEndpointProducerBuilder lazyStartProducer(
                boolean lazyStartProducer) {
            doSetProperty("lazyStartProducer", lazyStartProducer);
            return this;
        }
        /**
         * Whether the producer should be started lazy (on the first message).
         * By starting lazy you can use this to allow CamelContext and routes to
         * startup in situations where a producer may otherwise fail during
         * starting and cause the route to fail being started. By deferring this
         * startup to be lazy then the startup failure can be handled during
         * routing messages via Camel's routing error handlers. Beware that when
         * the first message is processed then creating and starting the
         * producer may take a little time and prolong the total processing time
         * of the processing.
         * 
         * The option will be converted to a &lt;code&gt;boolean&lt;/code&gt;
         * type.
         * 
         * Default: false
         * Group: producer
         * 
         * @param lazyStartProducer the value to set
         * @return the dsl builder
         */
        default QueueEndpointProducerBuilder lazyStartProducer(
                String lazyStartProducer) {
            doSetProperty("lazyStartProducer", lazyStartProducer);
            return this;
        }
        /**
         * Queue service operation hint to the producer.
         * 
         * The option is a:
         * &lt;code&gt;org.apache.camel.component.azure.storage.queue.QueueOperationDefinition&lt;/code&gt; type.
         * 
         * Group: producer
         * 
         * @param operation the value to set
         * @return the dsl builder
         */
        default QueueEndpointProducerBuilder operation(
                QueueOperationDefinition operation) {
            doSetProperty("operation", operation);
            return this;
        }
        /**
         * Queue service operation hint to the producer.
         * 
         * The option will be converted to a
         * &lt;code&gt;org.apache.camel.component.azure.storage.queue.QueueOperationDefinition&lt;/code&gt; type.
         * 
         * Group: producer
         * 
         * @param operation the value to set
         * @return the dsl builder
         */
        default QueueEndpointProducerBuilder operation(String operation) {
            doSetProperty("operation", operation);
            return this;
        }
        /**
         * Maximum number of messages to get, if there are less messages exist
         * in the queue than requested all the messages will be returned. If
         * left empty only 1 message will be retrieved, the allowed range is 1
         * to 32 messages.
         * 
         * The option is a: &lt;code&gt;java.lang.Integer&lt;/code&gt; type.
         * 
         * Default: 1
         * Group: queue
         * 
         * @param maxMessages the value to set
         * @return the dsl builder
         */
        default QueueEndpointProducerBuilder maxMessages(Integer maxMessages) {
            doSetProperty("maxMessages", maxMessages);
            return this;
        }
        /**
         * Maximum number of messages to get, if there are less messages exist
         * in the queue than requested all the messages will be returned. If
         * left empty only 1 message will be retrieved, the allowed range is 1
         * to 32 messages.
         * 
         * The option will be converted to a
         * &lt;code&gt;java.lang.Integer&lt;/code&gt; type.
         * 
         * Default: 1
         * Group: queue
         * 
         * @param maxMessages the value to set
         * @return the dsl builder
         */
        default QueueEndpointProducerBuilder maxMessages(String maxMessages) {
            doSetProperty("maxMessages", maxMessages);
            return this;
        }
        /**
         * The ID of the message to be deleted or updated.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: queue
         * 
         * @param messageId the value to set
         * @return the dsl builder
         */
        default QueueEndpointProducerBuilder messageId(String messageId) {
            doSetProperty("messageId", messageId);
            return this;
        }
        /**
         * Unique identifier that must match for the message to be deleted or
         * updated.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: queue
         * 
         * @param popReceipt the value to set
         * @return the dsl builder
         */
        default QueueEndpointProducerBuilder popReceipt(String popReceipt) {
            doSetProperty("popReceipt", popReceipt);
            return this;
        }
        /**
         * An optional timeout applied to the operation. If a response is not
         * returned before the timeout concludes a RuntimeException will be
         * thrown.
         * 
         * The option is a: &lt;code&gt;java.time.Duration&lt;/code&gt; type.
         * 
         * Group: queue
         * 
         * @param timeout the value to set
         * @return the dsl builder
         */
        default QueueEndpointProducerBuilder timeout(Duration timeout) {
            doSetProperty("timeout", timeout);
            return this;
        }
        /**
         * An optional timeout applied to the operation. If a response is not
         * returned before the timeout concludes a RuntimeException will be
         * thrown.
         * 
         * The option will be converted to a
         * &lt;code&gt;java.time.Duration&lt;/code&gt; type.
         * 
         * Group: queue
         * 
         * @param timeout the value to set
         * @return the dsl builder
         */
        default QueueEndpointProducerBuilder timeout(String timeout) {
            doSetProperty("timeout", timeout);
            return this;
        }
        /**
         * How long the message will stay alive in the queue. If unset the value
         * will default to 7 days, if -1 is passed the message will not expire.
         * The time to live must be -1 or any positive number. The format should
         * be in this form: PnDTnHnMn.nS., e.g: PT20.345S -- parses as 20.345
         * seconds, P2D -- parses as 2 days However, in case you are using
         * EndpointDsl/ComponentDsl, you can do something like
         * Duration.ofSeconds() since these Java APIs are typesafe.
         * 
         * The option is a: &lt;code&gt;java.time.Duration&lt;/code&gt; type.
         * 
         * Group: queue
         * 
         * @param timeToLive the value to set
         * @return the dsl builder
         */
        default QueueEndpointProducerBuilder timeToLive(Duration timeToLive) {
            doSetProperty("timeToLive", timeToLive);
            return this;
        }
        /**
         * How long the message will stay alive in the queue. If unset the value
         * will default to 7 days, if -1 is passed the message will not expire.
         * The time to live must be -1 or any positive number. The format should
         * be in this form: PnDTnHnMn.nS., e.g: PT20.345S -- parses as 20.345
         * seconds, P2D -- parses as 2 days However, in case you are using
         * EndpointDsl/ComponentDsl, you can do something like
         * Duration.ofSeconds() since these Java APIs are typesafe.
         * 
         * The option will be converted to a
         * &lt;code&gt;java.time.Duration&lt;/code&gt; type.
         * 
         * Group: queue
         * 
         * @param timeToLive the value to set
         * @return the dsl builder
         */
        default QueueEndpointProducerBuilder timeToLive(String timeToLive) {
            doSetProperty("timeToLive", timeToLive);
            return this;
        }
        /**
         * The timeout period for how long the message is invisible in the
         * queue. The timeout must be between 1 seconds and 7 days. The format
         * should be in this form: PnDTnHnMn.nS., e.g: PT20.345S -- parses as
         * 20.345 seconds, P2D -- parses as 2 days However, in case you are
         * using EndpointDsl/ComponentDsl, you can do something like
         * Duration.ofSeconds() since these Java APIs are typesafe.
         * 
         * The option is a: &lt;code&gt;java.time.Duration&lt;/code&gt; type.
         * 
         * Group: queue
         * 
         * @param visibilityTimeout the value to set
         * @return the dsl builder
         */
        default QueueEndpointProducerBuilder visibilityTimeout(
                Duration visibilityTimeout) {
            doSetProperty("visibilityTimeout", visibilityTimeout);
            return this;
        }
        /**
         * The timeout period for how long the message is invisible in the
         * queue. The timeout must be between 1 seconds and 7 days. The format
         * should be in this form: PnDTnHnMn.nS., e.g: PT20.345S -- parses as
         * 20.345 seconds, P2D -- parses as 2 days However, in case you are
         * using EndpointDsl/ComponentDsl, you can do something like
         * Duration.ofSeconds() since these Java APIs are typesafe.
         * 
         * The option will be converted to a
         * &lt;code&gt;java.time.Duration&lt;/code&gt; type.
         * 
         * Group: queue
         * 
         * @param visibilityTimeout the value to set
         * @return the dsl builder
         */
        default QueueEndpointProducerBuilder visibilityTimeout(
                String visibilityTimeout) {
            doSetProperty("visibilityTimeout", visibilityTimeout);
            return this;
        }
        /**
         * Access key for the associated azure account name to be used for
         * authentication with azure queue services.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: security
         * 
         * @param accessKey the value to set
         * @return the dsl builder
         */
        default QueueEndpointProducerBuilder accessKey(String accessKey) {
            doSetProperty("accessKey", accessKey);
            return this;
        }
        /**
         * StorageSharedKeyCredential can be injected to create the azure
         * client, this holds the important authentication information.
         * 
         * The option is a:
         * &lt;code&gt;com.azure.storage.common.StorageSharedKeyCredential&lt;/code&gt; type.
         * 
         * Group: security
         * 
         * @param credentials the value to set
         * @return the dsl builder
         */
        default QueueEndpointProducerBuilder credentials(Object credentials) {
            doSetProperty("credentials", credentials);
            return this;
        }
        /**
         * StorageSharedKeyCredential can be injected to create the azure
         * client, this holds the important authentication information.
         * 
         * The option will be converted to a
         * &lt;code&gt;com.azure.storage.common.StorageSharedKeyCredential&lt;/code&gt; type.
         * 
         * Group: security
         * 
         * @param credentials the value to set
         * @return the dsl builder
         */
        default QueueEndpointProducerBuilder credentials(String credentials) {
            doSetProperty("credentials", credentials);
            return this;
        }
    }

    /**
     * Advanced builder for endpoint producers for the Azure Storage Queue
     * Service component.
     */
    public interface AdvancedQueueEndpointProducerBuilder
            extends
                EndpointProducerBuilder {
        default QueueEndpointProducerBuilder basic() {
            return (QueueEndpointProducerBuilder) this;
        }
    }

    /**
     * Builder for endpoint for the Azure Storage Queue Service component.
     */
    public interface QueueEndpointBuilder
            extends
                QueueEndpointConsumerBuilder,
                QueueEndpointProducerBuilder {
        default AdvancedQueueEndpointBuilder advanced() {
            return (AdvancedQueueEndpointBuilder) this;
        }
        /**
         * Setting the autoDiscoverClient mechanism, if true, the component will
         * look for a client instance in the registry automatically otherwise it
         * will skip that checking.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: true
         * Group: common
         * 
         * @param autoDiscoverClient the value to set
         * @return the dsl builder
         */
        default QueueEndpointBuilder autoDiscoverClient(
                boolean autoDiscoverClient) {
            doSetProperty("autoDiscoverClient", autoDiscoverClient);
            return this;
        }
        /**
         * Setting the autoDiscoverClient mechanism, if true, the component will
         * look for a client instance in the registry automatically otherwise it
         * will skip that checking.
         * 
         * The option will be converted to a &lt;code&gt;boolean&lt;/code&gt;
         * type.
         * 
         * Default: true
         * Group: common
         * 
         * @param autoDiscoverClient the value to set
         * @return the dsl builder
         */
        default QueueEndpointBuilder autoDiscoverClient(
                String autoDiscoverClient) {
            doSetProperty("autoDiscoverClient", autoDiscoverClient);
            return this;
        }
        /**
         * Service client to a storage account to interact with the queue
         * service. This client does not hold any state about a particular
         * storage account but is instead a convenient way of sending off
         * appropriate requests to the resource on the service. This client
         * contains all the operations for interacting with a queue account in
         * Azure Storage. Operations allowed by the client are creating,
         * listing, and deleting queues, retrieving and updating properties of
         * the account, and retrieving statistics of the account.
         * 
         * The option is a:
         * &lt;code&gt;com.azure.storage.queue.QueueServiceClient&lt;/code&gt;
         * type.
         * 
         * Group: common
         * 
         * @param serviceClient the value to set
         * @return the dsl builder
         */
        default QueueEndpointBuilder serviceClient(Object serviceClient) {
            doSetProperty("serviceClient", serviceClient);
            return this;
        }
        /**
         * Service client to a storage account to interact with the queue
         * service. This client does not hold any state about a particular
         * storage account but is instead a convenient way of sending off
         * appropriate requests to the resource on the service. This client
         * contains all the operations for interacting with a queue account in
         * Azure Storage. Operations allowed by the client are creating,
         * listing, and deleting queues, retrieving and updating properties of
         * the account, and retrieving statistics of the account.
         * 
         * The option will be converted to a
         * &lt;code&gt;com.azure.storage.queue.QueueServiceClient&lt;/code&gt;
         * type.
         * 
         * Group: common
         * 
         * @param serviceClient the value to set
         * @return the dsl builder
         */
        default QueueEndpointBuilder serviceClient(String serviceClient) {
            doSetProperty("serviceClient", serviceClient);
            return this;
        }
        /**
         * Maximum number of messages to get, if there are less messages exist
         * in the queue than requested all the messages will be returned. If
         * left empty only 1 message will be retrieved, the allowed range is 1
         * to 32 messages.
         * 
         * The option is a: &lt;code&gt;java.lang.Integer&lt;/code&gt; type.
         * 
         * Default: 1
         * Group: queue
         * 
         * @param maxMessages the value to set
         * @return the dsl builder
         */
        default QueueEndpointBuilder maxMessages(Integer maxMessages) {
            doSetProperty("maxMessages", maxMessages);
            return this;
        }
        /**
         * Maximum number of messages to get, if there are less messages exist
         * in the queue than requested all the messages will be returned. If
         * left empty only 1 message will be retrieved, the allowed range is 1
         * to 32 messages.
         * 
         * The option will be converted to a
         * &lt;code&gt;java.lang.Integer&lt;/code&gt; type.
         * 
         * Default: 1
         * Group: queue
         * 
         * @param maxMessages the value to set
         * @return the dsl builder
         */
        default QueueEndpointBuilder maxMessages(String maxMessages) {
            doSetProperty("maxMessages", maxMessages);
            return this;
        }
        /**
         * The ID of the message to be deleted or updated.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: queue
         * 
         * @param messageId the value to set
         * @return the dsl builder
         */
        default QueueEndpointBuilder messageId(String messageId) {
            doSetProperty("messageId", messageId);
            return this;
        }
        /**
         * Unique identifier that must match for the message to be deleted or
         * updated.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: queue
         * 
         * @param popReceipt the value to set
         * @return the dsl builder
         */
        default QueueEndpointBuilder popReceipt(String popReceipt) {
            doSetProperty("popReceipt", popReceipt);
            return this;
        }
        /**
         * An optional timeout applied to the operation. If a response is not
         * returned before the timeout concludes a RuntimeException will be
         * thrown.
         * 
         * The option is a: &lt;code&gt;java.time.Duration&lt;/code&gt; type.
         * 
         * Group: queue
         * 
         * @param timeout the value to set
         * @return the dsl builder
         */
        default QueueEndpointBuilder timeout(Duration timeout) {
            doSetProperty("timeout", timeout);
            return this;
        }
        /**
         * An optional timeout applied to the operation. If a response is not
         * returned before the timeout concludes a RuntimeException will be
         * thrown.
         * 
         * The option will be converted to a
         * &lt;code&gt;java.time.Duration&lt;/code&gt; type.
         * 
         * Group: queue
         * 
         * @param timeout the value to set
         * @return the dsl builder
         */
        default QueueEndpointBuilder timeout(String timeout) {
            doSetProperty("timeout", timeout);
            return this;
        }
        /**
         * How long the message will stay alive in the queue. If unset the value
         * will default to 7 days, if -1 is passed the message will not expire.
         * The time to live must be -1 or any positive number. The format should
         * be in this form: PnDTnHnMn.nS., e.g: PT20.345S -- parses as 20.345
         * seconds, P2D -- parses as 2 days However, in case you are using
         * EndpointDsl/ComponentDsl, you can do something like
         * Duration.ofSeconds() since these Java APIs are typesafe.
         * 
         * The option is a: &lt;code&gt;java.time.Duration&lt;/code&gt; type.
         * 
         * Group: queue
         * 
         * @param timeToLive the value to set
         * @return the dsl builder
         */
        default QueueEndpointBuilder timeToLive(Duration timeToLive) {
            doSetProperty("timeToLive", timeToLive);
            return this;
        }
        /**
         * How long the message will stay alive in the queue. If unset the value
         * will default to 7 days, if -1 is passed the message will not expire.
         * The time to live must be -1 or any positive number. The format should
         * be in this form: PnDTnHnMn.nS., e.g: PT20.345S -- parses as 20.345
         * seconds, P2D -- parses as 2 days However, in case you are using
         * EndpointDsl/ComponentDsl, you can do something like
         * Duration.ofSeconds() since these Java APIs are typesafe.
         * 
         * The option will be converted to a
         * &lt;code&gt;java.time.Duration&lt;/code&gt; type.
         * 
         * Group: queue
         * 
         * @param timeToLive the value to set
         * @return the dsl builder
         */
        default QueueEndpointBuilder timeToLive(String timeToLive) {
            doSetProperty("timeToLive", timeToLive);
            return this;
        }
        /**
         * The timeout period for how long the message is invisible in the
         * queue. The timeout must be between 1 seconds and 7 days. The format
         * should be in this form: PnDTnHnMn.nS., e.g: PT20.345S -- parses as
         * 20.345 seconds, P2D -- parses as 2 days However, in case you are
         * using EndpointDsl/ComponentDsl, you can do something like
         * Duration.ofSeconds() since these Java APIs are typesafe.
         * 
         * The option is a: &lt;code&gt;java.time.Duration&lt;/code&gt; type.
         * 
         * Group: queue
         * 
         * @param visibilityTimeout the value to set
         * @return the dsl builder
         */
        default QueueEndpointBuilder visibilityTimeout(
                Duration visibilityTimeout) {
            doSetProperty("visibilityTimeout", visibilityTimeout);
            return this;
        }
        /**
         * The timeout period for how long the message is invisible in the
         * queue. The timeout must be between 1 seconds and 7 days. The format
         * should be in this form: PnDTnHnMn.nS., e.g: PT20.345S -- parses as
         * 20.345 seconds, P2D -- parses as 2 days However, in case you are
         * using EndpointDsl/ComponentDsl, you can do something like
         * Duration.ofSeconds() since these Java APIs are typesafe.
         * 
         * The option will be converted to a
         * &lt;code&gt;java.time.Duration&lt;/code&gt; type.
         * 
         * Group: queue
         * 
         * @param visibilityTimeout the value to set
         * @return the dsl builder
         */
        default QueueEndpointBuilder visibilityTimeout(String visibilityTimeout) {
            doSetProperty("visibilityTimeout", visibilityTimeout);
            return this;
        }
        /**
         * Access key for the associated azure account name to be used for
         * authentication with azure queue services.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: security
         * 
         * @param accessKey the value to set
         * @return the dsl builder
         */
        default QueueEndpointBuilder accessKey(String accessKey) {
            doSetProperty("accessKey", accessKey);
            return this;
        }
        /**
         * StorageSharedKeyCredential can be injected to create the azure
         * client, this holds the important authentication information.
         * 
         * The option is a:
         * &lt;code&gt;com.azure.storage.common.StorageSharedKeyCredential&lt;/code&gt; type.
         * 
         * Group: security
         * 
         * @param credentials the value to set
         * @return the dsl builder
         */
        default QueueEndpointBuilder credentials(Object credentials) {
            doSetProperty("credentials", credentials);
            return this;
        }
        /**
         * StorageSharedKeyCredential can be injected to create the azure
         * client, this holds the important authentication information.
         * 
         * The option will be converted to a
         * &lt;code&gt;com.azure.storage.common.StorageSharedKeyCredential&lt;/code&gt; type.
         * 
         * Group: security
         * 
         * @param credentials the value to set
         * @return the dsl builder
         */
        default QueueEndpointBuilder credentials(String credentials) {
            doSetProperty("credentials", credentials);
            return this;
        }
    }

    /**
     * Advanced builder for endpoint for the Azure Storage Queue Service
     * component.
     */
    public interface AdvancedQueueEndpointBuilder
            extends
                AdvancedQueueEndpointConsumerBuilder,
                AdvancedQueueEndpointProducerBuilder {
        default QueueEndpointBuilder basic() {
            return (QueueEndpointBuilder) this;
        }
    }

    /**
     * Proxy enum for
     * <code>org.apache.camel.component.azure.storage.queue.QueueOperationDefinition</code> enum.
     */
    enum QueueOperationDefinition {
        listQueues,
        createQueue,
        deleteQueue,
        clearQueue,
        sendMessage,
        deleteMessage,
        receiveMessages,
        peekMessages,
        updateMessage;
    }

    public interface QueueBuilders {
        /**
         * Azure Storage Queue Service (camel-azure-storage-queue)
         * The azure-storage-queue component is used for storing and retrieving
         * the messages to/from Azure Storage Queue using Azure SDK v12.
         * 
         * Category: cloud,messaging
         * Since: 3.3
         * Maven coordinates: org.apache.camel:camel-azure-storage-queue
         * 
         * Syntax: <code>azure-storage-queue:accountName/queueName</code>
         * 
         * Path parameter: accountName
         * Azure account name to be used for authentication with azure queue
         * services
         * 
         * Path parameter: queueName
         * The queue resource name
         * 
         * @param path accountName/queueName
         * @return the dsl builder
         */
        default QueueEndpointBuilder azureStorageQueue(String path) {
            return QueueEndpointBuilderFactory.endpointBuilder("azure-storage-queue", path);
        }
        /**
         * Azure Storage Queue Service (camel-azure-storage-queue)
         * The azure-storage-queue component is used for storing and retrieving
         * the messages to/from Azure Storage Queue using Azure SDK v12.
         * 
         * Category: cloud,messaging
         * Since: 3.3
         * Maven coordinates: org.apache.camel:camel-azure-storage-queue
         * 
         * Syntax: <code>azure-storage-queue:accountName/queueName</code>
         * 
         * Path parameter: accountName
         * Azure account name to be used for authentication with azure queue
         * services
         * 
         * Path parameter: queueName
         * The queue resource name
         * 
         * @param componentName to use a custom component name for the endpoint
         * instead of the default name
         * @param path accountName/queueName
         * @return the dsl builder
         */
        default QueueEndpointBuilder azureStorageQueue(
                String componentName,
                String path) {
            return QueueEndpointBuilderFactory.endpointBuilder(componentName, path);
        }
    }
    static QueueEndpointBuilder endpointBuilder(
            String componentName,
            String path) {
        class QueueEndpointBuilderImpl extends AbstractEndpointBuilder implements QueueEndpointBuilder, AdvancedQueueEndpointBuilder {
            public QueueEndpointBuilderImpl(String path) {
                super(componentName, path);
            }
        }
        return new QueueEndpointBuilderImpl(path);
    }
}