/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.apache.camel.builder.endpoint.dsl;

import java.time.Duration;
import javax.annotation.Generated;
import org.apache.camel.ExchangePattern;
import org.apache.camel.builder.EndpointConsumerBuilder;
import org.apache.camel.builder.EndpointProducerBuilder;
import org.apache.camel.builder.endpoint.AbstractEndpointBuilder;
import org.apache.camel.spi.ExceptionHandler;

/**
 * Store and retrieve blobs from Azure Storage Blob Service using SDK v12.
 * 
 * Generated by camel build tools - do NOT edit this file!
 */
@Generated("org.apache.camel.maven.packaging.EndpointDslMojo")
public interface BlobEndpointBuilderFactory {


    /**
     * Builder for endpoint consumers for the Azure Storage Blob Service
     * component.
     */
    public interface BlobEndpointConsumerBuilder
            extends
                EndpointConsumerBuilder {
        default AdvancedBlobEndpointConsumerBuilder advanced() {
            return (AdvancedBlobEndpointConsumerBuilder) this;
        }
        /**
         * Setting the autoDiscoverClient mechanism, if true, the component will
         * look for a client instance in the registry automatically otherwise it
         * will skip that checking.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: true
         * Group: common
         * 
         * @param autoDiscoverClient the value to set
         * @return the dsl builder
         */
        default BlobEndpointConsumerBuilder autoDiscoverClient(
                boolean autoDiscoverClient) {
            doSetProperty("autoDiscoverClient", autoDiscoverClient);
            return this;
        }
        /**
         * Setting the autoDiscoverClient mechanism, if true, the component will
         * look for a client instance in the registry automatically otherwise it
         * will skip that checking.
         * 
         * The option will be converted to a &lt;code&gt;boolean&lt;/code&gt;
         * type.
         * 
         * Default: true
         * Group: common
         * 
         * @param autoDiscoverClient the value to set
         * @return the dsl builder
         */
        default BlobEndpointConsumerBuilder autoDiscoverClient(
                String autoDiscoverClient) {
            doSetProperty("autoDiscoverClient", autoDiscoverClient);
            return this;
        }
        /**
         * The blob name, to consume specific blob from a container. However on
         * producer, is only required for the operations on the blob level.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param blobName the value to set
         * @return the dsl builder
         */
        default BlobEndpointConsumerBuilder blobName(String blobName) {
            doSetProperty("blobName", blobName);
            return this;
        }
        /**
         * Set the blob offset for the upload or download operations, default is
         * 0.
         * 
         * The option is a: &lt;code&gt;long&lt;/code&gt; type.
         * 
         * Default: 0
         * Group: common
         * 
         * @param blobOffset the value to set
         * @return the dsl builder
         */
        default BlobEndpointConsumerBuilder blobOffset(long blobOffset) {
            doSetProperty("blobOffset", blobOffset);
            return this;
        }
        /**
         * Set the blob offset for the upload or download operations, default is
         * 0.
         * 
         * The option will be converted to a &lt;code&gt;long&lt;/code&gt; type.
         * 
         * Default: 0
         * Group: common
         * 
         * @param blobOffset the value to set
         * @return the dsl builder
         */
        default BlobEndpointConsumerBuilder blobOffset(String blobOffset) {
            doSetProperty("blobOffset", blobOffset);
            return this;
        }
        /**
         * Client to a storage account. This client does not hold any state
         * about a particular storage account but is instead a convenient way of
         * sending off appropriate requests to the resource on the service. It
         * may also be used to construct URLs to blobs and containers. This
         * client contains operations on a service account. Operations on a
         * container are available on BlobContainerClient through
         * getBlobContainerClient(String), and operations on a blob are
         * available on BlobClient through
         * getBlobContainerClient(String).getBlobClient(String).
         * 
         * The option is a:
         * &lt;code&gt;com.azure.storage.blob.BlobServiceClient&lt;/code&gt;
         * type.
         * 
         * Group: common
         * 
         * @param blobServiceClient the value to set
         * @return the dsl builder
         */
        default BlobEndpointConsumerBuilder blobServiceClient(
                Object blobServiceClient) {
            doSetProperty("blobServiceClient", blobServiceClient);
            return this;
        }
        /**
         * Client to a storage account. This client does not hold any state
         * about a particular storage account but is instead a convenient way of
         * sending off appropriate requests to the resource on the service. It
         * may also be used to construct URLs to blobs and containers. This
         * client contains operations on a service account. Operations on a
         * container are available on BlobContainerClient through
         * getBlobContainerClient(String), and operations on a blob are
         * available on BlobClient through
         * getBlobContainerClient(String).getBlobClient(String).
         * 
         * The option will be converted to a
         * &lt;code&gt;com.azure.storage.blob.BlobServiceClient&lt;/code&gt;
         * type.
         * 
         * Group: common
         * 
         * @param blobServiceClient the value to set
         * @return the dsl builder
         */
        default BlobEndpointConsumerBuilder blobServiceClient(
                String blobServiceClient) {
            doSetProperty("blobServiceClient", blobServiceClient);
            return this;
        }
        /**
         * The blob type in order to initiate the appropriate settings for each
         * blob type.
         * 
         * The option is a:
         * &lt;code&gt;org.apache.camel.component.azure.storage.blob.BlobType&lt;/code&gt; type.
         * 
         * Default: blockblob
         * Group: common
         * 
         * @param blobType the value to set
         * @return the dsl builder
         */
        default BlobEndpointConsumerBuilder blobType(BlobType blobType) {
            doSetProperty("blobType", blobType);
            return this;
        }
        /**
         * The blob type in order to initiate the appropriate settings for each
         * blob type.
         * 
         * The option will be converted to a
         * &lt;code&gt;org.apache.camel.component.azure.storage.blob.BlobType&lt;/code&gt; type.
         * 
         * Default: blockblob
         * Group: common
         * 
         * @param blobType the value to set
         * @return the dsl builder
         */
        default BlobEndpointConsumerBuilder blobType(String blobType) {
            doSetProperty("blobType", blobType);
            return this;
        }
        /**
         * Close the stream after read or keep it open, default is true.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: true
         * Group: common
         * 
         * @param closeStreamAfterRead the value to set
         * @return the dsl builder
         */
        default BlobEndpointConsumerBuilder closeStreamAfterRead(
                boolean closeStreamAfterRead) {
            doSetProperty("closeStreamAfterRead", closeStreamAfterRead);
            return this;
        }
        /**
         * Close the stream after read or keep it open, default is true.
         * 
         * The option will be converted to a &lt;code&gt;boolean&lt;/code&gt;
         * type.
         * 
         * Default: true
         * Group: common
         * 
         * @param closeStreamAfterRead the value to set
         * @return the dsl builder
         */
        default BlobEndpointConsumerBuilder closeStreamAfterRead(
                String closeStreamAfterRead) {
            doSetProperty("closeStreamAfterRead", closeStreamAfterRead);
            return this;
        }
        /**
         * StorageSharedKeyCredential can be injected to create the azure
         * client, this holds the important authentication information.
         * 
         * The option is a:
         * &lt;code&gt;com.azure.storage.common.StorageSharedKeyCredential&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param credentials the value to set
         * @return the dsl builder
         */
        default BlobEndpointConsumerBuilder credentials(Object credentials) {
            doSetProperty("credentials", credentials);
            return this;
        }
        /**
         * StorageSharedKeyCredential can be injected to create the azure
         * client, this holds the important authentication information.
         * 
         * The option will be converted to a
         * &lt;code&gt;com.azure.storage.common.StorageSharedKeyCredential&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param credentials the value to set
         * @return the dsl builder
         */
        default BlobEndpointConsumerBuilder credentials(String credentials) {
            doSetProperty("credentials", credentials);
            return this;
        }
        /**
         * How many bytes to include in the range. Must be greater than or equal
         * to 0 if specified.
         * 
         * The option is a: &lt;code&gt;java.lang.Long&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param dataCount the value to set
         * @return the dsl builder
         */
        default BlobEndpointConsumerBuilder dataCount(Long dataCount) {
            doSetProperty("dataCount", dataCount);
            return this;
        }
        /**
         * How many bytes to include in the range. Must be greater than or equal
         * to 0 if specified.
         * 
         * The option will be converted to a
         * &lt;code&gt;java.lang.Long&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param dataCount the value to set
         * @return the dsl builder
         */
        default BlobEndpointConsumerBuilder dataCount(String dataCount) {
            doSetProperty("dataCount", dataCount);
            return this;
        }
        /**
         * The file directory where the downloaded blobs will be saved to, this
         * can be used in both, producer and consumer.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param fileDir the value to set
         * @return the dsl builder
         */
        default BlobEndpointConsumerBuilder fileDir(String fileDir) {
            doSetProperty("fileDir", fileDir);
            return this;
        }
        /**
         * Specifies the maximum number of blobs to return, including all
         * BlobPrefix elements. If the request does not specify
         * maxResultsPerPage or specifies a value greater than 5,000, the server
         * will return up to 5,000 items.
         * 
         * The option is a: &lt;code&gt;java.lang.Integer&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param maxResultsPerPage the value to set
         * @return the dsl builder
         */
        default BlobEndpointConsumerBuilder maxResultsPerPage(
                Integer maxResultsPerPage) {
            doSetProperty("maxResultsPerPage", maxResultsPerPage);
            return this;
        }
        /**
         * Specifies the maximum number of blobs to return, including all
         * BlobPrefix elements. If the request does not specify
         * maxResultsPerPage or specifies a value greater than 5,000, the server
         * will return up to 5,000 items.
         * 
         * The option will be converted to a
         * &lt;code&gt;java.lang.Integer&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param maxResultsPerPage the value to set
         * @return the dsl builder
         */
        default BlobEndpointConsumerBuilder maxResultsPerPage(
                String maxResultsPerPage) {
            doSetProperty("maxResultsPerPage", maxResultsPerPage);
            return this;
        }
        /**
         * Specifies the maximum number of additional HTTP Get requests that
         * will be made while reading the data from a response body.
         * 
         * The option is a: &lt;code&gt;int&lt;/code&gt; type.
         * 
         * Default: 0
         * Group: common
         * 
         * @param maxRetryRequests the value to set
         * @return the dsl builder
         */
        default BlobEndpointConsumerBuilder maxRetryRequests(
                int maxRetryRequests) {
            doSetProperty("maxRetryRequests", maxRetryRequests);
            return this;
        }
        /**
         * Specifies the maximum number of additional HTTP Get requests that
         * will be made while reading the data from a response body.
         * 
         * The option will be converted to a &lt;code&gt;int&lt;/code&gt; type.
         * 
         * Default: 0
         * Group: common
         * 
         * @param maxRetryRequests the value to set
         * @return the dsl builder
         */
        default BlobEndpointConsumerBuilder maxRetryRequests(
                String maxRetryRequests) {
            doSetProperty("maxRetryRequests", maxRetryRequests);
            return this;
        }
        /**
         * Filters the results to return only blobs whose names begin with the
         * specified prefix. May be null to return all blobs.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param prefix the value to set
         * @return the dsl builder
         */
        default BlobEndpointConsumerBuilder prefix(String prefix) {
            doSetProperty("prefix", prefix);
            return this;
        }
        /**
         * Filters the results to return only blobs whose names match the
         * specified regular expression. May be null to return all if both
         * prefix and regex are set, regex takes the priority and prefix is
         * ignored.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param regex the value to set
         * @return the dsl builder
         */
        default BlobEndpointConsumerBuilder regex(String regex) {
            doSetProperty("regex", regex);
            return this;
        }
        /**
         * Client to a storage account. This client does not hold any state
         * about a particular storage account but is instead a convenient way of
         * sending off appropriate requests to the resource on the service. It
         * may also be used to construct URLs to blobs and containers. This
         * client contains operations on a service account. Operations on a
         * container are available on BlobContainerClient through
         * BlobServiceClient#getBlobContainerClient(String), and operations on a
         * blob are available on BlobClient through
         * BlobContainerClient#getBlobClient(String).
         * 
         * The option is a:
         * &lt;code&gt;com.azure.storage.blob.BlobServiceClient&lt;/code&gt;
         * type.
         * 
         * Group: common
         * 
         * @param serviceClient the value to set
         * @return the dsl builder
         */
        default BlobEndpointConsumerBuilder serviceClient(Object serviceClient) {
            doSetProperty("serviceClient", serviceClient);
            return this;
        }
        /**
         * Client to a storage account. This client does not hold any state
         * about a particular storage account but is instead a convenient way of
         * sending off appropriate requests to the resource on the service. It
         * may also be used to construct URLs to blobs and containers. This
         * client contains operations on a service account. Operations on a
         * container are available on BlobContainerClient through
         * BlobServiceClient#getBlobContainerClient(String), and operations on a
         * blob are available on BlobClient through
         * BlobContainerClient#getBlobClient(String).
         * 
         * The option will be converted to a
         * &lt;code&gt;com.azure.storage.blob.BlobServiceClient&lt;/code&gt;
         * type.
         * 
         * Group: common
         * 
         * @param serviceClient the value to set
         * @return the dsl builder
         */
        default BlobEndpointConsumerBuilder serviceClient(String serviceClient) {
            doSetProperty("serviceClient", serviceClient);
            return this;
        }
        /**
         * An optional timeout value beyond which a RuntimeException will be
         * raised.
         * 
         * The option is a: &lt;code&gt;java.time.Duration&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param timeout the value to set
         * @return the dsl builder
         */
        default BlobEndpointConsumerBuilder timeout(Duration timeout) {
            doSetProperty("timeout", timeout);
            return this;
        }
        /**
         * An optional timeout value beyond which a RuntimeException will be
         * raised.
         * 
         * The option will be converted to a
         * &lt;code&gt;java.time.Duration&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param timeout the value to set
         * @return the dsl builder
         */
        default BlobEndpointConsumerBuilder timeout(String timeout) {
            doSetProperty("timeout", timeout);
            return this;
        }
        /**
         * Allows for bridging the consumer to the Camel routing Error Handler,
         * which mean any exceptions occurred while the consumer is trying to
         * pickup incoming messages, or the likes, will now be processed as a
         * message and handled by the routing Error Handler. By default the
         * consumer will use the org.apache.camel.spi.ExceptionHandler to deal
         * with exceptions, that will be logged at WARN or ERROR level and
         * ignored.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: false
         * Group: consumer
         * 
         * @param bridgeErrorHandler the value to set
         * @return the dsl builder
         */
        default BlobEndpointConsumerBuilder bridgeErrorHandler(
                boolean bridgeErrorHandler) {
            doSetProperty("bridgeErrorHandler", bridgeErrorHandler);
            return this;
        }
        /**
         * Allows for bridging the consumer to the Camel routing Error Handler,
         * which mean any exceptions occurred while the consumer is trying to
         * pickup incoming messages, or the likes, will now be processed as a
         * message and handled by the routing Error Handler. By default the
         * consumer will use the org.apache.camel.spi.ExceptionHandler to deal
         * with exceptions, that will be logged at WARN or ERROR level and
         * ignored.
         * 
         * The option will be converted to a &lt;code&gt;boolean&lt;/code&gt;
         * type.
         * 
         * Default: false
         * Group: consumer
         * 
         * @param bridgeErrorHandler the value to set
         * @return the dsl builder
         */
        default BlobEndpointConsumerBuilder bridgeErrorHandler(
                String bridgeErrorHandler) {
            doSetProperty("bridgeErrorHandler", bridgeErrorHandler);
            return this;
        }
        /**
         * Access key for the associated azure account name to be used for
         * authentication with azure blob services.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: security
         * 
         * @param accessKey the value to set
         * @return the dsl builder
         */
        default BlobEndpointConsumerBuilder accessKey(String accessKey) {
            doSetProperty("accessKey", accessKey);
            return this;
        }
    }

    /**
     * Advanced builder for endpoint consumers for the Azure Storage Blob
     * Service component.
     */
    public interface AdvancedBlobEndpointConsumerBuilder
            extends
                EndpointConsumerBuilder {
        default BlobEndpointConsumerBuilder basic() {
            return (BlobEndpointConsumerBuilder) this;
        }
        /**
         * To let the consumer use a custom ExceptionHandler. Notice if the
         * option bridgeErrorHandler is enabled then this option is not in use.
         * By default the consumer will deal with exceptions, that will be
         * logged at WARN or ERROR level and ignored.
         * 
         * The option is a:
         * &lt;code&gt;org.apache.camel.spi.ExceptionHandler&lt;/code&gt; type.
         * 
         * Group: consumer (advanced)
         * 
         * @param exceptionHandler the value to set
         * @return the dsl builder
         */
        default AdvancedBlobEndpointConsumerBuilder exceptionHandler(
                ExceptionHandler exceptionHandler) {
            doSetProperty("exceptionHandler", exceptionHandler);
            return this;
        }
        /**
         * To let the consumer use a custom ExceptionHandler. Notice if the
         * option bridgeErrorHandler is enabled then this option is not in use.
         * By default the consumer will deal with exceptions, that will be
         * logged at WARN or ERROR level and ignored.
         * 
         * The option will be converted to a
         * &lt;code&gt;org.apache.camel.spi.ExceptionHandler&lt;/code&gt; type.
         * 
         * Group: consumer (advanced)
         * 
         * @param exceptionHandler the value to set
         * @return the dsl builder
         */
        default AdvancedBlobEndpointConsumerBuilder exceptionHandler(
                String exceptionHandler) {
            doSetProperty("exceptionHandler", exceptionHandler);
            return this;
        }
        /**
         * Sets the exchange pattern when the consumer creates an exchange.
         * 
         * The option is a:
         * &lt;code&gt;org.apache.camel.ExchangePattern&lt;/code&gt; type.
         * 
         * Group: consumer (advanced)
         * 
         * @param exchangePattern the value to set
         * @return the dsl builder
         */
        default AdvancedBlobEndpointConsumerBuilder exchangePattern(
                ExchangePattern exchangePattern) {
            doSetProperty("exchangePattern", exchangePattern);
            return this;
        }
        /**
         * Sets the exchange pattern when the consumer creates an exchange.
         * 
         * The option will be converted to a
         * &lt;code&gt;org.apache.camel.ExchangePattern&lt;/code&gt; type.
         * 
         * Group: consumer (advanced)
         * 
         * @param exchangePattern the value to set
         * @return the dsl builder
         */
        default AdvancedBlobEndpointConsumerBuilder exchangePattern(
                String exchangePattern) {
            doSetProperty("exchangePattern", exchangePattern);
            return this;
        }
    }

    /**
     * Builder for endpoint producers for the Azure Storage Blob Service
     * component.
     */
    public interface BlobEndpointProducerBuilder
            extends
                EndpointProducerBuilder {
        default AdvancedBlobEndpointProducerBuilder advanced() {
            return (AdvancedBlobEndpointProducerBuilder) this;
        }
        /**
         * Setting the autoDiscoverClient mechanism, if true, the component will
         * look for a client instance in the registry automatically otherwise it
         * will skip that checking.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: true
         * Group: common
         * 
         * @param autoDiscoverClient the value to set
         * @return the dsl builder
         */
        default BlobEndpointProducerBuilder autoDiscoverClient(
                boolean autoDiscoverClient) {
            doSetProperty("autoDiscoverClient", autoDiscoverClient);
            return this;
        }
        /**
         * Setting the autoDiscoverClient mechanism, if true, the component will
         * look for a client instance in the registry automatically otherwise it
         * will skip that checking.
         * 
         * The option will be converted to a &lt;code&gt;boolean&lt;/code&gt;
         * type.
         * 
         * Default: true
         * Group: common
         * 
         * @param autoDiscoverClient the value to set
         * @return the dsl builder
         */
        default BlobEndpointProducerBuilder autoDiscoverClient(
                String autoDiscoverClient) {
            doSetProperty("autoDiscoverClient", autoDiscoverClient);
            return this;
        }
        /**
         * The blob name, to consume specific blob from a container. However on
         * producer, is only required for the operations on the blob level.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param blobName the value to set
         * @return the dsl builder
         */
        default BlobEndpointProducerBuilder blobName(String blobName) {
            doSetProperty("blobName", blobName);
            return this;
        }
        /**
         * Set the blob offset for the upload or download operations, default is
         * 0.
         * 
         * The option is a: &lt;code&gt;long&lt;/code&gt; type.
         * 
         * Default: 0
         * Group: common
         * 
         * @param blobOffset the value to set
         * @return the dsl builder
         */
        default BlobEndpointProducerBuilder blobOffset(long blobOffset) {
            doSetProperty("blobOffset", blobOffset);
            return this;
        }
        /**
         * Set the blob offset for the upload or download operations, default is
         * 0.
         * 
         * The option will be converted to a &lt;code&gt;long&lt;/code&gt; type.
         * 
         * Default: 0
         * Group: common
         * 
         * @param blobOffset the value to set
         * @return the dsl builder
         */
        default BlobEndpointProducerBuilder blobOffset(String blobOffset) {
            doSetProperty("blobOffset", blobOffset);
            return this;
        }
        /**
         * Client to a storage account. This client does not hold any state
         * about a particular storage account but is instead a convenient way of
         * sending off appropriate requests to the resource on the service. It
         * may also be used to construct URLs to blobs and containers. This
         * client contains operations on a service account. Operations on a
         * container are available on BlobContainerClient through
         * getBlobContainerClient(String), and operations on a blob are
         * available on BlobClient through
         * getBlobContainerClient(String).getBlobClient(String).
         * 
         * The option is a:
         * &lt;code&gt;com.azure.storage.blob.BlobServiceClient&lt;/code&gt;
         * type.
         * 
         * Group: common
         * 
         * @param blobServiceClient the value to set
         * @return the dsl builder
         */
        default BlobEndpointProducerBuilder blobServiceClient(
                Object blobServiceClient) {
            doSetProperty("blobServiceClient", blobServiceClient);
            return this;
        }
        /**
         * Client to a storage account. This client does not hold any state
         * about a particular storage account but is instead a convenient way of
         * sending off appropriate requests to the resource on the service. It
         * may also be used to construct URLs to blobs and containers. This
         * client contains operations on a service account. Operations on a
         * container are available on BlobContainerClient through
         * getBlobContainerClient(String), and operations on a blob are
         * available on BlobClient through
         * getBlobContainerClient(String).getBlobClient(String).
         * 
         * The option will be converted to a
         * &lt;code&gt;com.azure.storage.blob.BlobServiceClient&lt;/code&gt;
         * type.
         * 
         * Group: common
         * 
         * @param blobServiceClient the value to set
         * @return the dsl builder
         */
        default BlobEndpointProducerBuilder blobServiceClient(
                String blobServiceClient) {
            doSetProperty("blobServiceClient", blobServiceClient);
            return this;
        }
        /**
         * The blob type in order to initiate the appropriate settings for each
         * blob type.
         * 
         * The option is a:
         * &lt;code&gt;org.apache.camel.component.azure.storage.blob.BlobType&lt;/code&gt; type.
         * 
         * Default: blockblob
         * Group: common
         * 
         * @param blobType the value to set
         * @return the dsl builder
         */
        default BlobEndpointProducerBuilder blobType(BlobType blobType) {
            doSetProperty("blobType", blobType);
            return this;
        }
        /**
         * The blob type in order to initiate the appropriate settings for each
         * blob type.
         * 
         * The option will be converted to a
         * &lt;code&gt;org.apache.camel.component.azure.storage.blob.BlobType&lt;/code&gt; type.
         * 
         * Default: blockblob
         * Group: common
         * 
         * @param blobType the value to set
         * @return the dsl builder
         */
        default BlobEndpointProducerBuilder blobType(String blobType) {
            doSetProperty("blobType", blobType);
            return this;
        }
        /**
         * Close the stream after read or keep it open, default is true.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: true
         * Group: common
         * 
         * @param closeStreamAfterRead the value to set
         * @return the dsl builder
         */
        default BlobEndpointProducerBuilder closeStreamAfterRead(
                boolean closeStreamAfterRead) {
            doSetProperty("closeStreamAfterRead", closeStreamAfterRead);
            return this;
        }
        /**
         * Close the stream after read or keep it open, default is true.
         * 
         * The option will be converted to a &lt;code&gt;boolean&lt;/code&gt;
         * type.
         * 
         * Default: true
         * Group: common
         * 
         * @param closeStreamAfterRead the value to set
         * @return the dsl builder
         */
        default BlobEndpointProducerBuilder closeStreamAfterRead(
                String closeStreamAfterRead) {
            doSetProperty("closeStreamAfterRead", closeStreamAfterRead);
            return this;
        }
        /**
         * StorageSharedKeyCredential can be injected to create the azure
         * client, this holds the important authentication information.
         * 
         * The option is a:
         * &lt;code&gt;com.azure.storage.common.StorageSharedKeyCredential&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param credentials the value to set
         * @return the dsl builder
         */
        default BlobEndpointProducerBuilder credentials(Object credentials) {
            doSetProperty("credentials", credentials);
            return this;
        }
        /**
         * StorageSharedKeyCredential can be injected to create the azure
         * client, this holds the important authentication information.
         * 
         * The option will be converted to a
         * &lt;code&gt;com.azure.storage.common.StorageSharedKeyCredential&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param credentials the value to set
         * @return the dsl builder
         */
        default BlobEndpointProducerBuilder credentials(String credentials) {
            doSetProperty("credentials", credentials);
            return this;
        }
        /**
         * How many bytes to include in the range. Must be greater than or equal
         * to 0 if specified.
         * 
         * The option is a: &lt;code&gt;java.lang.Long&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param dataCount the value to set
         * @return the dsl builder
         */
        default BlobEndpointProducerBuilder dataCount(Long dataCount) {
            doSetProperty("dataCount", dataCount);
            return this;
        }
        /**
         * How many bytes to include in the range. Must be greater than or equal
         * to 0 if specified.
         * 
         * The option will be converted to a
         * &lt;code&gt;java.lang.Long&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param dataCount the value to set
         * @return the dsl builder
         */
        default BlobEndpointProducerBuilder dataCount(String dataCount) {
            doSetProperty("dataCount", dataCount);
            return this;
        }
        /**
         * The file directory where the downloaded blobs will be saved to, this
         * can be used in both, producer and consumer.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param fileDir the value to set
         * @return the dsl builder
         */
        default BlobEndpointProducerBuilder fileDir(String fileDir) {
            doSetProperty("fileDir", fileDir);
            return this;
        }
        /**
         * Specifies the maximum number of blobs to return, including all
         * BlobPrefix elements. If the request does not specify
         * maxResultsPerPage or specifies a value greater than 5,000, the server
         * will return up to 5,000 items.
         * 
         * The option is a: &lt;code&gt;java.lang.Integer&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param maxResultsPerPage the value to set
         * @return the dsl builder
         */
        default BlobEndpointProducerBuilder maxResultsPerPage(
                Integer maxResultsPerPage) {
            doSetProperty("maxResultsPerPage", maxResultsPerPage);
            return this;
        }
        /**
         * Specifies the maximum number of blobs to return, including all
         * BlobPrefix elements. If the request does not specify
         * maxResultsPerPage or specifies a value greater than 5,000, the server
         * will return up to 5,000 items.
         * 
         * The option will be converted to a
         * &lt;code&gt;java.lang.Integer&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param maxResultsPerPage the value to set
         * @return the dsl builder
         */
        default BlobEndpointProducerBuilder maxResultsPerPage(
                String maxResultsPerPage) {
            doSetProperty("maxResultsPerPage", maxResultsPerPage);
            return this;
        }
        /**
         * Specifies the maximum number of additional HTTP Get requests that
         * will be made while reading the data from a response body.
         * 
         * The option is a: &lt;code&gt;int&lt;/code&gt; type.
         * 
         * Default: 0
         * Group: common
         * 
         * @param maxRetryRequests the value to set
         * @return the dsl builder
         */
        default BlobEndpointProducerBuilder maxRetryRequests(
                int maxRetryRequests) {
            doSetProperty("maxRetryRequests", maxRetryRequests);
            return this;
        }
        /**
         * Specifies the maximum number of additional HTTP Get requests that
         * will be made while reading the data from a response body.
         * 
         * The option will be converted to a &lt;code&gt;int&lt;/code&gt; type.
         * 
         * Default: 0
         * Group: common
         * 
         * @param maxRetryRequests the value to set
         * @return the dsl builder
         */
        default BlobEndpointProducerBuilder maxRetryRequests(
                String maxRetryRequests) {
            doSetProperty("maxRetryRequests", maxRetryRequests);
            return this;
        }
        /**
         * Filters the results to return only blobs whose names begin with the
         * specified prefix. May be null to return all blobs.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param prefix the value to set
         * @return the dsl builder
         */
        default BlobEndpointProducerBuilder prefix(String prefix) {
            doSetProperty("prefix", prefix);
            return this;
        }
        /**
         * Filters the results to return only blobs whose names match the
         * specified regular expression. May be null to return all if both
         * prefix and regex are set, regex takes the priority and prefix is
         * ignored.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param regex the value to set
         * @return the dsl builder
         */
        default BlobEndpointProducerBuilder regex(String regex) {
            doSetProperty("regex", regex);
            return this;
        }
        /**
         * Client to a storage account. This client does not hold any state
         * about a particular storage account but is instead a convenient way of
         * sending off appropriate requests to the resource on the service. It
         * may also be used to construct URLs to blobs and containers. This
         * client contains operations on a service account. Operations on a
         * container are available on BlobContainerClient through
         * BlobServiceClient#getBlobContainerClient(String), and operations on a
         * blob are available on BlobClient through
         * BlobContainerClient#getBlobClient(String).
         * 
         * The option is a:
         * &lt;code&gt;com.azure.storage.blob.BlobServiceClient&lt;/code&gt;
         * type.
         * 
         * Group: common
         * 
         * @param serviceClient the value to set
         * @return the dsl builder
         */
        default BlobEndpointProducerBuilder serviceClient(Object serviceClient) {
            doSetProperty("serviceClient", serviceClient);
            return this;
        }
        /**
         * Client to a storage account. This client does not hold any state
         * about a particular storage account but is instead a convenient way of
         * sending off appropriate requests to the resource on the service. It
         * may also be used to construct URLs to blobs and containers. This
         * client contains operations on a service account. Operations on a
         * container are available on BlobContainerClient through
         * BlobServiceClient#getBlobContainerClient(String), and operations on a
         * blob are available on BlobClient through
         * BlobContainerClient#getBlobClient(String).
         * 
         * The option will be converted to a
         * &lt;code&gt;com.azure.storage.blob.BlobServiceClient&lt;/code&gt;
         * type.
         * 
         * Group: common
         * 
         * @param serviceClient the value to set
         * @return the dsl builder
         */
        default BlobEndpointProducerBuilder serviceClient(String serviceClient) {
            doSetProperty("serviceClient", serviceClient);
            return this;
        }
        /**
         * An optional timeout value beyond which a RuntimeException will be
         * raised.
         * 
         * The option is a: &lt;code&gt;java.time.Duration&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param timeout the value to set
         * @return the dsl builder
         */
        default BlobEndpointProducerBuilder timeout(Duration timeout) {
            doSetProperty("timeout", timeout);
            return this;
        }
        /**
         * An optional timeout value beyond which a RuntimeException will be
         * raised.
         * 
         * The option will be converted to a
         * &lt;code&gt;java.time.Duration&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param timeout the value to set
         * @return the dsl builder
         */
        default BlobEndpointProducerBuilder timeout(String timeout) {
            doSetProperty("timeout", timeout);
            return this;
        }
        /**
         * A user-controlled value that you can use to track requests. The value
         * of the sequence number must be between 0 and 263 - 1.The default
         * value is 0.
         * 
         * The option is a: &lt;code&gt;java.lang.Long&lt;/code&gt; type.
         * 
         * Default: 0
         * Group: producer
         * 
         * @param blobSequenceNumber the value to set
         * @return the dsl builder
         */
        default BlobEndpointProducerBuilder blobSequenceNumber(
                Long blobSequenceNumber) {
            doSetProperty("blobSequenceNumber", blobSequenceNumber);
            return this;
        }
        /**
         * A user-controlled value that you can use to track requests. The value
         * of the sequence number must be between 0 and 263 - 1.The default
         * value is 0.
         * 
         * The option will be converted to a
         * &lt;code&gt;java.lang.Long&lt;/code&gt; type.
         * 
         * Default: 0
         * Group: producer
         * 
         * @param blobSequenceNumber the value to set
         * @return the dsl builder
         */
        default BlobEndpointProducerBuilder blobSequenceNumber(
                String blobSequenceNumber) {
            doSetProperty("blobSequenceNumber", blobSequenceNumber);
            return this;
        }
        /**
         * Specifies which type of blocks to return.
         * 
         * The option is a:
         * &lt;code&gt;com.azure.storage.blob.models.BlockListType&lt;/code&gt;
         * type.
         * 
         * Default: COMMITTED
         * Group: producer
         * 
         * @param blockListType the value to set
         * @return the dsl builder
         */
        default BlobEndpointProducerBuilder blockListType(
                BlockListType blockListType) {
            doSetProperty("blockListType", blockListType);
            return this;
        }
        /**
         * Specifies which type of blocks to return.
         * 
         * The option will be converted to a
         * &lt;code&gt;com.azure.storage.blob.models.BlockListType&lt;/code&gt;
         * type.
         * 
         * Default: COMMITTED
         * Group: producer
         * 
         * @param blockListType the value to set
         * @return the dsl builder
         */
        default BlobEndpointProducerBuilder blockListType(String blockListType) {
            doSetProperty("blockListType", blockListType);
            return this;
        }
        /**
         * Close the stream after write or keep it open, default is true.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: true
         * Group: producer
         * 
         * @param closeStreamAfterWrite the value to set
         * @return the dsl builder
         */
        default BlobEndpointProducerBuilder closeStreamAfterWrite(
                boolean closeStreamAfterWrite) {
            doSetProperty("closeStreamAfterWrite", closeStreamAfterWrite);
            return this;
        }
        /**
         * Close the stream after write or keep it open, default is true.
         * 
         * The option will be converted to a &lt;code&gt;boolean&lt;/code&gt;
         * type.
         * 
         * Default: true
         * Group: producer
         * 
         * @param closeStreamAfterWrite the value to set
         * @return the dsl builder
         */
        default BlobEndpointProducerBuilder closeStreamAfterWrite(
                String closeStreamAfterWrite) {
            doSetProperty("closeStreamAfterWrite", closeStreamAfterWrite);
            return this;
        }
        /**
         * When is set to true, the staged blocks will not be committed
         * directly.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: true
         * Group: producer
         * 
         * @param commitBlockListLater the value to set
         * @return the dsl builder
         */
        default BlobEndpointProducerBuilder commitBlockListLater(
                boolean commitBlockListLater) {
            doSetProperty("commitBlockListLater", commitBlockListLater);
            return this;
        }
        /**
         * When is set to true, the staged blocks will not be committed
         * directly.
         * 
         * The option will be converted to a &lt;code&gt;boolean&lt;/code&gt;
         * type.
         * 
         * Default: true
         * Group: producer
         * 
         * @param commitBlockListLater the value to set
         * @return the dsl builder
         */
        default BlobEndpointProducerBuilder commitBlockListLater(
                String commitBlockListLater) {
            doSetProperty("commitBlockListLater", commitBlockListLater);
            return this;
        }
        /**
         * When is set to true, the append blocks will be created when
         * committing append blocks.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: true
         * Group: producer
         * 
         * @param createAppendBlob the value to set
         * @return the dsl builder
         */
        default BlobEndpointProducerBuilder createAppendBlob(
                boolean createAppendBlob) {
            doSetProperty("createAppendBlob", createAppendBlob);
            return this;
        }
        /**
         * When is set to true, the append blocks will be created when
         * committing append blocks.
         * 
         * The option will be converted to a &lt;code&gt;boolean&lt;/code&gt;
         * type.
         * 
         * Default: true
         * Group: producer
         * 
         * @param createAppendBlob the value to set
         * @return the dsl builder
         */
        default BlobEndpointProducerBuilder createAppendBlob(
                String createAppendBlob) {
            doSetProperty("createAppendBlob", createAppendBlob);
            return this;
        }
        /**
         * When is set to true, the page blob will be created when uploading
         * page blob.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: true
         * Group: producer
         * 
         * @param createPageBlob the value to set
         * @return the dsl builder
         */
        default BlobEndpointProducerBuilder createPageBlob(
                boolean createPageBlob) {
            doSetProperty("createPageBlob", createPageBlob);
            return this;
        }
        /**
         * When is set to true, the page blob will be created when uploading
         * page blob.
         * 
         * The option will be converted to a &lt;code&gt;boolean&lt;/code&gt;
         * type.
         * 
         * Default: true
         * Group: producer
         * 
         * @param createPageBlob the value to set
         * @return the dsl builder
         */
        default BlobEndpointProducerBuilder createPageBlob(String createPageBlob) {
            doSetProperty("createPageBlob", createPageBlob);
            return this;
        }
        /**
         * Override the default expiration (millis) of URL download link.
         * 
         * The option is a: &lt;code&gt;java.lang.Long&lt;/code&gt; type.
         * 
         * Group: producer
         * 
         * @param downloadLinkExpiration the value to set
         * @return the dsl builder
         */
        default BlobEndpointProducerBuilder downloadLinkExpiration(
                Long downloadLinkExpiration) {
            doSetProperty("downloadLinkExpiration", downloadLinkExpiration);
            return this;
        }
        /**
         * Override the default expiration (millis) of URL download link.
         * 
         * The option will be converted to a
         * &lt;code&gt;java.lang.Long&lt;/code&gt; type.
         * 
         * Group: producer
         * 
         * @param downloadLinkExpiration the value to set
         * @return the dsl builder
         */
        default BlobEndpointProducerBuilder downloadLinkExpiration(
                String downloadLinkExpiration) {
            doSetProperty("downloadLinkExpiration", downloadLinkExpiration);
            return this;
        }
        /**
         * Whether the producer should be started lazy (on the first message).
         * By starting lazy you can use this to allow CamelContext and routes to
         * startup in situations where a producer may otherwise fail during
         * starting and cause the route to fail being started. By deferring this
         * startup to be lazy then the startup failure can be handled during
         * routing messages via Camel's routing error handlers. Beware that when
         * the first message is processed then creating and starting the
         * producer may take a little time and prolong the total processing time
         * of the processing.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: false
         * Group: producer
         * 
         * @param lazyStartProducer the value to set
         * @return the dsl builder
         */
        default BlobEndpointProducerBuilder lazyStartProducer(
                boolean lazyStartProducer) {
            doSetProperty("lazyStartProducer", lazyStartProducer);
            return this;
        }
        /**
         * Whether the producer should be started lazy (on the first message).
         * By starting lazy you can use this to allow CamelContext and routes to
         * startup in situations where a producer may otherwise fail during
         * starting and cause the route to fail being started. By deferring this
         * startup to be lazy then the startup failure can be handled during
         * routing messages via Camel's routing error handlers. Beware that when
         * the first message is processed then creating and starting the
         * producer may take a little time and prolong the total processing time
         * of the processing.
         * 
         * The option will be converted to a &lt;code&gt;boolean&lt;/code&gt;
         * type.
         * 
         * Default: false
         * Group: producer
         * 
         * @param lazyStartProducer the value to set
         * @return the dsl builder
         */
        default BlobEndpointProducerBuilder lazyStartProducer(
                String lazyStartProducer) {
            doSetProperty("lazyStartProducer", lazyStartProducer);
            return this;
        }
        /**
         * The blob operation that can be used with this component on the
         * producer.
         * 
         * The option is a:
         * &lt;code&gt;org.apache.camel.component.azure.storage.blob.BlobOperationsDefinition&lt;/code&gt; type.
         * 
         * Default: listBlobContainers
         * Group: producer
         * 
         * @param operation the value to set
         * @return the dsl builder
         */
        default BlobEndpointProducerBuilder operation(
                BlobOperationsDefinition operation) {
            doSetProperty("operation", operation);
            return this;
        }
        /**
         * The blob operation that can be used with this component on the
         * producer.
         * 
         * The option will be converted to a
         * &lt;code&gt;org.apache.camel.component.azure.storage.blob.BlobOperationsDefinition&lt;/code&gt; type.
         * 
         * Default: listBlobContainers
         * Group: producer
         * 
         * @param operation the value to set
         * @return the dsl builder
         */
        default BlobEndpointProducerBuilder operation(String operation) {
            doSetProperty("operation", operation);
            return this;
        }
        /**
         * Specifies the maximum size for the page blob, up to 8 TB. The page
         * blob size must be aligned to a 512-byte boundary.
         * 
         * The option is a: &lt;code&gt;java.lang.Long&lt;/code&gt; type.
         * 
         * Default: 512
         * Group: producer
         * 
         * @param pageBlobSize the value to set
         * @return the dsl builder
         */
        default BlobEndpointProducerBuilder pageBlobSize(Long pageBlobSize) {
            doSetProperty("pageBlobSize", pageBlobSize);
            return this;
        }
        /**
         * Specifies the maximum size for the page blob, up to 8 TB. The page
         * blob size must be aligned to a 512-byte boundary.
         * 
         * The option will be converted to a
         * &lt;code&gt;java.lang.Long&lt;/code&gt; type.
         * 
         * Default: 512
         * Group: producer
         * 
         * @param pageBlobSize the value to set
         * @return the dsl builder
         */
        default BlobEndpointProducerBuilder pageBlobSize(String pageBlobSize) {
            doSetProperty("pageBlobSize", pageBlobSize);
            return this;
        }
        /**
         * Access key for the associated azure account name to be used for
         * authentication with azure blob services.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: security
         * 
         * @param accessKey the value to set
         * @return the dsl builder
         */
        default BlobEndpointProducerBuilder accessKey(String accessKey) {
            doSetProperty("accessKey", accessKey);
            return this;
        }
    }

    /**
     * Advanced builder for endpoint producers for the Azure Storage Blob
     * Service component.
     */
    public interface AdvancedBlobEndpointProducerBuilder
            extends
                EndpointProducerBuilder {
        default BlobEndpointProducerBuilder basic() {
            return (BlobEndpointProducerBuilder) this;
        }
    }

    /**
     * Builder for endpoint for the Azure Storage Blob Service component.
     */
    public interface BlobEndpointBuilder
            extends
                BlobEndpointConsumerBuilder,
                BlobEndpointProducerBuilder {
        default AdvancedBlobEndpointBuilder advanced() {
            return (AdvancedBlobEndpointBuilder) this;
        }
        /**
         * Setting the autoDiscoverClient mechanism, if true, the component will
         * look for a client instance in the registry automatically otherwise it
         * will skip that checking.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: true
         * Group: common
         * 
         * @param autoDiscoverClient the value to set
         * @return the dsl builder
         */
        default BlobEndpointBuilder autoDiscoverClient(
                boolean autoDiscoverClient) {
            doSetProperty("autoDiscoverClient", autoDiscoverClient);
            return this;
        }
        /**
         * Setting the autoDiscoverClient mechanism, if true, the component will
         * look for a client instance in the registry automatically otherwise it
         * will skip that checking.
         * 
         * The option will be converted to a &lt;code&gt;boolean&lt;/code&gt;
         * type.
         * 
         * Default: true
         * Group: common
         * 
         * @param autoDiscoverClient the value to set
         * @return the dsl builder
         */
        default BlobEndpointBuilder autoDiscoverClient(String autoDiscoverClient) {
            doSetProperty("autoDiscoverClient", autoDiscoverClient);
            return this;
        }
        /**
         * The blob name, to consume specific blob from a container. However on
         * producer, is only required for the operations on the blob level.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param blobName the value to set
         * @return the dsl builder
         */
        default BlobEndpointBuilder blobName(String blobName) {
            doSetProperty("blobName", blobName);
            return this;
        }
        /**
         * Set the blob offset for the upload or download operations, default is
         * 0.
         * 
         * The option is a: &lt;code&gt;long&lt;/code&gt; type.
         * 
         * Default: 0
         * Group: common
         * 
         * @param blobOffset the value to set
         * @return the dsl builder
         */
        default BlobEndpointBuilder blobOffset(long blobOffset) {
            doSetProperty("blobOffset", blobOffset);
            return this;
        }
        /**
         * Set the blob offset for the upload or download operations, default is
         * 0.
         * 
         * The option will be converted to a &lt;code&gt;long&lt;/code&gt; type.
         * 
         * Default: 0
         * Group: common
         * 
         * @param blobOffset the value to set
         * @return the dsl builder
         */
        default BlobEndpointBuilder blobOffset(String blobOffset) {
            doSetProperty("blobOffset", blobOffset);
            return this;
        }
        /**
         * Client to a storage account. This client does not hold any state
         * about a particular storage account but is instead a convenient way of
         * sending off appropriate requests to the resource on the service. It
         * may also be used to construct URLs to blobs and containers. This
         * client contains operations on a service account. Operations on a
         * container are available on BlobContainerClient through
         * getBlobContainerClient(String), and operations on a blob are
         * available on BlobClient through
         * getBlobContainerClient(String).getBlobClient(String).
         * 
         * The option is a:
         * &lt;code&gt;com.azure.storage.blob.BlobServiceClient&lt;/code&gt;
         * type.
         * 
         * Group: common
         * 
         * @param blobServiceClient the value to set
         * @return the dsl builder
         */
        default BlobEndpointBuilder blobServiceClient(Object blobServiceClient) {
            doSetProperty("blobServiceClient", blobServiceClient);
            return this;
        }
        /**
         * Client to a storage account. This client does not hold any state
         * about a particular storage account but is instead a convenient way of
         * sending off appropriate requests to the resource on the service. It
         * may also be used to construct URLs to blobs and containers. This
         * client contains operations on a service account. Operations on a
         * container are available on BlobContainerClient through
         * getBlobContainerClient(String), and operations on a blob are
         * available on BlobClient through
         * getBlobContainerClient(String).getBlobClient(String).
         * 
         * The option will be converted to a
         * &lt;code&gt;com.azure.storage.blob.BlobServiceClient&lt;/code&gt;
         * type.
         * 
         * Group: common
         * 
         * @param blobServiceClient the value to set
         * @return the dsl builder
         */
        default BlobEndpointBuilder blobServiceClient(String blobServiceClient) {
            doSetProperty("blobServiceClient", blobServiceClient);
            return this;
        }
        /**
         * The blob type in order to initiate the appropriate settings for each
         * blob type.
         * 
         * The option is a:
         * &lt;code&gt;org.apache.camel.component.azure.storage.blob.BlobType&lt;/code&gt; type.
         * 
         * Default: blockblob
         * Group: common
         * 
         * @param blobType the value to set
         * @return the dsl builder
         */
        default BlobEndpointBuilder blobType(BlobType blobType) {
            doSetProperty("blobType", blobType);
            return this;
        }
        /**
         * The blob type in order to initiate the appropriate settings for each
         * blob type.
         * 
         * The option will be converted to a
         * &lt;code&gt;org.apache.camel.component.azure.storage.blob.BlobType&lt;/code&gt; type.
         * 
         * Default: blockblob
         * Group: common
         * 
         * @param blobType the value to set
         * @return the dsl builder
         */
        default BlobEndpointBuilder blobType(String blobType) {
            doSetProperty("blobType", blobType);
            return this;
        }
        /**
         * Close the stream after read or keep it open, default is true.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: true
         * Group: common
         * 
         * @param closeStreamAfterRead the value to set
         * @return the dsl builder
         */
        default BlobEndpointBuilder closeStreamAfterRead(
                boolean closeStreamAfterRead) {
            doSetProperty("closeStreamAfterRead", closeStreamAfterRead);
            return this;
        }
        /**
         * Close the stream after read or keep it open, default is true.
         * 
         * The option will be converted to a &lt;code&gt;boolean&lt;/code&gt;
         * type.
         * 
         * Default: true
         * Group: common
         * 
         * @param closeStreamAfterRead the value to set
         * @return the dsl builder
         */
        default BlobEndpointBuilder closeStreamAfterRead(
                String closeStreamAfterRead) {
            doSetProperty("closeStreamAfterRead", closeStreamAfterRead);
            return this;
        }
        /**
         * StorageSharedKeyCredential can be injected to create the azure
         * client, this holds the important authentication information.
         * 
         * The option is a:
         * &lt;code&gt;com.azure.storage.common.StorageSharedKeyCredential&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param credentials the value to set
         * @return the dsl builder
         */
        default BlobEndpointBuilder credentials(Object credentials) {
            doSetProperty("credentials", credentials);
            return this;
        }
        /**
         * StorageSharedKeyCredential can be injected to create the azure
         * client, this holds the important authentication information.
         * 
         * The option will be converted to a
         * &lt;code&gt;com.azure.storage.common.StorageSharedKeyCredential&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param credentials the value to set
         * @return the dsl builder
         */
        default BlobEndpointBuilder credentials(String credentials) {
            doSetProperty("credentials", credentials);
            return this;
        }
        /**
         * How many bytes to include in the range. Must be greater than or equal
         * to 0 if specified.
         * 
         * The option is a: &lt;code&gt;java.lang.Long&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param dataCount the value to set
         * @return the dsl builder
         */
        default BlobEndpointBuilder dataCount(Long dataCount) {
            doSetProperty("dataCount", dataCount);
            return this;
        }
        /**
         * How many bytes to include in the range. Must be greater than or equal
         * to 0 if specified.
         * 
         * The option will be converted to a
         * &lt;code&gt;java.lang.Long&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param dataCount the value to set
         * @return the dsl builder
         */
        default BlobEndpointBuilder dataCount(String dataCount) {
            doSetProperty("dataCount", dataCount);
            return this;
        }
        /**
         * The file directory where the downloaded blobs will be saved to, this
         * can be used in both, producer and consumer.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param fileDir the value to set
         * @return the dsl builder
         */
        default BlobEndpointBuilder fileDir(String fileDir) {
            doSetProperty("fileDir", fileDir);
            return this;
        }
        /**
         * Specifies the maximum number of blobs to return, including all
         * BlobPrefix elements. If the request does not specify
         * maxResultsPerPage or specifies a value greater than 5,000, the server
         * will return up to 5,000 items.
         * 
         * The option is a: &lt;code&gt;java.lang.Integer&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param maxResultsPerPage the value to set
         * @return the dsl builder
         */
        default BlobEndpointBuilder maxResultsPerPage(Integer maxResultsPerPage) {
            doSetProperty("maxResultsPerPage", maxResultsPerPage);
            return this;
        }
        /**
         * Specifies the maximum number of blobs to return, including all
         * BlobPrefix elements. If the request does not specify
         * maxResultsPerPage or specifies a value greater than 5,000, the server
         * will return up to 5,000 items.
         * 
         * The option will be converted to a
         * &lt;code&gt;java.lang.Integer&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param maxResultsPerPage the value to set
         * @return the dsl builder
         */
        default BlobEndpointBuilder maxResultsPerPage(String maxResultsPerPage) {
            doSetProperty("maxResultsPerPage", maxResultsPerPage);
            return this;
        }
        /**
         * Specifies the maximum number of additional HTTP Get requests that
         * will be made while reading the data from a response body.
         * 
         * The option is a: &lt;code&gt;int&lt;/code&gt; type.
         * 
         * Default: 0
         * Group: common
         * 
         * @param maxRetryRequests the value to set
         * @return the dsl builder
         */
        default BlobEndpointBuilder maxRetryRequests(int maxRetryRequests) {
            doSetProperty("maxRetryRequests", maxRetryRequests);
            return this;
        }
        /**
         * Specifies the maximum number of additional HTTP Get requests that
         * will be made while reading the data from a response body.
         * 
         * The option will be converted to a &lt;code&gt;int&lt;/code&gt; type.
         * 
         * Default: 0
         * Group: common
         * 
         * @param maxRetryRequests the value to set
         * @return the dsl builder
         */
        default BlobEndpointBuilder maxRetryRequests(String maxRetryRequests) {
            doSetProperty("maxRetryRequests", maxRetryRequests);
            return this;
        }
        /**
         * Filters the results to return only blobs whose names begin with the
         * specified prefix. May be null to return all blobs.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param prefix the value to set
         * @return the dsl builder
         */
        default BlobEndpointBuilder prefix(String prefix) {
            doSetProperty("prefix", prefix);
            return this;
        }
        /**
         * Filters the results to return only blobs whose names match the
         * specified regular expression. May be null to return all if both
         * prefix and regex are set, regex takes the priority and prefix is
         * ignored.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param regex the value to set
         * @return the dsl builder
         */
        default BlobEndpointBuilder regex(String regex) {
            doSetProperty("regex", regex);
            return this;
        }
        /**
         * Client to a storage account. This client does not hold any state
         * about a particular storage account but is instead a convenient way of
         * sending off appropriate requests to the resource on the service. It
         * may also be used to construct URLs to blobs and containers. This
         * client contains operations on a service account. Operations on a
         * container are available on BlobContainerClient through
         * BlobServiceClient#getBlobContainerClient(String), and operations on a
         * blob are available on BlobClient through
         * BlobContainerClient#getBlobClient(String).
         * 
         * The option is a:
         * &lt;code&gt;com.azure.storage.blob.BlobServiceClient&lt;/code&gt;
         * type.
         * 
         * Group: common
         * 
         * @param serviceClient the value to set
         * @return the dsl builder
         */
        default BlobEndpointBuilder serviceClient(Object serviceClient) {
            doSetProperty("serviceClient", serviceClient);
            return this;
        }
        /**
         * Client to a storage account. This client does not hold any state
         * about a particular storage account but is instead a convenient way of
         * sending off appropriate requests to the resource on the service. It
         * may also be used to construct URLs to blobs and containers. This
         * client contains operations on a service account. Operations on a
         * container are available on BlobContainerClient through
         * BlobServiceClient#getBlobContainerClient(String), and operations on a
         * blob are available on BlobClient through
         * BlobContainerClient#getBlobClient(String).
         * 
         * The option will be converted to a
         * &lt;code&gt;com.azure.storage.blob.BlobServiceClient&lt;/code&gt;
         * type.
         * 
         * Group: common
         * 
         * @param serviceClient the value to set
         * @return the dsl builder
         */
        default BlobEndpointBuilder serviceClient(String serviceClient) {
            doSetProperty("serviceClient", serviceClient);
            return this;
        }
        /**
         * An optional timeout value beyond which a RuntimeException will be
         * raised.
         * 
         * The option is a: &lt;code&gt;java.time.Duration&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param timeout the value to set
         * @return the dsl builder
         */
        default BlobEndpointBuilder timeout(Duration timeout) {
            doSetProperty("timeout", timeout);
            return this;
        }
        /**
         * An optional timeout value beyond which a RuntimeException will be
         * raised.
         * 
         * The option will be converted to a
         * &lt;code&gt;java.time.Duration&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param timeout the value to set
         * @return the dsl builder
         */
        default BlobEndpointBuilder timeout(String timeout) {
            doSetProperty("timeout", timeout);
            return this;
        }
        /**
         * Access key for the associated azure account name to be used for
         * authentication with azure blob services.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: security
         * 
         * @param accessKey the value to set
         * @return the dsl builder
         */
        default BlobEndpointBuilder accessKey(String accessKey) {
            doSetProperty("accessKey", accessKey);
            return this;
        }
    }

    /**
     * Advanced builder for endpoint for the Azure Storage Blob Service
     * component.
     */
    public interface AdvancedBlobEndpointBuilder
            extends
                AdvancedBlobEndpointConsumerBuilder,
                AdvancedBlobEndpointProducerBuilder {
        default BlobEndpointBuilder basic() {
            return (BlobEndpointBuilder) this;
        }
    }

    /**
     * Proxy enum for
     * <code>org.apache.camel.component.azure.storage.blob.BlobType</code> enum.
     */
    enum BlobType {
        blockblob,
        appendblob,
        pageblob;
    }

    /**
     * Proxy enum for <code>com.azure.storage.blob.models.BlockListType</code>
     * enum.
     */
    enum BlockListType {
        COMMITTED,
        UNCOMMITTED,
        ALL;
    }

    /**
     * Proxy enum for
     * <code>org.apache.camel.component.azure.storage.blob.BlobOperationsDefinition</code> enum.
     */
    enum BlobOperationsDefinition {
        listBlobContainers,
        createBlobContainer,
        deleteBlobContainer,
        listBlobs,
        getBlob,
        deleteBlob,
        downloadBlobToFile,
        downloadLink,
        uploadBlockBlob,
        stageBlockBlobList,
        commitBlobBlockList,
        getBlobBlockList,
        createAppendBlob,
        commitAppendBlob,
        createPageBlob,
        uploadPageBlob,
        resizePageBlob,
        clearPageBlob,
        getPageBlobRanges;
    }

    public interface BlobBuilders {
        /**
         * Azure Storage Blob Service (camel-azure-storage-blob)
         * Store and retrieve blobs from Azure Storage Blob Service using SDK
         * v12.
         * 
         * Category: cloud,file
         * Since: 3.3
         * Maven coordinates: org.apache.camel:camel-azure-storage-blob
         * 
         * Syntax: <code>azure-storage-blob:accountName/containerName</code>
         * 
         * Path parameter: accountName
         * Azure account name to be used for authentication with azure blob
         * services
         * 
         * Path parameter: containerName
         * The blob container name
         * 
         * @param path accountName/containerName
         * @return the dsl builder
         */
        default BlobEndpointBuilder azureStorageBlob(String path) {
            return BlobEndpointBuilderFactory.endpointBuilder("azure-storage-blob", path);
        }
        /**
         * Azure Storage Blob Service (camel-azure-storage-blob)
         * Store and retrieve blobs from Azure Storage Blob Service using SDK
         * v12.
         * 
         * Category: cloud,file
         * Since: 3.3
         * Maven coordinates: org.apache.camel:camel-azure-storage-blob
         * 
         * Syntax: <code>azure-storage-blob:accountName/containerName</code>
         * 
         * Path parameter: accountName
         * Azure account name to be used for authentication with azure blob
         * services
         * 
         * Path parameter: containerName
         * The blob container name
         * 
         * @param componentName to use a custom component name for the endpoint
         * instead of the default name
         * @param path accountName/containerName
         * @return the dsl builder
         */
        default BlobEndpointBuilder azureStorageBlob(
                String componentName,
                String path) {
            return BlobEndpointBuilderFactory.endpointBuilder(componentName, path);
        }
    }
    static BlobEndpointBuilder endpointBuilder(String componentName, String path) {
        class BlobEndpointBuilderImpl extends AbstractEndpointBuilder implements BlobEndpointBuilder, AdvancedBlobEndpointBuilder {
            public BlobEndpointBuilderImpl(String path) {
                super(componentName, path);
            }
        }
        return new BlobEndpointBuilderImpl(path);
    }
}