/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.apache.camel.component.slack;

public final class SlackConstants {

    public static final String SLACK_USERNAME_FIELD = "username";
    public static final String SLACK_TEXT_FIELD = "text";
    public static final String SLACK_CHANNEL_FIELD = "channel";
    public static final String SLACK_ICON_URL_FIELD = "icon_url";
    public static final String SLACK_ICON_EMOJI_FIELD = "icon_emoji";
    public static final String SLACK_ATTACHMENTS_FIELD = "attachments";

    public static final String SLACK_ATTACHMENT_FALLBACK_FIELD = "fallback";
    public static final String SLACK_ATTACHMENT_COLOR_FIELD = "color";
    public static final String SLACK_ATTACHMENT_TEXT_FIELD = "text";
    public static final String SLACK_ATTACHMENT_PRETEXT_FIELD = "pretext";
    public static final String SLACK_ATTACHMENT_AUTHOR_NAME_FIELD = "author_name";
    public static final String SLACK_ATTACHMENT_AUTHOR_LINK_FIELD = "author_link";
    public static final String SLACK_ATTACHMENT_AUTHOR_ICON_FIELD = "author_icon";
    public static final String SLACK_ATTACHMENT_TITLE_FIELD = "title";
    public static final String SLACK_ATTACHMENT_TITLE_LINK_FIELD = "title_link";
    public static final String SLACK_ATTACHMENT_IMAGE_URL_FIELD = "image_url";
    public static final String SLACK_ATTACHMENT_FOOTER_FIELD = "footer";
    public static final String SLACK_ATTACHMENT_FOOTER_ICON_FIELD = "footer_icon";
    public static final String SLACK_ATTACHMENT_TS_FIELD = "ts";

    private SlackConstants() {
    }
}
