/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.apache.camel.builder.endpoint.dsl;

import java.util.Map;
import javax.annotation.Generated;
import org.apache.camel.ExchangePattern;
import org.apache.camel.builder.EndpointConsumerBuilder;
import org.apache.camel.builder.EndpointProducerBuilder;
import org.apache.camel.builder.endpoint.AbstractEndpointBuilder;
import org.apache.camel.spi.ExceptionHandler;

/**
 * Manage posts and users using Wordpress API.
 * 
 * Generated by camel build tools - do NOT edit this file!
 */
@Generated("org.apache.camel.maven.packaging.EndpointDslMojo")
public interface WordpressEndpointBuilderFactory {


    /**
     * Builder for endpoint consumers for the Wordpress component.
     */
    public interface WordpressEndpointConsumerBuilder
            extends
                EndpointConsumerBuilder {
        default AdvancedWordpressEndpointConsumerBuilder advanced() {
            return (AdvancedWordpressEndpointConsumerBuilder) this;
        }
        /**
         * The Wordpress REST API version.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Default: 2
         * Group: common
         */
        default WordpressEndpointConsumerBuilder apiVersion(String apiVersion) {
            doSetProperty("apiVersion", apiVersion);
            return this;
        }
        /**
         * The criteria to use with complex searches.
         * 
         * The option is a: <code>java.util.Map&lt;java.lang.String,
         * java.lang.Object&gt;</code> type.
         * The option is multivalued, and you can use the criteria(String,
         * Object) method to add a value (call the method multiple times to set
         * more values).
         * 
         * Group: common
         */
        default WordpressEndpointConsumerBuilder criteria(
                String key,
                Object value) {
            doSetMultiValueProperty("criteria", "criteria." + key, value);
            return this;
        }
        /**
         * The criteria to use with complex searches.
         * 
         * The option is a: <code>java.util.Map&lt;java.lang.String,
         * java.lang.Object&gt;</code> type.
         * The option is multivalued, and you can use the criteria(String,
         * Object) method to add a value (call the method multiple times to set
         * more values).
         * 
         * Group: common
         */
        default WordpressEndpointConsumerBuilder criteria(Map values) {
            doSetMultiValueProperties("criteria", "criteria.", values);
            return this;
        }
        /**
         * Whether to bypass trash and force deletion.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Default: false
         * Group: common
         */
        default WordpressEndpointConsumerBuilder force(boolean force) {
            doSetProperty("force", force);
            return this;
        }
        /**
         * Whether to bypass trash and force deletion.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Default: false
         * Group: common
         */
        default WordpressEndpointConsumerBuilder force(String force) {
            doSetProperty("force", force);
            return this;
        }
        /**
         * The entity ID. Should be passed when the operation performed requires
         * a specific entity, e.g. deleting a post.
         * 
         * The option is a: <code>java.lang.Integer</code> type.
         * 
         * Group: common
         */
        default WordpressEndpointConsumerBuilder id(Integer id) {
            doSetProperty("id", id);
            return this;
        }
        /**
         * The entity ID. Should be passed when the operation performed requires
         * a specific entity, e.g. deleting a post.
         * 
         * The option will be converted to a <code>java.lang.Integer</code>
         * type.
         * 
         * Group: common
         */
        default WordpressEndpointConsumerBuilder id(String id) {
            doSetProperty("id", id);
            return this;
        }
        /**
         * Password from authorized user.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: common
         */
        default WordpressEndpointConsumerBuilder password(String password) {
            doSetProperty("password", password);
            return this;
        }
        /**
         * Search criteria.
         * 
         * The option is a:
         * <code>org.apache.camel.component.wordpress.api.model.SearchCriteria</code> type.
         * 
         * Group: common
         */
        default WordpressEndpointConsumerBuilder searchCriteria(
                Object searchCriteria) {
            doSetProperty("searchCriteria", searchCriteria);
            return this;
        }
        /**
         * Search criteria.
         * 
         * The option will be converted to a
         * <code>org.apache.camel.component.wordpress.api.model.SearchCriteria</code> type.
         * 
         * Group: common
         */
        default WordpressEndpointConsumerBuilder searchCriteria(
                String searchCriteria) {
            doSetProperty("searchCriteria", searchCriteria);
            return this;
        }
        /**
         * The Wordpress API URL from your site, e.g.
         * http://myblog.com/wp-json/.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Required: true
         * Group: common
         */
        default WordpressEndpointConsumerBuilder url(String url) {
            doSetProperty("url", url);
            return this;
        }
        /**
         * Authorized user to perform writing operations.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: common
         */
        default WordpressEndpointConsumerBuilder user(String user) {
            doSetProperty("user", user);
            return this;
        }
        /**
         * Allows for bridging the consumer to the Camel routing Error Handler,
         * which mean any exceptions occurred while the consumer is trying to
         * pickup incoming messages, or the likes, will now be processed as a
         * message and handled by the routing Error Handler. By default the
         * consumer will use the org.apache.camel.spi.ExceptionHandler to deal
         * with exceptions, that will be logged at WARN or ERROR level and
         * ignored.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Default: false
         * Group: consumer
         */
        default WordpressEndpointConsumerBuilder bridgeErrorHandler(
                boolean bridgeErrorHandler) {
            doSetProperty("bridgeErrorHandler", bridgeErrorHandler);
            return this;
        }
        /**
         * Allows for bridging the consumer to the Camel routing Error Handler,
         * which mean any exceptions occurred while the consumer is trying to
         * pickup incoming messages, or the likes, will now be processed as a
         * message and handled by the routing Error Handler. By default the
         * consumer will use the org.apache.camel.spi.ExceptionHandler to deal
         * with exceptions, that will be logged at WARN or ERROR level and
         * ignored.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Default: false
         * Group: consumer
         */
        default WordpressEndpointConsumerBuilder bridgeErrorHandler(
                String bridgeErrorHandler) {
            doSetProperty("bridgeErrorHandler", bridgeErrorHandler);
            return this;
        }
    }

    /**
     * Advanced builder for endpoint consumers for the Wordpress component.
     */
    public interface AdvancedWordpressEndpointConsumerBuilder
            extends
                EndpointConsumerBuilder {
        default WordpressEndpointConsumerBuilder basic() {
            return (WordpressEndpointConsumerBuilder) this;
        }
        /**
         * To let the consumer use a custom ExceptionHandler. Notice if the
         * option bridgeErrorHandler is enabled then this option is not in use.
         * By default the consumer will deal with exceptions, that will be
         * logged at WARN or ERROR level and ignored.
         * 
         * The option is a: <code>org.apache.camel.spi.ExceptionHandler</code>
         * type.
         * 
         * Group: consumer (advanced)
         */
        default AdvancedWordpressEndpointConsumerBuilder exceptionHandler(
                ExceptionHandler exceptionHandler) {
            doSetProperty("exceptionHandler", exceptionHandler);
            return this;
        }
        /**
         * To let the consumer use a custom ExceptionHandler. Notice if the
         * option bridgeErrorHandler is enabled then this option is not in use.
         * By default the consumer will deal with exceptions, that will be
         * logged at WARN or ERROR level and ignored.
         * 
         * The option will be converted to a
         * <code>org.apache.camel.spi.ExceptionHandler</code> type.
         * 
         * Group: consumer (advanced)
         */
        default AdvancedWordpressEndpointConsumerBuilder exceptionHandler(
                String exceptionHandler) {
            doSetProperty("exceptionHandler", exceptionHandler);
            return this;
        }
        /**
         * Sets the exchange pattern when the consumer creates an exchange.
         * 
         * The option is a: <code>org.apache.camel.ExchangePattern</code> type.
         * 
         * Group: consumer (advanced)
         */
        default AdvancedWordpressEndpointConsumerBuilder exchangePattern(
                ExchangePattern exchangePattern) {
            doSetProperty("exchangePattern", exchangePattern);
            return this;
        }
        /**
         * Sets the exchange pattern when the consumer creates an exchange.
         * 
         * The option will be converted to a
         * <code>org.apache.camel.ExchangePattern</code> type.
         * 
         * Group: consumer (advanced)
         */
        default AdvancedWordpressEndpointConsumerBuilder exchangePattern(
                String exchangePattern) {
            doSetProperty("exchangePattern", exchangePattern);
            return this;
        }
        /**
         * Whether the endpoint should use basic property binding (Camel 2.x) or
         * the newer property binding with additional capabilities.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Default: false
         * Group: advanced
         */
        default AdvancedWordpressEndpointConsumerBuilder basicPropertyBinding(
                boolean basicPropertyBinding) {
            doSetProperty("basicPropertyBinding", basicPropertyBinding);
            return this;
        }
        /**
         * Whether the endpoint should use basic property binding (Camel 2.x) or
         * the newer property binding with additional capabilities.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Default: false
         * Group: advanced
         */
        default AdvancedWordpressEndpointConsumerBuilder basicPropertyBinding(
                String basicPropertyBinding) {
            doSetProperty("basicPropertyBinding", basicPropertyBinding);
            return this;
        }
        /**
         * Sets whether synchronous processing should be strictly used, or Camel
         * is allowed to use asynchronous processing (if supported).
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Default: false
         * Group: advanced
         */
        default AdvancedWordpressEndpointConsumerBuilder synchronous(
                boolean synchronous) {
            doSetProperty("synchronous", synchronous);
            return this;
        }
        /**
         * Sets whether synchronous processing should be strictly used, or Camel
         * is allowed to use asynchronous processing (if supported).
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Default: false
         * Group: advanced
         */
        default AdvancedWordpressEndpointConsumerBuilder synchronous(
                String synchronous) {
            doSetProperty("synchronous", synchronous);
            return this;
        }
    }

    /**
     * Builder for endpoint producers for the Wordpress component.
     */
    public interface WordpressEndpointProducerBuilder
            extends
                EndpointProducerBuilder {
        default AdvancedWordpressEndpointProducerBuilder advanced() {
            return (AdvancedWordpressEndpointProducerBuilder) this;
        }
        /**
         * The Wordpress REST API version.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Default: 2
         * Group: common
         */
        default WordpressEndpointProducerBuilder apiVersion(String apiVersion) {
            doSetProperty("apiVersion", apiVersion);
            return this;
        }
        /**
         * The criteria to use with complex searches.
         * 
         * The option is a: <code>java.util.Map&lt;java.lang.String,
         * java.lang.Object&gt;</code> type.
         * The option is multivalued, and you can use the criteria(String,
         * Object) method to add a value (call the method multiple times to set
         * more values).
         * 
         * Group: common
         */
        default WordpressEndpointProducerBuilder criteria(
                String key,
                Object value) {
            doSetMultiValueProperty("criteria", "criteria." + key, value);
            return this;
        }
        /**
         * The criteria to use with complex searches.
         * 
         * The option is a: <code>java.util.Map&lt;java.lang.String,
         * java.lang.Object&gt;</code> type.
         * The option is multivalued, and you can use the criteria(String,
         * Object) method to add a value (call the method multiple times to set
         * more values).
         * 
         * Group: common
         */
        default WordpressEndpointProducerBuilder criteria(Map values) {
            doSetMultiValueProperties("criteria", "criteria.", values);
            return this;
        }
        /**
         * Whether to bypass trash and force deletion.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Default: false
         * Group: common
         */
        default WordpressEndpointProducerBuilder force(boolean force) {
            doSetProperty("force", force);
            return this;
        }
        /**
         * Whether to bypass trash and force deletion.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Default: false
         * Group: common
         */
        default WordpressEndpointProducerBuilder force(String force) {
            doSetProperty("force", force);
            return this;
        }
        /**
         * The entity ID. Should be passed when the operation performed requires
         * a specific entity, e.g. deleting a post.
         * 
         * The option is a: <code>java.lang.Integer</code> type.
         * 
         * Group: common
         */
        default WordpressEndpointProducerBuilder id(Integer id) {
            doSetProperty("id", id);
            return this;
        }
        /**
         * The entity ID. Should be passed when the operation performed requires
         * a specific entity, e.g. deleting a post.
         * 
         * The option will be converted to a <code>java.lang.Integer</code>
         * type.
         * 
         * Group: common
         */
        default WordpressEndpointProducerBuilder id(String id) {
            doSetProperty("id", id);
            return this;
        }
        /**
         * Password from authorized user.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: common
         */
        default WordpressEndpointProducerBuilder password(String password) {
            doSetProperty("password", password);
            return this;
        }
        /**
         * Search criteria.
         * 
         * The option is a:
         * <code>org.apache.camel.component.wordpress.api.model.SearchCriteria</code> type.
         * 
         * Group: common
         */
        default WordpressEndpointProducerBuilder searchCriteria(
                Object searchCriteria) {
            doSetProperty("searchCriteria", searchCriteria);
            return this;
        }
        /**
         * Search criteria.
         * 
         * The option will be converted to a
         * <code>org.apache.camel.component.wordpress.api.model.SearchCriteria</code> type.
         * 
         * Group: common
         */
        default WordpressEndpointProducerBuilder searchCriteria(
                String searchCriteria) {
            doSetProperty("searchCriteria", searchCriteria);
            return this;
        }
        /**
         * The Wordpress API URL from your site, e.g.
         * http://myblog.com/wp-json/.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Required: true
         * Group: common
         */
        default WordpressEndpointProducerBuilder url(String url) {
            doSetProperty("url", url);
            return this;
        }
        /**
         * Authorized user to perform writing operations.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: common
         */
        default WordpressEndpointProducerBuilder user(String user) {
            doSetProperty("user", user);
            return this;
        }
        /**
         * Whether the producer should be started lazy (on the first message).
         * By starting lazy you can use this to allow CamelContext and routes to
         * startup in situations where a producer may otherwise fail during
         * starting and cause the route to fail being started. By deferring this
         * startup to be lazy then the startup failure can be handled during
         * routing messages via Camel's routing error handlers. Beware that when
         * the first message is processed then creating and starting the
         * producer may take a little time and prolong the total processing time
         * of the processing.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Default: false
         * Group: producer
         */
        default WordpressEndpointProducerBuilder lazyStartProducer(
                boolean lazyStartProducer) {
            doSetProperty("lazyStartProducer", lazyStartProducer);
            return this;
        }
        /**
         * Whether the producer should be started lazy (on the first message).
         * By starting lazy you can use this to allow CamelContext and routes to
         * startup in situations where a producer may otherwise fail during
         * starting and cause the route to fail being started. By deferring this
         * startup to be lazy then the startup failure can be handled during
         * routing messages via Camel's routing error handlers. Beware that when
         * the first message is processed then creating and starting the
         * producer may take a little time and prolong the total processing time
         * of the processing.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Default: false
         * Group: producer
         */
        default WordpressEndpointProducerBuilder lazyStartProducer(
                String lazyStartProducer) {
            doSetProperty("lazyStartProducer", lazyStartProducer);
            return this;
        }
    }

    /**
     * Advanced builder for endpoint producers for the Wordpress component.
     */
    public interface AdvancedWordpressEndpointProducerBuilder
            extends
                EndpointProducerBuilder {
        default WordpressEndpointProducerBuilder basic() {
            return (WordpressEndpointProducerBuilder) this;
        }
        /**
         * Whether the endpoint should use basic property binding (Camel 2.x) or
         * the newer property binding with additional capabilities.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Default: false
         * Group: advanced
         */
        default AdvancedWordpressEndpointProducerBuilder basicPropertyBinding(
                boolean basicPropertyBinding) {
            doSetProperty("basicPropertyBinding", basicPropertyBinding);
            return this;
        }
        /**
         * Whether the endpoint should use basic property binding (Camel 2.x) or
         * the newer property binding with additional capabilities.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Default: false
         * Group: advanced
         */
        default AdvancedWordpressEndpointProducerBuilder basicPropertyBinding(
                String basicPropertyBinding) {
            doSetProperty("basicPropertyBinding", basicPropertyBinding);
            return this;
        }
        /**
         * Sets whether synchronous processing should be strictly used, or Camel
         * is allowed to use asynchronous processing (if supported).
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Default: false
         * Group: advanced
         */
        default AdvancedWordpressEndpointProducerBuilder synchronous(
                boolean synchronous) {
            doSetProperty("synchronous", synchronous);
            return this;
        }
        /**
         * Sets whether synchronous processing should be strictly used, or Camel
         * is allowed to use asynchronous processing (if supported).
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Default: false
         * Group: advanced
         */
        default AdvancedWordpressEndpointProducerBuilder synchronous(
                String synchronous) {
            doSetProperty("synchronous", synchronous);
            return this;
        }
    }

    /**
     * Builder for endpoint for the Wordpress component.
     */
    public interface WordpressEndpointBuilder
            extends
                WordpressEndpointConsumerBuilder,
                WordpressEndpointProducerBuilder {
        default AdvancedWordpressEndpointBuilder advanced() {
            return (AdvancedWordpressEndpointBuilder) this;
        }
        /**
         * The Wordpress REST API version.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Default: 2
         * Group: common
         */
        default WordpressEndpointBuilder apiVersion(String apiVersion) {
            doSetProperty("apiVersion", apiVersion);
            return this;
        }
        /**
         * The criteria to use with complex searches.
         * 
         * The option is a: <code>java.util.Map&lt;java.lang.String,
         * java.lang.Object&gt;</code> type.
         * The option is multivalued, and you can use the criteria(String,
         * Object) method to add a value (call the method multiple times to set
         * more values).
         * 
         * Group: common
         */
        default WordpressEndpointBuilder criteria(String key, Object value) {
            doSetMultiValueProperty("criteria", "criteria." + key, value);
            return this;
        }
        /**
         * The criteria to use with complex searches.
         * 
         * The option is a: <code>java.util.Map&lt;java.lang.String,
         * java.lang.Object&gt;</code> type.
         * The option is multivalued, and you can use the criteria(String,
         * Object) method to add a value (call the method multiple times to set
         * more values).
         * 
         * Group: common
         */
        default WordpressEndpointBuilder criteria(Map values) {
            doSetMultiValueProperties("criteria", "criteria.", values);
            return this;
        }
        /**
         * Whether to bypass trash and force deletion.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Default: false
         * Group: common
         */
        default WordpressEndpointBuilder force(boolean force) {
            doSetProperty("force", force);
            return this;
        }
        /**
         * Whether to bypass trash and force deletion.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Default: false
         * Group: common
         */
        default WordpressEndpointBuilder force(String force) {
            doSetProperty("force", force);
            return this;
        }
        /**
         * The entity ID. Should be passed when the operation performed requires
         * a specific entity, e.g. deleting a post.
         * 
         * The option is a: <code>java.lang.Integer</code> type.
         * 
         * Group: common
         */
        default WordpressEndpointBuilder id(Integer id) {
            doSetProperty("id", id);
            return this;
        }
        /**
         * The entity ID. Should be passed when the operation performed requires
         * a specific entity, e.g. deleting a post.
         * 
         * The option will be converted to a <code>java.lang.Integer</code>
         * type.
         * 
         * Group: common
         */
        default WordpressEndpointBuilder id(String id) {
            doSetProperty("id", id);
            return this;
        }
        /**
         * Password from authorized user.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: common
         */
        default WordpressEndpointBuilder password(String password) {
            doSetProperty("password", password);
            return this;
        }
        /**
         * Search criteria.
         * 
         * The option is a:
         * <code>org.apache.camel.component.wordpress.api.model.SearchCriteria</code> type.
         * 
         * Group: common
         */
        default WordpressEndpointBuilder searchCriteria(Object searchCriteria) {
            doSetProperty("searchCriteria", searchCriteria);
            return this;
        }
        /**
         * Search criteria.
         * 
         * The option will be converted to a
         * <code>org.apache.camel.component.wordpress.api.model.SearchCriteria</code> type.
         * 
         * Group: common
         */
        default WordpressEndpointBuilder searchCriteria(String searchCriteria) {
            doSetProperty("searchCriteria", searchCriteria);
            return this;
        }
        /**
         * The Wordpress API URL from your site, e.g.
         * http://myblog.com/wp-json/.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Required: true
         * Group: common
         */
        default WordpressEndpointBuilder url(String url) {
            doSetProperty("url", url);
            return this;
        }
        /**
         * Authorized user to perform writing operations.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: common
         */
        default WordpressEndpointBuilder user(String user) {
            doSetProperty("user", user);
            return this;
        }
    }

    /**
     * Advanced builder for endpoint for the Wordpress component.
     */
    public interface AdvancedWordpressEndpointBuilder
            extends
                AdvancedWordpressEndpointConsumerBuilder,
                AdvancedWordpressEndpointProducerBuilder {
        default WordpressEndpointBuilder basic() {
            return (WordpressEndpointBuilder) this;
        }
        /**
         * Whether the endpoint should use basic property binding (Camel 2.x) or
         * the newer property binding with additional capabilities.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Default: false
         * Group: advanced
         */
        default AdvancedWordpressEndpointBuilder basicPropertyBinding(
                boolean basicPropertyBinding) {
            doSetProperty("basicPropertyBinding", basicPropertyBinding);
            return this;
        }
        /**
         * Whether the endpoint should use basic property binding (Camel 2.x) or
         * the newer property binding with additional capabilities.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Default: false
         * Group: advanced
         */
        default AdvancedWordpressEndpointBuilder basicPropertyBinding(
                String basicPropertyBinding) {
            doSetProperty("basicPropertyBinding", basicPropertyBinding);
            return this;
        }
        /**
         * Sets whether synchronous processing should be strictly used, or Camel
         * is allowed to use asynchronous processing (if supported).
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Default: false
         * Group: advanced
         */
        default AdvancedWordpressEndpointBuilder synchronous(boolean synchronous) {
            doSetProperty("synchronous", synchronous);
            return this;
        }
        /**
         * Sets whether synchronous processing should be strictly used, or Camel
         * is allowed to use asynchronous processing (if supported).
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Default: false
         * Group: advanced
         */
        default AdvancedWordpressEndpointBuilder synchronous(String synchronous) {
            doSetProperty("synchronous", synchronous);
            return this;
        }
    }

    public interface WordpressBuilders {
        /**
         * Wordpress (camel-wordpress)
         * Manage posts and users using Wordpress API.
         * 
         * Category: cloud,api,cms
         * Since: 2.21
         * Maven coordinates: org.apache.camel:camel-wordpress
         * 
         * Syntax: <code>wordpress:operation</code>
         * 
         * Path parameter: operation (required)
         * The endpoint operation.
         * There are 2 enums and the value can be one of: post, user
         * 
         * Path parameter: operationDetail
         * The second part of an endpoint operation. Needed only when endpoint
         * semantic is not enough, like wordpress:post:delete
         * There are 1 enums and the value can be one of: delete
         * 
         * @param path operation
         */
        default WordpressEndpointBuilder wordpress(String path) {
            return WordpressEndpointBuilderFactory.endpointBuilder("wordpress", path);
        }
        /**
         * Wordpress (camel-wordpress)
         * Manage posts and users using Wordpress API.
         * 
         * Category: cloud,api,cms
         * Since: 2.21
         * Maven coordinates: org.apache.camel:camel-wordpress
         * 
         * Syntax: <code>wordpress:operation</code>
         * 
         * Path parameter: operation (required)
         * The endpoint operation.
         * There are 2 enums and the value can be one of: post, user
         * 
         * Path parameter: operationDetail
         * The second part of an endpoint operation. Needed only when endpoint
         * semantic is not enough, like wordpress:post:delete
         * There are 1 enums and the value can be one of: delete
         * 
         * @param componentName to use a custom component name for the endpoint
         * instead of the default name
         * @param path operation
         */
        default WordpressEndpointBuilder wordpress(
                String componentName,
                String path) {
            return WordpressEndpointBuilderFactory.endpointBuilder(componentName, path);
        }
    }
    static WordpressEndpointBuilder endpointBuilder(
            String componentName,
            String path) {
        class WordpressEndpointBuilderImpl extends AbstractEndpointBuilder implements WordpressEndpointBuilder, AdvancedWordpressEndpointBuilder {
            public WordpressEndpointBuilderImpl(String path) {
                super(componentName, path);
            }
        }
        return new WordpressEndpointBuilderImpl(path);
    }
}