/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.apache.camel.builder.endpoint.dsl;

import java.util.Map;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import javax.annotation.Generated;
import org.apache.camel.ExchangePattern;
import org.apache.camel.LoggingLevel;
import org.apache.camel.builder.EndpointConsumerBuilder;
import org.apache.camel.builder.EndpointProducerBuilder;
import org.apache.camel.builder.endpoint.AbstractEndpointBuilder;
import org.apache.camel.spi.ExceptionHandler;
import org.apache.camel.spi.PollingConsumerPollStrategy;

/**
 * Exchange information in the healthcare domain using the FHIR (Fast Healthcare
 * Interoperability Resources) standard.
 * 
 * Generated by camel build tools - do NOT edit this file!
 */
@Generated("org.apache.camel.maven.packaging.EndpointDslMojo")
public interface FhirEndpointBuilderFactory {


    /**
     * Builder for endpoint consumers for the FHIR component.
     */
    public interface FhirEndpointConsumerBuilder
            extends
                EndpointConsumerBuilder {
        default AdvancedFhirEndpointConsumerBuilder advanced() {
            return (AdvancedFhirEndpointConsumerBuilder) this;
        }
        /**
         * Encoding to use for all request.
         * 
         * The option is a: <code>ca.uhn.fhir.rest.api.EncodingEnum</code> type.
         * 
         * Group: common
         */
        default FhirEndpointConsumerBuilder encoding(EncodingEnum encoding) {
            doSetProperty("encoding", encoding);
            return this;
        }
        /**
         * Encoding to use for all request.
         * 
         * The option will be converted to a
         * <code>ca.uhn.fhir.rest.api.EncodingEnum</code> type.
         * 
         * Group: common
         */
        default FhirEndpointConsumerBuilder encoding(String encoding) {
            doSetProperty("encoding", encoding);
            return this;
        }
        /**
         * The FHIR Version to use.
         * 
         * The option is a: <code>ca.uhn.fhir.context.FhirVersionEnum</code>
         * type.
         * 
         * Default: R4
         * Group: common
         */
        default FhirEndpointConsumerBuilder fhirVersion(
                FhirVersionEnum fhirVersion) {
            doSetProperty("fhirVersion", fhirVersion);
            return this;
        }
        /**
         * The FHIR Version to use.
         * 
         * The option will be converted to a
         * <code>ca.uhn.fhir.context.FhirVersionEnum</code> type.
         * 
         * Default: R4
         * Group: common
         */
        default FhirEndpointConsumerBuilder fhirVersion(String fhirVersion) {
            doSetProperty("fhirVersion", fhirVersion);
            return this;
        }
        /**
         * Sets the name of a parameter to be passed in the exchange In Body.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: common
         */
        default FhirEndpointConsumerBuilder inBody(String inBody) {
            doSetProperty("inBody", inBody);
            return this;
        }
        /**
         * Will log every requests and responses.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Default: false
         * Group: common
         */
        default FhirEndpointConsumerBuilder log(boolean log) {
            doSetProperty("log", log);
            return this;
        }
        /**
         * Will log every requests and responses.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Default: false
         * Group: common
         */
        default FhirEndpointConsumerBuilder log(String log) {
            doSetProperty("log", log);
            return this;
        }
        /**
         * Pretty print all request.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Default: false
         * Group: common
         */
        default FhirEndpointConsumerBuilder prettyPrint(boolean prettyPrint) {
            doSetProperty("prettyPrint", prettyPrint);
            return this;
        }
        /**
         * Pretty print all request.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Default: false
         * Group: common
         */
        default FhirEndpointConsumerBuilder prettyPrint(String prettyPrint) {
            doSetProperty("prettyPrint", prettyPrint);
            return this;
        }
        /**
         * The FHIR server base URL.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: common
         */
        default FhirEndpointConsumerBuilder serverUrl(String serverUrl) {
            doSetProperty("serverUrl", serverUrl);
            return this;
        }
        /**
         * Allows for bridging the consumer to the Camel routing Error Handler,
         * which mean any exceptions occurred while the consumer is trying to
         * pickup incoming messages, or the likes, will now be processed as a
         * message and handled by the routing Error Handler. By default the
         * consumer will use the org.apache.camel.spi.ExceptionHandler to deal
         * with exceptions, that will be logged at WARN or ERROR level and
         * ignored.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Default: false
         * Group: consumer
         */
        default FhirEndpointConsumerBuilder bridgeErrorHandler(
                boolean bridgeErrorHandler) {
            doSetProperty("bridgeErrorHandler", bridgeErrorHandler);
            return this;
        }
        /**
         * Allows for bridging the consumer to the Camel routing Error Handler,
         * which mean any exceptions occurred while the consumer is trying to
         * pickup incoming messages, or the likes, will now be processed as a
         * message and handled by the routing Error Handler. By default the
         * consumer will use the org.apache.camel.spi.ExceptionHandler to deal
         * with exceptions, that will be logged at WARN or ERROR level and
         * ignored.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Default: false
         * Group: consumer
         */
        default FhirEndpointConsumerBuilder bridgeErrorHandler(
                String bridgeErrorHandler) {
            doSetProperty("bridgeErrorHandler", bridgeErrorHandler);
            return this;
        }
        /**
         * If the polling consumer did not poll any files, you can enable this
         * option to send an empty message (no body) instead.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Default: false
         * Group: consumer
         */
        default FhirEndpointConsumerBuilder sendEmptyMessageWhenIdle(
                boolean sendEmptyMessageWhenIdle) {
            doSetProperty("sendEmptyMessageWhenIdle", sendEmptyMessageWhenIdle);
            return this;
        }
        /**
         * If the polling consumer did not poll any files, you can enable this
         * option to send an empty message (no body) instead.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Default: false
         * Group: consumer
         */
        default FhirEndpointConsumerBuilder sendEmptyMessageWhenIdle(
                String sendEmptyMessageWhenIdle) {
            doSetProperty("sendEmptyMessageWhenIdle", sendEmptyMessageWhenIdle);
            return this;
        }
        /**
         * The proxy host.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: proxy
         */
        default FhirEndpointConsumerBuilder proxyHost(String proxyHost) {
            doSetProperty("proxyHost", proxyHost);
            return this;
        }
        /**
         * The proxy password.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: proxy
         */
        default FhirEndpointConsumerBuilder proxyPassword(String proxyPassword) {
            doSetProperty("proxyPassword", proxyPassword);
            return this;
        }
        /**
         * The proxy port.
         * 
         * The option is a: <code>java.lang.Integer</code> type.
         * 
         * Group: proxy
         */
        default FhirEndpointConsumerBuilder proxyPort(Integer proxyPort) {
            doSetProperty("proxyPort", proxyPort);
            return this;
        }
        /**
         * The proxy port.
         * 
         * The option will be converted to a <code>java.lang.Integer</code>
         * type.
         * 
         * Group: proxy
         */
        default FhirEndpointConsumerBuilder proxyPort(String proxyPort) {
            doSetProperty("proxyPort", proxyPort);
            return this;
        }
        /**
         * The proxy username.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: proxy
         */
        default FhirEndpointConsumerBuilder proxyUser(String proxyUser) {
            doSetProperty("proxyUser", proxyUser);
            return this;
        }
        /**
         * The number of subsequent error polls (failed due some error) that
         * should happen before the backoffMultipler should kick-in.
         * 
         * The option is a: <code>int</code> type.
         * 
         * Group: scheduler
         */
        default FhirEndpointConsumerBuilder backoffErrorThreshold(
                int backoffErrorThreshold) {
            doSetProperty("backoffErrorThreshold", backoffErrorThreshold);
            return this;
        }
        /**
         * The number of subsequent error polls (failed due some error) that
         * should happen before the backoffMultipler should kick-in.
         * 
         * The option will be converted to a <code>int</code> type.
         * 
         * Group: scheduler
         */
        default FhirEndpointConsumerBuilder backoffErrorThreshold(
                String backoffErrorThreshold) {
            doSetProperty("backoffErrorThreshold", backoffErrorThreshold);
            return this;
        }
        /**
         * The number of subsequent idle polls that should happen before the
         * backoffMultipler should kick-in.
         * 
         * The option is a: <code>int</code> type.
         * 
         * Group: scheduler
         */
        default FhirEndpointConsumerBuilder backoffIdleThreshold(
                int backoffIdleThreshold) {
            doSetProperty("backoffIdleThreshold", backoffIdleThreshold);
            return this;
        }
        /**
         * The number of subsequent idle polls that should happen before the
         * backoffMultipler should kick-in.
         * 
         * The option will be converted to a <code>int</code> type.
         * 
         * Group: scheduler
         */
        default FhirEndpointConsumerBuilder backoffIdleThreshold(
                String backoffIdleThreshold) {
            doSetProperty("backoffIdleThreshold", backoffIdleThreshold);
            return this;
        }
        /**
         * To let the scheduled polling consumer backoff if there has been a
         * number of subsequent idles/errors in a row. The multiplier is then
         * the number of polls that will be skipped before the next actual
         * attempt is happening again. When this option is in use then
         * backoffIdleThreshold and/or backoffErrorThreshold must also be
         * configured.
         * 
         * The option is a: <code>int</code> type.
         * 
         * Group: scheduler
         */
        default FhirEndpointConsumerBuilder backoffMultiplier(
                int backoffMultiplier) {
            doSetProperty("backoffMultiplier", backoffMultiplier);
            return this;
        }
        /**
         * To let the scheduled polling consumer backoff if there has been a
         * number of subsequent idles/errors in a row. The multiplier is then
         * the number of polls that will be skipped before the next actual
         * attempt is happening again. When this option is in use then
         * backoffIdleThreshold and/or backoffErrorThreshold must also be
         * configured.
         * 
         * The option will be converted to a <code>int</code> type.
         * 
         * Group: scheduler
         */
        default FhirEndpointConsumerBuilder backoffMultiplier(
                String backoffMultiplier) {
            doSetProperty("backoffMultiplier", backoffMultiplier);
            return this;
        }
        /**
         * Milliseconds before the next poll.
         * 
         * The option is a: <code>long</code> type.
         * 
         * Default: 500
         * Group: scheduler
         */
        default FhirEndpointConsumerBuilder delay(long delay) {
            doSetProperty("delay", delay);
            return this;
        }
        /**
         * Milliseconds before the next poll.
         * 
         * The option will be converted to a <code>long</code> type.
         * 
         * Default: 500
         * Group: scheduler
         */
        default FhirEndpointConsumerBuilder delay(String delay) {
            doSetProperty("delay", delay);
            return this;
        }
        /**
         * If greedy is enabled, then the ScheduledPollConsumer will run
         * immediately again, if the previous run polled 1 or more messages.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Default: false
         * Group: scheduler
         */
        default FhirEndpointConsumerBuilder greedy(boolean greedy) {
            doSetProperty("greedy", greedy);
            return this;
        }
        /**
         * If greedy is enabled, then the ScheduledPollConsumer will run
         * immediately again, if the previous run polled 1 or more messages.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Default: false
         * Group: scheduler
         */
        default FhirEndpointConsumerBuilder greedy(String greedy) {
            doSetProperty("greedy", greedy);
            return this;
        }
        /**
         * Milliseconds before the first poll starts.
         * 
         * The option is a: <code>long</code> type.
         * 
         * Default: 1000
         * Group: scheduler
         */
        default FhirEndpointConsumerBuilder initialDelay(long initialDelay) {
            doSetProperty("initialDelay", initialDelay);
            return this;
        }
        /**
         * Milliseconds before the first poll starts.
         * 
         * The option will be converted to a <code>long</code> type.
         * 
         * Default: 1000
         * Group: scheduler
         */
        default FhirEndpointConsumerBuilder initialDelay(String initialDelay) {
            doSetProperty("initialDelay", initialDelay);
            return this;
        }
        /**
         * Specifies a maximum limit of number of fires. So if you set it to 1,
         * the scheduler will only fire once. If you set it to 5, it will only
         * fire five times. A value of zero or negative means fire forever.
         * 
         * The option is a: <code>long</code> type.
         * 
         * Default: 0
         * Group: scheduler
         */
        default FhirEndpointConsumerBuilder repeatCount(long repeatCount) {
            doSetProperty("repeatCount", repeatCount);
            return this;
        }
        /**
         * Specifies a maximum limit of number of fires. So if you set it to 1,
         * the scheduler will only fire once. If you set it to 5, it will only
         * fire five times. A value of zero or negative means fire forever.
         * 
         * The option will be converted to a <code>long</code> type.
         * 
         * Default: 0
         * Group: scheduler
         */
        default FhirEndpointConsumerBuilder repeatCount(String repeatCount) {
            doSetProperty("repeatCount", repeatCount);
            return this;
        }
        /**
         * The consumer logs a start/complete log line when it polls. This
         * option allows you to configure the logging level for that.
         * 
         * The option is a: <code>org.apache.camel.LoggingLevel</code> type.
         * 
         * Default: TRACE
         * Group: scheduler
         */
        default FhirEndpointConsumerBuilder runLoggingLevel(
                LoggingLevel runLoggingLevel) {
            doSetProperty("runLoggingLevel", runLoggingLevel);
            return this;
        }
        /**
         * The consumer logs a start/complete log line when it polls. This
         * option allows you to configure the logging level for that.
         * 
         * The option will be converted to a
         * <code>org.apache.camel.LoggingLevel</code> type.
         * 
         * Default: TRACE
         * Group: scheduler
         */
        default FhirEndpointConsumerBuilder runLoggingLevel(
                String runLoggingLevel) {
            doSetProperty("runLoggingLevel", runLoggingLevel);
            return this;
        }
        /**
         * Allows for configuring a custom/shared thread pool to use for the
         * consumer. By default each consumer has its own single threaded thread
         * pool.
         * 
         * The option is a:
         * <code>java.util.concurrent.ScheduledExecutorService</code> type.
         * 
         * Group: scheduler
         */
        default FhirEndpointConsumerBuilder scheduledExecutorService(
                ScheduledExecutorService scheduledExecutorService) {
            doSetProperty("scheduledExecutorService", scheduledExecutorService);
            return this;
        }
        /**
         * Allows for configuring a custom/shared thread pool to use for the
         * consumer. By default each consumer has its own single threaded thread
         * pool.
         * 
         * The option will be converted to a
         * <code>java.util.concurrent.ScheduledExecutorService</code> type.
         * 
         * Group: scheduler
         */
        default FhirEndpointConsumerBuilder scheduledExecutorService(
                String scheduledExecutorService) {
            doSetProperty("scheduledExecutorService", scheduledExecutorService);
            return this;
        }
        /**
         * To use a cron scheduler from either camel-spring or camel-quartz
         * component. Use value spring or quartz for built in scheduler.
         * 
         * The option is a: <code>java.lang.Object</code> type.
         * 
         * Default: none
         * Group: scheduler
         */
        default FhirEndpointConsumerBuilder scheduler(Object scheduler) {
            doSetProperty("scheduler", scheduler);
            return this;
        }
        /**
         * To use a cron scheduler from either camel-spring or camel-quartz
         * component. Use value spring or quartz for built in scheduler.
         * 
         * The option will be converted to a <code>java.lang.Object</code> type.
         * 
         * Default: none
         * Group: scheduler
         */
        default FhirEndpointConsumerBuilder scheduler(String scheduler) {
            doSetProperty("scheduler", scheduler);
            return this;
        }
        /**
         * To configure additional properties when using a custom scheduler or
         * any of the Quartz, Spring based scheduler.
         * 
         * The option is a: <code>java.util.Map&lt;java.lang.String,
         * java.lang.Object&gt;</code> type.
         * The option is multivalued, and you can use the
         * schedulerProperties(String, Object) method to add a value (call the
         * method multiple times to set more values).
         * 
         * Group: scheduler
         */
        default FhirEndpointConsumerBuilder schedulerProperties(
                String key,
                Object value) {
            doSetMultiValueProperty("schedulerProperties", "scheduler." + key, value);
            return this;
        }
        /**
         * To configure additional properties when using a custom scheduler or
         * any of the Quartz, Spring based scheduler.
         * 
         * The option is a: <code>java.util.Map&lt;java.lang.String,
         * java.lang.Object&gt;</code> type.
         * The option is multivalued, and you can use the
         * schedulerProperties(String, Object) method to add a value (call the
         * method multiple times to set more values).
         * 
         * Group: scheduler
         */
        default FhirEndpointConsumerBuilder schedulerProperties(Map values) {
            doSetMultiValueProperties("schedulerProperties", "scheduler.", values);
            return this;
        }
        /**
         * Whether the scheduler should be auto started.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Default: true
         * Group: scheduler
         */
        default FhirEndpointConsumerBuilder startScheduler(
                boolean startScheduler) {
            doSetProperty("startScheduler", startScheduler);
            return this;
        }
        /**
         * Whether the scheduler should be auto started.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Default: true
         * Group: scheduler
         */
        default FhirEndpointConsumerBuilder startScheduler(String startScheduler) {
            doSetProperty("startScheduler", startScheduler);
            return this;
        }
        /**
         * Time unit for initialDelay and delay options.
         * 
         * The option is a: <code>java.util.concurrent.TimeUnit</code> type.
         * 
         * Default: MILLISECONDS
         * Group: scheduler
         */
        default FhirEndpointConsumerBuilder timeUnit(TimeUnit timeUnit) {
            doSetProperty("timeUnit", timeUnit);
            return this;
        }
        /**
         * Time unit for initialDelay and delay options.
         * 
         * The option will be converted to a
         * <code>java.util.concurrent.TimeUnit</code> type.
         * 
         * Default: MILLISECONDS
         * Group: scheduler
         */
        default FhirEndpointConsumerBuilder timeUnit(String timeUnit) {
            doSetProperty("timeUnit", timeUnit);
            return this;
        }
        /**
         * Controls if fixed delay or fixed rate is used. See
         * ScheduledExecutorService in JDK for details.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Default: true
         * Group: scheduler
         */
        default FhirEndpointConsumerBuilder useFixedDelay(boolean useFixedDelay) {
            doSetProperty("useFixedDelay", useFixedDelay);
            return this;
        }
        /**
         * Controls if fixed delay or fixed rate is used. See
         * ScheduledExecutorService in JDK for details.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Default: true
         * Group: scheduler
         */
        default FhirEndpointConsumerBuilder useFixedDelay(String useFixedDelay) {
            doSetProperty("useFixedDelay", useFixedDelay);
            return this;
        }
        /**
         * OAuth access token.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: security
         */
        default FhirEndpointConsumerBuilder accessToken(String accessToken) {
            doSetProperty("accessToken", accessToken);
            return this;
        }
        /**
         * Username to use for basic authentication.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: security
         */
        default FhirEndpointConsumerBuilder password(String password) {
            doSetProperty("password", password);
            return this;
        }
        /**
         * Username to use for basic authentication.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: security
         */
        default FhirEndpointConsumerBuilder username(String username) {
            doSetProperty("username", username);
            return this;
        }
    }

    /**
     * Advanced builder for endpoint consumers for the FHIR component.
     */
    public interface AdvancedFhirEndpointConsumerBuilder
            extends
                EndpointConsumerBuilder {
        default FhirEndpointConsumerBuilder basic() {
            return (FhirEndpointConsumerBuilder) this;
        }
        /**
         * To let the consumer use a custom ExceptionHandler. Notice if the
         * option bridgeErrorHandler is enabled then this option is not in use.
         * By default the consumer will deal with exceptions, that will be
         * logged at WARN or ERROR level and ignored.
         * 
         * The option is a: <code>org.apache.camel.spi.ExceptionHandler</code>
         * type.
         * 
         * Group: consumer (advanced)
         */
        default AdvancedFhirEndpointConsumerBuilder exceptionHandler(
                ExceptionHandler exceptionHandler) {
            doSetProperty("exceptionHandler", exceptionHandler);
            return this;
        }
        /**
         * To let the consumer use a custom ExceptionHandler. Notice if the
         * option bridgeErrorHandler is enabled then this option is not in use.
         * By default the consumer will deal with exceptions, that will be
         * logged at WARN or ERROR level and ignored.
         * 
         * The option will be converted to a
         * <code>org.apache.camel.spi.ExceptionHandler</code> type.
         * 
         * Group: consumer (advanced)
         */
        default AdvancedFhirEndpointConsumerBuilder exceptionHandler(
                String exceptionHandler) {
            doSetProperty("exceptionHandler", exceptionHandler);
            return this;
        }
        /**
         * Sets the exchange pattern when the consumer creates an exchange.
         * 
         * The option is a: <code>org.apache.camel.ExchangePattern</code> type.
         * 
         * Group: consumer (advanced)
         */
        default AdvancedFhirEndpointConsumerBuilder exchangePattern(
                ExchangePattern exchangePattern) {
            doSetProperty("exchangePattern", exchangePattern);
            return this;
        }
        /**
         * Sets the exchange pattern when the consumer creates an exchange.
         * 
         * The option will be converted to a
         * <code>org.apache.camel.ExchangePattern</code> type.
         * 
         * Group: consumer (advanced)
         */
        default AdvancedFhirEndpointConsumerBuilder exchangePattern(
                String exchangePattern) {
            doSetProperty("exchangePattern", exchangePattern);
            return this;
        }
        /**
         * A pluggable org.apache.camel.PollingConsumerPollingStrategy allowing
         * you to provide your custom implementation to control error handling
         * usually occurred during the poll operation before an Exchange have
         * been created and being routed in Camel.
         * 
         * The option is a:
         * <code>org.apache.camel.spi.PollingConsumerPollStrategy</code> type.
         * 
         * Group: consumer (advanced)
         */
        default AdvancedFhirEndpointConsumerBuilder pollStrategy(
                PollingConsumerPollStrategy pollStrategy) {
            doSetProperty("pollStrategy", pollStrategy);
            return this;
        }
        /**
         * A pluggable org.apache.camel.PollingConsumerPollingStrategy allowing
         * you to provide your custom implementation to control error handling
         * usually occurred during the poll operation before an Exchange have
         * been created and being routed in Camel.
         * 
         * The option will be converted to a
         * <code>org.apache.camel.spi.PollingConsumerPollStrategy</code> type.
         * 
         * Group: consumer (advanced)
         */
        default AdvancedFhirEndpointConsumerBuilder pollStrategy(
                String pollStrategy) {
            doSetProperty("pollStrategy", pollStrategy);
            return this;
        }
        /**
         * Whether the endpoint should use basic property binding (Camel 2.x) or
         * the newer property binding with additional capabilities.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Default: false
         * Group: advanced
         */
        default AdvancedFhirEndpointConsumerBuilder basicPropertyBinding(
                boolean basicPropertyBinding) {
            doSetProperty("basicPropertyBinding", basicPropertyBinding);
            return this;
        }
        /**
         * Whether the endpoint should use basic property binding (Camel 2.x) or
         * the newer property binding with additional capabilities.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Default: false
         * Group: advanced
         */
        default AdvancedFhirEndpointConsumerBuilder basicPropertyBinding(
                String basicPropertyBinding) {
            doSetProperty("basicPropertyBinding", basicPropertyBinding);
            return this;
        }
        /**
         * To use the custom client.
         * 
         * The option is a:
         * <code>ca.uhn.fhir.rest.client.api.IGenericClient</code> type.
         * 
         * Group: advanced
         */
        default AdvancedFhirEndpointConsumerBuilder client(Object client) {
            doSetProperty("client", client);
            return this;
        }
        /**
         * To use the custom client.
         * 
         * The option will be converted to a
         * <code>ca.uhn.fhir.rest.client.api.IGenericClient</code> type.
         * 
         * Group: advanced
         */
        default AdvancedFhirEndpointConsumerBuilder client(String client) {
            doSetProperty("client", client);
            return this;
        }
        /**
         * To use the custom client factory.
         * 
         * The option is a:
         * <code>ca.uhn.fhir.rest.client.api.IRestfulClientFactory</code> type.
         * 
         * Group: advanced
         */
        default AdvancedFhirEndpointConsumerBuilder clientFactory(
                Object clientFactory) {
            doSetProperty("clientFactory", clientFactory);
            return this;
        }
        /**
         * To use the custom client factory.
         * 
         * The option will be converted to a
         * <code>ca.uhn.fhir.rest.client.api.IRestfulClientFactory</code> type.
         * 
         * Group: advanced
         */
        default AdvancedFhirEndpointConsumerBuilder clientFactory(
                String clientFactory) {
            doSetProperty("clientFactory", clientFactory);
            return this;
        }
        /**
         * Compresses outgoing (POST/PUT) contents to the GZIP format.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Default: false
         * Group: advanced
         */
        default AdvancedFhirEndpointConsumerBuilder compress(boolean compress) {
            doSetProperty("compress", compress);
            return this;
        }
        /**
         * Compresses outgoing (POST/PUT) contents to the GZIP format.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Default: false
         * Group: advanced
         */
        default AdvancedFhirEndpointConsumerBuilder compress(String compress) {
            doSetProperty("compress", compress);
            return this;
        }
        /**
         * How long to try and establish the initial TCP connection (in ms).
         * 
         * The option is a: <code>java.lang.Integer</code> type.
         * 
         * Default: 10000
         * Group: advanced
         */
        default AdvancedFhirEndpointConsumerBuilder connectionTimeout(
                Integer connectionTimeout) {
            doSetProperty("connectionTimeout", connectionTimeout);
            return this;
        }
        /**
         * How long to try and establish the initial TCP connection (in ms).
         * 
         * The option will be converted to a <code>java.lang.Integer</code>
         * type.
         * 
         * Default: 10000
         * Group: advanced
         */
        default AdvancedFhirEndpointConsumerBuilder connectionTimeout(
                String connectionTimeout) {
            doSetProperty("connectionTimeout", connectionTimeout);
            return this;
        }
        /**
         * When this option is set, model classes will not be scanned for
         * children until the child list for the given type is actually
         * accessed.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Default: false
         * Group: advanced
         */
        default AdvancedFhirEndpointConsumerBuilder deferModelScanning(
                boolean deferModelScanning) {
            doSetProperty("deferModelScanning", deferModelScanning);
            return this;
        }
        /**
         * When this option is set, model classes will not be scanned for
         * children until the child list for the given type is actually
         * accessed.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Default: false
         * Group: advanced
         */
        default AdvancedFhirEndpointConsumerBuilder deferModelScanning(
                String deferModelScanning) {
            doSetProperty("deferModelScanning", deferModelScanning);
            return this;
        }
        /**
         * FhirContext is an expensive object to create. To avoid creating
         * multiple instances, it can be set directly.
         * 
         * The option is a: <code>ca.uhn.fhir.context.FhirContext</code> type.
         * 
         * Group: advanced
         */
        default AdvancedFhirEndpointConsumerBuilder fhirContext(
                Object fhirContext) {
            doSetProperty("fhirContext", fhirContext);
            return this;
        }
        /**
         * FhirContext is an expensive object to create. To avoid creating
         * multiple instances, it can be set directly.
         * 
         * The option will be converted to a
         * <code>ca.uhn.fhir.context.FhirContext</code> type.
         * 
         * Group: advanced
         */
        default AdvancedFhirEndpointConsumerBuilder fhirContext(
                String fhirContext) {
            doSetProperty("fhirContext", fhirContext);
            return this;
        }
        /**
         * Force conformance check.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Default: false
         * Group: advanced
         */
        default AdvancedFhirEndpointConsumerBuilder forceConformanceCheck(
                boolean forceConformanceCheck) {
            doSetProperty("forceConformanceCheck", forceConformanceCheck);
            return this;
        }
        /**
         * Force conformance check.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Default: false
         * Group: advanced
         */
        default AdvancedFhirEndpointConsumerBuilder forceConformanceCheck(
                String forceConformanceCheck) {
            doSetProperty("forceConformanceCheck", forceConformanceCheck);
            return this;
        }
        /**
         * HTTP session cookie to add to every request.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: advanced
         */
        default AdvancedFhirEndpointConsumerBuilder sessionCookie(
                String sessionCookie) {
            doSetProperty("sessionCookie", sessionCookie);
            return this;
        }
        /**
         * How long to block for individual read/write operations (in ms).
         * 
         * The option is a: <code>java.lang.Integer</code> type.
         * 
         * Default: 10000
         * Group: advanced
         */
        default AdvancedFhirEndpointConsumerBuilder socketTimeout(
                Integer socketTimeout) {
            doSetProperty("socketTimeout", socketTimeout);
            return this;
        }
        /**
         * How long to block for individual read/write operations (in ms).
         * 
         * The option will be converted to a <code>java.lang.Integer</code>
         * type.
         * 
         * Default: 10000
         * Group: advanced
         */
        default AdvancedFhirEndpointConsumerBuilder socketTimeout(
                String socketTimeout) {
            doSetProperty("socketTimeout", socketTimeout);
            return this;
        }
        /**
         * Request that the server modify the response using the _summary param.
         * 
         * The option is a: <code>ca.uhn.fhir.rest.api.SummaryEnum</code> type.
         * 
         * Group: advanced
         */
        default AdvancedFhirEndpointConsumerBuilder summary(SummaryEnum summary) {
            doSetProperty("summary", summary);
            return this;
        }
        /**
         * Request that the server modify the response using the _summary param.
         * 
         * The option will be converted to a
         * <code>ca.uhn.fhir.rest.api.SummaryEnum</code> type.
         * 
         * Group: advanced
         */
        default AdvancedFhirEndpointConsumerBuilder summary(String summary) {
            doSetProperty("summary", summary);
            return this;
        }
        /**
         * Sets whether synchronous processing should be strictly used, or Camel
         * is allowed to use asynchronous processing (if supported).
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Default: false
         * Group: advanced
         */
        default AdvancedFhirEndpointConsumerBuilder synchronous(
                boolean synchronous) {
            doSetProperty("synchronous", synchronous);
            return this;
        }
        /**
         * Sets whether synchronous processing should be strictly used, or Camel
         * is allowed to use asynchronous processing (if supported).
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Default: false
         * Group: advanced
         */
        default AdvancedFhirEndpointConsumerBuilder synchronous(
                String synchronous) {
            doSetProperty("synchronous", synchronous);
            return this;
        }
        /**
         * When should Camel validate the FHIR Server's conformance statement.
         * 
         * The option is a:
         * <code>ca.uhn.fhir.rest.client.api.ServerValidationModeEnum</code>
         * type.
         * 
         * Default: ONCE
         * Group: advanced
         */
        default AdvancedFhirEndpointConsumerBuilder validationMode(
                ServerValidationModeEnum validationMode) {
            doSetProperty("validationMode", validationMode);
            return this;
        }
        /**
         * When should Camel validate the FHIR Server's conformance statement.
         * 
         * The option will be converted to a
         * <code>ca.uhn.fhir.rest.client.api.ServerValidationModeEnum</code>
         * type.
         * 
         * Default: ONCE
         * Group: advanced
         */
        default AdvancedFhirEndpointConsumerBuilder validationMode(
                String validationMode) {
            doSetProperty("validationMode", validationMode);
            return this;
        }
    }

    /**
     * Builder for endpoint producers for the FHIR component.
     */
    public interface FhirEndpointProducerBuilder
            extends
                EndpointProducerBuilder {
        default AdvancedFhirEndpointProducerBuilder advanced() {
            return (AdvancedFhirEndpointProducerBuilder) this;
        }
        /**
         * Encoding to use for all request.
         * 
         * The option is a: <code>ca.uhn.fhir.rest.api.EncodingEnum</code> type.
         * 
         * Group: common
         */
        default FhirEndpointProducerBuilder encoding(EncodingEnum encoding) {
            doSetProperty("encoding", encoding);
            return this;
        }
        /**
         * Encoding to use for all request.
         * 
         * The option will be converted to a
         * <code>ca.uhn.fhir.rest.api.EncodingEnum</code> type.
         * 
         * Group: common
         */
        default FhirEndpointProducerBuilder encoding(String encoding) {
            doSetProperty("encoding", encoding);
            return this;
        }
        /**
         * The FHIR Version to use.
         * 
         * The option is a: <code>ca.uhn.fhir.context.FhirVersionEnum</code>
         * type.
         * 
         * Default: R4
         * Group: common
         */
        default FhirEndpointProducerBuilder fhirVersion(
                FhirVersionEnum fhirVersion) {
            doSetProperty("fhirVersion", fhirVersion);
            return this;
        }
        /**
         * The FHIR Version to use.
         * 
         * The option will be converted to a
         * <code>ca.uhn.fhir.context.FhirVersionEnum</code> type.
         * 
         * Default: R4
         * Group: common
         */
        default FhirEndpointProducerBuilder fhirVersion(String fhirVersion) {
            doSetProperty("fhirVersion", fhirVersion);
            return this;
        }
        /**
         * Sets the name of a parameter to be passed in the exchange In Body.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: common
         */
        default FhirEndpointProducerBuilder inBody(String inBody) {
            doSetProperty("inBody", inBody);
            return this;
        }
        /**
         * Will log every requests and responses.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Default: false
         * Group: common
         */
        default FhirEndpointProducerBuilder log(boolean log) {
            doSetProperty("log", log);
            return this;
        }
        /**
         * Will log every requests and responses.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Default: false
         * Group: common
         */
        default FhirEndpointProducerBuilder log(String log) {
            doSetProperty("log", log);
            return this;
        }
        /**
         * Pretty print all request.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Default: false
         * Group: common
         */
        default FhirEndpointProducerBuilder prettyPrint(boolean prettyPrint) {
            doSetProperty("prettyPrint", prettyPrint);
            return this;
        }
        /**
         * Pretty print all request.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Default: false
         * Group: common
         */
        default FhirEndpointProducerBuilder prettyPrint(String prettyPrint) {
            doSetProperty("prettyPrint", prettyPrint);
            return this;
        }
        /**
         * The FHIR server base URL.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: common
         */
        default FhirEndpointProducerBuilder serverUrl(String serverUrl) {
            doSetProperty("serverUrl", serverUrl);
            return this;
        }
        /**
         * Whether the producer should be started lazy (on the first message).
         * By starting lazy you can use this to allow CamelContext and routes to
         * startup in situations where a producer may otherwise fail during
         * starting and cause the route to fail being started. By deferring this
         * startup to be lazy then the startup failure can be handled during
         * routing messages via Camel's routing error handlers. Beware that when
         * the first message is processed then creating and starting the
         * producer may take a little time and prolong the total processing time
         * of the processing.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Default: false
         * Group: producer
         */
        default FhirEndpointProducerBuilder lazyStartProducer(
                boolean lazyStartProducer) {
            doSetProperty("lazyStartProducer", lazyStartProducer);
            return this;
        }
        /**
         * Whether the producer should be started lazy (on the first message).
         * By starting lazy you can use this to allow CamelContext and routes to
         * startup in situations where a producer may otherwise fail during
         * starting and cause the route to fail being started. By deferring this
         * startup to be lazy then the startup failure can be handled during
         * routing messages via Camel's routing error handlers. Beware that when
         * the first message is processed then creating and starting the
         * producer may take a little time and prolong the total processing time
         * of the processing.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Default: false
         * Group: producer
         */
        default FhirEndpointProducerBuilder lazyStartProducer(
                String lazyStartProducer) {
            doSetProperty("lazyStartProducer", lazyStartProducer);
            return this;
        }
        /**
         * The proxy host.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: proxy
         */
        default FhirEndpointProducerBuilder proxyHost(String proxyHost) {
            doSetProperty("proxyHost", proxyHost);
            return this;
        }
        /**
         * The proxy password.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: proxy
         */
        default FhirEndpointProducerBuilder proxyPassword(String proxyPassword) {
            doSetProperty("proxyPassword", proxyPassword);
            return this;
        }
        /**
         * The proxy port.
         * 
         * The option is a: <code>java.lang.Integer</code> type.
         * 
         * Group: proxy
         */
        default FhirEndpointProducerBuilder proxyPort(Integer proxyPort) {
            doSetProperty("proxyPort", proxyPort);
            return this;
        }
        /**
         * The proxy port.
         * 
         * The option will be converted to a <code>java.lang.Integer</code>
         * type.
         * 
         * Group: proxy
         */
        default FhirEndpointProducerBuilder proxyPort(String proxyPort) {
            doSetProperty("proxyPort", proxyPort);
            return this;
        }
        /**
         * The proxy username.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: proxy
         */
        default FhirEndpointProducerBuilder proxyUser(String proxyUser) {
            doSetProperty("proxyUser", proxyUser);
            return this;
        }
        /**
         * OAuth access token.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: security
         */
        default FhirEndpointProducerBuilder accessToken(String accessToken) {
            doSetProperty("accessToken", accessToken);
            return this;
        }
        /**
         * Username to use for basic authentication.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: security
         */
        default FhirEndpointProducerBuilder password(String password) {
            doSetProperty("password", password);
            return this;
        }
        /**
         * Username to use for basic authentication.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: security
         */
        default FhirEndpointProducerBuilder username(String username) {
            doSetProperty("username", username);
            return this;
        }
    }

    /**
     * Advanced builder for endpoint producers for the FHIR component.
     */
    public interface AdvancedFhirEndpointProducerBuilder
            extends
                EndpointProducerBuilder {
        default FhirEndpointProducerBuilder basic() {
            return (FhirEndpointProducerBuilder) this;
        }
        /**
         * Whether the endpoint should use basic property binding (Camel 2.x) or
         * the newer property binding with additional capabilities.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Default: false
         * Group: advanced
         */
        default AdvancedFhirEndpointProducerBuilder basicPropertyBinding(
                boolean basicPropertyBinding) {
            doSetProperty("basicPropertyBinding", basicPropertyBinding);
            return this;
        }
        /**
         * Whether the endpoint should use basic property binding (Camel 2.x) or
         * the newer property binding with additional capabilities.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Default: false
         * Group: advanced
         */
        default AdvancedFhirEndpointProducerBuilder basicPropertyBinding(
                String basicPropertyBinding) {
            doSetProperty("basicPropertyBinding", basicPropertyBinding);
            return this;
        }
        /**
         * To use the custom client.
         * 
         * The option is a:
         * <code>ca.uhn.fhir.rest.client.api.IGenericClient</code> type.
         * 
         * Group: advanced
         */
        default AdvancedFhirEndpointProducerBuilder client(Object client) {
            doSetProperty("client", client);
            return this;
        }
        /**
         * To use the custom client.
         * 
         * The option will be converted to a
         * <code>ca.uhn.fhir.rest.client.api.IGenericClient</code> type.
         * 
         * Group: advanced
         */
        default AdvancedFhirEndpointProducerBuilder client(String client) {
            doSetProperty("client", client);
            return this;
        }
        /**
         * To use the custom client factory.
         * 
         * The option is a:
         * <code>ca.uhn.fhir.rest.client.api.IRestfulClientFactory</code> type.
         * 
         * Group: advanced
         */
        default AdvancedFhirEndpointProducerBuilder clientFactory(
                Object clientFactory) {
            doSetProperty("clientFactory", clientFactory);
            return this;
        }
        /**
         * To use the custom client factory.
         * 
         * The option will be converted to a
         * <code>ca.uhn.fhir.rest.client.api.IRestfulClientFactory</code> type.
         * 
         * Group: advanced
         */
        default AdvancedFhirEndpointProducerBuilder clientFactory(
                String clientFactory) {
            doSetProperty("clientFactory", clientFactory);
            return this;
        }
        /**
         * Compresses outgoing (POST/PUT) contents to the GZIP format.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Default: false
         * Group: advanced
         */
        default AdvancedFhirEndpointProducerBuilder compress(boolean compress) {
            doSetProperty("compress", compress);
            return this;
        }
        /**
         * Compresses outgoing (POST/PUT) contents to the GZIP format.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Default: false
         * Group: advanced
         */
        default AdvancedFhirEndpointProducerBuilder compress(String compress) {
            doSetProperty("compress", compress);
            return this;
        }
        /**
         * How long to try and establish the initial TCP connection (in ms).
         * 
         * The option is a: <code>java.lang.Integer</code> type.
         * 
         * Default: 10000
         * Group: advanced
         */
        default AdvancedFhirEndpointProducerBuilder connectionTimeout(
                Integer connectionTimeout) {
            doSetProperty("connectionTimeout", connectionTimeout);
            return this;
        }
        /**
         * How long to try and establish the initial TCP connection (in ms).
         * 
         * The option will be converted to a <code>java.lang.Integer</code>
         * type.
         * 
         * Default: 10000
         * Group: advanced
         */
        default AdvancedFhirEndpointProducerBuilder connectionTimeout(
                String connectionTimeout) {
            doSetProperty("connectionTimeout", connectionTimeout);
            return this;
        }
        /**
         * When this option is set, model classes will not be scanned for
         * children until the child list for the given type is actually
         * accessed.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Default: false
         * Group: advanced
         */
        default AdvancedFhirEndpointProducerBuilder deferModelScanning(
                boolean deferModelScanning) {
            doSetProperty("deferModelScanning", deferModelScanning);
            return this;
        }
        /**
         * When this option is set, model classes will not be scanned for
         * children until the child list for the given type is actually
         * accessed.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Default: false
         * Group: advanced
         */
        default AdvancedFhirEndpointProducerBuilder deferModelScanning(
                String deferModelScanning) {
            doSetProperty("deferModelScanning", deferModelScanning);
            return this;
        }
        /**
         * FhirContext is an expensive object to create. To avoid creating
         * multiple instances, it can be set directly.
         * 
         * The option is a: <code>ca.uhn.fhir.context.FhirContext</code> type.
         * 
         * Group: advanced
         */
        default AdvancedFhirEndpointProducerBuilder fhirContext(
                Object fhirContext) {
            doSetProperty("fhirContext", fhirContext);
            return this;
        }
        /**
         * FhirContext is an expensive object to create. To avoid creating
         * multiple instances, it can be set directly.
         * 
         * The option will be converted to a
         * <code>ca.uhn.fhir.context.FhirContext</code> type.
         * 
         * Group: advanced
         */
        default AdvancedFhirEndpointProducerBuilder fhirContext(
                String fhirContext) {
            doSetProperty("fhirContext", fhirContext);
            return this;
        }
        /**
         * Force conformance check.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Default: false
         * Group: advanced
         */
        default AdvancedFhirEndpointProducerBuilder forceConformanceCheck(
                boolean forceConformanceCheck) {
            doSetProperty("forceConformanceCheck", forceConformanceCheck);
            return this;
        }
        /**
         * Force conformance check.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Default: false
         * Group: advanced
         */
        default AdvancedFhirEndpointProducerBuilder forceConformanceCheck(
                String forceConformanceCheck) {
            doSetProperty("forceConformanceCheck", forceConformanceCheck);
            return this;
        }
        /**
         * HTTP session cookie to add to every request.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: advanced
         */
        default AdvancedFhirEndpointProducerBuilder sessionCookie(
                String sessionCookie) {
            doSetProperty("sessionCookie", sessionCookie);
            return this;
        }
        /**
         * How long to block for individual read/write operations (in ms).
         * 
         * The option is a: <code>java.lang.Integer</code> type.
         * 
         * Default: 10000
         * Group: advanced
         */
        default AdvancedFhirEndpointProducerBuilder socketTimeout(
                Integer socketTimeout) {
            doSetProperty("socketTimeout", socketTimeout);
            return this;
        }
        /**
         * How long to block for individual read/write operations (in ms).
         * 
         * The option will be converted to a <code>java.lang.Integer</code>
         * type.
         * 
         * Default: 10000
         * Group: advanced
         */
        default AdvancedFhirEndpointProducerBuilder socketTimeout(
                String socketTimeout) {
            doSetProperty("socketTimeout", socketTimeout);
            return this;
        }
        /**
         * Request that the server modify the response using the _summary param.
         * 
         * The option is a: <code>ca.uhn.fhir.rest.api.SummaryEnum</code> type.
         * 
         * Group: advanced
         */
        default AdvancedFhirEndpointProducerBuilder summary(SummaryEnum summary) {
            doSetProperty("summary", summary);
            return this;
        }
        /**
         * Request that the server modify the response using the _summary param.
         * 
         * The option will be converted to a
         * <code>ca.uhn.fhir.rest.api.SummaryEnum</code> type.
         * 
         * Group: advanced
         */
        default AdvancedFhirEndpointProducerBuilder summary(String summary) {
            doSetProperty("summary", summary);
            return this;
        }
        /**
         * Sets whether synchronous processing should be strictly used, or Camel
         * is allowed to use asynchronous processing (if supported).
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Default: false
         * Group: advanced
         */
        default AdvancedFhirEndpointProducerBuilder synchronous(
                boolean synchronous) {
            doSetProperty("synchronous", synchronous);
            return this;
        }
        /**
         * Sets whether synchronous processing should be strictly used, or Camel
         * is allowed to use asynchronous processing (if supported).
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Default: false
         * Group: advanced
         */
        default AdvancedFhirEndpointProducerBuilder synchronous(
                String synchronous) {
            doSetProperty("synchronous", synchronous);
            return this;
        }
        /**
         * When should Camel validate the FHIR Server's conformance statement.
         * 
         * The option is a:
         * <code>ca.uhn.fhir.rest.client.api.ServerValidationModeEnum</code>
         * type.
         * 
         * Default: ONCE
         * Group: advanced
         */
        default AdvancedFhirEndpointProducerBuilder validationMode(
                ServerValidationModeEnum validationMode) {
            doSetProperty("validationMode", validationMode);
            return this;
        }
        /**
         * When should Camel validate the FHIR Server's conformance statement.
         * 
         * The option will be converted to a
         * <code>ca.uhn.fhir.rest.client.api.ServerValidationModeEnum</code>
         * type.
         * 
         * Default: ONCE
         * Group: advanced
         */
        default AdvancedFhirEndpointProducerBuilder validationMode(
                String validationMode) {
            doSetProperty("validationMode", validationMode);
            return this;
        }
    }

    /**
     * Builder for endpoint for the FHIR component.
     */
    public interface FhirEndpointBuilder
            extends
                FhirEndpointConsumerBuilder,
                FhirEndpointProducerBuilder {
        default AdvancedFhirEndpointBuilder advanced() {
            return (AdvancedFhirEndpointBuilder) this;
        }
        /**
         * Encoding to use for all request.
         * 
         * The option is a: <code>ca.uhn.fhir.rest.api.EncodingEnum</code> type.
         * 
         * Group: common
         */
        default FhirEndpointBuilder encoding(EncodingEnum encoding) {
            doSetProperty("encoding", encoding);
            return this;
        }
        /**
         * Encoding to use for all request.
         * 
         * The option will be converted to a
         * <code>ca.uhn.fhir.rest.api.EncodingEnum</code> type.
         * 
         * Group: common
         */
        default FhirEndpointBuilder encoding(String encoding) {
            doSetProperty("encoding", encoding);
            return this;
        }
        /**
         * The FHIR Version to use.
         * 
         * The option is a: <code>ca.uhn.fhir.context.FhirVersionEnum</code>
         * type.
         * 
         * Default: R4
         * Group: common
         */
        default FhirEndpointBuilder fhirVersion(FhirVersionEnum fhirVersion) {
            doSetProperty("fhirVersion", fhirVersion);
            return this;
        }
        /**
         * The FHIR Version to use.
         * 
         * The option will be converted to a
         * <code>ca.uhn.fhir.context.FhirVersionEnum</code> type.
         * 
         * Default: R4
         * Group: common
         */
        default FhirEndpointBuilder fhirVersion(String fhirVersion) {
            doSetProperty("fhirVersion", fhirVersion);
            return this;
        }
        /**
         * Sets the name of a parameter to be passed in the exchange In Body.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: common
         */
        default FhirEndpointBuilder inBody(String inBody) {
            doSetProperty("inBody", inBody);
            return this;
        }
        /**
         * Will log every requests and responses.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Default: false
         * Group: common
         */
        default FhirEndpointBuilder log(boolean log) {
            doSetProperty("log", log);
            return this;
        }
        /**
         * Will log every requests and responses.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Default: false
         * Group: common
         */
        default FhirEndpointBuilder log(String log) {
            doSetProperty("log", log);
            return this;
        }
        /**
         * Pretty print all request.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Default: false
         * Group: common
         */
        default FhirEndpointBuilder prettyPrint(boolean prettyPrint) {
            doSetProperty("prettyPrint", prettyPrint);
            return this;
        }
        /**
         * Pretty print all request.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Default: false
         * Group: common
         */
        default FhirEndpointBuilder prettyPrint(String prettyPrint) {
            doSetProperty("prettyPrint", prettyPrint);
            return this;
        }
        /**
         * The FHIR server base URL.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: common
         */
        default FhirEndpointBuilder serverUrl(String serverUrl) {
            doSetProperty("serverUrl", serverUrl);
            return this;
        }
        /**
         * The proxy host.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: proxy
         */
        default FhirEndpointBuilder proxyHost(String proxyHost) {
            doSetProperty("proxyHost", proxyHost);
            return this;
        }
        /**
         * The proxy password.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: proxy
         */
        default FhirEndpointBuilder proxyPassword(String proxyPassword) {
            doSetProperty("proxyPassword", proxyPassword);
            return this;
        }
        /**
         * The proxy port.
         * 
         * The option is a: <code>java.lang.Integer</code> type.
         * 
         * Group: proxy
         */
        default FhirEndpointBuilder proxyPort(Integer proxyPort) {
            doSetProperty("proxyPort", proxyPort);
            return this;
        }
        /**
         * The proxy port.
         * 
         * The option will be converted to a <code>java.lang.Integer</code>
         * type.
         * 
         * Group: proxy
         */
        default FhirEndpointBuilder proxyPort(String proxyPort) {
            doSetProperty("proxyPort", proxyPort);
            return this;
        }
        /**
         * The proxy username.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: proxy
         */
        default FhirEndpointBuilder proxyUser(String proxyUser) {
            doSetProperty("proxyUser", proxyUser);
            return this;
        }
        /**
         * OAuth access token.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: security
         */
        default FhirEndpointBuilder accessToken(String accessToken) {
            doSetProperty("accessToken", accessToken);
            return this;
        }
        /**
         * Username to use for basic authentication.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: security
         */
        default FhirEndpointBuilder password(String password) {
            doSetProperty("password", password);
            return this;
        }
        /**
         * Username to use for basic authentication.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: security
         */
        default FhirEndpointBuilder username(String username) {
            doSetProperty("username", username);
            return this;
        }
    }

    /**
     * Advanced builder for endpoint for the FHIR component.
     */
    public interface AdvancedFhirEndpointBuilder
            extends
                AdvancedFhirEndpointConsumerBuilder,
                AdvancedFhirEndpointProducerBuilder {
        default FhirEndpointBuilder basic() {
            return (FhirEndpointBuilder) this;
        }
        /**
         * Whether the endpoint should use basic property binding (Camel 2.x) or
         * the newer property binding with additional capabilities.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Default: false
         * Group: advanced
         */
        default AdvancedFhirEndpointBuilder basicPropertyBinding(
                boolean basicPropertyBinding) {
            doSetProperty("basicPropertyBinding", basicPropertyBinding);
            return this;
        }
        /**
         * Whether the endpoint should use basic property binding (Camel 2.x) or
         * the newer property binding with additional capabilities.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Default: false
         * Group: advanced
         */
        default AdvancedFhirEndpointBuilder basicPropertyBinding(
                String basicPropertyBinding) {
            doSetProperty("basicPropertyBinding", basicPropertyBinding);
            return this;
        }
        /**
         * To use the custom client.
         * 
         * The option is a:
         * <code>ca.uhn.fhir.rest.client.api.IGenericClient</code> type.
         * 
         * Group: advanced
         */
        default AdvancedFhirEndpointBuilder client(Object client) {
            doSetProperty("client", client);
            return this;
        }
        /**
         * To use the custom client.
         * 
         * The option will be converted to a
         * <code>ca.uhn.fhir.rest.client.api.IGenericClient</code> type.
         * 
         * Group: advanced
         */
        default AdvancedFhirEndpointBuilder client(String client) {
            doSetProperty("client", client);
            return this;
        }
        /**
         * To use the custom client factory.
         * 
         * The option is a:
         * <code>ca.uhn.fhir.rest.client.api.IRestfulClientFactory</code> type.
         * 
         * Group: advanced
         */
        default AdvancedFhirEndpointBuilder clientFactory(Object clientFactory) {
            doSetProperty("clientFactory", clientFactory);
            return this;
        }
        /**
         * To use the custom client factory.
         * 
         * The option will be converted to a
         * <code>ca.uhn.fhir.rest.client.api.IRestfulClientFactory</code> type.
         * 
         * Group: advanced
         */
        default AdvancedFhirEndpointBuilder clientFactory(String clientFactory) {
            doSetProperty("clientFactory", clientFactory);
            return this;
        }
        /**
         * Compresses outgoing (POST/PUT) contents to the GZIP format.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Default: false
         * Group: advanced
         */
        default AdvancedFhirEndpointBuilder compress(boolean compress) {
            doSetProperty("compress", compress);
            return this;
        }
        /**
         * Compresses outgoing (POST/PUT) contents to the GZIP format.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Default: false
         * Group: advanced
         */
        default AdvancedFhirEndpointBuilder compress(String compress) {
            doSetProperty("compress", compress);
            return this;
        }
        /**
         * How long to try and establish the initial TCP connection (in ms).
         * 
         * The option is a: <code>java.lang.Integer</code> type.
         * 
         * Default: 10000
         * Group: advanced
         */
        default AdvancedFhirEndpointBuilder connectionTimeout(
                Integer connectionTimeout) {
            doSetProperty("connectionTimeout", connectionTimeout);
            return this;
        }
        /**
         * How long to try and establish the initial TCP connection (in ms).
         * 
         * The option will be converted to a <code>java.lang.Integer</code>
         * type.
         * 
         * Default: 10000
         * Group: advanced
         */
        default AdvancedFhirEndpointBuilder connectionTimeout(
                String connectionTimeout) {
            doSetProperty("connectionTimeout", connectionTimeout);
            return this;
        }
        /**
         * When this option is set, model classes will not be scanned for
         * children until the child list for the given type is actually
         * accessed.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Default: false
         * Group: advanced
         */
        default AdvancedFhirEndpointBuilder deferModelScanning(
                boolean deferModelScanning) {
            doSetProperty("deferModelScanning", deferModelScanning);
            return this;
        }
        /**
         * When this option is set, model classes will not be scanned for
         * children until the child list for the given type is actually
         * accessed.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Default: false
         * Group: advanced
         */
        default AdvancedFhirEndpointBuilder deferModelScanning(
                String deferModelScanning) {
            doSetProperty("deferModelScanning", deferModelScanning);
            return this;
        }
        /**
         * FhirContext is an expensive object to create. To avoid creating
         * multiple instances, it can be set directly.
         * 
         * The option is a: <code>ca.uhn.fhir.context.FhirContext</code> type.
         * 
         * Group: advanced
         */
        default AdvancedFhirEndpointBuilder fhirContext(Object fhirContext) {
            doSetProperty("fhirContext", fhirContext);
            return this;
        }
        /**
         * FhirContext is an expensive object to create. To avoid creating
         * multiple instances, it can be set directly.
         * 
         * The option will be converted to a
         * <code>ca.uhn.fhir.context.FhirContext</code> type.
         * 
         * Group: advanced
         */
        default AdvancedFhirEndpointBuilder fhirContext(String fhirContext) {
            doSetProperty("fhirContext", fhirContext);
            return this;
        }
        /**
         * Force conformance check.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Default: false
         * Group: advanced
         */
        default AdvancedFhirEndpointBuilder forceConformanceCheck(
                boolean forceConformanceCheck) {
            doSetProperty("forceConformanceCheck", forceConformanceCheck);
            return this;
        }
        /**
         * Force conformance check.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Default: false
         * Group: advanced
         */
        default AdvancedFhirEndpointBuilder forceConformanceCheck(
                String forceConformanceCheck) {
            doSetProperty("forceConformanceCheck", forceConformanceCheck);
            return this;
        }
        /**
         * HTTP session cookie to add to every request.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: advanced
         */
        default AdvancedFhirEndpointBuilder sessionCookie(String sessionCookie) {
            doSetProperty("sessionCookie", sessionCookie);
            return this;
        }
        /**
         * How long to block for individual read/write operations (in ms).
         * 
         * The option is a: <code>java.lang.Integer</code> type.
         * 
         * Default: 10000
         * Group: advanced
         */
        default AdvancedFhirEndpointBuilder socketTimeout(Integer socketTimeout) {
            doSetProperty("socketTimeout", socketTimeout);
            return this;
        }
        /**
         * How long to block for individual read/write operations (in ms).
         * 
         * The option will be converted to a <code>java.lang.Integer</code>
         * type.
         * 
         * Default: 10000
         * Group: advanced
         */
        default AdvancedFhirEndpointBuilder socketTimeout(String socketTimeout) {
            doSetProperty("socketTimeout", socketTimeout);
            return this;
        }
        /**
         * Request that the server modify the response using the _summary param.
         * 
         * The option is a: <code>ca.uhn.fhir.rest.api.SummaryEnum</code> type.
         * 
         * Group: advanced
         */
        default AdvancedFhirEndpointBuilder summary(SummaryEnum summary) {
            doSetProperty("summary", summary);
            return this;
        }
        /**
         * Request that the server modify the response using the _summary param.
         * 
         * The option will be converted to a
         * <code>ca.uhn.fhir.rest.api.SummaryEnum</code> type.
         * 
         * Group: advanced
         */
        default AdvancedFhirEndpointBuilder summary(String summary) {
            doSetProperty("summary", summary);
            return this;
        }
        /**
         * Sets whether synchronous processing should be strictly used, or Camel
         * is allowed to use asynchronous processing (if supported).
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Default: false
         * Group: advanced
         */
        default AdvancedFhirEndpointBuilder synchronous(boolean synchronous) {
            doSetProperty("synchronous", synchronous);
            return this;
        }
        /**
         * Sets whether synchronous processing should be strictly used, or Camel
         * is allowed to use asynchronous processing (if supported).
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Default: false
         * Group: advanced
         */
        default AdvancedFhirEndpointBuilder synchronous(String synchronous) {
            doSetProperty("synchronous", synchronous);
            return this;
        }
        /**
         * When should Camel validate the FHIR Server's conformance statement.
         * 
         * The option is a:
         * <code>ca.uhn.fhir.rest.client.api.ServerValidationModeEnum</code>
         * type.
         * 
         * Default: ONCE
         * Group: advanced
         */
        default AdvancedFhirEndpointBuilder validationMode(
                ServerValidationModeEnum validationMode) {
            doSetProperty("validationMode", validationMode);
            return this;
        }
        /**
         * When should Camel validate the FHIR Server's conformance statement.
         * 
         * The option will be converted to a
         * <code>ca.uhn.fhir.rest.client.api.ServerValidationModeEnum</code>
         * type.
         * 
         * Default: ONCE
         * Group: advanced
         */
        default AdvancedFhirEndpointBuilder validationMode(String validationMode) {
            doSetProperty("validationMode", validationMode);
            return this;
        }
    }

    /**
     * Proxy enum for <code>ca.uhn.fhir.rest.api.EncodingEnum</code> enum.
     */
    enum EncodingEnum {
        JSON,
        XML,
        RDF;
    }

    /**
     * Proxy enum for <code>ca.uhn.fhir.context.FhirVersionEnum</code> enum.
     */
    enum FhirVersionEnum {
        DSTU2,
        DSTU2_HL7ORG,
        DSTU2_1,
        DSTU3,
        R4,
        R5;
    }

    /**
     * Proxy enum for <code>ca.uhn.fhir.rest.api.SummaryEnum</code> enum.
     */
    enum SummaryEnum {
        COUNT,
        TEXT,
        DATA,
        TRUE,
        FALSE;
    }

    /**
     * Proxy enum for
     * <code>ca.uhn.fhir.rest.client.api.ServerValidationModeEnum</code> enum.
     */
    enum ServerValidationModeEnum {
        NEVER,
        ONCE;
    }

    public interface FhirBuilders {
        /**
         * FHIR (camel-fhir)
         * Exchange information in the healthcare domain using the FHIR (Fast
         * Healthcare Interoperability Resources) standard.
         * 
         * Category: api
         * Since: 2.23
         * Maven coordinates: org.apache.camel:camel-fhir
         * 
         * Syntax: <code>fhir:apiName/methodName</code>
         * 
         * Path parameter: apiName (required)
         * What kind of operation to perform
         * There are 13 enums and the value can be one of: CAPABILITIES, CREATE,
         * DELETE, HISTORY, LOAD_PAGE, META, OPERATION, PATCH, READ, SEARCH,
         * TRANSACTION, UPDATE, VALIDATE
         * 
         * Path parameter: methodName (required)
         * What sub operation to use for the selected operation
         * 
         * @param path apiName/methodName
         */
        default FhirEndpointBuilder fhir(String path) {
            return FhirEndpointBuilderFactory.endpointBuilder("fhir", path);
        }
        /**
         * FHIR (camel-fhir)
         * Exchange information in the healthcare domain using the FHIR (Fast
         * Healthcare Interoperability Resources) standard.
         * 
         * Category: api
         * Since: 2.23
         * Maven coordinates: org.apache.camel:camel-fhir
         * 
         * Syntax: <code>fhir:apiName/methodName</code>
         * 
         * Path parameter: apiName (required)
         * What kind of operation to perform
         * There are 13 enums and the value can be one of: CAPABILITIES, CREATE,
         * DELETE, HISTORY, LOAD_PAGE, META, OPERATION, PATCH, READ, SEARCH,
         * TRANSACTION, UPDATE, VALIDATE
         * 
         * Path parameter: methodName (required)
         * What sub operation to use for the selected operation
         * 
         * @param componentName to use a custom component name for the endpoint
         * instead of the default name
         * @param path apiName/methodName
         */
        default FhirEndpointBuilder fhir(String componentName, String path) {
            return FhirEndpointBuilderFactory.endpointBuilder(componentName, path);
        }
    }
    static FhirEndpointBuilder endpointBuilder(String componentName, String path) {
        class FhirEndpointBuilderImpl extends AbstractEndpointBuilder implements FhirEndpointBuilder, AdvancedFhirEndpointBuilder {
            public FhirEndpointBuilderImpl(String path) {
                super(componentName, path);
            }
        }
        return new FhirEndpointBuilderImpl(path);
    }
}