/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.apache.camel.impl;

import org.apache.camel.ContextTestSupport;
import org.apache.camel.ExtendedCamelContext;
import org.apache.camel.spi.GeneratedPropertyConfigurer;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class ConfigurerResolverTest extends ContextTestSupport {

    @Test
    public void testConfigurerResolver() throws Exception {
        GeneratedPropertyConfigurer resolver = context.adapt(ExtendedCamelContext.class).getConfigurerResolver()
                .resolvePropertyConfigurer(context.getClass().getName(), context);
        Assertions.assertNotNull(resolver);

        resolver.configure(context, context, "name", "foobar", true);
        Assertions.assertEquals("foobar", context.getName());
    }
}
